/*
 * Copyright (C) 2008 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifdef _WIN32_WINNT
#undef _WIN32_WINNT
#endif

#ifndef WINVER
#define WINVER 0x0500
#endif

// If we don't define these, they get defined in windef.h. 
// We want to use std::min and std::max.
#ifndef max
#define max max
#endif
#ifndef min
#define min min
#endif

#ifndef _WINSOCKAPI_
#define _WINSOCKAPI_ // Prevent inclusion of winsock.h in windows.h
#endif

#include "config.h"
#if defined(_WIN32)
#include "CECom.h"

#include "wtf/ASCIICType.h"
#include "wtf/AlwaysInline.h"
#include "wtf/Assertions.h"
#include "wtf/ByteArray.h"
#include "wtf/CurrentTime.h"
#include "wtf/Deque.h"
#include "wtf/DisallowCType.h"
#include "wtf/FastMalloc.h"
#include "wtf/Forward.h"
#include "wtf/GetPtr.h"
#include "wtf/HashCountedSet.h"
#include "wtf/HashFunctions.h"
#include "wtf/HashMap.h"
#include "wtf/HashSet.h"
#include "wtf/HashTable.h"
#include "wtf/HashTraits.h"
#include "wtf/ListHashSet.h"
#include "wtf/ListRefPtr.h"
#include "wtf/Locker.h"
#include "wtf/MainThread.h"
#include "wtf/MathExtras.h"
#include "wtf/MessageQueue.h"
#include "wtf/Noncopyable.h"
#include "wtf/NotFound.h"
#include "wtf/OwnArrayPtr.h"
#include "wtf/OwnPtr.h"
#include "wtf/PassRefPtr.h"
#include "wtf/Platform.h"
#include "wtf/PtrAndFlags.h"
#include "wtf/RandomNumber.h"
#include "wtf/RefCounted.h"
#include "wtf/RefCountedLeakCounter.h"
#include "wtf/RefPtr.h"
#include "wtf/StdLibExtras.h"
#include "wtf/StringExtras.h"
#include "wtf/UnusedParam.h"
#include "wtf/Vector.h"
#include "wtf/VectorTraits.h"
#include "wtf/dtoa.h"

#endif //#if defined(_WIN32)
