///////////////////////////////////////////////////////////////////////////////
// Copyright     2009, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef JSSessionStorage_h
#define JSSessionStorage_h

#include "runtime/JSObject.h"
#include "ICEHtmlBrowserManager.h"
#include "CEJSPrivilegeSSObject.h"
#include "JSDOMWindow.h"
#include "../CEPrivilegeObjectBase.h"

///////////////////////////////////////////////////////////////////////////////
// CEJSSessionStorage
// this is for window.SessionStorage object
///////////////////////////////////////////////////////////////////////////////
class JSSessionStoragePrototype;
class CEJSPrivilegeSSObjectDeclaration;
class JSSessionStorage : public JSC::JSObject, public PrivilegeObjectBase
{
public:
	explicit JSSessionStorage(WebCore::JSDOMWindow* window, PassRefPtr<JSC::Structure> structure);
	virtual ~JSSessionStorage();

	static JSC::JSObject* createPrototype(JSC::ExecState* exec);

	virtual bool getOwnPropertySlot(JSC::ExecState* exec, const JSC::Identifier& propertyName, JSC::PropertySlot& slot);
	bool canGetItemsForName(JSC::ExecState*, const JSC::Identifier&);
	virtual void put(JSC::ExecState* exec, const JSC::Identifier& propertyName, JSC::JSValue value, JSC::PutPropertySlot& slot);

	virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
	static const JSC::ClassInfo s_info;

	static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
	{
		return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
	}

	//virtual bool deleteProperty(JSC::ExecState*, const JSC::Identifier&);
	//virtual void getPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&);
	//bool customGetPropertyNames(JSC::ExecState*, JSC::PropertyNameArray&);

	//static JSC::JSValue nameGetter(JSC::ExecState*, const JSC::Identifier&, const JSC::PropertySlot&);

	WebCore::JSDOMWindow* getDOMWindow()
	{
		return(_member ? _member->_window : 0);
	}

	CEHResult getCredential(CEComICEHtmlCredentialRef& credential);

	/////////////////////////////////////////////
	// CEJSPrivilegeSSObjectDeclaration support
	/////////////////////////////////////////////
public:
	CEHResult getJSPrivilegeSSObjectDeclaration(JSC::ExecState* exec, CEJSPrivilegeSSObjectDeclaration** pDeclarationOut);

private:
	// the heap couldn't allocate big class.
	struct _member_def {
		WebCore::JSDOMWindow* _window;
		CEJSPrivilegeSSObjectDeclaration* _privilegeSSObjectDeclaration;
		CEJSPrivilegeSSObjectCollection* _privilegeSSOblectCollection;
		CEComICEHtmlCredentialRef _credential;
	};
	_member_def* _member;
};

//
// class JSSessionStoragePrototype
//
class JSSessionStoragePrototype : public JSC::JSObject {
public:
	//static JSC::JSObject* self(JSC::ExecState*);
	virtual const JSC::ClassInfo* classInfo() const { return &s_info; }
	static const JSC::ClassInfo s_info;
	virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
	static PassRefPtr<JSC::Structure> createStructure(JSC::JSValue prototype)
	{
		return JSC::Structure::create(prototype, JSC::TypeInfo(JSC::ObjectType));
	}
	JSSessionStoragePrototype(PassRefPtr<JSC::Structure> structure) : JSC::JSObject(structure) { }
};


/////////////////////////////////
// CEJSSessionStorageAppCallback
/////////////////////////////////
class CEJSSessionStorageAppCallback {

private:
	CEJSSessionStorageAppCallback();

private:
	// for save ExecState during callback application side.
	class _saveExecState
	{
		public:
		_saveExecState(JSC::ExecState* exec)
		{
			// Do not re enter.
			CEASSERT(CEJSSessionStorageAppCallback::_exec == 0);
			CEJSSessionStorageAppCallback::_exec = exec;
		}
		~_saveExecState()
		{
			CEASSERT(CEJSSessionStorageAppCallback::_exec != 0);
			CEJSSessionStorageAppCallback::_exec = 0;
		}
	};

public:
	static JSC::ExecState* getExecState()
	{
		CEASSERT(_exec && "why did not set exec?");
		return(_exec);
	}

public:
	// Bug15969 tell application some query about SessionStorage object.
	static CEHResult declarePrivilegeSSObj(JSC::ExecState* exec, ICEJSPrivilegeSSObjectParent* iParent, ICEJSPrivilegeSSObjectDeclarer* iDeclarer);
	static CEHResult authorizeOfPrivilegeSSObj(JSC::ExecState* exec, INT32 classId, ICEHtmlCredential* iCredential, CEJSAuthStatus* statusOut, INT_PTR* objectIdOut);
	static CEHResult finalizeObjectIdOfPrivilegeSSObj(INT_PTR objectId);
	static CEHResult declarePropertyOfPrivilegeSSObj(JSC::ExecState* exec, INT_PTR objectId, ICEJSSSPropertyParent* iParent, ICEJSSSPropertyDeclarer* iDeclarer);
	static CEHResult isDirtyPropertyOfPrivilegeSSObj(JSC::ExecState* exec, INT_PTR objectId, INT32 propertyId, CEJSIsDirtyStatus* statusOut);
	static CEHResult getPropertyOfPrivilegeSSObj(JSC::ExecState* exec, INT_PTR objectId, INT32 propertyId, ICEJSExtVariantFactory* iFactory, ICEJSExtVariant** iValueOut);
	static CEHResult setPropertyOfPrivilegeSSObj(JSC::ExecState* exec, INT_PTR objectId, INT32 propertyId, ICEJSExtVariant* iValue, ICEJSExtVariantFactory* iFactory, ICEJSExtVariant** iValueOut);
	static CEHResult invokeMethodOfPrivilegeSSObj(JSC::ExecState* exec, INT_PTR objectId, INT32 methodId, ICEJSExtVariant** iArgValues, UINT32 argCount, ICEJSExtVariantFactory* iFactory, ICEJSExtVariant** iValueOut);

private:
	static CEHResult _getListener(CEComICEJSPrivilegeSSObjectListenerRef& listener);
	static JSC::ExecState* _exec;
};


#endif


