///////////////////////////////////////////////////////////////////////////////
// Copyright     2009, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef CEJSPrivilegeSSObjectDeclaration_h
#define CEJSPrivilegeSSObjectDeclaration_h

#include "ceuhashtableT.h"
#include "runtime/JSValue.h"
#include "runtime/JSObject.h"

///////////////////////////////////////////////////////////////////////////////
// CEJSPrivilegeSSObjectDeclaration
///////////////////////////////////////////////////////////////////////////////
class JSSessionStorage;
class CEJSPrivilegeSSObjectDeclaration
{
public:
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	/////////////////////////////////
	// factory
	/////////////////////////////////
	static CEHResult create(JSC::ExecState* exec, JSSessionStorage* SessionStorage, CEJSPrivilegeSSObjectDeclaration*& rDeclarationOut);

	/////////////////////////////////
	// constructor - destructor
	/////////////////////////////////
public:
	CEJSPrivilegeSSObjectDeclaration() : _isShutdownCompleted(true)
	{
		_SessionStorage = 0;
	}
	virtual ~CEJSPrivilegeSSObjectDeclaration();

	// owner is only JSSessionStorage
	void AddRef(){}
	void Release(){}

	/////////////////////////////////
	// initialize / shutdown
	/////////////////////////////////
private:
	CEHResult _init(JSC::ExecState* exec, JSSessionStorage* SessionStorage);
public:
	CEHResult shutdown();

	////////////////////////////////
	// operations 
	////////////////////////////////
public:
	CEHResult isDeclared(const JSC::Identifier& iPropName, INT32* classIdOut, UINT32* attrOut);

private:
	class DeclaredObjectKey
	{
	public:
		////////////////////////////////////////////////////////////////
		// operator new, delete, new[] and delete[].
		////////////////////////////////////////////////////////////////
		CEALLOCATORS;

		DeclaredObjectKey(const JSC::Identifier& iPropName) : _rPropName(iPropName) { }
		~DeclaredObjectKey() {} // no inherit

		UINT32 getHash() const { return _rPropName.ustring().rep()->hash(); }
		const JSC::Identifier& getPropName() const { return _rPropName; }

	private:
		const JSC::Identifier _rPropName;
	};

	class DeclaredObjectEntry
	{
	public:
		////////////////////////////////////////////////////////////////
		// operator new, delete, new[] and delete[].
		////////////////////////////////////////////////////////////////
		CEALLOCATORS;

		DeclaredObjectEntry(const JSC::Identifier& iPropName, INT32 classId, UINT32 attr)
			: _key(iPropName), _classId(classId), _attr(attr) {}
		~DeclaredObjectEntry() {} // no inherit

		INT32 getClassId() const { return _classId; }
		UINT32 getAttr() const { return _attr; }

		// hash implementation
		const DeclaredObjectKey& getKey() const { return _key; }
		bool isEqual(const DeclaredObjectKey& key) const { return _key.getPropName() == key.getPropName(); }

	private:
		DeclaredObjectKey _key;
		INT32 _classId;
		UINT32 _attr;
	};

private:
	CEUHashtableT<DeclaredObjectEntry, DeclaredObjectKey> _declaredObjectHash;
	bool _isShutdownCompleted : 1;

	////////////////////////////////////////////
	//  ICEJSPrivilegeSSObjectDeclarer methods
	////////////////////////////////////////////
public:
	CEHResult declareObject(INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr);
	CEHResult declareChildObject(INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, const char* childObject, UINT32 attr);

protected:
	// ICEJSPrivilegeSSObjectDeclarer vptr
	const void* _ssObjectDeclarerVptr;
	// ICEJSPrivilegeSSObjectParent vptr
	const void* _ssObjectParentVptr;

private:
	JSSessionStorage* _SessionStorage;
};

#endif
