///////////////////////////////////////////////////////////////////////////////
// Copyright     2009, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"

#include "JSDOMWindow.h"

#include "UString.h"
#include "PrototypeFunction.h"
#include "runtime/JSValue.h"
#include "runtime/FunctionConstructor.h"
#include "../JSUtilityFunc.h"
#include "CEJSPrivilegeSSObjectDeclaration.h"
#include "CEJSPrivilegeSSObjectDeclarationGlue.h"
#include "ICEHtmlBrowserManager.h"
#include "CEJSSessionStorage.h"

//////////////////////////////////////////////////////////////////////////////
// CEJSPrivilegeSSObjectDeclaration
//////////////////////////////////////////////////////////////////////////////

CEHResult CEJSPrivilegeSSObjectDeclaration::create(
	JSC::ExecState* exec, JSSessionStorage* SessionStorage, CEJSPrivilegeSSObjectDeclaration*& rDeclarationOut)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	rDeclarationOut = new CEJSPrivilegeSSObjectDeclarationGlue();
	if (rDeclarationOut)
	{
		hr = rDeclarationOut->_init(exec, SessionStorage);
		if (CEFailed(hr))
		{
			delete rDeclarationOut;
			rDeclarationOut = 0;
		}
	}
	else
	{
		hr = CE_SILK_ERR_MEMERR;
	}
	return hr;
}

CEJSPrivilegeSSObjectDeclaration::~CEJSPrivilegeSSObjectDeclaration()
{
    if (_isShutdownCompleted == false)
    {
        shutdown();
    }
}

CEHResult CEJSPrivilegeSSObjectDeclaration::_init(JSC::ExecState* exec, JSSessionStorage* SessionStorage)
{
	CEHResult hr = _declaredObjectHash.init(CEComGetAllocatorRec(), 8);
	if (CESucceeded(hr))
	{
		_isShutdownCompleted = false;
		_SessionStorage = SessionStorage;
		hr = CEJSSessionStorageAppCallback::declarePrivilegeSSObj(exec, CEJSPrivilegeSSObjectDeclarationGlue::toICEJSPrivilegeSSObjectParent(this), CEJSPrivilegeSSObjectDeclarationGlue::toICEJSPrivilegeSSObjectDeclarer(this));
	}
	return hr;
}

CEHResult CEJSPrivilegeSSObjectDeclaration::shutdown()
{
	CEASSERT(_isShutdownCompleted == false);
	CEHResult hr = CE_S_OK;
	CEUHashtableT<DeclaredObjectEntry, DeclaredObjectKey>::Iterator iter(_declaredObjectHash);
	DeclaredObjectEntry* pEntry;
	while ((pEntry = iter.nextElement()))
	{
		delete pEntry;
	}
	_declaredObjectHash.shutdown();
	_isShutdownCompleted = true;
	return hr;
}

////////////////////////////////
// operations 
////////////////////////////////
CEHResult CEJSPrivilegeSSObjectDeclaration::isDeclared(const JSC::Identifier& iPropName, INT32* classIdOut, UINT32* attrOut)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	DeclaredObjectKey key(iPropName);
	DeclaredObjectEntry* pEntry = NULL;
	if (_declaredObjectHash.find(key, pEntry))
	{
		hr = CE_S_OK;
		*classIdOut = pEntry->getClassId();
		*attrOut = pEntry->getAttr();
	}
    return hr;
}

////////////////////////////////////////////
//  ICEJSPrivilegeSSObjectDeclarer methods
////////////////////////////////////////////
CEHResult CEJSPrivilegeSSObjectDeclaration::declareObject(
	INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, UINT32 attr)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if (pObjectName && numOfChars16 > 0 && _SessionStorage)
	{
		JSC::ExecState* exec = _SessionStorage->getDOMWindow()->globalExec();

		JSC::Identifier symbol(exec, reinterpret_cast<const UChar*>(pObjectName), numOfChars16);
		if( !symbol.isEmpty() )
		{
			DeclaredObjectKey key(symbol);
			DeclaredObjectEntry* pEntry = NULL;
			if (!_declaredObjectHash.find(key, pEntry))
			{
				pEntry = new DeclaredObjectEntry(symbol, classId, attr);
				if (pEntry)
				{
					hr = _declaredObjectHash.insert(pEntry);
				}
				else
				{
					hr = CE_SILK_ERR_MEMERR;
				}
			}
			else
			{
				hr = CE_SILK_ERR_OPERATION_FAILED;
			}
		}
	}
	return hr;
}

////////////////////////////////////////////
//  ICEJSPrivilegeSSObjectParent methods
////////////////////////////////////////////
CEHResult CEJSPrivilegeSSObjectDeclaration::declareChildObject(
	INT32 classId, const UTF16CHAR* pObjectName, UINT32 numOfChars16, const char* childObject, UINT32 attr)
{
	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
	if (childObject && _SessionStorage)
	{
		JSC::ExecState* exec = _SessionStorage->getDOMWindow()->globalExec();

		JSC::Identifier symbol(exec, reinterpret_cast<const UChar*>(pObjectName), numOfChars16);
		if( !symbol.isEmpty() )
		{
			DeclaredObjectKey key(symbol);
			DeclaredObjectEntry* pEntry = NULL;
			if (!_declaredObjectHash.find(key, pEntry))
			{
				pEntry = new DeclaredObjectEntry(symbol, classId, attr);
				if (pEntry)
				{
					hr = _declaredObjectHash.insert(pEntry);
				}
				else
				{
					hr = CE_SILK_ERR_MEMERR;
				}
			}
			else
			{
				hr = CE_SILK_ERR_OPERATION_FAILED;
			}
		}
		if (CESucceeded(hr))
		{
			if( _SessionStorage )
			{
				_SessionStorage->putDirect(JSC::Identifier(exec, childObject), JSC::jsUndefined(), JSC::ReadOnly | JSC::DontDelete | JSC::Getter );
			}
		}
	}
	return hr;
}
