///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "WebKitSilkPrefix.h"

#include "JSDOMWindow.h"
#include <runtime/JSLock.h>
#include "UString.h"
#include "PrototypeFunction.h"
#include "runtime/JSValue.h"
#include "runtime/FunctionConstructor.h"
#include "JSUtilityFunc.h"


//
// utilities
//
void addStaticProperty(
	WebCore::JSDOMWindow* window, const JSC::Identifier& name, JSC::JSValue value)
{
	if ( window && !name.isEmpty() )
	{
		// Add the binding name to the window's table of child objects.
		window->putDirect(name, value, JSC::ReadOnly | JSC::DontDelete);
	}
}

void addNativeFunction(
	WebCore::JSDOMWindow* window, const JSC::Identifier& name, JSC::NativeFunction nativeFunc)
{
	if( window && !name.isEmpty() )
	{
		JSC::ExecState* exec = window->globalExec();
		JSC::PrototypeFunction* propFunc = new (exec) JSC::PrototypeFunction(exec, 0, name, nativeFunc);
		window->putDirectFunction(exec, propFunc, JSC::DontEnum | JSC::ReadOnly | JSC::DontDelete);
	}
}

void addNativeHandlingProperty(
	WebCore::JSDOMWindow* window, const JSC::Identifier& name, JSC::NativeFunction getter, JSC::NativeFunction setter)
{
	if( window && !name.isEmpty() )
	{
		JSC::ExecState* exec = window->globalExec();
		if( getter )
		{
			JSC::PrototypeFunction* jsFunc = new (exec) JSC::PrototypeFunction(exec, 0/*argnum*/, name, getter);
			if( jsFunc )
			{
				window->defineGetter(exec, name, jsFunc);
			}
		}
		if( setter )
		{
			JSC::PrototypeFunction* jsFunc = new (exec) JSC::PrototypeFunction(exec, 0/*argnum*/, name, setter);
			if( jsFunc )
			{
				window->defineSetter(exec, name, jsFunc);
			}
		}
	}
}


void addNewFunction(
	WebCore::JSDOMWindow* window, const JSC::Identifier& name, const JSC::UString& source)
{
	JSC::ExecState* exec = window->globalExec();

	// create a new function
    JSC::MarkedArgumentBuffer buf;
	buf.append(JSC::jsString(exec, source));
	JSC::ArgList args(buf);
	JSC::JSObject* newFunc = JSC::constructFunction(exec, args);

	// put object
	if( newFunc )
	{
		window->putDirect(name, newFunc, JSC::DontEnum | JSC::ReadOnly | JSC::DontDelete);
	}
	else
	{
		ASSERT(0);
	}
}

