/*
 * Copyright (C) 2006, 2007 Apple Inc.  All rights reserved.
 * Copyright     2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#include "config.h"


#include "EditorClientSilk.h"

#include "CEWebKitFrameWindowImpl.h"
#include "Page.h"
#include "FocusController.h"
#include "Frame.h"
#include "Editor.h"
#include "KeyboardEvent.h"

EditorClientSilk::EditorClientSilk(CEWebKitFrameWindowImpl* frameWindow) :
	WebCore::EditorClient(), _frameWindow(frameWindow)
{
}

void EditorClientSilk::pageDestroyed()
{
	delete this;
}


bool EditorClientSilk::isContinuousSpellCheckingEnabled()
{
	return true;
}

void EditorClientSilk::toggleGrammarChecking()
{
}

bool EditorClientSilk::isGrammarCheckingEnabled()
{
	return true;
}

void EditorClientSilk::toggleContinuousSpellChecking()
{
}

int EditorClientSilk::spellCheckerDocumentTag()
{
	return 0;//?
}


bool EditorClientSilk::isEditable()
{
	return false;
}


bool EditorClientSilk::shouldBeginEditing(WebCore::Range* range)
{
	return true;
}

bool EditorClientSilk::shouldEndEditing(WebCore::Range* range)
{
	return true;
}

bool EditorClientSilk::shouldInsertText(const WebCore::String& str, WebCore::Range* range, WebCore::EditorInsertAction insertAction)
{
	return true;
}


void EditorClientSilk::didBeginEditing()
{
}

void EditorClientSilk::didEndEditing()
{
}

void EditorClientSilk::didWriteSelectionToPasteboard()
{
}

void EditorClientSilk::didSetSelectionTypesForPasteboard()
{
}


void EditorClientSilk::respondToChangedContents()
{
}

void EditorClientSilk::respondToChangedSelection()
{
}


bool EditorClientSilk::shouldShowDeleteInterface(WebCore::HTMLElement* element)
{
	return false;
}

bool EditorClientSilk::shouldDeleteRange(WebCore::Range* range)
{
	return true;
}


bool EditorClientSilk::shouldInsertNode(WebCore::Node* node, WebCore::Range* replacingRange, WebCore::EditorInsertAction insertAction)
{
	return true;
}

bool EditorClientSilk::shouldApplyStyle(WebCore::CSSStyleDeclaration* styleDecl, WebCore::Range* range)
{
	return true;
}

bool EditorClientSilk::shouldMoveRangeAfterDelete(WebCore::Range* range1, WebCore::Range* range2)
{
	return true;
}

bool EditorClientSilk::shouldChangeTypingStyle(WebCore::CSSStyleDeclaration* currentStyle, WebCore::CSSStyleDeclaration* toProposedStyle)
{
	return true;
}

bool EditorClientSilk::smartInsertDeleteEnabled()
{
	return true;
}


void EditorClientSilk::registerCommandForUndo(PassRefPtr<WebCore::EditCommand> command)
{
}

void EditorClientSilk::registerCommandForRedo(PassRefPtr<WebCore::EditCommand> command)
{
}

void EditorClientSilk::clearUndoRedoOperations()
{
}


bool EditorClientSilk::canUndo() const
{
	return false;
}

bool EditorClientSilk::canRedo() const
{
	return false;
}


void EditorClientSilk::undo()
{
}

void EditorClientSilk::redo()
{
}
    

bool EditorClientSilk::shouldChangeSelectedRange(WebCore::Range* fromRange, WebCore::Range* toRange, WebCore::EAffinity affinity, bool stillSelecting)
{
	return true;
}

void EditorClientSilk::textFieldDidBeginEditing(WebCore::Element* element)
{
}

void EditorClientSilk::textFieldDidEndEditing(WebCore::Element* element)
{
}

void EditorClientSilk::textDidChangeInTextField(WebCore::Element* element)
{
}

bool EditorClientSilk::doTextFieldCommandFromEvent(WebCore::Element* element, WebCore::KeyboardEvent* keyEvent)
{
	return _frameWindow->handleEditingKeyboardEvent(keyEvent);
}

void EditorClientSilk::textWillBeDeletedInTextField(WebCore::Element* input)
{
}

void EditorClientSilk::textDidChangeInTextArea(WebCore::Element* element)
{
}


void EditorClientSilk::handleKeyboardEvent(WebCore::KeyboardEvent* keyEvent)
{
	if (_frameWindow)
	{
		if (_frameWindow->handleEditingKeyboardEvent(keyEvent))
		{
			keyEvent->setDefaultHandled();
		}
	}
}

void EditorClientSilk::handleInputMethodKeydown(WebCore::KeyboardEvent* keyEvent)
{
}


void EditorClientSilk::ignoreWordInSpellDocument(const WebCore::String& str)
{
}

void EditorClientSilk::learnWord(const WebCore::String& str)
{
}

WebCore::String EditorClientSilk::getAutoCorrectSuggestionForMisspelledWord(const WebCore::String& inputWord)
{
    return WebCore::String();
}

void EditorClientSilk::checkSpellingOfString(const UChar* uchars, int length, int* misspellingLocation, int* misspellingLength)
{
}

void EditorClientSilk::checkGrammarOfString(const UChar* uchars, int length, Vector<WebCore::GrammarDetail>& details, int* badGrammarLocation, int* badGrammarLength)
{
}

void EditorClientSilk::updateSpellingUIWithGrammarString(const WebCore::String& str, const WebCore::GrammarDetail& detail)
{
}

void EditorClientSilk::updateSpellingUIWithMisspelledWord(const WebCore::String& str)
{
}

void EditorClientSilk::showSpellingUI(bool show)
{
}

bool EditorClientSilk::spellingUIIsShowing()
{
	return true;
}

void EditorClientSilk::getGuessesForWord(const WebCore::String& str, Vector<WebCore::String>& guesses)
{
}


void EditorClientSilk::setInputMethodState(bool state)
{
}
