///////////////////////////////////////////////////////////////////////////////
// Copyright     2011, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef __CEHtmlCredentialBase_H__
#define __CEHtmlCredentialBase_H__

#include "CESysDefs.h"
#include "ICEHtmlCredential.h"
#include "PlatformString.h"
#include "CEComAtomicSupport.h"
#include "FrameLoaderClientSilk.h"
#include "CEPrivilegeObjectBase.h"

class PrivilegeObjectBase;
class CEWebKitDocumentLoader;
class CEHtmlCredentialBase
{
public:
	////////////////////////////////////////////////////////////////
	// operator new, delete, new[] and delete[].
	////////////////////////////////////////////////////////////////
	CEALLOCATORS;

	////////////////////////////////
	//  constructor / destructor
	////////////////////////////////
private:
	CEHtmlCredentialBase();

public:
	CEHtmlCredentialBase(PrivilegeObjectBase* owner) :
		 _owner(owner),_isShutdownCompleted(false)
	{
		CEASSERT(_owner);
		_refCount = 0;
	}
	virtual ~CEHtmlCredentialBase()
	{
		if (!_isShutdownCompleted) shutdown();
		CEASSERT(_refCount == 0);
	}

public:
	void AddRef()
	{
		CEComAtomicIncrement(_refCount);
	}

	void Release()
	{
		CEATOMIC refCount = CEComAtomicDecrement(_refCount);
		if (refCount == 0)
		{
			delete this;
		}
	}
private:
	CEATOMIC _refCount;

	/////////////////////////////////
	// initialize / shutdown
	/////////////////////////////////
	CEHResult shutdown() { _isShutdownCompleted = true; return CE_S_OK; }

	CEWebKitDocumentLoader* _getDocumentLoader();
	FrameLoaderClientSilk* _getFrameLoaderClient();


	////////////////////////////////
	//  ICEJSVariant methods
	////////////////////////////////
public:
	CEHResult getSSLMode(CEHtmlSSLMode* modeOut);
	CEHResult getSSLAlert(UINT32* alertOut);
	CEHResult getDomain(const UTF16CHAR **const pCharArray16Out, UINT32 *const numOfChars16Out);
	CEHResult getCertificate(const void** cert);
	CEHResult saveCurrentCertificate();

	////////////////////////////////
	//  data members
	////////////////////////////////
private:
	PrivilegeObjectBase* _owner;
	WebCore::String _hostname;
	bool _isShutdownCompleted : 1;
};

#endif // __CEHtmlCredentialBase_H__
