///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef _CEWebKitWindow_h_
#define _CEWebKitWindow_h_


#include "config.h"
#include "Page.h"
#include "HTMLFrameOwnerElement.h"

#include "CEUITypes.h"

#include "CESysEvent.h"

#include "CEWebKitFrameViewImpl.h"
struct ICEVGContext;
class CEWebKitWindowPrivate;
struct ICEUString;

class CEWebKitWindowImpl
{
public:
	CEWebKitWindowImpl();

	CEHResult init(WebCore::Page* page, WebCore::HTMLFrameOwnerElement* ownerElement);
	CEHResult shutdown();

	CEHResult load(ICEUString* iUrl, ICEUString* iReferer);
	CEHResult paint(ICEVGContext* iVGC, const CERect* dirtyRect);
	CEHResult mouse(eCEMouseEventType type, CEPointBase& pt, eCEMouseButton button, UINT32 modifiers, bool& consumedOut);
	CEHResult keyboard(CEKeyboardEventParam* ev, bool& consumedOut);
	CEHResult focus(bool focused);
	CEHResult scroll(INT32 x, INT32 y, INT32 dx, INT32 dy, UINT32 modifiers, bool& consumedOut);
	CEHResult back();
	CEHResult forward();
	CEHResult reload(bool skipCache);
	CEHResult shrinkHistory(UINT32 minimumSize);
	CEHResult setCustomTextEncodingName(ICEUString* iTitle);
	CEHResult stop();
	CEHResult getContentsSize(INT32* widthOut, INT32* heightOut);
	CEHResult confirmPlugin(bool result, bool keepResult, void *const cData);

	CEWebKitWindowPrivate* getPrivate() { return _private; }
	CEWebKitFrameViewImpl* getView();
private:
	CEWebKitWindowPrivate* _private;

public:
	CEHResult networkErrorEventWait(bool& result, ICEUString** errorPageStr);
	CEHResult networkErrorEventPost(bool result, ICEUString* errorPageStr);

	CESysHandle _networkErrorEvent;
private:
	bool _result;
	CEComICEUStringRef _errorPageStr;
};

class CEWebKitWindowPrivate
{
public:
	CEWebKitWindowPrivate(CEWebKitWindowImpl* silkPeer);

	CEHResult init(WebCore::Page* page, WebCore::HTMLFrameOwnerElement* ownerElement);
	CEHResult shutdown();
	CEHResult load(WebCore::KURL& url, WebCore::String* referer);
	CEHResult paint(WebCore::GraphicsContext& gc, WebCore::IntRect& dirtyRect);
	CEHResult mouse(WebCore::PlatformMouseEvent& mouseEvent, bool& acceptOut);
	CEHResult keyboard(WebCore::PlatformKeyboardEvent& keyEvent, bool& acceptOut);
	CEHResult focus(bool focused);
	CEHResult scroll(WebCore::PlatformWheelEvent& wheelEvent, bool& acceptOut);
	CEHResult back();
	CEHResult forward();
	CEHResult reload(bool skipCache);
	CEHResult shrinkHistory(UINT32 minimumSize);
	CEHResult setCustomTextEncodingName(ICEUString* iTitle);
	CEHResult stop();
	CEHResult confirmPlugin(bool result, bool keepResult, void *const cData);

	WebCore::Frame* getFrame() { return _frame; }
	WebCore::Frame* getFocusedFrame();
	CEHResult getContentsSize(INT32* widthOut, INT32* heightOut);
	CEHResult draw(WebCore::GraphicsContext* ctx, const WebCore::IntRect& rect);

	CEWebKitFrameViewImpl* getView() { return _frameView; }
private:
	CEHResult _initFrame(WebCore::Page* page, WebCore::HTMLFrameOwnerElement* ownerElement);
	CEHResult _shutdownFrame();
	bool _needsLayout(WebCore::Frame* frame);
	int _getLayoutCount(const WebCore::Frame* frame);

private:
	CEWebKitWindowImpl* _silkPeer;
	WebCore::Frame* _frame;
	int _layoutCount;
	CEWebKitFrameViewImpl* _frameView;
};

CEWebKitWindowImpl* kit(WebCore::Frame* frame);
WebCore::Frame* core(CEWebKitWindowImpl* window);


#endif /* _CEWebKitWindow_h_ */
