///////////////////////////////////////////////////////////////////////////////
// Copyright     2010, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitWidget_h
#define CEWebKitWidget_h

#include "CESysDefs.h"
#include "IntRect.h"
#include "IntPoint.h"
#include "FloatRect.h"
#include "ICENetwork.h"
#include "CEUITypes.h"

namespace WebCore
{
	class GraphicsContext;
	class FrameView;
	class Widget;
}

typedef enum
{
	CEWebKitWidgetInputType_Undefined,
	CEWebKitWidgetInputType_TEXT,
	CEWebKitWidgetInputType_PASSWORD,
	CEWebKitWidgetInputType_ISINDEX,
	CEWebKitWidgetInputType_CHECKBOX,
	CEWebKitWidgetInputType_RADIO,
	CEWebKitWidgetInputType_SUBMIT,
	CEWebKitWidgetInputType_RESET,
	CEWebKitWidgetInputType_FILE,
	CEWebKitWidgetInputType_HIDDEN,
	CEWebKitWidgetInputType_IMAGE,
	CEWebKitWidgetInputType_BUTTON,
	CEWebKitWidgetInputType_SEARCH,
	CEWebKitWidgetInputType_RANGE,
	CEWebKitWidgetInputType_EMAIL,
	CEWebKitWidgetInputType_NUMBER,
	CEWebKitWidgetInputType_TELEPHONE,
	CEWebKitWidgetInputType_URL,
} CEWebKitWidgetInputType;

typedef enum
{
	CEWebKitScrollMode_None,
	CEWebKitScrollMode_Window, // for old scroll
	CEWebKitScrollMode_Document,
	CEWebKitScrollMode_DocumentZoomFactor2
} CEWebKitScrollMode;

class CEWebKitWidget
{
public:
	CEWebKitWidget(){};
	virtual ~CEWebKitWidget(){};

	virtual CEHResult draw(WebCore::GraphicsContext* ctx,
		const WebCore::IntRect& rect) = 0;

	virtual CEHResult contentsResized() = 0;
	virtual CEHResult setScrollPosition(const WebCore::IntPoint& position) = 0;
	virtual CEHResult notifyChangeContentSize(const WebCore::IntSize size, const WebCore::IntSize fixedLayoutSize, const float zoomFactor) = 0;
	virtual CEHResult getDeviceScreenRect(WebCore::IntRect* const deviceScreenRectOut) = 0;
	virtual CEHResult initializeIME(bool password, bool singleLine, CEWebKitWidgetInputType inputType, const unsigned char* defaultStringStrUTF8, unsigned int defaultStringLen, INT32 maxLength, INT32 imeRect_x, INT32 imeRect_y, INT32 imeRect_width, INT32 imeRect_height, bool isPlugin, WebCore::Widget* pTarget) = 0;
	virtual CEHResult shutdownIME(bool nextIsTextInput) = 0;
	virtual CEHResult getNetworkEventListener(ICENetworkEventListener** listener) = 0;
	virtual CEHResult getUpdateDocRect(WebCore::FloatRect* const updateRect) = 0;
	virtual float getZoomFactor() = 0;
	virtual CEHResult getScrollMode(CEWebKitScrollMode *const scrollMode) = 0;
	virtual CEHResult setCursor(eCECursorType cursorType) = 0;
};

#endif //CEWebKitWidget_h
