///////////////////////////////////////////////////////////////////////////////
// Copyright     2008,2009,2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitImpl_h
#define CEWebKitImpl_h

#include "ICEHtmlWebKit.h"

#include "ICEApartment.h"
#include "ICEJSPrivilegeExtObjectListener.h"
#include "ICEJSPrivilegeSSObjectListener.h"

#include "./WebCoreSupport/FrameLoaderClientSilk.h"

typedef void (*WebKitPumpWebCoreHandler)(void* data);

class CEWebKitImpl
{
public:
	CEWebKitImpl();

	CEHResult init(ICEHtmlWebKitEnvironment* iEnvironment, ICENetwork* iCENetwork);
	CEHResult shutdown();

	CEHResult createWebKitFrameWindow(ICEWebKitFrameWindow** iFrameWindowOut);
	CEHResult pruneCache();
	CEHResult setProxy(bool isProxyEnable, ICEUString* host, UINT16 port);
	CEHResult setCookieEnable(bool isCookieEnable);
	CEHResult deleteAllCookies();
	CEHResult setCustomHeaderFileds(UINT16 numFields, ICEUString* const* fieldNames, ICEUString* const* fieldValues);
	CEHResult setAcceptLanguage(ICEUString* acceptLanguage);
	
	CEHResult handleTimerEvent();
	void setSharedTimerFiredFunction(void (*f)()) { _sharedTimerFiredFunction = f; }
	void setSharedTimerFireTime(double fireTime);
	void stopSharedTimer();

	static CEWebKitImpl* getInstance() { return _self; }

	static void messageHandlerProc(void* userData, void* msg, CEUThread_MsgStatus status)
	{
		ICEApartment* apartment = CEComGetApartment(CEComIID_ICENeutralApartment);
		CEComTransferApartment(0, apartment);
		CEComGlobalUnlock();
		
		getInstance()->_messageHandlerProc(msg);

		CEComGlobalLock();
		CEComTransferApartment(apartment, 0);
	}

	// mutoh added for JSExternal::getBrowserManger()
	// TODO Is this ok?
	ICEHtmlWebKitEnvironment* getWebKitEnvironment()
	{
		return(_iEnvironmentRef.object());
	}

	// Bug16496 for implement window.external
	// set window.external access listener
	CEHResult setJSPrivilegeExtObjectListener(ICEJSPrivilegeExtObjectListener* listener)
	{
		_jsPrivilegeExtObjectListener = listener;
		return(CE_S_OK);
	}
	// set window.SessionStorage access listener
	CEHResult setJSPrivilegeSSObjectListener(ICEJSPrivilegeSSObjectListener* listener)
	{
		_jsPrivilegeSSObjectListener = listener;
		return(CE_S_OK);
	}

	// get window.external access listener
	ICEJSPrivilegeExtObjectListener* getJSPrivilegeExtObjectListener()
	{
		return(_jsPrivilegeExtObjectListener.object());
	}

	// get window.SessionStorage access listener
	ICEJSPrivilegeSSObjectListener* getJSPrivilegeSSObjectListener()
	{
		return(_jsPrivilegeSSObjectListener.object());
	}

	bool checkLockingOutInLowMemory()
	{
		_lockingOutInLowMemory |= CEComIsLowMemory(0);
		return _lockingOutInLowMemory;
	}
	void clearLockingOutInLowMemory() 
	{
		_lockingOutInLowMemory = false;
		if (_timeoutReservedAfterLowMemory)
		{
			_timeoutReservedAfterLowMemory = false;
			setSharedTimerFireTime(0.0);
		}
	}
	void reserveTimeoutAfterLowMemory() 
	{
		_timeoutReservedAfterLowMemory = true;
	}
	CEHResult preparePluginInfo();

	void setSavedCertPath(unsigned long domain_hash, void* cert_path_ptr);
	void* getSavedCertPath(unsigned long domain_hash);
private:
	void _messageHandlerProc(void* msg);

private:
	// Bug16496 for implement window.external
	CEComICEJSPrivilegeExtObjectListenerRef _jsPrivilegeExtObjectListener;
	CEComICEJSPrivilegeSSObjectListenerRef _jsPrivilegeSSObjectListener;

	CEComICEHtmlWebKitEnvironmentRef _iEnvironmentRef;
	CEComICEHtmlOneshotTimerManagerRef _iTimerManagerRef;
	void (*_sharedTimerFiredFunction)();
	CEUThreadRef _thread;
	INT32 _shortTermTimeoutCount;

	unsigned _cacheMinDeadBytes;
	unsigned _cacheMaxDeadBytes;
	unsigned _cacheTotalBytes;

	bool _lockingOutInLowMemory;
	bool _timeoutReservedAfterLowMemory;
	bool _initFlagOfPlugin;

	HashMap<unsigned long, void*> _authedCertMap; // domain, cert_path

	static CEWebKitImpl* _self;
};

#endif /* CEWebKitImpl_h */
