///////////////////////////////////////////////////////////////////////////////
// Copyright     2010, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitFrameViewImpl_h
#define CEWebKitFrameViewImpl_h

#include "CEWebKitWidget.h"

class CEWebKitWindowPrivate;
class CEWebKitFrameWindowImpl;

class CEWebKitFrameViewImpl : public CEWebKitWidget
{
public:
	CEWebKitFrameViewImpl(CEWebKitWindowPrivate* window);
	virtual ~CEWebKitFrameViewImpl();

	// CEWebKitWidget pure virtual implement.
	CEHResult draw(WebCore::GraphicsContext* ctx, const WebCore::IntRect& rect);
	CEHResult contentsResized();
	CEHResult setScrollPosition(const WebCore::IntPoint& position);
	CEHResult notifyChangeContentSize(const WebCore::IntSize size, const WebCore::IntSize fixedLayoutSize, const float zoomFactor);
	CEHResult getDeviceScreenRect(WebCore::IntRect* const deviceScreenRectOut);
	CEHResult initializeIME(bool password, bool singleLine, CEWebKitWidgetInputType inputType, const unsigned char* defaultStringStrUTF8, unsigned int defaultStringLen, INT32 maxLength, INT32 imeRect_x, INT32 imeRect_y, INT32 imeRect_width, INT32 imeRect_height, bool isPlugin, WebCore::Widget* pTarget);
	CEHResult shutdownIME(bool nextIsTextInput);
	CEHResult getNetworkEventListener(ICENetworkEventListener** listener);
	CEHResult getUpdateDocRect(WebCore::FloatRect* const updateRect);
	float getZoomFactor();
	CEHResult getScrollMode(CEWebKitScrollMode *const scrollMode);
	CEHResult setCursor(eCECursorType cursorType);
	//

	CEHResult setFrameView(WebCore::FrameView* pFrameView);
	CEWebKitWindowPrivate* getWindowPrivate() { return _windowPrivate; }
private:
	CEWebKitFrameWindowImpl* _getCEWebKitFrameWindow();
	WebCore::FrameView* _pFrameView;
	CEWebKitWindowPrivate* _windowPrivate;
	eCECursorType _lastCursorType;
};

#endif /* CEWebKitFrameViewImpl_h */
