///////////////////////////////////////////////////////////////////////////////
// Copyright 2008,2009 Sony Corporation
///////////////////////////////////////////////////////////////////////////////
#ifndef CEWebKitFocusImpl_h
#define CEWebKitFocusImpl_h

#include "CESysDefs.h"
#include "ICEHtmlWebKit.h"

namespace WebCore {
	class FrameView;
	class RenderObject;
	class Widget;
	class Page;
}

class CEWebKitFrameWindowImpl;

class CEWebKitFocusImpl
{
public:
	CEWebKitFocusImpl();
	~CEWebKitFocusImpl();
	
	CEHResult init(CEWebKitFrameWindowImpl* silkPeer, ICEHtmlFocusNavigator* iFocusNavigatorRef);
	void shutdown();
	
	// for focus navigation cache
	void rebuildFocusNavigation();
	void addFocusItem(WebCore::RenderObject* o);
	void removeFocusItem(WebCore::RenderObject* o);
	void notifyContentPos(void* hView, CEPointBase* pos);
	
	// implements of FocusNavigatorPeer
	CEHResult isVisible(void* hView, bool* resultOut) const;
	CEHResult isFocusable(void* hView, bool* resultOut) const;
	CEHResult isEnable(void* hView, bool* resultOut) const;
	CEHResult scrollTo(void* hView, CEPointBase* pos);
	CEHResult getScrollPos(void* hView, CEPointBase* posOut) const;
	CEHResult getContentSize(void* hView, CEDim* sizeOut) const;
	CEHResult getTabIndex(void* hView, UINT32* tabIndexOut) const;
	CEHResult notifyFocused(void* hView);
	CEHResult notifyDestroy(void* hView);
	CEHResult constructFocusItemTree();
	CEHResult click(void* hView);
	CEHResult setStatus(CEHtmlFocusNavigatorPeerStatus status, INT32 vaue);
	CEHResult getStatus(CEHtmlFocusNavigatorPeerStatus status, INT32* value) const;
private:
	WebCore::FrameView* _getFrame(void* hView) const;
private:
	CEWebKitFrameWindowImpl* _silkPeer;
	CEComICEHtmlFocusNavigatorRef _iFocusNavigatorRef;
};

CEWebKitFocusImpl* focus(WebCore::Page* page);

#endif //#define CEWebKitFocusImpl_h


