///////////////////////////////////////////////////////////////////////////////
// Copyright 2010 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#include "WebKitSilkPrefix.h"

#include "CEWebKitFrameWindow.h"
#include "CEWebKitAccComp.h"
#include "CEWebKitMRLWindow.h"
#include "FrameView.h"
#include "GraphicsContextPlatformPrivateSilk.h"

#if USE(ACCELERATED_COMPOSITING)
/////////////////////////////////////////////////////////////
// SyncTimer
/////////////////////////////////////////////////////////////
CEWebKitAccCompSyncTimer::CEWebKitAccCompSyncTimer(CEWebKitFrameWindowPrivate* pWebViewPrivate)
: _syncTimer(this, &CEWebKitAccCompSyncTimer::syncTimerFired)
, _pWebViewPrivate(pWebViewPrivate)
{
	ASSERT(pWebViewPrivate);
}

CEWebKitAccCompSyncTimer::~CEWebKitAccCompSyncTimer()
{
	_syncTimer.stop();
}

void CEWebKitAccCompSyncTimer::startOneShot()
{
	if (!_syncTimer.isActive())
	{
		//CEComDebugPrintf("_syncTimer.startOneShot()\n");
		_syncTimer.startOneShot(0);
		CEMRL_FPS_18278_SAVETIME(0, 0);
	}
}
void CEWebKitAccCompSyncTimer::syncTimerFired(WebCore::Timer<CEWebKitAccCompSyncTimer>*)
{
	//CEComDebugPrintf("synTimerFired\n");
	CEMRL_FPS_18278_SAVETIME(0, 1);
	WebCore::Frame* frame = _pWebViewPrivate->getPage()->mainFrame();
	if (frame && frame->view())
		frame->view()->syncCompositingStateRecursive();
	CEMRL_FPS_18278_SAVETIME(0, 2);
}


void CEWebKitFrameWindowPrivate::layerSetRootGraphicsLayer(ICEMRLLayer* nativeRootLayer)
{
	if (_rootLayer != nativeRootLayer)
	{
		if (_rootLayer)
			_rootLayer.setWindow(0);

		_rootLayer = nativeRootLayer;
		if (nativeRootLayer)
		{
			CEWebKitMRLWindow* pWin = new CEWebKitMRLWindow(_silkPeer);
			if (pWin)
			{
				CEComICEMRLLWindowRef win(pWin->toICEMRLLWindow(pWin));
				_rootLayer.setWindow(win);
			}
		}
	}

	if (_rootLayer)
	{
		if (!_renderer)
		{
			WebCore::GraphicsLayerSilk::Env::getMRLFactory().createLayerRenderer(&_renderer);
		}
	}
	else
	{
		_renderer = 0;
	}

#if 0
	if (_rootLayer)
	{
		ASSERT(!_rootLayer->parent());
	}
	_rootLayer = nativeRootLayer;
	if (_rootLayer)
	{		
		_rootLayer->setFrameWindowImpl(_silkPeer);
	}
#endif //#if 0
}

///////////////////////////////////////////////////////////////
// CEWebKitFrameWindowPrivate ACCELERATED_COMPOSITING methods.
///////////////////////////////////////////////////////////////
void CEWebKitFrameWindowPrivate::layerMarkForSync(bool b)
{
#if 0
	if (b) // sync soon
	{
		ASSERT(0 && "fix this error");
	}
	else
#endif //0
	{
		_syncTimer.startOneShot();
	}
}

CEHResult CEWebKitFrameWindowPrivate::renderLayerBackingStore(ICEVGContext* iVGC, CERectF* dirtyRect)
{
	CEU_VALIDATE_PTR(iVGC);
	CEU_VALIDATE_PTR(dirtyRect);
	CEComICEVGContextRef vgc(iVGC);

	CEMRL_FPS_18278_SAVETIME(0, 6);
	CEComICEVGFactoryRef vgFactory(WebCore::GraphicsContextPlatformPrivate::Env::getVGFactory());

	vgc.save();
	vgc.setClipRectF(dirtyRect, eCEVGFillRule_WINDING);
	if (_rootLayer)
	{
		WebCore::Frame* frame = getPage()->mainFrame();
		if (frame)
		{
			WebCore::FrameView* view = frame->view();
			if (view)
			{
				CEPointBase scrollPos = 
				{
					view->scrollX(), 
					view->scrollY() 
				};

				CEDim viewportSize = 
				{
					view->layoutWidth(),
					view->layoutHeight()
				};

				// fake exceptForLayers backing store.
				{
					if (!_exceptForLayersBackingStore )
					{
						CERectF clip;
						vgc.getClipExtents(&clip._x, &clip._y, &clip._width, &clip._height);
						if (clip._width >= (viewportSize._width)
							&& clip._height >= (viewportSize._height))
						{
							CEComICEVGSurfaceRef targetSurface;
							vgc.getTargetSurface(&targetSurface);
							targetSurface.clone(&_exceptForLayersBackingStore);
						}
					}
					else
					{
						CEComICEVGPatternRef vgPattern;
						vgFactory.createPattern(_exceptForLayersBackingStore, &vgPattern);
						vgc.setSourcePattern(vgPattern);
						vgc.setOperator(eCEVGOperator_OVER);
						vgc.paint();
					}
				}

#ifndef NDEBUG
				static bool _printTree = false;
				if (_printTree)
					_rootLayer.printTree();
#endif //#ifndef NDEBUG
				WebCore::IntRect frameRect = view->frameRect();
				WebCore::FloatPoint fpos((float)frameRect.x(), (float)frameRect.y());
				_rootLayer.setPosition(fpos.x(), fpos.y());  // TODO: required?

				_renderer.render(vgFactory, vgc, _rootLayer, 
					scrollPos._x, scrollPos._y,
					viewportSize._width, viewportSize._height);

				vgc.restore();

				CEMRL_FPS_18278_SAVETIME(0, 7);
				UINT8 buff[128];
				_renderer.getMode(buff, sizeof(buff));
				CEMRL_FPS_18278_PRINT(vgc, (const char*)buff);
				CEMRL_FPS_18278_SAVETIME(0, 8);
			}
		}
	}
	return CE_S_OK;
}

bool CEWebKitFrameWindowPrivate::hasExceptForLayersBackingStore()const
{
	return _rootLayer ? (_exceptForLayersBackingStore != 0) : false;
}

void CEWebKitFrameWindowPrivate::invalidateExceptForLayersBackingStore()
{
	_exceptForLayersBackingStore = 0;
}


//////////////////////////////////////////////////////////
// CEWebKitMRLWindowImpl
//////////////////////////////////////////////////////////
CEHResult CEWebKitMRLWindowImpl::invalidateRect(INT32 x, INT32 y, INT32 width, INT32 height)
{
	if (_fw)
	{
		CERect r = {x, y, width, height};

		// TODO: union dirty rect.
		_fw->getChromeClient().repaint(&r);
#if 0
		if (rect)
			CEComDebugPrintf("invalidateRect: %d, %d, %d, %d\n",
			rect->_x,
			rect->_y,
			rect->_width,
			rect->_height);
		else
			CEComDebugPrintf("invalidateRect: window\n");
#endif //0
	}
	else {} // nothing to do.
	return CE_S_OK;
}

CEHResult CEWebKitMRLWindowImpl::invalidate()
{
	CERectF pRect;
	_fw->getChromeClient().getWindowRect(&pRect);
	return invalidateRect(
		static_cast<INT32>(pRect._x)
		, static_cast<INT32>(pRect._y)
		, static_cast<INT32>(pRect._width)
		, static_cast<INT32>(pRect._height)
		);
}



#if defined(CEMRL_FPS_18278)

#include "sstypes.h"
#include "CESysGetTimeOfDay.h"
#define MAX_TMS 20
#define MAX_CATEGORY 3
#define FONT_SIZE 15

namespace CEMRLFPS_18278 {

	INT64 tms[MAX_CATEGORY][MAX_TMS];
	CEComICEUICompositeFontRef _cf;
	size_t _maxCi = 0;

	void saveTime(size_t ci, size_t idx)
	{
		ASSERT(idx < MAX_TMS);
		ASSERT(ci < MAX_CATEGORY);
		tms[ci][idx] = CESysGetMonotonicTick();
		_maxCi = JGSS_MAX(ci, _maxCi);
	}

	INT32 _toMs(INT64 us)
	{
		return (INT32)(us/1000);
	}

	void _drawText(CEComICEVGContextRef&out, const UTF16CHAR* pC16s, UINT32 nC16s, CEPointBase& pt)
	{
		if (!_cf)
		{
			CEComICEUICompositeFontFactoryRef cfFactory = 
				WebCore::CEUIFontSupport::getCFFactory();

			CEComICEUStringRef fname;
			char fn [] = "sans-serif";
			ICEUStringCreateFromUTF8Array(CEComStdClassID_CEUString, fn, sizeof(fn), fname);
			CEComICEUIFontFamilyRef ff;
			WebCore::CEUIFontSupport::toCEUIFontFamily(fname, ff);
			CEPFFontStyle style = CEPFFONTSTYLE_REGULAR;

			cfFactory.createCompositeFontBySizeInPixels(0, ff, &style, 16, true, &_cf);
		}

		CERGBAColor fc;
		fc._color._components.alpha = 0xff;
		fc._color._components.red = 0;
		fc._color._components.green = 0;
		fc._color._components.blue = 0;

		CERGBAColor sc;
		sc._color._components.alpha = 0xff;
		sc._color._components.red = 0xff;
		sc._color._components.green = 0xff;
		sc._color._components.blue = 0xff;

		out.save();
		CEUIFontOption opt;
		CESysFillMemory(&opt, 0, sizeof(opt));

		out.translateF(0, 0);
		_cf.drawUTF16CHARArrayI(out, &fc, &pt, pC16s, nC16s, 0);

		out.translateF(2, 2);
		_cf.drawUTF16CHARArrayI(out, &fc, &pt, pC16s, nC16s, 0);

		out.translateF(-1, -1);
		_cf.drawUTF16CHARArrayI(out, &sc, &pt, pC16s, nC16s, 0);

		out.restore();
	}

	void print(ICEVGContext* iout, const char* mode)
	{
		CEComICEVGContextRef out(iout);
		UTF16CHAR buff[2048];
		UINT32 nC16s = sizeof(buff)/sizeof(UTF16CHAR);
		CEPointBase pt = { 10, 10 };

		CEComSnPrintf(buff, &nC16s, 
			"mode = %hs",
			mode
			);

		_drawText(out, buff, nC16s, pt);
#if 0

		CEComSnPrintf(buff, &nC16s, 
			"0: 1-0=%d, 2-1=%d, 3-2=%d, 4-3=%d, 5-4=%d, 6-5=%d (ms)",
			_toMs(tms[0][1]-tms[0][0]),
			_toMs(tms[0][2]-tms[0][1]),
			_toMs(tms[0][3]-tms[0][2]),
			_toMs(tms[0][4]-tms[0][3]),
			_toMs(tms[0][5]-tms[0][4]),
			_toMs(tms[0][6]-tms[0][5])
			);

		_drawText(out, buff, nC16s, pt);
#endif //0

		nC16s = sizeof(buff)/sizeof(UTF16CHAR);
		CEComSnPrintf(buff, &nC16s, 
			"0: 7-6=%d, 0-8=%d, 7-8=%d (ms), (1000/7-8)=%d fps",
			_toMs(tms[0][7]-tms[0][6]),
			_toMs(tms[0][0]-tms[0][8]),
			_toMs(tms[0][7]-tms[0][8]),
			1000/_toMs(tms[0][7]-tms[0][8])
			);
		pt._y += (FONT_SIZE + 3);
		_drawText(out, buff, nC16s, pt);

#if 0
		nC16s = sizeof(buff)/sizeof(UTF16CHAR);
		CEComSnPrintf(buff, &nC16s, 
			"1: 1-0=%d, 2-1=%d, 3-2=%d, 4-3=%d, 5-4=%d, 6-5=%d (ms)",
			_toMs(tms[1][1]-tms[1][0]),
			_toMs(tms[1][2]-tms[1][1]),
			_toMs(tms[1][3]-tms[1][2]),
			_toMs(tms[1][4]-tms[1][3]),
			_toMs(tms[1][5]-tms[1][4]),
			_toMs(tms[1][6]-tms[1][5])
			);
		pt._y += (FONT_SIZE + 3);
		_drawText(out, buff, nC16s, pt);
#endif //0
	}

	void shutdown()
	{
		_cf = 0;
	}

}; // namespace

#endif //#if defined(CEMRL_FPS_18278)

#else //#if USE(ACCELERATED_COMPOSITING)
CEHResult CEWebKitMRLWindowImpl::invalidateRect(INT32 x, INT32 y, INT32 width, INT32 height)
{
	return CE_S_OK;
}

CEHResult CEWebKitMRLWindowImpl::invalidate()
{
	return CE_S_OK;
}
#endif //#if USE(ACCELERATED_COMPOSITING)


