///////////////////////////////////////////////////////////////////////////////
// Copyright     2010, 2012 Sony Corporation
// Copyright (C) 2012 Sony Computer Entertainment Inc.
///////////////////////////////////////////////////////////////////////////////

#ifndef _NPAPI_SILK_H_
#define _NPAPI_SILK_H_

#include "npapi.h"
#include "npfunctions.h"

#define CENP_WM_BASE                     (0x400 + 0x100)
#define CENP_WM_PAINT                    (CENP_WM_BASE + 0x01)
#define CENP_WM_TIMER                    (CENP_WM_BASE + 0x02)
#define CENP_WM_MOUSEMOVE                (CENP_WM_BASE + 0x20)
#define CENP_WM_LBUTTONDOWN              (CENP_WM_BASE + 0x21)
#define CENP_WM_LBUTTONUP                (CENP_WM_BASE + 0x22)
#define CENP_WM_RBUTTONDOWN              (CENP_WM_BASE + 0x24)
#define CENP_WM_RBUTTONUP                (CENP_WM_BASE + 0x25)
#define CENP_WM_KEYDOWN                  (CENP_WM_BASE + 0x30)
#define CENP_WM_KEYUP                    (CENP_WM_BASE + 0x31)
#define CENP_WM_KEYTYPED                 (CENP_WM_BASE + 0x32)
#define CENP_WM_IME_COMPOSITIONTEXT      (CENP_WM_BASE + 0x40)
#define CENP_WM_IME_ENDCOMPOSITION       (CENP_WM_BASE + 0x41)
#define CENP_WM_IME_CLEARCOMPONENTTEXT   (CENP_WM_BASE + 0x42)
#define CENP_WM_IME_EXITCOMPONENT        (CENP_WM_BASE + 0x43)

enum  eCENPKeyModifier
{
	eCENPKeyModifier_NONE		= 0,
	eCENPKeyModifier_CTRL		= 1 << 0,
	eCENPKeyModifier_SHIFT		= 1 << 1,
	eCENPKeyModifier_ALT		= 1 << 2,
	eCENPKeyModifier_NUMMODIFIERS = 3,
};

enum eCENPSpecialKey
{
	eCENPSpecialKey_None = -1,
	eCENPSpecialKey_Tab = 0,
	eCENPSpecialKey_Left = 1,
	eCENPSpecialKey_Up = 2,
	eCENPSpecialKey_Right = 3,
	eCENPSpecialKey_Down = 4,
	eCENPSpecialKey_Return = 5,
	eCENPSpecialKey_Escape = 6,
	eCENPSpecialKey_Alt_Up = 7,
	eCENPSpecialKey_Alt_Down = 8
};

enum eCENPVirtualKey
{
	eCENPVK_UNDEFINED		= 0,
	eCENPVK_ENTER			= '\n',
	eCENPVK_BACK_SPACE		= '\b',
	eCENPVK_TAB				= '\t',
	eCENPVK_CARRAIGE_RETURN	= '\r',
	eCENPVK_CANCEL			= 0x03,
	eCENPVK_CLEAR			= 0x0C,
	eCENPVK_SHIFT			= 0x10,
	eCENPVK_CONTROL			= 0x11,
	eCENPVK_ALT				= 0x12,
	eCENPVK_PAUSE			= 0x13,
	eCENPVK_CAPS_LOCK		= 0x14,
	eCENPVK_ESCAPE			= 0x1B,

	eCENPVK_SPACE			= 0x20,
	eCENPVK_PAGE_UP			= 0x21,
	eCENPVK_PAGE_DOWN		= 0x22,
	eCENPVK_END				= 0x23,
	eCENPVK_HOME			= 0x24,
	eCENPVK_LEFT			= 0x25,
	eCENPVK_UP				= 0x26,
	eCENPVK_RIGHT			= 0x27,
	eCENPVK_DOWN			= 0x28,

	eCENPVK_SELECT			= 0x29,
	eCENPVK_PRINT			= 0x2A,
	eCENPVK_EXECUTE			= 0x2B,
	eCENPVK_SNAPSHOT		= 0x2C,
	eCENPVK_INSERT			= 0x2D,
	eCENPVK_DELETE			= 0x2E,
	eCENPVK_HELP			= 0x2F,

    // ascii '0' thru '9' (0x30 - 0x39)
	eCENPVK_0				= 0x30,
	eCENPVK_1				= 0x31,
	eCENPVK_2				= 0x32,
	eCENPVK_3				= 0x33,
	eCENPVK_4				= 0x34,
	eCENPVK_5				= 0x35,
	eCENPVK_6				= 0x36,
	eCENPVK_7				= 0x37,
	eCENPVK_8				= 0x38,
	eCENPVK_9				= 0x39,

    // ascii 'A' thru 'Z' (0x41 - 0x5A)
	eCENPVK_A				= 0x41,
	eCENPVK_B				= 0x42,
	eCENPVK_C				= 0x43,
	eCENPVK_D				= 0x44,
	eCENPVK_E				= 0x45,
	eCENPVK_F				= 0x46,
	eCENPVK_G				= 0x47,
	eCENPVK_H				= 0x48,
	eCENPVK_I				= 0x49,
	eCENPVK_J				= 0x4A,
	eCENPVK_K				= 0x4B,
	eCENPVK_L				= 0x4C,
	eCENPVK_M				= 0x4D,
	eCENPVK_N				= 0x4E,
	eCENPVK_O				= 0x4F,
	eCENPVK_P				= 0x50,
	eCENPVK_Q				= 0x51,
	eCENPVK_R				= 0x52,
	eCENPVK_S				= 0x53,
	eCENPVK_T				= 0x54,
	eCENPVK_U				= 0x55,
	eCENPVK_V				= 0x56,
	eCENPVK_W				= 0x57,
	eCENPVK_X				= 0x58,
	eCENPVK_Y				= 0x59,
	eCENPVK_Z				= 0x5A,

	eCENPVK_LWIN			= 0x5B,
	eCENPVK_RWIN			= 0x5C,
	eCENPVK_APPS			= 0x5D,

	eCENPVK_NUMPAD0			= 0x60,
	eCENPVK_NUMPAD1			= 0x61,
	eCENPVK_NUMPAD2			= 0x62,
	eCENPVK_NUMPAD3			= 0x63,
	eCENPVK_NUMPAD4			= 0x64,
	eCENPVK_NUMPAD5			= 0x65,
	eCENPVK_NUMPAD6			= 0x66,
	eCENPVK_NUMPAD7			= 0x67,
	eCENPVK_NUMPAD8			= 0x68,
	eCENPVK_NUMPAD9			= 0x69,
	eCENPVK_MULTIPLY		= 0x6A,
	eCENPVK_ADD				= 0x6B,
	eCENPVK_SEPARATER		= 0x6C,
	eCENPVK_SUBTRACT		= 0x6D,
	eCENPVK_DECIMAL			= 0x6E,
	eCENPVK_DIVIDE			= 0x6F,

	eCENPVK_F1				= 0x70,
	eCENPVK_F2				= 0x71,
	eCENPVK_F3				= 0x72,
	eCENPVK_F4				= 0x73,
	eCENPVK_F5				= 0x74,
	eCENPVK_F6				= 0x75,
	eCENPVK_F7				= 0x76,
	eCENPVK_F8				= 0x77,
	eCENPVK_F9				= 0x78,
	eCENPVK_F10				= 0x79,
	eCENPVK_F11				= 0x7A,
	eCENPVK_F12				= 0x7B,
	eCENPVK_F13				= 0x7C,
	eCENPVK_F14				= 0x7D,
	eCENPVK_F15				= 0x7E,
	eCENPVK_F16				= 0x7F,
	eCENPVK_F17				= 0x80,
	eCENPVK_F18				= 0x81,
	eCENPVK_F19				= 0x82,
	eCENPVK_F20				= 0x83,
	eCENPVK_F21				= 0x84,
	eCENPVK_F22				= 0x85,
	eCENPVK_F23				= 0x86,
	eCENPVK_F24				= 0x87,

	eCENPVK_NUM_LOCK		= 0x90,
	eCENPVK_SCROLL_LOCK		= 0x91,

	// following keys are available only on Japanese 106/109 keyboard
	eCENPVK_KANA			= 0x15,		// Japanese Hiragana/Katakana key
	eCENPVK_CONVERT			= 0x1C,		// Japanese IME Conversion key
	eCENPVK_NONCONVERT		= 0x1D,		// Japanese IME Non-conversion key
 	eCENPVK_MODECHANGE		= 0xE5		// Japanese Halfwidth/Fullwidth/Kanji key
};

typedef struct _CENPRect
{
	int _left;
	int _right;
	int _top;
	int _bottom;
	
} CENPRect;

typedef struct 
{
	int pitch;
	int bytePerPixel;
	unsigned char* pbuffer;
} CENPBuffer;

typedef struct
{
	NP_InitializeFuncPtr			NP_Initialize;
#if !defined(_MSC_VER)
	NP_GetMIMEDescriptionFuncPtr	NP_GetMIMEDescription;
#endif
} CENPExportedCallbacks;

typedef struct _CENPPoint
{
	int _x;
	int _y;
} CENPPoint;

/*!
 * IME mode is defined as follows:
 */
typedef enum
{
	CENPImeModeFlag_Password		= 1 << 6,		//!< Password
	CENPImeModeFlag_SingleLine		= 1 << 7,		//!< Single line

	CENPImeModeFlag_Type_Undefined	= 0 << 8,		//!< Unknown type
	CENPImeModeFlag_Type_Text		= 1 << 8,		//!< type=text
	CENPImeModeFlag_Type_Search		= 2 << 8,		//!< type=search
	CENPImeModeFlag_Type_Tel		= 3 << 8,		//!< type=tel
	CENPImeModeFlag_Type_Url		= 4 << 8,		//!< type=url
	CENPImeModeFlag_Type_Email		= 5 << 8,		//!< type=email
	CENPImeModeFlag_Type_Password 	= 6 << 8,		//!< type=password
	CENPImeModeFlag_Type_Number		= 7 << 8,		//!< type=number
	CENPImeModeFlag_Type_Mask		= 0xff << 8,	//!< Mask of CENPImeModeFlag_Type
} CENPImeModeFlag;

typedef struct _CENPInitializeIME
{
	unsigned char* iDefaultStringStr;	/* The default string to setting for IME (UTF8), it hasn't NULL terminate.*/
	unsigned int iDefaultStringLen;		/* The Byte length of iDefaultStringStr */
	int maxLength;						/* The maxium character length of inputting text*/
	unsigned int imeMode;				/* IME Mode setting to use CENPImeModeFlag.*/
} CENPInitializeIME;

typedef struct _CENPSetCompositionText
{
	unsigned char* iTextStr;			/* The string to be inputted from IME (UTF8), it hasn't NULL terminate.*/
	unsigned int iTextLen;				/* The Byte length of iTexStr*/
} CENPSetCompositionText;

typedef enum
{
	CENPCursorType_Unknown,
	CENPCursorType_Arrow,
	CENPCursorType_Hand,
	CENPCursorType_IBeam,
	CENPCursorType_None
} CENPCursorType;

typedef struct _CENPSetCursor
{
	CENPCursorType type;
} CENPSetCursor;

typedef struct _CENPKeyboardEventParam
{
	eCENPVirtualKey virtualKey; //!< Virtual key code.
	uint16 keyChar;				//!< Key Charactor
	uint32 modifiers;			//!< Key Modifiers
} CENPKeyboardEventParam;


#endif


