/*
 * Copyright (C) 2006, 2007 Apple Inc.  All rights reserved.
 * Copyright (C) 2008 Collabora Ltd. All rights reserved.
 * Copyright (C) 2008 Nuanti Ltd.
 * Copyright (C) 2008 Novell Inc. All rights reserved.
 * Copyright     2009, 2012 Sony Corporation
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#include "config.h"
#include "PluginPackage.h"

#include "SharedBuffer.h"
#include "npruntime_impl.h"

#include "ICEHtmlPlugin.h"
#include "ICEUString.h"
#include "ICETextSupport.h"
//#define KILL_STATIC_LINK_FOR_PLUGIN_18440
#if CE_OS(HYDRA) || CE_OS(XAI) 
#if !defined(KILL_STATIC_LINK_FOR_PLUGIN_18440)//For Bug18440 dummy test
#ifdef __cplusplus
extern "C" {
#endif
NPError NP_Initialize(NPNetscapeFuncs* aNPNFuncs, NPPluginFuncs* aNPPFuncs);
#ifdef __cplusplus
}
#endif
#endif
#endif


namespace WebCore {

static ICEHtmlPluginModuleLoader* getModuleLoader() {
	static ICEHtmlPluginModuleLoader* iModuleLoader = NULL;
	if (!iModuleLoader) {
		CEComGetThreadContext(CEComIID_ICEHtmlPluginModuleLoader, reinterpret_cast<void**>(&iModuleLoader));
		iModuleLoader->_vtbl->_release(iModuleLoader); // will keep alive after webcore die.
	}
	return iModuleLoader;
}

static ICEHtmlPluginModuleInfoReader* getModuleInfoReader() {
	static ICEHtmlPluginModuleInfoReader* iModuleInfoReader = NULL;
    static bool initialized = false;
	if (!initialized) {
        initialized = true;
		CEComGetThreadContext(CEComIID_ICEHtmlPluginModuleInfoReader, reinterpret_cast<void**>(&iModuleInfoReader));
        if (iModuleInfoReader) {
            // will keep alive after webcore die.
            iModuleInfoReader->_vtbl->_release(iModuleInfoReader);
        }
	}
	return iModuleInfoReader;
}


unsigned PluginPackage::hash() const
{ 
    unsigned hashCodes[2] = {
        m_path.impl()->hash(),
        m_lastModified
    };

    return StringImpl::computeHash(reinterpret_cast<UChar*>(hashCodes), 2 * sizeof(unsigned) / sizeof(UChar));
}

bool PluginPackage::equal(const PluginPackage& a, const PluginPackage& b)
{
    return a.m_description == b.m_description;
}

int PluginPackage::compareFileVersion(const PlatformModuleVersion&) const
{
    return 0;
}

static CEHResult readModuleInfo(CEComICEHtmlPluginModuleInfoReaderRef& iModuleInfoReaderRef,
				CEComICEUStringRef& iModuleNameRef,
				eCEHtmlPluginInfo infoType,
				Vector<String>& out) {
    CEComICEUStringRef iStrRef;
    CEHResult hr = iModuleInfoReaderRef.readModuleInfo(iModuleNameRef, infoType, &iStrRef);
    if (CESucceeded(hr)) {
	String info;
	hr = info.fromICEUString(iStrRef);
	if (CESucceeded(hr)) {
	    info.split(UChar('|'), out);
	}
    }
    return hr;
}
						    
bool PluginPackage::fetchInfo()
{
    CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;
    CEComICEHtmlPluginModuleInfoReaderRef iModuleInfoReaderRef = getModuleInfoReader();
    if (iModuleInfoReaderRef) {
        CEComICEUStringRef iModuleNameRef;
        Vector<String> types, extLists, descs, productName, fileDescription;

        hr = m_fileName.createICEUString(&iModuleNameRef);
        if (CESucceeded(hr))
            hr = readModuleInfo(iModuleInfoReaderRef, iModuleNameRef, eCEHtmlPluginInfo_MIMEType, types);
        if (CESucceeded(hr))
            hr = readModuleInfo(iModuleInfoReaderRef, iModuleNameRef, eCEHtmlPluginInfo_FileExtension, extLists);
        if (CESucceeded(hr))
            hr = readModuleInfo(iModuleInfoReaderRef, iModuleNameRef, eCEHtmlPluginInfo_OpenName, descs);
		if (CESucceeded(hr))
            hr = readModuleInfo(iModuleInfoReaderRef, iModuleNameRef, eCEHtmlPluginInfo_ProductName, productName);
		if (CESucceeded(hr))
            hr = readModuleInfo(iModuleInfoReaderRef, iModuleNameRef, eCEHtmlPluginInfo_Description, fileDescription);



        if (CESucceeded(hr)) {
            for (unsigned i = 0; i < types.size(); i++) {
                String type = types[i];
                if (i < extLists.size()) {
                    Vector<String> exts;
                    extLists[i].split(',', exts);
                    m_mimeToExtensions.add(type, exts);
                }
                if (i < descs.size())
                    m_mimeToDescriptions.add(type, descs[i]);
            }

			m_name = productName[0];
			m_description = fileDescription[0];
        }
    } else {

        if (!load())
            return false;

        CEComICEHtmlPluginModuleLoaderRef iModuleLoaderRef = getModuleLoader();
        if (iModuleLoaderRef)
        {
            CEComICEUStringRef iMimeDescRef = NULL;
            hr = iModuleLoaderRef.getModuleInfoString(m_module, &iMimeDescRef);
            if (CESucceeded(hr))
            {
                const UTF16CHAR* mimeDescChar = NULL;
                UINT32 numMimeDescChar = 0;
                hr = iMimeDescRef.getCharArray16(&mimeDescChar, &numMimeDescChar);
                if (CESucceeded(hr))
                {
                    String desc(mimeDescChar, numMimeDescChar);
                    PassRefPtr<SharedBuffer> buf = utf8Buffer(desc);

                    Vector<String> types;
                    desc.split(UChar(';'), false, types);
                    for (unsigned int i = 0; i < types.size(); ++i) {
                        Vector<String> mime;
                        types[i].split(UChar(':'), true, mime); 
                        if (mime.size() > 0) {
                            Vector<String> exts;
                            if (mime.size() > 1)
                                mime[1].split(UChar(','), false, exts);
//							determineQuirks(mime[0]);
                            m_mimeToExtensions.add(mime[0], exts);
                            if (mime.size() > 2)
                                m_mimeToDescriptions.add(mime[0], mime[2]);
                        }
                    }
                }
            }
        }
    }
	return (CESucceeded(hr));
}

CEHResult initializePluginSilk(CEComICEHtmlPluginModuleLoaderRef iModuleLoaderRef, PlatformModule module, NPNetscapeFuncs* browserFuncs, NPPluginFuncs* pluginFuncs);

bool PluginPackage::load()
{
	if (m_freeLibraryTimer.isActive()) {
		ASSERT(m_module);
		m_freeLibraryTimer.stop();
	} else if (m_isLoaded) {
        m_loadCount++;
        return true;
    }

	CEHResult hr = CE_SILK_ERR_OPERATION_FAILED;

	CEComICEHtmlPluginModuleLoaderRef iModuleLoaderRef = getModuleLoader();
	if (iModuleLoaderRef)
	{
		CEComICEUStringRef iFileNameRef = NULL;

		const UTF16CHAR* fileName = m_fileName.charactersSilk();
		UINT32 fileNameLength = (m_fileName.length() < CE_UINT32_MAX)? m_fileName.length() : CE_UINT32_MAX;
		hr = ICEUStringCreateFromUTF16Array(CEComStdClassID_CEUString, fileName, fileNameLength * sizeof(UTF16CHAR), iFileNameRef);
		if (CESucceeded(hr))
		{
			hr = iModuleLoaderRef.loadModule(iFileNameRef, &m_module);
			if (CESucceeded(hr))
			{
				m_isLoaded = true;
			}
		}
#if !CE_OS(HYDRA)  && !CE_OS(XAI) //For Bug18440 dummy test
		if (CESucceeded(hr))
		{
			memset(&m_pluginFuncs, 0, sizeof(m_pluginFuncs));
			m_pluginFuncs.size = sizeof(m_pluginFuncs);
			m_browserFuncs.size = sizeof (m_browserFuncs);
			m_browserFuncs.version = NP_VERSION_MINOR;
			m_browserFuncs.geturl = NPN_GetURL;
			m_browserFuncs.posturl = NPN_PostURL;
			m_browserFuncs.requestread = NPN_RequestRead;
			m_browserFuncs.newstream = NPN_NewStream;
			m_browserFuncs.write = NPN_Write;
			m_browserFuncs.destroystream = NPN_DestroyStream;
			m_browserFuncs.status = NPN_Status;
			m_browserFuncs.uagent = NPN_UserAgent;
			m_browserFuncs.memalloc = NPN_MemAlloc;
			m_browserFuncs.memfree = NPN_MemFree;
			m_browserFuncs.memflush = NPN_MemFlush;
			m_browserFuncs.reloadplugins = NPN_ReloadPlugins;
			m_browserFuncs.geturlnotify = NPN_GetURLNotify;
			m_browserFuncs.posturlnotify = NPN_PostURLNotify;
			m_browserFuncs.getvalue = NPN_GetValue;
			m_browserFuncs.setvalue = NPN_SetValue;
			m_browserFuncs.invalidaterect = NPN_InvalidateRect;
			m_browserFuncs.invalidateregion = NPN_InvalidateRegion;
			m_browserFuncs.forceredraw = NPN_ForceRedraw;
			m_browserFuncs.getJavaEnv = NPN_GetJavaEnv;
			m_browserFuncs.getJavaPeer = NPN_GetJavaPeer;
			m_browserFuncs.pushpopupsenabledstate = NPN_PushPopupsEnabledState;
			m_browserFuncs.poppopupsenabledstate = NPN_PopPopupsEnabledState;

			m_browserFuncs.releasevariantvalue = _NPN_ReleaseVariantValue;
			m_browserFuncs.getstringidentifier = _NPN_GetStringIdentifier;
			m_browserFuncs.getstringidentifiers = _NPN_GetStringIdentifiers;
			m_browserFuncs.getintidentifier = _NPN_GetIntIdentifier;
			m_browserFuncs.identifierisstring = _NPN_IdentifierIsString;
			m_browserFuncs.utf8fromidentifier = _NPN_UTF8FromIdentifier;
			m_browserFuncs.createobject = _NPN_CreateObject;
			m_browserFuncs.retainobject = _NPN_RetainObject;
			m_browserFuncs.releaseobject = _NPN_ReleaseObject;
			m_browserFuncs.invoke = _NPN_Invoke;
			m_browserFuncs.invokeDefault = _NPN_InvokeDefault;
			m_browserFuncs.evaluate = _NPN_Evaluate;
			m_browserFuncs.getproperty = _NPN_GetProperty;
			m_browserFuncs.setproperty = _NPN_SetProperty;
			m_browserFuncs.removeproperty = _NPN_RemoveProperty;
			m_browserFuncs.hasproperty = _NPN_HasMethod;
			m_browserFuncs.hasmethod = _NPN_HasProperty;
			m_browserFuncs.setexception = _NPN_SetException;
			m_browserFuncs.enumerate = _NPN_Enumerate;
			m_browserFuncs.construct = _NPN_Construct;
        }

		// initialize
		if (CESucceeded(hr))
		{
			hr = initializePluginSilk(iModuleLoaderRef, m_module, &m_browserFuncs, &m_pluginFuncs);
		}

		// prepare for shutdown
		if (CESucceeded(hr))
		{
			const char* NPShutdownFuncName = "NP_Shutdown";
			m_NPP_Shutdown = 0;
			hr = iModuleLoaderRef.findSymbol(m_module, NPShutdownFuncName, sizeof(NPShutdownFuncName), reinterpret_cast<void**>(&m_NPP_Shutdown));
		}


		if (CESucceeded(hr))
		{
			m_loadCount++;
		}
		else
		{
			unloadWithoutShutdown();
		}
	
#else
		if (CESucceeded(hr))
		{
			memset(&m_pluginFuncs, 0, sizeof(m_pluginFuncs));
			m_pluginFuncs.size = sizeof(m_pluginFuncs);
			m_browserFuncs.size = sizeof (m_browserFuncs);
			m_browserFuncs.version = NP_VERSION_MINOR;
			m_browserFuncs.geturl = NPN_GetURL;
			m_browserFuncs.posturl = NPN_PostURL;
			m_browserFuncs.requestread = NPN_RequestRead;
			m_browserFuncs.newstream = NPN_NewStream;
			m_browserFuncs.write = NPN_Write;
			m_browserFuncs.destroystream = NPN_DestroyStream;
			m_browserFuncs.status = NPN_Status;
			m_browserFuncs.uagent = NPN_UserAgent;
			m_browserFuncs.memalloc = NPN_MemAlloc;
			m_browserFuncs.memfree = NPN_MemFree;
			m_browserFuncs.memflush = NPN_MemFlush;
			m_browserFuncs.reloadplugins = NPN_ReloadPlugins;
			m_browserFuncs.geturlnotify = NPN_GetURLNotify;
			m_browserFuncs.posturlnotify = NPN_PostURLNotify;
			m_browserFuncs.getvalue = NPN_GetValue;
			m_browserFuncs.setvalue = NPN_SetValue;
			m_browserFuncs.invalidaterect = NPN_InvalidateRect;
			m_browserFuncs.invalidateregion = NPN_InvalidateRegion;
			m_browserFuncs.forceredraw = NPN_ForceRedraw;
			m_browserFuncs.getJavaEnv = NPN_GetJavaEnv;
			m_browserFuncs.getJavaPeer = NPN_GetJavaPeer;
			m_browserFuncs.pushpopupsenabledstate = NPN_PushPopupsEnabledState;
			m_browserFuncs.poppopupsenabledstate = NPN_PopPopupsEnabledState;

			m_browserFuncs.releasevariantvalue = _NPN_ReleaseVariantValue;
			m_browserFuncs.getstringidentifier = _NPN_GetStringIdentifier;
			m_browserFuncs.getstringidentifiers = _NPN_GetStringIdentifiers;
			m_browserFuncs.getintidentifier = _NPN_GetIntIdentifier;
			m_browserFuncs.identifierisstring = _NPN_IdentifierIsString;
			m_browserFuncs.utf8fromidentifier = _NPN_UTF8FromIdentifier;
			m_browserFuncs.createobject = _NPN_CreateObject;
			m_browserFuncs.retainobject = _NPN_RetainObject;
			m_browserFuncs.releaseobject = _NPN_ReleaseObject;
			m_browserFuncs.invoke = _NPN_Invoke;
			m_browserFuncs.invokeDefault = _NPN_InvokeDefault;
			m_browserFuncs.evaluate = _NPN_Evaluate;
			m_browserFuncs.getproperty = _NPN_GetProperty;
			m_browserFuncs.setproperty = _NPN_SetProperty;
			m_browserFuncs.removeproperty = _NPN_RemoveProperty;
			m_browserFuncs.hasproperty = _NPN_HasMethod;
			m_browserFuncs.hasmethod = _NPN_HasProperty;
			m_browserFuncs.setexception = _NPN_SetException;
			m_browserFuncs.enumerate = _NPN_Enumerate;
			m_browserFuncs.construct = _NPN_Construct;
		}


#if defined(KILL_STATIC_LINK_FOR_PLUGIN_18440)
		NPError npErr = NPERR_NO_ERROR;
#else
		NPError npErr = NP_Initialize(&m_browserFuncs, &m_pluginFuncs);
#endif
		if(npErr==NPERR_NO_ERROR)
		{
			m_loadCount++;
			hr = CE_S_OK;
		}
#endif
	}
    return (CESucceeded(hr));
}

} // namespace WebCore
