///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////

#include "config.h"
#include "PlatformString.h"
#include "ICETextSupport.h"

namespace WebCore {

#if U_SIZEOF_WCHAR_T==2
String::String(const UTF16CHAR* str, UINT32 len)
{
    if (!str)
        return;
    m_impl = StringImpl::create(reinterpret_cast<const UChar*>(str), len);
}
#endif

const UTF16CHAR* String::charactersSilk() const
{
	return reinterpret_cast<const UTF16CHAR*>(characters());
};

CEHResult String::fromICEUString(ICEUString* iStr)
{
	CEComICEUStringRef iStrRef(iStr);
	const UTF16CHAR* chars;
	UINT32 len;
	CEHResult hr = iStrRef.getCharArray16(&chars, &len);
	if (CESucceeded(hr))
	{
		String s(chars, len);
		swap(s);
	}
	return hr;
}

CEHResult String::createICEUString(ICEUString** out) const
{
	const UTF16CHAR* chars = charactersSilk();
	UINT32 size = length() * sizeof(UTF16CHAR);
	CEComICEUStringRef iStrRef;
	CEHResult hr = ICEUStringCreateFromUTF16Array(CEComStdClassID_CEUString, chars, size, iStrRef);
	if (CESucceeded(hr))
		*out = iStrRef.detach();
	return hr;
}

}
