/*
 * Copyright (C) 2004, 2005, 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2008 Collabora Ltd.  All rights reserved.
 * Copyright     2009, 2012 Sony Corporation
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#include "config.h"
#include "Widget.h"
#include "ScrollView.h"
#include "HostWindow.h"
#include "Cursor.h"

namespace WebCore {

void Widget::show()
{
}

void Widget::hide()
{
}

bool ignoreNextSetCursor = false;

void Widget::setCursor(const Cursor& cursor)
{
	if (ignoreNextSetCursor)
	{
		ignoreNextSetCursor = false;
		return;
	}

	if (root() && root()->hostWindow())
	{
		PlatformWidget platformWindow = root()->hostWindow()->platformWindow();
		if (platformWindow)
		{
			platformWindow->setCursor(cursor.impl());
		}
	}
}

void Widget::paint(GraphicsContext* ctx, const IntRect& r)
{
	if (!platformWidget())
		return;
	platformWidget()->draw(ctx, r);
}

void Widget::setFocus()
{
}

void Widget::setIsSelected(bool)
{
}


IntRect Widget::frameRect() const
{
    return m_frame;
}

void Widget::setFrameRect(const IntRect& rect)
{
    IntRect oldRect = m_frame;
	m_frame = rect;

	if (platformWidget())
	{
		if (oldRect.width() != rect.width() || oldRect.height() != rect.width())
		{
			platformWidget()->contentsResized();
		}
	}
}

} // namespace WebCore
