///////////////////////////////////////////////////////////////////////////////
// Copyright 2011 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////

#include "config.h"
#include "ScrollbarSilk.h"

#include "EventHandler.h"
#include "Frame.h"
#include "FrameView.h"
#include "GraphicsContext.h"
#include "PlatformMouseEvent.h"
#include "ScrollbarClient.h"
#include "ScrollbarTheme.h"

#include "HostWindow.h"
#include "ScrollbarThemeSilk.h"

using namespace std;

namespace WebCore {
	
PassRefPtr<Scrollbar> Scrollbar::createNativeScrollbar(ScrollbarClient* client, ScrollbarOrientation orientation, ScrollbarControlSize size)
{
    return adoptRef(new ScrollbarSilk(client, orientation, size));
}

ScrollbarSilk::ScrollbarSilk(ScrollbarClient* client, ScrollbarOrientation orientation,
                           ScrollbarControlSize controlSize)
    : Scrollbar(client, orientation, controlSize)
{
}

ScrollbarSilk::~ScrollbarSilk()
{
}

void ScrollbarSilk::setFrameRect(const IntRect& rect)
{	
	IntRect zoomedRect = rect;
	if (parent())
	{
		HostWindow* hostWindow = parent()->hostWindow();
		if (hostWindow)
		{
			PlatformWidget platformWidget = hostWindow->platformWindow();
			if (platformWidget)
			{
				float zoomFactor = platformWidget->getZoomFactor();
				if (m_theme)
				{
					ScrollbarThemeSilk* themeSilk = static_cast<ScrollbarThemeSilk*>(m_theme);
					themeSilk->setZoomFactor(zoomFactor);
					int thickness = m_theme->scrollbarThickness(m_controlSize);
					
					if (orientation() == HorizontalScrollbar) {
						zoomedRect.setHeight(thickness);
					}
					else{
						zoomedRect.setWidth(thickness);
					}
				}
			}
		}
	}

	Scrollbar::setFrameRect(zoomedRect);
}

}

