/*
 * This file is part of the theme implementation for form controls in WebCore.
 *
 * Copyright (C) 2005, 2006, 2007, 2008 Apple Computer, Inc.
 * Copyright     2009 Sony Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef RenderThemeSilk_h
#define RenderThemeSilk_h

#include "RenderTheme.h"
#include "ICEHtmlWebKit.h"

namespace WebCore {

	RenderTheme* theme();

	class RenderThemeSilk : public RenderTheme
	{
	public:
		RenderThemeSilk();
		~RenderThemeSilk();

	protected:
		
		virtual void systemFont(int cssValueId, FontDescription&) const {}
		
		virtual bool paintButton(RenderObject*, const RenderObject::PaintInfo&, const IntRect&);

		virtual bool paintCheckbox(RenderObject* o, const RenderObject::PaintInfo& i, const IntRect& r);
		virtual void setCheckboxSize(RenderStyle*) const;

		virtual bool paintRadio(RenderObject* o, const RenderObject::PaintInfo& i, const IntRect& r);
		virtual void setRadioSize(RenderStyle* style) const;

		virtual bool paintTextField(RenderObject*, const RenderObject::PaintInfo&, const IntRect&);
		virtual bool paintTextArea(RenderObject*, const RenderObject::PaintInfo&, const IntRect&);
		
		virtual void adjustMenuListButtonStyle(CSSStyleSelector*, RenderStyle*, Element*) const;
		virtual bool paintMenuListButton(RenderObject*, const RenderObject::PaintInfo&, const IntRect&);
		
		virtual void adjustMenuListStyle(CSSStyleSelector* selector, RenderStyle* style, Element* e) const;
		virtual bool paintMenuList(RenderObject* o, const RenderObject::PaintInfo& i, const IntRect& r);

		virtual bool paintSearchField(RenderObject* o, const RenderObject::PaintInfo& i, const IntRect& r);
		virtual void adjustSearchFieldCancelButtonStyle(CSSStyleSelector*, RenderStyle*, Element*) const;
		virtual bool paintSearchFieldCancelButton(RenderObject*, const RenderObject::PaintInfo&, const IntRect&);

		virtual double caretBlinkInterval() const;

		virtual bool supportsFocusRing(const RenderStyle* style) const;
		
	private:
		bool paintControl(CEHtmlDrawWidget type, CEHtmlDrawWidgetState state, RenderObject* ro, const RenderObject::PaintInfo& pi, const IntRect& r);
		CEHtmlDrawWidgetState _convertWidgetState(RenderObject* o);
		void _setDropDownButtonSize() const;

	private:
		CEComICEHtmlWebKitThemeRef _iWebKitThemeRef;

		UINT32 _checkboxWidth;
		UINT32 _checkboxHeight;
		UINT32 _radioWidth;
		UINT32 _radioHeight;
		UINT32 _dropDownButtonWidth;
		UINT32 _dropDownButtonHeight;
	};
}; // namespace WebCore

#endif /* RenderThemeSilk_h */
