///////////////////////////////////////////////////////////////////////////////
// Copyright 2008 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#include "config.h"
#include "KURL.h"
#include "NotImplemented.h"

namespace WebCore {

String KURL::fileSystemPath() const
{
    return path();
}

CEHResult KURL::fromICEURL(KURL& kurl, ICEURL* iurl)
{
    CEHResult err;
    String s;
    CEComICEURLRef urlRef(iurl);
    CEComICEUStringRef strRef;

    err = urlRef.getPropertyAsString2(CEURIProperty2_URI, &strRef, &convertCStringToICEUStringUTF8);
    if (!err)
    {
        err = s.fromICEUString(strRef);
        if (!err)
        {
            kurl = KURL(s);
        }
    }
    return err;
}

CEHResult KURL::createICEURL(ICEURL** iurl) const
{
	CEHResult err = CE_SILK_ERR_BADARGS;
	if (!isEmpty())
	{
		CEComICEUStringRef str;
		err = string().createICEUString(&str);
		if (!err)
		{
			CEComICEURLRef url;
			err = ceurl_create(reinterpret_cast<void**>(&url));
			if (!err)
			{
				err = url.parse(0, str);
				if (!err)
                    err = url.toImmutable();
				if (!err)
				{
					*iurl = url.detach();
				}
			}
		}
	}
	return err;
}

} // namespace WebCore
