/*
 * Copyright (C) 2004, 2006, 2008 Apple Inc. All rights reserved.
 * Copyright     2009, 2012 Sony Corporation
 * Copyright (C) 2012 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */

#include "config.h"
#include "Cursor.h"

namespace WebCore {

Cursor::Cursor(PlatformCursor impl)
{
	m_impl = impl;
}

Cursor::Cursor(const Cursor& c)
{
	m_impl = c.impl();
}

Cursor& Cursor::operator=(const Cursor& c)
{
	this->m_impl = c.impl();
	return *this;
}

Cursor::~Cursor() {}
Cursor::Cursor(Image*, IntPoint const&) {}

static Cursor arrowCursor = Cursor(eCECursorType_Arrow);

const Cursor& pointerCursor()
{
	return arrowCursor;
}

const Cursor& crossCursor()
{
	static Cursor cursor = Cursor(eCECursorType_Cross);
	return cursor;
}

const Cursor& handCursor()
{
	static Cursor cursor = Cursor(eCECursorType_Hand);
	return cursor;
}

const Cursor& moveCursor()
{
	return arrowCursor;
}

const Cursor& iBeamCursor()
{
	static Cursor cursor = Cursor(eCECursorType_IBeam);
	return cursor;
}

const Cursor& waitCursor()
{
	static Cursor cursor = Cursor(eCECursorType_Wait);
	return cursor;
}

const Cursor& helpCursor()
{
	static Cursor cursor = Cursor(eCECursorType_Help);
	return cursor;
}

const Cursor& eastResizeCursor()
{
	return arrowCursor;
}

const Cursor& northResizeCursor()
{
	return arrowCursor;
}

const Cursor& northEastResizeCursor()
{
	return arrowCursor;
}

const Cursor& northWestResizeCursor()
{
	return arrowCursor;
}

const Cursor& southResizeCursor()
{
	return arrowCursor;
}

const Cursor& southEastResizeCursor()
{
	return arrowCursor;
}

const Cursor& southWestResizeCursor()
{
	return arrowCursor;
}

const Cursor& westResizeCursor()
{
	return arrowCursor;
}

const Cursor& northSouthResizeCursor()
{
	static Cursor cursor = Cursor(eCECursorType_SizeNS);
	return cursor;
}

const Cursor& eastWestResizeCursor()
{
	static Cursor cursor = Cursor(eCECursorType_SizeWE);
	return cursor;
}

const Cursor& northEastSouthWestResizeCursor()
{
	static Cursor cursor = Cursor(eCECursorType_SizeNESW);
	return cursor;
}

const Cursor& northWestSouthEastResizeCursor()
{
	static Cursor cursor = Cursor(eCECursorType_SizeNWSE);
	return cursor;
}

const Cursor& columnResizeCursor()
{
	return arrowCursor;
}

const Cursor& rowResizeCursor()
{
	return arrowCursor;
}

const Cursor& middlePanningCursor()
{
	return arrowCursor;
}

const Cursor& eastPanningCursor()
{
	return arrowCursor;
}

const Cursor& northPanningCursor()
{
	return arrowCursor;
}

const Cursor& northEastPanningCursor()
{
	return arrowCursor;
}

const Cursor& northWestPanningCursor()
{
	return arrowCursor;
}

const Cursor& southPanningCursor()
{
	return arrowCursor;
}

const Cursor& southEastPanningCursor()
{
	return arrowCursor;
}

const Cursor& southWestPanningCursor()
{
	return arrowCursor;
}

const Cursor& westPanningCursor()
{
	return arrowCursor;
}

const Cursor& verticalTextCursor()
{
	return arrowCursor;
}

const Cursor& cellCursor()
{
	return arrowCursor;
}

const Cursor& contextMenuCursor()
{
	return arrowCursor;
}

const Cursor& noDropCursor()
{
	return arrowCursor;
}

const Cursor& notAllowedCursor()
{
	return arrowCursor;
}

const Cursor& progressCursor()
{
	return arrowCursor;
}

const Cursor& aliasCursor()
{
	return arrowCursor;
}

const Cursor& zoomInCursor()
{
	return arrowCursor;
}

const Cursor& zoomOutCursor()
{
	return arrowCursor;
}

const Cursor& copyCursor()
{
	return arrowCursor;
}

const Cursor& noneCursor()
{
	static Cursor cursor = Cursor(eCECursorType_No);
	return cursor;
}

const Cursor& grabCursor()
{
	return arrowCursor;
}

const Cursor& grabbingCursor()
{
	return arrowCursor;
}

} // namespace WebCore
