/*
 * Copyright (C) 2003, 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2006 Samuel Weinig <sam.weinig@gmail.com>
 * Copyright     2011 Sony Corporation
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef ResourceRequest_h
#define ResourceRequest_h

#include "ResourceRequestBase.h"
#include "CEApiFile.h"

namespace WebCore {

    struct ResourceRequest : ResourceRequestBase {

        ResourceRequest(const String& url)
            : ResourceRequestBase(KURL(url), UseProtocolCachePolicy)
	    , m_isReloadPolicyValid(true)
	    , m_isMainResource(false)
	    , m_identifier(0)
	    , m_frame(NULL)
	    , m_redirected(false)
	    , m_issync(false) 
	    , m_isupload(false) {
        }

        ResourceRequest(const KURL& url)
            : ResourceRequestBase(url, UseProtocolCachePolicy)
	    , m_isReloadPolicyValid(true)
	    , m_isMainResource(false)
	    , m_identifier(0)
	    , m_frame(NULL) 
	    , m_redirected(false)
	    , m_issync(false)
	    , m_isupload(false) {
        }

        ResourceRequest(const KURL& url, const String& referrer, ResourceRequestCachePolicy policy = UseProtocolCachePolicy)
            : ResourceRequestBase(url, policy)
	    , m_isReloadPolicyValid(true)
	    , m_isMainResource(false)
	    , m_identifier(0)
	    , m_frame(NULL) 
	    , m_redirected(false)
	    , m_issync(false)
	    , m_isupload(false) {
            setHTTPReferrer(referrer);
        }

        ResourceRequest()
            : ResourceRequestBase(KURL(), UseProtocolCachePolicy)
	    , m_isReloadPolicyValid(true)
	    , m_isMainResource(false)
	    , m_identifier(0)
	    , m_frame(NULL) 
	    , m_redirected(false)
	    , m_issync(false)
	    , m_isupload(false) {
        }

	    void reloadPolicyInvalid() const { m_isReloadPolicyValid = false; }
	    bool isReloadPolicyValid() const { return m_isReloadPolicyValid; }

	    void setIsMainResource() const { m_isMainResource = true; }
	    void unSetIsMainResource() const { m_isMainResource = false; }
	    bool getIsMainRresource() const { return m_isMainResource; }
	

	    void setIdentifier(unsigned long identifier) const { m_identifier = identifier; }
	    unsigned long getIdentifier() const { return m_identifier; }

	    void setFrame(void* frame) const { m_frame = frame; }
	    void* getFrame() const { return m_frame; }

	    void setRedirected(bool isRedirected) const { m_redirected = isRedirected; }
	    bool getRedirected() const { return m_redirected; }

	    bool getIsSync() const { return m_issync; }
	    void setIsSync(bool issync) const { m_issync = issync; }

	    bool IsUpLoad() const { return m_isupload; }
	    void setIsUpLoad(bool isupload) const { m_isupload = isupload; }
    private:
	    friend class ResourceRequestBase;

	    void doUpdatePlatformRequest() {}
	    void doUpdateResourceRequest() {}

	    mutable bool m_isReloadPolicyValid;
	    mutable bool m_isMainResource;
	    mutable unsigned long m_identifier;
	    mutable void* m_frame;
	    mutable bool m_redirected;
	    mutable bool m_issync;
	    mutable bool m_isupload;
    };

} // namespace WebCore

#endif // ResourceRequest_h
