/*
 *  Copyright     2011 Sony Corporation
 *  Copyright (C) 2011 Sony Computer Entertainment Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#include "config.h"
#include "CookieJar.h"

#include "KURL.h"
#include "PlatformString.h"
#include "StringHash.h"

#include <wtf/HashMap.h>
#include "ResourceHandleManagerCore.h"

namespace WebCore {

void setCookies(Document* /*document*/, const KURL& url, const String& value)
{
	ResourceHandleManager* pResoureHandler = ResourceHandleManager::sharedInstance();
	if(pResoureHandler)
	{
		pResoureHandler->setCookies(url, value);
	}
}

String cookies(const Document* /*document*/, const KURL& url)
{	
	ResourceHandleManager* pResoureHandler = ResourceHandleManager::sharedInstance();
	if(pResoureHandler)
	{
		return pResoureHandler->getCookies(url);
	}
	return String();
}

bool cookiesEnabled(const Document* /*document*/)
{	
	ResourceHandleManager* pResoureHandler = ResourceHandleManager::sharedInstance();
	if(pResoureHandler)
	{
		return pResoureHandler->cookiesEnabled();
	}
	return false;
}

}
