///////////////////////////////////////////////////////////////////////////////
// Copyright 2010 Sony Corporation
///////////////////////////////////////////////////////////////////////////////

#ifndef GraphicsLayerSilk_h
#define GraphicsLayerSilk_h

#if USE(ACCELERATED_COMPOSITING)

#include "GraphicsContext.h"
#include "GraphicsLayer.h"
#include "ICEMRL.h"

#define GLayerSILK(gLayer) static_cast<GraphicsLayerSilk*>(gLayer)

namespace WebCore {
class GraphicsLayerSilk : public GraphicsLayer {
public:

	class Env {
	public:
		static CEHResult init(ICEMRLFactory* mrlFactory)
		{
			_mrlFactory = mrlFactory;
			return CE_S_OK;
		}

		static void shutdown()
		{
			_mrlFactory = 0;
		}

		static CEComICEMRLFactoryRef getMRLFactory()
		{
			return _mrlFactory;
		}

	private:
		static CEComICEMRLFactoryRef _mrlFactory;
	};

public:

	GraphicsLayerSilk(GraphicsLayerClient* client);
	virtual ~GraphicsLayerSilk();

	virtual void setNeedsDisplay();
	// mark the given rect (in layer coords) as needing display. Never goes deep.
	virtual void setNeedsDisplayInRect(const FloatRect&);

	virtual void setName(const String& name);
	virtual NativeLayer nativeLayer() const;
	virtual void addChild(GraphicsLayer*);
	virtual void addChildAtIndex(GraphicsLayer*, int index);
	virtual void addChildAbove(GraphicsLayer* layer, GraphicsLayer* sibling);
	virtual void addChildBelow(GraphicsLayer* layer, GraphicsLayer* sibling);
	virtual bool replaceChild(GraphicsLayer* oldChild, GraphicsLayer* newChild);
	virtual void removeFromParent();
	virtual void setPosition(const FloatPoint& p);
	virtual void setAnchorPoint(const FloatPoint3D& p);
	virtual void setSize(const FloatSize& size);
	virtual void setTransform(const TransformationMatrix& t);
	virtual void setChildrenTransform(const TransformationMatrix& t);
	virtual void setPreserves3D(bool b);
	virtual void setMasksToBounds(bool b);
	virtual void setDrawsContent(bool b);
	virtual void setBackgroundColor(const Color&);
	virtual void clearBackgroundColor();
	virtual void setContentsOpaque(bool b);
	virtual void setBackfaceVisibility(bool b);
	virtual void setOpacity(float o);
	virtual void suspendAnimations();
	virtual void resumeAnimations();
	virtual void setContentsToImage(Image*);
	virtual void setContentsToVideo(PlatformLayer*);
	virtual void setContentsBackgroundColor(const Color&);
	virtual PlatformLayer* platformLayer() const;
#ifndef NDEBUG
	virtual void setDebugBackgroundColor(const Color&);
	virtual void setDebugBorder(const Color&, float /*borderWidth*/);
	virtual float zPosition() const;
	virtual void setZPosition(float);
#endif //#ifndef NDEBUG

	// Set the geometry orientation (top-down, or bottom-up) for this layer, which also controls sublayer geometry.
	virtual void setGeometryOrientation(CompositingCoordinatesOrientation orientation);

	// Flippedness of the contents of this layer. Does not affect sublayer geometry.
	virtual void setContentsOrientation(CompositingCoordinatesOrientation orientation);

	virtual void syncCompositingState();
	virtual void setOpacityInternal(float accumulatedOpacity);

	//////////////////////////////////////////////////////////////////
	// slik private interface
	//////////////////////////////////////////////////////////////////
	
	void _syncChildren();

private:
	mutable CEComICEMRLLayerRef _cemrlLayer;
	bool _needsSyncChildren;
};
}; // namespace


#endif //#if USE(ACCELERATED_COMPOSITING)
#endif //#ifndef GraphicsLayerSilk_h

