/*
 * Copyright (C) 2006, 2007, 2008 Apple Inc. All rights reserved.
 * Copyright     2008, 2009 Sony Corporation
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#if USE(SILK_CEUIFONT)
#include "GlyphPageTreeNode.h"
#include "SimpleFontData.h"
#include "FontCache.h"
#include "CEPFRasterizer.h"
namespace WebCore {
bool GlyphPage::fill(unsigned offset, unsigned length, UChar* buffer, unsigned bufferLength, const SimpleFontData* fontData)
{
    // bufferLength will be greater than the requested number of glyphs if the buffer contains surrogate pairs.
	CEASSERT(length == bufferLength || ((length*2) == bufferLength));

    bool haveGlyphs = false;
	UINT32 nFound = 0;
	CEComICEUIPlatformFontRef pf = fontData->platformData().pfFont();
	if (pf) {
		UINT32 glyphs[GlyphPage::size];
		UINT32 nGlyphs = GlyphPage::size;
	    if (CESucceeded(pf.getGlyphs16((const UTF16CHAR*)buffer, bufferLength, length == bufferLength, glyphs, &nGlyphs))) {
			CEASSERT((nGlyphs <= GlyphPage::size) && (length == nGlyphs));
			for (unsigned i = 0; i < length; i++) {
				if (CEPF_BAD_GLYPHINDEX(glyphs[i]))
					setGlyphDataForIndex(offset + i, 0, 0);
				else {
					setGlyphDataForIndex(offset + i, glyphs[i], fontData);
					haveGlyphs = true;
					nFound++;
				}
			}
		}
    }

#if 0
	{
		static int _fillCount = 0;
		const FontPlatformData& fpd = fontData->platformData();

		CEComICEUICompositeFontRef pf = fpd.pfFont();
		if (pf) {
			CEPFFaceInfo faceInfo;
			CESysFillMemory(&faceInfo, 0, sizeof(CEPFFaceInfo));
			pf.getPFFaceInfo(&faceInfo);

			UTF16CHAR buff[512]={0};
			if (faceInfo.familyName) {
				CESysCopyMemory(buff, sizeof(buf), faceInfo.familyName, faceInfo.familyNameSizeInBytes);
				buff[faceInfo.familyNameSizeInBytes/sizeof(UTF16CHAR)]=0;
			}

			INT32 ceFontStyles = 0;
			pf.getValue(CEUIFontValueType_CEFontStyles, &ceFontStyles);

			CEComDebugPrintf("%p, %p, %p, pfstyle=%d, faceStyle=%d, havGlyphs=%d, sz=%f, bold=%d, oblique=%d, b[0]=%hx, nFound=%d, fillCount=%5d, %s\n", 
				this, fontData, pf.object(), ceFontStyles, faceInfo.eCEPFFontStyles,
				haveGlyphs?1:0, fpd.size(), fpd.syntheticBold()?1:0, fpd.syntheticOblique()?1:0,
				buffer[0], nFound, _fillCount++, buff);
		}
	}
#endif //0

    return haveGlyphs;
}

}

#else //#if USE(SILK_CEUIFONT)
bad config.
#endif //#if USE(SILK_CEUIFONT)


