/*
 * Copyright (C) 2007, 2008 Apple Inc. All rights reserved.
 * Copyright 2008, 2009 Sony Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

#ifndef FontCustomPlatformData_Silk_h
#define FontCustomPlatformData_Silk_h

#include "FontRenderingMode.h"
#include "PlatformString.h"
#include <wtf/Noncopyable.h>

#include "FontPlatformData.h"
#if USE(SILK_CEUI_CUSTOM_FONT)

#include "ICEPFRasterizer.h"
namespace WebCore {

	class SharedBuffer;
	
	typedef void* CEPFFontHANDLE;

	struct FontCustomPlatformData : Noncopyable {
		FontCustomPlatformData(ICEPFFace* pfFace, ICEUIFontFamily* uniqName)
			: m_pfface(pfFace)
			, m_name(uniqName)
		{
		}

		~FontCustomPlatformData();

		FontPlatformData fontPlatformData(int size, bool bold, bool italic, FontRenderingMode = NormalRenderingMode);

		CEComICEPFFaceRef		m_pfface;
		CEComICEUIFontFamilyRef	m_name;
	};

	FontCustomPlatformData* createFontCustomPlatformData(SharedBuffer*);
}

#else //#if USE(SILK_CEUI_CUSTOM_FONT)
#if USE(SILK_CEUIFONT)
#else //#if USE(SILK_CEUIFONT)
bad config.
#endif //#if USE(SILK_CEUIFONT)
#endif //#if USE(SILK_CEUI_CUSTOM_FONT)

#endif //FontCustomPlatformData_Silk_h

