///////////////////////////////////////////////////////////////////////////////
// Copyright 2009 Sony Corporation
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
// 
///////////////////////////////////////////////////////////////////////////////
#ifndef _CEImageBufferGraphicsContextImpl_h__
#define _CEImageBufferGraphicsContextImpl_h__

#include "config.h"
#include "ImageBuffer.h"

class CEWebCoreVGSurfaceWriteFuncImpl
{
public:
	CEWebCoreVGSurfaceWriteFuncImpl(Vector<char>& out)
		: _out(out)
	{}

	CEHResult write(ICEUnknown* closure, const UCHAR8* data, UINT32 length)
	{
		_out.append(data, length);
		return CE_S_OK;
	}

private:
	Vector<char>& _out;
};

#endif// _CEImageBufferGraphicsContextImpl_h__



