/*
 * Copyright (C) 2004, 2005, 2006, 2007 Apple Inc.
 * Copyright     2011 Sony Corporation
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 *
 */

/* This prefix file is for use on Mac OS X and Windows only. It should contain only:
 *    1) files to precompile on Mac OS X and Windows for faster builds
 *    2) in one case at least: OS-X-specific performance bug workarounds
 *    3) the special trick to catch us using new or delete without including "config.h"
 * The project should be able to build without this header, although we rarely test that.
 */

/* Things that need to be defined globally should go into "config.h". */

#if defined(__APPLE__)
#ifdef __cplusplus
#define NULL __null
#else
#define NULL ((void *)0)
#endif
#endif

#if defined(BUILDING_SILK__)
#elif defined(WIN32) || defined(_WIN32)

#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0500
#endif

#ifndef WINVER
#define WINVER 0x0500
#endif

#ifndef _WINSOCKAPI_
#define _WINSOCKAPI_ // Prevent inclusion of winsock.h in windows.h
#endif

// If we don't define these, they get defined in windef.h. 
// We want to use std::min and std::max
#ifdef __cplusplus
#define max max
#define min min
#endif

#else
#include <pthread.h>
#endif // defined(WIN32) || defined(_WIN32)

#include <sys/types.h>
#include <fcntl.h>
#if defined(__APPLE__)
#include <regex.h>
#endif
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#if defined(__APPLE__)
#include <unistd.h>
#endif

#ifdef __cplusplus

#include <algorithm>
#include <cstddef>
#include <new>

#endif

#include <sys/types.h>
#if defined(__APPLE__)
#include <sys/param.h>
#endif
#include <sys/stat.h>
#if defined(__APPLE__)
#include <sys/time.h>
#include <sys/resource.h>
#endif

#include <time.h>

#if !defined(BUILDING_SILK__)
#include <CoreFoundation/CoreFoundation.h>
#include <CoreServices/CoreServices.h>
#endif

#ifdef __OBJC__
#import <Cocoa/Cocoa.h>
#endif

#ifdef __cplusplus
#define new ("if you use new/delete make sure to include config.h at the top of the file"()) 
#define delete ("if you use new/delete make sure to include config.h at the top of the file"()) 
#endif

/* Work around a bug with C++ library that screws up Objective-C++ when exception support is disabled. */
#if defined(__APPLE__)
#undef try
#undef catch
#endif

// pch FAKE.
#if defined(_WIN32)
#include "config.h"
#include "CECom.h"
#include "CEApi.h"
#include "ICEUString.h"

#include "dom/Node.h"

#include "Unicode.h"

#include "wtf/ASCIICType.h"
#include "wtf/AlwaysInline.h"
#include "wtf/Assertions.h"
#include "wtf/ByteArray.h"
#include "wtf/CurrentTime.h"
#include "wtf/Deque.h"
#include "wtf/DisallowCType.h"
#include "wtf/FastMalloc.h"
#include "wtf/Forward.h"
#include "wtf/GetPtr.h"
#include "wtf/HashCountedSet.h"
#include "wtf/HashFunctions.h"
#include "wtf/HashMap.h"
#include "wtf/HashSet.h"
#include "wtf/HashTable.h"
#include "wtf/HashTraits.h"
#include "wtf/ListHashSet.h"
#include "wtf/ListRefPtr.h"
#include "wtf/Locker.h"
#include "wtf/MainThread.h"
#include "wtf/MathExtras.h"
#include "wtf/MessageQueue.h"
#include "wtf/Noncopyable.h"
#include "wtf/NotFound.h"
#include "wtf/OwnArrayPtr.h"
#include "wtf/OwnPtr.h"
#include "wtf/PassRefPtr.h"
#include "wtf/Platform.h"
#include "wtf/PtrAndFlags.h"
#include "wtf/RandomNumber.h"
#include "wtf/RefCounted.h"
#include "wtf/RefCountedLeakCounter.h"
#include "wtf/RefPtr.h"
#include "wtf/StdLibExtras.h"
#include "wtf/StringExtras.h"
#include "wtf/UnusedParam.h"
#include "wtf/Vector.h"
#include "wtf/VectorTraits.h"
#include "wtf/dtoa.h"

#include "SVGElement.h"
#include "XMLNames.h"
#include "HTMLNames.h"

#if ENABLE(SVG)
#include "XLinkNames.h"
#include "SVGNames.h"
#endif //#if ENABLE(SVG)

#include "SVGStylable.h"

#include "JSNodeList.h"

#include "AtomicString.h"
#include "JSNode.h"
#include "Node.h"
#include "NodeList.h"


#include "RenderObject.h"
#include "RenderBlock.h"

#include "Navigator.h"

#include "CookieJar.h"
#include "Frame.h"
#include "FrameLoader.h"
#include "FrameLoaderClient.h"


#include "CString.h"
#include "CSSTimingFunctionValue.h"
#include "CSSBorderImageValue.h"
#include "CSSCanvasValue.h"
#include "CSSCharsetRule.h"
#include "CSSCursorImageValue.h"
#include "CSSHelper.h"
#include "CSSImageValue.h"
#include "CSSFontFaceRule.h"
#include "CSSFontFaceSrcValue.h"
#include "CSSGradientValue.h"
#include "CSSImportRule.h"
#include "CSSInheritedValue.h"
#include "CSSInitialValue.h"
#include "CSSMediaRule.h"
#include "CSSMutableStyleDeclaration.h"
#include "CSSPrimitiveValue.h"
#include "CSSProperty.h"
#include "CSSPropertyNames.h"
#include "CSSQuirkPrimitiveValue.h"
#include "CSSReflectValue.h"
#include "CSSRuleList.h"
#include "CSSSelector.h"
#include "CSSStyleRule.h"
#include "CSSStyleSheet.h"
#include "CSSUnicodeRangeValue.h"
#include "CSSValueKeywords.h"
#include "CSSValueList.h"
#include "CSSVariableDependentValue.h"
#include "CSSVariablesDeclaration.h"
#include "CSSVariablesRule.h"
#include "Counter.h"
#include "Document.h"
#include "FloatConversion.h"
#include "FontFamilyValue.h"
#include "FontValue.h"
#include "MediaList.h"
#include "MediaQueryExp.h"
#include "Pair.h"
#include "Rect.h"
#include "ShadowValue.h"
#include "WebKitCSSKeyframeRule.h"
#include "WebKitCSSKeyframesRule.h"
#include "WebKitCSSTransformValue.h"
#endif //#if defined(_WIN32)
