/******************* (c) Marvell Semiconductor, Inc., 2001 ********************
 *
 *  $Header: Y:\\APCVSDEPOT/Vendor/ecos131/packages/net/drivers/eth/w81_eth/v1_0b1/src/w81_eth.c,v 1.1.1.1 2003/03/21 23:40:28 cvu Exp $
 *
 *  Purpose:
 *     This file contains implementation for the eagle ethernet hardware
 *
 *  Public Procedures:
 *     None.
 *
 *  Private Procedures:
 *     None.
 *
 *  Notes:
 *     None.
 *
 *****************************************************************************/

#include <pkgconf/net.h>
#include <pkgconf/net_w81_eth_drivers.h>

#include <cyg/infra/cyg_type.h>
#include <cyg/hal/hal_arch.h>
#include <cyg/infra/diag.h>
#include <cyg/hal/drv_api.h>
#include <cyg/hal/hal_cache.h>

#include <netdev.h>
#include <eth_drv.h>
#include <w81_eth.h>

extern void apfdGetEtherAddr(unsigned char *);

#define MAX_TX_BUF 32
#define TX_BUF_SIZE 1600

struct w8100_eth_info {
  int allocatedBufCount;
};



static struct w8100_eth_info w8100_eth0_info;

//static unsigned char enaddr[] = { 0x00, 0x50, 0x43, 0x02, 0x00, 0xA0};
extern unsigned char enaddr[6];

ETH_DRV_SC(w8100_eth0_sc,
           &w8100_eth0_info,   // Driver specific data
           "eth0",             // Name for this interface
           w8100_eth_start,
           w8100_eth_stop,
           w8100_eth_control,
           w8100_eth_can_send,
           w8100_eth_send,
           w8100_eth_recv);

NETDEVTAB_ENTRY(w8100_netdev, 
                "w8100_eth", 
                w8100_eth_init, 
                &w8100_eth0_sc);

struct eth_drv_sc *sc1 = 0;

//
// Initialize the interface - performed at system startup
// This function must set up the interface, including arranging to
// handle interrupts, etc, so that it may be "started" cheaply later.
//
static bool 
w8100_eth_init(struct cyg_netdevtab_entry *tab)
{
  struct eth_drv_sc *sc = (struct eth_drv_sc *)tab->device_instance;
  //struct w8100_eth_info *qi = (struct w8100_eth_info *)sc->driver_private;

  // Fetch the board address from the VPD
  //#define VPD_ETHERNET_ADDRESS 0x08
  //_mbx_fetch_VPD(VPD_ETHERNET_ADDRESS, enaddr, sizeof(enaddr));
  /* Get MAC address from flash, use hard coded address temporarily */
  sc1 = sc;
  // Initialize upper level driver
  apfdGetEtherAddr(enaddr);
  eth_drv_init(sc, (unsigned char *)&enaddr);
  return true;
}

//
// This function is called to shut down the interface.
//
static void
w8100_eth_stop(struct eth_drv_sc *sc)
{
  //struct w8100_eth_info *qi = (struct w8100_eth_info *)sc->driver_private;

  // Disable the device!

}

//
// This function is called to "start up" the interface.  It may be called
// multiple times, even when the hardware is already running.  It will be
// called whenever something "hardware oriented" changes and should leave
// the hardware ready to send/receive packets.
//
static void
w8100_eth_start(struct eth_drv_sc *sc, unsigned char *enaddr, int flags)
{
  //struct w8100_eth_info *qi = (struct w8100_eth_info *)sc->driver_private;

  // Enable the device!

}

//
// This function is called for low level "control" operations
//
static int
w8100_eth_control(struct eth_drv_sc *sc, unsigned long key,
                  void *data, int length)
{
  switch (key) {
  case ETH_DRV_SET_MAC_ADDRESS:
    return 0;
    break;
  default:
    return 1;
    break;
  }
}

//
// This function is called to see if another packet can be sent.
// It should return the number of packets which can be handled.
// Zero should be returned if the interface is busy and can not send any more.
//
static int
w8100_eth_can_send(struct eth_drv_sc *sc)
{
  return 1;
} 

//
// This routine is called to send data to the hardware.
static void 
w8100_eth_send(struct eth_drv_sc *sc, struct eth_drv_sg *sg_list, int sg_len, 
               int total_len, unsigned long key)
{
  //struct w8100_eth_info *qi = (struct w8100_eth_info *)sc->driver_private;

  volatile char *bp;
  dsQ_LlcData_t *txbd;

  register int i;

  /* Get buffer for ether transmit */
  txbd = ds_GetLlcDataBuf();

  if (txbd != NULL) {
    txbd->key = key;
    txbd->totalLen = total_len;

    bp = (char *)(txbd->data);

    for (i = 0;  i < sg_len;  i++) {
      bcopy((void *)sg_list[i].buf, (void *)bp, sg_list[i].len);
      bp += sg_list[i].len;
    }
    dsQ_LlcDataWriteNoBlock(txbd);
  }
  else {
    eth_drv_tx_done(sc, key, 1);
  }
}

//
// This function is called when a packet has been received.  It's job is
// to prepare to unload the packet from the hardware.  Once the length of
// the packet is known, the upper layer of the driver can be told.  When
// the upper layer is ready to unload the packet, the internal function
// 'w8100_eth_recv' will be called to actually fetch it from the hardware.
//
extern void
w8100_eth_RxEvent(int length)
{
  eth_drv_recv(sc1, length);
}

//
// This function is called as a result of the "eth_drv_recv()" call above.
// It's job is to actually fetch data for a packet from the hardware once
// memory buffers have been allocated for the packet.  Note that the buffers
// may come in pieces, using a scatter-gather list.  This allows for more
// efficient processing in the upper layers of the stack.
//
static void
w8100_eth_recv(struct eth_drv_sc *sc, struct eth_drv_sg *sg_list, int sg_len)
{
  volatile unsigned char * bp;
  register int i;

  bp = (unsigned char *)rcvdData;

  for (i = 0;  i < sg_len;  i++) {
    bcopy((void *)bp, (void *)sg_list[i].buf, sg_list[i].len);
    bp += sg_list[i].len;
  }
}

void
w8100_eth_TxEvent(dsQ_LlcData_t *pkt)
{
  eth_drv_tx_done(sc1, pkt->key, 0);
}


