/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version 1.1 (the 
 * "License"); you may not use this file except in compliance with the License. You may obtain 
 * a copy of the License at http://www.mozilla.org/MPL/ 
 *
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT 
 * WARRANTY OF ANY KIND, either express or implied. See the License for the specific 
 * language governing rights and limitations under the License. 
 *
 * The Original Code is [Open Source Virtual Machine.] 
 *
 * The Initial Developer of the Original Code is Adobe System Incorporated.  Portions created 
 * by the Initial Developer are Copyright (C)[ 2004-2006 ] Adobe Systems Incorporated. All Rights 
 * Reserved. 
 *
 * Contributor(s): Adobe AS3 Team
 *
 * Alternatively, the contents of this file may be used under the terms of either the GNU 
 * General Public License Version 2 or later (the "GPL"), or the GNU Lesser General Public 
 * License Version 2.1 or later (the "LGPL"), in which case the provisions of the GPL or the 
 * LGPL are applicable instead of those above. If you wish to allow use of your version of this 
 * file only under the terms of either the GPL or the LGPL, and not to allow others to use your 
 * version of this file under the terms of the MPL, indicate your decision by deleting provisions 
 * above and replace them with the notice and other provisions required by the GPL or the 
 * LGPL. If you do not delete the provisions above, a recipient may use your version of this file 
 * under the terms of any one of the MPL, the GPL or the LGPL. 
 *
 ***** END LICENSE BLOCK ***** */


import avmplus.*

var SCRIPT_NAME     = "opcodes.as";
var TBL_INPUT_FILE  = "../core/opcodes.tbl";
var OUTPUT_CPP_FILE = "../core/opcodes.cpp";
var OUTPUT_H_FILE   = "../core/opcodes.h";

var opcodes_text = File.read(TBL_INPUT_FILE);

var lines = opcodes_text.split('\n');

var opcodes = [];

class Opcode
{
	var constant;
	var name;
	var code;
    var ins_width;
	var op_count;
	var frm_use;
	var frm_set;
	var stk_pop;
	var stk_push;
	var canThrow;
}

for (var i=0; i<lines.length; i++) {
	var line = lines[i];

	// Remove comments from end
	line = line.replace(new RegExp("//.*$"), '');
	
    // Skip whitespace lines
    if (line.match(/^[ \t]*$/)) {
        continue;
    }

	// Separate quoted items from surroundings
	line = line.replace(/"[^"]+"/g, ' $& ');

	// Condense whitespace
	line = line.replace(/[ \t]+/g, ' ');

    var fields = line.split(' ');

    var opcode = new Opcode();
    opcode.constant = fields[0];
    opcode.name = fields[1];
    opcode.code = fields[2];
    opcode.ins_width = fields[3];
    opcode.op_count = fields[4];
    opcode.frm_use = fields[5];
    opcode.frm_set = fields[6];
    opcode.stk_pop = fields[7];
    opcode.stk_push = fields[8];
    opcode.canThrow = fields[9];

    opcodes.push(opcode);
}
		
var out = "";

out =  "/*\n";
out += " * THIS FILE IS AUTO-GENERATED. DO NOT EDIT THIS FILE.\n";
out += " * Use the script '" + SCRIPT_NAME + "' to generate this file.\n";
out += " */\n";
out += "\n";

out += "enum AbcOpcode {\n"
for (var i=0; i<opcodes.length; i++) {
	if (opcodes[i].constant.substr(0,5) != "OP_0x")
		out += opcodes[i].constant + " = " + opcodes[i].code + ",\n";
}
out += "};\n"

File.write(OUTPUT_H_FILE, out);

out =  "/*\n";
out += " * THIS FILE IS AUTO-GENERATED. DO NOT EDIT THIS FILE.\n";
out += " * Use the script '" + SCRIPT_NAME + "' to generate this file.\n";
out += " */\n";
out += "\n";

out += "#if defined(AVMPLUS_PROFILE) || defined(AVMPLUS_VERBOSE) || defined(DEBUGGER)\n";
out += "const char * const opNames[] = {\n";
var first=true;
for (var i=0; i<opcodes.length; i++) {
	if (!first) {
		out += ",\n";
	} else {
		first = false;
	}
	out += '    ' + opcodes[i].name;
}
out += "\n";
out += "};\n";
out += "#endif\n";
out += "\n";
out += "\n\n";
out += "const signed char opOperandCount[] = {\n";
for (var i=0; i<opcodes.length; i++) {
	out += '    ' + opcodes[i].op_count + ",\t// " + opcodes[i].name + "\n";
}
out += "\n";
out += "};\n";
out += "\n";
out += "#if 0 && defined(AVMPLUS_MIR) && defined(_DEBUG)\n";
out += "\n\n";
out += "// C++ note.  the max opSize[] value is 5 (3 bits).  We could pack these tighter.\n";
out += "// no. of bytes in the opcode stream.  0 means unsupported opcode.\n";
out += "const unsigned char opSizes[] = {\n";
for (var i=0; i<opcodes.length; i++) {
	out += '    ' + opcodes[i].ins_width + ",\t// " + opcodes[i].name + "\n";
}
out += "\n";
out += "};\n";
out += "const unsigned char opStackPop[] = {\n";
first = true;
for (var i=0; i<opcodes.length; i++) {
	if (!first) {
		out += ",\n";
	} else {
		first = false;
	}
	out += '    ' + opcodes[i].stk_pop;
}
out += "\n";
out += "};\n";
out += "\n"; 
out += "const unsigned char opStackPush[] = {\n";
first = true;
for (var i=0; i<opcodes.length; i++) {
	if (!first) {
		out += ",\n";
	} else {
		first = false;
	}
	out += '    ' + opcodes[i].stk_push;
}
out += "\n";
out += "};\n";
out += "#endif /* AVMPLUS_MIR && _DEBUG */\n";

out += "const unsigned char opCanThrow[] = {\n";
first = true;
for (var i=0; i<opcodes.length; i++) {
	if (!first) {
		out += ",\n";
	} else {
		first = false;
	}
	out += '    ' + opcodes[i].canThrow;
}
out += "\n";
out += "};\n";
out += "\n"; 
 
File.write(OUTPUT_CPP_FILE, out);

print("opcodes.as successful");
