#ifndef __avmplus_Sampler__
#define __avmplus_Sampler__

/*
 * Copyright (C) 2004-2006 Adobe Macromedia Software LLC.  All rights reserved.
 */

namespace avmplus
{
#ifdef DEBUGGER
	struct Sample
	{
		uint64 micros;
		uint32 sampleType;
		union {
			struct {
				uint32 depth;
				void *trace; // not filled in for sampleType==DELETED_OBJECT_SAMPLE
			} stack;
			uint64 size; // deleted object size record
			
		};
		uint64 id; // filled for DELETED_OBJECT_SAMPLE + NEW_OBJECT_SAMPLE
		// these are only filled in for sampleType==NEW_OBJECT_SAMPLE
		Atom  typeOrVTable;
		MMgc::GCWeakRef *weakRef;
	};

	class Sampler
	{
	public:
		Sampler(MMgc::GC *);
		~Sampler();

		enum SampleType 
		{ 
			RAW_SAMPLE=0x55555555,
			NEW_OBJECT_SAMPLE=0xaaaaaaaa, 
			DELETED_OBJECT_SAMPLE=0xdddddddd
		};
		
		// are we sampling at all
		bool sampling;

		// if true we call startSampling as early as possible during startup
		bool autoStartSampling;

		// should use opaque Cursor type instead of byte*
		byte *getSamples(uint32 &num);
		void readSample(byte *&p, Sample &s);
		
		void setCore(AvmCore *core);
		void init(bool sampling, bool autoStart);
		void sampleCheck() { if(takeSample) sample(); }

		uint64 recordAllocationSample(AvmPlusScriptableObject *obj, Atom typeOrVTable);
		void recordDeallocationSample(uint64 id, uint64 size);

		void startSampling();
		void stopSampling();
		void clearSamples();
		void pauseSampling();

		
		// called by VM after initBuiltin's
		void initSampling();

		void createFakeFunction(const char *name);
		AbstractFunction *getFakeFunction(const char *name);

		void presweep();
		void postsweep();

		uint32 sampleCount() const { return numSamples; }
 		bool activelySampling() { return samplingNow; }

	private:	


		static void inline align(byte*&b)
		{
			if((int)b & 4)
			{
#ifdef DEBUG
				*(int32*)b = 0xaaaaaaaa;
#endif
				b += sizeof(int32);
			}
		}
		
		template<class T>
		static void inline read(byte *&p, T &u)
		{
			u = *(T*)p;
			p += sizeof(T);
		}

		template<class T>
		static void inline write(byte *&p, T u)
		{
			*(T*)p = u;
			p += sizeof(T);
		}
		
		
		AvmCore *core;

		uint64 allocId;
				
		bool samplingNow;
		int takeSample;
		uint32 numSamples;
		GrowableBuffer samples;
		byte *currentSample;
		void sample();

		uintptr timerHandle;
		Hashtable *fakeMethodInfos; 
		
		void rewind(byte*&b, uint32 amount)
		{
			b -= amount;
		}

		int sampleSpaceCheck();
		
		void writeRawSample(SampleType sampleType);
	};

#define SAMPLE_FRAME(_strp, _core) avmplus::FakeCallStackNode __fcsn((avmplus::AvmCore*)_core, _strp)
#define SAMPLE_CHECK()  __fcsn.sampleCheck();

#else

#define SAMPLE_FRAME(_x, _s) 
#define SAMPLE_CHECK()

#endif // DEBUGGER
}
#endif // __avmplus_Sampler__
