/** 
   /* ***** BEGIN LICENSE BLOCK ***** 
    * Version: MPL 1.1/GPL 2.0/LGPL 2.1 
    *
    * The contents of this file are subject to the Mozilla Public License Version 1.1 (the 
    * "License"); you may not use this file except in compliance with the License. You may obtain 
    * a copy of the License at http://www.mozilla.org/MPL/ 
    * 
    * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT 
    * WARRANTY OF ANY KIND, either express or implied. See the License for the specific 
    * language governing rights and limitations under the License. 
    * 
    * The Original Code is [Open Source Virtual Machine.] 
    * 
    * The Initial Developer of the Original Code is Adobe System Incorporated.  Portions created 
    * by the Initial Developer are Copyright (C)[ 2004-2006 ] Adobe Systems Incorporated. All Rights 
    * Reserved. 
    * 
    * Contributor(s): Adobe AS3 Team
    * 
    * Alternatively, the contents of this file may be used under the terms of either the GNU 
    * General Public License Version 2 or later (the "GPL"), or the GNU Lesser General Public 
    * License Version 2.1 or later (the "LGPL"), in which case the provisions of the GPL or the 
    * LGPL are applicable instead of those above. If you wish to allow use of your version of this 
    * file only under the terms of either the GPL or the LGPL, and not to allow others to use your 
    * version of this file under the terms of the MPL, indicate your decision by deleting provisions 
    * above and replace them with the notice and other provisions required by the GPL or the 
    * LGPL. If you do not delete the provisions above, a recipient may use your version of this file 
    * under the terms of any one of the MPL, the GPL or the LGPL. 
    * 
    ***** END LICENSE BLOCK *****
  
 * THIS FILE IS AUTO-GENERATED. DO NOT EDIT THIS FILE.
 * Use the script 'errorgen' to generate this file.
 */

#include "avmplus.h"

namespace avmplus
{
    namespace ErrorConstants
    {
        // Error message strings only in DEBUGGER builds.
#ifdef DEBUGGER
		LangName languageNames[kLanguages] =
		{
            { "en",     LANG_en },
            { "de",     LANG_de },
            { "es",     LANG_es },
            { "fr",     LANG_fr },
            { "it",     LANG_it },
            { "ja",     LANG_ja },
            { "ko",     LANG_ko },
            { "zh-CN",  LANG_zh_CN },
            { "zh-TW",  LANG_zh_TW },

		};

        int errorMappingTable[2*kNumErrorConstants] =
        {
            1000, 0,
            1001, 1,
            1002, 2,
            1003, 3,
            1004, 4,
            1005, 5,
            1006, 6,
            1007, 7,
            1008, 8,
            1009, 9,
            1010, 10,
            1011, 11,
            1012, 12,
            1013, 13,
            1014, 14,
            1015, 15,
            1016, 16,
            1017, 17,
            1018, 18,
            1019, 19,
            1020, 20,
            1021, 21,
            1022, 22,
            1023, 23,
            1024, 24,
            1025, 25,
            1026, 26,
            1027, 27,
            1028, 28,
            1029, 29,
            1030, 30,
            1031, 31,
            1032, 32,
            1033, 33,
            1034, 34,
            1035, 35,
            1037, 36,
            1038, 37,
            1039, 38,
            1040, 39,
            1041, 40,
            1042, 41,
            1043, 42,
            1044, 43,
            1045, 44,
            1046, 45,
            1047, 46,
            1049, 47,
            1050, 48,
            1051, 49,
            1052, 50,
            1053, 51,
            1054, 52,
            1056, 53,
            1057, 54,
            1058, 55,
            1059, 56,
            1060, 57,
            1061, 58,
            1063, 59,
            1064, 60,
            1065, 61,
            1066, 62,
            1067, 63,
            1068, 64,
            1069, 65,
            1070, 66,
            1071, 67,
            1072, 68,
            1073, 69,
            1074, 70,
            1075, 71,
            1076, 72,
            1077, 73,
            1078, 74,
            1079, 75,
            1080, 76,
            1081, 77,
            1082, 78,
            1083, 79,
            1084, 80,
            1085, 81,
            1086, 82,
            1087, 83,
            1088, 84,
            1089, 85,
            1090, 86,
            1091, 87,
            1092, 88,
            1093, 89,
            1094, 90,
            1095, 91,
            1096, 92,
            1097, 93,
            1098, 94,
            1100, 95,
            1101, 96,
            1102, 97,
            1103, 98,
            1104, 99,
            1107, 100,
            1108, 101,
            1109, 102,
            1110, 103,
            1111, 104,
            1112, 105,
            1113, 106,
            1114, 107,
            1115, 108,
            1116, 109,
            1117, 110,
            1118, 111,
            1119, 112,
            1120, 113,
            1121, 114,
            1122, 115,
            1123, 116,
            1124, 117,
            1500, 118,
            1501, 119,
            1502, 120,
            1503, 121,
            1504, 122,
            1505, 123,
            1506, 124,
            1507, 125,
            1508, 126,
            1509, 127,
            1510, 128
        };

        const char* errorConstants[kLanguages][kNumErrorConstants] =
        {
                // en
            {
                /*1000,0*/ "The system is out of memory.",
                /*1001,1*/ "The method %1 is not implemented.",
                /*1002,2*/ "Number.toPrecision has a range of 1 to 21. Number.toFixed and Number.toExponential have a range of 0 to 20. Specified value is not within expected range.",
                /*1003,3*/ "The radix argument must be between 2 and 36; got %1.",
                /*1004,4*/ "Method %1 was invoked on an incompatible object.",
                /*1005,5*/ "Array index is not a positive integer (%1).",
                /*1006,6*/ "%1 is not a function.",
                /*1007,7*/ "Instantiation attempted on a non-constructor.",
                /*1008,8*/ "%1 is ambiguous; Found more than one matching binding.",
                /*1009,9*/ "Cannot access a property or method of a null object reference.",
                /*1010,10*/ "A term is undefined and has no properties.",
                /*1011,11*/ "Method %1 contained illegal opcode %2 at offset %3.",
                /*1012,12*/ "The last instruction exceeded code size.",
                /*1013,13*/ "Cannot call OP_findproperty when scopeDepth is 0.",
                /*1014,14*/ "Class %1 could not be found.",
                /*1015,15*/ "Method %1 cannot set default xml namespace",
                /*1016,16*/ "Descendants operator (..) not supported on type %1.",
                /*1017,17*/ "Scope stack overflow occurred.",
                /*1018,18*/ "Scope stack underflow occurred.",
                /*1019,19*/ "Getscopeobject %1 is out of bounds.",
                /*1020,20*/ "Code cannot fall off the end of a method.",
                /*1021,21*/ "At least one branch target was not on a valid instruction in the method.",
                /*1022,22*/ "Type void may only be used as a function return type.",
                /*1023,23*/ "Stack overflow occurred.",
                /*1024,24*/ "Stack underflow occurred.",
                /*1025,25*/ "An invalid register %1 was accessed.",
                /*1026,26*/ "Slot %1 exceeds slotCount=%2 of %3.",
                /*1027,27*/ "Method_info %1 exceeds method_count=%2.",
                /*1028,28*/ "Disp_id %1 exceeds max_disp_id=%2 of %3.",
                /*1029,29*/ "Disp_id %1 is undefined on %2.",
                /*1030,30*/ "Stack depth is unbalanced. %1 != %2.",
                /*1031,31*/ "Scope depth is unbalanced. %1 != %2.",
                /*1032,32*/ "Cpool index %1 is out of range %2.",
                /*1033,33*/ "Cpool entry %1 is wrong type.",
                /*1034,34*/ "Type Coercion failed: cannot convert %1 to %2.",
                /*1035,35*/ "Illegal super expression found in method %1.",
                /*1037,36*/ "Cannot assign to a method %1 on %2.",
                /*1038,37*/ "%1 is already defined.",
                /*1039,38*/ "Cannot verify method until it is referenced.",
                /*1040,39*/ "The right-hand side of instanceof must be a class or function.",
                /*1041,40*/ "The right-hand side of operator must be a class.",
                /*1042,41*/ "Not an ABC file.  major_version=%1 minor_version=%2.",
                /*1043,42*/ "Invalid code_length=%1.",
                /*1044,43*/ "MethodInfo-%1 unsupported flags=%2.",
                /*1045,44*/ "Unsupported traits kind=%1.",
                /*1046,45*/ "MethodInfo-%1 referenced before definition.",
                /*1047,46*/ "No entry point was found.",
                /*1049,47*/ "Prototype objects must be vanilla Objects.",
                /*1050,48*/ "Cannot convert %1 to primitive.",
                /*1051,49*/ "Illegal early binding access to %1.",
                /*1052,50*/ "Invalid URI passed to %1 function.",
                /*1053,51*/ "Illegal override of %1 in %2.",
                /*1054,52*/ "Illegal range or target offsets in exception handler.",
                /*1056,53*/ "Cannot create property %1 on %2.",
                /*1057,54*/ "%1 can only contain methods.",
                /*1058,55*/ "Illegal operand type: %1 must be %2.",
                /*1059,56*/ "ClassInfo-%1 is referenced before definition.",
                /*1060,57*/ "ClassInfo %1 exceeds class_count=%2.",
                /*1061,58*/ "The value %1 cannot be converted to %2 without losing precision.",
                /*1063,59*/ "Argument count mismatch on %1. Expected %2, got %3.",
                /*1064,60*/ "Cannot call method %1 as constructor.",
                /*1065,61*/ "Variable %1 is not defined.",
                /*1066,62*/ "The form function('function body') is not supported.",
                /*1067,63*/ "Native method %1 has illegal method body.",
                /*1068,64*/ "%1 and %2 cannot be reconciled.",
                /*1069,65*/ "Property %1 not found on %2 and there is no default value.",
                /*1070,66*/ "Method %1 not found on %2",
                /*1071,67*/ "Function %1 has already been bound to %2.",
                /*1072,68*/ "Disp_id 0 is illegal.",
                /*1073,69*/ "Non-override method %1 replaced because of duplicate disp_id %2.",
                /*1074,70*/ "Illegal write to read-only property %1 on %2.",
                /*1075,71*/ "Math is not a function.",
                /*1076,72*/ "Math is not a constructor.",
                /*1077,73*/ "Illegal read of write-only property %1 on %2.",
                /*1078,74*/ "Illegal opcode/multiname combination: %1<%2>.",
                /*1079,75*/ "Native methods are not allowed in loaded code.",
                /*1080,76*/ "Illegal value for namespace.",
                /*1081,77*/ "Property %1 not found on %2 and there is no default value.",
                /*1082,78*/ "No default namespace has been set.",
                /*1083,79*/ "The prefix \"%1\" for element \"%2\" is not bound.",
                /*1084,80*/ "Element or attribute (\"%1\") does not match QName production: QName::=(NCName':')?NCName.",
                /*1085,81*/ "The element type \"%1\" must be terminated by the matching end-tag \"</%2>\".",
                /*1086,82*/ "The %1 method only works on lists containing one item.",
                /*1087,83*/ "Assignment to indexed XML is not allowed.",
                /*1088,84*/ "The markup in the document following the root element must be well-formed.",
                /*1089,85*/ "Assignment to lists with more than one item is not supported.",
                /*1090,86*/ "XML parser failure: element is malformed.",
                /*1091,87*/ "XML parser failure: Unterminated CDATA section.",
                /*1092,88*/ "XML parser failure: Unterminated XML declaration.",
                /*1093,89*/ "XML parser failure: Unterminated DOCTYPE declaration.",
                /*1094,90*/ "XML parser failure: Unterminated comment.",
                /*1095,91*/ "XML parser failure: Unterminated attribute.",
                /*1096,92*/ "XML parser failure: Unterminated element.",
                /*1097,93*/ "XML parser failure: Unterminated processing instruction.",
                /*1098,94*/ "Illegal prefix %1 for no namespace.",
                /*1100,95*/ "Cannot supply flags when constructing one RegExp from another.",
                /*1101,96*/ "Cannot verify method %1 with unknown scope.",
                /*1102,97*/ "Illegal default value for type %1.",
                /*1103,98*/ "Class %1 cannot extend final base class.",
                /*1104,99*/ "Attribute \"%1\" was already specified for element \"%2\".",
                /*1107,100*/ "The ABC data is corrupt, attempt to read out of bounds.",
                /*1108,101*/ "The OP_newclass opcode was used with the incorrect base class.",
                /*1109,102*/ "Attempt to directly call unbound function %1 from method %2.",
                /*1110,103*/ "%1 cannot extend %2.",
                /*1111,104*/ "%1 cannot implement %2.",
                /*1112,105*/ "Argument count mismatch on class coercion.  Expected 1, got %1.",
                /*1113,106*/ "OP_newactivation used in method without NEED_ACTIVATION flag.",
                /*1114,107*/ "OP_getglobalslot or OP_setglobalslot used with no global scope.",
                /*1115,108*/ "%1 is not a constructor.",
                /*1116,109*/ "second argument to Function.prototype.apply must be an array.",
                /*1117,110*/ "Invalid XML name: %1.",
                /*1118,111*/ "Illegal cyclical loop between nodes.",
                /*1119,112*/ "Delete operator is not supported with operand of type %1.",
                /*1120,113*/ "Cannot delete property %1 on %2.",
                /*1121,114*/ "Method %1 has a duplicate method body.",
                /*1122,115*/ "Interface method %1 has illegal method body.",
                /*1123,116*/ "Filter operator not supported on type %1.",
                /*1124,117*/ "OP_hasnext2 requires object and index to be distinct registers.",
                /*1500,118*/ "Error occurred opening file %1.",
                /*1501,119*/ "Error occurred writing to file %1.",
                /*1502,120*/ "A script has executed for longer than the default timeout period of 15 seconds.",
                /*1503,121*/ "A script failed to exit after 30 seconds and was terminated.",
                /*1504,122*/ "End of file.",
                /*1505,123*/ "The string index %1 is out of bounds; must be in range %2 to %3.",
                /*1506,124*/ "The specified range is invalid.",
                /*1507,125*/ "Argument %1 cannot be null.",
                /*1508,126*/ "The value specified for argument %1 is invalid.",
                /*1509,127*/ "There was an error decompressing the data.",
                /*1510,128*/ "When the callback argument is a method of a class, the optional this argument must be null."
            },
                // de
            {
                /*1000,0*/ "Nicht genügend Speicher vorhanden.",
                /*1001,1*/ "Die Methode %1 wird nicht implementiert.",
                /*1002,2*/ "Das Genauigkeitsargument muss zwischen %2 und %3 liegen; %1 ist ungültig.",
                /*1003,3*/ "Das Grundzahlargument muss zwischen 2 und 36 liegen; %1 erhalten.",
                /*1004,4*/ "Methode %1 wurde für ein nicht kompatibles Objekt aufgerufen.",
                /*1005,5*/ "Array-Index ist keine positive Ganzzahl (%1).",
                /*1006,6*/ "%1 ist keine Funktion.",
                /*1007,7*/ "Versuchte Instanziierung für einen Nicht-Konstruktor.",
                /*1008,8*/ "%1 ist nicht eindeutig; es wurden mehrere übereinstimmende Bindungen gefunden.",
                /*1009,9*/ "Der Zugriff auf eine Eigenschaft oder eine Methode eines null-Objektverweises ist nicht möglich.",
                /*1010,10*/ "Ein Begriff ist nicht definiert und hat keine Eigenschaften.",
                /*1011,11*/ "Methode %1 enthielt einen unzulässigen Opcode %2 bei Offset %3.",
                /*1012,12*/ "Die letzte Anweisung hat die Codegröße überschritten.",
                /*1013,13*/ "OP_findproperty kann nicht aufgerufen werden, wenn scopeDepth 0 ist.",
                /*1014,14*/ "Klasse %1 wurde nicht gefunden.",
                /*1015,15*/ "Methode %1 kann nicht den Standard-XML-Namespace festlegen.",
                /*1016,16*/ "Nachfolger-Operator (..) wird für Typ %1 nicht unterstützt.",
                /*1017,17*/ "Gültigkeitsbereich-Stapelüberlauf.",
                /*1018,18*/ "Gültigkeitsbereich-Stapelunterlauf.",
                /*1019,19*/ "Getscopeobject %1 liegt außerhalb des gültigen Bereichs.",
                /*1020,20*/ "Code kann nicht außerhalb eines Methodenendes vorkommen.",
                /*1021,21*/ "Mindestens ein Verzweigungsziel war nicht auf einer gültigen Anweisung in der Methode.",
                /*1022,22*/ "Typ 'void' kann nur als Rückgabetyp für eine Funktion verwendet werden.",
                /*1023,23*/ "Stapelüberlauf.",
                /*1024,24*/ "Stapelunterlauf.",
                /*1025,25*/ "Zugriff auf ein ungültiges Register %1.",
                /*1026,26*/ "Position %1 ist höher als slotCount=%2 von %3.",
                /*1027,27*/ "Method_info %1 ist höher als method_count=%2.",
                /*1028,28*/ "Disp_id %1 ist größer als max_disp_id=%2 von %3.",
                /*1029,29*/ "Disp_id %1 ist nicht definiert in %2.",
                /*1030,30*/ "Stapeltiefe ist nicht ausgeglichen. %1 != %2.",
                /*1031,31*/ "Gültigkeitsbereichstiefe ist nicht ausgeglichen. %1 != %2.",
                /*1032,32*/ "Cpool-Index %1 liegt außerhalb des gültigen Bereichs %2.",
                /*1033,33*/ "Cpool-Eintrag %1 hat den falschen Typ.",
                /*1034,34*/ "Typumwandlung fehlgeschlagen: %1 kann nicht in %2 umgewandelt werden.",
                /*1035,35*/ "Unzulässiger super-Ausdruck in Methode %1 gefunden.",
                /*1037,36*/ "Zuweisung zu einer Methode %1 für %2 nicht möglich.",
                /*1038,37*/ "%1 ist bereits definiert.",
                /*1039,38*/ "Die Methode kann nicht überprüft werden, bevor sie referenziert wird.",
                /*1040,39*/ "Auf der rechten Seite von instanceof muss eine Klasse oder Funktion stehen.",
                /*1041,40*/ "Auf der rechten Seite des Operators muss eine Klasse stehen.",
                /*1042,41*/ "Keine ABC-Datei. major_version=%1 minor_version=%2.",
                /*1043,42*/ "Ungültige code_length=%1.",
                /*1044,43*/ "MethodInfo-%1 nicht unterstützte Flags=%2.",
                /*1045,44*/ "Nicht unterstützter Traittyp=%1.",
                /*1046,45*/ "MethodInfo-%1 vor der Definition referenziert.",
                /*1047,46*/ "Es wurde kein Zugangspunkt gefunden.",
                /*1049,47*/ "Prototypobjekte müssen Vanilla-Objekte sein.",
                /*1050,48*/ "%1 kann nicht in Grundtyp umgewandelt werden.",
                /*1051,49*/ "Unzulässig früher Bindungszugriff auf %1.",
                /*1052,50*/ "Ungültige URI an %1-Funktion übergeben.",
                /*1053,51*/ "Unzulässiges Außerkraftsetzen von %1 in %2.",
                /*1054,52*/ "Unzulässige Bereich- oder Zieloffsets in Ausnahmeprozedur.",
                /*1056,53*/ "Eigenschaft %1 in %2 kann nicht erstellt werden.",
                /*1057,54*/ "%1 kann nur Methoden enthalten.",
                /*1058,55*/ "Unzulässiger Operandtyp: %1 muss %2 sein.",
                /*1059,56*/ "ClassInfo-%1 vor der Definition referenziert.",
                /*1060,57*/ "ClassInfo %1 ist größer als class_count=%2.",
                /*1061,58*/ "Der Wert %1 kann nicht in %2 umgewandelt werden, ohne dass Genauigkeit verloren geht.",
                /*1063,59*/ "Nicht übereinstimmende Argumentzählung für %1. %2 erwartet, %3 erhalten.",
                /*1064,60*/ "Methode %1 kann nicht als Konstruktor aufgerufen werden.",
                /*1065,61*/ "Variable %1 ist nicht definiert.",
                /*1066,62*/ "Die Form function('function body') wird nicht unterstützt.",
                /*1067,63*/ "Der Hauptteil der nativen Methode %1 ist unzulässig.",
                /*1068,64*/ "%1 und %2 können nicht angeglichen werden.",
                /*1069,65*/ "Eigenschaft %1 für %2 nicht gefunden und es ist kein Standardwert vorhanden.",
                /*1070,66*/ "Methode %1 nicht in %2 gefunden",
                /*1071,67*/ "Funktion %1 wurde bereits an %2 gebunden.",
                /*1072,68*/ "Disp_id 0 ist unzulässig.",
                /*1073,69*/ "Die nicht außer Kraft zu setzende Methode %1 wurde wegen doppelter disp_id %2 ersetzt.",
                /*1074,70*/ "Unzulässiger Schreibvorgang in schreibgeschützte Eigenschaft %1 in %2.",
                /*1075,71*/ "Math ist keine Funktion.",
                /*1076,72*/ "Math ist kein Konstruktor.",
                /*1077,73*/ "Unzulässiger Lesevorgang für Eigenschaft mit Lesezugriff %1 in %2.",
                /*1078,74*/ "Unzulässige Opcode/Multiname-Kombination: %1<%2>.",
                /*1079,75*/ "Native Methoden sind in geladenem Code nicht zulässig.",
                /*1080,76*/ "Unzulässiger Wert für Namespace.",
                /*1081,77*/ "Eigenschaft %1 in %2 nicht gefunden und es ist kein Standardwert vorhanden.",
                /*1082,78*/ "Es wurde kein Standard-Namespace festgelegt.",
                /*1083,79*/ "Das Präfix \"%1\" für Element \"%2\" ist nicht gebunden.",
                /*1084,80*/ "Element oder Attribut (\"%1\") stimmt nicht mit QName-Produktion überein: QName::=(NCName':')?NCName.",
                /*1085,81*/ "Der Elementtyp \"%1\" muss durch das entsprechende Schluss-Tag \"</%2>\" abgeschlossen werden.",
                /*1086,82*/ "Die %1-Methode kann nur für Listen mit einem Element verwendet werden.",
                /*1087,83*/ "Die Zuweisung zu indizierter XML ist nicht zulässig.",
                /*1088,84*/ "Das Markup im Dokument nach dem Stammelement muss logisch aufgebaut sein.",
                /*1089,85*/ "Die Zuweisung zu Listen mit mehreren Elementen wird nicht unterstützt.",
                /*1090,86*/ "XML-Parserfehler: Element ist fehlerhaft.",
                /*1091,87*/ "XML-Parserfehler: Nicht abgeschlossener CDATA-Abschnitt.",
                /*1092,88*/ "XML-Parserfehler: Nicht abgeschlossene XML-Deklaration.",
                /*1093,89*/ "XML-Parserfehler: Nicht abgeschlossene DOCTYPE-Deklaration.",
                /*1094,90*/ "XML-Parserfehler: Nicht abgeschlossener Kommentar.",
                /*1095,91*/ "XML-Parserfehler: Nicht abgeschlossenes Attribut.",
                /*1096,92*/ "XML-Parserfehler: Nicht abgeschlossenes Element.",
                /*1097,93*/ "XML-Parserfehler: Nicht abgeschlossene Verarbeitungsanweisung.",
                /*1098,94*/ "Unzulässiges Präfix %1 für Nicht-Namespace.",
                /*1100,95*/ "Es können keine Flags angegeben werden, wenn ein RegExp aus einem anderen konstruiert wird.",
                /*1101,96*/ "Methode %1 mit unbekannten Gültigkeitsbereich kann nicht überprüft werden.",
                /*1102,97*/ "Unzulässiger Standardwert für Typ %1.",
                /*1103,98*/ "Klasse %1 kann die letzte Basisklasse nicht erweitern.",
                /*1104,99*/ "Attribut \"%1\" wurde bereits für Element \"%2\" spezifiziert.",
                /*1107,100*/ "Die ABC-Daten sind beschädigt, versuchtes Lesen außerhalb des gültigen Bereichs.",
                /*1108,101*/ "Der Opcode OP_newclass wurde mit der falschen Basisklasse verwendet.",
                /*1109,102*/ "Versuchter direkter Aufruf der nicht gebundenen Funktion %1 von Methode %2.",
                /*1110,103*/ "%1 kann nicht %2 erweitern.",
                /*1111,104*/ "%1 kann nicht %2 implementieren.",
                /*1112,105*/ "Nicht übereinstimmende Argumentzählung für Klassenumwandlung.  1 erwartet, %1 erhalten.",
                /*1113,106*/ "OP_newactivation wurde ohne Flag NEED_ACTIVATION in Methode verwendet.",
                /*1114,107*/ "OP_getglobalslot oder OP_setglobalslot ohne globalen Gültigkeitsbereich verwendet.",
                /*1115,108*/ "%1 ist kein Konstruktor.",
                /*1116,109*/ "zweites Argument für Function.prototype.apply muss ein Array sein.",
                /*1117,110*/ "Ungültiger XML-Name: %1.",
                /*1118,111*/ "Unzulässige zyklische Schleife zwischen Knoten.",
                /*1119,112*/ "Delete-Operator mit Operand vom Typ %1 wird nicht unterstützt.",
                /*1120,113*/ "Eigenschaft %1 in %2 kann nicht gelöscht werden.",
                /*1121,114*/ "Methode %1 verfügt über doppelten Hauptteil.",
                /*1122,115*/ "Der Hauptteil der Schnittstellenmethode %1 ist unzulässig.",
                /*1123,116*/ "Filter-Operator wird für Typ %1 nicht unterstützt.",
                /*1124,117*/ "Für OP_hasnext2 müssen object und index verschiedene Register sein.",
                /*1500,118*/ "Fehler beim Öffnen von Datei %1.",
                /*1501,119*/ "Fehler beim Schreiben in Datei %1.",
                /*1502,120*/ "Ein Skript wurde länger als die Standard-Timeout-Zeit von 15 Sekunden ausgeführt.",
                /*1503,121*/ "Ein Skript konnte nach 30 Sekunden nicht abgeschlossen werden und wurde beendet.",
                /*1504,122*/ "Dateiende.",
                /*1505,123*/ "Der String-Index %1 liegt außerhalb des zulässigen Bereichs; muss im Bereich %2 bis %3 liegen.",
                /*1506,124*/ "Der angegebene Bereich ist ungültig.",
                /*1507,125*/ "Argument %1 kann nicht null sein.",
                /*1508,126*/ "Der angegebene Wert für Argument %1 ist ungültig.",
                /*1509,127*/ "Fehler beim Dekomprimieren der Daten.",
                /*1510,128*/ "Wenn das callback-Argument eine Methode einer Klasse ist, muss das optionale this-Argument null sein."
            },
                // es
            {
                /*1000,0*/ "El sistema no tiene memoria disponible.",
                /*1001,1*/ "El método %1 no se ha implementado.",
                /*1002,2*/ "El argumento de precisión debe estar entre %2 y %3; %1 no es válido.",
                /*1003,3*/ "El argumento de base debe estar entre 2 y 36; se obtuvo %1.",
                /*1004,4*/ "Se invocó el método %1 en un objeto no compatible.",
                /*1005,5*/ "El índice de matriz no es un entero positivo (%1).",
                /*1006,6*/ "%1 no es una función.",
                /*1007,7*/ "Se intentó crear una instancia en un tipo no constructor.",
                /*1008,8*/ "%1 es ambiguo; se encontró más de una vinculación coincidente.",
                /*1009,9*/ "No se puede acceder a una propiedad o a un método de una referencia a un objeto nulo.",
                /*1010,10*/ "Un término no está definido y no tiene propiedades.",
                /*1011,11*/ "Código de operación %2 no válido en el desplazamiento %3 del método %1.",
                /*1012,12*/ "La última instrucción superó el tamaño de código.",
                /*1013,13*/ "No se puede llamar a OP_findproperty cuando el valor de scopeDepth es 0.",
                /*1014,14*/ "No se encontró la clase %1.",
                /*1015,15*/ "El método %1 no puede establecer el espacio de nombres xml predeterminado",
                /*1016,16*/ "Operador de descendientes (..) no admitido en el tipo %1.",
                /*1017,17*/ "Desbordamiento de la pila en el ámbito.",
                /*1018,18*/ "Subdesbordamiento de la pila en el ámbito.",
                /*1019,19*/ "Getscopeobject %1 está fuera de los límites.",
                /*1020,20*/ "El código no puede sobrepasar el final de un método.",
                /*1021,21*/ "Hay al menos un destino de rama en una instrucción no válida del método.",
                /*1022,22*/ "El tipo Void sólo se puede utilizar como tipo de devolución de función.",
                /*1023,23*/ "Desbordamiento de la pila.",
                /*1024,24*/ "Subdesbordamiento de la pila.",
                /*1025,25*/ "Se obtuvo acceso a un registro no válido %1.",
                /*1026,26*/ "La ranura %1 supera el valor slotCount=%2 de %3.",
                /*1027,27*/ "Method_info %1 supera el valor method_count=%2.",
                /*1028,28*/ "Disp_id %1 supera el valor max_disp_id=%2 de %3.",
                /*1029,29*/ "Disp_id %1 no está definido en %2.",
                /*1030,30*/ "Profundidad de pila desequilibrada. %1 != %2.",
                /*1031,31*/ "Profundidad de ámbito desequilibrada. %1 != %2.",
                /*1032,32*/ "El índice Cpool %1 está fuera del rango %2.",
                /*1033,33*/ "El tipo de la entrada Cpool %1 es incorrecto.",
                /*1034,34*/ "Error de conversión forzada: no se puede convertir %1 en %2.",
                /*1035,35*/ "Expresión super no válida en el método %1.",
                /*1037,36*/ "No se puede asignar a un método %1 en %2.",
                /*1038,37*/ "%1 ya está definido.",
                /*1039,38*/ "No se puede verificar el método hasta que se haga referencia a él.",
                /*1040,39*/ "A la derecha de instanceof debe haber una clase o una función.",
                /*1041,40*/ "A la derecha del operador debe haber una clase.",
                /*1042,41*/ "No es un archivo ABC.  major_version=%1 minor_version=%2.",
                /*1043,42*/ "code_length=%1 no válido.",
                /*1044,43*/ "MethodInfo-%1 no admite flags=%2.",
                /*1045,44*/ "traits kind=%1 no admitido.",
                /*1046,45*/ "Referencia a MethodInfo-%1 antes de la definición.",
                /*1047,46*/ "No se encontró un punto de entrada.",
                /*1049,47*/ "Los objetos de prototipo deben ser objetos vanilla.",
                /*1050,48*/ "No se puede convertir %1 en primitiva.",
                /*1051,49*/ "Acceso de vinculación a %1 en tiempo de compilación no válido.",
                /*1052,50*/ "URI no válido pasado a la función %1.",
                /*1053,51*/ "Sustitución no válida de %1 en %2.",
                /*1054,52*/ "Rango o desplazamientos de destino no válidos en el controlador de excepciones.",
                /*1056,53*/ "No se puede crear la propiedad %1 en %2.",
                /*1057,54*/ "%1 sólo puede contener métodos.",
                /*1058,55*/ "Tipo de operando no válido: %1 debe ser %2.",
                /*1059,56*/ "Referencia a ClassInfo-%1 antes de la definición.",
                /*1060,57*/ "ClassInfo %1 supera el valor de class_count=%2.",
                /*1061,58*/ "No se puede convertir el valor %1 en %2 sin perder precisión.",
                /*1063,59*/ "Discordancia del recuento de argumentos en %1. Se esperaba %2 y se obtuvo %3.",
                /*1064,60*/ "No se puede llamar al método %1 como constructor.",
                /*1065,61*/ "No se ha definido la variable %1.",
                /*1066,62*/ "No se admite la forma function('cuerpo de función').",
                /*1067,63*/ "El cuerpo del método nativo %1 no es válido.",
                /*1068,64*/ "%1 y %2 no pueden igualarse.",
                /*1069,65*/ "No se encontró la propiedad %1 en %2 y no hay ningún valor predeterminado.",
                /*1070,66*/ "No se encontró el método %1 en %2",
                /*1071,67*/ "La función %1 ya se ha vinculado a %2.",
                /*1072,68*/ "Disp_id 0 no es válido.",
                /*1073,69*/ "Se reemplazó el método %1 de no sustitución por la duplicación de disp_id %2.",
                /*1074,70*/ "Lectura no permitida de la propiedad %1 de sólo lectura en %2.",
                /*1075,71*/ "Math no es una función.",
                /*1076,72*/ "Math no es un constructor.",
                /*1077,73*/ "Lectura no permitida de la propiedad %1 de sólo escritura en %2.",
                /*1078,74*/ "Combinación no válida de código de operación y nombre múltiple: %1<%2>.",
                /*1079,75*/ "No se permiten métodos nativos en el código cargado.",
                /*1080,76*/ "Valor de espacio de nombres no válido.",
                /*1081,77*/ "No se encuentra la propiedad %1 en %2 y no hay ningún valor predeterminado.",
                /*1082,78*/ "No se ha establecido ningún espacio de nombres predeterminado.",
                /*1083,79*/ "El prefijo \"%1\" del elemento \"%2\" no está vinculado.",
                /*1084,80*/ "El elemento o el atributo (\"%1\") no coincide con la regla de producción de QName: QName::=(NCName':')?NCName.",
                /*1085,81*/ "El tipo de elemento \"%1\" debe terminar con la etiqueta final \"</%2>\" correspondiente.",
                /*1086,82*/ "El método %1 sólo funciona en listas que contienen un elemento.",
                /*1087,83*/ "No se permite la asignación a XML indexado.",
                /*1088,84*/ "El marcado del documento que sigue al elemento raíz debe estar bien formado.",
                /*1089,85*/ "No se admite la asignación a listas con más de un elemento.",
                /*1090,86*/ "Error del analizador XML: elemento mal formado.",
                /*1091,87*/ "Error del analizador XML: sección CDATA sin terminar.",
                /*1092,88*/ "Error del analizador XML: declaración XML sin terminar.",
                /*1093,89*/ "Error del analizador XML: declaración DOCTYPE sin terminar.",
                /*1094,90*/ "Error del analizador XML: comentario sin terminar.",
                /*1095,91*/ "Error del analizador XML: atributo sin terminar.",
                /*1096,92*/ "Error del analizador XML: elemento sin terminar.",
                /*1097,93*/ "Error del analizador XML: instrucción de procesamiento sin terminar.",
                /*1098,94*/ "Prefijo %1 no válido sin un espacio de nombres.",
                /*1100,95*/ "No se pueden proporcionar indicadores cuando se genera una expresión regular a partir de otra.",
                /*1101,96*/ "No se puede verificar el método %1 con ámbito desconocido.",
                /*1102,97*/ "Valor predeterminado no válido para el tipo %1.",
                /*1103,98*/ "La clase %1 no puede ampliar la clase base final.",
                /*1104,99*/ "El atributo \"%1\" ya se especificó para el elemento \"%2\".",
                /*1107,100*/ "Los datos ABC están dañados; intentan leer fuera de los límites.",
                /*1108,101*/ "El código de operación OP_newclass se utilizó con la clase base incorrecta.",
                /*1109,102*/ "Intento de llamada directa a la función abierta %1 desde el método %2.",
                /*1110,103*/ "%1 no puede ampliar %2.",
                /*1111,104*/ "%1 no puede implementar %2.",
                /*1112,105*/ "Discordancia del recuento de argumentos en coerción de clase.  Se esperaba 1; se obtuvo %1.",
                /*1113,106*/ "Se utilizó OP_newactivation en el método sin el indicador NEED_ACTIVATION.",
                /*1114,107*/ "Se utilizaron OP_getglobalslot u OP_setglobalslot sin ámbito global.",
                /*1115,108*/ "%1 no es un constructor.",
                /*1116,109*/ "el segundo argumento de Function.prototype.apply debe ser una matriz.",
                /*1117,110*/ "Nombre XML no válido: %1.",
                /*1118,111*/ "Bucle cíclico no válido entre nodos.",
                /*1119,112*/ "El operador de eliminación no se admite con el operando de tipo %1.",
                /*1120,113*/ "No se puede eliminar la propiedad %1 en %2.",
                /*1121,114*/ "El cuerpo del método %1 está duplicado.",
                /*1122,115*/ "El cuerpo del método de interfaz %1 no es válido.",
                /*1123,116*/ "Operador de filtro no admitido en el tipo %1.",
                /*1124,117*/ "OP_hasnext2 requiere que el objeto y el índice sean registros diferentes.",
                /*1500,118*/ "Error al abrir el archivo %1.",
                /*1501,119*/ "Error al escribir en el archivo %1.",
                /*1502,120*/ "El tiempo de ejecución del script ha superado el tiempo de espera predeterminado de 15 segundos.",
                /*1503,121*/ "No se salió del script en 30 segundos y se ha cerrado.",
                /*1504,122*/ "Final del archivo.",
                /*1505,123*/ "El índice de cadena %1 está fuera de los límites; debe estar en el rango %2-%3.",
                /*1506,124*/ "El rango especificado no es válido.",
                /*1507,125*/ "El argumento %1 no puede ser null.",
                /*1508,126*/ "El valor especificado para el argumento %1 no es válido.",
                /*1509,127*/ "Se produjo un error al descomprimir los datos.",
                /*1510,128*/ "Si el argumento de la función de repetición de llamada es un método de la clase, el argumento opcional debe ser null."
            },
                // fr
            {
                /*1000,0*/ "La mémoire du système est saturée.",
                /*1001,1*/ "La méthode %1 n'est pas mise en oeuvre.",
                /*1002,2*/ "L'argument precision doit être compris entre %2 et %3. %1 n'est pas valide.",
                /*1003,3*/ "L'argument radix doit être compris entre 2 et 36. %1 détecté.",
                /*1004,4*/ "La méthode %1 a été invoquée pour un objet non compatible.",
                /*1005,5*/ "L'index du tableau n'est pas un entier positif (%1).",
                /*1006,6*/ "%1 n'est pas une fonction.",
                /*1007,7*/ "Tentative d'instanciation sur un élément non constructeur.",
                /*1008,8*/ "%1 est ambigu. Plusieurs liaisons correspondantes détectées.",
                /*1009,9*/ "Il est impossible d'accéder à la propriété ou à la méthode d'une référence d'objet nul.",
                /*1010,10*/ "Un terme n'est pas défini et n'a pas de propriété.",
                /*1011,11*/ "La méthode %1 contenait un opcode %2 non valide au décalage %3.",
                /*1012,12*/ "La dernière instruction dépassait la taille du code.",
                /*1013,13*/ "Impossible d'appeler OP_findproperty si scopeDepth correspond à 0.",
                /*1014,14*/ "La classe %1 est introuvable.",
                /*1015,15*/ "La méthode %1 ne peut pas définir l'espace de nom xml par défaut",
                /*1016,16*/ "L'opérateur Descendants (..) n'est pas pris en charge sur le type %1.",
                /*1017,17*/ "Il s'est produit un débordement de la pile de domaine.",
                /*1018,18*/ "Il s'est produit un débordement négatif de la pile de domaine.",
                /*1019,19*/ "Getscopeobject %1 sort des limites.",
                /*1020,20*/ "Le code ne doit pas dépasser la fin d'une méthode.",
                /*1021,21*/ "Au moins une cible branche ne figurait pas dans une instruction valide de la méthode.",
                /*1022,22*/ "Void est réservé aux types de renvoi de fonction.",
                /*1023,23*/ "Il s'est produit un débordement de pile.",
                /*1024,24*/ "Il s'est produit un débordement négatif de pile.",
                /*1025,25*/ "Il s'est produit un accès à un registre %1 non valide.",
                /*1026,26*/ "L'emplacement %1 dépasse slotCount=%2 sur %3.",
                /*1027,27*/ "Method_info %1 dépasse method_count=%2.",
                /*1028,28*/ "Disp_id %1 dépasse max_disp_id=%2 sur %3.",
                /*1029,29*/ "Disp_id %1 n'est pas défini sur %2.",
                /*1030,30*/ "La profondeur de la pile n'est pas équilibrée. %1 != %2.",
                /*1031,31*/ "La profondeur du domaine n'est pas équilibrée. %1 != %2.",
                /*1032,32*/ "L'index Cpool %1 est en dehors des limites %2.",
                /*1033,33*/ "Le type de l'entrée Cpool  %1 est incorrect.",
                /*1034,34*/ "Echec de la contrainte de type : conversion de %1 en %2 impossible.",
                /*1035,35*/ "Super expression illégale détectée dans la méthode %1.",
                /*1037,36*/ "Affectation impossible à une méthode %1 sur %2.",
                /*1038,37*/ "%1 est déjà défini.",
                /*1039,38*/ "Impossible de vérifier la méthode tant qu'elle n'est pas référencée.",
                /*1040,39*/ "L'expression à droite de instanceof doit être une classe ou une fonction.",
                /*1041,40*/ "L'expression à droite de l'opérateur doit être une classe.",
                /*1042,41*/ "Il ne s'agit pas d'un fichier ABC.  major_version=%1 minor_version=%2.",
                /*1043,42*/ "code_length non valide=%1.",
                /*1044,43*/ "Indicateurs MethodInfo-%1 non pris en charge=%2.",
                /*1045,44*/ "Type de trait non pris en charge=%1.",
                /*1046,45*/ "MethodInfo-%1 référencé avant la définition.",
                /*1047,46*/ "Aucun point d'entrée n'a été détecté.",
                /*1049,47*/ "Les objets prototype doivent être des objets vanille.",
                /*1050,48*/ "Impossible de convertir %1 en primitive.",
                /*1051,49*/ "Accès anticipé illégal de liaison à %1.",
                /*1052,50*/ "URI non valide transmis à la fonction %1.",
                /*1053,51*/ "Remplacement illégal de %1 dans %2.",
                /*1054,52*/ "Plage ou décalages cibles illégaux dans le gestionnaire d'exceptions.",
                /*1056,53*/ "Impossible de créer la propriété %1 sur %2.",
                /*1057,54*/ "%1 ne peut contenir que des méthodes.",
                /*1058,55*/ "Type d'opérande illégal : %1 doit correspondre à %2.",
                /*1059,56*/ "ClassInfo-%1 est référencé avant la définition.",
                /*1060,57*/ "ClassInfo %1 dépasse class_count=%2.",
                /*1061,58*/ "La valeur %1 ne peut pas être convertie en %2 sans perte de précision.",
                /*1063,59*/ "Non-correspondance du nombre d'arguments sur %1. %2 prévu(s), %3 détecté(s).",
                /*1064,60*/ "Impossible d'appeler la méthode %1 en tant que constructeur.",
                /*1065,61*/ "La variable %1 n'est pas définie.",
                /*1066,62*/ "La fonction('corps de fonction') form n'est pas prise en charge.",
                /*1067,63*/ "La méthode native %1 contient un corps de méthode illégal.",
                /*1068,64*/ "Impossible de réconcilier %1 et %2.",
                /*1069,65*/ "La propriété %1 est introuvable sur %2 et il n'existe pas de valeur par défaut.",
                /*1070,66*/ "La méthode %1 est introuvable sur %2",
                /*1071,67*/ "La fonction %1 a déjà été liée à %2.",
                /*1072,68*/ "Disp_id 0 est illégal.",
                /*1073,69*/ "La méthode de non-remplacement %1 a été supplantée en raison du doublon disp_id %2.",
                /*1074,70*/ "Ecriture illégale dans une propriété en lecture seule %1 sur %2.",
                /*1075,71*/ "Math n'est pas une fonction.",
                /*1076,72*/ "Math n'est pas un constructeur.",
                /*1077,73*/ "Lecture illégale d'une propriété en écriture seule %1 sur %2.",
                /*1078,74*/ "Combinaison opcode/multiname illégale : %1<%2>.",
                /*1079,75*/ "Les méthodes natives ne sont pas autorisées dans le code chargé.",
                /*1080,76*/ "La valeur de l'espace de nom est illégale.",
                /*1081,77*/ "La propriété %1 est introuvable sur %2 et il n'existe pas de valeur par défaut.",
                /*1082,78*/ "Aucun espace de nom par défaut n'a été défini.",
                /*1083,79*/ "Le préfixe \"%1\" associé à l'élément \"%2\" n'est pas lié.",
                /*1084,80*/ "L'élément ou l'attribut (\"%1\") ne correspond pas à la production QName : QName::=(NCName':')?NCName.",
                /*1085,81*/ "Le type d'élément \"%1\" doit se terminer par la balise de fin correspondante \"</%2>\".",
                /*1086,82*/ "La méthode %1 ne fonctionne qu'avec les listes composées d'un seul élément.",
                /*1087,83*/ "L'affectation à un élément XML indexé n'est pas autorisée.",
                /*1088,84*/ "Le marquage du document après l'élément root doit être composé correctement.",
                /*1089,85*/ "L'affectation à des listes composées de plus d'un élément n'est pas prise en charge.",
                /*1090,86*/ "Echec de l'analyse XML : le format de l'élément est incorrect.",
                /*1091,87*/ "Echec de l'analyse XML : Section CDATA non terminée.",
                /*1092,88*/ "Echec de l'analyse XML : Déclaration XML non terminée.",
                /*1093,89*/ "Echec de l'analyse XML : Déclaration DOCTYPE non terminée.",
                /*1094,90*/ "Echec de l'analyse XML : Commentaire non terminé.",
                /*1095,91*/ "Echec de l'analyse XML : Attribut non terminé.",
                /*1096,92*/ "Echec de l'analyse XML : Elément non terminé.",
                /*1097,93*/ "Echec de l'analyse XML : Instruction de traitement non terminée.",
                /*1098,94*/ "Préfixe %1 illégal sans espace de nom.",
                /*1100,95*/ "Impossible de fournir des indicateurs lors de la construction d'un RegExp à partir d'un autre.",
                /*1101,96*/ "Impossible de vérifier la méthode %1 si le domaine est inconnu.",
                /*1102,97*/ "Valeur par défaut illégale pour le type %1.",
                /*1103,98*/ "La classe %1 ne peut pas étendre la classe de base finale.",
                /*1104,99*/ "L'attribut \"%1\" a déjà été spécifié pour l'élément \"%2\".",
                /*1107,100*/ "Les données ABC sont corrompues, tentative de lecture en dehors des limites.",
                /*1108,101*/ "L'élément opcode OP_newclass a été utilisé avec une classe de base incorrecte.",
                /*1109,102*/ "Tentative d'appel direct d'une fonction non liée %1 à partir de la méthode %2.",
                /*1110,103*/ "%1 ne peut pas étendre %2.",
                /*1111,104*/ "%1 ne peut pas mettre en oeuvre %2.",
                /*1112,105*/ "Non-concordance du nombre d'arguments pour contrainte de classe.  1 prévu, %1 détecté(s).",
                /*1113,106*/ "OP_newactivation utilisé dans la méthode sans indicateur NEED_ACTIVATION.",
                /*1114,107*/ "OP_getglobalslot ou OP_setglobalslot utilisé sans domaine global.",
                /*1115,108*/ "%1 n'est pas un constructeur.",
                /*1116,109*/ "Le deuxième argument transmis à Function.prototype.apply doit être un tableau.",
                /*1117,110*/ "Nom XML non valide : %1.",
                /*1118,111*/ "Boucle cyclique illégale entre noeuds.",
                /*1119,112*/ "L'opérateur delete n'est pas pris en charge avec une opérande de type %1.",
                /*1120,113*/ "Impossible de supprimer la propriété %1 sur %2.",
                /*1121,114*/ "La méthode %1 contient un corps de méthode dupliqué.",
                /*1122,115*/ "La méthode d'interface %1 contient un corps de méthode illégal.",
                /*1123,116*/ "L'opérateur Filter n'est pas pris en charge sur le type %1.",
                /*1124,117*/ "OP_hasnext2 requiert que l'objet et l'index soient des registres distincts.",
                /*1500,118*/ "Une erreur s’est produite lors de l’ouverture du fichier %1.",
                /*1501,119*/ "Une erreur s’est produite lors de l’écriture dans le fichier %1.",
                /*1502,120*/ "La durée d'exécution d'un script excède le délai par défaut (15 secondes).",
                /*1503,121*/ "Un script ne s'est pas terminé après 30 secondes et a été arrêté.",
                /*1504,122*/ "Fin du fichier.",
                /*1505,123*/ "L'index de chaîne %1 sort des limites. Il doit être compris entre %2 et %3.",
                /*1506,124*/ "La plage indiquée n'est pas valide.",
                /*1507,125*/ "L’argument %1 ne doit pas être null.",
                /*1508,126*/ "La valeur indiquée pour l’argument %1 n’est pas valide.",
                /*1509,127*/ "Une erreur s'est produite lors de la décompression des données.",
                /*1510,128*/ "Lorsque l’argument du rappel correspond à une méthode de classe, l’argument facultatif 'this' doit être null."
            },
                // it
            {
                /*1000,0*/ "Memoria del sistema esaurita.",
                /*1001,1*/ "Il metodo %1 non è implementato.",
                /*1002,2*/ "L'argomento precision deve essere compreso tra %2 e %3; %1 non è un valore valido.",
                /*1003,3*/ "L'argomento radix deve essere compreso tra 2 e 36; valore ricevuto: %1.",
                /*1004,4*/ "È stato richiamato il metodo %1 su un oggetto incompatibile.",
                /*1005,5*/ "L'indice della matrice non è un numero intero positivo (%1).",
                /*1006,6*/ "%1 non è una funzione.",
                /*1007,7*/ "Tentativo di creazione di istanza su un elemento diverso da un costruttore.",
                /*1008,8*/ "%1 è ambiguo; trovata più di un'associazione corrispondente.",
                /*1009,9*/ "Impossibile accedere a una proprietà o a un metodo di un riferimento oggetto null.",
                /*1010,10*/ "Un termine risulta undefined e non ha proprietà.",
                /*1011,11*/ "Il metodo %1  conteneva un opcode non valido (%2 ) in corrispondenza dell'offset %3.",
                /*1012,12*/ "L'ultima istruzione ha superato la dimensione del codice.",
                /*1013,13*/ "Impossibile chiamare OP_findproperty quando scopeDepth è uguale a 0.",
                /*1014,14*/ "Impossibile trovare la classe %1.",
                /*1015,15*/ "Il metodo %1 non può impostare lo spazio dei nomi xml predefinito",
                /*1016,16*/ "Operatore Descendants (..) non supportato nel tipo %1.",
                /*1017,17*/ "Si è verificato un overflow dello stack per l'area di validità.",
                /*1018,18*/ "Si è verificato un underflow dello stack per l'area di validità.",
                /*1019,19*/ "Getscopeobject %1 è fuori dei limiti.",
                /*1020,20*/ "Il codice non può superare la fine di un metodo.",
                /*1021,21*/ "Almeno una destinazione del ramo non si riferisce a un'istruzione valida nel metodo.",
                /*1022,22*/ "Il tipo void può essere utilizzato solo come tipo restituito della funzione.",
                /*1023,23*/ "Si è verificato un overflow dello stack.",
                /*1024,24*/ "Si è verificato un underflow dello stack.",
                /*1025,25*/ "È stato eseguito l'accesso a un registro %1 non valido.",
                /*1026,26*/ "Lo slot %1 supera slotCount=%2 di %3.",
                /*1027,27*/ "Method_info %1 supera method_count=%2.",
                /*1028,28*/ "Disp_id %1 supera max_disp_id=%2 di %3.",
                /*1029,29*/ "Disp_id %1 non è definito su %2.",
                /*1030,30*/ "Profondità dello stack non bilanciata. %1 != %2.",
                /*1031,31*/ "Profondità dell'area di validità non bilanciata. %1 != %2.",
                /*1032,32*/ "L'indice Cpool %1 è fuori intervallo %2.",
                /*1033,33*/ "La voce Cpool %1 è di tipo errato.",
                /*1034,34*/ "Assegnazione di tipo forzata non riuscita: impossibile convertire %1 in %2.",
                /*1035,35*/ "Trovata super espressione non valida nel metodo %1.",
                /*1037,36*/ "Impossibile assegnare a un metodo %1 su %2.",
                /*1038,37*/ "%1 è già definita.",
                /*1039,38*/ "Impossibile verificare un metodo finché non viene utilizzato come riferimento.",
                /*1040,39*/ "L'espressione a destra di instanceof deve essere una classe o una funzione.",
                /*1041,40*/ "L'espressione a destra dell'operatore deve essere una classe.",
                /*1042,41*/ "Non è un file ABC.  major_version=%1 minor_version=%2.",
                /*1043,42*/ "Valore non valido code_length=%1.",
                /*1044,43*/ "MethodInfo-%1 non supportato flags=%2.",
                /*1045,44*/ "Tipo traits non supportato=%1.",
                /*1046,45*/ "MethodInfo-%1 utilizzato come riferimento prima della definizione.",
                /*1047,46*/ "Punto di entrata non trovato.",
                /*1049,47*/ "Gli oggetti prototype devono essere oggetti vanilla.",
                /*1050,48*/ "Impossibile convertire %1 in dato di base.",
                /*1051,49*/ "Accesso in associazione a %1 prematuro e non valido.",
                /*1052,50*/ "URI non valido passato alla funzione %1.",
                /*1053,51*/ "Sostituzione non valida di %1 in %2.",
                /*1054,52*/ "Intervallo non valido oppure offset di destinazione nel gestore eccezioni.",
                /*1056,53*/ "Impossibile creare la proprietà %1 su %2.",
                /*1057,54*/ "%1 può contenere solo metodi.",
                /*1058,55*/ "Tipo di operando non valido: %1 deve essere %2.",
                /*1059,56*/ "ClassInfo-%1 è utilizzato come riferimento prima della definizione.",
                /*1060,57*/ "ClassInfo %1 supera class_count=%2.",
                /*1061,58*/ "Impossibile convertire il valore %1 in %2 senza perdere precisione.",
                /*1063,59*/ "Incongruenza nel conteggio degli argomenti su %1. Era atteso %2, è stato ricevuto %3.",
                /*1064,60*/ "Impossibile chiamare il metodo %1 come funzione di costruzione.",
                /*1065,61*/ "La variabile %1 non è definita.",
                /*1066,62*/ "La forma funzione('corpo funzione') non è supportata.",
                /*1067,63*/ "Corpo del metodo nativo %1 non valido.",
                /*1068,64*/ "Impossibile riconciliare %1 e %2.",
                /*1069,65*/ "Impossibile trovare la proprietà %1 su %2 e nessun valore predefinito presente.",
                /*1070,66*/ "Metodo %1 non trovato su %2",
                /*1071,67*/ "La funzione %1 è già stata associata a %2.",
                /*1072,68*/ "Disp_id 0 non è valido.",
                /*1073,69*/ "Metodo non-override %1 sostituito a causa di disp_id %2 duplicati.",
                /*1074,70*/ "Scrittura non valida della proprietà di sola lettura %1 su %2.",
                /*1075,71*/ "Math non è una funzione.",
                /*1076,72*/ "Math non è una funzione di costruzione.",
                /*1077,73*/ "Lettura non valida della proprietà di sola scrittura %1 su %2.",
                /*1078,74*/ "Combinazione opcode/multiname non valida: %1<%2>.",
                /*1079,75*/ "Metodi nativi non consentiti nel codice caricato.",
                /*1080,76*/ "Valore non valido per namespace.",
                /*1081,77*/ "Impossibile trovare la proprietà %1 su %2 e nessun valore predefinito presente.",
                /*1082,78*/ "Nessuno spazio dei nomi predefinito impostato.",
                /*1083,79*/ "Il prefisso \"%1\" per l'elemento \"%2\" non è associato.",
                /*1084,80*/ "L'elemento o l'attributo (\"%1\") non corrisponde alla produzione di QName: QName::=(NCName':')?NCName.",
                /*1085,81*/ "Il tipo di elemento \"%1\" deve terminare con il tag di fine corrispondente \"</%2>\".",
                /*1086,82*/ "Il metodo %1 funziona solo sugli elenchi che contengono una sola voce.",
                /*1087,83*/ "L'assegnazione all'XML indicizzato non è consentita.",
                /*1088,84*/ "Il codice nel documento successivo all'elemento principale deve essere formato correttamente.",
                /*1089,85*/ "Non è supportata l'assegnazione agli elenchi con più di una voce.",
                /*1090,86*/ "Errore nell'analisi sintattica XML: l'elemento non è formato correttamente.",
                /*1091,87*/ "Errore nell'analisi sintattica XML: sezione CDATA non terminata.",
                /*1092,88*/ "Errore nell'analisi sintattica XML: dichiarazione XML non terminata.",
                /*1093,89*/ "Errore nell'analisi sintattica XML: dichiarazione DOCTYPE non terminata.",
                /*1094,90*/ "Errore nell'analisi sintattica XML: commento non terminato.",
                /*1095,91*/ "Errore nell'analisi sintattica XML: attributo non terminato.",
                /*1096,92*/ "Errore nell'analisi sintattica XML: elemento non terminato.",
                /*1097,93*/ "Errore nell'analisi sintattica XML: istruzione di elaborazione non terminata.",
                /*1098,94*/ "Prefisso %1 non valido per no namespace.",
                /*1100,95*/ "Impossibile fornire i flag quando si costruisce un RegExp da un altro.",
                /*1101,96*/ "Impossibile verificare il metodo %1 con ambito di validità sconosciuto.",
                /*1102,97*/ "Valore predefinito non valido per il tipo %1.",
                /*1103,98*/ "La classe %1 non può estendere la classe base finale.",
                /*1104,99*/ "L'attributo \"%1\" è già stato specificato per l'elemento \"%2\".",
                /*1107,100*/ "I dati ABC sono danneggiati; tentativo di leggere fuori dei limiti.",
                /*1108,101*/ "L'opcode OP_newclass è stato utilizzato con una classe base non corretta.",
                /*1109,102*/ "Tentativo di chiamare direttamente la funzione non associata %1 dal metodo %2.",
                /*1110,103*/ "%1 non può estendere %2.",
                /*1111,104*/ "%1 non può implementare %2.",
                /*1112,105*/ "Incongruenza nel conteggio degli argomenti nell'assegnazione forzata della classe.  Era atteso 1, è stato ricevuto %1.",
                /*1113,106*/ "OP_newactivation utilizzato nel metodo senza flag NEED_ACTIVATION.",
                /*1114,107*/ "OP_getglobalslot o OP_setglobalslot utilizzato senza area di validità globale.",
                /*1115,108*/ "%1 non è una funzione di costruzione.",
                /*1116,109*/ "Il secondo argomento di Function.prototype.apply deve essere un array.",
                /*1117,110*/ "Nome XML non valido: %1.",
                /*1118,111*/ "Ripetizione ciclica non valida tra i nodi.",
                /*1119,112*/ "Operatore Delete non supportato con un operando di tipo %1.",
                /*1120,113*/ "Impossibile eliminare la proprietà %1 su %2.",
                /*1121,114*/ "Corpo duplicato nel metodo %1.",
                /*1122,115*/ "Corpo non valido nel metodo di interfaccia %1.",
                /*1123,116*/ "Operatore Filter non supportato nel tipo %1.",
                /*1124,117*/ "OP_hasnext2 richiede che oggetto e indice siano registri distinti.",
                /*1500,118*/ "Errore durante l'apertura del file %1.",
                /*1501,119*/ "Errore durante la scrittura del file %1.",
                /*1502,120*/ "Uno script è stato eseguito per più del periodo di timeout predefinito di 15 secondi.",
                /*1503,121*/ "Uno script non è uscito dopo 30 secondi ed è stato terminato.",
                /*1504,122*/ "Fine del file.",
                /*1505,123*/ "L'indice di stringa %1 è fuori dei limiti; deve essere compreso nell'intervallo da %2 a %3.",
                /*1506,124*/ "L'intervallo specificato non è valido.",
                /*1507,125*/ "L'argomento %1 non può essere null.",
                /*1508,126*/ "Il valore specificato per l'argomento %1 non è valido.",
                /*1509,127*/ "Si è verificato un errore durante la decompressione dei dati.",
                /*1510,128*/ "Quando l'argomento callback è il metodo di una classe, l'argomento opzionale this deve essere null."
            },
                // ja
            {
                /*1000,0*/ "システムのメモリ不足です。",
                /*1001,1*/ "メソッド %1 は実装されていません。",
                /*1002,2*/ "精度の引数には %2 ～ %3 の値を指定してください。%1 は不正な値です。",
                /*1003,3*/ "基数の引数には 2 ～ 36 の値を指定してください。%1 は不正な値です。",
                /*1004,4*/ "メソッド %1 が対応していないオブジェクトで呼び出されました。",
                /*1005,5*/ "配列インデックスが正の整数 (%1) ではありません。",
                /*1006,6*/ "%1 は関数ではありません。",
                /*1007,7*/ "コンストラクタ以外にインスタンス化が試行されました。",
                /*1008,8*/ "%1 があいまいです。一致するバインディングが複数見つかりました。",
                /*1009,9*/ "null のオブジェクト参照のプロパティまたはメソッドにアクセスすることはできません。",
                /*1010,10*/ "条件は未定義であり、プロパティがありません。",
                /*1011,11*/ "メソッド %1 に無効な opcode %2 (オフセット %3 内) が含まれています。",
                /*1012,12*/ "最後の命令がコードサイズを超えました。",
                /*1013,13*/ "scopeDepth が 0 である場合、OP_findproperty を呼び出すことはできません。",
                /*1014,14*/ "クラス %1 が見つかりません。",
                /*1015,15*/ "メソッド %1 はデフォルトの xml 名前空間を設定できません",
                /*1016,16*/ "Descendants 演算子 (..) は型 %1 でサポートされていません。",
                /*1017,17*/ "スコープのスタックオーバーフローが発生しました。",
                /*1018,18*/ "スコープのスタックアンダーフローが発生しました。",
                /*1019,19*/ "Getscopeobject %1 が境界外です。",
                /*1020,20*/ "コードがメソッドの末尾からはみ出すことはできません。",
                /*1021,21*/ "最低 1 つのブランチターゲットがメソッドの有効な命令を反映していません。",
                /*1022,22*/ "Void 型は、関数の戻り型としてのみ使用できます。",
                /*1023,23*/ "スタックオーバーフローが発生しました。",
                /*1024,24*/ "スタックアンダーフローが発生しました。",
                /*1025,25*/ "無効なレジスタ %1 がアクセスされました。",
                /*1026,26*/ "スロット %1 が %3 の slotCount=%2 を超えています。",
                /*1027,27*/ "Method_info %1 が method_count=%2 を超えています。",
                /*1028,28*/ "Disp_id %1 が %3 の max_disp_id=%2 を超えています。",
                /*1029,29*/ "Disp_id %1 が %2 に対して未定義です。",
                /*1030,30*/ "スタックの深さがアンバランスです。%1 != %2。",
                /*1031,31*/ "スコープの深さがアンバランスです。%1 != %2。",
                /*1032,32*/ "Cpool のインデックス %1 が %2 の範囲外です。",
                /*1033,33*/ "Cpool のエントリ %1 の型が正しくありません。",
                /*1034,34*/ "強制型変換に失敗しました。%1 を %2 に変換できません。",
                /*1035,35*/ "メソッド %1 で無効な super 式が見つかりました。",
                /*1037,36*/ "%2 のメソッド %1 に代入できません。",
                /*1038,37*/ "%1 は定義済みです。",
                /*1039,38*/ "メソッドは参照されるまで検証できません。",
                /*1040,39*/ "instanceof の右側はクラスまたは関数でなければなりません。",
                /*1041,40*/ "演算子の右側はクラスでなければなりません。",
                /*1042,41*/ "ABC ファイルではありません。major_version=%1 minor_version=%2 です。",
                /*1043,42*/ "code_length=%1 が無効です。",
                /*1044,43*/ "MethodInfo-%1 サポートされていないフラグ =%2。",
                /*1045,44*/ "サポートされていない種類の機能 =%1。",
                /*1046,45*/ "MethodInfo-%1 が定義の前に参照されています。",
                /*1047,46*/ "エントリポイントが見つかりませんでした。",
                /*1049,47*/ "プロトタイプオブジェクトはバニラオブジェクトでなければなりません。",
                /*1050,48*/ "%1 をプリミティブに変換できません。",
                /*1051,49*/ "%1 へのアーリーバインディングアクセスが無効です。",
                /*1052,50*/ "無効な URI が %1 関数に渡されました。",
                /*1053,51*/ "%2 の %1 のオーバーライドが無効です。",
                /*1054,52*/ "例外ハンドラの範囲またはターゲットオフセットが無効です。",
                /*1056,53*/ "%2 のプロパティ %1 を作成できません。",
                /*1057,54*/ "%1 はメソッドしか含むことができません。",
                /*1058,55*/ "無効なオペランド型 :%1 は %2 でなければなりません。",
                /*1059,56*/ "ClassInfo-%1 が定義の前に参照されています。",
                /*1060,57*/ "ClassInfo %1 が class_count=%2 を超えています。",
                /*1061,58*/ "値 %1 を %2 に変換すると精度が失われます。",
                /*1063,59*/ "%1 の引数の数が一致していません。%2 が必要ですが、%3 が指定されました。",
                /*1064,60*/ "メソッド %1 をコンストラクタとして呼び出すことはできません。",
                /*1065,61*/ "変数 %1 は定義されていません。",
                /*1066,62*/ "function('function body') という書式はサポートされていません。",
                /*1067,63*/ "ネイティブメソッド %1 のメソッドボディが無効です。",
                /*1068,64*/ "%1 と %2 は共有できません。",
                /*1069,65*/ "%2 にプロパティ %1 が見つからず、デフォルト値もありません。",
                /*1070,66*/ "%2 にメソッド %1 が見つかりません。",
                /*1071,67*/ "関数 %1 は %2 にバインド済みです。",
                /*1072,68*/ "Disp_id 0 が無効です。",
                /*1073,69*/ "disp_id %2 が重複しているために、非オーバーライドメソッド %1 が置換されました。",
                /*1074,70*/ "%2 の読み取り専用プロパティ %1 へは書き込みできません。",
                /*1075,71*/ "Math は関数ではありません。",
                /*1076,72*/ "Math はコンストラクタではありません。",
                /*1077,73*/ "%2 の書き込み専用プロパティ %1 の読み込みは無効です。",
                /*1078,74*/ "オプコードとマルチネームの組み合わせが無効です :%1<%2>。",
                /*1079,75*/ "読み込まれたコードではネイティブメソッドを使用できません。",
                /*1080,76*/ "名前空間の値が無効です。",
                /*1081,77*/ "%2 にプロパティ %1 が見つからず、デフォルト値もありません。",
                /*1082,78*/ "デフォルトの名前空間が設定されていません。",
                /*1083,79*/ "エレメント \"%2\" の接頭辞 \"%1\" がバインドされていません。",
                /*1084,80*/ "エレメントまたは属性 (\"%1\") が QName プロダクションと一致しません : QName::=(NCName':')?NCName。",
                /*1085,81*/ "エレメント型 \"%1\" は対応する終了タグ \"</%2>\" で終了する必要があります。",
                /*1086,82*/ "%1 メソッドは、単一のアイテムを含むリストに対してのみ使用できます。",
                /*1087,83*/ "インデックス付きの XML への代入は許可されません。",
                /*1088,84*/ "ルートエレメントに続くドキュメントのマークアップは整形式でなければなりません。",
                /*1089,85*/ "複数のアイテムを含むリストへの代入はサポートされていません。",
                /*1090,86*/ "XML パーサエラー :エレメントの形式が正しくありません。",
                /*1091,87*/ "XML パーサエラー :CDATA セクションが終了していません。",
                /*1092,88*/ "XML パーサエラー :XML 宣言が終了していません。",
                /*1093,89*/ "XML パーサエラー :DOCTYPE 宣言が終了していません。",
                /*1094,90*/ "XML パーサエラー :コメントが終了していません。",
                /*1095,91*/ "XML パーサエラー :属性が終了していません。",
                /*1096,92*/ "XML パーサエラー :エレメントが終了していません。",
                /*1097,93*/ "XML パーサエラー :処理命令が終了していません。",
                /*1098,94*/ "no namespace の接頭辞 %1 が無効です。",
                /*1100,95*/ "RegExp から別の RegExp を構築する際にフラグを渡すことはできません。",
                /*1101,96*/ "不明なスコープを持つメソッド %1 を検証できません。",
                /*1102,97*/ "型 %1 のデフォルト値が無効です。",
                /*1103,98*/ "クラス %1 は、final 基本クラスを拡張できません。",
                /*1104,99*/ "属性 \"%1\" (エレメント \"%2\") は既に指定されています。",
                /*1107,100*/ "ABC データは破損しているため、境界外の読み取りが試行されました。",
                /*1108,101*/ "OP_newclass オプコードが不正な基本クラスで使用されました。",
                /*1109,102*/ "結合されていない関数 %1 をメソッド %2 から直接呼び出そうとしました。",
                /*1110,103*/ "%1 は %2 を拡張できません。",
                /*1111,104*/ "%1 は %2 を実装できません。",
                /*1112,105*/ "クラスの型変換に指定された引数の数が不正です。1 個必要ですが、%1 個指定されました。",
                /*1113,106*/ "OP_newactivation が NEED_ACTIVATION フラグなしでメソッドで使用されました。",
                /*1114,107*/ "グローバルスコープなしで OP_getglobalslot または OP_setglobalslot が使用されました。",
                /*1115,108*/ "%1 はコンストラクタではありません。",
                /*1116,109*/ "Function.prototype.apply の 2 番目の引数は配列でなければなりません。",
                /*1117,110*/ "無効な XML 名 : %1。",
                /*1118,111*/ "ノード間に不正な周期的なループがあります。",
                /*1119,112*/ "Delete 演算子はオペランド型 %1 でサポートされていません。",
                /*1120,113*/ "%2 のプロパティ %1 を削除できません。",
                /*1121,114*/ "メソッド %1 のメソッドボディが重複しています。",
                /*1122,115*/ "インターフェイスメソッド %1 のメソッドボディが無効です。",
                /*1123,116*/ "Filter 演算子は型 %1 でサポートされていません。",
                /*1124,117*/ "OP_hasnext2 を明示的に登録するには、オブジェクトとインデックスが必要です。",
                /*1500,118*/ "ファイル %1 を開く際にエラーが発生しました。",
                /*1501,119*/ "ファイル %1 に書き込む際にエラーが発生しました。",
                /*1502,120*/ "スクリプトがデフォルトのタイムアウト時間の 15 秒を超えて実行されました。",
                /*1503,121*/ "スクリプトが 30 秒後の終了に失敗したため、強制終了しました。",
                /*1504,122*/ "ファイルの終端です。",
                /*1505,123*/ "文字列インデックス %1 が境界外です。%2 ～ %3 の範囲内である必要があります。",
                /*1506,124*/ "指定した範囲は無効です。",
                /*1507,125*/ "引数 %1 は null にすることができません。",
                /*1508,126*/ "引数 %1 に指定した値は無効です。",
                /*1509,127*/ "圧縮データの解凍時にエラーが発生しました。",
                /*1510,128*/ "コールバック引数がクラスのメソッドのとき、任意指定の引数 'this' は null でなければなりません。"
            },
                // ko
            {
                /*1000,0*/ "시스템의 메모리가 부족합니다.",
                /*1001,1*/ "메서드 %1이(가) 구현되지 않습니다.",
                /*1002,2*/ "정밀도 인수는 %2과 %3 사이의 값이어야 합니다. %1은(는) 유효하지 않습니다.",
                /*1003,3*/ "기수 인수는 2와 36 사이의 값이어야 하지만 %1입니다.",
                /*1004,4*/ "호환되지 않는 객체에서 메서드 %1을(를) 호출했습니다.",
                /*1005,5*/ "배열 인덱스가 양의 정수(%1)가 아닙니다.",
                /*1006,6*/ "%1은(는) 함수가 아닙니다.",
                /*1007,7*/ "비생성자에서 인스턴스화를 시도했습니다.",
                /*1008,8*/ "%1은(는) 모호합니다. 일치하는 바인딩이 두 개 이상 있습니다.",
                /*1009,9*/ "null 객체 참조의 속성이나 메서드에 액세스할 수 없습니다.",
                /*1010,10*/ "정의되지 않은 용어이며 속성이 없습니다.",
                /*1011,11*/ "메서드 %1은(는) 잘못된 opcode %2을(를) 포함하고 있습니다(오프셋 %3에 있음).",
                /*1012,12*/ "마지막 명령이 코드 크기를 초과했습니다.",
                /*1013,13*/ "scopeDepth가 0이면 OP_findproperty를 호출할 수 없습니다.",
                /*1014,14*/ "클래스 %1을(를) 찾을 수 없습니다.",
                /*1015,15*/ "메서드 %1은(는) 기본 xml 네임스페이스를 설정할 수 없습니다.",
                /*1016,16*/ "하위 연산자(..)는 %1 유형에서 지원되지 않습니다.",
                /*1017,17*/ "범위 스택 오버플로가 발생했습니다.",
                /*1018,18*/ "범위 스택 언더플로가 발생했습니다.",
                /*1019,19*/ "Getscopeobject %1이(가) 범위를 벗어났습니다.",
                /*1020,20*/ "코드는 메서드 끝 부분을 벗어날 수 없습니다.",
                /*1021,21*/ "적어도 하나의 분기 대상이 메서드의 유효한 명령에 있지 않습니다.",
                /*1022,22*/ "void 형식은 함수 반환 형식으로만 사용할 수 있습니다.",
                /*1023,23*/ "스택 오버플로가 발생했습니다.",
                /*1024,24*/ "스택 언더플로가 발생했습니다.",
                /*1025,25*/ "유효하지 않은 레지스터 %1을(를) 액세스했습니다.",
                /*1026,26*/ "슬롯 %1이(가) %3의 slotCount=%2을(를) 초과했습니다.",
                /*1027,27*/ "Method_info %1이(가) method_count=%2을(를) 초과했습니다.",
                /*1028,28*/ "Disp_id %1이(가) %3의 max_disp_id=%2을(를) 초과했습니다.",
                /*1029,29*/ "Disp_id %1이(가) %2에 정의되어 있지 않습니다.",
                /*1030,30*/ "스택 깊이의 균형이 맞지 않습니다. %1 != %2",
                /*1031,31*/ "범위 심도의 균형이 맞지 않습니다. %1 != %2",
                /*1032,32*/ "Cpool 인덱스 %1이(가) 범위 %2을(를) 벗어났습니다.",
                /*1033,33*/ "Cpool 항목 %1은(는) 잘못된 유형입니다.",
                /*1034,34*/ "유형 강제 변환에 실패했습니다. %1을(를) %2(으)로 변환할 수 없습니다.",
                /*1035,35*/ "메서드 %1에 잘못된 super 표현식이 있습니다.",
                /*1037,36*/ "%2의 메서드 %1에 할당할 수 없습니다.",
                /*1038,37*/ "%1이(가) 이미 정의되어 있습니다.",
                /*1039,38*/ "참조할 때까지 메서드를 확인할 수 없습니다.",
                /*1040,39*/ "instanceof의 오른쪽은 클래스 또는 함수여야 합니다.",
                /*1041,40*/ "연산자의 오른쪽은 클래스여야 합니다.",
                /*1042,41*/ "ABC 파일이 아닙니다. major_version=%1 minor_version=%2",
                /*1043,42*/ "code_length=%1이(가) 유효하지 않습니다.",
                /*1044,43*/ "flags=%1을(를) 지원하지 않는 MethodInfo-%2입니다.",
                /*1045,44*/ "traits kind=%1을(를) 지원하지 않습니다.",
                /*1046,45*/ "정의하기 전에 MethodInfo-%1을(를) 참조합니다.",
                /*1047,46*/ "진입점을 찾을 수 없습니다.",
                /*1049,47*/ "프로토타입 객체는 vanilla 객체여야 합니다.",
                /*1050,48*/ "%1을(를) 원시 값으로 변환할 수 없습니다.",
                /*1051,49*/ "%1에 대한 초기 바인딩 액세스가 잘못되었습니다.",
                /*1052,50*/ "%1 함수에 유효하지 않은 URI가 전달되었습니다.",
                /*1053,51*/ "%2의 %1에 대한 재정의가 잘못되었습니다.",
                /*1054,52*/ "예외 핸들러의 범위 또는 대상 오프셋이 잘못되었습니다.",
                /*1056,53*/ "%2에 속성 %1을(를) 만들 수 없습니다.",
                /*1057,54*/ "%1은(는) 메서드만 포함할 수 있습니다.",
                /*1058,55*/ "피연산자 유형이 잘못되었습니다. %1은(는) %2이어야 합니다.",
                /*1059,56*/ "정의하기 전에 ClassInfo-%1을(를) 참조합니다.",
                /*1060,57*/ "ClassInfo %1이(가) class_count=%2을(를) 초과했습니다.",
                /*1061,58*/ "정밀도의 손상 없이는 값 %1을(를) %2(으)로 변환할 수 없습니다.",
                /*1063,59*/ "%1에서 인수 개수가 일치하지 않습니다. %2개가 필요하지만 %3개가 있습니다.",
                /*1064,60*/ "메서드 %1을(를) 생성자로 호출할 수 없습니다.",
                /*1065,61*/ "변수 %1이(가) 정의되어 있지 않습니다.",
                /*1066,62*/ "양식 함수('함수 본문')는 지원되지 않습니다.",
                /*1067,63*/ "기본 메서드 %1의 메서드 본문이 잘못되었습니다.",
                /*1068,64*/ "%1과(와) %2을(를) 조정할 수 없습니다.",
                /*1069,65*/ "%2에서 속성 %1을(를) 찾을 수 없습니다. 기본값이 없습니다.",
                /*1070,66*/ "%2에서 메서드 %1을(를) 찾을 수 없습니다.",
                /*1071,67*/ "함수 %1이(가) 이미 %2에 바인딩되었습니다.",
                /*1072,68*/ "Disp_id 0이 잘못되었습니다.",
                /*1073,69*/ "복제된 disp_id %2(으)로 인해 재정의되지 않은 메서드 %1이(가) 대체되었습니다.",
                /*1074,70*/ "%2의 읽기 전용 속성 %1에는 쓸 수 없습니다.",
                /*1075,71*/ "Math는 함수가 아닙니다.",
                /*1076,72*/ "Math는 생성자가 아닙니다.",
                /*1077,73*/ "%2의 쓰기 전용 속성 %1은(는) 읽을 수 없습니다.",
                /*1078,74*/ "잘못된 opcode/multiname 조합입니다. %1<%2>.",
                /*1079,75*/ "로드된 코드에는 기본 메서드를 사용할 수 없습니다.",
                /*1080,76*/ "네임스페이스의 값이 잘못되었습니다.",
                /*1081,77*/ "속성 %1을(를) %2에서 찾을 수 없습니다. 기본값이 없습니다.",
                /*1082,78*/ "기본 네임스페이스가 설정되지 않았습니다.",
                /*1083,79*/ "요소 \"%2\"에 대한 접두어 \"%1\"이(가) 바인딩되지 않았습니다.",
                /*1084,80*/ "요소 또는 속성(\"%1\")이 QName 생성 규칙과 일치하지 않습니다. QName::=(NCName':')?NCName",
                /*1085,81*/ "요소 유형 \"%1\"은(는) 일치하는 끝 태그 \"</%2>\"(으)로 끝나야 합니다.",
                /*1086,82*/ "%1 메서드는 항목 하나를 포함한 목록에서만 작동합니다.",
                /*1087,83*/ "인덱싱된 XML에 할당할 수 없습니다.",
                /*1088,84*/ "루트 요소 다음에 나오는 문서 내의 태그는 올바른 형식이어야 합니다.",
                /*1089,85*/ "둘 이상의 항목이 있는 목록에 할당이 지원되지 않습니다.",
                /*1090,86*/ "XML 파서 실패: 요소가 잘못되었습니다.",
                /*1091,87*/ "XML 파서 실패: CDATA 섹션이 종결되지 않았습니다.",
                /*1092,88*/ "XML 파서 실패: XML 선언이 종결되지 않았습니다.",
                /*1093,89*/ "XML 파서 실패: DOCTYPE 선언이 종결되지 않았습니다.",
                /*1094,90*/ "XML 파서 실패: 주석이 종결되지 않았습니다.",
                /*1095,91*/ "XML 파서 실패: 속성이 종결되지 않았습니다.",
                /*1096,92*/ "XML 파서 실패: 요소가 종결되지 않았습니다.",
                /*1097,93*/ "XML 파서 실패: 처리 명령이 종결되지 않았습니다.",
                /*1098,94*/ "네임스페이스 없음에 대한 접두어 %1이(가) 잘못되었습니다.",
                /*1100,95*/ "다른 RegExp로부터 하나의 RegExp를 만드는 경우 플래그를 제공할 수 없습니다.",
                /*1101,96*/ "범위를 알 수 없는 메서드 %1은(는) 확인할 수 없습니다.",
                /*1102,97*/ "유형 %1의 기본값이 잘못되었습니다.",
                /*1103,98*/ "클래스 %1은(는) 최종 기본 클래스를 확장할 수 없습니다.",
                /*1104,99*/ "속성 \"%1\"이(가) 요소 \"%2\"에 대해 이미 지정되었습니다.",
                /*1107,100*/ "ABC 데이터가 손상되었으며 범위를 벗어나는 읽기를 시도합니다.",
                /*1108,101*/ "OP_newclass opcode가 잘못된 기본 클래스에서 사용되었습니다.",
                /*1109,102*/ "언바운드 함수 %1을(를) 메서드 %2(으)로부터 직접 호출하려고 시도합니다.",
                /*1110,103*/ "%1은(는) %2을(를) 확장할 수 없습니다.",
                /*1111,104*/ "%1은(는) %2을(를) 구현할 수 없습니다.",
                /*1112,105*/ "인수 개수가 클래스 강제 변환 시 일치하지 않습니다.  1개가 필요하지만 %1개가 있습니다.",
                /*1113,106*/ "NEED_ACTIVATION 플래그가 없는 메서드에 OP_newactivation이 사용되었습니다.",
                /*1114,107*/ "전역 범위 없이 OP_getglobalslot 또는 OP_setglobalslot이 사용되었습니다.",
                /*1115,108*/ "%1은(는) 생성자가 아닙니다.",
                /*1116,109*/ "Function.prototype.apply의 두 번째 인수는 배열이어야 합니다.",
                /*1117,110*/ "잘못된 XML 이름: %1",
                /*1118,111*/ "노드 사이의 순환 루프가 잘못되었습니다.",
                /*1119,112*/ "유형 %1의 피연산자에 대해서는 Delete 연산자가 지원되지 않습니다.",
                /*1120,113*/ "%2의 속성 %1을(를) 삭제할 수 없습니다.",
                /*1121,114*/ "메서드 %1에 복제된 메서드 본문이 있습니다.",
                /*1122,115*/ "인터페이스 메서드 %1에 잘못된 메서드 본문이 있습니다.",
                /*1123,116*/ "유형 %1에서는 필터 연산자가 지원되지 않습니다.",
                /*1124,117*/ "OP_hasnext2는 개별 레지스터가 되려면 객체 및 인덱스가 있어야 합니다.",
                /*1500,118*/ "파일 %1을(를) 여는 동안 오류가 발생했습니다.",
                /*1501,119*/ "파일 %1에 쓰는 동안 오류가 발생했습니다.",
                /*1502,120*/ "스크립트 실행 시간이 기본 제한 시간인 15초를 초과했습니다.",
                /*1503,121*/ "스크립트가 30초 후에도 끝나지 않아 종료했습니다.",
                /*1504,122*/ "파일의 끝입니다.",
                /*1505,123*/ "문자열 인덱스 %1이(가) 범위를 벗어났습니다. %2와 %3 사이의 범위에 있어야 합니다.",
                /*1506,124*/ "유효하지 않은 범위가 지정되었습니다.",
                /*1507,125*/ "인수 %1은(는) null일 수 없습니다.",
                /*1508,126*/ "인수 %1에 지정된 값이 유효하지 않습니다.",
                /*1509,127*/ "데이터의 압축을 푸는 동안 오류가 발생했습니다.",
                /*1510,128*/ "콜백 인수가 클래스의 메서드인 경우 선택적 인수 'this'는 null이어야 합니다."
            },
                // zh_CN
            {
                /*1000,0*/ "系统内存不足。",
                /*1001,1*/ "未实现 %1 方法。",
                /*1002,2*/ "精度参数必须介于 %2 到 %3 之间；%1 无效。",
                /*1003,3*/ "基数参数必须介于 2 到 36 之间；当前值为 %1。",
                /*1004,4*/ "对不兼容的对象调用了方法 %1。",
                /*1005,5*/ "数组索引不是正整数 (%1)。",
                /*1006,6*/ "%1 不是函数。",
                /*1007,7*/ "尝试实例化的函数不是构造函数。",
                /*1008,8*/ "%1 有歧义；找到多个匹配的绑定。",
                /*1009,9*/ "无法访问空对象引用的属性或方法。",
                /*1010,10*/ "术语尚未定义，并且无任何属性。",
                /*1011,11*/ "方法 %1 包含非法 opcode %2 (偏移量为 %3)。",
                /*1012,12*/ "最后一条指令超出代码大小。",
                /*1013,13*/ "当 scopeDepth 为 0 时，无法调用 OP_findproperty。",
                /*1014,14*/ "无法找到类 %1。",
                /*1015,15*/ "方法 %1 无法设置默认 XML 命名空间",
                /*1016,16*/ "类型 %1 不支持后代运算符 (..)。",
                /*1017,17*/ "发生范围堆栈上溢。",
                /*1018,18*/ "发生范围堆栈下溢。",
                /*1019,19*/ "Getscopeobject %1 超出范围。",
                /*1020,20*/ "代码不能超出方法结尾。",
                /*1021,21*/ "至少一个分支目标不是方法中的有效指令。",
                /*1022,22*/ "void 类型只能用作函数返回类型。",
                /*1023,23*/ "发生堆栈上溢。",
                /*1024,24*/ "发生堆栈下溢。",
                /*1025,25*/ "访问了无效的注册 %1。",
                /*1026,26*/ "Slot %1 超出 %3 中 slotCount=%2 的限制。",
                /*1027,27*/ "Method_info %1 超出 method_count=%2 的限制。",
                /*1028,28*/ "Disp_id %1 超出 %3 中 max_disp_id=%2 的限制。",
                /*1029,29*/ "Disp_id %1 在 %2 上未定义。",
                /*1030,30*/ "堆栈深度不对称。%1 != %2。",
                /*1031,31*/ "范围深度不对称。%1 != %2。",
                /*1032,32*/ "Cpool 索引 %1 超出范围 %2。",
                /*1033,33*/ "Cpool 项 %1 类型错误。",
                /*1034,34*/ "强制转换类型失败:无法将 %1 转换为 %2。",
                /*1035,35*/ "发现方法 %1 中存在非法的 super 表达式。",
                /*1037,36*/ "无法在 %2 上为方法 %1 赋值。",
                /*1038,37*/ "%1 已定义。",
                /*1039,38*/ "在方法被引用之前无法对其进行验证。",
                /*1040,39*/ "instanceof 的右侧必须是类或函数。",
                /*1041,40*/ "运算符的右侧必须是类。",
                /*1042,41*/ "不是 ABC 文件。major_version=%1 minor_version=%2。",
                /*1043,42*/ "code_length=%1 无效。",
                /*1044,43*/ "MethodInfo-%1 不支持 flags=%2。",
                /*1045,44*/ "不支持 trait kind=%1。",
                /*1046,45*/ "MethodInfo-%1 被引用时未定义。",
                /*1047,46*/ "未找到入口点。",
                /*1049,47*/ "原型对象必须是 vanilla 对象。",
                /*1050,48*/ "无法将 %1 转换为原始类型。",
                /*1051,49*/ "对 %1 的早期绑定访问是非法的。",
                /*1052,50*/ "传递给 %1 函数的 URI 无效。",
                /*1053,51*/ "在 %2 中非法覆盖 %1。",
                /*1054,52*/ "异常处理函数中存在非法的范围或目标偏移量。",
                /*1056,53*/ "无法为 %2 创建属性 %1。",
                /*1057,54*/ "%1 只能包含方法。",
                /*1058,55*/ "非法的操作数类型: %1 必须是 %2。",
                /*1059,56*/ "ClassInfo-%1 被引用时未定义。",
                /*1060,57*/ "ClassInfo %1 超出 class_count=%2 的限制。",
                /*1061,58*/ "无法在不损失精度的情况下将值 %1 转换为 %2。",
                /*1063,59*/ "%1 的参数数量不匹配。应该有 %2 个，当前为 %3 个。",
                /*1064,60*/ "无法将方法 %1 作为构造函数调用。",
                /*1065,61*/ "变量 %1 未定义。",
                /*1066,62*/ "不支持 function('function body') 形式。",
                /*1067,63*/ "内置方法 %1 含有非法的方法正文。",
                /*1068,64*/ "%1 和 %2 无法协调一致。",
                /*1069,65*/ "在 %2 上找不到属性 %1，且没有默认值。",
                /*1070,66*/ "在 %2 上找不到方法 %1",
                /*1071,67*/ "函数 %1 已被绑定到 %2。",
                /*1072,68*/ "Disp_id 0 是非法的。",
                /*1073,69*/ "由于 disp_id %2 的重复，非覆盖方法 %1 已被替换。",
                /*1074,70*/ "%2 上存在对只读属性 %1 的非法写入。",
                /*1075,71*/ "Math 不是函数。",
                /*1076,72*/ "Math 不是构造函数。",
                /*1077,73*/ "%2 上存在对只写属性 %1 的非法读取。",
                /*1078,74*/ "非法的 opcode/multiname 组合: %1<%2>。",
                /*1079,75*/ "载入代码中不允许使用内置方法。",
                /*1080,76*/ "非法的命名空间值。",
                /*1081,77*/ "在 %2 上找不到属性 %1，且没有默认值。",
                /*1082,78*/ "未设置默认的命名空间。",
                /*1083,79*/ "元素“%2”的前缀“%1”未绑定。",
                /*1084,80*/ "元素或属性 (“%1”) 与 QName 定义不匹配: QName::=(NCName':')?NCName。",
                /*1085,81*/ "元素类型“%1”必须以匹配的结束标记“</%2>”结束。",
                /*1086,82*/ "%1 方法只能用于包含单一项目的列表。",
                /*1087,83*/ "不允许对索引 XML 进行赋值。",
                /*1088,84*/ "文档中根元素后面的标记格式必须正确。",
                /*1089,85*/ "不支持对包含多个项目的列表进行赋值。",
                /*1090,86*/ "XML 分析器失败: 元素格式不正确。",
                /*1091,87*/ "XML 分析器失败: CDATA 部分未结束。",
                /*1092,88*/ "XML 分析器失败: XML 声明未结束。",
                /*1093,89*/ "XML 分析器失败: DOCTYPE 声明未结束。",
                /*1094,90*/ "XML 分析器失败: 注释未结束。",
                /*1095,91*/ "XML 分析器失败: 属性未结束。",
                /*1096,92*/ "XML 分析器失败: 元素未结束。",
                /*1097,93*/ "XML 分析器失败: 正在处理的指令未结束。",
                /*1098,94*/ "no namespace 带有非法前缀 %1。",
                /*1100,95*/ "在由一个 RegExp 构建另一个的过程中无法提供标志。",
                /*1101,96*/ "无法验证具有未知范围的方法 %1。",
                /*1102,97*/ "类型 %1 的默认值非法。",
                /*1103,98*/ "类 %1 不能扩展最终基类。",
                /*1104,99*/ "已指定属性“%1”(针对元素“%2”)。",
                /*1107,100*/ "ABC 数据已损坏，尝试的读取操作超出范围。",
                /*1108,101*/ "OP_newclass opcode 使用的基类不正确。",
                /*1109,102*/ "尝试直接调用非绑定函数 %1 (从方法 %2 中调用)。",
                /*1110,103*/ "%1 无法扩展 %2。",
                /*1111,104*/ "%1 无法实现 %2。",
                /*1112,105*/ "类强制转换的参数数量不匹配。应为 1 个，当前为 %1 个。",
                /*1113,106*/ "方法中使用的 OP_newactivation 没有 NEED_ACTIVATION 标志。",
                /*1114,107*/ "使用的 OP_getglobalslot 或 OP_setglobalslot 不具有全局范围。",
                /*1115,108*/ "%1 不是构造函数。",
                /*1116,109*/ "Function.prototype.apply 的第二个参数必须是数组。",
                /*1117,110*/ "XML 名称无效: %1。",
                /*1118,111*/ "节点间存在非法循环。",
                /*1119,112*/ "类型 %1 的操作数不支持删除运算符。",
                /*1120,113*/ "无法为 %2 删除属性 %1。",
                /*1121,114*/ "方法 %1 具有重复的方法正文。",
                /*1122,115*/ "接口方法 %1 含有非法的方法正文。",
                /*1123,116*/ "类型 %1 不支持过滤运算符。",
                /*1124,117*/ "OP_hasnext2 要求对象和索引位于不同的寄存器。",
                /*1500,118*/ "打开文件 %1 时出错。",
                /*1501,119*/ "写入文件 %1 时出错。",
                /*1502,120*/ "脚本的执行时间已经超过了 15 秒的默认超时设置。",
                /*1503,121*/ "脚本未能在 30 秒后退出而被终止。",
                /*1504,122*/ "文件结尾。",
                /*1505,123*/ "字符串索引 %1 超出范围；必须在 %2 到 %3 的范围内。",
                /*1506,124*/ "指定的范围无效。",
                /*1507,125*/ "参数 %1 不能为空。",
                /*1508,126*/ "为参数 %1 指定的值无效。",
                /*1509,127*/ "解压缩数据时出错。",
                /*1510,128*/ "如果回调参数是某个类的方法，则可选参数“this”必须为空。"
            },
                // zh_TW
            {
                /*1000,0*/ "系統記憶體不足。",
                /*1001,1*/ "未實作方法 %1。",
                /*1002,2*/ "精確度引數必須介於 %2 和 %3 之間；%1 無效。",
                /*1003,3*/ "基數引數必須介於 2 和 36 之間；目前引數為 %1。",
                /*1004,4*/ "在不相容的物件上呼叫了 %1 方法。",
                /*1005,5*/ "陣列索引不是正整數 (%1)。",
                /*1006,6*/ "%1 不是函數。",
                /*1007,7*/ "嘗試個體化非建構函式。",
                /*1008,8*/ "%1 出現模稜兩可的情況；找到一個以上的相符繫結。",
                /*1009,9*/ "無法存取 Null 物件參考的屬性或方法。",
                /*1010,10*/ "詞彙未定義且沒有屬性。",
                /*1011,11*/ "方法 %1 包含不合法的 Opcode %2 (在位移 %3)。",
                /*1012,12*/ "最後的指令超過程式碼大小。",
                /*1013,13*/ "當 scopeDepth 是 0 時，無法呼叫 OP_findproperty。",
                /*1014,14*/ "找不到類別 %1。",
                /*1015,15*/ "方法 %1 無法設定預設的 xml 名稱空間",
                /*1016,16*/ "類型 %1 不支援子系運算子 (..)。",
                /*1017,17*/ "發生範圍堆疊溢位。",
                /*1018,18*/ "發生範圍堆疊反向溢位。",
                /*1019,19*/ "Getscopeobject %1 超出範圍。",
                /*1020,20*/ "程式碼不能在方法的結尾之外。",
                /*1021,21*/ "至少有一個分支目標不在方法中的有效指令上。",
                /*1022,22*/ "類型 void 只能用來做為函數傳回類型。",
                /*1023,23*/ "發生堆疊溢位。",
                /*1024,24*/ "發生堆疊反向溢位。",
                /*1025,25*/ "存取無效的註冊項目 %1。",
                /*1026,26*/ "位置 %1 超過 %3 的 slotCount= %2。",
                /*1027,27*/ "Method_info %1 超過 method_count=%2。",
                /*1028,28*/ "Disp_id %1 超過 %3 的 max_disp_id=%2。",
                /*1029,29*/ "Disp_id %1 沒有定義於 %2。",
                /*1030,30*/ "堆疊深度不對稱。%1 != %2。",
                /*1031,31*/ "範圍深度不對稱。%1 != %2。",
                /*1032,32*/ "Cpool 索引 %1 超出範圍 %2。",
                /*1033,33*/ "Cpool 項目 %1 類型錯誤。",
                /*1034,34*/ "強制轉型失敗： 無法將 %1 轉換成 %2。",
                /*1035,35*/ "方法 %1 中有不合法的 super 陳述式。",
                /*1037,36*/ "無法指定給 %2 上的方法 %1。",
                /*1038,37*/ "%1 已定義。",
                /*1039,38*/ "方法被參考後才能進行驗證。",
                /*1040,39*/ "instanceof 的右邊必須是類別或函式。",
                /*1041,40*/ "運算子的右邊必須是類別。",
                /*1042,41*/ "不是 ABC 檔案。major_version=%1 minor_version=%2。",
                /*1043,42*/ "無效的 code_length=%1。",
                /*1044,43*/ "MethodInfo-%1 不支援的旗標=%2。",
                /*1045,44*/ "不支援的 traits 類型=%1。",
                /*1046,45*/ "MethodInfo-%1 在定義之前被參考。",
                /*1047,46*/ "找不到進入點。",
                /*1049,47*/ "原型物件必須是 Vanilla 物件。",
                /*1050,48*/ "無法將 %1 轉換成基本類型。",
                /*1051,49*/ "不合法的早期繫結存取 %1。",
                /*1052,50*/ "傳遞給 %1 函數的 URI 無效。",
                /*1053,51*/ "不合法覆寫 %2 中的 %1。",
                /*1054,52*/ "例外處理常式中出現不合法的範圍或目標位移。",
                /*1056,53*/ "無法在 %2 上建立屬性 %1。",
                /*1057,54*/ "%1 只能包含方法。",
                /*1058,55*/ "運算元類型不合法：%1 必須是 %2。",
                /*1059,56*/ "ClassInfo-%1 在定義之前被參考。",
                /*1060,57*/ "ClassInfo %1 超過 class_count=%2。",
                /*1061,58*/ "值 %1 在轉換成 %2 後會有誤差。",
                /*1063,59*/ "%1 上的引數個數不相符。需要 %2 個，目前為 %3 個。",
                /*1064,60*/ "無法將方法 %1 當作建構函式呼叫。",
                /*1065,61*/ "變數 %1 未定義。",
                /*1066,62*/ "不支援表單 function('function body')。",
                /*1067,63*/ "原生方法 %1 包含不合法的方法主體。",
                /*1068,64*/ "%1 和 %2 無法調解。",
                /*1069,65*/ "%2 上找不到屬性 %1，而且沒有預設值。",
                /*1070,66*/ "%2 上找不到方法 %1",
                /*1071,67*/ "函數 %1 已繫結至 %2。",
                /*1072,68*/ "Disp_id 0 不合法。",
                /*1073,69*/ "由於 disp_id %2 重複，非 Override 方法 %1 已被代換。",
                /*1074,70*/ "不合法的寫入 %2 上的唯讀屬性 %1。",
                /*1075,71*/ "Math 不是函數。",
                /*1076,72*/ "Math 不是建構函式。",
                /*1077,73*/ "不合法的讀取 %2 上的唯寫屬性 %1。",
                /*1078,74*/ "不合法的 Opcode/Multiname 組合：%1<%2>。",
                /*1079,75*/ "載入的程式碼中不允許使用原生方法。",
                /*1080,76*/ "不合法的名稱空間值。",
                /*1081,77*/ "%2 上找不到屬性 %1，且沒有預設值。",
                /*1082,78*/ "未設定預設的名稱空間。",
                /*1083,79*/ "未繫結元素 \"%2\" 的前置詞 \"%1\"。",
                /*1084,80*/ "元素或屬性 (\"%1\") 與 QName Production 不相符：QName::=(NCName':')?NCName。",
                /*1085,81*/ "元素類型 '%1' 必須以相符的結束標籤 '</%2>' 結束。",
                /*1086,82*/ "%1 方法只有在包含一個項目的清單上才有作用。",
                /*1087,83*/ "不允許索引 XML 的指定。",
                /*1088,84*/ "文件中根元素之後的標記必須使用正確格式。",
                /*1089,85*/ "無法指定給包含多個項目的清單。",
                /*1090,86*/ "XML 剖析器失敗：元素格式錯誤。",
                /*1091,87*/ "XML 剖析器失敗：未結束的 CDATA 區段。",
                /*1092,88*/ "XML 剖析器失敗：未結束的 XML 宣告。",
                /*1093,89*/ "XML 剖析器失敗：未結束的 DOCTYPE 宣告。",
                /*1094,90*/ "XML 剖析器失敗：未結束的註解。",
                /*1095,91*/ "XML 剖析器失敗：未結束的屬性。",
                /*1096,92*/ "XML 剖析器失敗：未結束的元素。",
                /*1097,93*/ "XML 剖析器失敗：未結束的處理指令。",
                /*1098,94*/ "no namespace 的前置詞 %1 不合法。",
                /*1100,95*/ "從另一個 RegExp 建構 RegExp 時無法提供旗標。",
                /*1101,96*/ "無法以未知的範圍檢查方法 %1。",
                /*1102,97*/ "類型 %1 的預設值不合法。",
                /*1103,98*/ "類別 %1 無法擴充最後的基底類別。",
                /*1104,99*/ "屬性 \"%1\" 已經指定給元素 \"%2\"。",
                /*1107,100*/ "ABC 資料已經損毀，嘗試讀取超出範圍。",
                /*1108,101*/ "OP_newclass Opcode 使用於不正確的基底類別。",
                /*1109,102*/ "嘗試直接從方法 %1 呼叫未繫結的函式 %2。",
                /*1110,103*/ "%1 無法擴充 %2。",
                /*1111,104*/ "%1 無法實作 %2。",
                /*1112,105*/ "強制類別上的引數個數不相符。需要 1 個，目前為 %1 個。",
                /*1113,106*/ "方法中使用 OP_newactivation，未搭配 NEED_ACTIVATION 指標。",
                /*1114,107*/ "在非全域範圍下使用 OP_getglobalslot 或 OP_setglobalslot。",
                /*1115,108*/ "%1 不是建構函式。",
                /*1116,109*/ "Function.prototype.apply 的第二個引數必須是陣列。",
                /*1117,110*/ "無效的 XML 名稱：%1。",
                /*1118,111*/ "節點之間的循環迴圈不合法。",
                /*1119,112*/ "類型 %1 的運算元不支援刪除運算子。",
                /*1120,113*/ "無法刪除 %2 上的屬性 %1。",
                /*1121,114*/ "方法 %1 包含重複的方法主體。",
                /*1122,115*/ "Interface 方法 %1 包含不合法的方法主體。",
                /*1123,116*/ "類型 %1 不支援篩選運算子。",
                /*1124,117*/ "OP_hasnext2 要求物件及索引為可辨識的登錄。",
                /*1500,118*/ "開啟檔案 %1 時發生錯誤。",
                /*1501,119*/ "寫入檔案 %1 時發生錯誤。",
                /*1502,120*/ "script 已經執行超過預設的 15 秒逾時時段。",
                /*1503,121*/ "Script 並未在 30 秒後結束，已經被終止。",
                /*1504,122*/ "檔案結尾。",
                /*1505,123*/ "字串索引 %1 超出範圍；範圍必須介於 %2 到 %3。",
                /*1506,124*/ "指定的範圍無效。",
                /*1507,125*/ "引數 %1 不能是 null。",
                /*1508,126*/ "指定給引數 %1 的值無效。",
                /*1509,127*/ "解壓縮資料時發生錯誤。",
                /*1510,128*/ "若回呼引數是 Class 的方法，選擇性的引數 'this' 必須是 null。"
            }
        };
#endif /* DEBUGGER */
    }
}
