/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1 
 *
 * The contents of this file are subject to the Mozilla Public License Version 1.1 (the 
 * "License"); you may not use this file except in compliance with the License. You may obtain 
 * a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT 
 * WARRANTY OF ANY KIND, either express or implied. See the License for the specific 
 * language governing rights and limitations under the License. 
 * 
 * The Original Code is [Open Source Virtual Machine.] 
 * 
 * The Initial Developer of the Original Code is Sony Computer Entertainment Inc.  Portions created 
 * by the Initial Developer are Copyright (C)[ 2010 ] Sony Computer Entertainment Inc. All Rights 
 * Reserved. 
 * 
 * Contributor(s): SCE Adobe Flash Player Porting Team
 * 
 * Alternatively, the contents of this file may be used under the terms of either the GNU 
 * General Public License Version 2 or later (the "GPL"), or the GNU Lesser General Public 
 * License Version 2.1 or later (the "LGPL"), in which case the provisions of the GPL or the 
 * LGPL are applicable instead of those above. If you wish to allow use of your version of this 
 * file only under the terms of either the GPL or the LGPL, and not to allow others to use your 
 * version of this file under the terms of the MPL, indicate your decision by deleting provisions 
 * above and replace them with the notice and other provisions required by the GPL or the 
 * LGPL. If you do not delete the provisions above, a recipient may use your version of this file 
 * under the terms of any one of the MPL, the GPL or the LGPL. 
 * 
 ***** END LICENSE BLOCK ***** */
#ifndef __BIG_STACK_INCLUDED__
#define __BIG_STACK_INCLUDED__

#include "avmplus.h"
#include <unistd.h>//"platform/ps3/unixtypes.h"

#define READ_STACK_PTR(_stack)\
	__asm__ volatile ("mr %0, 1\n" : "=b"(_stack) :: );


#define SET_STACKPTR(_pt)							\
	__asm__ volatile ("std 1, 0(%0)" :: "b"(_pt));	\
	__asm__ volatile ("mr 1, %0\n" :: "r"(_pt):);


#define WRITE_BACK_STACKPTR(_pt) \
	__asm__ volatile ("mr 1, %0\n" :: "r"(_pt):);


class BigStack{
private:
	static const int bottomMargin = 144;
	bool allocateMyself;
	uint64_t *stackLimit;
	uint64_t *stackBase;
	uint64_t *stackBottom;

public:
	uint64_t *jumpPoint;
	uint64_t *rememberedStackTop;
	BigStack *upper;
	BigStack *lower;


	BigStack(uint32_t);
	BigStack(uint64_t* limit, uint64_t* base);
	~BigStack();

	bool isInside(void*) const;
	uint32_t size() const { return (uint32_t)stackBottom - (uint32_t)stackLimit;}
	uint32_t rest(void*) const;

	uint64_t* limit(void) const {return (uint64_t*)stackLimit;}
	uint64_t* base(void) const {return (uint64_t*)stackBase;}
	uint64_t* bottom(void) const {return stackBottom;}
	void* tieBackChain(uint64_t *);

	void stackInfo(uint64_t **limit, uint64_t **base);
	float usage(void *);

	uint64_t* trackChain(uint64_t* startSP) const;
};

/*BIG STACK

  [STACK LIMIT  ]
        |
		|
  [STACK POINTER]---- This class doesn't contain this data.
        |
		|
  [STACK BOTTOM ]
        |------------ bottom margin (0 if stack area is allocated out of this class.)
  [STACK BASE   ]		
 */

//stackInfo doesn't return real stack bottom pointers.
//This function only tells us the final stack pointer of stack chain.
void stackInfoByChain(void *spTop,BigStack *bs, uint64_t** orgTop, uint64_t** orgBottom, uint64_t** bigTop, uint64_t** bigBottom);
void originalStackInfoByChain(void *sp, uint64_t **otop, uint64_t **obot);
void stackInfoBySilk(uint64_t **orgLimit, uint64_t **orgBase);
void stackDisp(void *spTop,BigStack *bs = 0);

float originalStackUsage(void *sp);

#endif __BIG_STACK_INCLUDED__
