/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1 
 *
 * The contents of this file are subject to the Mozilla Public License Version 1.1 (the 
 * "License"); you may not use this file except in compliance with the License. You may obtain 
 * a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT 
 * WARRANTY OF ANY KIND, either express or implied. See the License for the specific 
 * language governing rights and limitations under the License. 
 * 
 * The Original Code is [Open Source Virtual Machine.] 
 * 
 * The Initial Developer of the Original Code is Sony Computer Entertainment Inc.  Portions created 
 * by the Initial Developer are Copyright (C)[ 2010 ] Sony Computer Entertainment Inc. All Rights 
 * Reserved. 
 * 
 * Contributor(s): SCE Adobe Flash Player Porting Team
 * 
 * Alternatively, the contents of this file may be used under the terms of either the GNU 
 * General Public License Version 2 or later (the "GPL"), or the GNU Lesser General Public 
 * License Version 2.1 or later (the "LGPL"), in which case the provisions of the GPL or the 
 * LGPL are applicable instead of those above. If you wish to allow use of your version of this 
 * file only under the terms of either the GPL or the LGPL, and not to allow others to use your 
 * version of this file under the terms of the MPL, indicate your decision by deleting provisions 
 * above and replace them with the notice and other provisions required by the GPL or the 
 * LGPL. If you do not delete the provisions above, a recipient may use your version of this file 
 * under the terms of any one of the MPL, the GPL or the LGPL. 
 * 
 ***** END LICENSE BLOCK ***** */
#include "BigStack.h"
#include "GCAllocObject.h"
#include <stdio.h>


static void *ORIGINAL_STACK_LIMIT = 0 ,*ORIGINAL_STACK_BASE = 0;
static int (*SILK_STACK_INFOMATION_FUNC)(void**,void**);

extern "C"{
	void set_stack_estimate_func_pointer(int (*fp)(void**,void**) ){
		SILK_STACK_INFOMATION_FUNC = fp;
	}
}

BigStack::BigStack(uint32_t sz) :
	stackLimit(0),
	stackBase(0),
	stackBottom(0),
	rememberedStackTop(0),
	allocateMyself(true),
	jumpPoint(0),
	upper(0),
	lower(0)
{
	stackLimit = (void*)(MMgc::GCAllocObject::m_malloc(sz));

	if(!stackLimit){
		return;
	}

	memset(stackLimit,0,sz);
	stackBase = (uint32_t)stackLimit + sz;
	stackBottom = ((uint32_t)stackLimit + sz - bottomMargin) & 0xfffffff0;
}

BigStack::BigStack(uint64_t *limit,uint64_t *base) :
	stackLimit(limit),
	stackBase(base),
	stackBottom(base), //stackBottom equals to stackBase. Though this is not accuate, it will not be a problem.
	rememberedStackTop(0),
	allocateMyself(false),
	jumpPoint(0),
	upper(0),
	lower(0)
{

	if( (uint32_t)limit > (uint32_t)base )
		stackLimit = stackBase = stackBottom = 0;
}

BigStack::~BigStack(){
	if(allocateMyself && stackLimit){
		MMgc::GCAllocObject::m_free(stackLimit);
	}
}

bool BigStack::isInside(void* sp) const{
	if( ((uint32_t)stackLimit <= (uint32_t)sp) && ((uint32_t)sp <= (uint32_t)stackBottom) ){
		return true;
	}else{
		return false;
	}
}

uint32_t BigStack::rest(void *sp) const{
	return (uint32_t)stackBottom - (uint32_t)sp +1;
}

void* BigStack::tieBackChain(uint64_t* nowSP){
	*stackBottom = (uint64_t)nowSP;
	return (void*)stackBottom;
}

float BigStack::usage(void *sp){
	if(!isInside(sp))
		return 0.0;

	return ((uint32_t)stackBottom - (uint32_t)sp)/(float)((uint32_t)stackBase - (uint32_t)stackLimit);
}

uint64_t* BigStack::trackChain(uint64_t* sp) const{
	if(!isInside(sp))
		return 0;

	while((*sp & 0x00000000ffffffffULL) && isInside((uint64_t*)*sp)){
		sp = (uint64_t*)*sp;
	}

	return sp;
}

void BigStack::stackInfo(uint64_t **limit, uint64_t **base){
	*limit = (uint64_t*)stackLimit;
	*base = (uint64_t*)stackBase;
}

/*******************************************************************************************************/
void stackInfoByChain(void *spTop,BigStack *bs,uint64_t** orgTop, uint64_t** orgBottom, uint64_t** bigTop, uint64_t** bigBottom){
	uint64_t* sp = (uint64_t*)spTop;

	if( bs && bs->isInside(sp) ){
		*bigTop = sp;

		while(bs->isInside(*sp)){
			sp = (uint64_t*)*sp;
		}
	   
		*bigBottom = sp;
		sp = *sp;
	}else{
		*bigTop = 0;
		*bigBottom = 0;
	}

	*orgTop = sp;
	
	while(*sp & 0x00000000ffffffffULL){
		sp = *sp;
	}
	*orgBottom = sp;
}

void originalStackInfoByChain(void *sp, uint64_t **otop, uint64_t **obot){
	uint64_t *dummy1,*dummy2;
	stackInfoByChain(sp, 0, otop, obot, &dummy1, &dummy2);
}

void stackInfoBySilk(uint64_t **orgLimit, uint64_t **orgBase){
	if(!ORIGINAL_STACK_LIMIT || !ORIGINAL_STACK_BASE){
		SILK_STACK_INFOMATION_FUNC(&ORIGINAL_STACK_BASE, &ORIGINAL_STACK_LIMIT);
	}

	*orgLimit = (uint64_t*)ORIGINAL_STACK_LIMIT;
	*orgBase = (uint64_t*)ORIGINAL_STACK_BASE;
}


void stackDisp(void *spTop,BigStack *bs = 0){
	uint64_t* sp = (uint64_t*)spTop;

	int lv = 0;	
	while(1){
		fprintf(stderr,"[%04d] 0x%llx -> 0x%llx\n", lv++, sp, *sp);
		if(bs && (bs->bottom() == sp)){
			fprintf(stderr,"----- big stack bottom ----\n");
		}

		if( (*sp & 0x00000000ffffffff) == 0){
			break;
		}
		sp = (uint64_t*) *sp;
	}
}

float originalStackUsage(void *sp){
	void *sLimit,*sBase;
	stackInfoBySilk(&sLimit,&sBase);

	int wholeSize = (uint64_t)sBase -(uint64_t)sLimit;

	uint64_t *oTop,*oBot,*bTop,*bBot;

	stackInfoByChain(sp,0, &oTop, &oBot, &bTop, &bBot);
	
	return ((uint32_t)sBase - (uint32_t)oTop)/(float)wholeSize;
}
