/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1 
 *
 * The contents of this file are subject to the Mozilla Public License Version 1.1 (the 
 * "License"); you may not use this file except in compliance with the License. You may obtain 
 * a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT 
 * WARRANTY OF ANY KIND, either express or implied. See the License for the specific 
 * language governing rights and limitations under the License. 
 * 
 * The Original Code is [Open Source Virtual Machine.] 
 * 
 * The Initial Developer of the Original Code is Adobe System Incorporated.  Portions created 
 * by the Initial Developer are Copyright (C)[ 2004-2006 ] Adobe Systems Incorporated. All Rights 
 * Reserved. 
 * 
 * Contributor(s): Adobe AS3 Team
 * 
 * Alternatively, the contents of this file may be used under the terms of either the GNU 
 * General Public License Version 2 or later (the "GPL"), or the GNU Lesser General Public 
 * License Version 2.1 or later (the "LGPL"), in which case the provisions of the GPL or the 
 * LGPL are applicable instead of those above. If you wish to allow use of your version of this 
 * file only under the terms of either the GPL or the LGPL, and not to allow others to use your 
 * version of this file under the terms of the MPL, indicate your decision by deleting provisions 
 * above and replace them with the notice and other provisions required by the GPL or the 
 * LGPL. If you do not delete the provisions above, a recipient may use your version of this file 
 * under the terms of any one of the MPL, the GPL or the LGPL. 
 * 
 ***** END LICENSE BLOCK ***** */

#ifndef __GCSpinLock__
#define __GCSpinLock__

#include <sys/ppu_thread.h>

namespace MMgc
{
	class GCSpinLock
	{
	public:
		GCSpinLock() : spinlock_(0ULL)
		{
		}
	
		~GCSpinLock()
		{
		}

		inline void Acquire()
		{
			register uint64_t* p = &spinlock_; /* r3 */
			register uint64_t nonzero, tmp;
			// spin while spinlock_ is 0
			uint64_t prio = 1, count = 100; // it should be optimized. is 100 too short? - fukasawa SCEI

			// for debug
/*
 			sys_ppu_thread_t tid; 
 			sys_ppu_thread_get_id(&tid); 
 			sys_ppu_thread_get_priority(tid, (int*)&prio); 
*/
			uint64_t r11, r3;
			// spin while spinlock_ is not 0
			asm volatile ("mr %1, %6\n"			\
						  "clrldi %1, %1, 32\n"	\
						  "addi %2, %2, -1\n"	\
						  "cmpdi cr7, %2, 0\n"	\
						  "bne cr7, $+36\n"		\
						    "mr %4, 3\n"			\
						    "mr %3, 11\n"			\
						    "li 11, 141\n"			\
						    "li 3, 500\n"			\
						    "sc 0\n"\
						    "mr 11, %3\n"			\
						    "mr 3, %4\n"			\
						    "li %2, 500\n"			\
						  "ldarx %0, 0, %5\n"	\
						  "cmpdi %0, 0\n"		\
						  "bne- $-52\n"			\
						  "stdcx. %1, 0, %5\n"	\
						  "bne- $-60\n"			\
						  : "+r"(tmp), "+r"(nonzero), "+r"(count), "+r"(r11), "+r"(r3) :"b"(p), "r"(prio) : "cr0", "cr7", "r11", "r4", "r5", "r6", "r7", "r8", "r9", "r10");
		}

		inline void Release()
		{
			register uint64_t* p = &spinlock_; /* r3 */
			register uint64_t zero, tmp;
			asm volatile ("li %1, 0\n"\
						  "ldarx %0, 0, %2\n"\
						  "stdcx. %1, 0, %2\n"\
						  "bne- $-8\n"
						  : "=&r"(tmp), "=&r"(zero): "b"(p));
		}

	private:
		uint64_t spinlock_;
	};

	/**
	 * GCAcquireSpinlock is a convenience class which acquires
	 * the specified spinlock at construct time, then releases
	 * the spinlock at desruct time.  The single statement
	 *
	 *    GCAcquireSpinlock acquire(spinlock);
	 *
	 * ... will acquire the spinlock at the top of the function
	 * and release it at the end.  This makes for less error-prone
	 * code than explicit acquire/release.
	 */
	class GCAcquireSpinlock
	{
	public:
		GCAcquireSpinlock(GCSpinLock& spinlock) : m_spinlock(spinlock)
		{
			m_spinlock.Acquire();
		}
		~GCAcquireSpinlock()
		{
			m_spinlock.Release();
		}

	private:
		GCSpinLock& m_spinlock;
	};
}

#endif /* __GCSpinLock__ */
