/* ***** BEGIN LICENSE BLOCK ***** 
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1 
 *
 * The contents of this file are subject to the Mozilla Public License Version 1.1 (the 
 * "License"); you may not use this file except in compliance with the License. You may obtain 
 * a copy of the License at http://www.mozilla.org/MPL/ 
 * 
 * Software distributed under the License is distributed on an "AS IS" basis, WITHOUT 
 * WARRANTY OF ANY KIND, either express or implied. See the License for the specific 
 * language governing rights and limitations under the License. 
 * 
 * The Original Code is [Open Source Virtual Machine.] 
 * 
 * The Initial Developer of the Original Code is Adobe System Incorporated.  Portions created 
 * by the Initial Developer are Copyright (C)[ 2004-2006 ] Adobe Systems Incorporated. All Rights 
 * Reserved. 
 * 
 * Contributor(s): Adobe AS3 Team
 * 
 * Alternatively, the contents of this file may be used under the terms of either the GNU 
 * General Public License Version 2 or later (the "GPL"), or the GNU Lesser General Public 
 * License Version 2.1 or later (the "LGPL"), in which case the provisions of the GPL or the 
 * LGPL are applicable instead of those above. If you wish to allow use of your version of this 
 * file only under the terms of either the GPL or the LGPL, and not to allow others to use your 
 * version of this file under the terms of the MPL, indicate your decision by deleting provisions 
 * above and replace them with the notice and other provisions required by the GPL or the 
 * LGPL. If you do not delete the provisions above, a recipient may use your version of this file 
 * under the terms of any one of the MPL, the GPL or the LGPL. 
 * 
 ***** END LICENSE BLOCK ***** */

#include <stdlib.h>

#include "MMgc.h"

namespace MMgc
{
#if defined(PLATFORM_PS3) || defined(PLATFORM_SILK)
	GCMallocFuncPtr	GCAllocObject::m_malloc = 0;
	GCFreeFuncPtr	GCAllocObject::m_free = 0;

	void GCAllocObject::Init(GCMallocFuncPtr m, GCFreeFuncPtr f)
	{
		if (m)
		{
			m_malloc = m;
		}
		else
		{
			m_malloc = 0;
		}

		if (f)
		{
			m_free = f;
		}
		else
		{
			m_free = 0;
		}
	}

	void GCAllocObject::Destory()
	{
		m_malloc = 0;
		m_free = 0;
	}
#endif	// PLATFORM_PS3 || PLATFORM_SILK

	void* GCAllocObject::operator new (size_t size)
	{
#if !defined(PLATFORM_PS3) && !defined(PLATFORM_SILK)
		return malloc(size);
#else	// !PLATFORM_PS3 && !PLATFORM_SILK
		return m_malloc(size);
#endif	// !PLATFORM_PS3 && !PLATFORM_SILK
	}

	void* GCAllocObject::operator new[] (size_t size)
	{
#if !defined(PLATFORM_PS3) && !defined(PLATFORM_SILK)
		return malloc(size);
#else	// !PLATFORM_PS3 && !PLATFORM_SILK
		return m_malloc(size);
#endif	// !PLATFORM_PS3 && !PLATFORM_SILK
	}
	
	void GCAllocObject::operator delete (void *ptr)
	{
#if !defined(PLATFORM_PS3) && !defined(PLATFORM_SILK)
		free(ptr);
#else	// !PLATFORM_PS3 && !PLATFORM_SILK
		m_free(ptr);
#endif	// !PLATFORM_PS3 && !PLATFORM_SILK
	}

	void GCAllocObject::operator delete [] (void *ptr)
	{
#if !defined(PLATFORM_PS3) && !defined(PLATFORM_SILK)
		free(ptr);
#else	// !PLATFORM_PS3 && !PLATFORM_SILK
		m_free(ptr);
#endif	// !PLATFORM_PS3 && !PLATFORM_SILK
	}
}

