/*
* Copyright (C) 2015 MediaTek Inc.
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
* GNU General Public License for more details.
*/

#ifndef __ISP_EXT_H
#define __ISP_EXT_H

#include <linux/ioctl.h>

#define ISP_ISR_MAX_NUM 32
#define ISP_INT_ERR_TIMER_THR 1000
#define ISP_INT_ERR_MAX_TIME 3

/**
 * interrupt clear type
 */
enum isp_irq_mode {
	ISP_IRQ_MODE_CLEAR_NONE, /* non-clear wait, clear after wait */
	ISP_IRQ_MODE_CLEAR_WAIT, /* clear wait, clear before and after wait */
	ISP_IRQ_MODE_CLEAR_STATUS, /* clear specific status only */
	ISP_IRQ_MODE_CLEAR_ALL /* clear all status */
};

struct isp_userkey {
	int userKey;
	char userName[32];
};

enum isp_dev_cmds {
	ISP_DEV_CMD_RESET_BY_HWMODULE,
	ISP_DEV_CMD_WAIT_IRQ, /* Wait IRQ */
	ISP_DEV_CMD_FLUSH_IRQ_REQUEST, /* flush signal */
	ISP_DEV_CMD_REGISTER_IRQ_USER_KEY,
	ISP_DEV_CMD_QUERY_MODULE_INFO,
	ISP_DEV_CMD_QUERY_NUM_USER_KEY,
	ISP_DEV_CMD_CLEAR_IRQ,
	ISP_DEV_CMD_CONFIG_CSI_BY_EFUSE,
	ISP_DEV_CMD_CONFIG_CSI_CPHY_MASK_CAL,
	ISP_DEV_CMD_SET_DIP_WARP_SB_INFO,
	ISP_DEV_CMD_UNUSED, /* keep compatibility for EPv8 */
	ISP_DEV_CMD_SET_POLL_TIRGGER,
};

struct isp_module_info {
	int module_id;
	unsigned long base;
	unsigned long range;
};

/* CAM_CTL_RAW_INT_STATUSX */
enum isp_module_isp_event {
	ISP_MODULE_EVENT_VSYNC = 0,
	ISP_MODULE_EVENT_TG_INT1,
	ISP_MODULE_EVENT_TG_INT2,
	ISP_MODULE_EVENT_EXPDON,
	ISP_MODULE_EVENT_TG_ERR,
	ISP_MODULE_EVENT_TG_GBERR,
	ISP_MODULE_EVENT_CQ_CODE_ERR,
	ISP_MODULE_EVENT_CQ_APB_ERR,
	ISP_MODULE_EVENT_CQ_VS_ERR,
	ISP_MODULE_EVENT_IMGO_DROP_FRAME,
	ISP_MODULE_EVENT_RRZO_DROP_FRAME,
	ISP_MODULE_EVENT_HW_PASS1_DONE,
	ISP_MODULE_EVENT_SOF,
	ISP_MODULE_EVENT_SOF_WAIT,
	ISP_MODULE_EVENT_RMX_ERR = 16,
	ISP_MODULE_EVENT_BMX_ERR,
	ISP_MODULE_EVENT_RRZO_ERR,
	ISP_MODULE_EVENT_AFO_ERR,
	ISP_MODULE_EVENT_IMGO_ERR,
	ISP_MODULE_EVENT_AAO_ERR,
	ISP_MODULE_EVENT_LCSO_ERR,
	ISP_MODULE_EVENT_BNR_ERR,
	ISP_MODULE_EVENT_LSC_ERR,
	ISP_MODULE_EVENT_CAC_ERR,
	ISP_MODULE_EVENT_DMA_ERR = 29,
	ISP_MODULE_EVENT_SW_PASS1_DONE,
};

/* error mask bit of cam irq */
#define CAM_INT_ST_MASK_CAM_ERR (\
	1 << ISP_MODULE_EVENT_TG_ERR |\
	1 << ISP_MODULE_EVENT_TG_GBERR |\
	1 << ISP_MODULE_EVENT_CQ_CODE_ERR |\
	1 << ISP_MODULE_EVENT_CQ_APB_ERR |\
	1 << ISP_MODULE_EVENT_CQ_VS_ERR |\
	1 << ISP_MODULE_EVENT_RMX_ERR |\
	1 << ISP_MODULE_EVENT_BMX_ERR |\
	1 << ISP_MODULE_EVENT_RRZO_ERR |\
	1 << ISP_MODULE_EVENT_AFO_ERR |\
	1 << ISP_MODULE_EVENT_IMGO_ERR |\
	1 << ISP_MODULE_EVENT_AAO_ERR |\
	1 << ISP_MODULE_EVENT_LCSO_ERR |\
	1 << ISP_MODULE_EVENT_BNR_ERR |\
	1 << ISP_MODULE_EVENT_LSC_ERR |\
	1 << ISP_MODULE_EVENT_CAC_ERR |\
	1 << ISP_MODULE_EVENT_DMA_ERR)

/* CAM_CTL_RAW_INT2_STATUS */
enum isp_module_dma_event {
	ISP_MODULE_EVENT_IMGO_DONE = 0,
	ISP_MODULE_EVENT_UFEO_DONE,
	ISP_MODULE_EVENT_RRZO_DONE,
	ISP_MODULE_EVENT_EISO_DONE,
	ISP_MODULE_EVENT_FLKO_DONE,
	ISP_MODULE_EVENT_AFO_DONE,
	ISP_MODULE_EVENT_LCSO_DONE,
	ISP_MODULE_EVENT_AAO_DONE,
	ISP_MODULE_EVENT_BPCI_DONE = 9,
	ISP_MODULE_EVENT_LSCI_DONE,
	ISP_MODULE_EVENT_CACI_DONE,
	ISP_MODULE_EVENT_AF_TAR_DONE,
	ISP_MODULE_EVENT_PDO_DONE,
	ISP_MODULE_EVENT_CQ_THR0_DONE = 16,
	ISP_MODULE_EVENT_CQ_THR1_DONE,
	ISP_MODULE_EVENT_CQ_THR2_DONE,
	ISP_MODULE_EVENT_CQ_THR3_DONE,
	ISP_MODULE_EVENT_CQ_THR4_DONE,
	ISP_MODULE_EVENT_CQ_THR5_DONE,
	ISP_MODULE_EVENT_CQ_THR6_DONE,
	ISP_MODULE_EVENT_CQ_THR7_DONE,
	ISP_MODULE_EVENT_CQ_THR8_DONE,
	ISP_MODULE_EVENT_CQ_THR9_DONE,
	ISP_MODULE_EVENT_CQ_THR10_DONE,
	ISP_MODULE_EVENT_CQ_THR11_DONE,
};

enum aao_sub_sample_status {
	AAO_DONE = 0x1,
	SW_P1_Done = 0x2,
};

/* 0x30 CTL_INT_STATUS */
enum isp_module_isp_status {
	ISP_MODULE_APB_INTERFERE_STATUS = 30,
	ISP_MODULE_ADL2_P2X_ERR_STATUS = 23,
	ISP_MODULE_ADL2_DONE_STATUS = 22,
	ISP_MODULE_NBC_COLLISION_STATUS = 21,
	ISP_MODULE_PCA_COLLISION_STATUS = 20,
	ISP_MODULE_GGM_COLLISION_STATUS = 19,
	ISP_MODULE_DMA_ERR_STATUS = 18,
	ISP_MODULE_TILE_DONE_STATUS = 17,
	ISP_MODULE_PASS2_DONE_STATUS = 16,
	ISP_MODULE_FEO_DONE_STATUS = 15,
	ISP_MODULE_IMG3CO_DONE_STATUS = 14,
	ISP_MODULE_IMG3BO_DONE_STATUS = 13,
	ISP_MODULE_IMG3O_DONE_STATUS = 12,
	ISP_MODULE_IMG2O_DONE_STATUS = 11,
	ISP_MODULE_MFBO_DONE_STATUS = 10,
	ISP_MODULE_DEPI_DONE_STATUS = 9,
	ISP_MODULE_DMGI_DONE_STATUS = 8,
	ISP_MODULE_LCEI_DONE_STATUS = 7,
	ISP_MODULE_VIP3I_DONE_STATUS = 6,
	ISP_MODULE_VIP2I_DONE_STATUS = 5,
	ISP_MODULE_VIPI_DONE_STATUS = 4,
	ISP_MODULE_UFDI_DONE_STATUS = 3,
	ISP_MODULE_IMGI_DONE_STATUS = 2,
	ISP_MODULE_TDR_SIZE_ERR_STATUS = 1,
	ISP_MODULE_MDP_DONE_STATUS = 0,
};

/* 0x1c	CAMSV_INT_STATUS */
enum isp_module_camsv_event {
	ISP_MODULE_CAMSV_EVENT_VSYNC = 0,
	ISP_MODULE_CAMSV_EVENT_TG_INT1,
	ISP_MODULE_CAMSV_EVENT_TG_INT2,
	ISP_MODULE_CAMSV_EVENT_EXPDON,
	ISP_MODULE_CAMSV_EVENT_TG_ERR,
	ISP_MODULE_CAMSV_EVENT_TG_GBERR,
	ISP_MODULE_CAMSV_EVENT_TG_DROP,
	ISP_MODULE_CAMSV_EVENT_TG_SOF,
	ISP_MODULE_CAMSV_EVENT_HW_PASS1_DONE = 10,
	ISP_MODULE_CAMSV_EVENT_IMGO_ERR = 16,
	ISP_MODULE_CAMSV_EVENT_IMGO_OVERR,
	ISP_MODULE_CAMSV_EVENT_IMGO_DROP = 19,
	ISP_MODULE_CAMSV_EVENT_SW_PASS1_DONE,
	ISP_MODULE_CAMSV_EVENT_TG_SOF_WAIT,
};

/* 0x24 BE_INT_STATUS */
enum isp_module_be_event {
	ISP_MODULE_BE_EVENT_EOT = 0,
	ISP_MODULE_BE_EVENT_SOF,
	ISP_MODULE_BE_EVENT_OUT_DONE,
	ISP_MODULE_BE_EVENT_LABEL_ERR,
	ISP_MODULE_BE_EVENT_MERGE_STACK_ERR,
	ISP_MODULE_BE_EVENT_DATA_TABEL_ERR,
	ISP_MODULE_BE_EVENT_DB_ERR,
	ISP_MODULE_BE_EVENT_P1_VSYNC,
	ISP_MODULE_BE_EVENT_P1_SOF,
	ISP_MODULE_BE_EVENT_HW_PASS1_DONE,
	ISP_MODULE_BE_EVENT_SW_PASS1_DONE,
};

enum isp_module_event_type {
	ISP_MODULE_EVENT_TYPE_ISP,
	ISP_MODULE_EVENT_TYPE_DMA,
	ISP_MODULE_EVENT_TYPE_CQ_INT,
	ISP_MODULE_EVENT_TYPE_CQ_INT2,
	ISP_MODULE_EVENT_TYPE_CQ_INT3,
};

enum camsys_type {
	CAMSYS_SIDE0,
	CAMSYS_SIDE1,
	CAMSYS_GAZE0,
	CAMSYS_GAZE1,
	CAMSYS_NUM
};

enum imgsys_type {
	IMGSYS_SIDE0,
	IMGSYS_SIDE1,
	IMGSYS_GAZE0,
	IMGSYS_GAZE1,
	IMGSYS_NUM
};

enum isp_module_type {
	ISP_MODULE_CAM,
	ISP_MODULE_CAMSV,
	ISP_MODULE_BE,
	ISP_MODULE_DIP,
};

enum isp_module_callback_type {
	ISP_CB_EVENT_SOF,
	ISP_CB_EVENT_MAX,
};

struct event_req {
	int module_id;
	int user_key;
	unsigned long event;
	int mode; /* enum isp_irq_mode */
	unsigned int timeout;
};

struct rbsync_info {
	int module_id;
	long kva;
};

#define EVENT_BIT_MASK 0xffff
#define EVENT_TYPE_BIT_MASK 0xff0000
#define EVENT_MODULE_BIT_MASK 0xf000000
#define EVENT_BITS 16
#define EVENT_TYPE_BITS (EVENT_BITS + 8)
#define MODULE_BITS (EVENT_TYPE_BITS + 4)
#define DECODE_EVENT_CMD_EVENT(e) (e & EVENT_BIT_MASK)
#define	DECODE_EVENT_CMD_EVENT_TYPE(e) ((e & EVENT_TYPE_BIT_MASK) >> EVENT_BITS)
#define DECODE_EVENT_CMD_EVENT_MODULE(e) \
	((e & EVENT_MODULE_BIT_MASK) >> EVENT_TYPE_BITS)
#define __ISP_MODULE_EVENT_CMD(m_type, e_type, e) \
	(((m_type) << EVENT_TYPE_BITS | \
	  (e_type) << EVENT_BITS | \
	  (e)))

#define ISP_MODULE_EVENT_CAM_VSYNC \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_CAM,\
	ISP_MODULE_EVENT_TYPE_ISP, ISP_MODULE_EVENT_VSYNC)

#define ISP_MODULE_EVENT_CAM_HW_PASS1_DONE \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_CAM,\
	ISP_MODULE_EVENT_TYPE_ISP, ISP_MODULE_EVENT_HW_PASS1_DONE)

#define ISP_MODULE_EVENT_CAM_SOF \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_CAM,\
	ISP_MODULE_EVENT_TYPE_ISP, ISP_MODULE_EVENT_SOF)

#define ISP_MODULE_EVENT_CAM_SW_PASS1_DONE \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_CAM,\
	ISP_MODULE_EVENT_TYPE_ISP, ISP_MODULE_EVENT_SW_PASS1_DONE)

#define ISP_MODULE_EVENT_CAM_CQ_THR0_DONE \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_CAM,\
	ISP_MODULE_EVENT_TYPE_DMA, ISP_MODULE_EVENT_CQ_THR0_DONE)

#define ISP_MODULE_EVENT_DIP_PASS2_DONE \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_DIP,\
	ISP_MODULE_EVENT_TYPE_ISP, ISP_MODULE_PASS2_DONE_STATUS)

#define ISP_MODULE_EVENT_DIP_IMG3O_DONE \
	__ISP_MODULE_EVENT_CMD(ISP_MODULE_DIP,\
	ISP_MODULE_EVENT_TYPE_ISP, ISP_MODULE_IMG3O_DONE_STATUS)

#define ISP_MAGIC 'k'
#define ISP_RESET_BY_HWMODULE _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_RESET_BY_HWMODULE, unsigned int)
#define ISP_WAIT_IRQ _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_WAIT_IRQ, struct event_req)
#define ISP_REGISTER_IRQ_USER_KEY _IOWR(\
	ISP_MAGIC, ISP_DEV_CMD_REGISTER_IRQ_USER_KEY, struct isp_userkey)
#define ISP_FLUSH_IRQ_REQUEST _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_FLUSH_IRQ_REQUEST, struct event_req)
#define ISP_QUERY_HWMODULE_INFO	_IOWR(\
	ISP_MAGIC, ISP_DEV_CMD_QUERY_MODULE_INFO, struct isp_module_info)
#define ISP_QUERY_NUM_USER_KEY _IOR(\
	ISP_MAGIC, ISP_DEV_CMD_QUERY_NUM_USER_KEY, unsigned int)
#define ISP_CLEAR_IRQ_REQUEST _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_CLEAR_IRQ, struct event_req)
#define ISP_CONFIG_CSI_BY_EFUSE _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_CONFIG_CSI_BY_EFUSE, unsigned int)
#define ISP_CONFIG_CSI_CPHY_MASK_CAL _IOW(\
		ISP_MAGIC, ISP_DEV_CMD_CONFIG_CSI_CPHY_MASK_CAL, unsigned int)
#define ISP_SET_DIP_WARP_SB_INFO _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_SET_DIP_WARP_SB_INFO, struct rbsync_info)
#define ISP_SET_POLL_TRIGGER _IOW(\
	ISP_MAGIC, ISP_DEV_CMD_SET_POLL_TIRGGER, struct event_req)

#endif /* __ISP_EXT_H */
