#ifndef __PWR_CTRL_REG_H__
#define __PWR_CTRL_REG_H__

/* ----------------- Register Definitions ------------------- */
#define POWERON_CONFIG_EN				0x00000000
	#define BCLK_CG_EN					BIT(0)
	#define PROJECT_CODE				0x0B160000
#define PWR_STATUS						0x00000190
	#define PWR_STATUS_MM_CORE			BIT(7)
	#define PWR_STATUS_MM_COM			BIT(8)
	#define PWR_STATUS_MM_GAZE			BIT(9)
	#define PWR_STATUS_CAM_SIDE0		BIT(10)
	#define PWR_STATUS_CAM_SIDE1		BIT(11)
	#define PWR_STATUS_IMG_SIDE0		BIT(12)
	#define PWR_STATUS_IMG_SIDE1		BIT(13)
	#define PWR_STATUS_CAM_IMG_GZ0		BIT(14)
	#define PWR_STATUS_CAM_IMG_GZ1		BIT(15)
	#define PWR_STATUS_SYSRAM_STBUR		BIT(16)
	#define PWR_STATUS_SYSRAM_GAZE		BIT(17)
	#define PWR_STATUS_SYSRAM_VR_TRK	BIT(18)
	#define PWR_STATUS_DP				BIT(19)
	#define PWR_STATUS_VPU_VCORE		BIT(20)
	#define PWR_STATUS_VPU_CONN			BIT(21)
	#define PWR_STATUS_VPU0				BIT(22)
	#define PWR_STATUS_VPU1				BIT(23)
	#define PWR_STATUS_VPU2				BIT(24)
	#define PWR_STATUS_MFG0				BIT(25)
	#define PWR_STATUS_MFG1				BIT(26)
	#define PWR_STATUS_MFG2				BIT(27)
	#define PWR_STATUS_MFG3				BIT(28)
#define PWR_STATUS_2ND						0x00000194
	#define PWR_STATUS_2ND_MM_CORE			BIT(7)
	#define PWR_STATUS_2ND_MM_COM			BIT(8)
	#define PWR_STATUS_2ND_MM_GAZE			BIT(9)
	#define PWR_STATUS_2ND_CAM_SIDE0		BIT(10)
	#define PWR_STATUS_2ND_CAM_SIDE1		BIT(11)
	#define PWR_STATUS_2ND_IMG_SIDE0		BIT(12)
	#define PWR_STATUS_2ND_IMG_SIDE1		BIT(13)
	#define PWR_STATUS_2ND_CAM_IMG_GZ0		BIT(14)
	#define PWR_STATUS_2ND_CAM_IMG_GZ1		BIT(15)
	#define PWR_STATUS_2ND_SYSRAM_STBUR		BIT(16)
	#define PWR_STATUS_2ND_SYSRAM_GAZE		BIT(17)
	#define PWR_STATUS_2ND_SYSRAM_VR_TRK	BIT(18)
	#define PWR_STATUS_2ND_DP				BIT(19)
	#define PWR_STATUS_2ND_VPU_VCORE		BIT(20)
	#define PWR_STATUS_2ND_VPU_CONN			BIT(21)
	#define PWR_STATUS_2ND_VPU0				BIT(22)
	#define PWR_STATUS_2ND_VPU1				BIT(23)
	#define PWR_STATUS_2ND_VPU2				BIT(24)
	#define PWR_STATUS_2ND_MFG0				BIT(25)
	#define PWR_STATUS_2ND_MFG1				BIT(26)
	#define PWR_STATUS_2ND_MFG2				BIT(27)
	#define PWR_STATUS_2ND_MFG3				BIT(28)
#define CPU_PWR_STATUS					0x00000198
	#define PWR_STATUS_MP0_CPU0			BIT(5)
	#define PWR_STATUS_MP0_CPU1			BIT(6)
	#define PWR_STATUS_MP0_CPU2			BIT(7)
	#define PWR_STATUS_MP0_CPU3			BIT(8)
	#define PWR_STATUS_MP0				BIT(13)
#define CPU_PWR_STATUS_2ND				0x0000019c
	#define PWR_STATUS_2ND_MP0_CPU0		BIT(5)
	#define PWR_STATUS_2ND_MP0_CPU1		BIT(6)
	#define PWR_STATUS_2ND_MP0_CPU2		BIT(7)
	#define PWR_STATUS_2ND_MP0_CPU3		BIT(8)
	#define PWR_STATUS_2ND_MP0			BIT(13)
#define MP0_TOP_PWR_CON						0x00000208
	#define MP0_TOP_PWR_RST_B				BIT(0)
	#define MP0_TOP_PWR_ISO					BIT(1)
	#define MP0_TOP_PWR_ON					BIT(2)
	#define MP0_TOP_PWR_ON_2ND				BIT(3)
	#define MP0_TOP_PWR_CLK_DIS				BIT(4)
	#define MP0_TOP_SRAM_CKISO				BIT(5)
	#define MP0_TOP_SRAM_ISOINT_B			BIT(6)
	#define MP0_TOP_SRAM_PD_SLPB_CLAMP		BIT(7)
	#define MP0_TOP_SRAM_PDN				BIT(8)
	#define MP0_TOP_SRAM_SLEEP_B			BIT(12)
	#define SC_MP0_TOP_SRAM_PDN_ACK			BIT(24)
	#define SC_MP0_TOP_SRAM_SLEEP_B_ACK		BIT(28)
	#define SC_MP0_TOP_PWR_ACK				BIT(30)
	#define SC_MP0_TOP_PWR_ACK_2ND			BIT(31)
#define MP0_CPU0_PWR_CON					0x0000020c
	#define MP0_CPU0_PWR_RST_B				BIT(0)
	#define MP0_CPU0_PWR_ISO				BIT(1)
	#define MP0_CPU0_PWR_ON					BIT(2)
	#define MP0_CPU0_PWR_ON_2ND				BIT(3)
	#define MP0_CPU0_PWR_CLK_DIS			BIT(4)
	#define MP0_CPU0_SRAM_CKISO				BIT(5)
	#define MP0_CPU0_SRAM_ISOINT_B			BIT(6)
	#define MP0_CPU0_SRAM_PD_SLPB_CLAMP		BIT(7)
	#define MP0_CPU0_SRAM_PDN				BIT(8)
	#define MP0_CPU0_SRAM_SLEEP_B			BIT(12)
	#define SC_MP0_CPU0_SRAM_PDN_ACK		BIT(24)
	#define SC_MP0_CPU0_SRAM_SLEEP_B_ACK	BIT(28)
	#define SC_MP0_CPU0_PWR_ACK				BIT(30)
	#define SC_MP0_CPU0_PWR_ACK_2ND			BIT(31)
#define MP0_CPU1_PWR_CON					0x00000210
	#define MP0_CPU1_PWR_RST_B				BIT(0)
	#define MP0_CPU1_PWR_ISO				BIT(1)
	#define MP0_CPU1_PWR_ON					BIT(2)
	#define MP0_CPU1_PWR_ON_2ND				BIT(3)
	#define MP0_CPU1_PWR_CLK_DIS			BIT(4)
	#define MP0_CPU1_SRAM_CKISO				BIT(5)
	#define MP0_CPU1_SRAM_ISOINT_B			BIT(6)
	#define MP0_CPU1_SRAM_PD_SLPB_CLAMP		BIT(7)
	#define MP0_CPU1_SRAM_PDN				BIT(8)
	#define MP0_CPU1_SRAM_SLEEP_B			BIT(12)
	#define SC_MP0_CPU1_SRAM_PDN_ACK		BIT(24)
	#define SC_MP0_CPU1_SRAM_SLEEP_B_ACK	BIT(28)
	#define SC_MP0_CPU1_PWR_ACK				BIT(30)
	#define SC_MP0_CPU1_PWR_ACK_2ND			BIT(31)
#define MP0_CPU2_PWR_CON					0x00000214
	#define MP0_CPU2_PWR_RST_B				BIT(0)
	#define MP0_CPU2_PWR_ISO				BIT(1)
	#define MP0_CPU2_PWR_ON					BIT(2)
	#define MP0_CPU2_PWR_ON_2ND				BIT(3)
	#define MP0_CPU2_PWR_CLK_DIS			BIT(4)
	#define MP0_CPU2_SRAM_CKISO				BIT(5)
	#define MP0_CPU2_SRAM_ISOINT_B			BIT(6)
	#define MP0_CPU2_SRAM_PD_SLPB_CLAMP		BIT(7)
	#define MP0_CPU2_SRAM_PDN				BIT(8)
	#define MP0_CPU2_SRAM_SLEEP_B			BIT(12)
	#define SC_MP0_CPU2_SRAM_PDN_ACK		BIT(24)
	#define SC_MP0_CPU2_SRAM_SLEEP_B_ACK	BIT(28)
	#define SC_MP0_CPU2_PWR_ACK				BIT(30)
	#define SC_MP0_CPU2_PWR_ACK_2ND			BIT(31)
#define MP0_CPU3_PWR_CON					0x00000218
	#define MP0_CPU3_PWR_RST_B				BIT(0)
	#define MP0_CPU3_PWR_ISO				BIT(1)
	#define MP0_CPU3_PWR_ON					BIT(2)
	#define MP0_CPU3_PWR_ON_2ND				BIT(3)
	#define MP0_CPU3_PWR_CLK_DIS			BIT(4)
	#define MP0_CPU3_SRAM_CKISO				BIT(5)
	#define MP0_CPU3_SRAM_ISOINT_B			BIT(6)
	#define MP0_CPU3_SRAM_PD_SLPB_CLAMP		BIT(7)
	#define MP0_CPU3_SRAM_PDN				BIT(8)
	#define MP0_CPU3_SRAM_SLEEP_B			BIT(12)
	#define SC_MP0_CPU3_SRAM_PDN_ACK		BIT(24)
	#define SC_MP0_CPU3_SRAM_SLEEP_B_ACK	BIT(28)
	#define SC_MP0_CPU3_PWR_ACK				BIT(30)
	#define SC_MP0_CPU3_PWR_ACK_2ND			BIT(31)
#define MFG0_PWR_CON					0x000002E0
	#define MFG0_PWR_RST_B				BIT(0)
	#define MFG0_PWR_ISO				BIT(1)
	#define MFG0_PWR_ON					BIT(2)
	#define MFG0_PWR_ON_2ND				BIT(3)
	#define MFG0_PWR_CLK_DIS			BIT(4)
#define MFG1_PWR_CON					0x000002E4
	#define MFG1_PWR_RST_B				BIT(0)
	#define MFG1_PWR_ISO				BIT(1)
	#define MFG1_PWR_ON					BIT(2)
	#define MFG1_PWR_ON_2ND				BIT(3)
	#define MFG1_PWR_CLK_DIS			BIT(4)
	#define MFG1_SRAM_PDN				BIT(8)
	#define MFG1_SRAM_PDN_ACK			BIT(24)
#define MFG2_PWR_CON					0x000002E8
	#define MFG2_PWR_RST_B				BIT(0)
	#define MFG2_PWR_ISO				BIT(1)
	#define MFG2_PWR_ON					BIT(2)
	#define MFG2_PWR_ON_2ND				BIT(3)
	#define MFG2_PWR_CLK_DIS			BIT(4)
	#define MFG2_SRAM_PDN				BIT(8)
	#define MFG2_SRAM_PDN_ACK			BIT(24)
#define MFG3_PWR_CON					0x000002EC
	#define MFG3_PWR_RST_B				BIT(0)
	#define MFG3_PWR_ISO				BIT(1)
	#define MFG3_PWR_ON					BIT(2)
	#define MFG3_PWR_ON_2ND				BIT(3)
	#define MFG3_PWR_CLK_DIS			BIT(4)
	#define MFG3_SRAM_PDN				BIT(8)
	#define MFG3_SRAM_PDN_ACK			BIT(24)
#define VPU0_PWR_CON					0x000002F0
	#define VPU0_PWR_RST_B				BIT(0)
	#define VPU0_PWR_ISO				BIT(1)
	#define VPU0_PWR_ON					BIT(2)
	#define VPU0_PWR_ON_2ND				BIT(3)
	#define VPU0_PWR_CLK_DIS			BIT(4)
#define VPU1_PWR_CON					0x000002F4
	#define VPU1_PWR_RST_B				BIT(0)
	#define VPU1_PWR_ISO				BIT(1)
	#define VPU1_PWR_ON					BIT(2)
	#define VPU1_PWR_ON_2ND				BIT(3)
	#define VPU1_PWR_CLK_DIS			BIT(4)
#define VPU2_PWR_CON					0x000002F8
	#define VPU2_PWR_RST_B				BIT(0)
	#define VPU2_PWR_ISO				BIT(1)
	#define VPU2_PWR_ON					BIT(2)
	#define VPU2_PWR_ON_2ND				BIT(3)
	#define VPU2_PWR_CLK_DIS			BIT(4)
#define MM_CORE_PWR_CON					0x00000324
	#define MM_CORE_PWR_RST_B			BIT(0)
	#define MM_CORE_PWR_ISO				BIT(1)
	#define MM_CORE_PWR_ON				BIT(2)
	#define MM_CORE_PWR_ON_2ND			BIT(3)
	#define MM_CORE_PWR_CLK_DIS			BIT(4)
	#define MM_CORE_SRAM_PDN			BIT(8)
	#define SC_MM_CORE_SRAM_PDN_ACK		BIT(24)
#define MM_COM_PWR_CON					0x00000334
	#define MM_COM_PWR_RST_B			BIT(0)
	#define MM_COM_PWR_ISO				BIT(1)
	#define MM_COM_PWR_ON				BIT(2)
	#define MM_COM_PWR_ON_2ND			BIT(3)
	#define MM_COM_PWR_CLK_DIS			BIT(4)
	#define MM_COM_SRAM_PDN				BIT(8)
	#define SC_MM_COM_SRAM_PDN_ACK		BIT(24)
#define MM_GAZE_PWR_CON					0x0000033c
	#define MM_GAZE_PWR_RST_B			BIT(0)
	#define MM_GAZE_PWR_ISO				BIT(1)
	#define MM_GAZE_PWR_ON				BIT(2)
	#define MM_GAZE_PWR_ON_2ND			BIT(3)
	#define MM_GAZE_PWR_CLK_DIS			BIT(4)
	#define MM_GAZE_SRAM_PDN			BIT(8)
	#define SC_MM_GAZE_SRAM_PDN_ACK		BIT(24)
#define IMG_SIDE0_PWR_CON				0x00000344
	#define IMG_SIDE0_PWR_RST_B			BIT(0)
	#define IMG_SIDE0_PWR_ISO			BIT(1)
	#define IMG_SIDE0_PWR_ON			BIT(2)
	#define IMG_SIDE0_PWR_ON_2ND		BIT(3)
	#define IMG_SIDE0_PWR_CLK_DIS		BIT(4)
	#define IMG_SIDE0_SRAM_PDN			BIT(8)
	#define IMG_SIDE0_SRAM_PDN_ACK		BIT(24)
#define IMG_SIDE1_PWR_CON				0x00000348
	#define IMG_SIDE1_PWR_RST_B			BIT(0)
	#define IMG_SIDE1_PWR_ISO			BIT(1)
	#define IMG_SIDE1_PWR_ON			BIT(2)
	#define IMG_SIDE1_PWR_ON_2ND		BIT(3)
	#define IMG_SIDE1_PWR_CLK_DIS		BIT(4)
	#define IMG_SIDE1_SRAM_PDN			BIT(8)
	#define IMG_SIDE1_SRAM_PDN_ACK		BIT(24)
#define CAM_SIDE0_PWR_CON				0x00000350
	#define CAM_SIDE0_PWR_RST_B			BIT(0)
	#define CAM_SIDE0_PWR_ISO			BIT(1)
	#define CAM_SIDE0_PWR_ON			BIT(2)
	#define CAM_SIDE0_PWR_ON_2ND		BIT(3)
	#define CAM_SIDE0_PWR_CLK_DIS		BIT(4)
	#define CAM_SIDE0_SRAM_PDN			GENMASK(11, 8)
	#define CAM_SIDE0_SRAM_PDN_ACK		GENMASK(27, 24)
#define CAM_IMG_GZ0_PWR_CON				0x00000354
	#define CAM_IMG_GZ0_PWR_RST_B		BIT(0)
	#define CAM_IMG_GZ0_PWR_ISO			BIT(1)
	#define CAM_IMG_GZ0_PWR_ON			BIT(2)
	#define CAM_IMG_GZ0_PWR_ON_2ND		BIT(3)
	#define CAM_IMG_GZ0_PWR_CLK_DIS		BIT(4)
	#define CAM_IMG_GZ0_SRAM_PDN		GENMASK(11, 8)
	#define CAM_IMG_GZ0_SRAM_PDN_ACK	GENMASK(27, 24)
#define CAM_SIDE1_PWR_CON				0x00000358
	#define CAM_SIDE1_PWR_RST_B			BIT(0)
	#define CAM_SIDE1_PWR_ISO			BIT(1)
	#define CAM_SIDE1_PWR_ON			BIT(2)
	#define CAM_SIDE1_PWR_ON_2ND		BIT(3)
	#define CAM_SIDE1_PWR_CLK_DIS		BIT(4)
	#define CAM_SIDE1_SRAM_PDN			GENMASK(11, 8)
	#define CAM_SIDE1_SRAM_PDN_ACK		GENMASK(27, 24)
#define CAM_IMG_GZ1_PWR_CON				0x0000035c
	#define CAM_IMG_GZ1_PWR_RST_B		BIT(0)
	#define CAM_IMG_GZ1_PWR_ISO			BIT(1)
	#define CAM_IMG_GZ1_PWR_ON			BIT(2)
	#define CAM_IMG_GZ1_PWR_ON_2ND		BIT(3)
	#define CAM_IMG_GZ1_PWR_CLK_DIS		BIT(4)
	#define CAM_IMG_GZ1_SRAM_PDN		GENMASK(11, 8)
	#define CAM_IMG_GZ1_SRAM_PDN_ACK	GENMASK(27, 24)
#define SYSRAM_STBUF_PWR_CON			0x00000360
	#define SYSRAM_STBUF_PWR_RST_B		BIT(0)
	#define SYSRAM_STBUF_PWR_ISO		BIT(1)
	#define SYSRAM_STBUF_PWR_ON			BIT(2)
	#define SYSRAM_STBUF_PWR_ON_2ND		BIT(3)
	#define SYSRAM_STBUF_PWR_CLK_DIS	BIT(4)
	#define SYSRAM_STBUF_SRAM_PDN		GENMASK(11, 8)
	#define SYSRAM_STBUF_SRAM_PDN_ACK	GENMASK(27, 24)
#define SYSRAM_GAZE_PWR_CON				0x00000364
	#define SYSRAM_GAZE_PWR_RST_B		BIT(0)
	#define SYSRAM_GAZE_PWR_ISO			BIT(1)
	#define SYSRAM_GAZE_PWR_ON			BIT(2)
	#define SYSRAM_GAZE_PWR_ON_2ND		BIT(3)
	#define SYSRAM_GAZE_PWR_CLK_DIS		BIT(4)
	#define SYSRAM_GAZE_SRAM_PDN		GENMASK(11, 8)
	#define SYSRAM_GAZE_SRAM_PDN_ACK	GENMASK(27, 24)
#define SYSRAM_VR_TRK_PWR_CON			0x0000036c
	#define SYSRAM_VR_TRK_PWR_RST_B		BIT(0)
	#define SYSRAM_VR_TRK_PWR_ISO		BIT(1)
	#define SYSRAM_VR_TRK_PWR_ON		BIT(2)
	#define SYSRAM_VR_TRK_PWR_ON_2ND	BIT(3)
	#define SYSRAM_VR_TRK_PWR_CLK_DIS	BIT(4)
	#define SYSRAM_VR_TRK_SRAM_PDN		GENMASK(11, 8)
	#define SYSRAM_VR_TRK_SRAM_PDN_ACK	GENMASK(27, 24)
#define VPU_CORE_PWR_CON				0x00000370
	#define VPU_CORE_PWR_RST_B			BIT(0)
	#define VPU_CORE_PWR_ISO			BIT(1)
	#define VPU_CORE_PWR_ON				BIT(2)
	#define VPU_CORE_PWR_ON_2ND			BIT(3)
	#define VPU_CORE_PWR_CLK_DIS		BIT(4)
	#define VPU_CORE_SRAM_PDN			GENMASK(11, 8)
	#define VPU_CORE_SRAM_PDN_ACK		GENMASK(27, 24)
#define VPU_CONN_PWR_CON				0x00000374
	#define VPU_CONN_PWR_RST_B			BIT(0)
	#define VPU_CONN_PWR_ISO			BIT(1)
	#define VPU_CONN_PWR_ON				BIT(2)
	#define VPU_CONN_PWR_ON_2ND			BIT(3)
	#define VPU_CONN_PWR_CLK_DIS		BIT(4)
	#define VPU_CONN_SRAM_PDN			GENMASK(11, 8)
	#define VPU_CONN_SRAM_PDN_ACK		GENMASK(27, 24)
#define DP_PWR_CON					0x00000378
	#define DP_PWR_RST_B			BIT(0)
	#define DP_PWR_ISO				BIT(1)
	#define DP_PWR_ON				BIT(2)
	#define DP_PWR_ON_2ND			BIT(3)
	#define DP_PWR_CLK_DIS			BIT(4)
	#define DP_SRAM_CKISO			BIT(5)
	#define DP_SRAM_ISOINT_B		BIT(6)
	#define DP_SRAM_PDN				GENMASK(11, 8)
	#define DP_SRAM_SLEEP_B			GENMASK(15, 12)
	#define SC_DP_SRAM_PDN_ACK		GENMASK(27, 24)
#define DP_PHY_PWR_CON					0x00000384
	#define DP_PHY_PWR_RST_B			BIT(0)
	#define DP_PHY_PWR_ISO				BIT(1)
	#define DP_PHY_PWR_ON				BIT(2)
	#define DP_PHY_PWR_ON_2ND			BIT(3)
#define SCP_SRAM_CON					0x00000398
	#define SCP_SRAM_ISOINT_B			BIT(1)
	#define SCP_SRAM_SLEEP_B			BIT(4)
#define EXT_BUCK_ISO					0x000003a8
	#define VPU0_EXT_BUCK_ISO			BIT(0)
	#define VPU1_EXT_BUCK_ISO			BIT(1)
	#define VPU2_EXT_BUCK_ISO			BIT(2)
	#define MP_VPROC_EXT_BUCK_ISO		BIT(3)
	#define VPU_CONN_EXT_BUCK_ISO		BIT(5)
#define VPU0_SRAM_CON					0x000003b0
	#define VPU0_SRAM_CKISO				BIT(0)
	#define VPU0_SRAM_ISOINT_B			BIT(1)
	#define VPU0_SRAM_SLEEP_B			GENMASK(11, 4)
	#define VPU0_SRAM_PDN				GENMASK(23, 12)
	#define SC_VPU0_SRAM_PDN_ACK		GENMASK(27, 24)
#define VPU1_SRAM_CON					0x000003b4
	#define VPU1_SRAM_CKISO				BIT(0)
	#define VPU1_SRAM_ISOINT_B			BIT(1)
	#define VPU1_SRAM_SLEEP_B			GENMASK(11, 4)
	#define VPU1_SRAM_PDN				GENMASK(23, 12)
	#define SC_VPU1_SRAM_PDN_ACK		GENMASK(27, 24)
#define VPU2_SRAM_CON					0x000003b8
	#define VPU2_SRAM_CKISO				BIT(0)
	#define VPU2_SRAM_ISOINT_B			BIT(1)
	#define VPU2_SRAM_SLEEP_B			GENMASK(11, 4)
	#define VPU2_SRAM_PDN				GENMASK(23, 12)
	#define SC_VPU2_SRAM_PDN_ACK		GENMASK(27, 24)
#define ELS_ISO_EN_CON					0x000003bc
	#define EMI_ELS_ISO					BIT(0)
	#define DPY_CH0_ELS_ISO				BIT(1)
	#define DPY_CH1_ELS_ISO				BIT(2)
	#define DPY_CH2_ELS_ISO				BIT(3)
	#define DPY_CH3_ELS_ISO				BIT(4)
	#define DP_ELS_ISO					BIT(7)

/* Group 1 */
#define SMI_COMMON0_CLAMP_EN_STA			0x00000000
#define SMI_COMMON0_CLAMP_EN_SET			0x00000004
#define SMI_COMMON0_CLAMP_EN_CLR			0x00000008
/* Group 2 */
#define SMI_COMMON1_CLAMP_EN_STA			0x00000000
#define SMI_COMMON1_CLAMP_EN_SET			0x00000004
#define SMI_COMMON1_CLAMP_EN_CLR			0x00000008
/* Group 3 */
#define SYSRAM0_SMI_COMMON0_CLAMP_EN_STA		0x00000000
#define SYSRAM0_SMI_COMMON0_CLAMP_EN_SET		0x00000004
#define SYSRAM0_SMI_COMMON0_CLAMP_EN_CLR		0x00000008
/* Group 4 */
#define SYSRAM0_SMI_COMMON1_CLAMP_EN_STA		0x00000000
#define SYSRAM0_SMI_COMMON1_CLAMP_EN_SET		0x00000004
#define SYSRAM0_SMI_COMMON1_CLAMP_EN_CLR		0x00000008
/* Group 5 */
#define SYSRAM2_SMI_COMMON0_CLAMP_EN_STA		0x00000000
#define SYSRAM2_SMI_COMMON0_CLAMP_EN_SET		0x00000004
#define SYSRAM2_SMI_COMMON0_CLAMP_EN_CLR		0x00000008
/* Group 6 */
#define SYSRAM2_SMI_COMMON1_CLAMP_EN_STA		0x00000000
#define SYSRAM2_SMI_COMMON1_CLAMP_EN_SET		0x00000004
#define SYSRAM2_SMI_COMMON1_CLAMP_EN_CLR		0x00000008
/* Group 7 */
#define SYSRAM4_SMI_COMMON_CLAMP_EN_STA			0x00000000
#define SYSRAM4_SMI_COMMON_CLAMP_EN_SET			0x00000004
#define SYSRAM4_SMI_COMMON_CLAMP_EN_CLR			0x00000008
/* Group 8 */
#define SYSRAM5_SMI_COMMON_CLAMP_EN_STA			0x00000000
#define SYSRAM5_SMI_COMMON_CLAMP_EN_SET			0x00000004
#define SYSRAM5_SMI_COMMON_CLAMP_EN_CLR			0x00000008
/* Group 9 */
#define SYSRAM6_SMI_COMMON_CLAMP_EN_STA			0x00000000
#define SYSRAM6_SMI_COMMON_CLAMP_EN_SET			0x00000004
#define SYSRAM6_SMI_COMMON_CLAMP_EN_CLR			0x00000008

#endif /*__PWR_CTRL_REG_H__*/
