/*
 * Copyright (c) 2014 MediaTek Inc.
 * Author: Hongzhou.Yang <hongzhou.yang@mediatek.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef __PINCTRL_MTK_MT3612_H
#define __PINCTRL_MTK_MT3612_H

#include <linux/pinctrl/pinctrl.h>
#include <pinctrl-mtk-common.h>

/** @ingroup IP_group_gpio_internal_struct
 * @brief define mt3612 gpio pin description struct.
 */
static const struct mtk_desc_pin mtk_pins_mt3612[] = {
	MTK_PIN(
		PINCTRL_PIN(0, "GPIO0"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 0),
		MTK_FUNCTION(0, "GPIO0"),
		MTK_FUNCTION(1, "SSUSB1_VBUS_VALID")
	),
	MTK_PIN(
		PINCTRL_PIN(1, "GPIO1"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 1),
		MTK_FUNCTION(0, "GPIO1"),
		MTK_FUNCTION(1, "DPRX_HPD")
	),
	MTK_PIN(
		PINCTRL_PIN(2, "GPIO2"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 2),
		MTK_FUNCTION(0, "DPRX_AUX_P_DC")
	),
	MTK_PIN(
		PINCTRL_PIN(3, "GPIO3"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 3),
		MTK_FUNCTION(0, "GPIO3"),
		MTK_FUNCTION(1, "DPRX_AUX_N_DC")
	),
	MTK_PIN(
		PINCTRL_PIN(4, "GPIO4"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 4),
		MTK_FUNCTION(0, "GPIO4"),
		MTK_FUNCTION(1, "DPRX_CFG1")
	),
	MTK_PIN(
		PINCTRL_PIN(5, "GPIO5"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 5),
		MTK_FUNCTION(0, "GPIO5"),
		MTK_FUNCTION(1, "DPRX_CFG2")
	),
	MTK_PIN(
		PINCTRL_PIN(6, "GPIO6"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 6),
		MTK_FUNCTION(0, "GPIO6"),
		MTK_FUNCTION(1, "PWM_4"),
		MTK_FUNCTION(2, "GPT2_I"),
		MTK_FUNCTION(3, "UART3_TX"),
		MTK_FUNCTION(4, "SPI_M3_CK"),
		MTK_FUNCTION(5, "I2C_SSUSB_DP_SDA_0"),
		MTK_FUNCTION(7, "DBG_MON_A4")
	),
	MTK_PIN(
		PINCTRL_PIN(7, "GPIO7"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 7),
		MTK_FUNCTION(0, "GPIO7"),
		MTK_FUNCTION(1, "PWM_5"),
		MTK_FUNCTION(2, "GPT2_O"),
		MTK_FUNCTION(3, "UART3_RX"),
		MTK_FUNCTION(4, "SPI_M3_CS"),
		MTK_FUNCTION(5, "I2C_SSUSB_DP_SCL_0"),
		MTK_FUNCTION(7, "DBG_MON_A5")
	),
	MTK_PIN(
		PINCTRL_PIN(8, "GPIO8"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 8),
		MTK_FUNCTION(0, "GPIO8"),
		MTK_FUNCTION(1, "PWM_6"),
		MTK_FUNCTION(2, "GPT3_I"),
		MTK_FUNCTION(3, "I2C4_SCL"),
		MTK_FUNCTION(4, "SPI_M3_MOSI"),
		MTK_FUNCTION(5, "I2C_SSUSB_DP_SDA_1"),
		MTK_FUNCTION(7, "DBG_MON_A6")
	),
	MTK_PIN(
		PINCTRL_PIN(9, "GPIO9"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 9),
		MTK_FUNCTION(0, "GPIO9"),
		MTK_FUNCTION(1, "PWM_7"),
		MTK_FUNCTION(2, "GPT3_O"),
		MTK_FUNCTION(3, "I2C4_SDA"),
		MTK_FUNCTION(4, "SPI_M3_MISO"),
		MTK_FUNCTION(5, "I2C_SSUSB_DP_SCL_1"),
		MTK_FUNCTION(7, "DBG_MON_A7")
	),
	MTK_PIN(
		PINCTRL_PIN(10, "GPIO10"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 10),
		MTK_FUNCTION(0, "GPIO10"),
		MTK_FUNCTION(1, "PWM_8"),
		MTK_FUNCTION(2, "GPT4_I"),
		MTK_FUNCTION(3, "UART4_TX"),
		MTK_FUNCTION(4, "SPI_M4_CK"),
		MTK_FUNCTION(5, "I2C_SSUSB_PE_SDA_0"),
		MTK_FUNCTION(6, "DISP_PWM"),
		MTK_FUNCTION(7, "DBG_MON_A8")
	),
	MTK_PIN(
		PINCTRL_PIN(11, "GPIO11"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 11),
		MTK_FUNCTION(0, "GPIO11"),
		MTK_FUNCTION(1, "PWM_9"),
		MTK_FUNCTION(2, "GPT4_O"),
		MTK_FUNCTION(3, "UART4_RX"),
		MTK_FUNCTION(4, "SPI_M4_CS"),
		MTK_FUNCTION(5, "I2C_SSUSB_PE_SCL_0"),
		MTK_FUNCTION(7, "DBG_MON_A9")
	),
	MTK_PIN(
		PINCTRL_PIN(12, "GPIO12"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 12),
		MTK_FUNCTION(0, "GPIO12"),
		MTK_FUNCTION(1, "PWM_10"),
		MTK_FUNCTION(2, "GPT5_I"),
		MTK_FUNCTION(3, "I2C5_SCL"),
		MTK_FUNCTION(4, "SPI_M4_MOSI"),
		MTK_FUNCTION(5, "I2C_SSUSB_PE_SDA_1"),
		MTK_FUNCTION(6, "CLKM0"),
		MTK_FUNCTION(7, "DBG_MON_A10")
	),
	MTK_PIN(
		PINCTRL_PIN(13, "GPIO13"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 13),
		MTK_FUNCTION(0, "GPIO13"),
		MTK_FUNCTION(1, "PWM_11"),
		MTK_FUNCTION(2, "GPT5_O"),
		MTK_FUNCTION(3, "I2C5_SDA"),
		MTK_FUNCTION(4, "SPI_M4_MISO"),
		MTK_FUNCTION(5, "I2C_SSUSB_PE_SCL_1"),
		MTK_FUNCTION(6, "CLKM1"),
		MTK_FUNCTION(7, "DBG_MON_A11")
	),
	MTK_PIN(
		PINCTRL_PIN(14, "GPIO14"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 14),
		MTK_FUNCTION(0, "GPIO14"),
		MTK_FUNCTION(1, "PWM_12"),
		MTK_FUNCTION(2, "GPT6_I"),
		MTK_FUNCTION(3, "UART5_TX"),
		MTK_FUNCTION(4, "SPI_M5_CK"),
		MTK_FUNCTION(6, "CLKM2"),
		MTK_FUNCTION(7, "DBG_MON_A12")
	),
	MTK_PIN(
		PINCTRL_PIN(15, "GPIO15"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 15),
		MTK_FUNCTION(0, "GPIO15"),
		MTK_FUNCTION(1, "PWM_13"),
		MTK_FUNCTION(2, "GPT6_O"),
		MTK_FUNCTION(3, "UART5_RX"),
		MTK_FUNCTION(4, "SPI_M5_CS"),
		MTK_FUNCTION(6, "CLKM3"),
		MTK_FUNCTION(7, "DBG_MON_A13")
	),
	MTK_PIN(
		PINCTRL_PIN(16, "GPIO16"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 16),
		MTK_FUNCTION(0, "GPIO16"),
		MTK_FUNCTION(1, "PWM_14"),
		MTK_FUNCTION(2, "GPT7_I"),
		MTK_FUNCTION(3, "I2C6_SCL"),
		MTK_FUNCTION(4, "SPI_M5_MOSI"),
		MTK_FUNCTION(6, "CLKM4"),
		MTK_FUNCTION(7, "DBG_MON_A14")
	),
	MTK_PIN(
		PINCTRL_PIN(17, "GPIO17"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 17),
		MTK_FUNCTION(0, "GPIO17"),
		MTK_FUNCTION(1, "PWM_15"),
		MTK_FUNCTION(2, "GPT7_O"),
		MTK_FUNCTION(3, "I2C6_SDA"),
		MTK_FUNCTION(4, "SPI_M5_MISO"),
		MTK_FUNCTION(6, "CLKM5"),
		MTK_FUNCTION(7, "DBG_MON_A15")
	),
	MTK_PIN(
		PINCTRL_PIN(18, "GPIO18"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 18),
		MTK_FUNCTION(0, "GPIO18"),
		MTK_FUNCTION(1, "PWM_20"),
		MTK_FUNCTION(2, "GPT10_I"),
		MTK_FUNCTION(3, "UART7_TX"),
		MTK_FUNCTION(4, "SPI_M7_CK"),
		MTK_FUNCTION(7, "DBG_MON_A20")
	),
	MTK_PIN(
		PINCTRL_PIN(19, "GPIO19"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 19),
		MTK_FUNCTION(0, "GPIO19"),
		MTK_FUNCTION(1, "PWM_21"),
		MTK_FUNCTION(2, "GPT10_O"),
		MTK_FUNCTION(3, "UART7_RX"),
		MTK_FUNCTION(4, "SPI_M7_CS"),
		MTK_FUNCTION(7, "DBG_MON_A21")
	),
	MTK_PIN(
		PINCTRL_PIN(20, "GPIO20"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 20),
		MTK_FUNCTION(0, "GPIO20"),
		MTK_FUNCTION(1, "SPI_M0_CK"),
		MTK_FUNCTION(3, "PMICSPI1_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(21, "GPIO21"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 21),
		MTK_FUNCTION(0, "GPIO21"),
		MTK_FUNCTION(1, "SPI_M0_CS"),
		MTK_FUNCTION(3, "PMICSPI1_CS")
	),
	MTK_PIN(
		PINCTRL_PIN(22, "GPIO22"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 22),
		MTK_FUNCTION(0, "GPIO22"),
		MTK_FUNCTION(1, "SPI_M0_MOSI"),
		MTK_FUNCTION(3, "PMICSPI1_MOSI")
	),
	MTK_PIN(
		PINCTRL_PIN(23, "GPIO23"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 23),
		MTK_FUNCTION(0, "GPIO23"),
		MTK_FUNCTION(1, "SPI_M0_MISO"),
		MTK_FUNCTION(3, "PMICSPI1_MISO")
	),
	MTK_PIN(
		PINCTRL_PIN(24, "GPIO24"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 24),
		MTK_FUNCTION(0, "GPIO24"),
		MTK_FUNCTION(1, "IMU_INT0")
	),
	MTK_PIN(
		PINCTRL_PIN(25, "GPIO25"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 25),
		MTK_FUNCTION(0, "GPIO25"),
		MTK_FUNCTION(1, "IMU_INT1")
	),
	MTK_PIN(
		PINCTRL_PIN(26, "GPIO26"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 26),
		MTK_FUNCTION(0, "GPIO26")
	),
	MTK_PIN(
		PINCTRL_PIN(27, "GPIO27"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 27),
		MTK_FUNCTION(0, "GPIO27")
	),
	MTK_PIN(
		PINCTRL_PIN(28, "GPIO28"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 28),
		MTK_FUNCTION(0, "GPIO28")
	),
	MTK_PIN(
		PINCTRL_PIN(29, "GPIO29"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 29),
		MTK_FUNCTION(0, "GPIO29")
	),
	MTK_PIN(
		PINCTRL_PIN(30, "GPIO30"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 30),
		MTK_FUNCTION(0, "GPIO30")
	),
	MTK_PIN(
		PINCTRL_PIN(31, "GPIO31"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 31),
		MTK_FUNCTION(0, "GPIO31"),
		MTK_FUNCTION(1, "I2S_MCK_TDM_IN"),
		MTK_FUNCTION(2, "I2S_MCK_I2S_IN"),
		MTK_FUNCTION(3, "I2S_MCK_TDM_OUT"),
		MTK_FUNCTION(4, "I2S_MCK_I2S_OUT"),
		MTK_FUNCTION(5, "I2S_DO3_DP"),
		MTK_FUNCTION(7, "BG_MON_B12")
	),
	MTK_PIN(
		PINCTRL_PIN(32, "GPIO32"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 32),
		MTK_FUNCTION(0, "GPIO32"),
		MTK_FUNCTION(1, "I2S_LRCK_TDM_IN"),
		MTK_FUNCTION(2, "I2S_LRCK_I2S_IN"),
		MTK_FUNCTION(3, "I2S_LRCK_TDM_OUT"),
		MTK_FUNCTION(4, "I2S_LRCK_I2S_OUT"),
		MTK_FUNCTION(5, "I2S_LRCK_DP"),
		MTK_FUNCTION(7, "DBG_MON_B13")
	),
	MTK_PIN(
		PINCTRL_PIN(33, "GPIO33"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 33),
		MTK_FUNCTION(0, "GPIO33"),
		MTK_FUNCTION(1, "I2S_BCK_TDM_IN"),
		MTK_FUNCTION(2, "I2S_BCK_I2S_IN"),
		MTK_FUNCTION(3, "I2S_BCK_TDM_OUT"),
		MTK_FUNCTION(4, "I2S_BCK_I2S_OUT"),
		MTK_FUNCTION(5, "I2S_BCK_DP"),
		MTK_FUNCTION(7, "DBG_MON_B14")
	),
	MTK_PIN(
		PINCTRL_PIN(34, "GPIO34"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 34),
		MTK_FUNCTION(0, "GPIO34"),
		MTK_FUNCTION(3, "I2S_DO0_TDM_OUT"),
		MTK_FUNCTION(4, "I2S_DO0_I2S_OUT"),
		MTK_FUNCTION(5, "I2S_DO0_DP"),
		MTK_FUNCTION(7, "DBG_MON_B15")
	),
	MTK_PIN(
		PINCTRL_PIN(35, "GPIO35"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 35),
		MTK_FUNCTION(0, "GPIO35"),
		MTK_FUNCTION(1, "I2S_DI0_TDM_IN"),
		MTK_FUNCTION(2, "I2S_DI0_I2S_IN"),
		MTK_FUNCTION(3, "DP_SPDFO"),
		MTK_FUNCTION(5, "I2S_DO1_DP"),
		MTK_FUNCTION(7, "DBG_MON_B16")
	),
	MTK_PIN(
		PINCTRL_PIN(36, "GPIO36"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 36),
		MTK_FUNCTION(0, "GPIO36"),
		MTK_FUNCTION(2, "I2S_DI1_I2S_IN"),
		MTK_FUNCTION(4, "I2S_DO2_DP"),
		MTK_FUNCTION(7, "DBG_MON_B17")
	),
	MTK_PIN(
		PINCTRL_PIN(37, "GPIO37"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 37),
		MTK_FUNCTION(0, "GPIO37"),
		MTK_FUNCTION(1, "I2S_AUDIO_MUTE_DP"),
		MTK_FUNCTION(5, "DP_SPDFO"),
		MTK_FUNCTION(7, "DBG_MON_B18")
	),
	MTK_PIN(
		PINCTRL_PIN(38, "GPIO38"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 38),
		MTK_FUNCTION(0, "GPIO38"),
		MTK_FUNCTION(1, "I2C0_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B19")
	),
	MTK_PIN(
		PINCTRL_PIN(39, "GPIO39"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 39),
		MTK_FUNCTION(0, "GPIO39"),
		MTK_FUNCTION(1, "I2C0_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B20")
	),
	MTK_PIN(
		PINCTRL_PIN(40, "GPIO40"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 40),
		MTK_FUNCTION(0, "GPIO40"),
		MTK_FUNCTION(1, "I2C1_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B21")
	),
	MTK_PIN(
		PINCTRL_PIN(41, "GPIO41"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 41),
		MTK_FUNCTION(0, "GPIO41"),
		MTK_FUNCTION(1, "I2C1_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B22")
	),
	MTK_PIN(
		PINCTRL_PIN(42, "GPIO42"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 42),
		MTK_FUNCTION(0, "GPIO42"),
		MTK_FUNCTION(1, "I2C2_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B23")
	),
	MTK_PIN(
		PINCTRL_PIN(43, "GPIO43"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 43),
		MTK_FUNCTION(0, "GPIO43"),
		MTK_FUNCTION(1, "I2C2_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B24")
	),
	MTK_PIN(
		PINCTRL_PIN(44, "GPIO44"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 44),
		MTK_FUNCTION(0, "GPIO44"),
		MTK_FUNCTION(1, "DSIDIO0_LCM_RST")
	),
	MTK_PIN(
		PINCTRL_PIN(45, "GPIO45"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 45),
		MTK_FUNCTION(0, "GPIO45"),
		MTK_FUNCTION(1, "DSIDIO0_LCM_TE")
	),
	MTK_PIN(
		PINCTRL_PIN(46, "GPIO46"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 46),
		MTK_FUNCTION(0, "GPIO46"),
		MTK_FUNCTION(1, "DSIDIO1_LCM_RST")
	),
	MTK_PIN(
		PINCTRL_PIN(47, "GPIO47"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 47),
		MTK_FUNCTION(0, "GPIO47"),
		MTK_FUNCTION(1, "DSIDIO1_LCM_TE")
	),
	MTK_PIN(
		PINCTRL_PIN(48, "GPIO48"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 48),
		MTK_FUNCTION(0, "GPIO48"),
		MTK_FUNCTION(1, "I2CG0_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B0")
	),
	MTK_PIN(
		PINCTRL_PIN(49, "GPIO49"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 49),
		MTK_FUNCTION(0, "GPIO49"),
		MTK_FUNCTION(1, "I2CG0_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B1")
	),
	MTK_PIN(
		PINCTRL_PIN(50, "GPIO50"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 50),
		MTK_FUNCTION(0, "GPIO50"),
		MTK_FUNCTION(1, "CSIDIOG0_VSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(51, "GPIO51"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 51),
		MTK_FUNCTION(0, "GPIO51"),
		MTK_FUNCTION(1, "CSIDIOG0_CAMCLK_N")
	),
	MTK_PIN(
		PINCTRL_PIN(52, "GPIO52"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 52),
		MTK_FUNCTION(0, "GPIO52")
	),
	MTK_PIN(
		PINCTRL_PIN(53, "GPIO53"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 53),
		MTK_FUNCTION(0, "GPIO53")
	),
	MTK_PIN(
		PINCTRL_PIN(54, "GPIO54"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 54),
		MTK_FUNCTION(0, "GPIO54"),
		MTK_FUNCTION(1, "I2CS0_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B2")
	),
	MTK_PIN(
		PINCTRL_PIN(55, "GPIO55"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 55),
		MTK_FUNCTION(0, "GPIO55"),
		MTK_FUNCTION(1, "I2CS0_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B3")
	),
	MTK_PIN(
		PINCTRL_PIN(56, "GPIO56"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 56),
		MTK_FUNCTION(0, "GPIO56"),
		MTK_FUNCTION(1, "I2CS1_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B4")
	),
	MTK_PIN(
		PINCTRL_PIN(57, "GPIO57"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 57),
		MTK_FUNCTION(0, "GPIO57"),
		MTK_FUNCTION(1, "I2CS1_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B5")
	),
	MTK_PIN(
		PINCTRL_PIN(58, "GPIO58"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 58),
		MTK_FUNCTION(0, "GPIO58"),
		MTK_FUNCTION(1, "CSIDIOS0_CAMCLK_N")
	),
	MTK_PIN(
		PINCTRL_PIN(59, "GPIO59"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 59),
		MTK_FUNCTION(0, "GPIO59")
	),
	MTK_PIN(
		PINCTRL_PIN(60, "GPIO60"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 60),
		MTK_FUNCTION(0, "GPIO60")
	),
	MTK_PIN(
		PINCTRL_PIN(61, "GPIO61"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 61),
		MTK_FUNCTION(0, "GPIO61"),
		MTK_FUNCTION(1, "CSIDIOS01_VSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(62, "GPIO62"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 62),
		MTK_FUNCTION(0, "GPIO62"),
		MTK_FUNCTION(1, "CSIDIOS1_CAMCLK_N")
	),
	MTK_PIN(
		PINCTRL_PIN(63, "GPIO63"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 63),
		MTK_FUNCTION(0, "GPIO63")
	),
	MTK_PIN(
		PINCTRL_PIN(64, "GPIO64"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 64),
		MTK_FUNCTION(0, "GPIO64")
	),
	MTK_PIN(
		PINCTRL_PIN(65, "GPIO65"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 65),
		MTK_FUNCTION(0, "GPIO65"),
		MTK_FUNCTION(1, "I2CS2_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B6")
	),
	MTK_PIN(
		PINCTRL_PIN(66, "GPIO66"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 66),
		MTK_FUNCTION(0, "GPIO66"),
		MTK_FUNCTION(1, "I2CS2_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B7")
	),
	MTK_PIN(
		PINCTRL_PIN(67, "GPIO67"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 67),
		MTK_FUNCTION(0, "GPIO67"),
		MTK_FUNCTION(1, "I2CS3_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B8")
	),
	MTK_PIN(
		PINCTRL_PIN(68, "GPIO68"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 68),
		MTK_FUNCTION(0, "GPIO68"),
		MTK_FUNCTION(1, "I2CS3_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B9")
	),
	MTK_PIN(
		PINCTRL_PIN(69, "GPIO69"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 69),
		MTK_FUNCTION(0, "GPIO69"),
		MTK_FUNCTION(1, "CSIDIOS2_CAMCLK_N")
	),
	MTK_PIN(
		PINCTRL_PIN(70, "GPIO70"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 70),
		MTK_FUNCTION(0, "GPIO70")
	),
	MTK_PIN(
		PINCTRL_PIN(71, "GPIO71"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 71),
		MTK_FUNCTION(0, "GPIO71")
	),
	MTK_PIN(
		PINCTRL_PIN(72, "GPIO72"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 72),
		MTK_FUNCTION(0, "GPIO72"),
		MTK_FUNCTION(1, "CSIDIOS23_VSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(73, "GPIO73"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 73),
		MTK_FUNCTION(0, "GPIO73"),
		MTK_FUNCTION(1, "CSIDIOS3_CAMCLK_N")
	),
	MTK_PIN(
		PINCTRL_PIN(74, "GPIO74"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 74),
		MTK_FUNCTION(0, "GPIO74")
	),
	MTK_PIN(
		PINCTRL_PIN(75, "GPIO75"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 75),
		MTK_FUNCTION(0, "GPIO75")
	),
	MTK_PIN(
		PINCTRL_PIN(76, "GPIO76"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 76),
		MTK_FUNCTION(0, "GPIO76"),
		MTK_FUNCTION(1, "I2CG1_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B10")
	),
	MTK_PIN(
		PINCTRL_PIN(77, "GPIO77"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 77),
		MTK_FUNCTION(0, "GPIO77"),
		MTK_FUNCTION(1, "I2CG1_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B11")
	),
	MTK_PIN(
		PINCTRL_PIN(78, "GPIO78"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 78),
		MTK_FUNCTION(0, "GPIO78"),
		MTK_FUNCTION(1, "CSIDIOG1_CAMCLK_N")
	),
	MTK_PIN(
		PINCTRL_PIN(79, "GPIO79"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 79),
		MTK_FUNCTION(0, "GPIO79")
	),
	MTK_PIN(
		PINCTRL_PIN(80, "GPIO80"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 80),
		MTK_FUNCTION(0, "GPIO80")
	),
	MTK_PIN(
		PINCTRL_PIN(81, "GPIO81"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 81),
		MTK_FUNCTION(0, "GPIO81"),
		MTK_FUNCTION(1, "CSIDIOG1_VSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(82, "GPIO82"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 82),
		MTK_FUNCTION(0, "GPIO82"),
		MTK_FUNCTION(1, "CSIDIOG2_VSYNC")
	),
	MTK_PIN(
		PINCTRL_PIN(83, "GPIO83"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 83),
		MTK_FUNCTION(0, "GPIO83"),
		MTK_FUNCTION(1, "DSIDIO2_LCM_RST")
	),
	MTK_PIN(
		PINCTRL_PIN(84, "GPIO84"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 84),
		MTK_FUNCTION(0, "GPIO84"),
		MTK_FUNCTION(1, "DSIDIO2_LCM_TE")
	),
	MTK_PIN(
		PINCTRL_PIN(85, "GPIO85"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 85),
		MTK_FUNCTION(0, "GPIO85"),
		MTK_FUNCTION(1, "DSIDIO3_LCM_RST")
	),
	MTK_PIN(
		PINCTRL_PIN(86, "GPIO86"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 86),
		MTK_FUNCTION(0, "GPIO86"),
		MTK_FUNCTION(1, "DSIDIO3_LCM_TE")
	),
	MTK_PIN(
		PINCTRL_PIN(87, "GPIO87"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 87),
		MTK_FUNCTION(0, "GPIO87"),
		MTK_FUNCTION(1, "PWM_0"),
		MTK_FUNCTION(2, "GPT0_I"),
		MTK_FUNCTION(3, "UART2_TX"),
		MTK_FUNCTION(4, "SPI_M2_CK"),
		MTK_FUNCTION(5, "PMICSPI1_CK"),
		MTK_FUNCTION(7, "DBG_MON_A0")
	),
	MTK_PIN(
		PINCTRL_PIN(88, "GPIO88"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 88),
		MTK_FUNCTION(0, "GPIO88"),
		MTK_FUNCTION(1, "PWM_1"),
		MTK_FUNCTION(2, "GPT0_O"),
		MTK_FUNCTION(3, "UART2_RX"),
		MTK_FUNCTION(4, "SPI_M2_CS"),
		MTK_FUNCTION(5, "PMICSPI1_CS"),
		MTK_FUNCTION(7, "DBG_MON_A1")
	),
	MTK_PIN(
		PINCTRL_PIN(89, "GPIO89"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 89),
		MTK_FUNCTION(0, "GPIO89"),
		MTK_FUNCTION(1, "PWM_2"),
		MTK_FUNCTION(2, "GPT1_I"),
		MTK_FUNCTION(3, "I2C3_SCL"),
		MTK_FUNCTION(4, "SPI_M2_MOSI"),
		MTK_FUNCTION(5, "PMICSPI1_MOSI"),
		MTK_FUNCTION(7, "DBG_MON_A2")
	),
	MTK_PIN(
		PINCTRL_PIN(90, "GPIO90"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 90),
		MTK_FUNCTION(0, "GPIO90"),
		MTK_FUNCTION(1, "PWM_3"),
		MTK_FUNCTION(2, "GPT1_O"),
		MTK_FUNCTION(3, "I2C3_SDA"),
		MTK_FUNCTION(4, "SPI_M2_MISO"),
		MTK_FUNCTION(5, "PMICSPI1_MISO"),
		MTK_FUNCTION(7, "DBG_MON_A3")
	),
	MTK_PIN(
		PINCTRL_PIN(91, "GPIO91"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 91),
		MTK_FUNCTION(0, "GPIO91"),
		MTK_FUNCTION(1, "PWM_16"),
		MTK_FUNCTION(2, "GPT8_I"),
		MTK_FUNCTION(3, "UART6_TX"),
		MTK_FUNCTION(4, "SPI_M6_CK"),
		MTK_FUNCTION(7, "DBG_MON_A16")
	),
	MTK_PIN(
		PINCTRL_PIN(92, "GPIO92"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 92),
		MTK_FUNCTION(0, "GPIO92"),
		MTK_FUNCTION(1, "PWM_17"),
		MTK_FUNCTION(2, "GPT8_O"),
		MTK_FUNCTION(3, "UART6_RX"),
		MTK_FUNCTION(4, "SPI_M6_CS"),
		MTK_FUNCTION(7, "DBG_MON_A17")
	),
	MTK_PIN(
		PINCTRL_PIN(93, "GPIO93"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 93),
		MTK_FUNCTION(0, "GPIO93"),
		MTK_FUNCTION(1, "PWM_18"),
		MTK_FUNCTION(2, "GPT9_I"),
		MTK_FUNCTION(3, "I2C7_SCL"),
		MTK_FUNCTION(4, "SPI_M6_MOSI"),
		MTK_FUNCTION(7, "DBG_MON_A18")
	),
	MTK_PIN(
		PINCTRL_PIN(94, "GPIO94"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 94),
		MTK_FUNCTION(0, "GPIO94"),
		MTK_FUNCTION(1, "PWM_19"),
		MTK_FUNCTION(2, "GPT9_O"),
		MTK_FUNCTION(3, "I2C7_SDA"),
		MTK_FUNCTION(4, "SPI_M6_MISO"),
		MTK_FUNCTION(7, "DBG_MON_A19")
	),
	MTK_PIN(
		PINCTRL_PIN(95, "GPIO95"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 95),
		MTK_FUNCTION(0, "GPIO95"),
		MTK_FUNCTION(1, "PWM_19"),
		MTK_FUNCTION(2, "GPT11_I"),
		MTK_FUNCTION(3, "I2C8_SCL"),
		MTK_FUNCTION(4, "SPI_M7_MOSI"),
		MTK_FUNCTION(7, "DBG_MON_A22")
	),
	MTK_PIN(
		PINCTRL_PIN(96, "GPIO96"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 96),
		MTK_FUNCTION(0, "GPIO96"),
		MTK_FUNCTION(1, "PWM_23"),
		MTK_FUNCTION(2, "GPT11_O"),
		MTK_FUNCTION(3, "I2C8_SDA"),
		MTK_FUNCTION(4, "SPI_M7_MISO"),
		MTK_FUNCTION(7, "DBG_MON_A23")
	),
	MTK_PIN(
		PINCTRL_PIN(97, "GPIO97"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 97),
		MTK_FUNCTION(0, "GPIO97"),
		MTK_FUNCTION(1, "EMMC_CLK"),
		MTK_FUNCTION(2, "SPI_M1_CK"),
		MTK_FUNCTION(6, "CAMSYS_SD1_TCK"),
		MTK_FUNCTION(7, "CAMSYS_GZ1_TCK")
	),
	MTK_PIN(
		PINCTRL_PIN(98, "GPIO98"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 98),
		MTK_FUNCTION(0, "GPIO98"),
		MTK_FUNCTION(1, "EMMC_DS"),
		MTK_FUNCTION(2, "SPI_M1_CS")
	),
	MTK_PIN(
		PINCTRL_PIN(99, "GPIO99"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 99),
		MTK_FUNCTION(0, "GPIO99"),
		MTK_FUNCTION(1, "EMMC_CMD")
	),
	MTK_PIN(
		PINCTRL_PIN(100, "GPIO100"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 100),
		MTK_FUNCTION(0, "GPIO100"),
		MTK_FUNCTION(1, "EMMC_DAT0"),
		MTK_FUNCTION(2, "SPI_M1_MOS"),
		MTK_FUNCTION(3, "DFD_NTRST"),
		MTK_FUNCTION(4, "UDI_NTRST"),
		MTK_FUNCTION(6, "CAMSYS_SD0_TRST"),
		MTK_FUNCTION(7, "CAMSYS_GZ0_TRST")
	),
	MTK_PIN(
		PINCTRL_PIN(101, "GPIO101"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 101),
		MTK_FUNCTION(0, "GPIO101"),
		MTK_FUNCTION(1, "EMMC_DAT1"),
		MTK_FUNCTION(2, "SPI_M1_MISO"),
		MTK_FUNCTION(3, "DFD_TCK"),
		MTK_FUNCTION(4, "UDI_TCK_XI"),
		MTK_FUNCTION(6, "CAMSYS_SD0_TCK"),
		MTK_FUNCTION(7, "CAMSYS_GZ0_TCK")
	),
	MTK_PIN(
		PINCTRL_PIN(102, "GPIO102"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 102),
		MTK_FUNCTION(0, "GPIO102"),
		MTK_FUNCTION(1, "EMMC_DAT2"),
		MTK_FUNCTION(3, "DFD_TMS"),
		MTK_FUNCTION(4, "UDI_TMS"),
		MTK_FUNCTION(6, "CAMSYS_SD0_TMS"),
		MTK_FUNCTION(7, "CAMSYS_GZ0_TMS")
	),
	MTK_PIN(
		PINCTRL_PIN(103, "GPIO103"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 103),
		MTK_FUNCTION(0, "GPIO103"),
		MTK_FUNCTION(1, "EMMC_DAT3"),
		MTK_FUNCTION(3, "DFD_TDI"),
		MTK_FUNCTION(4, "UDI_TDI"),
		MTK_FUNCTION(6, "CAMSYS_SD0_TDI"),
		MTK_FUNCTION(7, "AMSYS_GZ0_TDI")
	),
	MTK_PIN(
		PINCTRL_PIN(104, "GPIO104"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 104),
		MTK_FUNCTION(0, "GPIO104"),
		MTK_FUNCTION(1, "EMMC_DAT4"),
		MTK_FUNCTION(3, "DFD_TDO"),
		MTK_FUNCTION(4, "UDI_TDO"),
		MTK_FUNCTION(6, "CAMSYS_SD0_TDO"),
		MTK_FUNCTION(7, "CAMSYS_GZ0_TDO")
	),
	MTK_PIN(
		PINCTRL_PIN(105, "GPIO105"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 105),
		MTK_FUNCTION(0, "GPIO105"),
		MTK_FUNCTION(1, "EMMC_DAT5"),
		MTK_FUNCTION(6, "CAMSYS_SD1_TMS"),
		MTK_FUNCTION(7, "CAMSYS_GZ1_TMS")
	),
	MTK_PIN(
		PINCTRL_PIN(106, "GPIO106"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 106),
		MTK_FUNCTION(0, "GPIO106"),
		MTK_FUNCTION(1, "EMMC_DAT6"),
		MTK_FUNCTION(6, "CAMSYS_SD1_TDI"),
		MTK_FUNCTION(7, "CAMSYS_GZ1_TDI")
	),
	MTK_PIN(
		PINCTRL_PIN(107, "GPIO107"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 107),
		MTK_FUNCTION(0, "GPIO107"),
		MTK_FUNCTION(1, "EMMC_DAT7"),
		MTK_FUNCTION(6, "CAMSYS_SD1_TDO"),
		MTK_FUNCTION(7, "CAMSYS_GZ1_TDO")
	),
	MTK_PIN(
		PINCTRL_PIN(108, "GPIO108"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 108),
		MTK_FUNCTION(0, "GPIO108"),
		MTK_FUNCTION(1, "EMMC_RST"),
		MTK_FUNCTION(6, "CAMSYS_SD1_TRST"),
		MTK_FUNCTION(7, "CAMSYS_GZ1_TRST")
	),
	MTK_PIN(
		PINCTRL_PIN(109, "GPIO109"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 109),
		MTK_FUNCTION(0, "GPIO109"),
		MTK_FUNCTION(1, "SCP_GPIO_0"),
		MTK_FUNCTION(3, "I2C0_SCP_SDA"),
		MTK_FUNCTION(4, "EINT0"),
		MTK_FUNCTION(5, "SPI_M0_SCP_CK"),
		MTK_FUNCTION(6, "CLKM0")
	),
	MTK_PIN(
		PINCTRL_PIN(110, "GPIO110"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 110),
		MTK_FUNCTION(0, "GPIO110"),
		MTK_FUNCTION(1, "SCP_GPIO_1"),
		MTK_FUNCTION(3, "I2C0_SCP_SCL"),
		MTK_FUNCTION(4, "EINT1"),
		MTK_FUNCTION(5, "SPI_M0_SCP_CS"),
		MTK_FUNCTION(6, "CLKM1")
	),
	MTK_PIN(
		PINCTRL_PIN(111, "GPIO111"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 111),
		MTK_FUNCTION(0, "GPIO111"),
		MTK_FUNCTION(1, "SCP_GPIO_2"),
		MTK_FUNCTION(3, "UART_SCP1_TXD"),
		MTK_FUNCTION(4, "EINT2"),
		MTK_FUNCTION(5, "SPI_M0_SCP_MOSI"),
		MTK_FUNCTION(6, "CLKM2")
	),
	MTK_PIN(
		PINCTRL_PIN(112, "GPIO112"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 112),
		MTK_FUNCTION(0, "GPIO112"),
		MTK_FUNCTION(1, "SCP_GPIO_3"),
		MTK_FUNCTION(3, "UART_SCP1_RXD"),
		MTK_FUNCTION(4, "EINT3"),
		MTK_FUNCTION(5, "SPI_M0_SCP_MISO"),
		MTK_FUNCTION(6, "CLKM3")
	),
	MTK_PIN(
		PINCTRL_PIN(113, "GPIO113"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 113),
		MTK_FUNCTION(0, "GPIO113"),
		MTK_FUNCTION(1, "SCP_GPIO_4"),
		MTK_FUNCTION(3, "I2C1_SCP_SDA"),
		MTK_FUNCTION(4, "EINT4"),
		MTK_FUNCTION(5, "SPI_M1_SCP_CK"),
		MTK_FUNCTION(6, "CLKM4")
	),
	MTK_PIN(
		PINCTRL_PIN(114, "GPIO114"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 114),
		MTK_FUNCTION(0, "GPIO114"),
		MTK_FUNCTION(1, "SCP_GPIO_5"),
		MTK_FUNCTION(3, "I2C1_SCP_SCL"),
		MTK_FUNCTION(4, "EINT5"),
		MTK_FUNCTION(5, "SPI_M1_SCP_CS"),
		MTK_FUNCTION(6, "CLKM5")
	),
	MTK_PIN(
		PINCTRL_PIN(115, "GPIO115"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 115),
		MTK_FUNCTION(0, "GPIO115"),
		MTK_FUNCTION(1, "SCP_GPIO_6"),
		MTK_FUNCTION(3, "UART_SCP2_TXD"),
		MTK_FUNCTION(4, "EINT6"),
		MTK_FUNCTION(5, "SPI_M1_SCP_MOSI"),
		MTK_FUNCTION(6, "I2C2_SCP_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B25")
	),
	MTK_PIN(
		PINCTRL_PIN(116, "GPIO116"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 116),
		MTK_FUNCTION(0, "GPIO116"),
		MTK_FUNCTION(1, "SCP_GPIO_7"),
		MTK_FUNCTION(3, "UART_SCP2_RXD"),
		MTK_FUNCTION(4, "EINT7"),
		MTK_FUNCTION(5, "SPI_M1_SCP_MISO"),
		MTK_FUNCTION(6, "I2C2_SCP_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B26")
	),
	MTK_PIN(
		PINCTRL_PIN(117, "GPIO117"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 117),
		MTK_FUNCTION(0, "GPIO117"),
		MTK_FUNCTION(1, "SCP_GPIO_8"),
		MTK_FUNCTION(3, "I2C2_SCP_SDA"),
		MTK_FUNCTION(4, "EINT8"),
		MTK_FUNCTION(5, "SPI_M2_SCP_CK"),
		MTK_FUNCTION(6, "I2C3_SCP_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B27")
	),
	MTK_PIN(
		PINCTRL_PIN(118, "GPIOSTB_8"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 118),
		MTK_FUNCTION(0, "GPIO118"),
		MTK_FUNCTION(1, "SCP_GPIO_9"),
		MTK_FUNCTION(3, "I2C2_SCP_SCL"),
		MTK_FUNCTION(4, "EINT9"),
		MTK_FUNCTION(5, "SPI_M2_SCP_CS"),
		MTK_FUNCTION(6, "I2C3_SCP_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B28")
	),
	MTK_PIN(
		PINCTRL_PIN(119, "GPIO119"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 119),
		MTK_FUNCTION(0, "GPIO119"),
		MTK_FUNCTION(1, "SCP_GPIO_10"),
		MTK_FUNCTION(4, "EINT10"),
		MTK_FUNCTION(5, "SPI_M2_SCP_MOSI"),
		MTK_FUNCTION(6, "I2C1_SCP_SDA")
	),
	MTK_PIN(
		PINCTRL_PIN(120, "GPIO120"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 120),
		MTK_FUNCTION(0, "GPIO120"),
		MTK_FUNCTION(1, "SCP_GPIO_11"),
		MTK_FUNCTION(4, "EINT11"),
		MTK_FUNCTION(5, "SPI_M2_SCP_MISO"),
		MTK_FUNCTION(6, "I2C1_SCP_SCL")
	),
	MTK_PIN(
		PINCTRL_PIN(121, "GPIO121"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 121),
		MTK_FUNCTION(0, "GPIO121"),
		MTK_FUNCTION(1, "SCP_GPIO_12"),
		MTK_FUNCTION(4, "EINT12"),
		MTK_FUNCTION(5, "I2C0_SCP_SDA"),
		MTK_FUNCTION(6, "I2C1_SCP_SDA"),
		MTK_FUNCTION(7, "DBG_MON_B29")
	),
	MTK_PIN(
		PINCTRL_PIN(122, "GPIO122"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 122),
		MTK_FUNCTION(0, "GPIO122"),
		MTK_FUNCTION(1, "SCP_GPIO_13"),
		MTK_FUNCTION(2, "DPRX_HDCP_UART_OUT"),
		MTK_FUNCTION(4, "EINT13"),
		MTK_FUNCTION(5, "I2C0_SCP_SCL"),
		MTK_FUNCTION(6, "I2C1_SCP_SCL"),
		MTK_FUNCTION(7, "DBG_MON_B30")
	),
	MTK_PIN(
		PINCTRL_PIN(123, "GPIO123"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 123),
		MTK_FUNCTION(0, "GPIO123"),
		MTK_FUNCTION(1, "SCP_GPIO_14"),
		MTK_FUNCTION(2, "DPRX_HDCP_UART_IN"),
		MTK_FUNCTION(4, "EINT14"),
		MTK_FUNCTION(7, "DBG_MON_B31")
	),
	MTK_PIN(
		PINCTRL_PIN(124, "GPIO124"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 124),
		MTK_FUNCTION(0, "GPIO124")
	),
	MTK_PIN(
		PINCTRL_PIN(125, "GPIO125"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 125),
		MTK_FUNCTION(0, "GPIO125")
	),
	MTK_PIN(
		PINCTRL_PIN(126, "GPIO126"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 126),
		MTK_FUNCTION(0, "GPIO126"),
		MTK_FUNCTION(1, "PWM_24"),
		MTK_FUNCTION(2, "GPT12_I"),
		MTK_FUNCTION(3, "UART8_TX"),
		MTK_FUNCTION(4, "SPI_M8_CK"),
		MTK_FUNCTION(6, "DISP_PWM"),
		MTK_FUNCTION(7, "DBG_MON_A24")
	),
	MTK_PIN(
		PINCTRL_PIN(127, "GPIO127"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 127),
		MTK_FUNCTION(0, "GPIO127"),
		MTK_FUNCTION(1, "PWM_25"),
		MTK_FUNCTION(2, "GPT12_O"),
		MTK_FUNCTION(3, "UART8_RX"),
		MTK_FUNCTION(4, "SPI_M8_CS"),
		MTK_FUNCTION(7, "DBG_MON_A25")
	),
	MTK_PIN(
		PINCTRL_PIN(128, "GPIO128"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 128),
		MTK_FUNCTION(0, "GPIO128"),
		MTK_FUNCTION(1, "PWM_26"),
		MTK_FUNCTION(2, "GPT13_I"),
		MTK_FUNCTION(3, "I2C9_SCL"),
		MTK_FUNCTION(4, "SPI_M8_MOSI"),
		MTK_FUNCTION(6, "CLKM0"),
		MTK_FUNCTION(7, "DBG_MON_A26")
	),
	MTK_PIN(
		PINCTRL_PIN(129, "GPIO129"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 129),
		MTK_FUNCTION(0, "GPIO129"),
		MTK_FUNCTION(1, "PWM_27"),
		MTK_FUNCTION(2, "GPT13_O"),
		MTK_FUNCTION(3, "I2C9_SDA"),
		MTK_FUNCTION(4, "SPI_M8_MISO"),
		MTK_FUNCTION(6, "CLKM1"),
		MTK_FUNCTION(7, "DBG_MON_A27")
	),
	MTK_PIN(
		PINCTRL_PIN(130, "GPIO130"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 130),
		MTK_FUNCTION(0, "GPIO130"),
		MTK_FUNCTION(1, "PWM_28"),
		MTK_FUNCTION(2, "GPT14_I"),
		MTK_FUNCTION(3, "UART9_TX"),
		MTK_FUNCTION(4, "SPI_M9_CK"),
		MTK_FUNCTION(6, "CLKM2"),
		MTK_FUNCTION(7, "DBG_MON_A28")
	),
	MTK_PIN(
		PINCTRL_PIN(131, "GPIO131"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 131),
		MTK_FUNCTION(0, "GPIO131"),
		MTK_FUNCTION(1, "PWM_29"),
		MTK_FUNCTION(2, "GPT14_O"),
		MTK_FUNCTION(3, "UART9_RX"),
		MTK_FUNCTION(4, "SPI_M9_CS"),
		MTK_FUNCTION(6, "CLKM3"),
		MTK_FUNCTION(7, "DBG_MON_A29")
	),
	MTK_PIN(
		PINCTRL_PIN(132, "GPIO132"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 132),
		MTK_FUNCTION(0, "GPIO132"),
		MTK_FUNCTION(1, "PWM_30"),
		MTK_FUNCTION(2, "GPT15_I"),
		MTK_FUNCTION(3, "I2C10_SCL"),
		MTK_FUNCTION(4, "SPI_M9_MOSI"),
		MTK_FUNCTION(6, "CLKM4"),
		MTK_FUNCTION(7, "DBG_MON_A30")
	),
	MTK_PIN(
		PINCTRL_PIN(133, "GPIO133"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 133),
		MTK_FUNCTION(0, "GPIO133"),
		MTK_FUNCTION(1, "PWM_31"),
		MTK_FUNCTION(2, "GPT15_O"),
		MTK_FUNCTION(3, "I2C10_SDA"),
		MTK_FUNCTION(4, "SPI_M9_MISO"),
		MTK_FUNCTION(6, "CLKM5"),
		MTK_FUNCTION(7, "DBG_MON_A31")
	),
	MTK_PIN(
		PINCTRL_PIN(134, "GPIO134"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 134),
		MTK_FUNCTION(0, "GPIO134")
	),
	MTK_PIN(
		PINCTRL_PIN(135, "GPIO135"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 135),
		MTK_FUNCTION(0, "GPIO135")
	),
	MTK_PIN(
		PINCTRL_PIN(136, "GPIO136"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 136),
		MTK_FUNCTION(0, "GPIO136")
	),
	MTK_PIN(
		PINCTRL_PIN(137, "GPIO137"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 137),
		MTK_FUNCTION(0, "GPIO137"),
		MTK_FUNCTION(1, "SF_CS"),
		MTK_FUNCTION(2, "SPI_M1_CS")
	),
	MTK_PIN(
		PINCTRL_PIN(138, "GPIO138"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 138),
		MTK_FUNCTION(0, "GPIO138"),
		MTK_FUNCTION(1, "SF_CK"),
		MTK_FUNCTION(2, "SPI_M1_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(139, "GPIO139"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 139),
		MTK_FUNCTION(0, "GPIO139"),
		MTK_FUNCTION(1, "SF_D0"),
		MTK_FUNCTION(2, "SPI_M1_MOSI")
	),
	MTK_PIN(
		PINCTRL_PIN(140, "GPIO140"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 140),
		MTK_FUNCTION(0, "GPIO140"),
		MTK_FUNCTION(1, "SF_D1"),
		MTK_FUNCTION(2, "SPI_M1_MISO")
	),
	MTK_PIN(
		PINCTRL_PIN(141, "GPIO141"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 141),
		MTK_FUNCTION(0, "GPIO141"),
		MTK_FUNCTION(1, "SF_D2")
	),
	MTK_PIN(
		PINCTRL_PIN(142, "GPIO142"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 142),
		MTK_FUNCTION(0, "GPIO142"),
		MTK_FUNCTION(1, "SF_D3")
	),
	MTK_PIN(
		PINCTRL_PIN(143, "GPIO143"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 143),
		MTK_FUNCTION(0, "GPIO143"),
		MTK_FUNCTION(1, "PMICSPI0_CK")
	),
	MTK_PIN(
		PINCTRL_PIN(144, "GPIO144"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 144),
		MTK_FUNCTION(0, "GPIO144"),
		MTK_FUNCTION(1, "PMICSPI0_CS")
	),
	MTK_PIN(
		PINCTRL_PIN(145, "GPIO145"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 145),
		MTK_FUNCTION(0, "GPIO145"),
		MTK_FUNCTION(1, "PMICSPI0_MOSI")
	),
	MTK_PIN(
		PINCTRL_PIN(146, "GPIO146"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 146),
		MTK_FUNCTION(0, "GPIO146"),
		MTK_FUNCTION(1, "PMICSPI0_MISO")
	),
	MTK_PIN(
		PINCTRL_PIN(147, "GPIO147"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 147),
		MTK_FUNCTION(0, "GPIO147"),
		MTK_FUNCTION(1, "PMIC_WATCHDOG")
	),
	MTK_PIN(
		PINCTRL_PIN(148, "GPIO148"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 148),
		MTK_FUNCTION(0, "GPIO148"),
		MTK_FUNCTION(1, "SOC_OT")
	),
	MTK_PIN(
		PINCTRL_PIN(149, "GPIO149"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 149),
		MTK_FUNCTION(0, "GPIO149"),
		MTK_FUNCTION(1, "UART0_TXD")
	),
	MTK_PIN(
		PINCTRL_PIN(150, "GPIO150"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 150),
		MTK_FUNCTION(0, "GPIO150"),
		MTK_FUNCTION(1, "UART0_RXD")
	),
	MTK_PIN(
		PINCTRL_PIN(151, "GPIO151"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 151),
		MTK_FUNCTION(0, "GPIO151"),
		MTK_FUNCTION(1, "UART1_TXD")
	),
	MTK_PIN(
		PINCTRL_PIN(152, "GPIO152"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 152),
		MTK_FUNCTION(0, "GPIO152"),
		MTK_FUNCTION(1, "UART1_RXD")
	),
	MTK_PIN(
		PINCTRL_PIN(153, "GPIO153"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 153),
		MTK_FUNCTION(0, "GPIO153"),
		MTK_FUNCTION(1, "UART0_RTS")
	),
	MTK_PIN(
		PINCTRL_PIN(154, "GPIO154"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 154),
		MTK_FUNCTION(0, "GPIO154"),
		MTK_FUNCTION(1, "UART0_CTS")
	),
	MTK_PIN(
		PINCTRL_PIN(155, "GPIO155"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 155),
		MTK_FUNCTION(0, "GPIO155"),
		MTK_FUNCTION(1, "UART_SCP0_TXD")
	),
	MTK_PIN(
		PINCTRL_PIN(156, "GPIO156"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 156),
		MTK_FUNCTION(0, "GPIO156"),
		MTK_FUNCTION(1, "UART_SCP0_RXD")
	),
	MTK_PIN(
		PINCTRL_PIN(157, "GPIO157"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 157),
		MTK_FUNCTION(0, "GPIO157"),
		MTK_FUNCTION(1, "UART_SCP0_RTS")
	),
	MTK_PIN(
		PINCTRL_PIN(158, "GPIO158"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 158),
		MTK_FUNCTION(0, "GPIO158"),
		MTK_FUNCTION(1, "UART_SCP0_CTS")
	),
	MTK_PIN(
		PINCTRL_PIN(159, "GPIO159"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 159),
		MTK_FUNCTION(0, "GPIO159"),
		MTK_FUNCTION(1, "JTAG_JTDI"),
		MTK_FUNCTION(2, "SCP_TDI"),
		MTK_FUNCTION(3, "VPU_TDI_0"),
		MTK_FUNCTION(4, "VPU_TDI_1"),
		MTK_FUNCTION(5, "VPU_TDI_2")
	),
	MTK_PIN(
		PINCTRL_PIN(160, "GPIO160"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 160),
		MTK_FUNCTION(0, "GPIO160"),
		MTK_FUNCTION(1, "JTAG_JTDO"),
		MTK_FUNCTION(2, "SCP_TDO"),
		MTK_FUNCTION(3, "VPU_TDO_0"),
		MTK_FUNCTION(4, "VPU_TDO_1"),
		MTK_FUNCTION(5, "VPU_TDO_2")
	),
	MTK_PIN(
		PINCTRL_PIN(161, "GPIO161"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 161),
		MTK_FUNCTION(0, "GPIO161"),
		MTK_FUNCTION(1, "JTAG_JTRSTB"),
		MTK_FUNCTION(2, "SCP_TRSTN"),
		MTK_FUNCTION(3, "VPU_TRST_0"),
		MTK_FUNCTION(4, "VPU_TRST_1"),
		MTK_FUNCTION(5, "VPU_TRST_2")
	),
	MTK_PIN(
		PINCTRL_PIN(162, "GPIO162"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 162),
		MTK_FUNCTION(0, "GPIO162"),
		MTK_FUNCTION(1, "JTAG_JTCK"),
		MTK_FUNCTION(2, "SCP_TCK"),
		MTK_FUNCTION(3, "VPU_TCK_0"),
		MTK_FUNCTION(4, "VPU_TCK_1"),
		MTK_FUNCTION(5, "VPU_TCK_2")
	),
	MTK_PIN(
		PINCTRL_PIN(163, "GPIO163"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 163),
		MTK_FUNCTION(0, "GPIO163"),
		MTK_FUNCTION(1, "JTAG_JTMS"),
		MTK_FUNCTION(2, "SCP_TMS"),
		MTK_FUNCTION(3, "VPU_TMS_0"),
		MTK_FUNCTION(4, "VPU_TMS_1"),
		MTK_FUNCTION(5, "VPU_TMS_2")
	),
	MTK_PIN(
		PINCTRL_PIN(164, "GPIO164"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 164),
		MTK_FUNCTION(0, "GPIO164"),
		MTK_FUNCTION(1, "JTAG_JTDI"),
		MTK_FUNCTION(2, "SCP_TDI"),
		MTK_FUNCTION(3, "VPU_TDI_0"),
		MTK_FUNCTION(4, "VPU_TDI_1"),
		MTK_FUNCTION(5, "VPU_TDI_2")
	),
	MTK_PIN(
		PINCTRL_PIN(165, "GPIO165"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 165),
		MTK_FUNCTION(0, "GPIO165"),
		MTK_FUNCTION(1, "JTAG_JTDO"),
		MTK_FUNCTION(2, "SCP_TDO"),
		MTK_FUNCTION(3, "PU_TDO_0"),
		MTK_FUNCTION(4, "PU_TDO_1"),
		MTK_FUNCTION(5, "PU_TDO_2")
	),
	MTK_PIN(
		PINCTRL_PIN(166, "GPIO166"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 166),
		MTK_FUNCTION(0, "GPIO166"),
		MTK_FUNCTION(1, "JTAG_JTRSTB"),
		MTK_FUNCTION(2, "SCP_TRSTN"),
		MTK_FUNCTION(3, "VPU_TRST_0"),
		MTK_FUNCTION(4, "VPU_TRST_1"),
		MTK_FUNCTION(5, "VPU_TRST_2")
	),
	MTK_PIN(
		PINCTRL_PIN(167, "GPIO167"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 167),
		MTK_FUNCTION(0, "GPIO167"),
		MTK_FUNCTION(1, "JTAG_JTCK"),
		MTK_FUNCTION(2, "SCP_TCK"),
		MTK_FUNCTION(3, "VPU_TCK_0"),
		MTK_FUNCTION(4, "VPU_TCK_1"),
		MTK_FUNCTION(5, "VPU_TCK_2")
	),
	MTK_PIN(
		PINCTRL_PIN(168, "GPIO168"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 168),
		MTK_FUNCTION(0, "GPIO168"),
		MTK_FUNCTION(1, "JTAG_JTMS"),
		MTK_FUNCTION(2, "SCP_TMS"),
		MTK_FUNCTION(3, "VPU_TMS_0"),
		MTK_FUNCTION(4, "VPU_TMS_1"),
		MTK_FUNCTION(5, "VPU_TMS_2")
	),
	MTK_PIN(
		PINCTRL_PIN(169, "GPIO169"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 169),
		MTK_FUNCTION(0, "GPIO169"),
		MTK_FUNCTION(1, "JTAG_JTDI"),
		MTK_FUNCTION(2, "SCP_TDI"),
		MTK_FUNCTION(3, "VPU_TDI_0"),
		MTK_FUNCTION(4, "VPU_TDI_1"),
		MTK_FUNCTION(5, "VPU_TDI_2")
	),
	MTK_PIN(
		PINCTRL_PIN(170, "GPIO170"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 170),
		MTK_FUNCTION(0, "GPIO170"),
		MTK_FUNCTION(1, "JTAG_JTDO"),
		MTK_FUNCTION(2, "SCP_TDO"),
		MTK_FUNCTION(3, "VPU_TDO_0"),
		MTK_FUNCTION(4, "VPU_TDO_1"),
		MTK_FUNCTION(5, "VPU_TDO_2")
	),
	MTK_PIN(
		PINCTRL_PIN(171, "GPIO171"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 171),
		MTK_FUNCTION(0, "GPIO171"),
		MTK_FUNCTION(1, "JTAG_JTRSTB"),
		MTK_FUNCTION(2, "SCP_TRSTN"),
		MTK_FUNCTION(3, "VPU_TRST_0"),
		MTK_FUNCTION(4, "VPU_TRST_1"),
		MTK_FUNCTION(5, "VPU_TRST_2")
	),
	MTK_PIN(
		PINCTRL_PIN(172, "GPIO172"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 172),
		MTK_FUNCTION(0, "GPIO172"),
		MTK_FUNCTION(1, "JTAG_JTCK"),
		MTK_FUNCTION(2, "SCP_TCK"),
		MTK_FUNCTION(3, "VPU_TCK_0"),
		MTK_FUNCTION(4, "VPU_TCK_1"),
		MTK_FUNCTION(5, "VPU_TCK_2")
	),
	MTK_PIN(
		PINCTRL_PIN(173, "GPIO173"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 173),
		MTK_FUNCTION(0, "GPIO173"),
		MTK_FUNCTION(1, "JTAG_JTMS"),
		MTK_FUNCTION(2, "SCP_TMS"),
		MTK_FUNCTION(3, "VPU_TMS_0"),
		MTK_FUNCTION(4, "VPU_TMS_1"),
		MTK_FUNCTION(5, "VPU_TMS_2")
	),
	MTK_PIN(
		PINCTRL_PIN(174, "GPIO174"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 174),
		MTK_FUNCTION(0, "GPIO174"),
		MTK_FUNCTION(1, "JTAG_JTDI"),
		MTK_FUNCTION(2, "SCP_TDI"),
		MTK_FUNCTION(3, "VPU_TDI_0"),
		MTK_FUNCTION(4, "VPU_TDI_1"),
		MTK_FUNCTION(5, "VPU_TDI_2")
	),
	MTK_PIN(
		PINCTRL_PIN(175, "GPIO175"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 175),
		MTK_FUNCTION(0, "GPIO175"),
		MTK_FUNCTION(1, "JTAG_JTDO"),
		MTK_FUNCTION(2, "SCP_TDO"),
		MTK_FUNCTION(3, "VPU_TDO_0"),
		MTK_FUNCTION(4, "VPU_TDO_1"),
		MTK_FUNCTION(5, "VPU_TDO_2")
	),
	MTK_PIN(
		PINCTRL_PIN(176, "GPIO176"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 176),
		MTK_FUNCTION(0, "GPIO176"),
		MTK_FUNCTION(1, "JTAG_JTRSTB"),
		MTK_FUNCTION(2, "SCP_TRSTN"),
		MTK_FUNCTION(3, "VPU_TRST_0"),
		MTK_FUNCTION(4, "VPU_TRST_1"),
		MTK_FUNCTION(5, "VPU_TRST_2")
	),
	MTK_PIN(
		PINCTRL_PIN(177, "GPIO177"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 177),
		MTK_FUNCTION(0, "GPIO177"),
		MTK_FUNCTION(1, "JTAG_JTCK"),
		MTK_FUNCTION(2, "SCP_TCK"),
		MTK_FUNCTION(3, "VPU_TCK_0"),
		MTK_FUNCTION(4, "VPU_TCK_1"),
		MTK_FUNCTION(5, "VPU_TCK_2")
	),
	MTK_PIN(
		PINCTRL_PIN(178, "GPIO178"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 178),
		MTK_FUNCTION(0, "GPIO178"),
		MTK_FUNCTION(1, "JTAG_JTMS"),
		MTK_FUNCTION(2, "SCP_TMS"),
		MTK_FUNCTION(3, "VPU_TMS_0"),
		MTK_FUNCTION(4, "VPU_TMS_1"),
		MTK_FUNCTION(5, "VPU_TMS_2")
	),
	MTK_PIN(
		PINCTRL_PIN(179, "GPIO_14"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 179),
		MTK_FUNCTION(0, "GPIO179"),
		MTK_FUNCTION(1, "TPIU_TCK")
	),
	MTK_PIN(
		PINCTRL_PIN(180, "GPIO_15"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 180),
		MTK_FUNCTION(0, "GPIO180"),
		MTK_FUNCTION(1, "TPIU_TCTL")
	),
	MTK_PIN(
		PINCTRL_PIN(181, "GPIO181"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 181),
		MTK_FUNCTION(0, "GPIO181"),
		MTK_FUNCTION(1, "TPIU_TDATA0")
	),
	MTK_PIN(
		PINCTRL_PIN(182, "GPIO182"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 182),
		MTK_FUNCTION(0, "GPIO182"),
		MTK_FUNCTION(1, "TPIU_TDATA1")
	),
	MTK_PIN(
		PINCTRL_PIN(183, "GPIO183"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 183),
		MTK_FUNCTION(0, "GPIO183"),
		MTK_FUNCTION(1, "TPIU_TDATA2")
	),
	MTK_PIN(
		PINCTRL_PIN(184, "GPIO184"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 184),
		MTK_FUNCTION(0, "GPIO184"),
		MTK_FUNCTION(3, "TPIU_TDATA3")
	),
	MTK_PIN(
		PINCTRL_PIN(185, "GPIO185"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 185),
		MTK_FUNCTION(0, "GPIO185"),
		MTK_FUNCTION(1, "JTAG_JTDI"),
		MTK_FUNCTION(2, "SCP_TDI"),
		MTK_FUNCTION(3, "VPU_TDI_0"),
		MTK_FUNCTION(4, "VPU_TDI_1"),
		MTK_FUNCTION(5, "VPU_TDI_2")
	),
	MTK_PIN(
		PINCTRL_PIN(186, "GPIO186"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 186),
		MTK_FUNCTION(0, "GPIO186"),
		MTK_FUNCTION(1, "JTAG_JTDO"),
		MTK_FUNCTION(2, "SCP_TDO"),
		MTK_FUNCTION(3, "VPU_TDO_0"),
		MTK_FUNCTION(4, "VPU_TDO_1"),
		MTK_FUNCTION(5, "VPU_TDO_2")
	),
	MTK_PIN(
		PINCTRL_PIN(187, "GPIO187"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 187),
		MTK_FUNCTION(0, "GPIO187"),
		MTK_FUNCTION(1, "JTAG_JTRSTB"),
		MTK_FUNCTION(2, "SCP_TRSTN"),
		MTK_FUNCTION(3, "VPU_TRST_0"),
		MTK_FUNCTION(4, "VPU_TRST_1"),
		MTK_FUNCTION(5, "VPU_TRST_2")
	),
	MTK_PIN(
		PINCTRL_PIN(188, "GPIO188"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 188),
		MTK_FUNCTION(0, "GPIO188"),
		MTK_FUNCTION(1, "JTAG_JTCK"),
		MTK_FUNCTION(2, "SCP_TCK"),
		MTK_FUNCTION(3, "VPU_TCK_0"),
		MTK_FUNCTION(4, "VPU_TCK_1"),
		MTK_FUNCTION(5, "VPU_TCK_2")
	),
	MTK_PIN(
		PINCTRL_PIN(189, "GPIO189"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 189),
		MTK_FUNCTION(0, "GPIO189"),
		MTK_FUNCTION(1, "JTAG_JTMS"),
		MTK_FUNCTION(2, "SCP_TMS"),
		MTK_FUNCTION(3, "VPU_TMS_0"),
		MTK_FUNCTION(4, "VPU_TMS_1"),
		MTK_FUNCTION(5, "VPU_TMS_2")
	),
	MTK_PIN(
		PINCTRL_PIN(190, "GPIO190"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 190),
		MTK_FUNCTION(0, "GPIO190"),
		MTK_FUNCTION(1, "SSUSB_PE")
	),
	MTK_PIN(
		PINCTRL_PIN(191, "GPIO191"),
		NULL, "mt3612",
		MTK_EINT_FUNCTION(0, 191),
		MTK_FUNCTION(0, "GPIO191"),
		MTK_FUNCTION(1, "SSUSB_OC")
	),
};

#endif /* __PINCTRL_MTK_MT3612_H */
