/*
 * Copyright (C) 2016 MediaTek Inc.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#ifndef _MT_PMIC_UPMU_HW_H_
#define _MT_PMIC_UPMU_HW_H_


#define PMU_FLAG_TABLE_ENTRY struct pmu_flag_table_entry_t
#define PMU_FLAGS_LIST_ENUM enum PMU_FLAGS_LIST

#define MT6355_PMIC_REG_BASE (0x0000)

#define pmic_uint	unsigned int
#define MT6355_TOP_CKPDN_CON0      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0400))
#define MT6355_TOP_CKPDN_CON0_SET  ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0402))
#define MT6355_TOP_CKPDN_CON0_CLR  ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0404))
#define MT6355_TOP_CKHWEN_CON0     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0430))
#define MT6355_TOP_CKHWEN_CON0_SET ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0432))
#define MT6355_TOP_CKHWEN_CON0_CLR ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0434))
#define MT6355_TOP_CKHWEN_CON1     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0436))
#define MT6355_TOP_CKHWEN_CON1_SET ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0438))
#define MT6355_TOP_CKHWEN_CON1_CLR ((pmic_uint)(MT6355_PMIC_REG_BASE+0x043A))
#define MT6355_DEW_READ_TEST       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0C04))
#define MT6355_STRUP_CON6          ((pmic_uint)(MT6355_PMIC_REG_BASE+0x0E0C))
#define MT6355_LDO_VBIF28_CON0     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x1796))
#define MT6355_LDO_VBIF28_OP_EN    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x1798))
#define MT6355_LDO_VBIF28_CON1     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x17A4))
#define MT6355_CHR_CON7            ((pmic_uint)(MT6355_PMIC_REG_BASE+0x220E))
#define MT6355_PCHR_VREF_ANA_DA0   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x2210))
#define MT6355_AUXADC_ADC0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3200))
#define MT6355_AUXADC_ADC1         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3202))
#define MT6355_AUXADC_ADC2         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3204))
#define MT6355_AUXADC_ADC3         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3206))
#define MT6355_AUXADC_ADC4         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3208))
#define MT6355_AUXADC_ADC5         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x320A))
#define MT6355_AUXADC_ADC6         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x320C))
#define MT6355_AUXADC_ADC7         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x320E))
#define MT6355_AUXADC_ADC8         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3210))
#define MT6355_AUXADC_ADC9         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3212))
#define MT6355_AUXADC_ADC10        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3214))
#define MT6355_AUXADC_ADC11        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3216))
#define MT6355_AUXADC_ADC12        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3218))
#define MT6355_AUXADC_ADC13        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x321A))
#define MT6355_AUXADC_ADC14        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x321C))
#define MT6355_AUXADC_ADC15        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x321E))
#define MT6355_AUXADC_ADC16        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3220))
#define MT6355_AUXADC_ADC17        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3222))
#define MT6355_AUXADC_ADC18        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3224))
#define MT6355_AUXADC_ADC19        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3226))
#define MT6355_AUXADC_ADC20        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3228))
#define MT6355_AUXADC_ADC21        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x322A))
#define MT6355_AUXADC_ADC22        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x322C))
#define MT6355_AUXADC_ADC23        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x322E))
#define MT6355_AUXADC_ADC24        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3230))
#define MT6355_AUXADC_ADC25        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3232))
#define MT6355_AUXADC_ADC26        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3234))
#define MT6355_AUXADC_ADC27        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3236))
#define MT6355_AUXADC_ADC28        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3238))
#define MT6355_AUXADC_ADC29        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x323A))
#define MT6355_AUXADC_ADC30        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x323C))
#define MT6355_AUXADC_ADC31        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x323E))
#define MT6355_AUXADC_ADC32        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3240))
#define MT6355_AUXADC_ADC33        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3242))
#define MT6355_AUXADC_ADC34        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3244))
#define MT6355_AUXADC_ADC35        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3246))
#define MT6355_AUXADC_ADC36        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3248))
#define MT6355_AUXADC_ADC37        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x324A))
#define MT6355_AUXADC_ADC38        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x324C))
#define MT6355_AUXADC_ADC39        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x324E))
#define MT6355_AUXADC_ADC40        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3250))
#define MT6355_AUXADC_ADC41        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3252))
#define MT6355_AUXADC_ADC42        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3254))
#define MT6355_AUXADC_ADC43        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3256))
#define MT6355_AUXADC_ADC44        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3258))
#define MT6355_AUXADC_BUF0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x325A))
#define MT6355_AUXADC_BUF1         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x325C))
#define MT6355_AUXADC_BUF2         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x325E))
#define MT6355_AUXADC_BUF3         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3260))
#define MT6355_AUXADC_BUF4         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3262))
#define MT6355_AUXADC_BUF5         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3264))
#define MT6355_AUXADC_BUF6         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3266))
#define MT6355_AUXADC_BUF7         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3268))
#define MT6355_AUXADC_BUF8         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x326A))
#define MT6355_AUXADC_BUF9         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x326C))
#define MT6355_AUXADC_BUF10        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x326E))
#define MT6355_AUXADC_BUF11        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3270))
#define MT6355_AUXADC_BUF12        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3272))
#define MT6355_AUXADC_BUF13        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3274))
#define MT6355_AUXADC_BUF14        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3276))
#define MT6355_AUXADC_BUF15        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3278))
#define MT6355_AUXADC_BUF16        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x327A))
#define MT6355_AUXADC_BUF17        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x327C))
#define MT6355_AUXADC_BUF18        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x327E))
#define MT6355_AUXADC_BUF19        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3280))
#define MT6355_AUXADC_BUF20        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3282))
#define MT6355_AUXADC_BUF21        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3284))
#define MT6355_AUXADC_BUF22        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3286))
#define MT6355_AUXADC_BUF23        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3288))
#define MT6355_AUXADC_BUF24        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x328A))
#define MT6355_AUXADC_BUF25        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x328C))
#define MT6355_AUXADC_BUF26        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x328E))
#define MT6355_AUXADC_BUF27        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3290))
#define MT6355_AUXADC_BUF28        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3292))
#define MT6355_AUXADC_BUF29        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3294))
#define MT6355_AUXADC_BUF30        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3296))
#define MT6355_AUXADC_BUF31        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3298))
#define MT6355_AUXADC_STA0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x329A))
#define MT6355_AUXADC_STA1         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x329C))
#define MT6355_AUXADC_STA2         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x329E))
#define MT6355_AUXADC_RQST0        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32A0))
#define MT6355_AUXADC_RQST0_SET    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32A2))
#define MT6355_AUXADC_RQST0_CLR    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32A4))
#define MT6355_AUXADC_RQST1        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32A6))
#define MT6355_AUXADC_RQST1_SET    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32A8))
#define MT6355_AUXADC_RQST1_CLR    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32AA))
#define MT6355_AUXADC_CON0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32AC))
#define MT6355_AUXADC_CON0_SET     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32AE))
#define MT6355_AUXADC_CON0_CLR     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32B0))
#define MT6355_AUXADC_CON1         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32B2))
#define MT6355_AUXADC_CON2         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32B4))
#define MT6355_AUXADC_CON3         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32B6))
#define MT6355_AUXADC_CON4         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32B8))
#define MT6355_AUXADC_CON5         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32BA))
#define MT6355_AUXADC_CON6         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32BC))
#define MT6355_AUXADC_CON7         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32BE))
#define MT6355_AUXADC_CON8         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32C0))
#define MT6355_AUXADC_CON9         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32C2))
#define MT6355_AUXADC_CON10        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32C4))
#define MT6355_AUXADC_CON11        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32C6))
#define MT6355_AUXADC_CON12        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32C8))
#define MT6355_AUXADC_CON13        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32CA))
#define MT6355_AUXADC_CON14        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32CC))
#define MT6355_AUXADC_CON15        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32CE))
#define MT6355_AUXADC_CON16        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32D0))
#define MT6355_AUXADC_CON17        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32D2))
#define MT6355_AUXADC_CON18        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32D4))
#define MT6355_AUXADC_CON19        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32D6))
#define MT6355_AUXADC_CON20        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32D8))
#define MT6355_AUXADC_CON21        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32DA))
#define MT6355_AUXADC_CON22        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32DC))
#define MT6355_AUXADC_CON23        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32DE))
#define MT6355_AUXADC_AUTORPT0     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32E0))
#define MT6355_AUXADC_LBAT0        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32E2))
#define MT6355_AUXADC_LBAT1        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32E4))
#define MT6355_AUXADC_LBAT2        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32E6))
#define MT6355_AUXADC_LBAT3        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32E8))
#define MT6355_AUXADC_LBAT4        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32EA))
#define MT6355_AUXADC_LBAT5        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32EC))
#define MT6355_AUXADC_LBAT6        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32EE))
#define MT6355_AUXADC_ACCDET       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32F0))
#define MT6355_AUXADC_THR0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32F2))
#define MT6355_AUXADC_THR1         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32F4))
#define MT6355_AUXADC_THR2         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32F6))
#define MT6355_AUXADC_THR3         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32F8))
#define MT6355_AUXADC_THR4         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32FA))
#define MT6355_AUXADC_THR5         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32FC))
#define MT6355_AUXADC_THR6         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x32FE))
#define MT6355_AUXADC_EFUSE0       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3300))
#define MT6355_AUXADC_EFUSE1       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3302))
#define MT6355_AUXADC_EFUSE2       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3304))
#define MT6355_AUXADC_EFUSE3       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3306))
#define MT6355_AUXADC_EFUSE4       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3308))
#define MT6355_AUXADC_EFUSE5       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x330A))
#define MT6355_AUXADC_DBG0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x330C))
#define MT6355_AUXADC_IMP0         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x330E))
#define MT6355_AUXADC_IMP1         ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3310))
#define MT6355_AUXADC_BAT_TEMP_0   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3312))
#define MT6355_AUXADC_BAT_TEMP_1   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3314))
#define MT6355_AUXADC_BAT_TEMP_2   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3316))
#define MT6355_AUXADC_BAT_TEMP_3   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3318))
#define MT6355_AUXADC_BAT_TEMP_4   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x331A))
#define MT6355_AUXADC_BAT_TEMP_5   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x331C))
#define MT6355_AUXADC_BAT_TEMP_6   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x331E))
#define MT6355_AUXADC_BAT_TEMP_7   ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3320))
#define MT6355_AUXADC_LBAT2_1      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3322))
#define MT6355_AUXADC_LBAT2_2      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3324))
#define MT6355_AUXADC_LBAT2_3      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3326))
#define MT6355_AUXADC_LBAT2_4      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3328))
#define MT6355_AUXADC_LBAT2_5      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x332A))
#define MT6355_AUXADC_LBAT2_6      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x332C))
#define MT6355_AUXADC_LBAT2_7      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x332E))
#define MT6355_AUXADC_MDBG_0       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3330))
#define MT6355_AUXADC_MDBG_1       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3332))
#define MT6355_AUXADC_MDBG_2       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3334))
#define MT6355_AUXADC_MDRT_0       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3336))
#define MT6355_AUXADC_MDRT_1       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3338))
#define MT6355_AUXADC_MDRT_2       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x333A))
#define MT6355_AUXADC_MDRT_3       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x333C))
#define MT6355_AUXADC_MDRT_4       ((pmic_uint)(MT6355_PMIC_REG_BASE+0x333E))
#define MT6355_AUXADC_JEITA_0      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3340))
#define MT6355_AUXADC_JEITA_1      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3342))
#define MT6355_AUXADC_JEITA_2      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3344))
#define MT6355_AUXADC_JEITA_3      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3346))
#define MT6355_AUXADC_JEITA_4      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3348))
#define MT6355_AUXADC_JEITA_5      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x334A))
#define MT6355_AUXADC_DCXO_MDRT_0  ((pmic_uint)(MT6355_PMIC_REG_BASE+0x334C))
#define MT6355_AUXADC_DCXO_MDRT_1  ((pmic_uint)(MT6355_PMIC_REG_BASE+0x334E))
#define MT6355_AUXADC_DCXO_MDRT_2  ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3350))
#define MT6355_AUXADC_NAG_0        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3352))
#define MT6355_AUXADC_NAG_1        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3354))
#define MT6355_AUXADC_NAG_2        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3356))
#define MT6355_AUXADC_NAG_3        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3358))
#define MT6355_AUXADC_NAG_4        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x335A))
#define MT6355_AUXADC_NAG_5        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x335C))
#define MT6355_AUXADC_NAG_6        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x335E))
#define MT6355_AUXADC_NAG_7        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3360))
#define MT6355_AUXADC_NAG_8        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3362))
#define MT6355_AUXADC_EFUSE_1      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3364))
#define MT6355_AUXADC_EFUSE_2      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3366))
#define MT6355_AUXADC_EFUSE_3      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3368))
#define MT6355_AUXADC_EFUSE_4      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x336A))
#define MT6355_AUXADC_RSV_1        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x336C))
#define MT6355_AUXADC_ANA_0        ((pmic_uint)(MT6355_PMIC_REG_BASE+0x336E))
#define MT6355_AUXADC_IMP_CG0      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3370))
#define MT6355_AUXADC_LBAT_CG0     ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3372))
#define MT6355_AUXADC_THR_CG0      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3374))
#define MT6355_AUXADC_BAT_TEMP_CG0 ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3376))
#define MT6355_AUXADC_LBAT2_CG0    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x3378))
#define MT6355_AUXADC_JEITA_CG0    ((pmic_uint)(MT6355_PMIC_REG_BASE+0x337A))
#define MT6355_AUXADC_NAG_CG0      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x337C))
#define MT6355_AUXADC_PRI_NEW      ((pmic_uint)(MT6355_PMIC_REG_BASE+0x337E))


#define PMIC_DEW_READ_TEST_ADDR                  MT6355_DEW_READ_TEST
#define PMIC_DEW_READ_TEST_MASK                  0xFFFF
#define PMIC_DEW_READ_TEST_SHIFT                 0
#define PMIC_RG_STRUP_AUXADC_START_SW_ADDR       MT6355_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_START_SW_MASK       0x1
#define PMIC_RG_STRUP_AUXADC_START_SW_SHIFT      0
#define PMIC_RG_STRUP_AUXADC_RSTB_SW_ADDR        MT6355_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_RSTB_SW_MASK        0x1
#define PMIC_RG_STRUP_AUXADC_RSTB_SW_SHIFT       1
#define PMIC_RG_STRUP_AUXADC_START_SEL_ADDR      MT6355_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_START_SEL_MASK      0x1
#define PMIC_RG_STRUP_AUXADC_START_SEL_SHIFT     2
#define PMIC_RG_STRUP_AUXADC_RSTB_SEL_ADDR       MT6355_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_RSTB_SEL_MASK       0x1
#define PMIC_RG_STRUP_AUXADC_RSTB_SEL_SHIFT      3
#define PMIC_RG_STRUP_AUXADC_RPCNT_MAX_ADDR      MT6355_STRUP_CON6
#define PMIC_RG_STRUP_AUXADC_RPCNT_MAX_MASK      0x7F
#define PMIC_RG_STRUP_AUXADC_RPCNT_MAX_SHIFT     4
#define PMIC_RG_LDO_VBIF28_EN_ADDR               MT6355_LDO_VBIF28_CON0
#define PMIC_RG_LDO_VBIF28_EN_MASK               0x1
#define PMIC_RG_LDO_VBIF28_EN_SHIFT              0
#define PMIC_RG_LDO_VBIF28_SW_OP_EN_ADDR         MT6355_LDO_VBIF28_OP_EN
#define PMIC_RG_LDO_VBIF28_SW_OP_EN_MASK         0x1
#define PMIC_RG_LDO_VBIF28_SW_OP_EN_SHIFT        0
#define PMIC_DA_QI_VBIF28_EN_ADDR                MT6355_LDO_VBIF28_CON1
#define PMIC_DA_QI_VBIF28_EN_MASK                0x1
#define PMIC_DA_QI_VBIF28_EN_SHIFT               15
#define PMIC_RG_ADCIN_VSEN_MUX_EN_ADDR           MT6355_CHR_CON7
#define PMIC_RG_ADCIN_VSEN_MUX_EN_MASK           0x1
#define PMIC_RG_ADCIN_VSEN_MUX_EN_SHIFT          8
#define PMIC_BATON_TDET_EN_ADDR                  MT6355_PCHR_VREF_ANA_DA0
#define PMIC_BATON_TDET_EN_MASK                  0x1
#define PMIC_BATON_TDET_EN_SHIFT                 2
#define PMIC_AUXADC_ADC_OUT_CH0_ADDR             MT6355_AUXADC_ADC0
#define PMIC_AUXADC_ADC_OUT_CH0_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH0_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH0_ADDR             MT6355_AUXADC_ADC0
#define PMIC_AUXADC_ADC_RDY_CH0_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH0_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH1_ADDR             MT6355_AUXADC_ADC1
#define PMIC_AUXADC_ADC_OUT_CH1_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH1_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH1_ADDR             MT6355_AUXADC_ADC1
#define PMIC_AUXADC_ADC_RDY_CH1_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH1_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH2_ADDR             MT6355_AUXADC_ADC2
#define PMIC_AUXADC_ADC_OUT_CH2_MASK             0xFFF
#define PMIC_AUXADC_ADC_OUT_CH2_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH2_ADDR             MT6355_AUXADC_ADC2
#define PMIC_AUXADC_ADC_RDY_CH2_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH2_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH3_ADDR             MT6355_AUXADC_ADC3
#define PMIC_AUXADC_ADC_OUT_CH3_MASK             0xFFF
#define PMIC_AUXADC_ADC_OUT_CH3_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH3_ADDR             MT6355_AUXADC_ADC3
#define PMIC_AUXADC_ADC_RDY_CH3_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH3_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH4_ADDR             MT6355_AUXADC_ADC4
#define PMIC_AUXADC_ADC_OUT_CH4_MASK             0xFFF
#define PMIC_AUXADC_ADC_OUT_CH4_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH4_ADDR             MT6355_AUXADC_ADC4
#define PMIC_AUXADC_ADC_RDY_CH4_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH4_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH5_ADDR             MT6355_AUXADC_ADC5
#define PMIC_AUXADC_ADC_OUT_CH5_MASK             0xFFF
#define PMIC_AUXADC_ADC_OUT_CH5_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH5_ADDR             MT6355_AUXADC_ADC5
#define PMIC_AUXADC_ADC_RDY_CH5_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH5_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH6_ADDR             MT6355_AUXADC_ADC6
#define PMIC_AUXADC_ADC_OUT_CH6_MASK             0xFFF
#define PMIC_AUXADC_ADC_OUT_CH6_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH6_ADDR             MT6355_AUXADC_ADC6
#define PMIC_AUXADC_ADC_RDY_CH6_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH6_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH7_ADDR             MT6355_AUXADC_ADC7
#define PMIC_AUXADC_ADC_OUT_CH7_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH7_ADDR             MT6355_AUXADC_ADC7
#define PMIC_AUXADC_ADC_RDY_CH7_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH7_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH8_ADDR             MT6355_AUXADC_ADC8
#define PMIC_AUXADC_ADC_OUT_CH8_MASK             0xFFF
#define PMIC_AUXADC_ADC_OUT_CH8_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH8_ADDR             MT6355_AUXADC_ADC8
#define PMIC_AUXADC_ADC_RDY_CH8_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH8_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH9_ADDR             MT6355_AUXADC_ADC9
#define PMIC_AUXADC_ADC_OUT_CH9_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH9_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_CH9_ADDR             MT6355_AUXADC_ADC9
#define PMIC_AUXADC_ADC_RDY_CH9_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_CH9_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_CH10_ADDR            MT6355_AUXADC_ADC10
#define PMIC_AUXADC_ADC_OUT_CH10_MASK            0xFFF
#define PMIC_AUXADC_ADC_OUT_CH10_SHIFT           0
#define PMIC_AUXADC_ADC_RDY_CH10_ADDR            MT6355_AUXADC_ADC10
#define PMIC_AUXADC_ADC_RDY_CH10_MASK            0x1
#define PMIC_AUXADC_ADC_RDY_CH10_SHIFT           15
#define PMIC_AUXADC_ADC_OUT_CH11_ADDR            MT6355_AUXADC_ADC11
#define PMIC_AUXADC_ADC_OUT_CH11_MASK            0xFFF
#define PMIC_AUXADC_ADC_OUT_CH11_SHIFT           0
#define PMIC_AUXADC_ADC_RDY_CH11_ADDR            MT6355_AUXADC_ADC11
#define PMIC_AUXADC_ADC_RDY_CH11_MASK            0x1
#define PMIC_AUXADC_ADC_RDY_CH11_SHIFT           15
#define PMIC_AUXADC_ADC_OUT_CH12_15_ADDR         MT6355_AUXADC_ADC12
#define PMIC_AUXADC_ADC_OUT_CH12_15_MASK         0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH12_15_SHIFT        0
#define PMIC_AUXADC_ADC_RDY_CH12_15_ADDR         MT6355_AUXADC_ADC12
#define PMIC_AUXADC_ADC_RDY_CH12_15_MASK         0x1
#define PMIC_AUXADC_ADC_RDY_CH12_15_SHIFT        15
#define PMIC_AUXADC_ADC_OUT_THR_HW_ADDR          MT6355_AUXADC_ADC13
#define PMIC_AUXADC_ADC_OUT_THR_HW_MASK          0xFFF
#define PMIC_AUXADC_ADC_OUT_THR_HW_SHIFT         0
#define PMIC_AUXADC_ADC_RDY_THR_HW_ADDR          MT6355_AUXADC_ADC13
#define PMIC_AUXADC_ADC_RDY_THR_HW_MASK          0x1
#define PMIC_AUXADC_ADC_RDY_THR_HW_SHIFT         15
#define PMIC_AUXADC_ADC_OUT_LBAT_ADDR            MT6355_AUXADC_ADC14
#define PMIC_AUXADC_ADC_OUT_LBAT_MASK            0xFFF
#define PMIC_AUXADC_ADC_OUT_LBAT_SHIFT           0
#define PMIC_AUXADC_ADC_RDY_LBAT_ADDR            MT6355_AUXADC_ADC14
#define PMIC_AUXADC_ADC_RDY_LBAT_MASK            0x1
#define PMIC_AUXADC_ADC_RDY_LBAT_SHIFT           15
#define PMIC_AUXADC_ADC_OUT_LBAT2_ADDR           MT6355_AUXADC_ADC15
#define PMIC_AUXADC_ADC_OUT_LBAT2_MASK           0xFFF
#define PMIC_AUXADC_ADC_OUT_LBAT2_SHIFT          0
#define PMIC_AUXADC_ADC_RDY_LBAT2_ADDR           MT6355_AUXADC_ADC15
#define PMIC_AUXADC_ADC_RDY_LBAT2_MASK           0x1
#define PMIC_AUXADC_ADC_RDY_LBAT2_SHIFT          15
#define PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_ADDR      MT6355_AUXADC_ADC16
#define PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_MASK      0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_SHIFT     0
#define PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_ADDR      MT6355_AUXADC_ADC16
#define PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_MASK      0x1
#define PMIC_AUXADC_ADC_RDY_CH7_BY_GPS_SHIFT     15
#define PMIC_AUXADC_ADC_OUT_CH7_BY_MD_ADDR       MT6355_AUXADC_ADC17
#define PMIC_AUXADC_ADC_OUT_CH7_BY_MD_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_BY_MD_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH7_BY_MD_ADDR       MT6355_AUXADC_ADC17
#define PMIC_AUXADC_ADC_RDY_CH7_BY_MD_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH7_BY_MD_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_CH7_BY_AP_ADDR       MT6355_AUXADC_ADC18
#define PMIC_AUXADC_ADC_OUT_CH7_BY_AP_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH7_BY_AP_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH7_BY_AP_ADDR       MT6355_AUXADC_ADC18
#define PMIC_AUXADC_ADC_RDY_CH7_BY_AP_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH7_BY_AP_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_CH4_BY_MD_ADDR       MT6355_AUXADC_ADC19
#define PMIC_AUXADC_ADC_OUT_CH4_BY_MD_MASK       0xFFF
#define PMIC_AUXADC_ADC_OUT_CH4_BY_MD_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH4_BY_MD_ADDR       MT6355_AUXADC_ADC19
#define PMIC_AUXADC_ADC_RDY_CH4_BY_MD_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH4_BY_MD_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_PWRON_PCHR_ADDR      MT6355_AUXADC_ADC20
#define PMIC_AUXADC_ADC_OUT_PWRON_PCHR_MASK      0x7FFF
#define PMIC_AUXADC_ADC_OUT_PWRON_PCHR_SHIFT     0
#define PMIC_AUXADC_ADC_RDY_PWRON_PCHR_ADDR      MT6355_AUXADC_ADC20
#define PMIC_AUXADC_ADC_RDY_PWRON_PCHR_MASK      0x1
#define PMIC_AUXADC_ADC_RDY_PWRON_PCHR_SHIFT     15
#define PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_ADDR     MT6355_AUXADC_ADC21
#define PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_MASK     0x7FFF
#define PMIC_AUXADC_ADC_OUT_PWRON_SWCHR_SHIFT    0
#define PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_ADDR     MT6355_AUXADC_ADC21
#define PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_MASK     0x1
#define PMIC_AUXADC_ADC_RDY_PWRON_SWCHR_SHIFT    15
#define PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_ADDR     MT6355_AUXADC_ADC22
#define PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_MASK     0x7FFF
#define PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_SHIFT    0
#define PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_ADDR     MT6355_AUXADC_ADC22
#define PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_MASK     0x1
#define PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR_SHIFT    15
#define PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_ADDR    MT6355_AUXADC_ADC23
#define PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_MASK    0x7FFF
#define PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR_SHIFT   0
#define PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_ADDR    MT6355_AUXADC_ADC23
#define PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_MASK    0x1
#define PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR_SHIFT   15
#define PMIC_AUXADC_ADC_OUT_CH0_BY_MD_ADDR       MT6355_AUXADC_ADC24
#define PMIC_AUXADC_ADC_OUT_CH0_BY_MD_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH0_BY_MD_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH0_BY_MD_ADDR       MT6355_AUXADC_ADC24
#define PMIC_AUXADC_ADC_RDY_CH0_BY_MD_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH0_BY_MD_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_CH0_BY_AP_ADDR       MT6355_AUXADC_ADC25
#define PMIC_AUXADC_ADC_OUT_CH0_BY_AP_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH0_BY_AP_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH0_BY_AP_ADDR       MT6355_AUXADC_ADC25
#define PMIC_AUXADC_ADC_RDY_CH0_BY_AP_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH0_BY_AP_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_CH1_BY_MD_ADDR       MT6355_AUXADC_ADC26
#define PMIC_AUXADC_ADC_OUT_CH1_BY_MD_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH1_BY_MD_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH1_BY_MD_ADDR       MT6355_AUXADC_ADC26
#define PMIC_AUXADC_ADC_RDY_CH1_BY_MD_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH1_BY_MD_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_CH1_BY_AP_ADDR       MT6355_AUXADC_ADC27
#define PMIC_AUXADC_ADC_OUT_CH1_BY_AP_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_CH1_BY_AP_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_CH1_BY_AP_ADDR       MT6355_AUXADC_ADC27
#define PMIC_AUXADC_ADC_RDY_CH1_BY_AP_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_CH1_BY_AP_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_BAT_TEMP_ADDR        MT6355_AUXADC_ADC28
#define PMIC_AUXADC_ADC_OUT_BAT_TEMP_MASK        0xFFF
#define PMIC_AUXADC_ADC_OUT_BAT_TEMP_SHIFT       0
#define PMIC_AUXADC_ADC_RDY_BAT_TEMP_ADDR        MT6355_AUXADC_ADC28
#define PMIC_AUXADC_ADC_RDY_BAT_TEMP_MASK        0x1
#define PMIC_AUXADC_ADC_RDY_BAT_TEMP_SHIFT       15
#define PMIC_AUXADC_ADC_OUT_FGADC_PCHR_ADDR      MT6355_AUXADC_ADC29
#define PMIC_AUXADC_ADC_OUT_FGADC_PCHR_MASK      0x7FFF
#define PMIC_AUXADC_ADC_OUT_FGADC_PCHR_SHIFT     0
#define PMIC_AUXADC_ADC_RDY_FGADC_PCHR_ADDR      MT6355_AUXADC_ADC29
#define PMIC_AUXADC_ADC_RDY_FGADC_PCHR_MASK      0x1
#define PMIC_AUXADC_ADC_RDY_FGADC_PCHR_SHIFT     15
#define PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_ADDR     MT6355_AUXADC_ADC30
#define PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_MASK     0x7FFF
#define PMIC_AUXADC_ADC_OUT_FGADC_SWCHR_SHIFT    0
#define PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_ADDR     MT6355_AUXADC_ADC30
#define PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_MASK     0x1
#define PMIC_AUXADC_ADC_RDY_FGADC_SWCHR_SHIFT    15
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_ADDR         MT6355_AUXADC_ADC31
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_MASK         0x7FFF
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_SHIFT        0
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_ADDR         MT6355_AUXADC_ADC31
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_MASK         0x1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR_SHIFT        15
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_ADDR        MT6355_AUXADC_ADC32
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_MASK        0x7FFF
#define PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR_SHIFT       0
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_ADDR        MT6355_AUXADC_ADC32
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_MASK        0x1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR_SHIFT       15
#define PMIC_AUXADC_ADC_OUT_IMP_ADDR             MT6355_AUXADC_ADC33
#define PMIC_AUXADC_ADC_OUT_IMP_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_IMP_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_IMP_ADDR             MT6355_AUXADC_ADC33
#define PMIC_AUXADC_ADC_RDY_IMP_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_IMP_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_IMP_AVG_ADDR         MT6355_AUXADC_ADC34
#define PMIC_AUXADC_ADC_OUT_IMP_AVG_MASK         0x7FFF
#define PMIC_AUXADC_ADC_OUT_IMP_AVG_SHIFT        0
#define PMIC_AUXADC_ADC_RDY_IMP_AVG_ADDR         MT6355_AUXADC_ADC34
#define PMIC_AUXADC_ADC_RDY_IMP_AVG_MASK         0x1
#define PMIC_AUXADC_ADC_RDY_IMP_AVG_SHIFT        15
#define PMIC_AUXADC_ADC_OUT_RAW_ADDR             MT6355_AUXADC_ADC35
#define PMIC_AUXADC_ADC_OUT_RAW_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_RAW_SHIFT            0
#define PMIC_AUXADC_ADC_OUT_MDRT_ADDR            MT6355_AUXADC_ADC36
#define PMIC_AUXADC_ADC_OUT_MDRT_MASK            0x7FFF
#define PMIC_AUXADC_ADC_OUT_MDRT_SHIFT           0
#define PMIC_AUXADC_ADC_RDY_MDRT_ADDR            MT6355_AUXADC_ADC36
#define PMIC_AUXADC_ADC_RDY_MDRT_MASK            0x1
#define PMIC_AUXADC_ADC_RDY_MDRT_SHIFT           15
#define PMIC_AUXADC_ADC_OUT_MDBG_ADDR            MT6355_AUXADC_ADC37
#define PMIC_AUXADC_ADC_OUT_MDBG_MASK            0x7FFF
#define PMIC_AUXADC_ADC_OUT_MDBG_SHIFT           0
#define PMIC_AUXADC_ADC_RDY_MDBG_ADDR            MT6355_AUXADC_ADC37
#define PMIC_AUXADC_ADC_RDY_MDBG_MASK            0x1
#define PMIC_AUXADC_ADC_RDY_MDBG_SHIFT           15
#define PMIC_AUXADC_ADC_OUT_JEITA_ADDR           MT6355_AUXADC_ADC38
#define PMIC_AUXADC_ADC_OUT_JEITA_MASK           0xFFF
#define PMIC_AUXADC_ADC_OUT_JEITA_SHIFT          0
#define PMIC_AUXADC_ADC_RDY_JEITA_ADDR           MT6355_AUXADC_ADC38
#define PMIC_AUXADC_ADC_RDY_JEITA_MASK           0x1
#define PMIC_AUXADC_ADC_RDY_JEITA_SHIFT          15
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_ADDR     MT6355_AUXADC_ADC39
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_MASK     0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_SHIFT    0
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_ADDR     MT6355_AUXADC_ADC39
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_MASK     0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS_SHIFT    15
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_ADDR      MT6355_AUXADC_ADC40
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_MASK      0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_SHIFT     0
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_ADDR      MT6355_AUXADC_ADC40
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_MASK      0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_MD_SHIFT     15
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_ADDR      MT6355_AUXADC_ADC41
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_MASK      0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_SHIFT     0
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_ADDR      MT6355_AUXADC_ADC41
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_MASK      0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_BY_AP_SHIFT     15
#define PMIC_AUXADC_ADC_OUT_DCXO_MDRT_ADDR       MT6355_AUXADC_ADC42
#define PMIC_AUXADC_ADC_OUT_DCXO_MDRT_MASK       0x7FFF
#define PMIC_AUXADC_ADC_OUT_DCXO_MDRT_SHIFT      0
#define PMIC_AUXADC_ADC_RDY_DCXO_MDRT_ADDR       MT6355_AUXADC_ADC42
#define PMIC_AUXADC_ADC_RDY_DCXO_MDRT_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_DCXO_MDRT_SHIFT      15
#define PMIC_AUXADC_ADC_OUT_NAG_ADDR             MT6355_AUXADC_ADC43
#define PMIC_AUXADC_ADC_OUT_NAG_MASK             0x7FFF
#define PMIC_AUXADC_ADC_OUT_NAG_SHIFT            0
#define PMIC_AUXADC_ADC_RDY_NAG_ADDR             MT6355_AUXADC_ADC43
#define PMIC_AUXADC_ADC_RDY_NAG_MASK             0x1
#define PMIC_AUXADC_ADC_RDY_NAG_SHIFT            15
#define PMIC_AUXADC_ADC_OUT_BATID_ADDR           MT6355_AUXADC_ADC44
#define PMIC_AUXADC_ADC_OUT_BATID_MASK           0xFFF
#define PMIC_AUXADC_ADC_OUT_BATID_SHIFT          0
#define PMIC_AUXADC_ADC_RDY_BATID_ADDR           MT6355_AUXADC_ADC44
#define PMIC_AUXADC_ADC_RDY_BATID_MASK           0x1
#define PMIC_AUXADC_ADC_RDY_BATID_SHIFT          15
#define PMIC_AUXADC_BUF_OUT_00_ADDR              MT6355_AUXADC_BUF0
#define PMIC_AUXADC_BUF_OUT_00_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_00_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_00_ADDR              MT6355_AUXADC_BUF0
#define PMIC_AUXADC_BUF_RDY_00_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_00_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_01_ADDR              MT6355_AUXADC_BUF1
#define PMIC_AUXADC_BUF_OUT_01_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_01_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_01_ADDR              MT6355_AUXADC_BUF1
#define PMIC_AUXADC_BUF_RDY_01_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_01_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_02_ADDR              MT6355_AUXADC_BUF2
#define PMIC_AUXADC_BUF_OUT_02_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_02_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_02_ADDR              MT6355_AUXADC_BUF2
#define PMIC_AUXADC_BUF_RDY_02_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_02_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_03_ADDR              MT6355_AUXADC_BUF3
#define PMIC_AUXADC_BUF_OUT_03_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_03_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_03_ADDR              MT6355_AUXADC_BUF3
#define PMIC_AUXADC_BUF_RDY_03_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_03_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_04_ADDR              MT6355_AUXADC_BUF4
#define PMIC_AUXADC_BUF_OUT_04_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_04_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_04_ADDR              MT6355_AUXADC_BUF4
#define PMIC_AUXADC_BUF_RDY_04_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_04_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_05_ADDR              MT6355_AUXADC_BUF5
#define PMIC_AUXADC_BUF_OUT_05_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_05_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_05_ADDR              MT6355_AUXADC_BUF5
#define PMIC_AUXADC_BUF_RDY_05_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_05_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_06_ADDR              MT6355_AUXADC_BUF6
#define PMIC_AUXADC_BUF_OUT_06_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_06_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_06_ADDR              MT6355_AUXADC_BUF6
#define PMIC_AUXADC_BUF_RDY_06_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_06_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_07_ADDR              MT6355_AUXADC_BUF7
#define PMIC_AUXADC_BUF_OUT_07_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_07_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_07_ADDR              MT6355_AUXADC_BUF7
#define PMIC_AUXADC_BUF_RDY_07_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_07_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_08_ADDR              MT6355_AUXADC_BUF8
#define PMIC_AUXADC_BUF_OUT_08_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_08_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_08_ADDR              MT6355_AUXADC_BUF8
#define PMIC_AUXADC_BUF_RDY_08_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_08_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_09_ADDR              MT6355_AUXADC_BUF9
#define PMIC_AUXADC_BUF_OUT_09_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_09_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_09_ADDR              MT6355_AUXADC_BUF9
#define PMIC_AUXADC_BUF_RDY_09_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_09_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_10_ADDR              MT6355_AUXADC_BUF10
#define PMIC_AUXADC_BUF_OUT_10_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_10_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_10_ADDR              MT6355_AUXADC_BUF10
#define PMIC_AUXADC_BUF_RDY_10_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_10_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_11_ADDR              MT6355_AUXADC_BUF11
#define PMIC_AUXADC_BUF_OUT_11_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_11_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_11_ADDR              MT6355_AUXADC_BUF11
#define PMIC_AUXADC_BUF_RDY_11_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_11_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_12_ADDR              MT6355_AUXADC_BUF12
#define PMIC_AUXADC_BUF_OUT_12_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_12_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_12_ADDR              MT6355_AUXADC_BUF12
#define PMIC_AUXADC_BUF_RDY_12_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_12_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_13_ADDR              MT6355_AUXADC_BUF13
#define PMIC_AUXADC_BUF_OUT_13_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_13_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_13_ADDR              MT6355_AUXADC_BUF13
#define PMIC_AUXADC_BUF_RDY_13_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_13_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_14_ADDR              MT6355_AUXADC_BUF14
#define PMIC_AUXADC_BUF_OUT_14_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_14_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_14_ADDR              MT6355_AUXADC_BUF14
#define PMIC_AUXADC_BUF_RDY_14_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_14_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_15_ADDR              MT6355_AUXADC_BUF15
#define PMIC_AUXADC_BUF_OUT_15_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_15_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_15_ADDR              MT6355_AUXADC_BUF15
#define PMIC_AUXADC_BUF_RDY_15_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_15_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_16_ADDR              MT6355_AUXADC_BUF16
#define PMIC_AUXADC_BUF_OUT_16_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_16_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_16_ADDR              MT6355_AUXADC_BUF16
#define PMIC_AUXADC_BUF_RDY_16_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_16_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_17_ADDR              MT6355_AUXADC_BUF17
#define PMIC_AUXADC_BUF_OUT_17_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_17_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_17_ADDR              MT6355_AUXADC_BUF17
#define PMIC_AUXADC_BUF_RDY_17_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_17_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_18_ADDR              MT6355_AUXADC_BUF18
#define PMIC_AUXADC_BUF_OUT_18_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_18_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_18_ADDR              MT6355_AUXADC_BUF18
#define PMIC_AUXADC_BUF_RDY_18_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_18_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_19_ADDR              MT6355_AUXADC_BUF19
#define PMIC_AUXADC_BUF_OUT_19_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_19_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_19_ADDR              MT6355_AUXADC_BUF19
#define PMIC_AUXADC_BUF_RDY_19_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_19_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_20_ADDR              MT6355_AUXADC_BUF20
#define PMIC_AUXADC_BUF_OUT_20_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_20_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_20_ADDR              MT6355_AUXADC_BUF20
#define PMIC_AUXADC_BUF_RDY_20_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_20_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_21_ADDR              MT6355_AUXADC_BUF21
#define PMIC_AUXADC_BUF_OUT_21_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_21_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_21_ADDR              MT6355_AUXADC_BUF21
#define PMIC_AUXADC_BUF_RDY_21_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_21_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_22_ADDR              MT6355_AUXADC_BUF22
#define PMIC_AUXADC_BUF_OUT_22_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_22_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_22_ADDR              MT6355_AUXADC_BUF22
#define PMIC_AUXADC_BUF_RDY_22_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_22_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_23_ADDR              MT6355_AUXADC_BUF23
#define PMIC_AUXADC_BUF_OUT_23_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_23_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_23_ADDR              MT6355_AUXADC_BUF23
#define PMIC_AUXADC_BUF_RDY_23_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_23_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_24_ADDR              MT6355_AUXADC_BUF24
#define PMIC_AUXADC_BUF_OUT_24_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_24_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_24_ADDR              MT6355_AUXADC_BUF24
#define PMIC_AUXADC_BUF_RDY_24_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_24_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_25_ADDR              MT6355_AUXADC_BUF25
#define PMIC_AUXADC_BUF_OUT_25_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_25_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_25_ADDR              MT6355_AUXADC_BUF25
#define PMIC_AUXADC_BUF_RDY_25_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_25_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_26_ADDR              MT6355_AUXADC_BUF26
#define PMIC_AUXADC_BUF_OUT_26_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_26_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_26_ADDR              MT6355_AUXADC_BUF26
#define PMIC_AUXADC_BUF_RDY_26_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_26_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_27_ADDR              MT6355_AUXADC_BUF27
#define PMIC_AUXADC_BUF_OUT_27_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_27_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_27_ADDR              MT6355_AUXADC_BUF27
#define PMIC_AUXADC_BUF_RDY_27_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_27_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_28_ADDR              MT6355_AUXADC_BUF28
#define PMIC_AUXADC_BUF_OUT_28_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_28_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_28_ADDR              MT6355_AUXADC_BUF28
#define PMIC_AUXADC_BUF_RDY_28_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_28_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_29_ADDR              MT6355_AUXADC_BUF29
#define PMIC_AUXADC_BUF_OUT_29_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_29_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_29_ADDR              MT6355_AUXADC_BUF29
#define PMIC_AUXADC_BUF_RDY_29_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_29_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_30_ADDR              MT6355_AUXADC_BUF30
#define PMIC_AUXADC_BUF_OUT_30_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_30_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_30_ADDR              MT6355_AUXADC_BUF30
#define PMIC_AUXADC_BUF_RDY_30_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_30_SHIFT             15
#define PMIC_AUXADC_BUF_OUT_31_ADDR              MT6355_AUXADC_BUF31
#define PMIC_AUXADC_BUF_OUT_31_MASK              0x7FFF
#define PMIC_AUXADC_BUF_OUT_31_SHIFT             0
#define PMIC_AUXADC_BUF_RDY_31_ADDR              MT6355_AUXADC_BUF31
#define PMIC_AUXADC_BUF_RDY_31_MASK              0x1
#define PMIC_AUXADC_BUF_RDY_31_SHIFT             15
#define PMIC_AUXADC_ADC_BUSY_IN_ADDR             MT6355_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_MASK             0xFFF
#define PMIC_AUXADC_ADC_BUSY_IN_SHIFT            0
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT_ADDR        MT6355_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT_MASK        0x1
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT_SHIFT       12
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT2_ADDR       MT6355_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT2_MASK       0x1
#define PMIC_AUXADC_ADC_BUSY_IN_LBAT2_SHIFT      13
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_ADDR    MT6355_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_MASK    0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP_SHIFT   14
#define PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_ADDR      MT6355_AUXADC_STA0
#define PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_MASK      0x1
#define PMIC_AUXADC_ADC_BUSY_IN_WAKEUP_SHIFT     15
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_ADDR   MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_MASK   0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT_SHIFT  0
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_ADDR  MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_MASK  0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP_SHIFT 1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_ADDR  MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_MASK  0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD_SHIFT 2
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_ADDR    MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MASK    0x1
#define PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_SHIFT   3
#define PMIC_AUXADC_ADC_BUSY_IN_JEITA_ADDR       MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_JEITA_MASK       0x1
#define PMIC_AUXADC_ADC_BUSY_IN_JEITA_SHIFT      4
#define PMIC_AUXADC_ADC_BUSY_IN_MDRT_ADDR        MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_MDRT_MASK        0x1
#define PMIC_AUXADC_ADC_BUSY_IN_MDRT_SHIFT       5
#define PMIC_AUXADC_ADC_BUSY_IN_MDBG_ADDR        MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_MDBG_MASK        0x1
#define PMIC_AUXADC_ADC_BUSY_IN_MDBG_SHIFT       6
#define PMIC_AUXADC_ADC_BUSY_IN_SHARE_ADDR       MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_SHARE_MASK       0x1
#define PMIC_AUXADC_ADC_BUSY_IN_SHARE_SHIFT      7
#define PMIC_AUXADC_ADC_BUSY_IN_IMP_ADDR         MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_IMP_MASK         0x1
#define PMIC_AUXADC_ADC_BUSY_IN_IMP_SHIFT        8
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_ADDR  MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_MASK  0x1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR_SHIFT 9
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_ADDR  MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_MASK  0x1
#define PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR_SHIFT 10
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_ADDR      MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_MASK      0x1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_AP_SHIFT     11
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_ADDR      MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_MASK      0x1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MD_SHIFT     12
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_ADDR         MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_MASK         0x1
#define PMIC_AUXADC_ADC_BUSY_IN_GPS_SHIFT        13
#define PMIC_AUXADC_ADC_BUSY_IN_THR_HW_ADDR      MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_HW_MASK      0x1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_HW_SHIFT     14
#define PMIC_AUXADC_ADC_BUSY_IN_THR_MD_ADDR      MT6355_AUXADC_STA1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_MD_MASK      0x1
#define PMIC_AUXADC_ADC_BUSY_IN_THR_MD_SHIFT     15
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_ADDR     MT6355_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_MASK     0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR_SHIFT    0
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_ADDR    MT6355_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_MASK    0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR_SHIFT   1
#define PMIC_AUXADC_ADC_BUSY_IN_BATID_ADDR       MT6355_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_BATID_MASK       0x1
#define PMIC_AUXADC_ADC_BUSY_IN_BATID_SHIFT      2
#define PMIC_AUXADC_ADC_BUSY_IN_PWRON_ADDR       MT6355_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_PWRON_MASK       0x1
#define PMIC_AUXADC_ADC_BUSY_IN_PWRON_SHIFT      3
#define PMIC_AUXADC_ADC_BUSY_IN_NAG_ADDR         MT6355_AUXADC_STA2
#define PMIC_AUXADC_ADC_BUSY_IN_NAG_MASK         0x1
#define PMIC_AUXADC_ADC_BUSY_IN_NAG_SHIFT        15
#define PMIC_AUXADC_RQST_CH0_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH0_MASK                0x1
#define PMIC_AUXADC_RQST_CH0_SHIFT               0
#define PMIC_AUXADC_RQST_CH1_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH1_MASK                0x1
#define PMIC_AUXADC_RQST_CH1_SHIFT               1
#define PMIC_AUXADC_RQST_CH2_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH2_MASK                0x1
#define PMIC_AUXADC_RQST_CH2_SHIFT               2
#define PMIC_AUXADC_RQST_CH3_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH3_MASK                0x1
#define PMIC_AUXADC_RQST_CH3_SHIFT               3
#define PMIC_AUXADC_RQST_CH4_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH4_MASK                0x1
#define PMIC_AUXADC_RQST_CH4_SHIFT               4
#define PMIC_AUXADC_RQST_CH5_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH5_MASK                0x1
#define PMIC_AUXADC_RQST_CH5_SHIFT               5
#define PMIC_AUXADC_RQST_CH6_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH6_MASK                0x1
#define PMIC_AUXADC_RQST_CH6_SHIFT               6
#define PMIC_AUXADC_RQST_CH7_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH7_MASK                0x1
#define PMIC_AUXADC_RQST_CH7_SHIFT               7
#define PMIC_AUXADC_RQST_CH8_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH8_MASK                0x1
#define PMIC_AUXADC_RQST_CH8_SHIFT               8
#define PMIC_AUXADC_RQST_CH9_ADDR                MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH9_MASK                0x1
#define PMIC_AUXADC_RQST_CH9_SHIFT               9
#define PMIC_AUXADC_RQST_CH10_ADDR               MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH10_MASK               0x1
#define PMIC_AUXADC_RQST_CH10_SHIFT              10
#define PMIC_AUXADC_RQST_CH11_ADDR               MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH11_MASK               0x1
#define PMIC_AUXADC_RQST_CH11_SHIFT              11
#define PMIC_AUXADC_RQST_CH12_ADDR               MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH12_MASK               0x1
#define PMIC_AUXADC_RQST_CH12_SHIFT              12
#define PMIC_AUXADC_RQST_CH13_ADDR               MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH13_MASK               0x1
#define PMIC_AUXADC_RQST_CH13_SHIFT              13
#define PMIC_AUXADC_RQST_CH14_ADDR               MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH14_MASK               0x1
#define PMIC_AUXADC_RQST_CH14_SHIFT              14
#define PMIC_AUXADC_RQST_CH15_ADDR               MT6355_AUXADC_RQST0
#define PMIC_AUXADC_RQST_CH15_MASK               0x1
#define PMIC_AUXADC_RQST_CH15_SHIFT              15
#define PMIC_AUXADC_RQST0_SET_ADDR               MT6355_AUXADC_RQST0_SET
#define PMIC_AUXADC_RQST0_SET_MASK               0xFFFF
#define PMIC_AUXADC_RQST0_SET_SHIFT              0
#define PMIC_AUXADC_RQST0_CLR_ADDR               MT6355_AUXADC_RQST0_CLR
#define PMIC_AUXADC_RQST0_CLR_MASK               0xFFFF
#define PMIC_AUXADC_RQST0_CLR_SHIFT              0
#define PMIC_AUXADC_RQST_CH0_BY_MD_ADDR          MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH0_BY_MD_MASK          0x1
#define PMIC_AUXADC_RQST_CH0_BY_MD_SHIFT         0
#define PMIC_AUXADC_RQST_CH1_BY_MD_ADDR          MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH1_BY_MD_MASK          0x1
#define PMIC_AUXADC_RQST_CH1_BY_MD_SHIFT         1
#define PMIC_AUXADC_RQST_RSV0_ADDR               MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_RSV0_MASK               0x1
#define PMIC_AUXADC_RQST_RSV0_SHIFT              2
#define PMIC_AUXADC_RQST_BATID_ADDR              MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_BATID_MASK              0x1
#define PMIC_AUXADC_RQST_BATID_SHIFT             3
#define PMIC_AUXADC_RQST_CH4_BY_MD_ADDR          MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH4_BY_MD_MASK          0x1
#define PMIC_AUXADC_RQST_CH4_BY_MD_SHIFT         4
#define PMIC_AUXADC_RQST_CH7_BY_MD_ADDR          MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH7_BY_MD_MASK          0x1
#define PMIC_AUXADC_RQST_CH7_BY_MD_SHIFT         7
#define PMIC_AUXADC_RQST_CH7_BY_GPS_ADDR         MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_CH7_BY_GPS_MASK         0x1
#define PMIC_AUXADC_RQST_CH7_BY_GPS_SHIFT        8
#define PMIC_AUXADC_RQST_DCXO_BY_MD_ADDR         MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_DCXO_BY_MD_MASK         0x1
#define PMIC_AUXADC_RQST_DCXO_BY_MD_SHIFT        9
#define PMIC_AUXADC_RQST_DCXO_BY_GPS_ADDR        MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_DCXO_BY_GPS_MASK        0x1
#define PMIC_AUXADC_RQST_DCXO_BY_GPS_SHIFT       10
#define PMIC_AUXADC_RQST_RSV1_ADDR               MT6355_AUXADC_RQST1
#define PMIC_AUXADC_RQST_RSV1_MASK               0x1F
#define PMIC_AUXADC_RQST_RSV1_SHIFT              11
#define PMIC_AUXADC_RQST1_SET_ADDR               MT6355_AUXADC_RQST1_SET
#define PMIC_AUXADC_RQST1_SET_MASK               0xFFFF
#define PMIC_AUXADC_RQST1_SET_SHIFT              0
#define PMIC_AUXADC_RQST1_CLR_ADDR               MT6355_AUXADC_RQST1_CLR
#define PMIC_AUXADC_RQST1_CLR_MASK               0xFFFF
#define PMIC_AUXADC_RQST1_CLR_SHIFT              0
#define PMIC_AUXADC_CK_ON_EXTD_ADDR              MT6355_AUXADC_CON0
#define PMIC_AUXADC_CK_ON_EXTD_MASK              0x3F
#define PMIC_AUXADC_CK_ON_EXTD_SHIFT             0
#define PMIC_AUXADC_SRCLKEN_SRC_SEL_ADDR         MT6355_AUXADC_CON0
#define PMIC_AUXADC_SRCLKEN_SRC_SEL_MASK         0x3
#define PMIC_AUXADC_SRCLKEN_SRC_SEL_SHIFT        6
#define PMIC_AUXADC_ADC_PWDB_ADDR                MT6355_AUXADC_CON0
#define PMIC_AUXADC_ADC_PWDB_MASK                0x1
#define PMIC_AUXADC_ADC_PWDB_SHIFT               8
#define PMIC_AUXADC_ADC_PWDB_SWCTRL_ADDR         MT6355_AUXADC_CON0
#define PMIC_AUXADC_ADC_PWDB_SWCTRL_MASK         0x1
#define PMIC_AUXADC_ADC_PWDB_SWCTRL_SHIFT        9
#define PMIC_AUXADC_STRUP_CK_ON_ENB_ADDR         MT6355_AUXADC_CON0
#define PMIC_AUXADC_STRUP_CK_ON_ENB_MASK         0x1
#define PMIC_AUXADC_STRUP_CK_ON_ENB_SHIFT        10
#define PMIC_AUXADC_SRCLKEN_CK_EN_ADDR           MT6355_AUXADC_CON0
#define PMIC_AUXADC_SRCLKEN_CK_EN_MASK           0x1
#define PMIC_AUXADC_SRCLKEN_CK_EN_SHIFT          12
#define PMIC_AUXADC_CK_AON_GPS_ADDR              MT6355_AUXADC_CON0
#define PMIC_AUXADC_CK_AON_GPS_MASK              0x1
#define PMIC_AUXADC_CK_AON_GPS_SHIFT             13
#define PMIC_AUXADC_CK_AON_MD_ADDR               MT6355_AUXADC_CON0
#define PMIC_AUXADC_CK_AON_MD_MASK               0x1
#define PMIC_AUXADC_CK_AON_MD_SHIFT              14
#define PMIC_AUXADC_CK_AON_ADDR                  MT6355_AUXADC_CON0
#define PMIC_AUXADC_CK_AON_MASK                  0x1
#define PMIC_AUXADC_CK_AON_SHIFT                 15
#define PMIC_AUXADC_CON0_SET_ADDR                MT6355_AUXADC_CON0_SET
#define PMIC_AUXADC_CON0_SET_MASK                0xFFFF
#define PMIC_AUXADC_CON0_SET_SHIFT               0
#define PMIC_AUXADC_CON0_CLR_ADDR                MT6355_AUXADC_CON0_CLR
#define PMIC_AUXADC_CON0_CLR_MASK                0xFFFF
#define PMIC_AUXADC_CON0_CLR_SHIFT               0
#define PMIC_AUXADC_AVG_NUM_SMALL_ADDR           MT6355_AUXADC_CON1
#define PMIC_AUXADC_AVG_NUM_SMALL_MASK           0x7
#define PMIC_AUXADC_AVG_NUM_SMALL_SHIFT          0
#define PMIC_AUXADC_AVG_NUM_LARGE_ADDR           MT6355_AUXADC_CON1
#define PMIC_AUXADC_AVG_NUM_LARGE_MASK           0x7
#define PMIC_AUXADC_AVG_NUM_LARGE_SHIFT          3
#define PMIC_AUXADC_SPL_NUM_ADDR                 MT6355_AUXADC_CON1
#define PMIC_AUXADC_SPL_NUM_MASK                 0x3FF
#define PMIC_AUXADC_SPL_NUM_SHIFT                6
#define PMIC_AUXADC_AVG_NUM_SEL_ADDR             MT6355_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_MASK             0xFFF
#define PMIC_AUXADC_AVG_NUM_SEL_SHIFT            0
#define PMIC_AUXADC_AVG_NUM_SEL_SHARE_ADDR       MT6355_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_SHARE_MASK       0x1
#define PMIC_AUXADC_AVG_NUM_SEL_SHARE_SHIFT      12
#define PMIC_AUXADC_AVG_NUM_SEL_LBAT_ADDR        MT6355_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_LBAT_MASK        0x1
#define PMIC_AUXADC_AVG_NUM_SEL_LBAT_SHIFT       13
#define PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_ADDR    MT6355_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_MASK    0x1
#define PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP_SHIFT   14
#define PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_ADDR      MT6355_AUXADC_CON2
#define PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_MASK      0x1
#define PMIC_AUXADC_AVG_NUM_SEL_WAKEUP_SHIFT     15
#define PMIC_AUXADC_SPL_NUM_LARGE_ADDR           MT6355_AUXADC_CON3
#define PMIC_AUXADC_SPL_NUM_LARGE_MASK           0x3FF
#define PMIC_AUXADC_SPL_NUM_LARGE_SHIFT          0
#define PMIC_AUXADC_SPL_NUM_SLEEP_ADDR           MT6355_AUXADC_CON4
#define PMIC_AUXADC_SPL_NUM_SLEEP_MASK           0x3FF
#define PMIC_AUXADC_SPL_NUM_SLEEP_SHIFT          0
#define PMIC_AUXADC_SPL_NUM_SLEEP_SEL_ADDR       MT6355_AUXADC_CON4
#define PMIC_AUXADC_SPL_NUM_SLEEP_SEL_MASK       0x1
#define PMIC_AUXADC_SPL_NUM_SLEEP_SEL_SHIFT      15
#define PMIC_AUXADC_SPL_NUM_SEL_ADDR             MT6355_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_MASK             0xFFF
#define PMIC_AUXADC_SPL_NUM_SEL_SHIFT            0
#define PMIC_AUXADC_SPL_NUM_SEL_SHARE_ADDR       MT6355_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_SHARE_MASK       0x1
#define PMIC_AUXADC_SPL_NUM_SEL_SHARE_SHIFT      12
#define PMIC_AUXADC_SPL_NUM_SEL_LBAT_ADDR        MT6355_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_LBAT_MASK        0x1
#define PMIC_AUXADC_SPL_NUM_SEL_LBAT_SHIFT       13
#define PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_ADDR    MT6355_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_MASK    0x1
#define PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP_SHIFT   14
#define PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_ADDR      MT6355_AUXADC_CON5
#define PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_MASK      0x1
#define PMIC_AUXADC_SPL_NUM_SEL_WAKEUP_SHIFT     15
#define PMIC_AUXADC_SPL_NUM_CH0_ADDR             MT6355_AUXADC_CON6
#define PMIC_AUXADC_SPL_NUM_CH0_MASK             0x3FF
#define PMIC_AUXADC_SPL_NUM_CH0_SHIFT            0
#define PMIC_AUXADC_SPL_NUM_CH3_ADDR             MT6355_AUXADC_CON7
#define PMIC_AUXADC_SPL_NUM_CH3_MASK             0x3FF
#define PMIC_AUXADC_SPL_NUM_CH3_SHIFT            0
#define PMIC_AUXADC_SPL_NUM_CH7_ADDR             MT6355_AUXADC_CON8
#define PMIC_AUXADC_SPL_NUM_CH7_MASK             0x3FF
#define PMIC_AUXADC_SPL_NUM_CH7_SHIFT            0
#define PMIC_AUXADC_AVG_NUM_LBAT_ADDR            MT6355_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_LBAT_MASK            0x7
#define PMIC_AUXADC_AVG_NUM_LBAT_SHIFT           0
#define PMIC_AUXADC_AVG_NUM_CH7_ADDR             MT6355_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_CH7_MASK             0x7
#define PMIC_AUXADC_AVG_NUM_CH7_SHIFT            4
#define PMIC_AUXADC_AVG_NUM_CH3_ADDR             MT6355_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_CH3_MASK             0x7
#define PMIC_AUXADC_AVG_NUM_CH3_SHIFT            8
#define PMIC_AUXADC_AVG_NUM_CH0_ADDR             MT6355_AUXADC_CON9
#define PMIC_AUXADC_AVG_NUM_CH0_MASK             0x7
#define PMIC_AUXADC_AVG_NUM_CH0_SHIFT            12
#define PMIC_AUXADC_AVG_NUM_HPC_ADDR             MT6355_AUXADC_CON10
#define PMIC_AUXADC_AVG_NUM_HPC_MASK             0x7
#define PMIC_AUXADC_AVG_NUM_HPC_SHIFT            0
#define PMIC_AUXADC_AVG_NUM_DCXO_ADDR            MT6355_AUXADC_CON10
#define PMIC_AUXADC_AVG_NUM_DCXO_MASK            0x7
#define PMIC_AUXADC_AVG_NUM_DCXO_SHIFT           4
#define PMIC_AUXADC_TRIM_CH0_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH0_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH0_SEL_SHIFT           0
#define PMIC_AUXADC_TRIM_CH1_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH1_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH1_SEL_SHIFT           2
#define PMIC_AUXADC_TRIM_CH2_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH2_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH2_SEL_SHIFT           4
#define PMIC_AUXADC_TRIM_CH3_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH3_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH3_SEL_SHIFT           6
#define PMIC_AUXADC_TRIM_CH4_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH4_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH4_SEL_SHIFT           8
#define PMIC_AUXADC_TRIM_CH5_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH5_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH5_SEL_SHIFT           10
#define PMIC_AUXADC_TRIM_CH6_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH6_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH6_SEL_SHIFT           12
#define PMIC_AUXADC_TRIM_CH7_SEL_ADDR            MT6355_AUXADC_CON11
#define PMIC_AUXADC_TRIM_CH7_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH7_SEL_SHIFT           14
#define PMIC_AUXADC_TRIM_CH8_SEL_ADDR            MT6355_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH8_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH8_SEL_SHIFT           0
#define PMIC_AUXADC_TRIM_CH9_SEL_ADDR            MT6355_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH9_SEL_MASK            0x3
#define PMIC_AUXADC_TRIM_CH9_SEL_SHIFT           2
#define PMIC_AUXADC_TRIM_CH10_SEL_ADDR           MT6355_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH10_SEL_MASK           0x3
#define PMIC_AUXADC_TRIM_CH10_SEL_SHIFT          4
#define PMIC_AUXADC_TRIM_CH11_SEL_ADDR           MT6355_AUXADC_CON12
#define PMIC_AUXADC_TRIM_CH11_SEL_MASK           0x3
#define PMIC_AUXADC_TRIM_CH11_SEL_SHIFT          6
#define PMIC_AUXADC_ADC_2S_COMP_ENB_ADDR         MT6355_AUXADC_CON12
#define PMIC_AUXADC_ADC_2S_COMP_ENB_MASK         0x1
#define PMIC_AUXADC_ADC_2S_COMP_ENB_SHIFT        14
#define PMIC_AUXADC_ADC_TRIM_COMP_ADDR           MT6355_AUXADC_CON12
#define PMIC_AUXADC_ADC_TRIM_COMP_MASK           0x1
#define PMIC_AUXADC_ADC_TRIM_COMP_SHIFT          15
#define PMIC_AUXADC_SW_GAIN_TRIM_ADDR            MT6355_AUXADC_CON13
#define PMIC_AUXADC_SW_GAIN_TRIM_MASK            0x7FFF
#define PMIC_AUXADC_SW_GAIN_TRIM_SHIFT           0
#define PMIC_AUXADC_SW_OFFSET_TRIM_ADDR          MT6355_AUXADC_CON14
#define PMIC_AUXADC_SW_OFFSET_TRIM_MASK          0x7FFF
#define PMIC_AUXADC_SW_OFFSET_TRIM_SHIFT         0
#define PMIC_AUXADC_RNG_EN_ADDR                  MT6355_AUXADC_CON15
#define PMIC_AUXADC_RNG_EN_MASK                  0x1
#define PMIC_AUXADC_RNG_EN_SHIFT                 0
#define PMIC_AUXADC_TEST_MODE_ADDR               MT6355_AUXADC_CON15
#define PMIC_AUXADC_TEST_MODE_MASK               0x1
#define PMIC_AUXADC_TEST_MODE_SHIFT              3
#define PMIC_AUXADC_BIT_SEL_ADDR                 MT6355_AUXADC_CON15
#define PMIC_AUXADC_BIT_SEL_MASK                 0x1
#define PMIC_AUXADC_BIT_SEL_SHIFT                4
#define PMIC_AUXADC_START_SW_ADDR                MT6355_AUXADC_CON15
#define PMIC_AUXADC_START_SW_MASK                0x1
#define PMIC_AUXADC_START_SW_SHIFT               5
#define PMIC_AUXADC_START_SWCTRL_ADDR            MT6355_AUXADC_CON15
#define PMIC_AUXADC_START_SWCTRL_MASK            0x1
#define PMIC_AUXADC_START_SWCTRL_SHIFT           6
#define PMIC_AUXADC_TS_VBE_SEL_ADDR              MT6355_AUXADC_CON15
#define PMIC_AUXADC_TS_VBE_SEL_MASK              0x1
#define PMIC_AUXADC_TS_VBE_SEL_SHIFT             7
#define PMIC_AUXADC_TS_VBE_SEL_SWCTRL_ADDR       MT6355_AUXADC_CON15
#define PMIC_AUXADC_TS_VBE_SEL_SWCTRL_MASK       0x1
#define PMIC_AUXADC_TS_VBE_SEL_SWCTRL_SHIFT      8
#define PMIC_AUXADC_VBUF_EN_ADDR                 MT6355_AUXADC_CON15
#define PMIC_AUXADC_VBUF_EN_MASK                 0x1
#define PMIC_AUXADC_VBUF_EN_SHIFT                9
#define PMIC_AUXADC_VBUF_EN_SWCTRL_ADDR          MT6355_AUXADC_CON15
#define PMIC_AUXADC_VBUF_EN_SWCTRL_MASK          0x1
#define PMIC_AUXADC_VBUF_EN_SWCTRL_SHIFT         10
#define PMIC_AUXADC_OUT_SEL_ADDR                 MT6355_AUXADC_CON15
#define PMIC_AUXADC_OUT_SEL_MASK                 0x1
#define PMIC_AUXADC_OUT_SEL_SHIFT                11
#define PMIC_AUXADC_DA_DAC_ADDR                  MT6355_AUXADC_CON16
#define PMIC_AUXADC_DA_DAC_MASK                  0xFFF
#define PMIC_AUXADC_DA_DAC_SHIFT                 0
#define PMIC_AUXADC_DA_DAC_SWCTRL_ADDR           MT6355_AUXADC_CON16
#define PMIC_AUXADC_DA_DAC_SWCTRL_MASK           0x1
#define PMIC_AUXADC_DA_DAC_SWCTRL_SHIFT          12
#define PMIC_AD_AUXADC_COMP_ADDR                 MT6355_AUXADC_CON16
#define PMIC_AD_AUXADC_COMP_MASK                 0x1
#define PMIC_AD_AUXADC_COMP_SHIFT                15
#define PMIC_RG_AUXADC_CALI_ADDR                 MT6355_AUXADC_CON17
#define PMIC_RG_AUXADC_CALI_MASK                 0xF
#define PMIC_RG_AUXADC_CALI_SHIFT                0
#define PMIC_RG_AUX_RSV_ADDR                     MT6355_AUXADC_CON17
#define PMIC_RG_AUX_RSV_MASK                     0xF
#define PMIC_RG_AUX_RSV_SHIFT                    4
#define PMIC_RG_VBUF_BYP_ADDR                    MT6355_AUXADC_CON17
#define PMIC_RG_VBUF_BYP_MASK                    0x1
#define PMIC_RG_VBUF_BYP_SHIFT                   8
#define PMIC_RG_VBUF_CALEN_ADDR                  MT6355_AUXADC_CON17
#define PMIC_RG_VBUF_CALEN_MASK                  0x1
#define PMIC_RG_VBUF_CALEN_SHIFT                 9
#define PMIC_RG_VBUF_EXTEN_ADDR                  MT6355_AUXADC_CON17
#define PMIC_RG_VBUF_EXTEN_MASK                  0x1
#define PMIC_RG_VBUF_EXTEN_SHIFT                 10
#define PMIC_AUXADC_ADCIN_VSEN_EN_ADDR           MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_VSEN_EN_MASK           0x1
#define PMIC_AUXADC_ADCIN_VSEN_EN_SHIFT          0
#define PMIC_AUXADC_ADCIN_VBAT_EN_ADDR           MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_VBAT_EN_MASK           0x1
#define PMIC_AUXADC_ADCIN_VBAT_EN_SHIFT          1
#define PMIC_AUXADC_ADCIN_VSEN_MUX_EN_ADDR       MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_VSEN_MUX_EN_MASK       0x1
#define PMIC_AUXADC_ADCIN_VSEN_MUX_EN_SHIFT      2
#define PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_ADDR  MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_MASK  0x1
#define PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN_SHIFT 3
#define PMIC_AUXADC_ADCIN_CHR_EN_ADDR            MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_CHR_EN_MASK            0x1
#define PMIC_AUXADC_ADCIN_CHR_EN_SHIFT           4
#define PMIC_AUXADC_ADCIN_BATON_TDET_EN_ADDR     MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_BATON_TDET_EN_MASK     0x1
#define PMIC_AUXADC_ADCIN_BATON_TDET_EN_SHIFT    5
#define PMIC_AUXADC_ACCDET_ANASWCTRL_EN_ADDR     MT6355_AUXADC_CON18
#define PMIC_AUXADC_ACCDET_ANASWCTRL_EN_MASK     0x1
#define PMIC_AUXADC_ACCDET_ANASWCTRL_EN_SHIFT    6
#define PMIC_AUXADC_XO_THADC_EN_ADDR             MT6355_AUXADC_CON18
#define PMIC_AUXADC_XO_THADC_EN_MASK             0x1
#define PMIC_AUXADC_XO_THADC_EN_SHIFT            7
#define PMIC_AUXADC_ADCIN_BATID_SW_EN_ADDR       MT6355_AUXADC_CON18
#define PMIC_AUXADC_ADCIN_BATID_SW_EN_MASK       0x1
#define PMIC_AUXADC_ADCIN_BATID_SW_EN_SHIFT      8
#define PMIC_AUXADC_DIG0_RSV0_ADDR               MT6355_AUXADC_CON18
#define PMIC_AUXADC_DIG0_RSV0_MASK               0x3
#define PMIC_AUXADC_DIG0_RSV0_SHIFT              9
#define PMIC_AUXADC_CHSEL_ADDR                   MT6355_AUXADC_CON18
#define PMIC_AUXADC_CHSEL_MASK                   0xF
#define PMIC_AUXADC_CHSEL_SHIFT                  11
#define PMIC_AUXADC_SWCTRL_EN_ADDR               MT6355_AUXADC_CON18
#define PMIC_AUXADC_SWCTRL_EN_MASK               0x1
#define PMIC_AUXADC_SWCTRL_EN_SHIFT              15
#define PMIC_AUXADC_SOURCE_LBAT_SEL_ADDR         MT6355_AUXADC_CON19
#define PMIC_AUXADC_SOURCE_LBAT_SEL_MASK         0x1
#define PMIC_AUXADC_SOURCE_LBAT_SEL_SHIFT        0
#define PMIC_AUXADC_SOURCE_LBAT2_SEL_ADDR        MT6355_AUXADC_CON19
#define PMIC_AUXADC_SOURCE_LBAT2_SEL_MASK        0x1
#define PMIC_AUXADC_SOURCE_LBAT2_SEL_SHIFT       1
#define PMIC_AUXADC_START_EXTD_ADDR              MT6355_AUXADC_CON19
#define PMIC_AUXADC_START_EXTD_MASK              0x7F
#define PMIC_AUXADC_START_EXTD_SHIFT             2
#define PMIC_AUXADC_DAC_EXTD_ADDR                MT6355_AUXADC_CON19
#define PMIC_AUXADC_DAC_EXTD_MASK                0xF
#define PMIC_AUXADC_DAC_EXTD_SHIFT               11
#define PMIC_AUXADC_DAC_EXTD_EN_ADDR             MT6355_AUXADC_CON19
#define PMIC_AUXADC_DAC_EXTD_EN_MASK             0x1
#define PMIC_AUXADC_DAC_EXTD_EN_SHIFT            15
#define PMIC_AUXADC_PMU_THR_PDN_SW_ADDR          MT6355_AUXADC_CON20
#define PMIC_AUXADC_PMU_THR_PDN_SW_MASK          0x1
#define PMIC_AUXADC_PMU_THR_PDN_SW_SHIFT         10
#define PMIC_AUXADC_PMU_THR_PDN_SEL_ADDR         MT6355_AUXADC_CON20
#define PMIC_AUXADC_PMU_THR_PDN_SEL_MASK         0x1
#define PMIC_AUXADC_PMU_THR_PDN_SEL_SHIFT        11
#define PMIC_AUXADC_PMU_THR_PDN_STATUS_ADDR      MT6355_AUXADC_CON20
#define PMIC_AUXADC_PMU_THR_PDN_STATUS_MASK      0x1
#define PMIC_AUXADC_PMU_THR_PDN_STATUS_SHIFT     12
#define PMIC_AUXADC_DIG0_RSV1_ADDR               MT6355_AUXADC_CON20
#define PMIC_AUXADC_DIG0_RSV1_MASK               0x7
#define PMIC_AUXADC_DIG0_RSV1_SHIFT              13
#define PMIC_AUXADC_START_SHADE_NUM_ADDR         MT6355_AUXADC_CON21
#define PMIC_AUXADC_START_SHADE_NUM_MASK         0x3FF
#define PMIC_AUXADC_START_SHADE_NUM_SHIFT        0
#define PMIC_AUXADC_START_SHADE_EN_ADDR          MT6355_AUXADC_CON21
#define PMIC_AUXADC_START_SHADE_EN_MASK          0x1
#define PMIC_AUXADC_START_SHADE_EN_SHIFT         14
#define PMIC_AUXADC_START_SHADE_SEL_ADDR         MT6355_AUXADC_CON21
#define PMIC_AUXADC_START_SHADE_SEL_MASK         0x1
#define PMIC_AUXADC_START_SHADE_SEL_SHIFT        15
#define PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_ADDR      MT6355_AUXADC_CON22
#define PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_MASK      0x1
#define PMIC_AUXADC_ADC_RDY_WAKEUP_CLR_SHIFT     0
#define PMIC_AUXADC_ADC_RDY_FGADC_CLR_ADDR       MT6355_AUXADC_CON22
#define PMIC_AUXADC_ADC_RDY_FGADC_CLR_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_FGADC_CLR_SHIFT      1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_ADDR  MT6355_AUXADC_CON22
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_MASK  0x1
#define PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR_SHIFT 2
#define PMIC_AUXADC_ADC_RDY_PWRON_CLR_ADDR       MT6355_AUXADC_CON22
#define PMIC_AUXADC_ADC_RDY_PWRON_CLR_MASK       0x1
#define PMIC_AUXADC_ADC_RDY_PWRON_CLR_SHIFT      3
#define PMIC_AUXADC_DATA_REUSE_SEL_ADDR          MT6355_AUXADC_CON23
#define PMIC_AUXADC_DATA_REUSE_SEL_MASK          0x3
#define PMIC_AUXADC_DATA_REUSE_SEL_SHIFT         0
#define PMIC_AUXADC_CH0_DATA_REUSE_SEL_ADDR      MT6355_AUXADC_CON23
#define PMIC_AUXADC_CH0_DATA_REUSE_SEL_MASK      0x3
#define PMIC_AUXADC_CH0_DATA_REUSE_SEL_SHIFT     2
#define PMIC_AUXADC_CH1_DATA_REUSE_SEL_ADDR      MT6355_AUXADC_CON23
#define PMIC_AUXADC_CH1_DATA_REUSE_SEL_MASK      0x3
#define PMIC_AUXADC_CH1_DATA_REUSE_SEL_SHIFT     4
#define PMIC_AUXADC_DCXO_DATA_REUSE_SEL_ADDR     MT6355_AUXADC_CON23
#define PMIC_AUXADC_DCXO_DATA_REUSE_SEL_MASK     0x3
#define PMIC_AUXADC_DCXO_DATA_REUSE_SEL_SHIFT    6
#define PMIC_AUXADC_DATA_REUSE_EN_ADDR           MT6355_AUXADC_CON23
#define PMIC_AUXADC_DATA_REUSE_EN_MASK           0x1
#define PMIC_AUXADC_DATA_REUSE_EN_SHIFT          8
#define PMIC_AUXADC_CH0_DATA_REUSE_EN_ADDR       MT6355_AUXADC_CON23
#define PMIC_AUXADC_CH0_DATA_REUSE_EN_MASK       0x1
#define PMIC_AUXADC_CH0_DATA_REUSE_EN_SHIFT      9
#define PMIC_AUXADC_CH1_DATA_REUSE_EN_ADDR       MT6355_AUXADC_CON23
#define PMIC_AUXADC_CH1_DATA_REUSE_EN_MASK       0x1
#define PMIC_AUXADC_CH1_DATA_REUSE_EN_SHIFT      10
#define PMIC_AUXADC_DCXO_DATA_REUSE_EN_ADDR      MT6355_AUXADC_CON23
#define PMIC_AUXADC_DCXO_DATA_REUSE_EN_MASK      0x1
#define PMIC_AUXADC_DCXO_DATA_REUSE_EN_SHIFT     11
#define PMIC_AUXADC_AUTORPT_PRD_ADDR             MT6355_AUXADC_AUTORPT0
#define PMIC_AUXADC_AUTORPT_PRD_MASK             0x3FF
#define PMIC_AUXADC_AUTORPT_PRD_SHIFT            0
#define PMIC_AUXADC_AUTORPT_EN_ADDR              MT6355_AUXADC_AUTORPT0
#define PMIC_AUXADC_AUTORPT_EN_MASK              0x1
#define PMIC_AUXADC_AUTORPT_EN_SHIFT             15
#define PMIC_AUXADC_LBAT_DEBT_MAX_ADDR           MT6355_AUXADC_LBAT0
#define PMIC_AUXADC_LBAT_DEBT_MAX_MASK           0xFF
#define PMIC_AUXADC_LBAT_DEBT_MAX_SHIFT          0
#define PMIC_AUXADC_LBAT_DEBT_MIN_ADDR           MT6355_AUXADC_LBAT0
#define PMIC_AUXADC_LBAT_DEBT_MIN_MASK           0xFF
#define PMIC_AUXADC_LBAT_DEBT_MIN_SHIFT          8
#define PMIC_AUXADC_LBAT_DET_PRD_15_0_ADDR       MT6355_AUXADC_LBAT1
#define PMIC_AUXADC_LBAT_DET_PRD_15_0_MASK       0xFFFF
#define PMIC_AUXADC_LBAT_DET_PRD_15_0_SHIFT      0
#define PMIC_AUXADC_LBAT_DET_PRD_19_16_ADDR      MT6355_AUXADC_LBAT2
#define PMIC_AUXADC_LBAT_DET_PRD_19_16_MASK      0xF
#define PMIC_AUXADC_LBAT_DET_PRD_19_16_SHIFT     0
#define PMIC_AUXADC_LBAT_VOLT_MAX_ADDR           MT6355_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_VOLT_MAX_MASK           0xFFF
#define PMIC_AUXADC_LBAT_VOLT_MAX_SHIFT          0
#define PMIC_AUXADC_LBAT_IRQ_EN_MAX_ADDR         MT6355_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_IRQ_EN_MAX_MASK         0x1
#define PMIC_AUXADC_LBAT_IRQ_EN_MAX_SHIFT        12
#define PMIC_AUXADC_LBAT_EN_MAX_ADDR             MT6355_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_EN_MAX_MASK             0x1
#define PMIC_AUXADC_LBAT_EN_MAX_SHIFT            13
#define PMIC_AUXADC_LBAT_MAX_IRQ_B_ADDR          MT6355_AUXADC_LBAT3
#define PMIC_AUXADC_LBAT_MAX_IRQ_B_MASK          0x1
#define PMIC_AUXADC_LBAT_MAX_IRQ_B_SHIFT         15
#define PMIC_AUXADC_LBAT_VOLT_MIN_ADDR           MT6355_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_VOLT_MIN_MASK           0xFFF
#define PMIC_AUXADC_LBAT_VOLT_MIN_SHIFT          0
#define PMIC_AUXADC_LBAT_IRQ_EN_MIN_ADDR         MT6355_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_IRQ_EN_MIN_MASK         0x1
#define PMIC_AUXADC_LBAT_IRQ_EN_MIN_SHIFT        12
#define PMIC_AUXADC_LBAT_EN_MIN_ADDR             MT6355_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_EN_MIN_MASK             0x1
#define PMIC_AUXADC_LBAT_EN_MIN_SHIFT            13
#define PMIC_AUXADC_LBAT_MIN_IRQ_B_ADDR          MT6355_AUXADC_LBAT4
#define PMIC_AUXADC_LBAT_MIN_IRQ_B_MASK          0x1
#define PMIC_AUXADC_LBAT_MIN_IRQ_B_SHIFT         15
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_ADDR  MT6355_AUXADC_LBAT5
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_MASK  0x1FF
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_ADDR  MT6355_AUXADC_LBAT6
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_MASK  0x1FF
#define PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_AUXADC_ACCDET_AUTO_SPL_ADDR         MT6355_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_AUTO_SPL_MASK         0x1
#define PMIC_AUXADC_ACCDET_AUTO_SPL_SHIFT        0
#define PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_ADDR    MT6355_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_MASK    0x1
#define PMIC_AUXADC_ACCDET_AUTO_RQST_CLR_SHIFT   1
#define PMIC_AUXADC_ACCDET_DIG1_RSV0_ADDR        MT6355_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_DIG1_RSV0_MASK        0x3F
#define PMIC_AUXADC_ACCDET_DIG1_RSV0_SHIFT       2
#define PMIC_AUXADC_ACCDET_DIG0_RSV0_ADDR        MT6355_AUXADC_ACCDET
#define PMIC_AUXADC_ACCDET_DIG0_RSV0_MASK        0xFF
#define PMIC_AUXADC_ACCDET_DIG0_RSV0_SHIFT       8
#define PMIC_AUXADC_THR_DEBT_MAX_ADDR            MT6355_AUXADC_THR0
#define PMIC_AUXADC_THR_DEBT_MAX_MASK            0xFF
#define PMIC_AUXADC_THR_DEBT_MAX_SHIFT           0
#define PMIC_AUXADC_THR_DEBT_MIN_ADDR            MT6355_AUXADC_THR0
#define PMIC_AUXADC_THR_DEBT_MIN_MASK            0xFF
#define PMIC_AUXADC_THR_DEBT_MIN_SHIFT           8
#define PMIC_AUXADC_THR_DET_PRD_15_0_ADDR        MT6355_AUXADC_THR1
#define PMIC_AUXADC_THR_DET_PRD_15_0_MASK        0xFFFF
#define PMIC_AUXADC_THR_DET_PRD_15_0_SHIFT       0
#define PMIC_AUXADC_THR_DET_PRD_19_16_ADDR       MT6355_AUXADC_THR2
#define PMIC_AUXADC_THR_DET_PRD_19_16_MASK       0xF
#define PMIC_AUXADC_THR_DET_PRD_19_16_SHIFT      0
#define PMIC_AUXADC_THR_VOLT_MAX_ADDR            MT6355_AUXADC_THR3
#define PMIC_AUXADC_THR_VOLT_MAX_MASK            0xFFF
#define PMIC_AUXADC_THR_VOLT_MAX_SHIFT           0
#define PMIC_AUXADC_THR_IRQ_EN_MAX_ADDR          MT6355_AUXADC_THR3
#define PMIC_AUXADC_THR_IRQ_EN_MAX_MASK          0x1
#define PMIC_AUXADC_THR_IRQ_EN_MAX_SHIFT         12
#define PMIC_AUXADC_THR_EN_MAX_ADDR              MT6355_AUXADC_THR3
#define PMIC_AUXADC_THR_EN_MAX_MASK              0x1
#define PMIC_AUXADC_THR_EN_MAX_SHIFT             13
#define PMIC_AUXADC_THR_MAX_IRQ_B_ADDR           MT6355_AUXADC_THR3
#define PMIC_AUXADC_THR_MAX_IRQ_B_MASK           0x1
#define PMIC_AUXADC_THR_MAX_IRQ_B_SHIFT          15
#define PMIC_AUXADC_THR_VOLT_MIN_ADDR            MT6355_AUXADC_THR4
#define PMIC_AUXADC_THR_VOLT_MIN_MASK            0xFFF
#define PMIC_AUXADC_THR_VOLT_MIN_SHIFT           0
#define PMIC_AUXADC_THR_IRQ_EN_MIN_ADDR          MT6355_AUXADC_THR4
#define PMIC_AUXADC_THR_IRQ_EN_MIN_MASK          0x1
#define PMIC_AUXADC_THR_IRQ_EN_MIN_SHIFT         12
#define PMIC_AUXADC_THR_EN_MIN_ADDR              MT6355_AUXADC_THR4
#define PMIC_AUXADC_THR_EN_MIN_MASK              0x1
#define PMIC_AUXADC_THR_EN_MIN_SHIFT             13
#define PMIC_AUXADC_THR_MIN_IRQ_B_ADDR           MT6355_AUXADC_THR4
#define PMIC_AUXADC_THR_MIN_IRQ_B_MASK           0x1
#define PMIC_AUXADC_THR_MIN_IRQ_B_SHIFT          15
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_ADDR  MT6355_AUXADC_THR5
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_MASK  0x1FF
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_ADDR  MT6355_AUXADC_THR6
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_MASK  0x1FF
#define PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_EFUSE_GAIN_CH4_TRIM_ADDR            MT6355_AUXADC_EFUSE0
#define PMIC_EFUSE_GAIN_CH4_TRIM_MASK            0xFFF
#define PMIC_EFUSE_GAIN_CH4_TRIM_SHIFT           0
#define PMIC_EFUSE_OFFSET_CH4_TRIM_ADDR          MT6355_AUXADC_EFUSE1
#define PMIC_EFUSE_OFFSET_CH4_TRIM_MASK          0x7FF
#define PMIC_EFUSE_OFFSET_CH4_TRIM_SHIFT         0
#define PMIC_EFUSE_GAIN_CH0_TRIM_ADDR            MT6355_AUXADC_EFUSE2
#define PMIC_EFUSE_GAIN_CH0_TRIM_MASK            0xFFF
#define PMIC_EFUSE_GAIN_CH0_TRIM_SHIFT           0
#define PMIC_EFUSE_OFFSET_CH0_TRIM_ADDR          MT6355_AUXADC_EFUSE3
#define PMIC_EFUSE_OFFSET_CH0_TRIM_MASK          0x7FF
#define PMIC_EFUSE_OFFSET_CH0_TRIM_SHIFT         0
#define PMIC_EFUSE_GAIN_CH7_TRIM_ADDR            MT6355_AUXADC_EFUSE4
#define PMIC_EFUSE_GAIN_CH7_TRIM_MASK            0xFFF
#define PMIC_EFUSE_GAIN_CH7_TRIM_SHIFT           0
#define PMIC_EFUSE_OFFSET_CH7_TRIM_ADDR          MT6355_AUXADC_EFUSE5
#define PMIC_EFUSE_OFFSET_CH7_TRIM_MASK          0x7FF
#define PMIC_EFUSE_OFFSET_CH7_TRIM_SHIFT         0
#define PMIC_AUXADC_FGADC_START_SW_ADDR          MT6355_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_START_SW_MASK          0x1
#define PMIC_AUXADC_FGADC_START_SW_SHIFT         0
#define PMIC_AUXADC_FGADC_START_SEL_ADDR         MT6355_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_START_SEL_MASK         0x1
#define PMIC_AUXADC_FGADC_START_SEL_SHIFT        1
#define PMIC_AUXADC_FGADC_R_SW_ADDR              MT6355_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_R_SW_MASK              0x1
#define PMIC_AUXADC_FGADC_R_SW_SHIFT             2
#define PMIC_AUXADC_FGADC_R_SEL_ADDR             MT6355_AUXADC_DBG0
#define PMIC_AUXADC_FGADC_R_SEL_MASK             0x1
#define PMIC_AUXADC_FGADC_R_SEL_SHIFT            3
#define PMIC_AUXADC_BAT_PLUGIN_START_SW_ADDR     MT6355_AUXADC_DBG0
#define PMIC_AUXADC_BAT_PLUGIN_START_SW_MASK     0x1
#define PMIC_AUXADC_BAT_PLUGIN_START_SW_SHIFT    4
#define PMIC_AUXADC_BAT_PLUGIN_START_SEL_ADDR    MT6355_AUXADC_DBG0
#define PMIC_AUXADC_BAT_PLUGIN_START_SEL_MASK    0x1
#define PMIC_AUXADC_BAT_PLUGIN_START_SEL_SHIFT   5
#define PMIC_AUXADC_DBG_DIG0_RSV2_ADDR           MT6355_AUXADC_DBG0
#define PMIC_AUXADC_DBG_DIG0_RSV2_MASK           0xF
#define PMIC_AUXADC_DBG_DIG0_RSV2_SHIFT          6
#define PMIC_AUXADC_DBG_DIG1_RSV2_ADDR           MT6355_AUXADC_DBG0
#define PMIC_AUXADC_DBG_DIG1_RSV2_MASK           0x3F
#define PMIC_AUXADC_DBG_DIG1_RSV2_SHIFT          10
#define PMIC_AUXADC_IMPEDANCE_CNT_ADDR           MT6355_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_CNT_MASK           0x3F
#define PMIC_AUXADC_IMPEDANCE_CNT_SHIFT          0
#define PMIC_AUXADC_IMPEDANCE_CHSEL_ADDR         MT6355_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_CHSEL_MASK         0x1
#define PMIC_AUXADC_IMPEDANCE_CHSEL_SHIFT        6
#define PMIC_AUXADC_IMPEDANCE_IRQ_CLR_ADDR       MT6355_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_IRQ_CLR_MASK       0x1
#define PMIC_AUXADC_IMPEDANCE_IRQ_CLR_SHIFT      7
#define PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_ADDR    MT6355_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_MASK    0x1
#define PMIC_AUXADC_IMPEDANCE_IRQ_STATUS_SHIFT   8
#define PMIC_AUXADC_CLR_IMP_CNT_STOP_ADDR        MT6355_AUXADC_IMP0
#define PMIC_AUXADC_CLR_IMP_CNT_STOP_MASK        0x1
#define PMIC_AUXADC_CLR_IMP_CNT_STOP_SHIFT       14
#define PMIC_AUXADC_IMPEDANCE_MODE_ADDR          MT6355_AUXADC_IMP0
#define PMIC_AUXADC_IMPEDANCE_MODE_MASK          0x1
#define PMIC_AUXADC_IMPEDANCE_MODE_SHIFT         15
#define PMIC_AUXADC_IMP_AUTORPT_PRD_ADDR         MT6355_AUXADC_IMP1
#define PMIC_AUXADC_IMP_AUTORPT_PRD_MASK         0x3FF
#define PMIC_AUXADC_IMP_AUTORPT_PRD_SHIFT        0
#define PMIC_AUXADC_IMP_AUTORPT_EN_ADDR          MT6355_AUXADC_IMP1
#define PMIC_AUXADC_IMP_AUTORPT_EN_MASK          0x1
#define PMIC_AUXADC_IMP_AUTORPT_EN_SHIFT         15
#define PMIC_AUXADC_BAT_TEMP_FROZE_EN_ADDR       MT6355_AUXADC_BAT_TEMP_0
#define PMIC_AUXADC_BAT_TEMP_FROZE_EN_MASK       0x1
#define PMIC_AUXADC_BAT_TEMP_FROZE_EN_SHIFT      0
#define PMIC_AUXADC_BAT_TEMP_DEBT_MAX_ADDR       MT6355_AUXADC_BAT_TEMP_1
#define PMIC_AUXADC_BAT_TEMP_DEBT_MAX_MASK       0xFF
#define PMIC_AUXADC_BAT_TEMP_DEBT_MAX_SHIFT      0
#define PMIC_AUXADC_BAT_TEMP_DEBT_MIN_ADDR       MT6355_AUXADC_BAT_TEMP_1
#define PMIC_AUXADC_BAT_TEMP_DEBT_MIN_MASK       0xFF
#define PMIC_AUXADC_BAT_TEMP_DEBT_MIN_SHIFT      8
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_ADDR   MT6355_AUXADC_BAT_TEMP_2
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_MASK   0xFFFF
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0_SHIFT  0
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_ADDR  MT6355_AUXADC_BAT_TEMP_3
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_MASK  0xF
#define PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_VOLT_MAX_ADDR       MT6355_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_VOLT_MAX_MASK       0xFFF
#define PMIC_AUXADC_BAT_TEMP_VOLT_MAX_SHIFT      0
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_ADDR     MT6355_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_MASK     0x1
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX_SHIFT    12
#define PMIC_AUXADC_BAT_TEMP_EN_MAX_ADDR         MT6355_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_EN_MAX_MASK         0x1
#define PMIC_AUXADC_BAT_TEMP_EN_MAX_SHIFT        13
#define PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_ADDR      MT6355_AUXADC_BAT_TEMP_4
#define PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_MASK      0x1
#define PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B_SHIFT     15
#define PMIC_AUXADC_BAT_TEMP_VOLT_MIN_ADDR       MT6355_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_VOLT_MIN_MASK       0xFFF
#define PMIC_AUXADC_BAT_TEMP_VOLT_MIN_SHIFT      0
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_ADDR     MT6355_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_MASK     0x1
#define PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN_SHIFT    12
#define PMIC_AUXADC_BAT_TEMP_EN_MIN_ADDR         MT6355_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_EN_MIN_MASK         0x1
#define PMIC_AUXADC_BAT_TEMP_EN_MIN_SHIFT        13
#define PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_ADDR      MT6355_AUXADC_BAT_TEMP_5
#define PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_MASK      0x1
#define PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B_SHIFT     15
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_ADDR  MT6355_AUXADC_BAT_TEMP_6
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_MASK  0x1FF
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX_SHIFT 0
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_ADDR  MT6355_AUXADC_BAT_TEMP_7
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_MASK  0x1FF
#define PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN_SHIFT 0
#define PMIC_AUXADC_LBAT2_DEBT_MAX_ADDR          MT6355_AUXADC_LBAT2_1
#define PMIC_AUXADC_LBAT2_DEBT_MAX_MASK          0xFF
#define PMIC_AUXADC_LBAT2_DEBT_MAX_SHIFT         0
#define PMIC_AUXADC_LBAT2_DEBT_MIN_ADDR          MT6355_AUXADC_LBAT2_1
#define PMIC_AUXADC_LBAT2_DEBT_MIN_MASK          0xFF
#define PMIC_AUXADC_LBAT2_DEBT_MIN_SHIFT         8
#define PMIC_AUXADC_LBAT2_DET_PRD_15_0_ADDR      MT6355_AUXADC_LBAT2_2
#define PMIC_AUXADC_LBAT2_DET_PRD_15_0_MASK      0xFFFF
#define PMIC_AUXADC_LBAT2_DET_PRD_15_0_SHIFT     0
#define PMIC_AUXADC_LBAT2_DET_PRD_19_16_ADDR     MT6355_AUXADC_LBAT2_3
#define PMIC_AUXADC_LBAT2_DET_PRD_19_16_MASK     0xF
#define PMIC_AUXADC_LBAT2_DET_PRD_19_16_SHIFT    0
#define PMIC_AUXADC_LBAT2_VOLT_MAX_ADDR          MT6355_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_VOLT_MAX_MASK          0xFFF
#define PMIC_AUXADC_LBAT2_VOLT_MAX_SHIFT         0
#define PMIC_AUXADC_LBAT2_IRQ_EN_MAX_ADDR        MT6355_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_IRQ_EN_MAX_MASK        0x1
#define PMIC_AUXADC_LBAT2_IRQ_EN_MAX_SHIFT       12
#define PMIC_AUXADC_LBAT2_EN_MAX_ADDR            MT6355_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_EN_MAX_MASK            0x1
#define PMIC_AUXADC_LBAT2_EN_MAX_SHIFT           13
#define PMIC_AUXADC_LBAT2_MAX_IRQ_B_ADDR         MT6355_AUXADC_LBAT2_4
#define PMIC_AUXADC_LBAT2_MAX_IRQ_B_MASK         0x1
#define PMIC_AUXADC_LBAT2_MAX_IRQ_B_SHIFT        15
#define PMIC_AUXADC_LBAT2_VOLT_MIN_ADDR          MT6355_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_VOLT_MIN_MASK          0xFFF
#define PMIC_AUXADC_LBAT2_VOLT_MIN_SHIFT         0
#define PMIC_AUXADC_LBAT2_IRQ_EN_MIN_ADDR        MT6355_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_IRQ_EN_MIN_MASK        0x1
#define PMIC_AUXADC_LBAT2_IRQ_EN_MIN_SHIFT       12
#define PMIC_AUXADC_LBAT2_EN_MIN_ADDR            MT6355_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_EN_MIN_MASK            0x1
#define PMIC_AUXADC_LBAT2_EN_MIN_SHIFT           13
#define PMIC_AUXADC_LBAT2_MIN_IRQ_B_ADDR         MT6355_AUXADC_LBAT2_5
#define PMIC_AUXADC_LBAT2_MIN_IRQ_B_MASK         0x1
#define PMIC_AUXADC_LBAT2_MIN_IRQ_B_SHIFT        15
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_ADDR        MT6355_AUXADC_LBAT2_6
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_MASK        0x1FF
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX_SHIFT       0
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_ADDR        MT6355_AUXADC_LBAT2_7
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_MASK        0x1FF
#define PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN_SHIFT       0
#define PMIC_AUXADC_MDBG_DET_PRD_ADDR            MT6355_AUXADC_MDBG_0
#define PMIC_AUXADC_MDBG_DET_PRD_MASK            0x3FF
#define PMIC_AUXADC_MDBG_DET_PRD_SHIFT           0
#define PMIC_AUXADC_MDBG_DET_EN_ADDR             MT6355_AUXADC_MDBG_0
#define PMIC_AUXADC_MDBG_DET_EN_MASK             0x1
#define PMIC_AUXADC_MDBG_DET_EN_SHIFT            15
#define PMIC_AUXADC_MDBG_R_PTR_ADDR              MT6355_AUXADC_MDBG_1
#define PMIC_AUXADC_MDBG_R_PTR_MASK              0x3F
#define PMIC_AUXADC_MDBG_R_PTR_SHIFT             0
#define PMIC_AUXADC_MDBG_W_PTR_ADDR              MT6355_AUXADC_MDBG_1
#define PMIC_AUXADC_MDBG_W_PTR_MASK              0x3F
#define PMIC_AUXADC_MDBG_W_PTR_SHIFT             8
#define PMIC_AUXADC_MDBG_BUF_LENGTH_ADDR         MT6355_AUXADC_MDBG_2
#define PMIC_AUXADC_MDBG_BUF_LENGTH_MASK         0x3F
#define PMIC_AUXADC_MDBG_BUF_LENGTH_SHIFT        0
#define PMIC_AUXADC_MDRT_DET_PRD_ADDR            MT6355_AUXADC_MDRT_0
#define PMIC_AUXADC_MDRT_DET_PRD_MASK            0x3FF
#define PMIC_AUXADC_MDRT_DET_PRD_SHIFT           0
#define PMIC_AUXADC_MDRT_DET_EN_ADDR             MT6355_AUXADC_MDRT_0
#define PMIC_AUXADC_MDRT_DET_EN_MASK             0x1
#define PMIC_AUXADC_MDRT_DET_EN_SHIFT            15
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_ADDR  MT6355_AUXADC_MDRT_1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_MASK  0xFFF
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_SHIFT 0
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_ADDR  MT6355_AUXADC_MDRT_1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_MASK  0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_CLR_SHIFT 15
#define PMIC_AUXADC_MDRT_DET_WKUP_START_ADDR      MT6355_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_WKUP_START_MASK      0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SHIFT     0
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_ADDR  MT6355_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_MASK  0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_START_SEL_SHIFT 1
#define PMIC_AUXADC_MDRT_DET_WKUP_EN_ADDR        MT6355_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_WKUP_EN_MASK        0x1
#define PMIC_AUXADC_MDRT_DET_WKUP_EN_SHIFT       2
#define PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_ADDR    MT6355_AUXADC_MDRT_2
#define PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_MASK    0x1
#define PMIC_AUXADC_MDRT_DET_SRCLKEN_IND_SHIFT   3
#define PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_ADDR     MT6355_AUXADC_MDRT_3
#define PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_MASK     0x3FF
#define PMIC_AUXADC_MDRT_DET_RDY_ST_PRD_SHIFT    0
#define PMIC_AUXADC_MDRT_DET_RDY_ST_EN_ADDR      MT6355_AUXADC_MDRT_3
#define PMIC_AUXADC_MDRT_DET_RDY_ST_EN_MASK      0x1
#define PMIC_AUXADC_MDRT_DET_RDY_ST_EN_SHIFT     15
#define PMIC_AUXADC_MDRT_DET_START_SEL_ADDR      MT6355_AUXADC_MDRT_4
#define PMIC_AUXADC_MDRT_DET_START_SEL_MASK      0x1
#define PMIC_AUXADC_MDRT_DET_START_SEL_SHIFT     0
#define PMIC_AUXADC_JEITA_IRQ_EN_ADDR            MT6355_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_IRQ_EN_MASK            0x1
#define PMIC_AUXADC_JEITA_IRQ_EN_SHIFT           0
#define PMIC_AUXADC_JEITA_EN_ADDR                MT6355_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_EN_MASK                0x1
#define PMIC_AUXADC_JEITA_EN_SHIFT               1
#define PMIC_AUXADC_JEITA_DET_PRD_ADDR           MT6355_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_DET_PRD_MASK           0xF
#define PMIC_AUXADC_JEITA_DET_PRD_SHIFT          2
#define PMIC_AUXADC_JEITA_DEBT_ADDR              MT6355_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_DEBT_MASK              0xF
#define PMIC_AUXADC_JEITA_DEBT_SHIFT             6
#define PMIC_AUXADC_JEITA_MIPI_DIS_ADDR          MT6355_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_MIPI_DIS_MASK          0x1
#define PMIC_AUXADC_JEITA_MIPI_DIS_SHIFT         10
#define PMIC_AUXADC_JEITA_FROZE_EN_ADDR          MT6355_AUXADC_JEITA_0
#define PMIC_AUXADC_JEITA_FROZE_EN_MASK          0x1
#define PMIC_AUXADC_JEITA_FROZE_EN_SHIFT         11
#define PMIC_AUXADC_JEITA_VOLT_HOT_ADDR          MT6355_AUXADC_JEITA_1
#define PMIC_AUXADC_JEITA_VOLT_HOT_MASK          0xFFF
#define PMIC_AUXADC_JEITA_VOLT_HOT_SHIFT         0
#define PMIC_AUXADC_JEITA_HOT_IRQ_ADDR           MT6355_AUXADC_JEITA_1
#define PMIC_AUXADC_JEITA_HOT_IRQ_MASK           0x1
#define PMIC_AUXADC_JEITA_HOT_IRQ_SHIFT          15
#define PMIC_AUXADC_JEITA_VOLT_WARM_ADDR         MT6355_AUXADC_JEITA_2
#define PMIC_AUXADC_JEITA_VOLT_WARM_MASK         0xFFF
#define PMIC_AUXADC_JEITA_VOLT_WARM_SHIFT        0
#define PMIC_AUXADC_JEITA_WARM_IRQ_ADDR          MT6355_AUXADC_JEITA_2
#define PMIC_AUXADC_JEITA_WARM_IRQ_MASK          0x1
#define PMIC_AUXADC_JEITA_WARM_IRQ_SHIFT         15
#define PMIC_AUXADC_JEITA_VOLT_COOL_ADDR         MT6355_AUXADC_JEITA_3
#define PMIC_AUXADC_JEITA_VOLT_COOL_MASK         0xFFF
#define PMIC_AUXADC_JEITA_VOLT_COOL_SHIFT        0
#define PMIC_AUXADC_JEITA_COOL_IRQ_ADDR          MT6355_AUXADC_JEITA_3
#define PMIC_AUXADC_JEITA_COOL_IRQ_MASK          0x1
#define PMIC_AUXADC_JEITA_COOL_IRQ_SHIFT         15
#define PMIC_AUXADC_JEITA_VOLT_COLD_ADDR         MT6355_AUXADC_JEITA_4
#define PMIC_AUXADC_JEITA_VOLT_COLD_MASK         0xFFF
#define PMIC_AUXADC_JEITA_VOLT_COLD_SHIFT        0
#define PMIC_AUXADC_JEITA_COLD_IRQ_ADDR          MT6355_AUXADC_JEITA_4
#define PMIC_AUXADC_JEITA_COLD_IRQ_MASK          0x1
#define PMIC_AUXADC_JEITA_COLD_IRQ_SHIFT         15
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_ADDR       MT6355_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_MASK       0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD_SHIFT      0
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_ADDR       MT6355_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_MASK       0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL_SHIFT      4
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_ADDR       MT6355_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_MASK       0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM_SHIFT      8
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_ADDR        MT6355_AUXADC_JEITA_5
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_MASK        0xF
#define PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT_SHIFT       12
#define PMIC_AUXADC_DCXO_MDRT_DET_PRD_ADDR       MT6355_AUXADC_DCXO_MDRT_0
#define PMIC_AUXADC_DCXO_MDRT_DET_PRD_MASK       0x3FF
#define PMIC_AUXADC_DCXO_MDRT_DET_PRD_SHIFT      0
#define PMIC_AUXADC_DCXO_MDRT_DET_EN_ADDR        MT6355_AUXADC_DCXO_MDRT_0
#define PMIC_AUXADC_DCXO_MDRT_DET_EN_MASK        0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_EN_SHIFT       15
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_ADDR MT6355_AUXADC_DCXO_MDRT_1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_MASK 0xFFF
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_SHIFT   0
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_ADDR MT6355_AUXADC_DCXO_MDRT_1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR_SHIFT   15
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_ADDR   MT6355_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_MASK   0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN_SHIFT  0
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_ADDR MT6355_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_MASK 0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL_SHIFT   1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_ADDR     MT6355_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_MASK     0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SHIFT    2
#define PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_ADDR    MT6355_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_MASK    0x1
#define PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND_SHIFT   3
#define PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_ADDR     MT6355_AUXADC_DCXO_MDRT_2
#define PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_MASK     0x1
#define PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL_SHIFT    4
#define PMIC_AUXADC_NAG_EN_ADDR                  MT6355_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_EN_MASK                  0x1
#define PMIC_AUXADC_NAG_EN_SHIFT                 0
#define PMIC_AUXADC_NAG_CLR_ADDR                 MT6355_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_CLR_MASK                 0x1
#define PMIC_AUXADC_NAG_CLR_SHIFT                1
#define PMIC_AUXADC_NAG_VBAT1_SEL_ADDR           MT6355_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_VBAT1_SEL_MASK           0x1
#define PMIC_AUXADC_NAG_VBAT1_SEL_SHIFT          2
#define PMIC_AUXADC_NAG_PRD_ADDR                 MT6355_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_PRD_MASK                 0x7F
#define PMIC_AUXADC_NAG_PRD_SHIFT                3
#define PMIC_AUXADC_NAG_IRQ_EN_ADDR              MT6355_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_IRQ_EN_MASK              0x1
#define PMIC_AUXADC_NAG_IRQ_EN_SHIFT             10
#define PMIC_AUXADC_NAG_C_DLTV_IRQ_ADDR          MT6355_AUXADC_NAG_0
#define PMIC_AUXADC_NAG_C_DLTV_IRQ_MASK          0x1
#define PMIC_AUXADC_NAG_C_DLTV_IRQ_SHIFT         15
#define PMIC_AUXADC_NAG_ZCV_ADDR                 MT6355_AUXADC_NAG_1
#define PMIC_AUXADC_NAG_ZCV_MASK                 0x7FFF
#define PMIC_AUXADC_NAG_ZCV_SHIFT                0
#define PMIC_AUXADC_NAG_C_DLTV_TH_15_0_ADDR      MT6355_AUXADC_NAG_2
#define PMIC_AUXADC_NAG_C_DLTV_TH_15_0_MASK      0xFFFF
#define PMIC_AUXADC_NAG_C_DLTV_TH_15_0_SHIFT     0
#define PMIC_AUXADC_NAG_C_DLTV_TH_26_16_ADDR     MT6355_AUXADC_NAG_3
#define PMIC_AUXADC_NAG_C_DLTV_TH_26_16_MASK     0x7FF
#define PMIC_AUXADC_NAG_C_DLTV_TH_26_16_SHIFT    0
#define PMIC_AUXADC_NAG_CNT_15_0_ADDR            MT6355_AUXADC_NAG_4
#define PMIC_AUXADC_NAG_CNT_15_0_MASK            0xFFFF
#define PMIC_AUXADC_NAG_CNT_15_0_SHIFT           0
#define PMIC_AUXADC_NAG_CNT_25_16_ADDR           MT6355_AUXADC_NAG_5
#define PMIC_AUXADC_NAG_CNT_25_16_MASK           0x3FF
#define PMIC_AUXADC_NAG_CNT_25_16_SHIFT          0
#define PMIC_AUXADC_NAG_DLTV_ADDR                MT6355_AUXADC_NAG_6
#define PMIC_AUXADC_NAG_DLTV_MASK                0xFFFF
#define PMIC_AUXADC_NAG_DLTV_SHIFT               0
#define PMIC_AUXADC_NAG_C_DLTV_15_0_ADDR         MT6355_AUXADC_NAG_7
#define PMIC_AUXADC_NAG_C_DLTV_15_0_MASK         0xFFFF
#define PMIC_AUXADC_NAG_C_DLTV_15_0_SHIFT        0
#define PMIC_AUXADC_NAG_C_DLTV_26_16_ADDR        MT6355_AUXADC_NAG_8
#define PMIC_AUXADC_NAG_C_DLTV_26_16_MASK        0x7FF
#define PMIC_AUXADC_NAG_C_DLTV_26_16_SHIFT       0
#define PMIC_AUXADC_EFUSE_DEGC_CALI_ADDR         MT6355_AUXADC_EFUSE_1
#define PMIC_AUXADC_EFUSE_DEGC_CALI_MASK         0x3F
#define PMIC_AUXADC_EFUSE_DEGC_CALI_SHIFT        0
#define PMIC_AUXADC_EFUSE_ADC_CALI_EN_ADDR       MT6355_AUXADC_EFUSE_1
#define PMIC_AUXADC_EFUSE_ADC_CALI_EN_MASK       0x1
#define PMIC_AUXADC_EFUSE_ADC_CALI_EN_SHIFT      8
#define PMIC_AUXADC_EFUSE_1RSV0_ADDR             MT6355_AUXADC_EFUSE_1
#define PMIC_AUXADC_EFUSE_1RSV0_MASK             0x7F
#define PMIC_AUXADC_EFUSE_1RSV0_SHIFT            9
#define PMIC_AUXADC_EFUSE_O_VTS_ADDR             MT6355_AUXADC_EFUSE_2
#define PMIC_AUXADC_EFUSE_O_VTS_MASK             0x1FFF
#define PMIC_AUXADC_EFUSE_O_VTS_SHIFT            0
#define PMIC_AUXADC_EFUSE_2RSV0_ADDR             MT6355_AUXADC_EFUSE_2
#define PMIC_AUXADC_EFUSE_2RSV0_MASK             0x7
#define PMIC_AUXADC_EFUSE_2RSV0_SHIFT            13
#define PMIC_AUXADC_EFUSE_O_SLOPE_ADDR           MT6355_AUXADC_EFUSE_3
#define PMIC_AUXADC_EFUSE_O_SLOPE_MASK           0x3F
#define PMIC_AUXADC_EFUSE_O_SLOPE_SHIFT          0
#define PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_ADDR      MT6355_AUXADC_EFUSE_3
#define PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_MASK      0x1
#define PMIC_AUXADC_EFUSE_O_SLOPE_SIGN_SHIFT     8
#define PMIC_AUXADC_EFUSE_3RSV0_ADDR             MT6355_AUXADC_EFUSE_3
#define PMIC_AUXADC_EFUSE_3RSV0_MASK             0x7F
#define PMIC_AUXADC_EFUSE_3RSV0_SHIFT            9
#define PMIC_AUXADC_EFUSE_AUXADC_RSV_ADDR        MT6355_AUXADC_EFUSE_4
#define PMIC_AUXADC_EFUSE_AUXADC_RSV_MASK        0xF
#define PMIC_AUXADC_EFUSE_AUXADC_RSV_SHIFT       0
#define PMIC_AUXADC_EFUSE_ID_ADDR                MT6355_AUXADC_EFUSE_4
#define PMIC_AUXADC_EFUSE_ID_MASK                0x1
#define PMIC_AUXADC_EFUSE_ID_SHIFT               4
#define PMIC_AUXADC_EFUSE_4RSV0_ADDR             MT6355_AUXADC_EFUSE_4
#define PMIC_AUXADC_EFUSE_4RSV0_MASK             0x7FF
#define PMIC_AUXADC_EFUSE_4RSV0_SHIFT            5
#define PMIC_AUXADC_RSV_1RSV0_ADDR               MT6355_AUXADC_RSV_1
#define PMIC_AUXADC_RSV_1RSV0_MASK               0xFFFF
#define PMIC_AUXADC_RSV_1RSV0_SHIFT              0
#define PMIC_DA_ADCIN_VBAT_EN_ADDR               MT6355_AUXADC_ANA_0
#define PMIC_DA_ADCIN_VBAT_EN_MASK               0x1
#define PMIC_DA_ADCIN_VBAT_EN_SHIFT              0
#define PMIC_DA_AUXADC_VBAT_EN_ADDR              MT6355_AUXADC_ANA_0
#define PMIC_DA_AUXADC_VBAT_EN_MASK              0x1
#define PMIC_DA_AUXADC_VBAT_EN_SHIFT             1
#define PMIC_DA_ADCIN_VSEN_MUX_EN_ADDR           MT6355_AUXADC_ANA_0
#define PMIC_DA_ADCIN_VSEN_MUX_EN_MASK           0x1
#define PMIC_DA_ADCIN_VSEN_MUX_EN_SHIFT          2
#define PMIC_DA_ADCIN_VSEN_EN_ADDR               MT6355_AUXADC_ANA_0
#define PMIC_DA_ADCIN_VSEN_EN_MASK               0x1
#define PMIC_DA_ADCIN_VSEN_EN_SHIFT              3
#define PMIC_DA_ADCIN_CHR_EN_ADDR                MT6355_AUXADC_ANA_0
#define PMIC_DA_ADCIN_CHR_EN_MASK                0x1
#define PMIC_DA_ADCIN_CHR_EN_SHIFT               4
#define PMIC_DA_BATON_TDET_EN_ADDR               MT6355_AUXADC_ANA_0
#define PMIC_DA_BATON_TDET_EN_MASK               0x1
#define PMIC_DA_BATON_TDET_EN_SHIFT              5
#define PMIC_DA_ADCIN_BATID_SW_EN_ADDR           MT6355_AUXADC_ANA_0
#define PMIC_DA_ADCIN_BATID_SW_EN_MASK           0x1
#define PMIC_DA_ADCIN_BATID_SW_EN_SHIFT          6
#define PMIC_RG_AUXADC_IMP_CK_SW_MODE_ADDR       MT6355_AUXADC_IMP_CG0
#define PMIC_RG_AUXADC_IMP_CK_SW_MODE_MASK       0x1
#define PMIC_RG_AUXADC_IMP_CK_SW_MODE_SHIFT      0
#define PMIC_RG_AUXADC_IMP_CK_SW_EN_ADDR         MT6355_AUXADC_IMP_CG0
#define PMIC_RG_AUXADC_IMP_CK_SW_EN_MASK         0x1
#define PMIC_RG_AUXADC_IMP_CK_SW_EN_SHIFT        1
#define PMIC_RG_AUXADC_LBAT_CK_SW_MODE_ADDR      MT6355_AUXADC_LBAT_CG0
#define PMIC_RG_AUXADC_LBAT_CK_SW_MODE_MASK      0x1
#define PMIC_RG_AUXADC_LBAT_CK_SW_MODE_SHIFT     0
#define PMIC_RG_AUXADC_LBAT_CK_SW_EN_ADDR        MT6355_AUXADC_LBAT_CG0
#define PMIC_RG_AUXADC_LBAT_CK_SW_EN_MASK        0x1
#define PMIC_RG_AUXADC_LBAT_CK_SW_EN_SHIFT       1
#define PMIC_RG_AUXADC_THR_CK_SW_MODE_ADDR       MT6355_AUXADC_THR_CG0
#define PMIC_RG_AUXADC_THR_CK_SW_MODE_MASK       0x1
#define PMIC_RG_AUXADC_THR_CK_SW_MODE_SHIFT      0
#define PMIC_RG_AUXADC_THR_CK_SW_EN_ADDR         MT6355_AUXADC_THR_CG0
#define PMIC_RG_AUXADC_THR_CK_SW_EN_MASK         0x1
#define PMIC_RG_AUXADC_THR_CK_SW_EN_SHIFT        1
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_ADDR  MT6355_AUXADC_BAT_TEMP_CG0
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_MASK  0x1
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE_SHIFT 0
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_ADDR    MT6355_AUXADC_BAT_TEMP_CG0
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_MASK    0x1
#define PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN_SHIFT   1
#define PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_ADDR     MT6355_AUXADC_LBAT2_CG0
#define PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_MASK     0x1
#define PMIC_RG_AUXADC_LBAT2_CK_SW_MODE_SHIFT    0
#define PMIC_RG_AUXADC_LBAT2_CK_SW_EN_ADDR       MT6355_AUXADC_LBAT2_CG0
#define PMIC_RG_AUXADC_LBAT2_CK_SW_EN_MASK       0x1
#define PMIC_RG_AUXADC_LBAT2_CK_SW_EN_SHIFT      1
#define PMIC_RG_AUXADC_JEITA_CK_SW_MODE_ADDR     MT6355_AUXADC_JEITA_CG0
#define PMIC_RG_AUXADC_JEITA_CK_SW_MODE_MASK     0x1
#define PMIC_RG_AUXADC_JEITA_CK_SW_MODE_SHIFT    0
#define PMIC_RG_AUXADC_JEITA_CK_SW_EN_ADDR       MT6355_AUXADC_JEITA_CG0
#define PMIC_RG_AUXADC_JEITA_CK_SW_EN_MASK       0x1
#define PMIC_RG_AUXADC_JEITA_CK_SW_EN_SHIFT      1
#define PMIC_RG_AUXADC_NAG_CK_SW_MODE_ADDR       MT6355_AUXADC_NAG_CG0
#define PMIC_RG_AUXADC_NAG_CK_SW_MODE_MASK       0x1
#define PMIC_RG_AUXADC_NAG_CK_SW_MODE_SHIFT      0
#define PMIC_RG_AUXADC_NAG_CK_SW_EN_ADDR         MT6355_AUXADC_NAG_CG0
#define PMIC_RG_AUXADC_NAG_CK_SW_EN_MASK         0x1
#define PMIC_RG_AUXADC_NAG_CK_SW_EN_SHIFT        1
#define PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_ADDR        MT6355_AUXADC_PRI_NEW
#define PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_MASK        0x1
#define PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL_SHIFT       0


enum PMU_FLAGS_LIST {
	PMIC_DEW_READ_TEST,
	PMIC_RG_STRUP_AUXADC_START_SW,
	PMIC_RG_STRUP_AUXADC_RSTB_SW,
	PMIC_RG_STRUP_AUXADC_START_SEL,
	PMIC_RG_STRUP_AUXADC_RSTB_SEL,
	PMIC_RG_STRUP_AUXADC_RPCNT_MAX,
	PMIC_RG_LDO_VBIF28_EN,
	PMIC_RG_LDO_VBIF28_SW_OP_EN,
	PMIC_DA_QI_VBIF28_EN,
	PMIC_RG_ADCIN_VSEN_MUX_EN,
	PMIC_BATON_TDET_EN,
	PMIC_AUXADC_ADC_OUT_CH0,
	PMIC_AUXADC_ADC_RDY_CH0,
	PMIC_AUXADC_ADC_OUT_CH1,
	PMIC_AUXADC_ADC_RDY_CH1,
	PMIC_AUXADC_ADC_OUT_CH2,
	PMIC_AUXADC_ADC_RDY_CH2,
	PMIC_AUXADC_ADC_OUT_CH3,
	PMIC_AUXADC_ADC_RDY_CH3,
	PMIC_AUXADC_ADC_OUT_CH4,
	PMIC_AUXADC_ADC_RDY_CH4,
	PMIC_AUXADC_ADC_OUT_CH5,
	PMIC_AUXADC_ADC_RDY_CH5,
	PMIC_AUXADC_ADC_OUT_CH6,
	PMIC_AUXADC_ADC_RDY_CH6,
	PMIC_AUXADC_ADC_OUT_CH7,
	PMIC_AUXADC_ADC_RDY_CH7,
	PMIC_AUXADC_ADC_OUT_CH8,
	PMIC_AUXADC_ADC_RDY_CH8,
	PMIC_AUXADC_ADC_OUT_CH9,
	PMIC_AUXADC_ADC_RDY_CH9,
	PMIC_AUXADC_ADC_OUT_CH10,
	PMIC_AUXADC_ADC_RDY_CH10,
	PMIC_AUXADC_ADC_OUT_CH11,
	PMIC_AUXADC_ADC_RDY_CH11,
	PMIC_AUXADC_ADC_OUT_CH12_15,
	PMIC_AUXADC_ADC_RDY_CH12_15,
	PMIC_AUXADC_ADC_OUT_THR_HW,
	PMIC_AUXADC_ADC_RDY_THR_HW,
	PMIC_AUXADC_ADC_OUT_LBAT,
	PMIC_AUXADC_ADC_RDY_LBAT,
	PMIC_AUXADC_ADC_OUT_LBAT2,
	PMIC_AUXADC_ADC_RDY_LBAT2,
	PMIC_AUXADC_ADC_OUT_CH7_BY_GPS,
	PMIC_AUXADC_ADC_RDY_CH7_BY_GPS,
	PMIC_AUXADC_ADC_OUT_CH7_BY_MD,
	PMIC_AUXADC_ADC_RDY_CH7_BY_MD,
	PMIC_AUXADC_ADC_OUT_CH7_BY_AP,
	PMIC_AUXADC_ADC_RDY_CH7_BY_AP,
	PMIC_AUXADC_ADC_OUT_CH4_BY_MD,
	PMIC_AUXADC_ADC_RDY_CH4_BY_MD,
	PMIC_AUXADC_ADC_OUT_PWRON_PCHR,
	PMIC_AUXADC_ADC_RDY_PWRON_PCHR,
	PMIC_AUXADC_ADC_OUT_PWRON_SWCHR,
	PMIC_AUXADC_ADC_RDY_PWRON_SWCHR,
	PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR,
	PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR,
	PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR,
	PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR,
	PMIC_AUXADC_ADC_OUT_CH0_BY_MD,
	PMIC_AUXADC_ADC_RDY_CH0_BY_MD,
	PMIC_AUXADC_ADC_OUT_CH0_BY_AP,
	PMIC_AUXADC_ADC_RDY_CH0_BY_AP,
	PMIC_AUXADC_ADC_OUT_CH1_BY_MD,
	PMIC_AUXADC_ADC_RDY_CH1_BY_MD,
	PMIC_AUXADC_ADC_OUT_CH1_BY_AP,
	PMIC_AUXADC_ADC_RDY_CH1_BY_AP,
	PMIC_AUXADC_ADC_OUT_BAT_TEMP,
	PMIC_AUXADC_ADC_RDY_BAT_TEMP,
	PMIC_AUXADC_ADC_OUT_FGADC_PCHR,
	PMIC_AUXADC_ADC_RDY_FGADC_PCHR,
	PMIC_AUXADC_ADC_OUT_FGADC_SWCHR,
	PMIC_AUXADC_ADC_RDY_FGADC_SWCHR,
	PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR,
	PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR,
	PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR,
	PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR,
	PMIC_AUXADC_ADC_OUT_IMP,
	PMIC_AUXADC_ADC_RDY_IMP,
	PMIC_AUXADC_ADC_OUT_IMP_AVG,
	PMIC_AUXADC_ADC_RDY_IMP_AVG,
	PMIC_AUXADC_ADC_OUT_RAW,
	PMIC_AUXADC_ADC_OUT_MDRT,
	PMIC_AUXADC_ADC_RDY_MDRT,
	PMIC_AUXADC_ADC_OUT_MDBG,
	PMIC_AUXADC_ADC_RDY_MDBG,
	PMIC_AUXADC_ADC_OUT_JEITA,
	PMIC_AUXADC_ADC_RDY_JEITA,
	PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS,
	PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS,
	PMIC_AUXADC_ADC_OUT_DCXO_BY_MD,
	PMIC_AUXADC_ADC_RDY_DCXO_BY_MD,
	PMIC_AUXADC_ADC_OUT_DCXO_BY_AP,
	PMIC_AUXADC_ADC_RDY_DCXO_BY_AP,
	PMIC_AUXADC_ADC_OUT_DCXO_MDRT,
	PMIC_AUXADC_ADC_RDY_DCXO_MDRT,
	PMIC_AUXADC_ADC_OUT_NAG,
	PMIC_AUXADC_ADC_RDY_NAG,
	PMIC_AUXADC_ADC_OUT_BATID,
	PMIC_AUXADC_ADC_RDY_BATID,
	PMIC_AUXADC_BUF_OUT_00,
	PMIC_AUXADC_BUF_RDY_00,
	PMIC_AUXADC_BUF_OUT_01,
	PMIC_AUXADC_BUF_RDY_01,
	PMIC_AUXADC_BUF_OUT_02,
	PMIC_AUXADC_BUF_RDY_02,
	PMIC_AUXADC_BUF_OUT_03,
	PMIC_AUXADC_BUF_RDY_03,
	PMIC_AUXADC_BUF_OUT_04,
	PMIC_AUXADC_BUF_RDY_04,
	PMIC_AUXADC_BUF_OUT_05,
	PMIC_AUXADC_BUF_RDY_05,
	PMIC_AUXADC_BUF_OUT_06,
	PMIC_AUXADC_BUF_RDY_06,
	PMIC_AUXADC_BUF_OUT_07,
	PMIC_AUXADC_BUF_RDY_07,
	PMIC_AUXADC_BUF_OUT_08,
	PMIC_AUXADC_BUF_RDY_08,
	PMIC_AUXADC_BUF_OUT_09,
	PMIC_AUXADC_BUF_RDY_09,
	PMIC_AUXADC_BUF_OUT_10,
	PMIC_AUXADC_BUF_RDY_10,
	PMIC_AUXADC_BUF_OUT_11,
	PMIC_AUXADC_BUF_RDY_11,
	PMIC_AUXADC_BUF_OUT_12,
	PMIC_AUXADC_BUF_RDY_12,
	PMIC_AUXADC_BUF_OUT_13,
	PMIC_AUXADC_BUF_RDY_13,
	PMIC_AUXADC_BUF_OUT_14,
	PMIC_AUXADC_BUF_RDY_14,
	PMIC_AUXADC_BUF_OUT_15,
	PMIC_AUXADC_BUF_RDY_15,
	PMIC_AUXADC_BUF_OUT_16,
	PMIC_AUXADC_BUF_RDY_16,
	PMIC_AUXADC_BUF_OUT_17,
	PMIC_AUXADC_BUF_RDY_17,
	PMIC_AUXADC_BUF_OUT_18,
	PMIC_AUXADC_BUF_RDY_18,
	PMIC_AUXADC_BUF_OUT_19,
	PMIC_AUXADC_BUF_RDY_19,
	PMIC_AUXADC_BUF_OUT_20,
	PMIC_AUXADC_BUF_RDY_20,
	PMIC_AUXADC_BUF_OUT_21,
	PMIC_AUXADC_BUF_RDY_21,
	PMIC_AUXADC_BUF_OUT_22,
	PMIC_AUXADC_BUF_RDY_22,
	PMIC_AUXADC_BUF_OUT_23,
	PMIC_AUXADC_BUF_RDY_23,
	PMIC_AUXADC_BUF_OUT_24,
	PMIC_AUXADC_BUF_RDY_24,
	PMIC_AUXADC_BUF_OUT_25,
	PMIC_AUXADC_BUF_RDY_25,
	PMIC_AUXADC_BUF_OUT_26,
	PMIC_AUXADC_BUF_RDY_26,
	PMIC_AUXADC_BUF_OUT_27,
	PMIC_AUXADC_BUF_RDY_27,
	PMIC_AUXADC_BUF_OUT_28,
	PMIC_AUXADC_BUF_RDY_28,
	PMIC_AUXADC_BUF_OUT_29,
	PMIC_AUXADC_BUF_RDY_29,
	PMIC_AUXADC_BUF_OUT_30,
	PMIC_AUXADC_BUF_RDY_30,
	PMIC_AUXADC_BUF_OUT_31,
	PMIC_AUXADC_BUF_RDY_31,
	PMIC_AUXADC_ADC_BUSY_IN,
	PMIC_AUXADC_ADC_BUSY_IN_LBAT,
	PMIC_AUXADC_ADC_BUSY_IN_LBAT2,
	PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP,
	PMIC_AUXADC_ADC_BUSY_IN_WAKEUP,
	PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT,
	PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP,
	PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD,
	PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS,
	PMIC_AUXADC_ADC_BUSY_IN_JEITA,
	PMIC_AUXADC_ADC_BUSY_IN_MDRT,
	PMIC_AUXADC_ADC_BUSY_IN_MDBG,
	PMIC_AUXADC_ADC_BUSY_IN_SHARE,
	PMIC_AUXADC_ADC_BUSY_IN_IMP,
	PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR,
	PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR,
	PMIC_AUXADC_ADC_BUSY_IN_GPS_AP,
	PMIC_AUXADC_ADC_BUSY_IN_GPS_MD,
	PMIC_AUXADC_ADC_BUSY_IN_GPS,
	PMIC_AUXADC_ADC_BUSY_IN_THR_HW,
	PMIC_AUXADC_ADC_BUSY_IN_THR_MD,
	PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR,
	PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR,
	PMIC_AUXADC_ADC_BUSY_IN_BATID,
	PMIC_AUXADC_ADC_BUSY_IN_PWRON,
	PMIC_AUXADC_ADC_BUSY_IN_NAG,
	PMIC_AUXADC_RQST_CH0,
	PMIC_AUXADC_RQST_CH1,
	PMIC_AUXADC_RQST_CH2,
	PMIC_AUXADC_RQST_CH3,
	PMIC_AUXADC_RQST_CH4,
	PMIC_AUXADC_RQST_CH5,
	PMIC_AUXADC_RQST_CH6,
	PMIC_AUXADC_RQST_CH7,
	PMIC_AUXADC_RQST_CH8,
	PMIC_AUXADC_RQST_CH9,
	PMIC_AUXADC_RQST_CH10,
	PMIC_AUXADC_RQST_CH11,
	PMIC_AUXADC_RQST_CH12,
	PMIC_AUXADC_RQST_CH13,
	PMIC_AUXADC_RQST_CH14,
	PMIC_AUXADC_RQST_CH15,
	PMIC_AUXADC_RQST0_SET,
	PMIC_AUXADC_RQST0_CLR,
	PMIC_AUXADC_RQST_CH0_BY_MD,
	PMIC_AUXADC_RQST_CH1_BY_MD,
	PMIC_AUXADC_RQST_RSV0,
	PMIC_AUXADC_RQST_BATID,
	PMIC_AUXADC_RQST_CH4_BY_MD,
	PMIC_AUXADC_RQST_CH7_BY_MD,
	PMIC_AUXADC_RQST_CH7_BY_GPS,
	PMIC_AUXADC_RQST_DCXO_BY_MD,
	PMIC_AUXADC_RQST_DCXO_BY_GPS,
	PMIC_AUXADC_RQST_RSV1,
	PMIC_AUXADC_RQST1_SET,
	PMIC_AUXADC_RQST1_CLR,
	PMIC_AUXADC_CK_ON_EXTD,
	PMIC_AUXADC_SRCLKEN_SRC_SEL,
	PMIC_AUXADC_ADC_PWDB,
	PMIC_AUXADC_ADC_PWDB_SWCTRL,
	PMIC_AUXADC_STRUP_CK_ON_ENB,
	PMIC_AUXADC_SRCLKEN_CK_EN,
	PMIC_AUXADC_CK_AON_GPS,
	PMIC_AUXADC_CK_AON_MD,
	PMIC_AUXADC_CK_AON,
	PMIC_AUXADC_CON0_SET,
	PMIC_AUXADC_CON0_CLR,
	PMIC_AUXADC_AVG_NUM_SMALL,
	PMIC_AUXADC_AVG_NUM_LARGE,
	PMIC_AUXADC_SPL_NUM,
	PMIC_AUXADC_AVG_NUM_SEL,
	PMIC_AUXADC_AVG_NUM_SEL_SHARE,
	PMIC_AUXADC_AVG_NUM_SEL_LBAT,
	PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP,
	PMIC_AUXADC_AVG_NUM_SEL_WAKEUP,
	PMIC_AUXADC_SPL_NUM_LARGE,
	PMIC_AUXADC_SPL_NUM_SLEEP,
	PMIC_AUXADC_SPL_NUM_SLEEP_SEL,
	PMIC_AUXADC_SPL_NUM_SEL,
	PMIC_AUXADC_SPL_NUM_SEL_SHARE,
	PMIC_AUXADC_SPL_NUM_SEL_LBAT,
	PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP,
	PMIC_AUXADC_SPL_NUM_SEL_WAKEUP,
	PMIC_AUXADC_SPL_NUM_CH0,
	PMIC_AUXADC_SPL_NUM_CH3,
	PMIC_AUXADC_SPL_NUM_CH7,
	PMIC_AUXADC_AVG_NUM_LBAT,
	PMIC_AUXADC_AVG_NUM_CH7,
	PMIC_AUXADC_AVG_NUM_CH3,
	PMIC_AUXADC_AVG_NUM_CH0,
	PMIC_AUXADC_AVG_NUM_HPC,
	PMIC_AUXADC_AVG_NUM_DCXO,
	PMIC_AUXADC_TRIM_CH0_SEL,
	PMIC_AUXADC_TRIM_CH1_SEL,
	PMIC_AUXADC_TRIM_CH2_SEL,
	PMIC_AUXADC_TRIM_CH3_SEL,
	PMIC_AUXADC_TRIM_CH4_SEL,
	PMIC_AUXADC_TRIM_CH5_SEL,
	PMIC_AUXADC_TRIM_CH6_SEL,
	PMIC_AUXADC_TRIM_CH7_SEL,
	PMIC_AUXADC_TRIM_CH8_SEL,
	PMIC_AUXADC_TRIM_CH9_SEL,
	PMIC_AUXADC_TRIM_CH10_SEL,
	PMIC_AUXADC_TRIM_CH11_SEL,
	PMIC_AUXADC_ADC_2S_COMP_ENB,
	PMIC_AUXADC_ADC_TRIM_COMP,
	PMIC_AUXADC_SW_GAIN_TRIM,
	PMIC_AUXADC_SW_OFFSET_TRIM,
	PMIC_AUXADC_RNG_EN,
	PMIC_AUXADC_TEST_MODE,
	PMIC_AUXADC_BIT_SEL,
	PMIC_AUXADC_START_SW,
	PMIC_AUXADC_START_SWCTRL,
	PMIC_AUXADC_TS_VBE_SEL,
	PMIC_AUXADC_TS_VBE_SEL_SWCTRL,
	PMIC_AUXADC_VBUF_EN,
	PMIC_AUXADC_VBUF_EN_SWCTRL,
	PMIC_AUXADC_OUT_SEL,
	PMIC_AUXADC_DA_DAC,
	PMIC_AUXADC_DA_DAC_SWCTRL,
	PMIC_AD_AUXADC_COMP,
	PMIC_RG_AUXADC_CALI,
	PMIC_RG_AUX_RSV,
	PMIC_RG_VBUF_BYP,
	PMIC_RG_VBUF_CALEN,
	PMIC_RG_VBUF_EXTEN,
	PMIC_AUXADC_ADCIN_VSEN_EN,
	PMIC_AUXADC_ADCIN_VBAT_EN,
	PMIC_AUXADC_ADCIN_VSEN_MUX_EN,
	PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN,
	PMIC_AUXADC_ADCIN_CHR_EN,
	PMIC_AUXADC_ADCIN_BATON_TDET_EN,
	PMIC_AUXADC_ACCDET_ANASWCTRL_EN,
	PMIC_AUXADC_XO_THADC_EN,
	PMIC_AUXADC_ADCIN_BATID_SW_EN,
	PMIC_AUXADC_DIG0_RSV0,
	PMIC_AUXADC_CHSEL,
	PMIC_AUXADC_SWCTRL_EN,
	PMIC_AUXADC_SOURCE_LBAT_SEL,
	PMIC_AUXADC_SOURCE_LBAT2_SEL,
	PMIC_AUXADC_START_EXTD,
	PMIC_AUXADC_DAC_EXTD,
	PMIC_AUXADC_DAC_EXTD_EN,
	PMIC_AUXADC_PMU_THR_PDN_SW,
	PMIC_AUXADC_PMU_THR_PDN_SEL,
	PMIC_AUXADC_PMU_THR_PDN_STATUS,
	PMIC_AUXADC_DIG0_RSV1,
	PMIC_AUXADC_START_SHADE_NUM,
	PMIC_AUXADC_START_SHADE_EN,
	PMIC_AUXADC_START_SHADE_SEL,
	PMIC_AUXADC_ADC_RDY_WAKEUP_CLR,
	PMIC_AUXADC_ADC_RDY_FGADC_CLR,
	PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR,
	PMIC_AUXADC_ADC_RDY_PWRON_CLR,
	PMIC_AUXADC_DATA_REUSE_SEL,
	PMIC_AUXADC_CH0_DATA_REUSE_SEL,
	PMIC_AUXADC_CH1_DATA_REUSE_SEL,
	PMIC_AUXADC_DCXO_DATA_REUSE_SEL,
	PMIC_AUXADC_DATA_REUSE_EN,
	PMIC_AUXADC_CH0_DATA_REUSE_EN,
	PMIC_AUXADC_CH1_DATA_REUSE_EN,
	PMIC_AUXADC_DCXO_DATA_REUSE_EN,
	PMIC_AUXADC_AUTORPT_PRD,
	PMIC_AUXADC_AUTORPT_EN,
	PMIC_AUXADC_LBAT_DEBT_MAX,
	PMIC_AUXADC_LBAT_DEBT_MIN,
	PMIC_AUXADC_LBAT_DET_PRD_15_0,
	PMIC_AUXADC_LBAT_DET_PRD_19_16,
	PMIC_AUXADC_LBAT_VOLT_MAX,
	PMIC_AUXADC_LBAT_IRQ_EN_MAX,
	PMIC_AUXADC_LBAT_EN_MAX,
	PMIC_AUXADC_LBAT_MAX_IRQ_B,
	PMIC_AUXADC_LBAT_VOLT_MIN,
	PMIC_AUXADC_LBAT_IRQ_EN_MIN,
	PMIC_AUXADC_LBAT_EN_MIN,
	PMIC_AUXADC_LBAT_MIN_IRQ_B,
	PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX,
	PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN,
	PMIC_AUXADC_ACCDET_AUTO_SPL,
	PMIC_AUXADC_ACCDET_AUTO_RQST_CLR,
	PMIC_AUXADC_ACCDET_DIG1_RSV0,
	PMIC_AUXADC_ACCDET_DIG0_RSV0,
	PMIC_AUXADC_THR_DEBT_MAX,
	PMIC_AUXADC_THR_DEBT_MIN,
	PMIC_AUXADC_THR_DET_PRD_15_0,
	PMIC_AUXADC_THR_DET_PRD_19_16,
	PMIC_AUXADC_THR_VOLT_MAX,
	PMIC_AUXADC_THR_IRQ_EN_MAX,
	PMIC_AUXADC_THR_EN_MAX,
	PMIC_AUXADC_THR_MAX_IRQ_B,
	PMIC_AUXADC_THR_VOLT_MIN,
	PMIC_AUXADC_THR_IRQ_EN_MIN,
	PMIC_AUXADC_THR_EN_MIN,
	PMIC_AUXADC_THR_MIN_IRQ_B,
	PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX,
	PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN,
	PMIC_EFUSE_GAIN_CH4_TRIM,
	PMIC_EFUSE_OFFSET_CH4_TRIM,
	PMIC_EFUSE_GAIN_CH0_TRIM,
	PMIC_EFUSE_OFFSET_CH0_TRIM,
	PMIC_EFUSE_GAIN_CH7_TRIM,
	PMIC_EFUSE_OFFSET_CH7_TRIM,
	PMIC_AUXADC_FGADC_START_SW,
	PMIC_AUXADC_FGADC_START_SEL,
	PMIC_AUXADC_FGADC_R_SW,
	PMIC_AUXADC_FGADC_R_SEL,
	PMIC_AUXADC_BAT_PLUGIN_START_SW,
	PMIC_AUXADC_BAT_PLUGIN_START_SEL,
	PMIC_AUXADC_DBG_DIG0_RSV2,
	PMIC_AUXADC_DBG_DIG1_RSV2,
	PMIC_AUXADC_IMPEDANCE_CNT,
	PMIC_AUXADC_IMPEDANCE_CHSEL,
	PMIC_AUXADC_IMPEDANCE_IRQ_CLR,
	PMIC_AUXADC_IMPEDANCE_IRQ_STATUS,
	PMIC_AUXADC_CLR_IMP_CNT_STOP,
	PMIC_AUXADC_IMPEDANCE_MODE,
	PMIC_AUXADC_IMP_AUTORPT_PRD,
	PMIC_AUXADC_IMP_AUTORPT_EN,
	PMIC_AUXADC_BAT_TEMP_FROZE_EN,
	PMIC_AUXADC_BAT_TEMP_DEBT_MAX,
	PMIC_AUXADC_BAT_TEMP_DEBT_MIN,
	PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0,
	PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16,
	PMIC_AUXADC_BAT_TEMP_VOLT_MAX,
	PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX,
	PMIC_AUXADC_BAT_TEMP_EN_MAX,
	PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B,
	PMIC_AUXADC_BAT_TEMP_VOLT_MIN,
	PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN,
	PMIC_AUXADC_BAT_TEMP_EN_MIN,
	PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B,
	PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX,
	PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN,
	PMIC_AUXADC_LBAT2_DEBT_MAX,
	PMIC_AUXADC_LBAT2_DEBT_MIN,
	PMIC_AUXADC_LBAT2_DET_PRD_15_0,
	PMIC_AUXADC_LBAT2_DET_PRD_19_16,
	PMIC_AUXADC_LBAT2_VOLT_MAX,
	PMIC_AUXADC_LBAT2_IRQ_EN_MAX,
	PMIC_AUXADC_LBAT2_EN_MAX,
	PMIC_AUXADC_LBAT2_MAX_IRQ_B,
	PMIC_AUXADC_LBAT2_VOLT_MIN,
	PMIC_AUXADC_LBAT2_IRQ_EN_MIN,
	PMIC_AUXADC_LBAT2_EN_MIN,
	PMIC_AUXADC_LBAT2_MIN_IRQ_B,
	PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX,
	PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN,
	PMIC_AUXADC_MDBG_DET_PRD,
	PMIC_AUXADC_MDBG_DET_EN,
	PMIC_AUXADC_MDBG_R_PTR,
	PMIC_AUXADC_MDBG_W_PTR,
	PMIC_AUXADC_MDBG_BUF_LENGTH,
	PMIC_AUXADC_MDRT_DET_PRD,
	PMIC_AUXADC_MDRT_DET_EN,
	PMIC_AUXADC_MDRT_DET_WKUP_START_CNT,
	PMIC_AUXADC_MDRT_DET_WKUP_START_CLR,
	PMIC_AUXADC_MDRT_DET_WKUP_START,
	PMIC_AUXADC_MDRT_DET_WKUP_START_SEL,
	PMIC_AUXADC_MDRT_DET_WKUP_EN,
	PMIC_AUXADC_MDRT_DET_SRCLKEN_IND,
	PMIC_AUXADC_MDRT_DET_RDY_ST_PRD,
	PMIC_AUXADC_MDRT_DET_RDY_ST_EN,
	PMIC_AUXADC_MDRT_DET_START_SEL,
	PMIC_AUXADC_JEITA_IRQ_EN,
	PMIC_AUXADC_JEITA_EN,
	PMIC_AUXADC_JEITA_DET_PRD,
	PMIC_AUXADC_JEITA_DEBT,
	PMIC_AUXADC_JEITA_MIPI_DIS,
	PMIC_AUXADC_JEITA_FROZE_EN,
	PMIC_AUXADC_JEITA_VOLT_HOT,
	PMIC_AUXADC_JEITA_HOT_IRQ,
	PMIC_AUXADC_JEITA_VOLT_WARM,
	PMIC_AUXADC_JEITA_WARM_IRQ,
	PMIC_AUXADC_JEITA_VOLT_COOL,
	PMIC_AUXADC_JEITA_COOL_IRQ,
	PMIC_AUXADC_JEITA_VOLT_COLD,
	PMIC_AUXADC_JEITA_COLD_IRQ,
	PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD,
	PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL,
	PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM,
	PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT,
	PMIC_AUXADC_DCXO_MDRT_DET_PRD,
	PMIC_AUXADC_DCXO_MDRT_DET_EN,
	PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT,
	PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR,
	PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN,
	PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL,
	PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START,
	PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND,
	PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL,
	PMIC_AUXADC_NAG_EN,
	PMIC_AUXADC_NAG_CLR,
	PMIC_AUXADC_NAG_VBAT1_SEL,
	PMIC_AUXADC_NAG_PRD,
	PMIC_AUXADC_NAG_IRQ_EN,
	PMIC_AUXADC_NAG_C_DLTV_IRQ,
	PMIC_AUXADC_NAG_ZCV,
	PMIC_AUXADC_NAG_C_DLTV_TH_15_0,
	PMIC_AUXADC_NAG_C_DLTV_TH_26_16,
	PMIC_AUXADC_NAG_CNT_15_0,
	PMIC_AUXADC_NAG_CNT_25_16,
	PMIC_AUXADC_NAG_DLTV,
	PMIC_AUXADC_NAG_C_DLTV_15_0,
	PMIC_AUXADC_NAG_C_DLTV_26_16,
	PMIC_AUXADC_EFUSE_DEGC_CALI,
	PMIC_AUXADC_EFUSE_ADC_CALI_EN,
	PMIC_AUXADC_EFUSE_1RSV0,
	PMIC_AUXADC_EFUSE_O_VTS,
	PMIC_AUXADC_EFUSE_2RSV0,
	PMIC_AUXADC_EFUSE_O_SLOPE,
	PMIC_AUXADC_EFUSE_O_SLOPE_SIGN,
	PMIC_AUXADC_EFUSE_3RSV0,
	PMIC_AUXADC_EFUSE_AUXADC_RSV,
	PMIC_AUXADC_EFUSE_ID,
	PMIC_AUXADC_EFUSE_4RSV0,
	PMIC_AUXADC_RSV_1RSV0,
	PMIC_DA_ADCIN_VBAT_EN,
	PMIC_DA_AUXADC_VBAT_EN,
	PMIC_DA_ADCIN_VSEN_MUX_EN,
	PMIC_DA_ADCIN_VSEN_EN,
	PMIC_DA_ADCIN_CHR_EN,
	PMIC_DA_BATON_TDET_EN,
	PMIC_DA_ADCIN_BATID_SW_EN,
	PMIC_RG_AUXADC_IMP_CK_SW_MODE,
	PMIC_RG_AUXADC_IMP_CK_SW_EN,
	PMIC_RG_AUXADC_LBAT_CK_SW_MODE,
	PMIC_RG_AUXADC_LBAT_CK_SW_EN,
	PMIC_RG_AUXADC_THR_CK_SW_MODE,
	PMIC_RG_AUXADC_THR_CK_SW_EN,
	PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE,
	PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN,
	PMIC_RG_AUXADC_LBAT2_CK_SW_MODE,
	PMIC_RG_AUXADC_LBAT2_CK_SW_EN,
	PMIC_RG_AUXADC_JEITA_CK_SW_MODE,
	PMIC_RG_AUXADC_JEITA_CK_SW_EN,
	PMIC_RG_AUXADC_NAG_CK_SW_MODE,
	PMIC_RG_AUXADC_NAG_CK_SW_EN,
	PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL,
	PMU_COMMAND_MAX
};

struct pmu_flag_table_entry_t {
	PMU_FLAGS_LIST_ENUM flagname;
	unsigned short offset;
	unsigned short mask;
	unsigned char shift;
};

#endif				/* _MT_PMIC_UPMU_HW_H_ */

