/*
 * Copyright (C) 2016 MediaTek Inc.

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See http://www.gnu.org/licenses/gpl-2.0.html for more details.
 */

#include <linux/kernel.h>

#include "upmu_sw.h"
#include "upmu_hw.h"

#include "include/pmic.h"

const PMU_FLAG_TABLE_ENTRY pmu_flags_table[] = {
	PMIC_ENTRY(PMIC_DEW_READ_TEST),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_RSTB_SW),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_START_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_RSTB_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_AUXADC_RPCNT_MAX),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBIF28_SW_OP_EN),
	PMIC_ENTRY(PMIC_DA_QI_VBIF28_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_RAW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_MDBG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_MDBG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_JEITA),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_JEITA),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BATID),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_00),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_00),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_01),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_01),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_02),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_02),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_03),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_03),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_04),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_04),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_05),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_05),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_06),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_06),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_07),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_07),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_08),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_08),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_09),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_09),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_10),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_10),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_11),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_11),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_12),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_12),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_13),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_13),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_14),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_14),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_15),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_15),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_16),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_16),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_17),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_17),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_18),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_18),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_19),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_19),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_20),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_20),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_21),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_21),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_22),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_22),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_23),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_23),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_24),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_24),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_25),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_25),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_26),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_26),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_27),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_27),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_28),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_28),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_29),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_29),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_30),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_30),
	PMIC_ENTRY(PMIC_AUXADC_BUF_OUT_31),
	PMIC_ENTRY(PMIC_AUXADC_BUF_RDY_31),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_JEITA),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_MDBG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_FGADC_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_SWCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_PWRON),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_NAG),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH5),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH6),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH8),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH9),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH10),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH11),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH13),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH14),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH15),
	PMIC_ENTRY(PMIC_AUXADC_RQST0_SET),
	PMIC_ENTRY(PMIC_AUXADC_RQST0_CLR),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_BATID),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_RQST1_SET),
	PMIC_ENTRY(PMIC_AUXADC_RQST1_CLR),
	PMIC_ENTRY(PMIC_AUXADC_CK_ON_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_SRC_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_STRUP_CK_ON_ENB),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_CK_EN),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_GPS),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_MD),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON),
	PMIC_ENTRY(PMIC_AUXADC_CON0_SET),
	PMIC_ENTRY(PMIC_AUXADC_CON0_CLR),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SMALL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_HPC),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_DCXO),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH0_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH3_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH4_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH5_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH6_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH7_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH8_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH9_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH10_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH11_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_2S_COMP_ENB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_TRIM_COMP),
	PMIC_ENTRY(PMIC_AUXADC_SW_GAIN_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_SW_OFFSET_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_RNG_EN),
	PMIC_ENTRY(PMIC_AUXADC_TEST_MODE),
	PMIC_ENTRY(PMIC_AUXADC_BIT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_START_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_OUT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC_SWCTRL),
	PMIC_ENTRY(PMIC_AD_AUXADC_COMP),
	PMIC_ENTRY(PMIC_RG_AUXADC_CALI),
	PMIC_ENTRY(PMIC_RG_AUX_RSV),
	PMIC_ENTRY(PMIC_RG_VBUF_BYP),
	PMIC_ENTRY(PMIC_RG_VBUF_CALEN),
	PMIC_ENTRY(PMIC_RG_VBUF_EXTEN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_ANASWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_SWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD_EN),
	PMIC_ENTRY(PMIC_AUXADC_PMU_THR_PDN_SW),
	PMIC_ENTRY(PMIC_AUXADC_PMU_THR_PDN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_PMU_THR_PDN_STATUS),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_NUM),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_EN),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_PRD),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_PRD_15_0),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_PRD_19_16),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_SPL),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_RQST_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG1_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_PRD_15_0),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_PRD_19_16),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH4_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH4_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH0_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH0_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH7_TRIM),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH7_TRIM),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_R_SW),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_R_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG0_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG1_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_CNT),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_IRQ_CLR),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_IRQ_STATUS),
	PMIC_ENTRY(PMIC_AUXADC_CLR_IMP_CNT_STOP),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_MODE),
	PMIC_ENTRY(PMIC_AUXADC_IMP_AUTORPT_PRD),
	PMIC_ENTRY(PMIC_AUXADC_IMP_AUTORPT_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_FROZE_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_PRD_15_0),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_PRD_19_16),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_PRD_15_0),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_PRD_19_16),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_MDBG_DET_PRD),
	PMIC_ENTRY(PMIC_AUXADC_MDBG_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDBG_R_PTR),
	PMIC_ENTRY(PMIC_AUXADC_MDBG_W_PTR),
	PMIC_ENTRY(PMIC_AUXADC_MDBG_BUF_LENGTH),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_PRD),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_RDY_ST_PRD),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_RDY_ST_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_IRQ_EN),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_EN),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_DET_PRD),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_DEBT),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_MIPI_DIS),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_FROZE_EN),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_VOLT_HOT),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_HOT_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_VOLT_WARM),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_WARM_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_VOLT_COOL),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_COOL_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_VOLT_COLD),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_COLD_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COLD),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_COOL),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_WARM),
	PMIC_ENTRY(PMIC_AUXADC_JEITA_DEBOUNCE_COUNT_HOT),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_PRD),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_SRCLKEN_IND),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_CH4_MUX_AP_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CLR),
	PMIC_ENTRY(PMIC_AUXADC_NAG_VBAT1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_PRD),
	PMIC_ENTRY(PMIC_AUXADC_NAG_IRQ_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_NAG_ZCV),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_26_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_25_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_DLTV),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_15_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_26_16),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_DEGC_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_CALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_1RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_2RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE_SIGN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_3RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_AUXADC_RSV),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ID),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_4RSV0),
	PMIC_ENTRY(PMIC_AUXADC_RSV_1RSV0),
	PMIC_ENTRY(PMIC_DA_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_DA_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_IMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_IMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_LBAT_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_LBAT_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_THR_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_THR_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_BAT_TEMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_LBAT2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_LBAT2_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_JEITA_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_JEITA_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_NAG_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_AUXADC_NAG_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_NEW_PRIORITY_LIST_SEL),
};
