/*
 * Copyright (C) 2018 MediaTek Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#ifndef __PWM_MT3615_REG_H__
/**
 * @file mt3615_pwm_reg.h
 * Heander of pmic_pwm.c
 */
#define __PWM_MT3615_REG_H__
#define PM_BS (0x0)
/*PMIC_BASE*/

/*
 * REMOVE _
 * REMOVE PWM_
 * REMOVE PMIC_
 * _LP_             -->   _LONG_PRESS_
 * _RB_             -->   _REBOOT_
 * _PARA_SRC_      -->  _PARA_
 *_STANDBY_         -->  _BY_
 *_FAIL_WDT_        -->  _FW_
 *_AUTOLOAD_       -->  _LOAD_
*/
/** @ingroup IP_group_pwm_external_def
 * @{
 */
#define LED1_APPLY_EN                       ((uint32_t)(PM_BS+0x1c88))
#define LED1_LOAD_DISABLE                   ((uint32_t)(PM_BS+0x1c8a))
#define LED1_MODE_CON                       ((uint32_t)(PM_BS+0x1c8c))
#define LED1_FIX_CON                        ((uint32_t)(PM_BS+0x1c8e))
#define LED1_FLASH_CON0                     ((uint32_t)(PM_BS+0x1c90))
#define LED1_FLASH_CON1                     ((uint32_t)(PM_BS+0x1c92))
#define LED1_FLASH_CON2                     ((uint32_t)(PM_BS+0x1c94))
#define LED1_FLASH_CON3                     ((uint32_t)(PM_BS+0x1c96))
#define LED1_FLASH_CON4                     ((uint32_t)(PM_BS+0x1c98))
#define LED1_FLASH_CON5                     ((uint32_t)(PM_BS+0x1c9a))
#define LED1_FLASH_CON6                     ((uint32_t)(PM_BS+0x1c9c))
#define LED1_FLASH_CON7                     ((uint32_t)(PM_BS+0x1c9e))
#define LED1_FLASH_CON8                     ((uint32_t)(PM_BS+0x1ca0))
#define LED1_FLASH_CON9                     ((uint32_t)(PM_BS+0x1ca2))
#define LED1_FLASH_CON10                    ((uint32_t)(PM_BS+0x1ca4))
#define LED1_ELR0                           ((uint32_t)(PM_BS+0x1cc4))
#define LED1_ELR1                           ((uint32_t)(PM_BS+0x1cc6))
#define LED1_ELR2                           ((uint32_t)(PM_BS+0x1cc8))
#define LED1_ELR3                           ((uint32_t)(PM_BS+0x1cca))
#define LED1_ELR4                           ((uint32_t)(PM_BS+0x1ccc))
#define LED1_ELR5                           ((uint32_t)(PM_BS+0x1cce))
#define LED1_ELR6                           ((uint32_t)(PM_BS+0x1cd0))
#define LED1_ELR7                           ((uint32_t)(PM_BS+0x1cd2))
#define LED1_ELR8                           ((uint32_t)(PM_BS+0x1cd4))
#define LED1_ELR9                           ((uint32_t)(PM_BS+0x1cd6))
#define LED1_ELR10                          ((uint32_t)(PM_BS+0x1cd8))
#define LED1_ELR11                          ((uint32_t)(PM_BS+0x1cda))
#define LED1_ELR12                          ((uint32_t)(PM_BS+0x1cdc))
#define LED1_ELR13                          ((uint32_t)(PM_BS+0x1cde))
#define LED1_ELR14                          ((uint32_t)(PM_BS+0x1ce0))
#define LED1_ELR15                          ((uint32_t)(PM_BS+0x1ce2))
#define LED1_ELR16                          ((uint32_t)(PM_BS+0x1ce4))
#define LED1_ELR17                          ((uint32_t)(PM_BS+0x1ce6))
#define LED1_ELR18                          ((uint32_t)(PM_BS+0x1ce8))
#define LED1_ELR19                          ((uint32_t)(PM_BS+0x1cea))
#define LED1_ELR20                          ((uint32_t)(PM_BS+0x1cec))
#define LED1_ELR21                          ((uint32_t)(PM_BS+0x1cee))
#define LED1_ELR22                          ((uint32_t)(PM_BS+0x1cf0))
#define LED1_ELR23                          ((uint32_t)(PM_BS+0x1cf2))
#define PWR_OFF_LP_LED1_MODE                ((uint32_t)(PM_BS+0x1d08))
#define PWR_OFF_LP_LED1_FIX_CON             ((uint32_t)(PM_BS+0x1d0a))
#define PWR_OFF_LP_LED1_FLASH_CON0          ((uint32_t)(PM_BS+0x1d0c))
#define PWR_OFF_LP_LED1_FLASH_CON1          ((uint32_t)(PM_BS+0x1d0e))
#define PWR_OFF_LP_LED1_FLASH_CON2          ((uint32_t)(PM_BS+0x1d10))
#define PWR_OFF_LP_LED1_FLASH_CON3          ((uint32_t)(PM_BS+0x1d12))
#define PWR_OFF_LP_LED1_FLASH_CON4          ((uint32_t)(PM_BS+0x1d14))
#define PWR_OFF_LP_LED1_FLASH_CON5          ((uint32_t)(PM_BS+0x1d16))
#define PWR_OFF_LP_LED1_FLASH_CON6          ((uint32_t)(PM_BS+0x1d18))
#define PWR_OFF_LP_LED1_FLASH_CON7          ((uint32_t)(PM_BS+0x1d1a))
#define PWR_OFF_LP_LED1_FLASH_CON8          ((uint32_t)(PM_BS+0x1d1c))
#define PWR_OFF_LP_LED1_FLASH_CON9          ((uint32_t)(PM_BS+0x1d1e))
#define PWR_OFF_LP_LED1_FLASH_CON10         ((uint32_t)(PM_BS+0x1d20))
#define PWR_RB_LED1_MODE                    ((uint32_t)(PM_BS+0x1d22))
#define PWR_RB_LED1_FIX_CON                 ((uint32_t)(PM_BS+0x1d24))
#define PWR_RB_LED1_FLASH_CON0              ((uint32_t)(PM_BS+0x1d26))
#define PWR_RB_LED1_FLASH_CON1              ((uint32_t)(PM_BS+0x1d28))
#define PWR_RB_LED1_FLASH_CON2              ((uint32_t)(PM_BS+0x1d2a))
#define PWR_RB_LED1_FLASH_CON3              ((uint32_t)(PM_BS+0x1d2c))
#define PWR_RB_LED1_FLASH_CON4              ((uint32_t)(PM_BS+0x1d2e))
#define PWR_RB_LED1_FLASH_CON5              ((uint32_t)(PM_BS+0x1d30))
#define PWR_RB_LED1_FLASH_CON6              ((uint32_t)(PM_BS+0x1d32))
#define PWR_RB_LED1_FLASH_CON7              ((uint32_t)(PM_BS+0x1d34))
#define PWR_RB_LED1_FLASH_CON8              ((uint32_t)(PM_BS+0x1d36))
#define PWR_RB_LED1_FLASH_CON9              ((uint32_t)(PM_BS+0x1d38))
#define PWR_RB_LED1_FLASH_CON10             ((uint32_t)(PM_BS+0x1d3a))
#define PWR_FAIL_LED1_MODE                  ((uint32_t)(PM_BS+0x1d3c))
#define PWR_FAIL_LED1_FIX_CON               ((uint32_t)(PM_BS+0x1d3e))
#define PWR_FAIL_LED1_FLASH_CON0            ((uint32_t)(PM_BS+0x1d40))
#define PWR_FAIL_LED1_FLASH_CON1            ((uint32_t)(PM_BS+0x1d42))
#define PWR_FAIL_LED1_FLASH_CON2            ((uint32_t)(PM_BS+0x1d44))
#define PWR_FAIL_LED1_FLASH_CON3            ((uint32_t)(PM_BS+0x1d46))
#define PWR_FAIL_LED1_FLASH_CON4            ((uint32_t)(PM_BS+0x1d48))
#define PWR_FAIL_LED1_FLASH_CON5            ((uint32_t)(PM_BS+0x1d4a))
#define PWR_FAIL_LED1_FLASH_CON6            ((uint32_t)(PM_BS+0x1d4c))
#define PWR_FAIL_LED1_FLASH_CON7            ((uint32_t)(PM_BS+0x1d4e))
#define PWR_FAIL_LED1_FLASH_CON8            ((uint32_t)(PM_BS+0x1d50))
#define PWR_FAIL_LED1_FLASH_CON9            ((uint32_t)(PM_BS+0x1d52))
#define PWR_FAIL_LED1_FLASH_CON10           ((uint32_t)(PM_BS+0x1d54))
#define PWR_FW_LED1_MODE                    ((uint32_t)(PM_BS+0x1d56))
#define PWR_FW_LED1_FIX_CON                 ((uint32_t)(PM_BS+0x1d58))
#define PWR_FW_LED1_FLASH_CON0              ((uint32_t)(PM_BS+0x1d5a))
#define PWR_FW_LED1_FLASH_CON1              ((uint32_t)(PM_BS+0x1d5c))
#define PWR_FW_LED1_FLASH_CON2              ((uint32_t)(PM_BS+0x1d5e))
#define PWR_FW_LED1_FLASH_CON3              ((uint32_t)(PM_BS+0x1d60))
#define PWR_FW_LED1_FLASH_CON4              ((uint32_t)(PM_BS+0x1d62))
#define PWR_FW_LED1_FLASH_CON5              ((uint32_t)(PM_BS+0x1d64))
#define PWR_FW_LED1_FLASH_CON6              ((uint32_t)(PM_BS+0x1d66))
#define PWR_FW_LED1_FLASH_CON7              ((uint32_t)(PM_BS+0x1d68))
#define PWR_FW_LED1_FLASH_CON8              ((uint32_t)(PM_BS+0x1d6a))
#define PWR_FW_LED1_FLASH_CON9              ((uint32_t)(PM_BS+0x1d6c))
#define PWR_FW_LED1_FLASH_CON10             ((uint32_t)(PM_BS+0x1d6e))
#define LED2_APPLY_EN                       ((uint32_t)(PM_BS+0x1d88))
#define LED2_LOAD_DISABLE                   ((uint32_t)(PM_BS+0x1d8a))
#define LED2_MODE_CON                       ((uint32_t)(PM_BS+0x1d8c))
#define LED2_FIX_CON                        ((uint32_t)(PM_BS+0x1d8e))
#define LED2_FLASH_CON0                     ((uint32_t)(PM_BS+0x1d90))
#define LED2_FLASH_CON1                     ((uint32_t)(PM_BS+0x1d92))
#define LED2_FLASH_CON2                     ((uint32_t)(PM_BS+0x1d94))
#define LED2_FLASH_CON3                     ((uint32_t)(PM_BS+0x1d96))
#define LED2_FLASH_CON4                     ((uint32_t)(PM_BS+0x1d98))
#define LED2_FLASH_CON5                     ((uint32_t)(PM_BS+0x1d9a))
#define LED2_FLASH_CON6                     ((uint32_t)(PM_BS+0x1d9c))
#define LED2_FLASH_CON7                     ((uint32_t)(PM_BS+0x1d9e))
#define LED2_FLASH_CON8                     ((uint32_t)(PM_BS+0x1da0))
#define LED2_FLASH_CON9                     ((uint32_t)(PM_BS+0x1da2))
#define LED2_FLASH_CON10                    ((uint32_t)(PM_BS+0x1da4))
#define LED2_ELR0                           ((uint32_t)(PM_BS+0x1dc4))
#define LED2_ELR1                           ((uint32_t)(PM_BS+0x1dc6))
#define LED2_ELR2                           ((uint32_t)(PM_BS+0x1dc8))
#define LED2_ELR3                           ((uint32_t)(PM_BS+0x1dca))
#define LED2_ELR4                           ((uint32_t)(PM_BS+0x1dcc))
#define LED2_ELR5                           ((uint32_t)(PM_BS+0x1dce))
#define LED2_ELR6                           ((uint32_t)(PM_BS+0x1dd0))
#define LED2_ELR7                           ((uint32_t)(PM_BS+0x1dd2))
#define LED2_ELR8                           ((uint32_t)(PM_BS+0x1dd4))
#define LED2_ELR9                           ((uint32_t)(PM_BS+0x1dd6))
#define LED2_ELR10                          ((uint32_t)(PM_BS+0x1dd8))
#define LED2_ELR11                          ((uint32_t)(PM_BS+0x1dda))
#define LED2_ELR12                          ((uint32_t)(PM_BS+0x1ddc))
#define LED2_ELR13                          ((uint32_t)(PM_BS+0x1dde))
#define LED2_ELR14                          ((uint32_t)(PM_BS+0x1de0))
#define LED2_ELR15                          ((uint32_t)(PM_BS+0x1de2))
#define LED2_ELR16                          ((uint32_t)(PM_BS+0x1de4))
#define LED2_ELR17                          ((uint32_t)(PM_BS+0x1de6))
#define LED2_ELR18                          ((uint32_t)(PM_BS+0x1de8))
#define LED2_ELR19                          ((uint32_t)(PM_BS+0x1dea))
#define LED2_ELR20                          ((uint32_t)(PM_BS+0x1dec))
#define LED2_ELR21                          ((uint32_t)(PM_BS+0x1dee))
#define LED2_ELR22                          ((uint32_t)(PM_BS+0x1df0))
#define LED2_ELR23                          ((uint32_t)(PM_BS+0x1df2))
#define PWR_OFF_LP_LED2_MODE                ((uint32_t)(PM_BS+0x1e08))
#define PWR_OFF_LP_LED2_FIX_CON             ((uint32_t)(PM_BS+0x1e0a))
#define PWR_OFF_LP_LED2_FLASH_CON0          ((uint32_t)(PM_BS+0x1e0c))
#define PWR_OFF_LP_LED2_FLASH_CON1          ((uint32_t)(PM_BS+0x1e0e))
#define PWR_OFF_LP_LED2_FLASH_CON2          ((uint32_t)(PM_BS+0x1e10))
#define PWR_OFF_LP_LED2_FLASH_CON3          ((uint32_t)(PM_BS+0x1e12))
#define PWR_OFF_LP_LED2_FLASH_CON4          ((uint32_t)(PM_BS+0x1e14))
#define PWR_OFF_LP_LED2_FLASH_CON5          ((uint32_t)(PM_BS+0x1e16))
#define PWR_OFF_LP_LED2_FLASH_CON6          ((uint32_t)(PM_BS+0x1e18))
#define PWR_OFF_LP_LED2_FLASH_CON7          ((uint32_t)(PM_BS+0x1e1a))
#define PWR_OFF_LP_LED2_FLASH_CON8          ((uint32_t)(PM_BS+0x1e1c))
#define PWR_OFF_LP_LED2_FLASH_CON9          ((uint32_t)(PM_BS+0x1e1e))
#define PWR_OFF_LP_LED2_FLASH_CON10         ((uint32_t)(PM_BS+0x1e20))
#define PWR_RB_LED2_MODE                    ((uint32_t)(PM_BS+0x1e22))
#define PWR_RB_LED2_FIX_CON                 ((uint32_t)(PM_BS+0x1e24))
#define PWR_RB_LED2_FLASH_CON0              ((uint32_t)(PM_BS+0x1e26))
#define PWR_RB_LED2_FLASH_CON1              ((uint32_t)(PM_BS+0x1e28))
#define PWR_RB_LED2_FLASH_CON2              ((uint32_t)(PM_BS+0x1e2a))
#define PWR_RB_LED2_FLASH_CON3              ((uint32_t)(PM_BS+0x1e2c))
#define PWR_RB_LED2_FLASH_CON4              ((uint32_t)(PM_BS+0x1e2e))
#define PWR_RB_LED2_FLASH_CON5              ((uint32_t)(PM_BS+0x1e30))
#define PWR_RB_LED2_FLASH_CON6              ((uint32_t)(PM_BS+0x1e32))
#define PWR_RB_LED2_FLASH_CON7              ((uint32_t)(PM_BS+0x1e34))
#define PWR_RB_LED2_FLASH_CON8              ((uint32_t)(PM_BS+0x1e36))
#define PWR_RB_LED2_FLASH_CON9              ((uint32_t)(PM_BS+0x1e38))
#define PWR_RB_LED2_FLASH_CON10             ((uint32_t)(PM_BS+0x1e3a))
#define PWR_FAIL_LED2_MODE                  ((uint32_t)(PM_BS+0x1e3c))
#define PWR_FAIL_LED2_FIX_CON               ((uint32_t)(PM_BS+0x1e3e))
#define PWR_FAIL_LED2_FLASH_CON0            ((uint32_t)(PM_BS+0x1e40))
#define PWR_FAIL_LED2_FLASH_CON1            ((uint32_t)(PM_BS+0x1e42))
#define PWR_FAIL_LED2_FLASH_CON2            ((uint32_t)(PM_BS+0x1e44))
#define PWR_FAIL_LED2_FLASH_CON3            ((uint32_t)(PM_BS+0x1e46))
#define PWR_FAIL_LED2_FLASH_CON4            ((uint32_t)(PM_BS+0x1e48))
#define PWR_FAIL_LED2_FLASH_CON5            ((uint32_t)(PM_BS+0x1e4a))
#define PWR_FAIL_LED2_FLASH_CON6            ((uint32_t)(PM_BS+0x1e4c))
#define PWR_FAIL_LED2_FLASH_CON7            ((uint32_t)(PM_BS+0x1e4e))
#define PWR_FAIL_LED2_FLASH_CON8            ((uint32_t)(PM_BS+0x1e50))
#define PWR_FAIL_LED2_FLASH_CON9            ((uint32_t)(PM_BS+0x1e52))
#define PWR_FAIL_LED2_FLASH_CON10           ((uint32_t)(PM_BS+0x1e54))
#define PWR_FW_LED2_MODE                    ((uint32_t)(PM_BS+0x1e56))
#define PWR_FW_LED2_FIX_CON                 ((uint32_t)(PM_BS+0x1e58))
#define PWR_FW_LED2_FLASH_CON0              ((uint32_t)(PM_BS+0x1e5a))
#define PWR_FW_LED2_FLASH_CON1              ((uint32_t)(PM_BS+0x1e5c))
#define PWR_FW_LED2_FLASH_CON2              ((uint32_t)(PM_BS+0x1e5e))
#define PWR_FW_LED2_FLASH_CON3              ((uint32_t)(PM_BS+0x1e60))
#define PWR_FW_LED2_FLASH_CON4              ((uint32_t)(PM_BS+0x1e62))
#define PWR_FW_LED2_FLASH_CON5              ((uint32_t)(PM_BS+0x1e64))
#define PWR_FW_LED2_FLASH_CON6              ((uint32_t)(PM_BS+0x1e66))
#define PWR_FW_LED2_FLASH_CON7              ((uint32_t)(PM_BS+0x1e68))
#define PWR_FW_LED2_FLASH_CON8              ((uint32_t)(PM_BS+0x1e6a))
#define PWR_FW_LED2_FLASH_CON9              ((uint32_t)(PM_BS+0x1e6c))
#define PWR_FW_LED2_FLASH_CON10             ((uint32_t)(PM_BS+0x1e6e))
#define LED3_APPLY_EN                       ((uint32_t)(PM_BS+0x1e88))
#define LED3_LOAD_DISABLE                   ((uint32_t)(PM_BS+0x1e8a))
#define LED3_MODE_CON                       ((uint32_t)(PM_BS+0x1e8c))
#define LED3_FIX_CON                        ((uint32_t)(PM_BS+0x1e8e))
#define LED3_FLASH_CON0                     ((uint32_t)(PM_BS+0x1e90))
#define LED3_FLASH_CON1                     ((uint32_t)(PM_BS+0x1e92))
#define LED3_FLASH_CON2                     ((uint32_t)(PM_BS+0x1e94))
#define LED3_FLASH_CON3                     ((uint32_t)(PM_BS+0x1e96))
#define LED3_FLASH_CON4                     ((uint32_t)(PM_BS+0x1e98))
#define LED3_FLASH_CON5                     ((uint32_t)(PM_BS+0x1e9a))
#define LED3_FLASH_CON6                     ((uint32_t)(PM_BS+0x1e9c))
#define LED3_FLASH_CON7                     ((uint32_t)(PM_BS+0x1e9e))
#define LED3_FLASH_CON8                     ((uint32_t)(PM_BS+0x1ea0))
#define LED3_FLASH_CON9                     ((uint32_t)(PM_BS+0x1ea2))
#define LED3_FLASH_CON10                    ((uint32_t)(PM_BS+0x1ea4))
#define LED3_ELR0                           ((uint32_t)(PM_BS+0x1ec4))
#define LED3_ELR1                           ((uint32_t)(PM_BS+0x1ec6))
#define LED3_ELR2                           ((uint32_t)(PM_BS+0x1ec8))
#define LED3_ELR3                           ((uint32_t)(PM_BS+0x1eca))
#define LED3_ELR4                           ((uint32_t)(PM_BS+0x1ecc))
#define LED3_ELR5                           ((uint32_t)(PM_BS+0x1ece))
#define LED3_ELR6                           ((uint32_t)(PM_BS+0x1ed0))
#define LED3_ELR7                           ((uint32_t)(PM_BS+0x1ed2))
#define LED3_ELR8                           ((uint32_t)(PM_BS+0x1ed4))
#define LED3_ELR9                           ((uint32_t)(PM_BS+0x1ed6))
#define LED3_ELR10                          ((uint32_t)(PM_BS+0x1ed8))
#define LED3_ELR11                          ((uint32_t)(PM_BS+0x1eda))
#define LED3_ELR12                          ((uint32_t)(PM_BS+0x1edc))
#define LED3_ELR13                          ((uint32_t)(PM_BS+0x1ede))
#define LED3_ELR14                          ((uint32_t)(PM_BS+0x1ee0))
#define LED3_ELR15                          ((uint32_t)(PM_BS+0x1ee2))
#define LED3_ELR16                          ((uint32_t)(PM_BS+0x1ee4))
#define LED3_ELR17                          ((uint32_t)(PM_BS+0x1ee6))
#define LED3_ELR18                          ((uint32_t)(PM_BS+0x1ee8))
#define LED3_ELR19                          ((uint32_t)(PM_BS+0x1eea))
#define LED3_ELR20                          ((uint32_t)(PM_BS+0x1eec))
#define LED3_ELR21                          ((uint32_t)(PM_BS+0x1eee))
#define LED3_ELR22                          ((uint32_t)(PM_BS+0x1ef0))
#define LED3_ELR23                          ((uint32_t)(PM_BS+0x1ef2))
#define PWR_OFF_LP_LED3_MODE                ((uint32_t)(PM_BS+0x1f08))
#define PWR_OFF_LP_LED3_FIX_CON             ((uint32_t)(PM_BS+0x1f0a))
#define PWR_OFF_LP_LED3_FLASH_CON0          ((uint32_t)(PM_BS+0x1f0c))
#define PWR_OFF_LP_LED3_FLASH_CON1          ((uint32_t)(PM_BS+0x1f0e))
#define PWR_OFF_LP_LED3_FLASH_CON2          ((uint32_t)(PM_BS+0x1f10))
#define PWR_OFF_LP_LED3_FLASH_CON3          ((uint32_t)(PM_BS+0x1f12))
#define PWR_OFF_LP_LED3_FLASH_CON4          ((uint32_t)(PM_BS+0x1f14))
#define PWR_OFF_LP_LED3_FLASH_CON5          ((uint32_t)(PM_BS+0x1f16))
#define PWR_OFF_LP_LED3_FLASH_CON6          ((uint32_t)(PM_BS+0x1f18))
#define PWR_OFF_LP_LED3_FLASH_CON7          ((uint32_t)(PM_BS+0x1f1a))
#define PWR_OFF_LP_LED3_FLASH_CON8          ((uint32_t)(PM_BS+0x1f1c))
#define PWR_OFF_LP_LED3_FLASH_CON9          ((uint32_t)(PM_BS+0x1f1e))
#define PWR_OFF_LP_LED3_FLASH_CON10         ((uint32_t)(PM_BS+0x1f20))
#define PWR_RB_LED3_MODE                    ((uint32_t)(PM_BS+0x1f22))
#define PWR_RB_LED3_FIX_CON                 ((uint32_t)(PM_BS+0x1f24))
#define PWR_RB_LED3_FLASH_CON0              ((uint32_t)(PM_BS+0x1f26))
#define PWR_RB_LED3_FLASH_CON1              ((uint32_t)(PM_BS+0x1f28))
#define PWR_RB_LED3_FLASH_CON2              ((uint32_t)(PM_BS+0x1f2a))
#define PWR_RB_LED3_FLASH_CON3              ((uint32_t)(PM_BS+0x1f2c))
#define PWR_RB_LED3_FLASH_CON4              ((uint32_t)(PM_BS+0x1f2e))
#define PWR_RB_LED3_FLASH_CON5              ((uint32_t)(PM_BS+0x1f30))
#define PWR_RB_LED3_FLASH_CON6              ((uint32_t)(PM_BS+0x1f32))
#define PWR_RB_LED3_FLASH_CON7              ((uint32_t)(PM_BS+0x1f34))
#define PWR_RB_LED3_FLASH_CON8              ((uint32_t)(PM_BS+0x1f36))
#define PWR_RB_LED3_FLASH_CON9              ((uint32_t)(PM_BS+0x1f38))
#define PWR_RB_LED3_FLASH_CON10             ((uint32_t)(PM_BS+0x1f3a))
#define PWR_FAIL_LED3_MODE                  ((uint32_t)(PM_BS+0x1f3c))
#define PWR_FAIL_LED3_FIX_CON               ((uint32_t)(PM_BS+0x1f3e))
#define PWR_FAIL_LED3_FLASH_CON0            ((uint32_t)(PM_BS+0x1f40))
#define PWR_FAIL_LED3_FLASH_CON1            ((uint32_t)(PM_BS+0x1f42))
#define PWR_FAIL_LED3_FLASH_CON2            ((uint32_t)(PM_BS+0x1f44))
#define PWR_FAIL_LED3_FLASH_CON3            ((uint32_t)(PM_BS+0x1f46))
#define PWR_FAIL_LED3_FLASH_CON4            ((uint32_t)(PM_BS+0x1f48))
#define PWR_FAIL_LED3_FLASH_CON5            ((uint32_t)(PM_BS+0x1f4a))
#define PWR_FAIL_LED3_FLASH_CON6            ((uint32_t)(PM_BS+0x1f4c))
#define PWR_FAIL_LED3_FLASH_CON7            ((uint32_t)(PM_BS+0x1f4e))
#define PWR_FAIL_LED3_FLASH_CON8            ((uint32_t)(PM_BS+0x1f50))
#define PWR_FAIL_LED3_FLASH_CON9            ((uint32_t)(PM_BS+0x1f52))
#define PWR_FAIL_LED3_FLASH_CON10           ((uint32_t)(PM_BS+0x1f54))
#define PWR_FW_LED3_MODE                    ((uint32_t)(PM_BS+0x1f56))
#define PWR_FW_LED3_FIX_CON                 ((uint32_t)(PM_BS+0x1f58))
#define PWR_FW_LED3_FLASH_CON0              ((uint32_t)(PM_BS+0x1f5a))
#define PWR_FW_LED3_FLASH_CON1              ((uint32_t)(PM_BS+0x1f5c))
#define PWR_FW_LED3_FLASH_CON2              ((uint32_t)(PM_BS+0x1f5e))
#define PWR_FW_LED3_FLASH_CON3              ((uint32_t)(PM_BS+0x1f60))
#define PWR_FW_LED3_FLASH_CON4              ((uint32_t)(PM_BS+0x1f62))
#define PWR_FW_LED3_FLASH_CON5              ((uint32_t)(PM_BS+0x1f64))
#define PWR_FW_LED3_FLASH_CON6              ((uint32_t)(PM_BS+0x1f66))
#define PWR_FW_LED3_FLASH_CON7              ((uint32_t)(PM_BS+0x1f68))
#define PWR_FW_LED3_FLASH_CON8              ((uint32_t)(PM_BS+0x1f6a))
#define PWR_FW_LED3_FLASH_CON9              ((uint32_t)(PM_BS+0x1f6c))
#define PWR_FW_LED3_FLASH_CON10             ((uint32_t)(PM_BS+0x1f6e))
#define PWM1_APPLY_EN                       ((uint32_t)(PM_BS+0x1f88))
#define PWM1_LOAD_DISABLE                   ((uint32_t)(PM_BS+0x1f8a))
#define PWM1_EN_CON                         ((uint32_t)(PM_BS+0x1f8c))
#define PWM1_CON0                           ((uint32_t)(PM_BS+0x1f8e))
#define PWR_OFF_LP_PWM1_EN                  ((uint32_t)(PM_BS+0x1f94))
#define PWR_OFF_LP_PWM1_CON0                ((uint32_t)(PM_BS+0x1f96))
#define PWR_RB_PWM1_EN                      ((uint32_t)(PM_BS+0x1f98))
#define PWR_RB_PWM1_CON0                    ((uint32_t)(PM_BS+0x1f9a))
#define PWR_FAIL_PWM1_EN                    ((uint32_t)(PM_BS+0x1f9c))
#define PWR_FAIL_PWM1_CON0                  ((uint32_t)(PM_BS+0x1f9e))
#define PWR_FW_PWM1_EN                      ((uint32_t)(PM_BS+0x1fa0))
#define PWR_FW_PWM1_CON0                    ((uint32_t)(PM_BS+0x1fa2))
#define PWM1_ELR0                           ((uint32_t)(PM_BS+0x1fa8))
#define PWM1_ELR1                           ((uint32_t)(PM_BS+0x1faa))
#define PWM2_APPLY_EN                       ((uint32_t)(PM_BS+0x200a))
#define PWM2_LOAD_DISABLE                   ((uint32_t)(PM_BS+0x200c))
#define PWM2_EN_CON                         ((uint32_t)(PM_BS+0x200e))
#define PWM2_CON0                           ((uint32_t)(PM_BS+0x2010))
#define PWM2_CON1                           ((uint32_t)(PM_BS+0x2012))
#define PWR_OFF_LP_PWM2_EN                  ((uint32_t)(PM_BS+0x201a))
#define PWR_OFF_LP_PWM2_CON0                ((uint32_t)(PM_BS+0x201c))
#define PWR_RB_PWM2_EN                      ((uint32_t)(PM_BS+0x201e))
#define PWR_RB_PWM2_CON0                    ((uint32_t)(PM_BS+0x2020))
#define PWR_FW_PWM2_EN                      ((uint32_t)(PM_BS+0x2022))
#define PWR_FW_PWM2_CON0                    ((uint32_t)(PM_BS+0x2024))
#define PWM2_ELR0                           ((uint32_t)(PM_BS+0x202a))
#define PWM2_ELR1                           ((uint32_t)(PM_BS+0x202c))
#define LED1_APPLY_EN_ADDR                  LED1_APPLY_EN
#define LED1_APPLY_EN_MASK                  0x1
#define LED1_APPLY_EN_SHIFT                 0
#define PWR_OFF_LP_LED1_LOAD_DISABLE_ADDR   LED1_LOAD_DISABLE
#define PWR_OFF_LP_LED1_LOAD_DISABLE_MASK   0x1
#define PWR_OFF_LP_LED1_LOAD_DISABLE_SHIFT  0
#define PWR_RB_LED1_LOAD_DISABLE_ADDR       LED1_LOAD_DISABLE
#define PWR_RB_LED1_LOAD_DISABLE_MASK       0x1
#define PWR_RB_LED1_LOAD_DISABLE_SHIFT      1
#define PWR_FAIL_LED1_LOAD_DISABLE_ADDR     LED1_LOAD_DISABLE
#define PWR_FAIL_LED1_LOAD_DISABLE_MASK     0x1
#define PWR_FAIL_LED1_LOAD_DISABLE_SHIFT    2
#define PWR_FW_LED1_LOAD_DISABLE_ADDR       LED1_LOAD_DISABLE
#define PWR_FW_LED1_LOAD_DISABLE_MASK       0x1
#define PWR_FW_LED1_LOAD_DISABLE_SHIFT      3
#define RG_LED1_MODE_ADDR                   LED1_MODE_CON
#define RG_LED1_MODE_MASK                   0x3
#define RG_LED1_MODE_SHIFT                  0
#define RG_LED1_DFIX_ADDR                   LED1_FIX_CON
#define RG_LED1_DFIX_MASK                   0x3FF
#define RG_LED1_DFIX_SHIFT                  0
#define RG_LED1_PSTART_ADDR                 LED1_FLASH_CON0
#define RG_LED1_PSTART_MASK                 0x7
#define RG_LED1_PSTART_SHIFT                0
#define RG_LED1_PEND_ADDR                   LED1_FLASH_CON0
#define RG_LED1_PEND_MASK                   0x7
#define RG_LED1_PEND_SHIFT                  3
#define RG_LED1_DH_ADDR                     LED1_FLASH_CON1
#define RG_LED1_DH_MASK                     0x3FF
#define RG_LED1_DH_SHIFT                    0
#define RG_LED1_DL_ADDR                     LED1_FLASH_CON2
#define RG_LED1_DL_MASK                     0x3FF
#define RG_LED1_DL_SHIFT                    0
#define RG_LED1_TH0_ADDR                    LED1_FLASH_CON3
#define RG_LED1_TH0_MASK                    0x3FF
#define RG_LED1_TH0_SHIFT                   0
#define RG_LED1_TL0_ADDR                    LED1_FLASH_CON4
#define RG_LED1_TL0_MASK                    0x3FF
#define RG_LED1_TL0_SHIFT                   0
#define RG_LED1_TR0_ADDR                    LED1_FLASH_CON5
#define RG_LED1_TR0_MASK                    0x3FF
#define RG_LED1_TR0_SHIFT                   0
#define RG_LED1_TF0_ADDR                    LED1_FLASH_CON6
#define RG_LED1_TF0_MASK                    0x3FF
#define RG_LED1_TF0_SHIFT                   0
#define RG_LED1_TH_ADDR                     LED1_FLASH_CON7
#define RG_LED1_TH_MASK                     0x3FF
#define RG_LED1_TH_SHIFT                    0
#define RG_LED1_TL_ADDR                     LED1_FLASH_CON8
#define RG_LED1_TL_MASK                     0x3FF
#define RG_LED1_TL_SHIFT                    0
#define RG_LED1_TR_ADDR                     LED1_FLASH_CON9
#define RG_LED1_TR_MASK                     0x3FF
#define RG_LED1_TR_SHIFT                    0
#define RG_LED1_TF_ADDR                     LED1_FLASH_CON10
#define RG_LED1_TF_MASK                     0x3FF
#define RG_LED1_TF_SHIFT                    0
#define PWR_BY_LED1_LOAD_DISABLE_ADDR       LED1_ELR0
#define PWR_BY_LED1_LOAD_DISABLE_MASK       0x1
#define PWR_BY_LED1_LOAD_DISABLE_SHIFT      0
#define PWR_ON_LED1_LOAD_DISABLE_ADDR       LED1_ELR0
#define PWR_ON_LED1_LOAD_DISABLE_MASK       0x1
#define PWR_ON_LED1_LOAD_DISABLE_SHIFT      1
#define PWR_BY_LED1_MODE_ADDR               LED1_ELR0
#define PWR_BY_LED1_MODE_MASK               0x3
#define PWR_BY_LED1_MODE_SHIFT              2
#define PWR_BY_LED1_DFIX_ADDR               LED1_ELR0
#define PWR_BY_LED1_DFIX_MASK               0x3FF
#define PWR_BY_LED1_DFIX_SHIFT              4
#define LED1_ELR_RSV0_ADDR                  LED1_ELR0
#define LED1_ELR_RSV0_MASK                  0x3
#define LED1_ELR_RSV0_SHIFT                 14
#define PWR_BY_LED1_PSTART_ADDR             LED1_ELR1
#define PWR_BY_LED1_PSTART_MASK             0x7
#define PWR_BY_LED1_PSTART_SHIFT            0
#define PWR_BY_LED1_PEND_ADDR               LED1_ELR1
#define PWR_BY_LED1_PEND_MASK               0x7
#define PWR_BY_LED1_PEND_SHIFT              3
#define LED1_ELR_RSV1_ADDR                  LED1_ELR1
#define LED1_ELR_RSV1_MASK                  0x3FF
#define LED1_ELR_RSV1_SHIFT                 6
#define PWR_BY_LED1_DH_ADDR                 LED1_ELR2
#define PWR_BY_LED1_DH_MASK                 0x3FF
#define PWR_BY_LED1_DH_SHIFT                0
#define PWR_BY_LED1_DL_ADDR                 LED1_ELR3
#define PWR_BY_LED1_DL_MASK                 0x3FF
#define PWR_BY_LED1_DL_SHIFT                0
#define PWR_BY_LED1_TH0_ADDR                LED1_ELR4
#define PWR_BY_LED1_TH0_MASK                0x3FF
#define PWR_BY_LED1_TH0_SHIFT               0
#define PWR_BY_LED1_TL0_ADDR                LED1_ELR5
#define PWR_BY_LED1_TL0_MASK                0x3FF
#define PWR_BY_LED1_TL0_SHIFT               0
#define PWR_BY_LED1_TR0_ADDR                LED1_ELR6
#define PWR_BY_LED1_TR0_MASK                0x3FF
#define PWR_BY_LED1_TR0_SHIFT               0
#define PWR_BY_LED1_TF0_ADDR                LED1_ELR7
#define PWR_BY_LED1_TF0_MASK                0x3FF
#define PWR_BY_LED1_TF0_SHIFT               0
#define PWR_BY_LED1_TH_ADDR                 LED1_ELR8
#define PWR_BY_LED1_TH_MASK                 0x3FF
#define PWR_BY_LED1_TH_SHIFT                0
#define PWR_BY_LED1_TL_ADDR                 LED1_ELR9
#define PWR_BY_LED1_TL_MASK                 0x3FF
#define PWR_BY_LED1_TL_SHIFT                0
#define PWR_BY_LED1_TR_ADDR                 LED1_ELR10
#define PWR_BY_LED1_TR_MASK                 0x3FF
#define PWR_BY_LED1_TR_SHIFT                0
#define PWR_BY_LED1_TF_ADDR                 LED1_ELR11
#define PWR_BY_LED1_TF_MASK                 0x3FF
#define PWR_BY_LED1_TF_SHIFT                0
#define PWR_ON_LED1_MODE_ADDR               LED1_ELR12
#define PWR_ON_LED1_MODE_MASK               0x3
#define PWR_ON_LED1_MODE_SHIFT              0
#define PWR_ON_LED1_DFIX_ADDR               LED1_ELR12
#define PWR_ON_LED1_DFIX_MASK               0x3FF
#define PWR_ON_LED1_DFIX_SHIFT              2
#define LED1_ELR_RSV2_ADDR                  LED1_ELR12
#define LED1_ELR_RSV2_MASK                  0xF
#define LED1_ELR_RSV2_SHIFT                 12
#define PWR_ON_LED1_PSTART_ADDR             LED1_ELR13
#define PWR_ON_LED1_PSTART_MASK             0x7
#define PWR_ON_LED1_PSTART_SHIFT            0
#define PWR_ON_LED1_PEND_ADDR               LED1_ELR13
#define PWR_ON_LED1_PEND_MASK               0x7
#define PWR_ON_LED1_PEND_SHIFT              3
#define LED1_ELR_RSV3_ADDR                  LED1_ELR13
#define LED1_ELR_RSV3_MASK                  0x3FF
#define LED1_ELR_RSV3_SHIFT                 6
#define PWR_ON_LED1_DH_ADDR                 LED1_ELR14
#define PWR_ON_LED1_DH_MASK                 0x3FF
#define PWR_ON_LED1_DH_SHIFT                0
#define PWR_ON_LED1_DL_ADDR                 LED1_ELR15
#define PWR_ON_LED1_DL_MASK                 0x3FF
#define PWR_ON_LED1_DL_SHIFT                0
#define PWR_ON_LED1_TH0_ADDR                LED1_ELR16
#define PWR_ON_LED1_TH0_MASK                0x3FF
#define PWR_ON_LED1_TH0_SHIFT               0
#define PWR_ON_LED1_TL0_ADDR                LED1_ELR17
#define PWR_ON_LED1_TL0_MASK                0x3FF
#define PWR_ON_LED1_TL0_SHIFT               0
#define PWR_ON_LED1_TR0_ADDR                LED1_ELR18
#define PWR_ON_LED1_TR0_MASK                0x3FF
#define PWR_ON_LED1_TR0_SHIFT               0
#define PWR_ON_LED1_TF0_ADDR                LED1_ELR19
#define PWR_ON_LED1_TF0_MASK                0x3FF
#define PWR_ON_LED1_TF0_SHIFT               0
#define PWR_ON_LED1_TH_ADDR                 LED1_ELR20
#define PWR_ON_LED1_TH_MASK                 0x3FF
#define PWR_ON_LED1_TH_SHIFT                0
#define PWR_ON_LED1_TL_ADDR                 LED1_ELR21
#define PWR_ON_LED1_TL_MASK                 0x3FF
#define PWR_ON_LED1_TL_SHIFT                0
#define PWR_ON_LED1_TR_ADDR                 LED1_ELR22
#define PWR_ON_LED1_TR_MASK                 0x3FF
#define PWR_ON_LED1_TR_SHIFT                0
#define PWR_ON_LED1_TF_ADDR                 LED1_ELR23
#define PWR_ON_LED1_TF_MASK                 0x3FF
#define PWR_ON_LED1_TF_SHIFT                0
#define PWR_OFF_LP_LED1_MODE_ADDR           PWR_OFF_LP_LED1_MODE
#define PWR_OFF_LP_LED1_MODE_MASK           0x3
#define PWR_OFF_LP_LED1_MODE_SHIFT          0
#define PWR_OFF_LP_LED1_DFIX_ADDR           PWR_OFF_LP_LED1_FIX_CON
#define PWR_OFF_LP_LED1_DFIX_MASK           0x3FF
#define PWR_OFF_LP_LED1_DFIX_SHIFT          0
#define PWR_OFF_LP_LED1_PSTART_ADDR         PWR_OFF_LP_LED1_FLASH_CON0
#define PWR_OFF_LP_LED1_PSTART_MASK         0x7
#define PWR_OFF_LP_LED1_PSTART_SHIFT        0
#define PWR_OFF_LP_LED1_PEND_ADDR           PWR_OFF_LP_LED1_FLASH_CON0
#define PWR_OFF_LP_LED1_PEND_MASK           0x7
#define PWR_OFF_LP_LED1_PEND_SHIFT          3
#define PWR_OFF_LP_LED1_DH_ADDR             PWR_OFF_LP_LED1_FLASH_CON1
#define PWR_OFF_LP_LED1_DH_MASK             0x3FF
#define PWR_OFF_LP_LED1_DH_SHIFT            0
#define PWR_OFF_LP_LED1_DL_ADDR             PWR_OFF_LP_LED1_FLASH_CON2
#define PWR_OFF_LP_LED1_DL_MASK             0x3FF
#define PWR_OFF_LP_LED1_DL_SHIFT            0
#define PWR_OFF_LP_LED1_TH0_ADDR            PWR_OFF_LP_LED1_FLASH_CON3
#define PWR_OFF_LP_LED1_TH0_MASK            0x3FF
#define PWR_OFF_LP_LED1_TH0_SHIFT           0
#define PWR_OFF_LP_LED1_TL0_ADDR            PWR_OFF_LP_LED1_FLASH_CON4
#define PWR_OFF_LP_LED1_TL0_MASK            0x3FF
#define PWR_OFF_LP_LED1_TL0_SHIFT           0
#define PWR_OFF_LP_LED1_TR0_ADDR            PWR_OFF_LP_LED1_FLASH_CON5
#define PWR_OFF_LP_LED1_TR0_MASK            0x3FF
#define PWR_OFF_LP_LED1_TR0_SHIFT           0
#define PWR_OFF_LP_LED1_TF0_ADDR            PWR_OFF_LP_LED1_FLASH_CON6
#define PWR_OFF_LP_LED1_TF0_MASK            0x3FF
#define PWR_OFF_LP_LED1_TF0_SHIFT           0
#define PWR_OFF_LP_LED1_TH_ADDR             PWR_OFF_LP_LED1_FLASH_CON7
#define PWR_OFF_LP_LED1_TH_MASK             0x3FF
#define PWR_OFF_LP_LED1_TH_SHIFT            0
#define PWR_OFF_LP_LED1_TL_ADDR             PWR_OFF_LP_LED1_FLASH_CON8
#define PWR_OFF_LP_LED1_TL_MASK             0x3FF
#define PWR_OFF_LP_LED1_TL_SHIFT            0
#define PWR_OFF_LP_LED1_TR_ADDR             PWR_OFF_LP_LED1_FLASH_CON9
#define PWR_OFF_LP_LED1_TR_MASK             0x3FF
#define PWR_OFF_LP_LED1_TR_SHIFT            0
#define PWR_OFF_LP_LED1_TF_ADDR             PWR_OFF_LP_LED1_FLASH_CON10
#define PWR_OFF_LP_LED1_TF_MASK             0x3FF
#define PWR_OFF_LP_LED1_TF_SHIFT            0
#define PWR_RB_LED1_MODE_ADDR               PWR_RB_LED1_MODE
#define PWR_RB_LED1_MODE_MASK               0x3
#define PWR_RB_LED1_MODE_SHIFT              0
#define PWR_RB_LED1_DFIX_ADDR               PWR_RB_LED1_FIX_CON
#define PWR_RB_LED1_DFIX_MASK               0x3FF
#define PWR_RB_LED1_DFIX_SHIFT              0
#define PWR_RB_LED1_PSTART_ADDR             PWR_RB_LED1_FLASH_CON0
#define PWR_RB_LED1_PSTART_MASK             0x7
#define PWR_RB_LED1_PSTART_SHIFT            0
#define PWR_RB_LED1_PEND_ADDR               PWR_RB_LED1_FLASH_CON0
#define PWR_RB_LED1_PEND_MASK               0x7
#define PWR_RB_LED1_PEND_SHIFT              3
#define PWR_RB_LED1_DH_ADDR                 PWR_RB_LED1_FLASH_CON1
#define PWR_RB_LED1_DH_MASK                 0x3FF
#define PWR_RB_LED1_DH_SHIFT                0
#define PWR_RB_LED1_DL_ADDR                 PWR_RB_LED1_FLASH_CON2
#define PWR_RB_LED1_DL_MASK                 0x3FF
#define PWR_RB_LED1_DL_SHIFT                0
#define PWR_RB_LED1_TH0_ADDR                PWR_RB_LED1_FLASH_CON3
#define PWR_RB_LED1_TH0_MASK                0x3FF
#define PWR_RB_LED1_TH0_SHIFT               0
#define PWR_RB_LED1_TL0_ADDR                PWR_RB_LED1_FLASH_CON4
#define PWR_RB_LED1_TL0_MASK                0x3FF
#define PWR_RB_LED1_TL0_SHIFT               0
#define PWR_RB_LED1_TR0_ADDR                PWR_RB_LED1_FLASH_CON5
#define PWR_RB_LED1_TR0_MASK                0x3FF
#define PWR_RB_LED1_TR0_SHIFT               0
#define PWR_RB_LED1_TF0_ADDR                PWR_RB_LED1_FLASH_CON6
#define PWR_RB_LED1_TF0_MASK                0x3FF
#define PWR_RB_LED1_TF0_SHIFT               0
#define PWR_RB_LED1_TH_ADDR                 PWR_RB_LED1_FLASH_CON7
#define PWR_RB_LED1_TH_MASK                 0x3FF
#define PWR_RB_LED1_TH_SHIFT                0
#define PWR_RB_LED1_TL_ADDR                 PWR_RB_LED1_FLASH_CON8
#define PWR_RB_LED1_TL_MASK                 0x3FF
#define PWR_RB_LED1_TL_SHIFT                0
#define PWR_RB_LED1_TR_ADDR                 PWR_RB_LED1_FLASH_CON9
#define PWR_RB_LED1_TR_MASK                 0x3FF
#define PWR_RB_LED1_TR_SHIFT                0
#define PWR_RB_LED1_TF_ADDR                 PWR_RB_LED1_FLASH_CON10
#define PWR_RB_LED1_TF_MASK                 0x3FF
#define PWR_RB_LED1_TF_SHIFT                0
#define PWR_FAIL_LED1_MODE_ADDR             PWR_FAIL_LED1_MODE
#define PWR_FAIL_LED1_MODE_MASK             0x3
#define PWR_FAIL_LED1_MODE_SHIFT            0
#define PWR_FAIL_LED1_DFIX_ADDR             PWR_FAIL_LED1_FIX_CON
#define PWR_FAIL_LED1_DFIX_MASK             0x3FF
#define PWR_FAIL_LED1_DFIX_SHIFT            0
#define PWR_FAIL_LED1_PSTART_ADDR           PWR_FAIL_LED1_FLASH_CON0
#define PWR_FAIL_LED1_PSTART_MASK           0x7
#define PWR_FAIL_LED1_PSTART_SHIFT          0
#define PWR_FAIL_LED1_PEND_ADDR             PWR_FAIL_LED1_FLASH_CON0
#define PWR_FAIL_LED1_PEND_MASK             0x7
#define PWR_FAIL_LED1_PEND_SHIFT            3
#define PWR_FAIL_LED1_DH_ADDR               PWR_FAIL_LED1_FLASH_CON1
#define PWR_FAIL_LED1_DH_MASK               0x3FF
#define PWR_FAIL_LED1_DH_SHIFT              0
#define PWR_FAIL_LED1_DL_ADDR               PWR_FAIL_LED1_FLASH_CON2
#define PWR_FAIL_LED1_DL_MASK               0x3FF
#define PWR_FAIL_LED1_DL_SHIFT              0
#define PWR_FAIL_LED1_TH0_ADDR              PWR_FAIL_LED1_FLASH_CON3
#define PWR_FAIL_LED1_TH0_MASK              0x3FF
#define PWR_FAIL_LED1_TH0_SHIFT             0
#define PWR_FAIL_LED1_TL0_ADDR              PWR_FAIL_LED1_FLASH_CON4
#define PWR_FAIL_LED1_TL0_MASK              0x3FF
#define PWR_FAIL_LED1_TL0_SHIFT             0
#define PWR_FAIL_LED1_TR0_ADDR              PWR_FAIL_LED1_FLASH_CON5
#define PWR_FAIL_LED1_TR0_MASK              0x3FF
#define PWR_FAIL_LED1_TR0_SHIFT             0
#define PWR_FAIL_LED1_TF0_ADDR              PWR_FAIL_LED1_FLASH_CON6
#define PWR_FAIL_LED1_TF0_MASK              0x3FF
#define PWR_FAIL_LED1_TF0_SHIFT             0
#define PWR_FAIL_LED1_TH_ADDR               PWR_FAIL_LED1_FLASH_CON7
#define PWR_FAIL_LED1_TH_MASK               0x3FF
#define PWR_FAIL_LED1_TH_SHIFT              0
#define PWR_FAIL_LED1_TL_ADDR               PWR_FAIL_LED1_FLASH_CON8
#define PWR_FAIL_LED1_TL_MASK               0x3FF
#define PWR_FAIL_LED1_TL_SHIFT              0
#define PWR_FAIL_LED1_TR_ADDR               PWR_FAIL_LED1_FLASH_CON9
#define PWR_FAIL_LED1_TR_MASK               0x3FF
#define PWR_FAIL_LED1_TR_SHIFT              0
#define PWR_FAIL_LED1_TF_ADDR               PWR_FAIL_LED1_FLASH_CON10
#define PWR_FAIL_LED1_TF_MASK               0x3FF
#define PWR_FAIL_LED1_TF_SHIFT              0
#define PWR_FW_LED1_MODE_ADDR               PWR_FW_LED1_MODE
#define PWR_FW_LED1_MODE_MASK               0x3
#define PWR_FW_LED1_MODE_SHIFT              0
#define PWR_FW_LED1_DFIX_ADDR               PWR_FW_LED1_FIX_CON
#define PWR_FW_LED1_DFIX_MASK               0x3FF
#define PWR_FW_LED1_DFIX_SHIFT              0
#define PWR_FW_LED1_PSTART_ADDR             PWR_FW_LED1_FLASH_CON0
#define PWR_FW_LED1_PSTART_MASK             0x7
#define PWR_FW_LED1_PSTART_SHIFT            0
#define PWR_FW_LED1_PEND_ADDR               PWR_FW_LED1_FLASH_CON0
#define PWR_FW_LED1_PEND_MASK               0x7
#define PWR_FW_LED1_PEND_SHIFT              3
#define PWR_FW_LED1_TH0_ADDR                PWR_FW_LED1_FLASH_CON1
#define PWR_FW_LED1_TH0_MASK                0x3FF
#define PWR_FW_LED1_TH0_SHIFT               0
#define PWR_FW_LED1_TL0_ADDR                PWR_FW_LED1_FLASH_CON2
#define PWR_FW_LED1_TL0_MASK                0x3FF
#define PWR_FW_LED1_TL0_SHIFT               0
#define PWR_FW_LED1_TR0_ADDR                PWR_FW_LED1_FLASH_CON3
#define PWR_FW_LED1_TR0_MASK                0x3FF
#define PWR_FW_LED1_TR0_SHIFT               0
#define PWR_FW_LED1_TF0_ADDR                PWR_FW_LED1_FLASH_CON4
#define PWR_FW_LED1_TF0_MASK                0x3FF
#define PWR_FW_LED1_TF0_SHIFT               0
#define PWR_FW_LED1_DH_ADDR                 PWR_FW_LED1_FLASH_CON5
#define PWR_FW_LED1_DH_MASK                 0x3FF
#define PWR_FW_LED1_DH_SHIFT                0
#define PWR_FW_LED1_TH_ADDR                 PWR_FW_LED1_FLASH_CON6
#define PWR_FW_LED1_TH_MASK                 0x3FF
#define PWR_FW_LED1_TH_SHIFT                0
#define PWR_FW_LED1_DL_ADDR                 PWR_FW_LED1_FLASH_CON7
#define PWR_FW_LED1_DL_MASK                 0x3FF
#define PWR_FW_LED1_DL_SHIFT                0
#define PWR_FW_LED1_TL_ADDR                 PWR_FW_LED1_FLASH_CON8
#define PWR_FW_LED1_TL_MASK                 0x3FF
#define PWR_FW_LED1_TL_SHIFT                0
#define PWR_FW_LED1_TR_ADDR                 PWR_FW_LED1_FLASH_CON9
#define PWR_FW_LED1_TR_MASK                 0x3FF
#define PWR_FW_LED1_TR_SHIFT                0
#define PWR_FW_LED1_TF_ADDR                 PWR_FW_LED1_FLASH_CON10
#define PWR_FW_LED1_TF_MASK                 0x3FF
#define PWR_FW_LED1_TF_SHIFT                0
#define LED2_APPLY_EN_ADDR                  LED2_APPLY_EN
#define LED2_APPLY_EN_MASK                  0x1
#define LED2_APPLY_EN_SHIFT                 0
#define PWR_OFF_LP_LED2_LOAD_DISABLE_ADDR   LED2_LOAD_DISABLE
#define PWR_OFF_LP_LED2_LOAD_DISABLE_MASK   0x1
#define PWR_OFF_LP_LED2_LOAD_DISABLE_SHIFT  0
#define PWR_RB_LED2_LOAD_DISABLE_ADDR       LED2_LOAD_DISABLE
#define PWR_RB_LED2_LOAD_DISABLE_MASK       0x1
#define PWR_RB_LED2_LOAD_DISABLE_SHIFT      1
#define PWR_FAIL_LED2_LOAD_DISABLE_ADDR     LED2_LOAD_DISABLE
#define PWR_FAIL_LED2_LOAD_DISABLE_MASK     0x1
#define PWR_FAIL_LED2_LOAD_DISABLE_SHIFT    2
#define PWR_FW_LED2_LOAD_DISABLE_ADDR       LED2_LOAD_DISABLE
#define PWR_FW_LED2_LOAD_DISABLE_MASK       0x1
#define PWR_FW_LED2_LOAD_DISABLE_SHIFT      3
#define RG_LED2_MODE_ADDR                   LED2_MODE_CON
#define RG_LED2_MODE_MASK                   0x3
#define RG_LED2_MODE_SHIFT                  0
#define RG_LED2_DFIX_ADDR                   LED2_FIX_CON
#define RG_LED2_DFIX_MASK                   0x3FF
#define RG_LED2_DFIX_SHIFT                  0
#define RG_LED2_PSTART_ADDR                 LED2_FLASH_CON0
#define RG_LED2_PSTART_MASK                 0x7
#define RG_LED2_PSTART_SHIFT                0
#define RG_LED2_PEND_ADDR                   LED2_FLASH_CON0
#define RG_LED2_PEND_MASK                   0x7
#define RG_LED2_PEND_SHIFT                  3
#define RG_LED2_DH_ADDR                     LED2_FLASH_CON1
#define RG_LED2_DH_MASK                     0x3FF
#define RG_LED2_DH_SHIFT                    0
#define RG_LED2_DL_ADDR                     LED2_FLASH_CON2
#define RG_LED2_DL_MASK                     0x3FF
#define RG_LED2_DL_SHIFT                    0
#define RG_LED2_TH0_ADDR                    LED2_FLASH_CON3
#define RG_LED2_TH0_MASK                    0x3FF
#define RG_LED2_TH0_SHIFT                   0
#define RG_LED2_TL0_ADDR                    LED2_FLASH_CON4
#define RG_LED2_TL0_MASK                    0x3FF
#define RG_LED2_TL0_SHIFT                   0
#define RG_LED2_TR0_ADDR                    LED2_FLASH_CON5
#define RG_LED2_TR0_MASK                    0x3FF
#define RG_LED2_TR0_SHIFT                   0
#define RG_LED2_TF0_ADDR                    LED2_FLASH_CON6
#define RG_LED2_TF0_MASK                    0x3FF
#define RG_LED2_TF0_SHIFT                   0
#define RG_LED2_TH_ADDR                     LED2_FLASH_CON7
#define RG_LED2_TH_MASK                     0x3FF
#define RG_LED2_TH_SHIFT                    0
#define RG_LED2_TL_ADDR                     LED2_FLASH_CON8
#define RG_LED2_TL_MASK                     0x3FF
#define RG_LED2_TL_SHIFT                    0
#define RG_LED2_TR_ADDR                     LED2_FLASH_CON9
#define RG_LED2_TR_MASK                     0x3FF
#define RG_LED2_TR_SHIFT                    0
#define RG_LED2_TF_ADDR                     LED2_FLASH_CON10
#define RG_LED2_TF_MASK                     0x3FF
#define RG_LED2_TF_SHIFT                    0
#define PWR_BY_LED2_LOAD_DISABLE_ADDR       LED2_ELR0
#define PWR_BY_LED2_LOAD_DISABLE_MASK       0x1
#define PWR_BY_LED2_LOAD_DISABLE_SHIFT      0
#define PWR_ON_LED2_LOAD_DISABLE_ADDR       LED2_ELR0
#define PWR_ON_LED2_LOAD_DISABLE_MASK       0x1
#define PWR_ON_LED2_LOAD_DISABLE_SHIFT      1
#define PWR_BY_LED2_MODE_ADDR               LED2_ELR0
#define PWR_BY_LED2_MODE_MASK               0x3
#define PWR_BY_LED2_MODE_SHIFT              2
#define PWR_BY_LED2_DFIX_ADDR               LED2_ELR0
#define PWR_BY_LED2_DFIX_MASK               0x3FF
#define PWR_BY_LED2_DFIX_SHIFT              4
#define LED2_ELR_RSV0_ADDR                  LED2_ELR0
#define LED2_ELR_RSV0_MASK                  0x3
#define LED2_ELR_RSV0_SHIFT                 14
#define PWR_BY_LED2_PSTART_ADDR             LED2_ELR1
#define PWR_BY_LED2_PSTART_MASK             0x7
#define PWR_BY_LED2_PSTART_SHIFT            0
#define PWR_BY_LED2_PEND_ADDR               LED2_ELR1
#define PWR_BY_LED2_PEND_MASK               0x7
#define PWR_BY_LED2_PEND_SHIFT              3
#define LED2_ELR_RSV1_ADDR                  LED2_ELR1
#define LED2_ELR_RSV1_MASK                  0x3FF
#define LED2_ELR_RSV1_SHIFT                 6
#define PWR_BY_LED2_DH_ADDR                 LED2_ELR2
#define PWR_BY_LED2_DH_MASK                 0x3FF
#define PWR_BY_LED2_DH_SHIFT                0
#define PWR_BY_LED2_DL_ADDR                 LED2_ELR3
#define PWR_BY_LED2_DL_MASK                 0x3FF
#define PWR_BY_LED2_DL_SHIFT                0
#define PWR_BY_LED2_TH0_ADDR                LED2_ELR4
#define PWR_BY_LED2_TH0_MASK                0x3FF
#define PWR_BY_LED2_TH0_SHIFT               0
#define PWR_BY_LED2_TL0_ADDR                LED2_ELR5
#define PWR_BY_LED2_TL0_MASK                0x3FF
#define PWR_BY_LED2_TL0_SHIFT               0
#define PWR_BY_LED2_TR0_ADDR                LED2_ELR6
#define PWR_BY_LED2_TR0_MASK                0x3FF
#define PWR_BY_LED2_TR0_SHIFT               0
#define PWR_BY_LED2_TF0_ADDR                LED2_ELR7
#define PWR_BY_LED2_TF0_MASK                0x3FF
#define PWR_BY_LED2_TF0_SHIFT               0
#define PWR_BY_LED2_TH_ADDR                 LED2_ELR8
#define PWR_BY_LED2_TH_MASK                 0x3FF
#define PWR_BY_LED2_TH_SHIFT                0
#define PWR_BY_LED2_TL_ADDR                 LED2_ELR9
#define PWR_BY_LED2_TL_MASK                 0x3FF
#define PWR_BY_LED2_TL_SHIFT                0
#define PWR_BY_LED2_TR_ADDR                 LED2_ELR10
#define PWR_BY_LED2_TR_MASK                 0x3FF
#define PWR_BY_LED2_TR_SHIFT                0
#define PWR_BY_LED2_TF_ADDR                 LED2_ELR11
#define PWR_BY_LED2_TF_MASK                 0x3FF
#define PWR_BY_LED2_TF_SHIFT                0
#define PWR_ON_LED2_MODE_ADDR               LED2_ELR12
#define PWR_ON_LED2_MODE_MASK               0x3
#define PWR_ON_LED2_MODE_SHIFT              0
#define PWR_ON_LED2_DFIX_ADDR               LED2_ELR12
#define PWR_ON_LED2_DFIX_MASK               0x3FF
#define PWR_ON_LED2_DFIX_SHIFT              2
#define LED2_ELR_RSV2_ADDR                  LED2_ELR12
#define LED2_ELR_RSV2_MASK                  0xF
#define LED2_ELR_RSV2_SHIFT                 12
#define PWR_ON_LED2_PSTART_ADDR             LED2_ELR13
#define PWR_ON_LED2_PSTART_MASK             0x7
#define PWR_ON_LED2_PSTART_SHIFT            0
#define PWR_ON_LED2_PEND_ADDR               LED2_ELR13
#define PWR_ON_LED2_PEND_MASK               0x7
#define PWR_ON_LED2_PEND_SHIFT              3
#define LED2_ELR_RSV3_ADDR                  LED2_ELR13
#define LED2_ELR_RSV3_MASK                  0x3FF
#define LED2_ELR_RSV3_SHIFT                 6
#define PWR_ON_LED2_DH_ADDR                 LED2_ELR14
#define PWR_ON_LED2_DH_MASK                 0x3FF
#define PWR_ON_LED2_DH_SHIFT                0
#define PWR_ON_LED2_DL_ADDR                 LED2_ELR15
#define PWR_ON_LED2_DL_MASK                 0x3FF
#define PWR_ON_LED2_DL_SHIFT                0
#define PWR_ON_LED2_TH0_ADDR                LED2_ELR16
#define PWR_ON_LED2_TH0_MASK                0x3FF
#define PWR_ON_LED2_TH0_SHIFT               0
#define PWR_ON_LED2_TL0_ADDR                LED2_ELR17
#define PWR_ON_LED2_TL0_MASK                0x3FF
#define PWR_ON_LED2_TL0_SHIFT               0
#define PWR_ON_LED2_TR0_ADDR                LED2_ELR18
#define PWR_ON_LED2_TR0_MASK                0x3FF
#define PWR_ON_LED2_TR0_SHIFT               0
#define PWR_ON_LED2_TF0_ADDR                LED2_ELR19
#define PWR_ON_LED2_TF0_MASK                0x3FF
#define PWR_ON_LED2_TF0_SHIFT               0
#define PWR_ON_LED2_TH_ADDR                 LED2_ELR20
#define PWR_ON_LED2_TH_MASK                 0x3FF
#define PWR_ON_LED2_TH_SHIFT                0
#define PWR_ON_LED2_TL_ADDR                 LED2_ELR21
#define PWR_ON_LED2_TL_MASK                 0x3FF
#define PWR_ON_LED2_TL_SHIFT                0
#define PWR_ON_LED2_TR_ADDR                 LED2_ELR22
#define PWR_ON_LED2_TR_MASK                 0x3FF
#define PWR_ON_LED2_TR_SHIFT                0
#define PWR_ON_LED2_TF_ADDR                 LED2_ELR23
#define PWR_ON_LED2_TF_MASK                 0x3FF
#define PWR_ON_LED2_TF_SHIFT                0
#define PWR_OFF_LP_LED2_MODE_ADDR           PWR_OFF_LP_LED2_MODE
#define PWR_OFF_LP_LED2_MODE_MASK           0x3
#define PWR_OFF_LP_LED2_MODE_SHIFT          0
#define PWR_OFF_LP_LED2_DFIX_ADDR           PWR_OFF_LP_LED2_FIX_CON
#define PWR_OFF_LP_LED2_DFIX_MASK           0x3FF
#define PWR_OFF_LP_LED2_DFIX_SHIFT          0
#define PWR_OFF_LP_LED2_PSTART_ADDR         PWR_OFF_LP_LED2_FLASH_CON0
#define PWR_OFF_LP_LED2_PSTART_MASK         0x7
#define PWR_OFF_LP_LED2_PSTART_SHIFT        0
#define PWR_OFF_LP_LED2_PEND_ADDR           PWR_OFF_LP_LED2_FLASH_CON0
#define PWR_OFF_LP_LED2_PEND_MASK           0x7
#define PWR_OFF_LP_LED2_PEND_SHIFT          3
#define PWR_OFF_LP_LED2_DH_ADDR             PWR_OFF_LP_LED2_FLASH_CON1
#define PWR_OFF_LP_LED2_DH_MASK             0x3FF
#define PWR_OFF_LP_LED2_DH_SHIFT            0
#define PWR_OFF_LP_LED2_DL_ADDR             PWR_OFF_LP_LED2_FLASH_CON2
#define PWR_OFF_LP_LED2_DL_MASK             0x3FF
#define PWR_OFF_LP_LED2_DL_SHIFT            0
#define PWR_OFF_LP_LED2_TH0_ADDR            PWR_OFF_LP_LED2_FLASH_CON3
#define PWR_OFF_LP_LED2_TH0_MASK            0x3FF
#define PWR_OFF_LP_LED2_TH0_SHIFT           0
#define PWR_OFF_LP_LED2_TL0_ADDR            PWR_OFF_LP_LED2_FLASH_CON4
#define PWR_OFF_LP_LED2_TL0_MASK            0x3FF
#define PWR_OFF_LP_LED2_TL0_SHIFT           0
#define PWR_OFF_LP_LED2_TR0_ADDR            PWR_OFF_LP_LED2_FLASH_CON5
#define PWR_OFF_LP_LED2_TR0_MASK            0x3FF
#define PWR_OFF_LP_LED2_TR0_SHIFT           0
#define PWR_OFF_LP_LED2_TF0_ADDR            PWR_OFF_LP_LED2_FLASH_CON6
#define PWR_OFF_LP_LED2_TF0_MASK            0x3FF
#define PWR_OFF_LP_LED2_TF0_SHIFT           0
#define PWR_OFF_LP_LED2_TH_ADDR             PWR_OFF_LP_LED2_FLASH_CON7
#define PWR_OFF_LP_LED2_TH_MASK             0x3FF
#define PWR_OFF_LP_LED2_TH_SHIFT            0
#define PWR_OFF_LP_LED2_TL_ADDR             PWR_OFF_LP_LED2_FLASH_CON8
#define PWR_OFF_LP_LED2_TL_MASK             0x3FF
#define PWR_OFF_LP_LED2_TL_SHIFT            0
#define PWR_OFF_LP_LED2_TR_ADDR             PWR_OFF_LP_LED2_FLASH_CON9
#define PWR_OFF_LP_LED2_TR_MASK             0x3FF
#define PWR_OFF_LP_LED2_TR_SHIFT            0
#define PWR_OFF_LP_LED2_TF_ADDR             PWR_OFF_LP_LED2_FLASH_CON10
#define PWR_OFF_LP_LED2_TF_MASK             0x3FF
#define PWR_OFF_LP_LED2_TF_SHIFT            0
#define PWR_RB_LED2_MODE_ADDR               PWR_RB_LED2_MODE
#define PWR_RB_LED2_MODE_MASK               0x3
#define PWR_RB_LED2_MODE_SHIFT              0
#define PWR_RB_LED2_DFIX_ADDR               PWR_RB_LED2_FIX_CON
#define PWR_RB_LED2_DFIX_MASK               0x3FF
#define PWR_RB_LED2_DFIX_SHIFT              0
#define PWR_RB_LED2_PSTART_ADDR             PWR_RB_LED2_FLASH_CON0
#define PWR_RB_LED2_PSTART_MASK             0x7
#define PWR_RB_LED2_PSTART_SHIFT            0
#define PWR_RB_LED2_PEND_ADDR               PWR_RB_LED2_FLASH_CON0
#define PWR_RB_LED2_PEND_MASK               0x7
#define PWR_RB_LED2_PEND_SHIFT              3
#define PWR_RB_LED2_DH_ADDR                 PWR_RB_LED2_FLASH_CON1
#define PWR_RB_LED2_DH_MASK                 0x3FF
#define PWR_RB_LED2_DH_SHIFT                0
#define PWR_RB_LED2_DL_ADDR                 PWR_RB_LED2_FLASH_CON2
#define PWR_RB_LED2_DL_MASK                 0x3FF
#define PWR_RB_LED2_DL_SHIFT                0
#define PWR_RB_LED2_TH0_ADDR                PWR_RB_LED2_FLASH_CON3
#define PWR_RB_LED2_TH0_MASK                0x3FF
#define PWR_RB_LED2_TH0_SHIFT               0
#define PWR_RB_LED2_TL0_ADDR                PWR_RB_LED2_FLASH_CON4
#define PWR_RB_LED2_TL0_MASK                0x3FF
#define PWR_RB_LED2_TL0_SHIFT               0
#define PWR_RB_LED2_TR0_ADDR                PWR_RB_LED2_FLASH_CON5
#define PWR_RB_LED2_TR0_MASK                0x3FF
#define PWR_RB_LED2_TR0_SHIFT               0
#define PWR_RB_LED2_TF0_ADDR                PWR_RB_LED2_FLASH_CON6
#define PWR_RB_LED2_TF0_MASK                0x3FF
#define PWR_RB_LED2_TF0_SHIFT               0
#define PWR_RB_LED2_TH_ADDR                 PWR_RB_LED2_FLASH_CON7
#define PWR_RB_LED2_TH_MASK                 0x3FF
#define PWR_RB_LED2_TH_SHIFT                0
#define PWR_RB_LED2_TL_ADDR                 PWR_RB_LED2_FLASH_CON8
#define PWR_RB_LED2_TL_MASK                 0x3FF
#define PWR_RB_LED2_TL_SHIFT                0
#define PWR_RB_LED2_TR_ADDR                 PWR_RB_LED2_FLASH_CON9
#define PWR_RB_LED2_TR_MASK                 0x3FF
#define PWR_RB_LED2_TR_SHIFT                0
#define PWR_RB_LED2_TF_ADDR                 PWR_RB_LED2_FLASH_CON10
#define PWR_RB_LED2_TF_MASK                 0x3FF
#define PWR_RB_LED2_TF_SHIFT                0
#define PWR_FAIL_LED2_MODE_ADDR             PWR_FAIL_LED2_MODE
#define PWR_FAIL_LED2_MODE_MASK             0x3
#define PWR_FAIL_LED2_MODE_SHIFT            0
#define PWR_FAIL_LED2_DFIX_ADDR             PWR_FAIL_LED2_FIX_CON
#define PWR_FAIL_LED2_DFIX_MASK             0x3FF
#define PWR_FAIL_LED2_DFIX_SHIFT            0
#define PWR_FAIL_LED2_PSTART_ADDR           PWR_FAIL_LED2_FLASH_CON0
#define PWR_FAIL_LED2_PSTART_MASK           0x7
#define PWR_FAIL_LED2_PSTART_SHIFT          0
#define PWR_FAIL_LED2_PEND_ADDR             PWR_FAIL_LED2_FLASH_CON0
#define PWR_FAIL_LED2_PEND_MASK             0x7
#define PWR_FAIL_LED2_PEND_SHIFT            3
#define PWR_FAIL_LED2_DH_ADDR               PWR_FAIL_LED2_FLASH_CON1
#define PWR_FAIL_LED2_DH_MASK               0x3FF
#define PWR_FAIL_LED2_DH_SHIFT              0
#define PWR_FAIL_LED2_DL_ADDR               PWR_FAIL_LED2_FLASH_CON2
#define PWR_FAIL_LED2_DL_MASK               0x3FF
#define PWR_FAIL_LED2_DL_SHIFT              0
#define PWR_FAIL_LED2_TH0_ADDR              PWR_FAIL_LED2_FLASH_CON3
#define PWR_FAIL_LED2_TH0_MASK              0x3FF
#define PWR_FAIL_LED2_TH0_SHIFT             0
#define PWR_FAIL_LED2_TL0_ADDR              PWR_FAIL_LED2_FLASH_CON4
#define PWR_FAIL_LED2_TL0_MASK              0x3FF
#define PWR_FAIL_LED2_TL0_SHIFT             0
#define PWR_FAIL_LED2_TR0_ADDR              PWR_FAIL_LED2_FLASH_CON5
#define PWR_FAIL_LED2_TR0_MASK              0x3FF
#define PWR_FAIL_LED2_TR0_SHIFT             0
#define PWR_FAIL_LED2_TF0_ADDR              PWR_FAIL_LED2_FLASH_CON6
#define PWR_FAIL_LED2_TF0_MASK              0x3FF
#define PWR_FAIL_LED2_TF0_SHIFT             0
#define PWR_FAIL_LED2_TH_ADDR               PWR_FAIL_LED2_FLASH_CON7
#define PWR_FAIL_LED2_TH_MASK               0x3FF
#define PWR_FAIL_LED2_TH_SHIFT              0
#define PWR_FAIL_LED2_TL_ADDR               PWR_FAIL_LED2_FLASH_CON8
#define PWR_FAIL_LED2_TL_MASK               0x3FF
#define PWR_FAIL_LED2_TL_SHIFT              0
#define PWR_FAIL_LED2_TR_ADDR               PWR_FAIL_LED2_FLASH_CON9
#define PWR_FAIL_LED2_TR_MASK               0x3FF
#define PWR_FAIL_LED2_TR_SHIFT              0
#define PWR_FAIL_LED2_TF_ADDR               PWR_FAIL_LED2_FLASH_CON10
#define PWR_FAIL_LED2_TF_MASK               0x3FF
#define PWR_FAIL_LED2_TF_SHIFT              0
#define PWR_FW_LED2_MODE_ADDR               PWR_FW_LED2_MODE
#define PWR_FW_LED2_MODE_MASK               0x3
#define PWR_FW_LED2_MODE_SHIFT              0
#define PWR_FW_LED2_DFIX_ADDR               PWR_FW_LED2_FIX_CON
#define PWR_FW_LED2_DFIX_MASK               0x3FF
#define PWR_FW_LED2_DFIX_SHIFT              0
#define PWR_FW_LED2_PSTART_ADDR             PWR_FW_LED2_FLASH_CON0
#define PWR_FW_LED2_PSTART_MASK             0x7
#define PWR_FW_LED2_PSTART_SHIFT            0
#define PWR_FW_LED2_PEND_ADDR               PWR_FW_LED2_FLASH_CON0
#define PWR_FW_LED2_PEND_MASK               0x7
#define PWR_FW_LED2_PEND_SHIFT              3
#define PWR_FW_LED2_TH0_ADDR                PWR_FW_LED2_FLASH_CON1
#define PWR_FW_LED2_TH0_MASK                0x3FF
#define PWR_FW_LED2_TH0_SHIFT               0
#define PWR_FW_LED2_TL0_ADDR                PWR_FW_LED2_FLASH_CON2
#define PWR_FW_LED2_TL0_MASK                0x3FF
#define PWR_FW_LED2_TL0_SHIFT               0
#define PWR_FW_LED2_TR0_ADDR                PWR_FW_LED2_FLASH_CON3
#define PWR_FW_LED2_TR0_MASK                0x3FF
#define PWR_FW_LED2_TR0_SHIFT               0
#define PWR_FW_LED2_TF0_ADDR                PWR_FW_LED2_FLASH_CON4
#define PWR_FW_LED2_TF0_MASK                0x3FF
#define PWR_FW_LED2_TF0_SHIFT               0
#define PWR_FW_LED2_DH_ADDR                 PWR_FW_LED2_FLASH_CON5
#define PWR_FW_LED2_DH_MASK                 0x3FF
#define PWR_FW_LED2_DH_SHIFT                0
#define PWR_FW_LED2_TH_ADDR                 PWR_FW_LED2_FLASH_CON6
#define PWR_FW_LED2_TH_MASK                 0x3FF
#define PWR_FW_LED2_TH_SHIFT                0
#define PWR_FW_LED2_DL_ADDR                 PWR_FW_LED2_FLASH_CON7
#define PWR_FW_LED2_DL_MASK                 0x3FF
#define PWR_FW_LED2_DL_SHIFT                0
#define PWR_FW_LED2_TL_ADDR                 PWR_FW_LED2_FLASH_CON8
#define PWR_FW_LED2_TL_MASK                 0x3FF
#define PWR_FW_LED2_TL_SHIFT                0
#define PWR_FW_LED2_TR_ADDR                 PWR_FW_LED2_FLASH_CON9
#define PWR_FW_LED2_TR_MASK                 0x3FF
#define PWR_FW_LED2_TR_SHIFT                0
#define PWR_FW_LED2_TF_ADDR                 PWR_FW_LED2_FLASH_CON10
#define PWR_FW_LED2_TF_MASK                 0x3FF
#define PWR_FW_LED2_TF_SHIFT                0
#define LED3_APPLY_EN_ADDR                  LED3_APPLY_EN
#define LED3_APPLY_EN_MASK                  0x1
#define LED3_APPLY_EN_SHIFT                 0
#define PWR_OFF_LP_LED3_LOAD_DISABLE_ADDR   LED3_LOAD_DISABLE
#define PWR_OFF_LP_LED3_LOAD_DISABLE_MASK   0x1
#define PWR_OFF_LP_LED3_LOAD_DISABLE_SHIFT  0
#define PWR_RB_LED3_LOAD_DISABLE_ADDR       LED3_LOAD_DISABLE
#define PWR_RB_LED3_LOAD_DISABLE_MASK       0x1
#define PWR_RB_LED3_LOAD_DISABLE_SHIFT      1
#define PWR_FAIL_LED3_LOAD_DISABLE_ADDR     LED3_LOAD_DISABLE
#define PWR_FAIL_LED3_LOAD_DISABLE_MASK     0x1
#define PWR_FAIL_LED3_LOAD_DISABLE_SHIFT    2
#define PWR_FW_LED3_LOAD_DISABLE_ADDR       LED3_LOAD_DISABLE
#define PWR_FW_LED3_LOAD_DISABLE_MASK       0x1
#define PWR_FW_LED3_LOAD_DISABLE_SHIFT      3
#define RG_LED3_MODE_ADDR                   LED3_MODE_CON
#define RG_LED3_MODE_MASK                   0x3
#define RG_LED3_MODE_SHIFT                  0
#define RG_LED3_DFIX_ADDR                   LED3_FIX_CON
#define RG_LED3_DFIX_MASK                   0x3FF
#define RG_LED3_DFIX_SHIFT                  0
#define RG_LED3_PSTART_ADDR                 LED3_FLASH_CON0
#define RG_LED3_PSTART_MASK                 0x7
#define RG_LED3_PSTART_SHIFT                0
#define RG_LED3_PEND_ADDR                   LED3_FLASH_CON0
#define RG_LED3_PEND_MASK                   0x7
#define RG_LED3_PEND_SHIFT                  3
#define RG_LED3_DH_ADDR                     LED3_FLASH_CON1
#define RG_LED3_DH_MASK                     0x3FF
#define RG_LED3_DH_SHIFT                    0
#define RG_LED3_DL_ADDR                     LED3_FLASH_CON2
#define RG_LED3_DL_MASK                     0x3FF
#define RG_LED3_DL_SHIFT                    0
#define RG_LED3_TH0_ADDR                    LED3_FLASH_CON3
#define RG_LED3_TH0_MASK                    0x3FF
#define RG_LED3_TH0_SHIFT                   0
#define RG_LED3_TL0_ADDR                    LED3_FLASH_CON4
#define RG_LED3_TL0_MASK                    0x3FF
#define RG_LED3_TL0_SHIFT                   0
#define RG_LED3_TR0_ADDR                    LED3_FLASH_CON5
#define RG_LED3_TR0_MASK                    0x3FF
#define RG_LED3_TR0_SHIFT                   0
#define RG_LED3_TF0_ADDR                    LED3_FLASH_CON6
#define RG_LED3_TF0_MASK                    0x3FF
#define RG_LED3_TF0_SHIFT                   0
#define RG_LED3_TH_ADDR                     LED3_FLASH_CON7
#define RG_LED3_TH_MASK                     0x3FF
#define RG_LED3_TH_SHIFT                    0
#define RG_LED3_TL_ADDR                     LED3_FLASH_CON8
#define RG_LED3_TL_MASK                     0x3FF
#define RG_LED3_TL_SHIFT                    0
#define RG_LED3_TR_ADDR                     LED3_FLASH_CON9
#define RG_LED3_TR_MASK                     0x3FF
#define RG_LED3_TR_SHIFT                    0
#define RG_LED3_TF_ADDR                     LED3_FLASH_CON10
#define RG_LED3_TF_MASK                     0x3FF
#define RG_LED3_TF_SHIFT                    0
#define PWR_BY_LED3_LOAD_DISABLE_ADDR       LED3_ELR0
#define PWR_BY_LED3_LOAD_DISABLE_MASK       0x1
#define PWR_BY_LED3_LOAD_DISABLE_SHIFT      0
#define PWR_ON_LED3_LOAD_DISABLE_ADDR       LED3_ELR0
#define PWR_ON_LED3_LOAD_DISABLE_MASK       0x1
#define PWR_ON_LED3_LOAD_DISABLE_SHIFT      1
#define PWR_BY_LED3_MODE_ADDR               LED3_ELR0
#define PWR_BY_LED3_MODE_MASK               0x3
#define PWR_BY_LED3_MODE_SHIFT              2
#define PWR_BY_LED3_DFIX_ADDR               LED3_ELR0
#define PWR_BY_LED3_DFIX_MASK               0x3FF
#define PWR_BY_LED3_DFIX_SHIFT              4
#define LED3_ELR_RSV0_ADDR                  LED3_ELR0
#define LED3_ELR_RSV0_MASK                  0x3
#define LED3_ELR_RSV0_SHIFT                 14
#define PWR_BY_LED3_PSTART_ADDR             LED3_ELR1
#define PWR_BY_LED3_PSTART_MASK             0x7
#define PWR_BY_LED3_PSTART_SHIFT            0
#define PWR_BY_LED3_PEND_ADDR               LED3_ELR1
#define PWR_BY_LED3_PEND_MASK               0x7
#define PWR_BY_LED3_PEND_SHIFT              3
#define LED3_ELR_RSV1_ADDR                  LED3_ELR1
#define LED3_ELR_RSV1_MASK                  0x3FF
#define LED3_ELR_RSV1_SHIFT                 6
#define PWR_BY_LED3_DH_ADDR                 LED3_ELR2
#define PWR_BY_LED3_DH_MASK                 0x3FF
#define PWR_BY_LED3_DH_SHIFT                0
#define PWR_BY_LED3_DL_ADDR                 LED3_ELR3
#define PWR_BY_LED3_DL_MASK                 0x3FF
#define PWR_BY_LED3_DL_SHIFT                0
#define PWR_BY_LED3_TH0_ADDR                LED3_ELR4
#define PWR_BY_LED3_TH0_MASK                0x3FF
#define PWR_BY_LED3_TH0_SHIFT               0
#define PWR_BY_LED3_TL0_ADDR                LED3_ELR5
#define PWR_BY_LED3_TL0_MASK                0x3FF
#define PWR_BY_LED3_TL0_SHIFT               0
#define PWR_BY_LED3_TR0_ADDR                LED3_ELR6
#define PWR_BY_LED3_TR0_MASK                0x3FF
#define PWR_BY_LED3_TR0_SHIFT               0
#define PWR_BY_LED3_TF0_ADDR                LED3_ELR7
#define PWR_BY_LED3_TF0_MASK                0x3FF
#define PWR_BY_LED3_TF0_SHIFT               0
#define PWR_BY_LED3_TH_ADDR                 LED3_ELR8
#define PWR_BY_LED3_TH_MASK                 0x3FF
#define PWR_BY_LED3_TH_SHIFT                0
#define PWR_BY_LED3_TL_ADDR                 LED3_ELR9
#define PWR_BY_LED3_TL_MASK                 0x3FF
#define PWR_BY_LED3_TL_SHIFT                0
#define PWR_BY_LED3_TR_ADDR                 LED3_ELR10
#define PWR_BY_LED3_TR_MASK                 0x3FF
#define PWR_BY_LED3_TR_SHIFT                0
#define PWR_BY_LED3_TF_ADDR                 LED3_ELR11
#define PWR_BY_LED3_TF_MASK                 0x3FF
#define PWR_BY_LED3_TF_SHIFT                0
#define PWR_ON_LED3_MODE_ADDR               LED3_ELR12
#define PWR_ON_LED3_MODE_MASK               0x3
#define PWR_ON_LED3_MODE_SHIFT              0
#define PWR_ON_LED3_DFIX_ADDR               LED3_ELR12
#define PWR_ON_LED3_DFIX_MASK               0x3FF
#define PWR_ON_LED3_DFIX_SHIFT              2
#define LED3_ELR_RSV2_ADDR                  LED3_ELR12
#define LED3_ELR_RSV2_MASK                  0xF
#define LED3_ELR_RSV2_SHIFT                 12
#define PWR_ON_LED3_PSTART_ADDR             LED3_ELR13
#define PWR_ON_LED3_PSTART_MASK             0x7
#define PWR_ON_LED3_PSTART_SHIFT            0
#define PWR_ON_LED3_PEND_ADDR               LED3_ELR13
#define PWR_ON_LED3_PEND_MASK               0x7
#define PWR_ON_LED3_PEND_SHIFT              3
#define LED3_ELR_RSV3_ADDR                  LED3_ELR13
#define LED3_ELR_RSV3_MASK                  0x3FF
#define LED3_ELR_RSV3_SHIFT                 6
#define PWR_ON_LED3_DH_ADDR                 LED3_ELR14
#define PWR_ON_LED3_DH_MASK                 0x3FF
#define PWR_ON_LED3_DH_SHIFT                0
#define PWR_ON_LED3_DL_ADDR                 LED3_ELR15
#define PWR_ON_LED3_DL_MASK                 0x3FF
#define PWR_ON_LED3_DL_SHIFT                0
#define PWR_ON_LED3_TH0_ADDR                LED3_ELR16
#define PWR_ON_LED3_TH0_MASK                0x3FF
#define PWR_ON_LED3_TH0_SHIFT               0
#define PWR_ON_LED3_TL0_ADDR                LED3_ELR17
#define PWR_ON_LED3_TL0_MASK                0x3FF
#define PWR_ON_LED3_TL0_SHIFT               0
#define PWR_ON_LED3_TR0_ADDR                LED3_ELR18
#define PWR_ON_LED3_TR0_MASK                0x3FF
#define PWR_ON_LED3_TR0_SHIFT               0
#define PWR_ON_LED3_TF0_ADDR                LED3_ELR19
#define PWR_ON_LED3_TF0_MASK                0x3FF
#define PWR_ON_LED3_TF0_SHIFT               0
#define PWR_ON_LED3_TH_ADDR                 LED3_ELR20
#define PWR_ON_LED3_TH_MASK                 0x3FF
#define PWR_ON_LED3_TH_SHIFT                0
#define PWR_ON_LED3_TL_ADDR                 LED3_ELR21
#define PWR_ON_LED3_TL_MASK                 0x3FF
#define PWR_ON_LED3_TL_SHIFT                0
#define PWR_ON_LED3_TR_ADDR                 LED3_ELR22
#define PWR_ON_LED3_TR_MASK                 0x3FF
#define PWR_ON_LED3_TR_SHIFT                0
#define PWR_ON_LED3_TF_ADDR                 LED3_ELR23
#define PWR_ON_LED3_TF_MASK                 0x3FF
#define PWR_ON_LED3_TF_SHIFT                0
#define PWR_OFF_LP_LED3_MODE_ADDR           PWR_OFF_LP_LED3_MODE
#define PWR_OFF_LP_LED3_MODE_MASK           0x3
#define PWR_OFF_LP_LED3_MODE_SHIFT          0
#define PWR_OFF_LP_LED3_DFIX_ADDR           PWR_OFF_LP_LED3_FIX_CON
#define PWR_OFF_LP_LED3_DFIX_MASK           0x3FF
#define PWR_OFF_LP_LED3_DFIX_SHIFT          0
#define PWR_OFF_LP_LED3_PSTART_ADDR         PWR_OFF_LP_LED3_FLASH_CON0
#define PWR_OFF_LP_LED3_PSTART_MASK         0x7
#define PWR_OFF_LP_LED3_PSTART_SHIFT        0
#define PWR_OFF_LP_LED3_PEND_ADDR           PWR_OFF_LP_LED3_FLASH_CON0
#define PWR_OFF_LP_LED3_PEND_MASK           0x7
#define PWR_OFF_LP_LED3_PEND_SHIFT          3
#define PWR_OFF_LP_LED3_DH_ADDR             PWR_OFF_LP_LED3_FLASH_CON1
#define PWR_OFF_LP_LED3_DH_MASK             0x3FF
#define PWR_OFF_LP_LED3_DH_SHIFT            0
#define PWR_OFF_LP_LED3_DL_ADDR             PWR_OFF_LP_LED3_FLASH_CON2
#define PWR_OFF_LP_LED3_DL_MASK             0x3FF
#define PWR_OFF_LP_LED3_DL_SHIFT            0
#define PWR_OFF_LP_LED3_TH0_ADDR            PWR_OFF_LP_LED3_FLASH_CON3
#define PWR_OFF_LP_LED3_TH0_MASK            0x3FF
#define PWR_OFF_LP_LED3_TH0_SHIFT           0
#define PWR_OFF_LP_LED3_TL0_ADDR            PWR_OFF_LP_LED3_FLASH_CON4
#define PWR_OFF_LP_LED3_TL0_MASK            0x3FF
#define PWR_OFF_LP_LED3_TL0_SHIFT           0
#define PWR_OFF_LP_LED3_TR0_ADDR            PWR_OFF_LP_LED3_FLASH_CON5
#define PWR_OFF_LP_LED3_TR0_MASK            0x3FF
#define PWR_OFF_LP_LED3_TR0_SHIFT           0
#define PWR_OFF_LP_LED3_TF0_ADDR            PWR_OFF_LP_LED3_FLASH_CON6
#define PWR_OFF_LP_LED3_TF0_MASK            0x3FF
#define PWR_OFF_LP_LED3_TF0_SHIFT           0
#define PWR_OFF_LP_LED3_TH_ADDR             PWR_OFF_LP_LED3_FLASH_CON7
#define PWR_OFF_LP_LED3_TH_MASK             0x3FF
#define PWR_OFF_LP_LED3_TH_SHIFT            0
#define PWR_OFF_LP_LED3_TL_ADDR             PWR_OFF_LP_LED3_FLASH_CON8
#define PWR_OFF_LP_LED3_TL_MASK             0x3FF
#define PWR_OFF_LP_LED3_TL_SHIFT            0
#define PWR_OFF_LP_LED3_TR_ADDR             PWR_OFF_LP_LED3_FLASH_CON9
#define PWR_OFF_LP_LED3_TR_MASK             0x3FF
#define PWR_OFF_LP_LED3_TR_SHIFT            0
#define PWR_OFF_LP_LED3_TF_ADDR             PWR_OFF_LP_LED3_FLASH_CON10
#define PWR_OFF_LP_LED3_TF_MASK             0x3FF
#define PWR_OFF_LP_LED3_TF_SHIFT            0
#define PWR_RB_LED3_MODE_ADDR               PWR_RB_LED3_MODE
#define PWR_RB_LED3_MODE_MASK               0x3
#define PWR_RB_LED3_MODE_SHIFT              0
#define PWR_RB_LED3_DFIX_ADDR               PWR_RB_LED3_FIX_CON
#define PWR_RB_LED3_DFIX_MASK               0x3FF
#define PWR_RB_LED3_DFIX_SHIFT              0
#define PWR_RB_LED3_PSTART_ADDR             PWR_RB_LED3_FLASH_CON0
#define PWR_RB_LED3_PSTART_MASK             0x7
#define PWR_RB_LED3_PSTART_SHIFT            0
#define PWR_RB_LED3_PEND_ADDR               PWR_RB_LED3_FLASH_CON0
#define PWR_RB_LED3_PEND_MASK               0x7
#define PWR_RB_LED3_PEND_SHIFT              3
#define PWR_RB_LED3_DH_ADDR                 PWR_RB_LED3_FLASH_CON1
#define PWR_RB_LED3_DH_MASK                 0x3FF
#define PWR_RB_LED3_DH_SHIFT                0
#define PWR_RB_LED3_DL_ADDR                 PWR_RB_LED3_FLASH_CON2
#define PWR_RB_LED3_DL_MASK                 0x3FF
#define PWR_RB_LED3_DL_SHIFT                0
#define PWR_RB_LED3_TH0_ADDR                PWR_RB_LED3_FLASH_CON3
#define PWR_RB_LED3_TH0_MASK                0x3FF
#define PWR_RB_LED3_TH0_SHIFT               0
#define PWR_RB_LED3_TL0_ADDR                PWR_RB_LED3_FLASH_CON4
#define PWR_RB_LED3_TL0_MASK                0x3FF
#define PWR_RB_LED3_TL0_SHIFT               0
#define PWR_RB_LED3_TR0_ADDR                PWR_RB_LED3_FLASH_CON5
#define PWR_RB_LED3_TR0_MASK                0x3FF
#define PWR_RB_LED3_TR0_SHIFT               0
#define PWR_RB_LED3_TF0_ADDR                PWR_RB_LED3_FLASH_CON6
#define PWR_RB_LED3_TF0_MASK                0x3FF
#define PWR_RB_LED3_TF0_SHIFT               0
#define PWR_RB_LED3_TH_ADDR                 PWR_RB_LED3_FLASH_CON7
#define PWR_RB_LED3_TH_MASK                 0x3FF
#define PWR_RB_LED3_TH_SHIFT                0
#define PWR_RB_LED3_TL_ADDR                 PWR_RB_LED3_FLASH_CON8
#define PWR_RB_LED3_TL_MASK                 0x3FF
#define PWR_RB_LED3_TL_SHIFT                0
#define PWR_RB_LED3_TR_ADDR                 PWR_RB_LED3_FLASH_CON9
#define PWR_RB_LED3_TR_MASK                 0x3FF
#define PWR_RB_LED3_TR_SHIFT                0
#define PWR_RB_LED3_TF_ADDR                 PWR_RB_LED3_FLASH_CON10
#define PWR_RB_LED3_TF_MASK                 0x3FF
#define PWR_RB_LED3_TF_SHIFT                0
#define PWR_FAIL_LED3_MODE_ADDR             PWR_FAIL_LED3_MODE
#define PWR_FAIL_LED3_MODE_MASK             0x3
#define PWR_FAIL_LED3_MODE_SHIFT            0
#define PWR_FAIL_LED3_DFIX_ADDR             PWR_FAIL_LED3_FIX_CON
#define PWR_FAIL_LED3_DFIX_MASK             0x3FF
#define PWR_FAIL_LED3_DFIX_SHIFT            0
#define PWR_FAIL_LED3_PSTART_ADDR           PWR_FAIL_LED3_FLASH_CON0
#define PWR_FAIL_LED3_PSTART_MASK           0x7
#define PWR_FAIL_LED3_PSTART_SHIFT          0
#define PWR_FAIL_LED3_PEND_ADDR             PWR_FAIL_LED3_FLASH_CON0
#define PWR_FAIL_LED3_PEND_MASK             0x7
#define PWR_FAIL_LED3_PEND_SHIFT            3
#define PWR_FAIL_LED3_DH_ADDR               PWR_FAIL_LED3_FLASH_CON1
#define PWR_FAIL_LED3_DH_MASK               0x3FF
#define PWR_FAIL_LED3_DH_SHIFT              0
#define PWR_FAIL_LED3_DL_ADDR               PWR_FAIL_LED3_FLASH_CON2
#define PWR_FAIL_LED3_DL_MASK               0x3FF
#define PWR_FAIL_LED3_DL_SHIFT              0
#define PWR_FAIL_LED3_TH0_ADDR              PWR_FAIL_LED3_FLASH_CON3
#define PWR_FAIL_LED3_TH0_MASK              0x3FF
#define PWR_FAIL_LED3_TH0_SHIFT             0
#define PWR_FAIL_LED3_TL0_ADDR              PWR_FAIL_LED3_FLASH_CON4
#define PWR_FAIL_LED3_TL0_MASK              0x3FF
#define PWR_FAIL_LED3_TL0_SHIFT             0
#define PWR_FAIL_LED3_TR0_ADDR              PWR_FAIL_LED3_FLASH_CON5
#define PWR_FAIL_LED3_TR0_MASK              0x3FF
#define PWR_FAIL_LED3_TR0_SHIFT             0
#define PWR_FAIL_LED3_TF0_ADDR              PWR_FAIL_LED3_FLASH_CON6
#define PWR_FAIL_LED3_TF0_MASK              0x3FF
#define PWR_FAIL_LED3_TF0_SHIFT             0
#define PWR_FAIL_LED3_TH_ADDR               PWR_FAIL_LED3_FLASH_CON7
#define PWR_FAIL_LED3_TH_MASK               0x3FF
#define PWR_FAIL_LED3_TH_SHIFT              0
#define PWR_FAIL_LED3_TL_ADDR               PWR_FAIL_LED3_FLASH_CON8
#define PWR_FAIL_LED3_TL_MASK               0x3FF
#define PWR_FAIL_LED3_TL_SHIFT              0
#define PWR_FAIL_LED3_TR_ADDR               PWR_FAIL_LED3_FLASH_CON9
#define PWR_FAIL_LED3_TR_MASK               0x3FF
#define PWR_FAIL_LED3_TR_SHIFT              0
#define PWR_FAIL_LED3_TF_ADDR               PWR_FAIL_LED3_FLASH_CON10
#define PWR_FAIL_LED3_TF_MASK               0x3FF
#define PWR_FAIL_LED3_TF_SHIFT              0
#define PWR_FW_LED3_MODE_ADDR               PWR_FW_LED3_MODE
#define PWR_FW_LED3_MODE_MASK               0x3
#define PWR_FW_LED3_MODE_SHIFT              0
#define PWR_FW_LED3_DFIX_ADDR               PWR_FW_LED3_FIX_CON
#define PWR_FW_LED3_DFIX_MASK               0x3FF
#define PWR_FW_LED3_DFIX_SHIFT              0
#define PWR_FW_LED3_PSTART_ADDR             PWR_FW_LED3_FLASH_CON0
#define PWR_FW_LED3_PSTART_MASK             0x7
#define PWR_FW_LED3_PSTART_SHIFT            0
#define PWR_FW_LED3_PEND_ADDR               PWR_FW_LED3_FLASH_CON0
#define PWR_FW_LED3_PEND_MASK               0x7
#define PWR_FW_LED3_PEND_SHIFT              3
#define PWR_FW_LED3_TH0_ADDR                PWR_FW_LED3_FLASH_CON1
#define PWR_FW_LED3_TH0_MASK                0x3FF
#define PWR_FW_LED3_TH0_SHIFT               0
#define PWR_FW_LED3_TL0_ADDR                PWR_FW_LED3_FLASH_CON2
#define PWR_FW_LED3_TL0_MASK                0x3FF
#define PWR_FW_LED3_TL0_SHIFT               0
#define PWR_FW_LED3_TR0_ADDR                PWR_FW_LED3_FLASH_CON3
#define PWR_FW_LED3_TR0_MASK                0x3FF
#define PWR_FW_LED3_TR0_SHIFT               0
#define PWR_FW_LED3_TF0_ADDR                PWR_FW_LED3_FLASH_CON4
#define PWR_FW_LED3_TF0_MASK                0x3FF
#define PWR_FW_LED3_TF0_SHIFT               0
#define PWR_FW_LED3_DH_ADDR                 PWR_FW_LED3_FLASH_CON5
#define PWR_FW_LED3_DH_MASK                 0x3FF
#define PWR_FW_LED3_DH_SHIFT                0
#define PWR_FW_LED3_TH_ADDR                 PWR_FW_LED3_FLASH_CON6
#define PWR_FW_LED3_TH_MASK                 0x3FF
#define PWR_FW_LED3_TH_SHIFT                0
#define PWR_FW_LED3_DL_ADDR                 PWR_FW_LED3_FLASH_CON7
#define PWR_FW_LED3_DL_MASK                 0x3FF
#define PWR_FW_LED3_DL_SHIFT                0
#define PWR_FW_LED3_TL_ADDR                 PWR_FW_LED3_FLASH_CON8
#define PWR_FW_LED3_TL_MASK                 0x3FF
#define PWR_FW_LED3_TL_SHIFT                0
#define PWR_FW_LED3_TR_ADDR                 PWR_FW_LED3_FLASH_CON9
#define PWR_FW_LED3_TR_MASK                 0x3FF
#define PWR_FW_LED3_TR_SHIFT                0
#define PWR_FW_LED3_TF_ADDR                 PWR_FW_LED3_FLASH_CON10
#define PWR_FW_LED3_TF_MASK                 0x3FF
#define PWR_FW_LED3_TF_SHIFT                0
#define PWM1_APPLY_EN_ADDR                  PWM1_APPLY_EN
#define PWM1_APPLY_EN_MASK                  0x1
#define PWM1_APPLY_EN_SHIFT                 0
#define PWR_OFF_LP_PWM1_LOAD_DISABLE_ADDR   PWM1_LOAD_DISABLE
#define PWR_OFF_LP_PWM1_LOAD_DISABLE_MASK   0x1
#define PWR_OFF_LP_PWM1_LOAD_DISABLE_SHIFT  0
#define PWR_RB_PWM1_LOAD_DISABLE_ADDR       PWM1_LOAD_DISABLE
#define PWR_RB_PWM1_LOAD_DISABLE_MASK       0x1
#define PWR_RB_PWM1_LOAD_DISABLE_SHIFT      1
#define PWR_FAIL_PWM1_LOAD_DISABLE_ADDR     PWM1_LOAD_DISABLE
#define PWR_FAIL_PWM1_LOAD_DISABLE_MASK     0x1
#define PWR_FAIL_PWM1_LOAD_DISABLE_SHIFT    2
#define PWR_FW_PWM1_LOAD_DISABLE_ADDR       PWM1_LOAD_DISABLE
#define PWR_FW_PWM1_LOAD_DISABLE_MASK       0x1
#define PWR_FW_PWM1_LOAD_DISABLE_SHIFT      3
#define RG_PWM1_EN_ADDR                     PWM1_EN_CON
#define RG_PWM1_EN_MASK                     0x1
#define RG_PWM1_EN_SHIFT                    0
#define RG_PWM1_DUTY_ADDR                   PWM1_CON0
#define RG_PWM1_DUTY_MASK                   0x3F
#define RG_PWM1_DUTY_SHIFT                  0
#define RG_PWM1_FREQ_ADDR                   PWM1_CON0
#define RG_PWM1_FREQ_MASK                   0x3
#define RG_PWM1_FREQ_SHIFT                  6
#define PWR_OFF_LP_PWM1_EN_ADDR             PWR_OFF_LP_PWM1_EN
#define PWR_OFF_LP_PWM1_EN_MASK             0x1
#define PWR_OFF_LP_PWM1_EN_SHIFT            0
#define PWR_OFF_LP_PWM1_DUTY_ADDR           PWR_OFF_LP_PWM1_CON0
#define PWR_OFF_LP_PWM1_DUTY_MASK           0x3F
#define PWR_OFF_LP_PWM1_DUTY_SHIFT          0
#define PWR_OFF_LP_PWM1_FREQ_ADDR           PWR_OFF_LP_PWM1_CON0
#define PWR_OFF_LP_PWM1_FREQ_MASK           0x3
#define PWR_OFF_LP_PWM1_FREQ_SHIFT          6
#define PWR_RB_PWM1_EN_ADDR                 PWR_RB_PWM1_EN
#define PWR_RB_PWM1_EN_MASK                 0x1
#define PWR_RB_PWM1_EN_SHIFT                0
#define PWR_RB_PWM1_DUTY_ADDR               PWR_RB_PWM1_CON0
#define PWR_RB_PWM1_DUTY_MASK               0x3F
#define PWR_RB_PWM1_DUTY_SHIFT              0
#define PWR_RB_PWM1_FREQ_ADDR               PWR_RB_PWM1_CON0
#define PWR_RB_PWM1_FREQ_MASK               0x3
#define PWR_RB_PWM1_FREQ_SHIFT              6
#define PWR_FAIL_PWM1_EN_ADDR               PWR_FAIL_PWM1_EN
#define PWR_FAIL_PWM1_EN_MASK               0x1
#define PWR_FAIL_PWM1_EN_SHIFT              0
#define PWR_FAIL_PWM1_DUTY_ADDR             PWR_FAIL_PWM1_CON0
#define PWR_FAIL_PWM1_DUTY_MASK             0x3F
#define PWR_FAIL_PWM1_DUTY_SHIFT            0
#define PWR_FAIL_PWM1_FREQ_ADDR             PWR_FAIL_PWM1_CON0
#define PWR_FAIL_PWM1_FREQ_MASK             0x3
#define PWR_FAIL_PWM1_FREQ_SHIFT            6
#define PWR_FW_PWM1_EN_ADDR                 PWR_FW_PWM1_EN
#define PWR_FW_PWM1_EN_MASK                 0x1
#define PWR_FW_PWM1_EN_SHIFT                0
#define PWR_FW_PWM1_DUTY_ADDR               PWR_FW_PWM1_CON0
#define PWR_FW_PWM1_DUTY_MASK               0x3F
#define PWR_FW_PWM1_DUTY_SHIFT              0
#define PWR_FW_PWM1_FREQ_ADDR               PWR_FW_PWM1_CON0
#define PWR_FW_PWM1_FREQ_MASK               0x3
#define PWR_FW_PWM1_FREQ_SHIFT              6
#define PWR_BY_PWM1_LOAD_DISABLE_ADDR       PWM1_ELR0
#define PWR_BY_PWM1_LOAD_DISABLE_MASK       0x1
#define PWR_BY_PWM1_LOAD_DISABLE_SHIFT      0
#define PWR_ON_PWM1_LOAD_DISABLE_ADDR       PWM1_ELR0
#define PWR_ON_PWM1_LOAD_DISABLE_MASK       0x1
#define PWR_ON_PWM1_LOAD_DISABLE_SHIFT      1
#define PWR_BY_PWM1_EN_ADDR                 PWM1_ELR0
#define PWR_BY_PWM1_EN_MASK                 0x1
#define PWR_BY_PWM1_EN_SHIFT                2
#define PWR_BY_PWM1_DUTY_ADDR               PWM1_ELR0
#define PWR_BY_PWM1_DUTY_MASK               0x3F
#define PWR_BY_PWM1_DUTY_SHIFT              3
#define PWR_BY_PWM1_FREQ_ADDR               PWM1_ELR0
#define PWR_BY_PWM1_FREQ_MASK               0x3
#define PWR_BY_PWM1_FREQ_SHIFT              9
#define PWR_ON_PWM1_EN_ADDR                 PWM1_ELR0
#define PWR_ON_PWM1_EN_MASK                 0x1
#define PWR_ON_PWM1_EN_SHIFT                11
#define PWM1_ELR_RSV0_ADDR                  PWM1_ELR0
#define PWM1_ELR_RSV0_MASK                  0xF
#define PWM1_ELR_RSV0_SHIFT                 12
#define PWR_ON_PWM1_DUTY_ADDR               PWM1_ELR1
#define PWR_ON_PWM1_DUTY_MASK               0x3F
#define PWR_ON_PWM1_DUTY_SHIFT              0
#define PWR_ON_PWM1_FREQ_ADDR               PWM1_ELR1
#define PWR_ON_PWM1_FREQ_MASK               0x3
#define PWR_ON_PWM1_FREQ_SHIFT              6
#define PWM1_ELR_RSV1_ADDR                  PWM1_ELR1
#define PWM1_ELR_RSV1_MASK                  0xFF
#define PWM1_ELR_RSV1_SHIFT                 8
#define PWM2_APPLY_EN_ADDR                  PWM2_APPLY_EN
#define PWM2_APPLY_EN_MASK                  0x1
#define PWM2_APPLY_EN_SHIFT                 0
#define PWR_OFF_LP_PWM2_LOAD_DISABLE_ADDR   PWM2_LOAD_DISABLE
#define PWR_OFF_LP_PWM2_LOAD_DISABLE_MASK   0x1
#define PWR_OFF_LP_PWM2_LOAD_DISABLE_SHIFT  0
#define PWR_RB_PWM2_LOAD_DISABLE_ADDR       PWM2_LOAD_DISABLE
#define PWR_RB_PWM2_LOAD_DISABLE_MASK       0x1
#define PWR_RB_PWM2_LOAD_DISABLE_SHIFT      1
#define PWR_FW_PWM2_LOAD_DISABLE_ADDR       PWM2_LOAD_DISABLE
#define PWR_FW_PWM2_LOAD_DISABLE_MASK       0x1
#define PWR_FW_PWM2_LOAD_DISABLE_SHIFT      2
#define RG_PWM2_EN_ADDR                     PWM2_EN_CON
#define RG_PWM2_EN_MASK                     0x1
#define RG_PWM2_EN_SHIFT                    0
#define RG_PWM2_FREQ_ADDR                   PWM2_CON0
#define RG_PWM2_FREQ_MASK                   0xF
#define RG_PWM2_FREQ_SHIFT                  0
#define RG_PWM2_DUTY_ADDR                   PWM2_CON0
#define RG_PWM2_DUTY_MASK                   0x3
#define RG_PWM2_DUTY_SHIFT                  4
#define RG_PWM2_TREPEAT_ADDR                PWM2_CON1
#define RG_PWM2_TREPEAT_MASK                0x3
#define RG_PWM2_TREPEAT_SHIFT               0
#define RG_PWM2_TON_ADDR                    PWM2_CON1
#define RG_PWM2_TON_MASK                    0x3
#define RG_PWM2_TON_SHIFT                   2
#define RG_PWM2_TOFF_ADDR                   PWM2_CON1
#define RG_PWM2_TOFF_MASK                   0x3
#define RG_PWM2_TOFF_SHIFT                  4
#define PWR_OFF_LP_PWM2_EN_ADDR             PWR_OFF_LP_PWM2_EN
#define PWR_OFF_LP_PWM2_EN_MASK             0x1
#define PWR_OFF_LP_PWM2_EN_SHIFT            0
#define PWR_OFF_LP_PWM2_FREQ_ADDR           PWR_OFF_LP_PWM2_CON0
#define PWR_OFF_LP_PWM2_FREQ_MASK           0xF
#define PWR_OFF_LP_PWM2_FREQ_SHIFT          0
#define PWR_OFF_LP_PWM2_TREPEAT_ADDR        PWR_OFF_LP_PWM2_CON0
#define PWR_OFF_LP_PWM2_TREPEAT_MASK        0x3
#define PWR_OFF_LP_PWM2_TREPEAT_SHIFT       4
#define PWR_OFF_LP_PWM2_TON_ADDR            PWR_OFF_LP_PWM2_CON0
#define PWR_OFF_LP_PWM2_TON_MASK            0x3
#define PWR_OFF_LP_PWM2_TON_SHIFT           6
#define PWR_OFF_LP_PWM2_TOFF_ADDR           PWR_OFF_LP_PWM2_CON0
#define PWR_OFF_LP_PWM2_TOFF_MASK           0x3
#define PWR_OFF_LP_PWM2_TOFF_SHIFT          8
#define PWR_RB_PWM2_EN_ADDR                 PWR_RB_PWM2_EN
#define PWR_RB_PWM2_EN_MASK                 0x1
#define PWR_RB_PWM2_EN_SHIFT                0
#define PWR_RB_PWM2_FREQ_ADDR               PWR_RB_PWM2_CON0
#define PWR_RB_PWM2_FREQ_MASK               0xF
#define PWR_RB_PWM2_FREQ_SHIFT              0
#define PWR_RB_PWM2_TREPEAT_ADDR            PWR_RB_PWM2_CON0
#define PWR_RB_PWM2_TREPEAT_MASK            0x3
#define PWR_RB_PWM2_TREPEAT_SHIFT           4
#define PWR_RB_PWM2_TON_ADDR                PWR_RB_PWM2_CON0
#define PWR_RB_PWM2_TON_MASK                0x3
#define PWR_RB_PWM2_TON_SHIFT               6
#define PWR_RB_PWM2_TOFF_ADDR               PWR_RB_PWM2_CON0
#define PWR_RB_PWM2_TOFF_MASK               0x3
#define PWR_RB_PWM2_TOFF_SHIFT              8
#define PWR_FW_PWM2_EN_ADDR                 PWR_FW_PWM2_EN
#define PWR_FW_PWM2_EN_MASK                 0x1
#define PWR_FW_PWM2_EN_SHIFT                0
#define PWR_FW_PWM2_FREQ_ADDR               PWR_FW_PWM2_CON0
#define PWR_FW_PWM2_FREQ_MASK               0xF
#define PWR_FW_PWM2_FREQ_SHIFT              0
#define PWR_FW_PWM2_TREPEAT_ADDR            PWR_FW_PWM2_CON0
#define PWR_FW_PWM2_TREPEAT_MASK            0x3
#define PWR_FW_PWM2_TREPEAT_SHIFT           4
#define PWR_FW_PWM2_TON_ADDR                PWR_FW_PWM2_CON0
#define PWR_FW_PWM2_TON_MASK                0x3
#define PWR_FW_PWM2_TON_SHIFT               6
#define PWR_FW_PWM2_TOFF_ADDR               PWR_FW_PWM2_CON0
#define PWR_FW_PWM2_TOFF_MASK               0x3
#define PWR_FW_PWM2_TOFF_SHIFT              8
#define PWR_ON_PWM2_LOAD_DISABLE_ADDR       PWM2_ELR0
#define PWR_ON_PWM2_LOAD_DISABLE_MASK       0x1
#define PWR_ON_PWM2_LOAD_DISABLE_SHIFT      0
#define PWR_ON2_PWM2_LOAD_DISABLE_ADDR      PWM2_ELR0
#define PWR_ON2_PWM2_LOAD_DISABLE_MASK      0x1
#define PWR_ON2_PWM2_LOAD_DISABLE_SHIFT     1
#define PWR_ON_PWM2_EN_ADDR                 PWM2_ELR0
#define PWR_ON_PWM2_EN_MASK                 0x1
#define PWR_ON_PWM2_EN_SHIFT                2
#define PWR_ON_PWM2_FREQ_ADDR               PWM2_ELR0
#define PWR_ON_PWM2_FREQ_MASK               0xF
#define PWR_ON_PWM2_FREQ_SHIFT              3
#define PWR_ON_PWM2_TREPEAT_ADDR            PWM2_ELR0
#define PWR_ON_PWM2_TREPEAT_MASK            0x3
#define PWR_ON_PWM2_TREPEAT_SHIFT           7
#define PWR_ON_PWM2_TON_ADDR                PWM2_ELR0
#define PWR_ON_PWM2_TON_MASK                0x3
#define PWR_ON_PWM2_TON_SHIFT               9
#define PWR_ON_PWM2_TOFF_ADDR               PWM2_ELR0
#define PWR_ON_PWM2_TOFF_MASK               0x3
#define PWR_ON_PWM2_TOFF_SHIFT              11
#define PWR_ON2_PWM2_EN_ADDR                PWM2_ELR0
#define PWR_ON2_PWM2_EN_MASK                0x1
#define PWR_ON2_PWM2_EN_SHIFT               13
#define PWM2_ELR_RSV0_ADDR                  PWM2_ELR0
#define PWM2_ELR_RSV0_MASK                  0x3
#define PWM2_ELR_RSV0_SHIFT                 14
#define PWR_ON2_PWM2_FREQ_ADDR              PWM2_ELR1
#define PWR_ON2_PWM2_FREQ_MASK              0xF
#define PWR_ON2_PWM2_FREQ_SHIFT             0
#define PWR_ON2_PWM2_TREPEAT_ADDR           PWM2_ELR1
#define PWR_ON2_PWM2_TREPEAT_MASK           0x3
#define PWR_ON2_PWM2_TREPEAT_SHIFT          4
#define PWR_ON2_PWM2_TON_ADDR               PWM2_ELR1
#define PWR_ON2_PWM2_TON_MASK               0x3
#define PWR_ON2_PWM2_TON_SHIFT              6
#define PWR_ON2_PWM2_TOFF_ADDR              PWM2_ELR1
#define PWR_ON2_PWM2_TOFF_MASK              0x3
#define PWR_ON2_PWM2_TOFF_SHIFT             8
#define PWM2_ELR_RSV_ADDR                   PWM2_ELR1
#define PWM2_ELR_RSV_MASK                   0x3F
#define PWM2_ELR_RSV_SHIFT                  10
#define MT3615_PSEQ2_CON0			((uint32_t)(PM_BS+0x890))
#define MT3615_SOC_READY_STATUS_ADDR		MT3615_PSEQ2_CON0
#define MT3615_SOC_READY_STATUS_MASK		0x1
#define MT3615_SOC_READY_STATUS_SHIFT		2
/**
 *@}
 */
/** @ingroup IP_group_pwm_external_enum
 * @brief Pwm channel number.
 * value is from 0 and 5.
 */
enum pwmchx {
		/** 0: pwm all channel 0~5*/
		PWMALL = 0,
		/** 1: pwm channel led1*/
		PWMLED1,
		/** 2: pwm channel led2*/
		PWMLED2,
		/** 3: pwm channel led3*/
		PWMLED3,
		/** 4: pwm channel pwm1*/
		PWM1,
		/** 5: pwm channel pwm2*/
		PWM2,
};

/** @ingroup IP_group_pwm_external_enum
 * @brief Pwm operate scenario.
 * value is from 0 and 7.
 */
enum pwmmode {
		/** 0: pwm normal reg operate*/
		PWM_RG = 0,
		/** 1: pwm standby reg operate*/
		PWR_STANDBY,
		/** 2: pwm on reg operate*/
		PWR_ON,
		/** 3: pwm off longpress reg operate*/
		PWR_OFF_LONGPRESS,
		/** 4: pwm reboot reg operate*/
		PWR_REBOOT,
		/** 5: pwm fail reg operate*/
		PWR_FAIL,
		/** 6: pwm fail wdt reg operate*/
		PWR_FAIL_WDT,
		/** 7: pwm on2 reg operate*/
		PWR_ON2,
};

/** @ingroup IP_group_pwm_external_enum
 * @brief Pwm led mode.
 * value is from 0 and 2.
 */
enum pwmledmode {
		/** 0: pwm ledx disable mode */
		PWM_DISABLE = 0,
		/** 1: pwm ledx fixed mode */
		PWM_FIXED,
		/** 2: pwm ledx flash mode */
		PWM_FLASH = 3,
};

/** @ingroup IP_group_pwm_external_enum
 * @brief Pwm1 operate case.
 * value is from 0 and 2.
 */
enum pwm1cfg {
		/** 0: pwm1 disble */
		PWM1_DISABLE = 0,
		/** 1: pwm1 enable */
		PWM1_ENABLE,
		/** 2: pwm1 config */
		PWM1_CONFIG,
};

/** @ingroup IP_group_pwm_external_enum
 * @brief Pwm2 operate case.
 * value is from 0 and 2.
 */
enum pwm2cfg {
		/** 0: pwm2 disble */
		PWM2_DISABLE = 0,
		/** 1: pwm2 enable */
		PWM2_ENABLE,
		/** 2: pwm2 config */
		PWM2_CONFIG,
};

#endif /* __MT3615_REG_H__ */
