/*
 * Copyright (C) 2015 Sony Interactive Entertainment Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  version 2 of the  License.
 *
 * THIS  SOFTWARE  IS PROVIDED   ``AS  IS AND   ANY  EXPRESS OR IMPLIED
 * WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 * NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 * USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 **/

#ifndef _HMUSYS_H
#define _HMUSYS_H

#define ISO_MAX_PACKET_SIZE			288
#define MMI_SENSOR_DATACH_LENGTH	96
#define MMI_SENSOR_DATACH_TIME_LENGTH	(MMI_SENSOR_DATACH_LENGTH + 8) /* add system_timestamp */

/* Get a minor range for your devices from the usb maintainer */
#define USB_PSEYE_MINOR_BASE	0

#define HMUSYS_INFO "INFO"

#define HMUSYS_CMD_BASE 0xff
#define HMUSYS_CMD_GET_VERSION _IO(HMUSYS_CMD_BASE, 2)					/* 65282 */
#define HMUSYS_CMD_GET_LAST_PACKET_TIMESTAMP _IO(HMUSYS_CMD_BASE, 4)	/* 65284 */
#define HMUSYS_CMD_GET_LAST_DEVICE_TIMESTAMP _IO(HMUSYS_CMD_BASE, 5)	/* 65285 */
#define HMUSYS_CMD_PAUSE_SENSOR_FORWARDING _IO(HMUSYS_CMD_BASE, 6)		/* 65286 */
#define HMUSYS_CMD_RESUME_SENSOR_FORWARDING _IO(HMUSYS_CMD_BASE, 7)		/* 65287 */
#define HMUSYS_CMD_GET_MIC_STAT _IO(HMUSYS_CMD_BASE, 9)					/* 65289 */
#define HMUSYS_CMD_GET_SENSOR_STAT _IO(HMUSYS_CMD_BASE, 10)				/* 65290 */
#define HMUSYS_REVISION (0x00020104)

#endif /* _HMUSYS_H */
