/*
 * Copyright (C) 2016 Sony Interactive Entertainment Inc.
 *
 * This program is free software; you can redistribute  it and/or modify it
 * under  the terms of  the GNU General  Public License as published by the
 * Free Software Foundation;  version 2 of the  License.
 *
 * THIS  SOFTWARE  IS PROVIDED   ``AS  IS AND   ANY  EXPRESS OR IMPLIED
 * WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 * NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 * USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * You should have received a copy of the  GNU General Public License along
 * with this program; if not, write  to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef _HOST_DEVICE_H_
#define _HOST_DEVICE_H_

/* Don't change this order. */
/* Updater Gadget uses values of when it was built. */
typedef enum MBRIDGE_CONTORL_EVENT {
	HOST_IOCTL_CHECK_STATE = 100,
	HOST_IOCTL_MAP_USER_SPACE,
	HOST_IOCTL_UNMAP_USER_SPACE,

	// Host USB Connection
	HOST_IOCTL_GET_RUNNING_MODE = 104,
	HOST_IOCTL_SET_NORMAL_MODE,
	HOST_IOCTL_SET_DFU_MODE,
	HOST_IOCTL_GET_USB_CONNECTED_STATE,
	HOST_IOCTL_QUIESCENT_EP,
	HOST_IOCTL_RESERVED2,
	HOST_IOCTL_RESERVED3,
	HOST_IOCTL_RESERVED4,

	// Device Authentication
	HOST_IOCTL_GET_AUTH_STATE,
	HOST_IOCTL_GET_AUTH1_DATA,
	HOST_IOCTL_NOTIFY_GET_AUTH1_DATA_DONE,
	HOST_IOCTL_SET_AUTH2_DATA,
	HOST_IOCTL_NOTIFY_SET_AUTH2_DATA_DONE,
	HOST_IOCTL_AUTH_SET_ERROR,
	HOST_IOCTL_NOTIFY_AUTH_CANCEL_START,
	HOST_IOCTL_NOTIFY_AUTH_CANCEL_DONE,

	// PS4 command with Control Transfer
	HOST_IOCTL_GET_CTRL_COMMAND_REQ,
	HOST_IOCTL_SET_CTRL_COMMAND_RESULT,
	HOST_IOCTL_SET_CTRL_REPORT_DATA,
	HOST_IOCTL_GET_CTRL_REPORT_DATA,

	/* Add new IOCTL cmd here */

	// Host Authentication
	// "User" gets/sets data, "Host" sets/gets data.
	HOST_IOCTL_RESET_HAUTH = 800,
	HOST_IOCTL_GET_HAUTH_HOST_HELLO,
	HOST_IOCTL_GET_HAUTH_START,
	HOST_IOCTL_GET_HAUTH_MSG2,
	HOST_IOCTL_GET_HAUTH_DATA,
	HOST_IOCTL_SET_HAUTH_DEV_HELLO,
	HOST_IOCTL_SET_HAUTH_MSG1,
	HOST_IOCTL_SET_HAUTH_STATUS,

	// Debug
	HOST_IOCTL_GET_DFU_RECEIVED_SIZE_DEBUG = 907,
	HOST_IOCTL_GET_DFU_PUSHED_SIZE_DEBUG,
	HOST_IOCTL_GET_DFU_POPPED_SIZE_DEBUG,
	HOST_IOCTL_RESET_DFU_SIZE_DEBUG,
	HOST_IOCTL_DEBUG_GET_HAUTH_DEV_HELLO,
	HOST_IOCTL_DEBUG_GET_HAUTH_MSG1,
	HOST_IOCTL_DEBUG_GET_HAUTH_STATUS,

	/* Add new IOCTL cmd for debug here */
	HOST_IOCTL_ISO_DEBUG = 1000
} _MBRIDGE_CONTORL_EVENT;

typedef enum MBRIDGE_PS4CMD_R_ID {
	MBRIDGE_R_ID_GET_COMMAND_STATUS = 0x40,
} _MBRIDGE_PS4CMD_R_ID;

typedef enum MBRIDGE_CTRLCMD_STATUS {
	MBRIDGE_CTRL_STATUS_SUCCEED = 0x00,
	MBRIDGE_CTRL_STATUS_PROCESS,
	MBRIDGE_CTRL_STATUS_ERROR,
} _MBRIDGE_CTRLCMD_STATUS;

#endif
