/******************************************************************************
 * Copyright (c) 2013-2014 Marvell International Ltd. and its affiliates.
 * All rights reserved.
 *
 * This software file (the "File") is owned and distributed by Marvell
 * International Ltd. and/or its affiliates ("Marvell") under the following
 * licensing terms.
 ******************************************************************************
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell and you have entered into a
 * commercial license agreement (a "Commercial License") with Marvell, the
 * File is licensed to you under the terms of the applicable Commercial
 * License.
 ******************************************************************************
 * Marvell GPL License Option
 *
 * If you received this File from Marvell, you may opt to use, redistribute
 * and/or modify this File in accordance with the terms and conditions of the
 * General Public License Version 2, June 1991 (the "GPL License"), a copy of
 * which is available along with the File in the license.txt file or by writing
 * to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
 * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE
 * EXPRESSLY DISCLAIMED. The GPL License provides additional details about this
 * warranty disclaimer.
 *******************************************************************************/
//////
/// don't edit! auto-generated by docc: zspWrapper.h
////////////////////////////////////////////////////////////
#ifndef zspWrapper_h
#define zspWrapper_h (){}


#include "ctypes.h"

#pragma pack(1)
#ifdef __cplusplus
  extern "C" {
#endif

#ifndef _DOCC_H_BITOPS_
#define _DOCC_H_BITOPS_ (){}

    #define _bSETMASK_(b)                                      ((b)<32 ? (1<<((b)&31)) : 0)
    #define _NSETMASK_(msb,lsb)                                (_bSETMASK_((msb)+1)-_bSETMASK_(lsb))
    #define _bCLRMASK_(b)                                      (~_bSETMASK_(b))
    #define _NCLRMASK_(msb,lsb)                                (~_NSETMASK_(msb,lsb))
    #define _BFGET_(r,msb,lsb)                                 (_NSETMASK_((msb)-(lsb),0)&((r)>>(lsb)))
    #define _BFSET_(r,msb,lsb,v)                               do{ (r)&=_NCLRMASK_(msb,lsb); (r)|=_NSETMASK_(msb,lsb)&((v)<<(lsb)); }while(0)

#endif



//////
/// 
/// $INTERFACE ZspGlobalRegs                            (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000 subsys_reset         (RW)
///               %unsigned 1  reset_n                   0x0
///                                    ###
///                                    * 0: reset the ZSP800_subsys except for the ZSP800 core logic
///                                    * 1: start the ZSP800_subsys except for the ZSP800 core logic
///                                    ###
///               %%        31         # Stuffing bits...
///     @ 0x00004 core_reset           (RW)
///               %unsigned 1  reset_n                   0x0
///                                    ###
///                                    * 0: reset the ZSP800 core logic
///                                    * 1: start the ZSP800 core logic
///                                    ###
///               %%        31         # Stuffing bits...
///     @ 0x00008 clock_ctrl           (RW)
///               %unsigned 1  enable                    0x1
///                                    ###
///                                    * 1: enable the clock of ZSP800_subsys
///                                    ###
///               %%        31         # Stuffing bits...
///     @ 0x0000C ext_bp               (RW)
///               %unsigned 4  ext_bp                    0x0
///               %%        28         # Stuffing bits...
///     @ 0x00010 halt                 (RW)
///               %unsigned 1  halt                      0x0
///                                    ###
///                                    * halt the zsp core
///                                    ###
///               %%        31         # Stuffing bits...
///     @ 0x00014 status               (R-)
///               %unsigned 1  deu_ccu_halt_ahb          0x0
///               %unsigned 1  zsp_idle_sleep            0x0
///               %unsigned 1  zsp_halted                0x0
///               %unsigned 1  deu_ccu_halt_cpu          0x0
///               %unsigned 1  mbx_flag                  0x0
///               %%        27         # Stuffing bits...
///     @ 0x00018                      (W-)
///     #         # Stuffing bytes...
///               %% 32
///     @ 0x0001C svtaddr              (RW)
///               %%        9          # Stuffing bits...
///               %unsigned 23 svtaddr                   0x0
///                                    ###
///                                    * This is the boot up address of ZSP in byte. After the core_reset is released, ZSP will fetch the first instruction from address {svtaddr,9’d0}.
///                                    ###
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:      32B, bits:      36b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_ZspGlobalRegs
#define h_ZspGlobalRegs (){}

    #define     RA_ZspGlobalRegs_subsys_reset                  0x0000

    #define     BA_ZspGlobalRegs_subsys_reset_reset_n          0x0000
    #define     B16ZspGlobalRegs_subsys_reset_reset_n          0x0000
    #define   LSb32ZspGlobalRegs_subsys_reset_reset_n             0
    #define   LSb16ZspGlobalRegs_subsys_reset_reset_n             0
    #define       bZspGlobalRegs_subsys_reset_reset_n          1
    #define   MSK32ZspGlobalRegs_subsys_reset_reset_n             0x00000001
    ///////////////////////////////////////////////////////////
    #define     RA_ZspGlobalRegs_core_reset                    0x0004

    #define     BA_ZspGlobalRegs_core_reset_reset_n            0x0004
    #define     B16ZspGlobalRegs_core_reset_reset_n            0x0004
    #define   LSb32ZspGlobalRegs_core_reset_reset_n               0
    #define   LSb16ZspGlobalRegs_core_reset_reset_n               0
    #define       bZspGlobalRegs_core_reset_reset_n            1
    #define   MSK32ZspGlobalRegs_core_reset_reset_n               0x00000001
    ///////////////////////////////////////////////////////////
    #define     RA_ZspGlobalRegs_clock_ctrl                    0x0008

    #define     BA_ZspGlobalRegs_clock_ctrl_enable             0x0008
    #define     B16ZspGlobalRegs_clock_ctrl_enable             0x0008
    #define   LSb32ZspGlobalRegs_clock_ctrl_enable                0
    #define   LSb16ZspGlobalRegs_clock_ctrl_enable                0
    #define       bZspGlobalRegs_clock_ctrl_enable             1
    #define   MSK32ZspGlobalRegs_clock_ctrl_enable                0x00000001
    ///////////////////////////////////////////////////////////
    #define     RA_ZspGlobalRegs_ext_bp                        0x000C

    #define     BA_ZspGlobalRegs_ext_bp_ext_bp                 0x000C
    #define     B16ZspGlobalRegs_ext_bp_ext_bp                 0x000C
    #define   LSb32ZspGlobalRegs_ext_bp_ext_bp                    0
    #define   LSb16ZspGlobalRegs_ext_bp_ext_bp                    0
    #define       bZspGlobalRegs_ext_bp_ext_bp                 4
    #define   MSK32ZspGlobalRegs_ext_bp_ext_bp                    0x0000000F
    ///////////////////////////////////////////////////////////
    #define     RA_ZspGlobalRegs_halt                          0x0010

    #define     BA_ZspGlobalRegs_halt_halt                     0x0010
    #define     B16ZspGlobalRegs_halt_halt                     0x0010
    #define   LSb32ZspGlobalRegs_halt_halt                        0
    #define   LSb16ZspGlobalRegs_halt_halt                        0
    #define       bZspGlobalRegs_halt_halt                     1
    #define   MSK32ZspGlobalRegs_halt_halt                        0x00000001
    ///////////////////////////////////////////////////////////
    #define     RA_ZspGlobalRegs_status                        0x0014

    #define     BA_ZspGlobalRegs_status_deu_ccu_halt_ahb       0x0014
    #define     B16ZspGlobalRegs_status_deu_ccu_halt_ahb       0x0014
    #define   LSb32ZspGlobalRegs_status_deu_ccu_halt_ahb          0
    #define   LSb16ZspGlobalRegs_status_deu_ccu_halt_ahb          0
    #define       bZspGlobalRegs_status_deu_ccu_halt_ahb       1
    #define   MSK32ZspGlobalRegs_status_deu_ccu_halt_ahb          0x00000001

    #define     BA_ZspGlobalRegs_status_zsp_idle_sleep         0x0014
    #define     B16ZspGlobalRegs_status_zsp_idle_sleep         0x0014
    #define   LSb32ZspGlobalRegs_status_zsp_idle_sleep            1
    #define   LSb16ZspGlobalRegs_status_zsp_idle_sleep            1
    #define       bZspGlobalRegs_status_zsp_idle_sleep         1
    #define   MSK32ZspGlobalRegs_status_zsp_idle_sleep            0x00000002

    #define     BA_ZspGlobalRegs_status_zsp_halted             0x0014
    #define     B16ZspGlobalRegs_status_zsp_halted             0x0014
    #define   LSb32ZspGlobalRegs_status_zsp_halted                2
    #define   LSb16ZspGlobalRegs_status_zsp_halted                2
    #define       bZspGlobalRegs_status_zsp_halted             1
    #define   MSK32ZspGlobalRegs_status_zsp_halted                0x00000004

    #define     BA_ZspGlobalRegs_status_deu_ccu_halt_cpu       0x0014
    #define     B16ZspGlobalRegs_status_deu_ccu_halt_cpu       0x0014
    #define   LSb32ZspGlobalRegs_status_deu_ccu_halt_cpu          3
    #define   LSb16ZspGlobalRegs_status_deu_ccu_halt_cpu          3
    #define       bZspGlobalRegs_status_deu_ccu_halt_cpu       1
    #define   MSK32ZspGlobalRegs_status_deu_ccu_halt_cpu          0x00000008

    #define     BA_ZspGlobalRegs_status_mbx_flag               0x0014
    #define     B16ZspGlobalRegs_status_mbx_flag               0x0014
    #define   LSb32ZspGlobalRegs_status_mbx_flag                  4
    #define   LSb16ZspGlobalRegs_status_mbx_flag                  4
    #define       bZspGlobalRegs_status_mbx_flag               1
    #define   MSK32ZspGlobalRegs_status_mbx_flag                  0x00000010
    ///////////////////////////////////////////////////////////
    #define     RA_ZspGlobalRegs_svtaddr                       0x001C

    #define     BA_ZspGlobalRegs_svtaddr_svtaddr               0x001D
    #define     B16ZspGlobalRegs_svtaddr_svtaddr               0x001C
    #define   LSb32ZspGlobalRegs_svtaddr_svtaddr                  9
    #define   LSb16ZspGlobalRegs_svtaddr_svtaddr                  9
    #define       bZspGlobalRegs_svtaddr_svtaddr               23
    #define   MSK32ZspGlobalRegs_svtaddr_svtaddr                  0xFFFFFE00
    ///////////////////////////////////////////////////////////

    typedef struct SIE_ZspGlobalRegs {
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_subsys_reset_reset_n(r32)     _BFGET_(r32, 0, 0)
    #define   SET32ZspGlobalRegs_subsys_reset_reset_n(r32,v)   _BFSET_(r32, 0, 0,v)
    #define   GET16ZspGlobalRegs_subsys_reset_reset_n(r16)     _BFGET_(r16, 0, 0)
    #define   SET16ZspGlobalRegs_subsys_reset_reset_n(r16,v)   _BFSET_(r16, 0, 0,v)

    #define     w32ZspGlobalRegs_subsys_reset                  {\
            UNSG32 usubsys_reset_reset_n                       :  1;\
            UNSG32 RSVDx0_b1                                   : 31;\
          }
    union { UNSG32 u32ZspGlobalRegs_subsys_reset;
            struct w32ZspGlobalRegs_subsys_reset;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_core_reset_reset_n(r32)       _BFGET_(r32, 0, 0)
    #define   SET32ZspGlobalRegs_core_reset_reset_n(r32,v)     _BFSET_(r32, 0, 0,v)
    #define   GET16ZspGlobalRegs_core_reset_reset_n(r16)       _BFGET_(r16, 0, 0)
    #define   SET16ZspGlobalRegs_core_reset_reset_n(r16,v)     _BFSET_(r16, 0, 0,v)

    #define     w32ZspGlobalRegs_core_reset                    {\
            UNSG32 ucore_reset_reset_n                         :  1;\
            UNSG32 RSVDx4_b1                                   : 31;\
          }
    union { UNSG32 u32ZspGlobalRegs_core_reset;
            struct w32ZspGlobalRegs_core_reset;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_clock_ctrl_enable(r32)        _BFGET_(r32, 0, 0)
    #define   SET32ZspGlobalRegs_clock_ctrl_enable(r32,v)      _BFSET_(r32, 0, 0,v)
    #define   GET16ZspGlobalRegs_clock_ctrl_enable(r16)        _BFGET_(r16, 0, 0)
    #define   SET16ZspGlobalRegs_clock_ctrl_enable(r16,v)      _BFSET_(r16, 0, 0,v)

    #define     w32ZspGlobalRegs_clock_ctrl                    {\
            UNSG32 uclock_ctrl_enable                          :  1;\
            UNSG32 RSVDx8_b1                                   : 31;\
          }
    union { UNSG32 u32ZspGlobalRegs_clock_ctrl;
            struct w32ZspGlobalRegs_clock_ctrl;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_ext_bp_ext_bp(r32)            _BFGET_(r32, 3, 0)
    #define   SET32ZspGlobalRegs_ext_bp_ext_bp(r32,v)          _BFSET_(r32, 3, 0,v)
    #define   GET16ZspGlobalRegs_ext_bp_ext_bp(r16)            _BFGET_(r16, 3, 0)
    #define   SET16ZspGlobalRegs_ext_bp_ext_bp(r16,v)          _BFSET_(r16, 3, 0,v)

    #define     w32ZspGlobalRegs_ext_bp                        {\
            UNSG32 uext_bp_ext_bp                              :  4;\
            UNSG32 RSVDxC_b4                                   : 28;\
          }
    union { UNSG32 u32ZspGlobalRegs_ext_bp;
            struct w32ZspGlobalRegs_ext_bp;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_halt_halt(r32)                _BFGET_(r32, 0, 0)
    #define   SET32ZspGlobalRegs_halt_halt(r32,v)              _BFSET_(r32, 0, 0,v)
    #define   GET16ZspGlobalRegs_halt_halt(r16)                _BFGET_(r16, 0, 0)
    #define   SET16ZspGlobalRegs_halt_halt(r16,v)              _BFSET_(r16, 0, 0,v)

    #define     w32ZspGlobalRegs_halt                          {\
            UNSG32 uhalt_halt                                  :  1;\
            UNSG32 RSVDx10_b1                                  : 31;\
          }
    union { UNSG32 u32ZspGlobalRegs_halt;
            struct w32ZspGlobalRegs_halt;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_status_deu_ccu_halt_ahb(r32)  _BFGET_(r32, 0, 0)
    #define   SET32ZspGlobalRegs_status_deu_ccu_halt_ahb(r32,v) _BFSET_(r32, 0, 0,v)
    #define   GET16ZspGlobalRegs_status_deu_ccu_halt_ahb(r16)  _BFGET_(r16, 0, 0)
    #define   SET16ZspGlobalRegs_status_deu_ccu_halt_ahb(r16,v) _BFSET_(r16, 0, 0,v)

    #define   GET32ZspGlobalRegs_status_zsp_idle_sleep(r32)    _BFGET_(r32, 1, 1)
    #define   SET32ZspGlobalRegs_status_zsp_idle_sleep(r32,v)  _BFSET_(r32, 1, 1,v)
    #define   GET16ZspGlobalRegs_status_zsp_idle_sleep(r16)    _BFGET_(r16, 1, 1)
    #define   SET16ZspGlobalRegs_status_zsp_idle_sleep(r16,v)  _BFSET_(r16, 1, 1,v)

    #define   GET32ZspGlobalRegs_status_zsp_halted(r32)        _BFGET_(r32, 2, 2)
    #define   SET32ZspGlobalRegs_status_zsp_halted(r32,v)      _BFSET_(r32, 2, 2,v)
    #define   GET16ZspGlobalRegs_status_zsp_halted(r16)        _BFGET_(r16, 2, 2)
    #define   SET16ZspGlobalRegs_status_zsp_halted(r16,v)      _BFSET_(r16, 2, 2,v)

    #define   GET32ZspGlobalRegs_status_deu_ccu_halt_cpu(r32)  _BFGET_(r32, 3, 3)
    #define   SET32ZspGlobalRegs_status_deu_ccu_halt_cpu(r32,v) _BFSET_(r32, 3, 3,v)
    #define   GET16ZspGlobalRegs_status_deu_ccu_halt_cpu(r16)  _BFGET_(r16, 3, 3)
    #define   SET16ZspGlobalRegs_status_deu_ccu_halt_cpu(r16,v) _BFSET_(r16, 3, 3,v)

    #define   GET32ZspGlobalRegs_status_mbx_flag(r32)          _BFGET_(r32, 4, 4)
    #define   SET32ZspGlobalRegs_status_mbx_flag(r32,v)        _BFSET_(r32, 4, 4,v)
    #define   GET16ZspGlobalRegs_status_mbx_flag(r16)          _BFGET_(r16, 4, 4)
    #define   SET16ZspGlobalRegs_status_mbx_flag(r16,v)        _BFSET_(r16, 4, 4,v)

    #define     w32ZspGlobalRegs_status                        {\
            UNSG32 ustatus_deu_ccu_halt_ahb                    :  1;\
            UNSG32 ustatus_zsp_idle_sleep                      :  1;\
            UNSG32 ustatus_zsp_halted                          :  1;\
            UNSG32 ustatus_deu_ccu_halt_cpu                    :  1;\
            UNSG32 ustatus_mbx_flag                            :  1;\
            UNSG32 RSVDx14_b5                                  : 27;\
          }
    union { UNSG32 u32ZspGlobalRegs_status;
            struct w32ZspGlobalRegs_status;
          };
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx18                                     [4];
    ///////////////////////////////////////////////////////////
    #define   GET32ZspGlobalRegs_svtaddr_svtaddr(r32)          _BFGET_(r32,31, 9)
    #define   SET32ZspGlobalRegs_svtaddr_svtaddr(r32,v)        _BFSET_(r32,31, 9,v)

    #define     w32ZspGlobalRegs_svtaddr                       {\
            UNSG32 RSVDx1C                                     :  9;\
            UNSG32 usvtaddr_svtaddr                            : 23;\
          }
    union { UNSG32 u32ZspGlobalRegs_svtaddr;
            struct w32ZspGlobalRegs_svtaddr;
          };
    ///////////////////////////////////////////////////////////
    } SIE_ZspGlobalRegs;

    typedef union  T32ZspGlobalRegs_subsys_reset
          { UNSG32 u32;
            struct w32ZspGlobalRegs_subsys_reset;
                 } T32ZspGlobalRegs_subsys_reset;
    typedef union  T32ZspGlobalRegs_core_reset
          { UNSG32 u32;
            struct w32ZspGlobalRegs_core_reset;
                 } T32ZspGlobalRegs_core_reset;
    typedef union  T32ZspGlobalRegs_clock_ctrl
          { UNSG32 u32;
            struct w32ZspGlobalRegs_clock_ctrl;
                 } T32ZspGlobalRegs_clock_ctrl;
    typedef union  T32ZspGlobalRegs_ext_bp
          { UNSG32 u32;
            struct w32ZspGlobalRegs_ext_bp;
                 } T32ZspGlobalRegs_ext_bp;
    typedef union  T32ZspGlobalRegs_halt
          { UNSG32 u32;
            struct w32ZspGlobalRegs_halt;
                 } T32ZspGlobalRegs_halt;
    typedef union  T32ZspGlobalRegs_status
          { UNSG32 u32;
            struct w32ZspGlobalRegs_status;
                 } T32ZspGlobalRegs_status;
    typedef union  T32ZspGlobalRegs_svtaddr
          { UNSG32 u32;
            struct w32ZspGlobalRegs_svtaddr;
                 } T32ZspGlobalRegs_svtaddr;
    ///////////////////////////////////////////////////////////

    typedef union  TZspGlobalRegs_subsys_reset
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_subsys_reset;
                   };
                 } TZspGlobalRegs_subsys_reset;
    typedef union  TZspGlobalRegs_core_reset
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_core_reset;
                   };
                 } TZspGlobalRegs_core_reset;
    typedef union  TZspGlobalRegs_clock_ctrl
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_clock_ctrl;
                   };
                 } TZspGlobalRegs_clock_ctrl;
    typedef union  TZspGlobalRegs_ext_bp
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_ext_bp;
                   };
                 } TZspGlobalRegs_ext_bp;
    typedef union  TZspGlobalRegs_halt
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_halt;
                   };
                 } TZspGlobalRegs_halt;
    typedef union  TZspGlobalRegs_status
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_status;
                   };
                 } TZspGlobalRegs_status;
    typedef union  TZspGlobalRegs_svtaddr
          { UNSG32 u32[1];
            struct {
            struct w32ZspGlobalRegs_svtaddr;
                   };
                 } TZspGlobalRegs_svtaddr;

    ///////////////////////////////////////////////////////////
     SIGN32 ZspGlobalRegs_drvrd(SIE_ZspGlobalRegs *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 ZspGlobalRegs_drvwr(SIE_ZspGlobalRegs *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void ZspGlobalRegs_reset(SIE_ZspGlobalRegs *p);
     SIGN32 ZspGlobalRegs_cmp  (SIE_ZspGlobalRegs *p, SIE_ZspGlobalRegs *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define ZspGlobalRegs_check(p,pie,pfx,hLOG) ZspGlobalRegs_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define ZspGlobalRegs_print(p,    pfx,hLOG) ZspGlobalRegs_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: ZspGlobalRegs
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE ZspInt2Zsp                               (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000 status               (R-)
///               %unsigned 16 status                    0x0
///                                    ###
///                                    * Interrupt status bits.
///                                    * For any bit, a low to high transition will trigger an interrupt to the ZSP core.
///                                    ###
///               %%        16         # Stuffing bits...
///     @ 0x00004 set                  (W-)
///               %unsigned 4  id                        
///                                    ###
///                                    * Writing to this address will set the status[id] to high.
///                                    ###
///               %%        28         # Stuffing bits...
///     @ 0x00008 clear                (W-)
///               %unsigned 4  id                        
///                                    ###
///                                    * Writing to this address will set the status[id] to low.
///                                    ###
///               %%        28         # Stuffing bits...
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:      12B, bits:      24b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_ZspInt2Zsp
#define h_ZspInt2Zsp (){}

    #define     RA_ZspInt2Zsp_status                           0x0000

    #define     BA_ZspInt2Zsp_status_status                    0x0000
    #define     B16ZspInt2Zsp_status_status                    0x0000
    #define   LSb32ZspInt2Zsp_status_status                       0
    #define   LSb16ZspInt2Zsp_status_status                       0
    #define       bZspInt2Zsp_status_status                    16
    #define   MSK32ZspInt2Zsp_status_status                       0x0000FFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspInt2Zsp_set                              0x0004

    #define     BA_ZspInt2Zsp_set_id                           0x0004
    #define     B16ZspInt2Zsp_set_id                           0x0004
    #define   LSb32ZspInt2Zsp_set_id                              0
    #define   LSb16ZspInt2Zsp_set_id                              0
    #define       bZspInt2Zsp_set_id                           4
    #define   MSK32ZspInt2Zsp_set_id                              0x0000000F
    ///////////////////////////////////////////////////////////
    #define     RA_ZspInt2Zsp_clear                            0x0008

    #define     BA_ZspInt2Zsp_clear_id                         0x0008
    #define     B16ZspInt2Zsp_clear_id                         0x0008
    #define   LSb32ZspInt2Zsp_clear_id                            0
    #define   LSb16ZspInt2Zsp_clear_id                            0
    #define       bZspInt2Zsp_clear_id                         4
    #define   MSK32ZspInt2Zsp_clear_id                            0x0000000F
    ///////////////////////////////////////////////////////////

    typedef struct SIE_ZspInt2Zsp {
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Zsp_status_status(r32)               _BFGET_(r32,15, 0)
    #define   SET32ZspInt2Zsp_status_status(r32,v)             _BFSET_(r32,15, 0,v)
    #define   GET16ZspInt2Zsp_status_status(r16)               _BFGET_(r16,15, 0)
    #define   SET16ZspInt2Zsp_status_status(r16,v)             _BFSET_(r16,15, 0,v)

    #define     w32ZspInt2Zsp_status                           {\
            UNSG32 ustatus_status                              : 16;\
            UNSG32 RSVDx0_b16                                  : 16;\
          }
    union { UNSG32 u32ZspInt2Zsp_status;
            struct w32ZspInt2Zsp_status;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Zsp_set_id(r32)                      _BFGET_(r32, 3, 0)
    #define   SET32ZspInt2Zsp_set_id(r32,v)                    _BFSET_(r32, 3, 0,v)
    #define   GET16ZspInt2Zsp_set_id(r16)                      _BFGET_(r16, 3, 0)
    #define   SET16ZspInt2Zsp_set_id(r16,v)                    _BFSET_(r16, 3, 0,v)

    #define     w32ZspInt2Zsp_set                              {\
            UNSG32 uset_id                                     :  4;\
            UNSG32 RSVDx4_b4                                   : 28;\
          }
    union { UNSG32 u32ZspInt2Zsp_set;
            struct w32ZspInt2Zsp_set;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Zsp_clear_id(r32)                    _BFGET_(r32, 3, 0)
    #define   SET32ZspInt2Zsp_clear_id(r32,v)                  _BFSET_(r32, 3, 0,v)
    #define   GET16ZspInt2Zsp_clear_id(r16)                    _BFGET_(r16, 3, 0)
    #define   SET16ZspInt2Zsp_clear_id(r16,v)                  _BFSET_(r16, 3, 0,v)

    #define     w32ZspInt2Zsp_clear                            {\
            UNSG32 uclear_id                                   :  4;\
            UNSG32 RSVDx8_b4                                   : 28;\
          }
    union { UNSG32 u32ZspInt2Zsp_clear;
            struct w32ZspInt2Zsp_clear;
          };
    ///////////////////////////////////////////////////////////
    } SIE_ZspInt2Zsp;

    typedef union  T32ZspInt2Zsp_status
          { UNSG32 u32;
            struct w32ZspInt2Zsp_status;
                 } T32ZspInt2Zsp_status;
    typedef union  T32ZspInt2Zsp_set
          { UNSG32 u32;
            struct w32ZspInt2Zsp_set;
                 } T32ZspInt2Zsp_set;
    typedef union  T32ZspInt2Zsp_clear
          { UNSG32 u32;
            struct w32ZspInt2Zsp_clear;
                 } T32ZspInt2Zsp_clear;
    ///////////////////////////////////////////////////////////

    typedef union  TZspInt2Zsp_status
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Zsp_status;
                   };
                 } TZspInt2Zsp_status;
    typedef union  TZspInt2Zsp_set
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Zsp_set;
                   };
                 } TZspInt2Zsp_set;
    typedef union  TZspInt2Zsp_clear
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Zsp_clear;
                   };
                 } TZspInt2Zsp_clear;

    ///////////////////////////////////////////////////////////
     SIGN32 ZspInt2Zsp_drvrd(SIE_ZspInt2Zsp *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 ZspInt2Zsp_drvwr(SIE_ZspInt2Zsp *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void ZspInt2Zsp_reset(SIE_ZspInt2Zsp *p);
     SIGN32 ZspInt2Zsp_cmp  (SIE_ZspInt2Zsp *p, SIE_ZspInt2Zsp *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define ZspInt2Zsp_check(p,pie,pfx,hLOG) ZspInt2Zsp_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define ZspInt2Zsp_print(p,    pfx,hLOG) ZspInt2Zsp_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: ZspInt2Zsp
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE ZspInt2Soc                               (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000 status               (R-)
///               %unsigned 16 status                    0x0
///                                    ###
///                                    * Interrupt status bits.
///                                    * If any of the enabled interrupt bits is high, port zspInt will be high.
///                                    ###
///               %%        16         # Stuffing bits...
///     @ 0x00004 set                  (W-)
///               %unsigned 4  id                        
///                                    ###
///                                    * Writing to this address will set the status[id] to high.
///                                    ###
///               %%        28         # Stuffing bits...
///     @ 0x00008 clear                (W-)
///               %unsigned 4  id                        
///                                    ###
///                                    * Writing to this address will set the status[id] to low.
///                                    ###
///               %%        28         # Stuffing bits...
///     @ 0x0000C enable               (RW)
///               %unsigned 16 enable                    0x0
///                                    ###
///                                    * Interrupt enable bit.
///                                    * For each bit, 1 indicates the interrupt for that bit is enabled
///                                    ###
///               %%        16         # Stuffing bits...
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:      16B, bits:      40b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_ZspInt2Soc
#define h_ZspInt2Soc (){}

    #define     RA_ZspInt2Soc_status                           0x0000

    #define     BA_ZspInt2Soc_status_status                    0x0000
    #define     B16ZspInt2Soc_status_status                    0x0000
    #define   LSb32ZspInt2Soc_status_status                       0
    #define   LSb16ZspInt2Soc_status_status                       0
    #define       bZspInt2Soc_status_status                    16
    #define   MSK32ZspInt2Soc_status_status                       0x0000FFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspInt2Soc_set                              0x0004

    #define     BA_ZspInt2Soc_set_id                           0x0004
    #define     B16ZspInt2Soc_set_id                           0x0004
    #define   LSb32ZspInt2Soc_set_id                              0
    #define   LSb16ZspInt2Soc_set_id                              0
    #define       bZspInt2Soc_set_id                           4
    #define   MSK32ZspInt2Soc_set_id                              0x0000000F
    ///////////////////////////////////////////////////////////
    #define     RA_ZspInt2Soc_clear                            0x0008

    #define     BA_ZspInt2Soc_clear_id                         0x0008
    #define     B16ZspInt2Soc_clear_id                         0x0008
    #define   LSb32ZspInt2Soc_clear_id                            0
    #define   LSb16ZspInt2Soc_clear_id                            0
    #define       bZspInt2Soc_clear_id                         4
    #define   MSK32ZspInt2Soc_clear_id                            0x0000000F
    ///////////////////////////////////////////////////////////
    #define     RA_ZspInt2Soc_enable                           0x000C

    #define     BA_ZspInt2Soc_enable_enable                    0x000C
    #define     B16ZspInt2Soc_enable_enable                    0x000C
    #define   LSb32ZspInt2Soc_enable_enable                       0
    #define   LSb16ZspInt2Soc_enable_enable                       0
    #define       bZspInt2Soc_enable_enable                    16
    #define   MSK32ZspInt2Soc_enable_enable                       0x0000FFFF
    ///////////////////////////////////////////////////////////

    typedef struct SIE_ZspInt2Soc {
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Soc_status_status(r32)               _BFGET_(r32,15, 0)
    #define   SET32ZspInt2Soc_status_status(r32,v)             _BFSET_(r32,15, 0,v)
    #define   GET16ZspInt2Soc_status_status(r16)               _BFGET_(r16,15, 0)
    #define   SET16ZspInt2Soc_status_status(r16,v)             _BFSET_(r16,15, 0,v)

    #define     w32ZspInt2Soc_status                           {\
            UNSG32 ustatus_status                              : 16;\
            UNSG32 RSVDx0_b16                                  : 16;\
          }
    union { UNSG32 u32ZspInt2Soc_status;
            struct w32ZspInt2Soc_status;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Soc_set_id(r32)                      _BFGET_(r32, 3, 0)
    #define   SET32ZspInt2Soc_set_id(r32,v)                    _BFSET_(r32, 3, 0,v)
    #define   GET16ZspInt2Soc_set_id(r16)                      _BFGET_(r16, 3, 0)
    #define   SET16ZspInt2Soc_set_id(r16,v)                    _BFSET_(r16, 3, 0,v)

    #define     w32ZspInt2Soc_set                              {\
            UNSG32 uset_id                                     :  4;\
            UNSG32 RSVDx4_b4                                   : 28;\
          }
    union { UNSG32 u32ZspInt2Soc_set;
            struct w32ZspInt2Soc_set;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Soc_clear_id(r32)                    _BFGET_(r32, 3, 0)
    #define   SET32ZspInt2Soc_clear_id(r32,v)                  _BFSET_(r32, 3, 0,v)
    #define   GET16ZspInt2Soc_clear_id(r16)                    _BFGET_(r16, 3, 0)
    #define   SET16ZspInt2Soc_clear_id(r16,v)                  _BFSET_(r16, 3, 0,v)

    #define     w32ZspInt2Soc_clear                            {\
            UNSG32 uclear_id                                   :  4;\
            UNSG32 RSVDx8_b4                                   : 28;\
          }
    union { UNSG32 u32ZspInt2Soc_clear;
            struct w32ZspInt2Soc_clear;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspInt2Soc_enable_enable(r32)               _BFGET_(r32,15, 0)
    #define   SET32ZspInt2Soc_enable_enable(r32,v)             _BFSET_(r32,15, 0,v)
    #define   GET16ZspInt2Soc_enable_enable(r16)               _BFGET_(r16,15, 0)
    #define   SET16ZspInt2Soc_enable_enable(r16,v)             _BFSET_(r16,15, 0,v)

    #define     w32ZspInt2Soc_enable                           {\
            UNSG32 uenable_enable                              : 16;\
            UNSG32 RSVDxC_b16                                  : 16;\
          }
    union { UNSG32 u32ZspInt2Soc_enable;
            struct w32ZspInt2Soc_enable;
          };
    ///////////////////////////////////////////////////////////
    } SIE_ZspInt2Soc;

    typedef union  T32ZspInt2Soc_status
          { UNSG32 u32;
            struct w32ZspInt2Soc_status;
                 } T32ZspInt2Soc_status;
    typedef union  T32ZspInt2Soc_set
          { UNSG32 u32;
            struct w32ZspInt2Soc_set;
                 } T32ZspInt2Soc_set;
    typedef union  T32ZspInt2Soc_clear
          { UNSG32 u32;
            struct w32ZspInt2Soc_clear;
                 } T32ZspInt2Soc_clear;
    typedef union  T32ZspInt2Soc_enable
          { UNSG32 u32;
            struct w32ZspInt2Soc_enable;
                 } T32ZspInt2Soc_enable;
    ///////////////////////////////////////////////////////////

    typedef union  TZspInt2Soc_status
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Soc_status;
                   };
                 } TZspInt2Soc_status;
    typedef union  TZspInt2Soc_set
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Soc_set;
                   };
                 } TZspInt2Soc_set;
    typedef union  TZspInt2Soc_clear
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Soc_clear;
                   };
                 } TZspInt2Soc_clear;
    typedef union  TZspInt2Soc_enable
          { UNSG32 u32[1];
            struct {
            struct w32ZspInt2Soc_enable;
                   };
                 } TZspInt2Soc_enable;

    ///////////////////////////////////////////////////////////
     SIGN32 ZspInt2Soc_drvrd(SIE_ZspInt2Soc *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 ZspInt2Soc_drvwr(SIE_ZspInt2Soc *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void ZspInt2Soc_reset(SIE_ZspInt2Soc *p);
     SIGN32 ZspInt2Soc_cmp  (SIE_ZspInt2Soc *p, SIE_ZspInt2Soc *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define ZspInt2Soc_check(p,pie,pfx,hLOG) ZspInt2Soc_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define ZspInt2Soc_print(p,    pfx,hLOG) ZspInt2Soc_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: ZspInt2Soc
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE ZspDmaRegs                               (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000 srcAddr              (RW)
///               %unsigned 32 addr                      
///                                    ###
///                                    * Source address in byte
///                                    ###
///     @ 0x00004 desAddr              (RW)
///               %unsigned 32 addr                      
///                                    ###
///                                    * Destination address in byte
///                                    ###
///     @ 0x00008 config               (RW)
///               %unsigned 24 size                      
///                                    ###
///                                    * Number of bytes to transfer
///                                    * Writing non-zero value to this address will start the DMA transfer.
///                                    ###
///               %%        8          # Stuffing bits...
///     @ 0x0000C status               (R-)
///               %unsigned 1  busy                      0x0
///                                    ###
///                                    * Indicates that the DMA is busy
///                                    ###
///               %unsigned 1  error                     0x0
///                                    ###
///                                    * Indicates that the last writing to ZspDmaRegs.config.size fails to start a DMA transfer because another one is ongoing. It will be cleared with the successful start of next DMA transfer.
///                                    ###
///               %%        30         # Stuffing bits...
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:      16B, bits:      90b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_ZspDmaRegs
#define h_ZspDmaRegs (){}

    #define     RA_ZspDmaRegs_srcAddr                          0x0000

    #define     BA_ZspDmaRegs_srcAddr_addr                     0x0000
    #define     B16ZspDmaRegs_srcAddr_addr                     0x0000
    #define   LSb32ZspDmaRegs_srcAddr_addr                        0
    #define   LSb16ZspDmaRegs_srcAddr_addr                        0
    #define       bZspDmaRegs_srcAddr_addr                     32
    #define   MSK32ZspDmaRegs_srcAddr_addr                        0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspDmaRegs_desAddr                          0x0004

    #define     BA_ZspDmaRegs_desAddr_addr                     0x0004
    #define     B16ZspDmaRegs_desAddr_addr                     0x0004
    #define   LSb32ZspDmaRegs_desAddr_addr                        0
    #define   LSb16ZspDmaRegs_desAddr_addr                        0
    #define       bZspDmaRegs_desAddr_addr                     32
    #define   MSK32ZspDmaRegs_desAddr_addr                        0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspDmaRegs_config                           0x0008

    #define     BA_ZspDmaRegs_config_size                      0x0008
    #define     B16ZspDmaRegs_config_size                      0x0008
    #define   LSb32ZspDmaRegs_config_size                         0
    #define   LSb16ZspDmaRegs_config_size                         0
    #define       bZspDmaRegs_config_size                      24
    #define   MSK32ZspDmaRegs_config_size                         0x00FFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspDmaRegs_status                           0x000C

    #define     BA_ZspDmaRegs_status_busy                      0x000C
    #define     B16ZspDmaRegs_status_busy                      0x000C
    #define   LSb32ZspDmaRegs_status_busy                         0
    #define   LSb16ZspDmaRegs_status_busy                         0
    #define       bZspDmaRegs_status_busy                      1
    #define   MSK32ZspDmaRegs_status_busy                         0x00000001

    #define     BA_ZspDmaRegs_status_error                     0x000C
    #define     B16ZspDmaRegs_status_error                     0x000C
    #define   LSb32ZspDmaRegs_status_error                        1
    #define   LSb16ZspDmaRegs_status_error                        1
    #define       bZspDmaRegs_status_error                     1
    #define   MSK32ZspDmaRegs_status_error                        0x00000002
    ///////////////////////////////////////////////////////////

    typedef struct SIE_ZspDmaRegs {
    ///////////////////////////////////////////////////////////
    #define   GET32ZspDmaRegs_srcAddr_addr(r32)                _BFGET_(r32,31, 0)
    #define   SET32ZspDmaRegs_srcAddr_addr(r32,v)              _BFSET_(r32,31, 0,v)

    #define     w32ZspDmaRegs_srcAddr                          {\
            UNSG32 usrcAddr_addr                               : 32;\
          }
    union { UNSG32 u32ZspDmaRegs_srcAddr;
            struct w32ZspDmaRegs_srcAddr;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspDmaRegs_desAddr_addr(r32)                _BFGET_(r32,31, 0)
    #define   SET32ZspDmaRegs_desAddr_addr(r32,v)              _BFSET_(r32,31, 0,v)

    #define     w32ZspDmaRegs_desAddr                          {\
            UNSG32 udesAddr_addr                               : 32;\
          }
    union { UNSG32 u32ZspDmaRegs_desAddr;
            struct w32ZspDmaRegs_desAddr;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspDmaRegs_config_size(r32)                 _BFGET_(r32,23, 0)
    #define   SET32ZspDmaRegs_config_size(r32,v)               _BFSET_(r32,23, 0,v)

    #define     w32ZspDmaRegs_config                           {\
            UNSG32 uconfig_size                                : 24;\
            UNSG32 RSVDx8_b24                                  :  8;\
          }
    union { UNSG32 u32ZspDmaRegs_config;
            struct w32ZspDmaRegs_config;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32ZspDmaRegs_status_busy(r32)                 _BFGET_(r32, 0, 0)
    #define   SET32ZspDmaRegs_status_busy(r32,v)               _BFSET_(r32, 0, 0,v)
    #define   GET16ZspDmaRegs_status_busy(r16)                 _BFGET_(r16, 0, 0)
    #define   SET16ZspDmaRegs_status_busy(r16,v)               _BFSET_(r16, 0, 0,v)

    #define   GET32ZspDmaRegs_status_error(r32)                _BFGET_(r32, 1, 1)
    #define   SET32ZspDmaRegs_status_error(r32,v)              _BFSET_(r32, 1, 1,v)
    #define   GET16ZspDmaRegs_status_error(r16)                _BFGET_(r16, 1, 1)
    #define   SET16ZspDmaRegs_status_error(r16,v)              _BFSET_(r16, 1, 1,v)

    #define     w32ZspDmaRegs_status                           {\
            UNSG32 ustatus_busy                                :  1;\
            UNSG32 ustatus_error                               :  1;\
            UNSG32 RSVDxC_b2                                   : 30;\
          }
    union { UNSG32 u32ZspDmaRegs_status;
            struct w32ZspDmaRegs_status;
          };
    ///////////////////////////////////////////////////////////
    } SIE_ZspDmaRegs;

    typedef union  T32ZspDmaRegs_srcAddr
          { UNSG32 u32;
            struct w32ZspDmaRegs_srcAddr;
                 } T32ZspDmaRegs_srcAddr;
    typedef union  T32ZspDmaRegs_desAddr
          { UNSG32 u32;
            struct w32ZspDmaRegs_desAddr;
                 } T32ZspDmaRegs_desAddr;
    typedef union  T32ZspDmaRegs_config
          { UNSG32 u32;
            struct w32ZspDmaRegs_config;
                 } T32ZspDmaRegs_config;
    typedef union  T32ZspDmaRegs_status
          { UNSG32 u32;
            struct w32ZspDmaRegs_status;
                 } T32ZspDmaRegs_status;
    ///////////////////////////////////////////////////////////

    typedef union  TZspDmaRegs_srcAddr
          { UNSG32 u32[1];
            struct {
            struct w32ZspDmaRegs_srcAddr;
                   };
                 } TZspDmaRegs_srcAddr;
    typedef union  TZspDmaRegs_desAddr
          { UNSG32 u32[1];
            struct {
            struct w32ZspDmaRegs_desAddr;
                   };
                 } TZspDmaRegs_desAddr;
    typedef union  TZspDmaRegs_config
          { UNSG32 u32[1];
            struct {
            struct w32ZspDmaRegs_config;
                   };
                 } TZspDmaRegs_config;
    typedef union  TZspDmaRegs_status
          { UNSG32 u32[1];
            struct {
            struct w32ZspDmaRegs_status;
                   };
                 } TZspDmaRegs_status;

    ///////////////////////////////////////////////////////////
     SIGN32 ZspDmaRegs_drvrd(SIE_ZspDmaRegs *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 ZspDmaRegs_drvwr(SIE_ZspDmaRegs *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void ZspDmaRegs_reset(SIE_ZspDmaRegs *p);
     SIGN32 ZspDmaRegs_cmp  (SIE_ZspDmaRegs *p, SIE_ZspDmaRegs *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define ZspDmaRegs_check(p,pie,pfx,hLOG) ZspDmaRegs_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define ZspDmaRegs_print(p,    pfx,hLOG) ZspDmaRegs_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: ZspDmaRegs
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE ZspRegs                 biu              (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000 ITCM                 (P)
///               %unsigned 32 Base                      
///     @ 0x00004                      (W-)
///     #         # Stuffing bytes...
///               %% 1048544
///     @ 0x20000 DTCM                 (P)
///               %unsigned 32 Base                      
///     @ 0x20004                      (W-)
///     #         # Stuffing bytes...
///               %% 1048544
///     @ 0x40000 PMEM                 (P)
///               %unsigned 32 Base                      
///     @ 0x40004                      (W-)
///     #         # Stuffing bytes...
///               %% 1048544
///     @ 0x60000 ZXBAR                (R-)
///               %unsigned 32 Base                      0x12006330
///     @ 0x60004                      (W-)
///     #         # Stuffing bytes...
///               %% 131040
///     @ 0x64000                      (P)
///     # 0x64000 Global               
///               $ZspGlobalRegs       Global            REG          
///     @ 0x64020                      (W-)
///     #         # Stuffing bytes...
///               %% 7936
///     @ 0x64400                      (P)
///     # 0x64400 Int2Zsp              
///               $ZspInt2Zsp          Int2Zsp           REG          
///     @ 0x6440C                      (W-)
///     #         # Stuffing bytes...
///               %% 4000
///     @ 0x64600                      (P)
///     # 0x64600 Int2Soc              
///               $ZspInt2Soc          Int2Soc           REG          
///     @ 0x64610                      (W-)
///     #         # Stuffing bytes...
///               %% 3968
///     @ 0x64800                      (P)
///     # 0x64800 DMA                  
///               $ZspDmaRegs          DMA               REG          
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:  411664B, bits:     318b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_ZspRegs
#define h_ZspRegs (){}

    #define     RA_ZspRegs_ITCM                                0x0000

    #define     BA_ZspRegs_ITCM_Base                           0x0000
    #define     B16ZspRegs_ITCM_Base                           0x0000
    #define   LSb32ZspRegs_ITCM_Base                              0
    #define   LSb16ZspRegs_ITCM_Base                              0
    #define       bZspRegs_ITCM_Base                           32
    #define   MSK32ZspRegs_ITCM_Base                              0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_DTCM                                0x20000

    #define     BA_ZspRegs_DTCM_Base                           0x20000
    #define     B16ZspRegs_DTCM_Base                           0x20000
    #define   LSb32ZspRegs_DTCM_Base                              0
    #define   LSb16ZspRegs_DTCM_Base                              0
    #define       bZspRegs_DTCM_Base                           32
    #define   MSK32ZspRegs_DTCM_Base                              0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_PMEM                                0x40000

    #define     BA_ZspRegs_PMEM_Base                           0x40000
    #define     B16ZspRegs_PMEM_Base                           0x40000
    #define   LSb32ZspRegs_PMEM_Base                              0
    #define   LSb16ZspRegs_PMEM_Base                              0
    #define       bZspRegs_PMEM_Base                           32
    #define   MSK32ZspRegs_PMEM_Base                              0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_ZXBAR                               0x60000

    #define     BA_ZspRegs_ZXBAR_Base                          0x60000
    #define     B16ZspRegs_ZXBAR_Base                          0x60000
    #define   LSb32ZspRegs_ZXBAR_Base                             0
    #define   LSb16ZspRegs_ZXBAR_Base                             0
    #define       bZspRegs_ZXBAR_Base                          32
    #define   MSK32ZspRegs_ZXBAR_Base                             0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_Global                              0x64000
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_Int2Zsp                             0x64400
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_Int2Soc                             0x64600
    ///////////////////////////////////////////////////////////
    #define     RA_ZspRegs_DMA                                 0x64800
    ///////////////////////////////////////////////////////////

    typedef struct SIE_ZspRegs {
    ///////////////////////////////////////////////////////////
    #define   GET32ZspRegs_ITCM_Base(r32)                      _BFGET_(r32,31, 0)
    #define   SET32ZspRegs_ITCM_Base(r32,v)                    _BFSET_(r32,31, 0,v)

    #define     w32ZspRegs_ITCM                                {\
            UNSG32 uITCM_Base                                  : 32;\
          }
    union { UNSG32 u32ZspRegs_ITCM;
            struct w32ZspRegs_ITCM;
          };
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx4                                      [131068];
    ///////////////////////////////////////////////////////////
    #define   GET32ZspRegs_DTCM_Base(r32)                      _BFGET_(r32,31, 0)
    #define   SET32ZspRegs_DTCM_Base(r32,v)                    _BFSET_(r32,31, 0,v)

    #define     w32ZspRegs_DTCM                                {\
            UNSG32 uDTCM_Base                                  : 32;\
          }
    union { UNSG32 u32ZspRegs_DTCM;
            struct w32ZspRegs_DTCM;
          };
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx20004                                  [131068];
    ///////////////////////////////////////////////////////////
    #define   GET32ZspRegs_PMEM_Base(r32)                      _BFGET_(r32,31, 0)
    #define   SET32ZspRegs_PMEM_Base(r32,v)                    _BFSET_(r32,31, 0,v)

    #define     w32ZspRegs_PMEM                                {\
            UNSG32 uPMEM_Base                                  : 32;\
          }
    union { UNSG32 u32ZspRegs_PMEM;
            struct w32ZspRegs_PMEM;
          };
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx40004                                  [131068];
    ///////////////////////////////////////////////////////////
    #define   GET32ZspRegs_ZXBAR_Base(r32)                     _BFGET_(r32,31, 0)
    #define   SET32ZspRegs_ZXBAR_Base(r32,v)                   _BFSET_(r32,31, 0,v)

    #define     w32ZspRegs_ZXBAR                               {\
            UNSG32 uZXBAR_Base                                 : 32;\
          }
    union { UNSG32 u32ZspRegs_ZXBAR;
            struct w32ZspRegs_ZXBAR;
          };
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx60004                                  [16380];
    ///////////////////////////////////////////////////////////
              SIE_ZspGlobalRegs                                ie_Global;
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx64020                                  [992];
    ///////////////////////////////////////////////////////////
              SIE_ZspInt2Zsp                                   ie_Int2Zsp;
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx6440C                                  [500];
    ///////////////////////////////////////////////////////////
              SIE_ZspInt2Soc                                   ie_Int2Soc;
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx64610                                  [496];
    ///////////////////////////////////////////////////////////
              SIE_ZspDmaRegs                                   ie_DMA;
    ///////////////////////////////////////////////////////////
    } SIE_ZspRegs;

    typedef union  T32ZspRegs_ITCM
          { UNSG32 u32;
            struct w32ZspRegs_ITCM;
                 } T32ZspRegs_ITCM;
    typedef union  T32ZspRegs_DTCM
          { UNSG32 u32;
            struct w32ZspRegs_DTCM;
                 } T32ZspRegs_DTCM;
    typedef union  T32ZspRegs_PMEM
          { UNSG32 u32;
            struct w32ZspRegs_PMEM;
                 } T32ZspRegs_PMEM;
    typedef union  T32ZspRegs_ZXBAR
          { UNSG32 u32;
            struct w32ZspRegs_ZXBAR;
                 } T32ZspRegs_ZXBAR;
    ///////////////////////////////////////////////////////////

    typedef union  TZspRegs_ITCM
          { UNSG32 u32[1];
            struct {
            struct w32ZspRegs_ITCM;
                   };
                 } TZspRegs_ITCM;
    typedef union  TZspRegs_DTCM
          { UNSG32 u32[1];
            struct {
            struct w32ZspRegs_DTCM;
                   };
                 } TZspRegs_DTCM;
    typedef union  TZspRegs_PMEM
          { UNSG32 u32[1];
            struct {
            struct w32ZspRegs_PMEM;
                   };
                 } TZspRegs_PMEM;
    typedef union  TZspRegs_ZXBAR
          { UNSG32 u32[1];
            struct {
            struct w32ZspRegs_ZXBAR;
                   };
                 } TZspRegs_ZXBAR;

    ///////////////////////////////////////////////////////////
     SIGN32 ZspRegs_drvrd(SIE_ZspRegs *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 ZspRegs_drvwr(SIE_ZspRegs *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void ZspRegs_reset(SIE_ZspRegs *p);
     SIGN32 ZspRegs_cmp  (SIE_ZspRegs *p, SIE_ZspRegs *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define ZspRegs_check(p,pie,pfx,hLOG) ZspRegs_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define ZspRegs_print(p,    pfx,hLOG) ZspRegs_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: ZspRegs
////////////////////////////////////////////////////////////



#ifdef __cplusplus
  }
#endif
#pragma  pack()

#endif
//////
/// ENDOFFILE: zspWrapper.h
////////////////////////////////////////////////////////////

