/******************************************************************************
 * Copyright (c) 2013-2014 Marvell International Ltd. and its affiliates.
 * All rights reserved.
 *
 * This software file (the "File") is owned and distributed by Marvell
 * International Ltd. and/or its affiliates ("Marvell") under the following
 * licensing terms.
 ******************************************************************************
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell and you have entered into a
 * commercial license agreement (a "Commercial License") with Marvell, the
 * File is licensed to you under the terms of the applicable Commercial
 * License.
 ******************************************************************************
 * Marvell GPL License Option
 *
 * If you received this File from Marvell, you may opt to use, redistribute
 * and/or modify this File in accordance with the terms and conditions of the
 * General Public License Version 2, June 1991 (the "GPL License"), a copy of
 * which is available along with the File in the license.txt file or by writing
 * to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
 * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE
 * EXPRESSLY DISCLAIMED. The GPL License provides additional details about this
 * warranty disclaimer.
 *******************************************************************************/
//////
/// don't edit! auto-generated by docc: avio.h
////////////////////////////////////////////////////////////
#ifndef avio_h
#define avio_h (){}


#include "ctypes.h"

#pragma pack(1)
#ifdef __cplusplus
  extern "C" {
#endif

#ifndef _DOCC_H_BITOPS_
#define _DOCC_H_BITOPS_ (){}

    #define _bSETMASK_(b)                                      ((b)<32 ? (1<<((b)&31)) : 0)
    #define _NSETMASK_(msb,lsb)                                (_bSETMASK_((msb)+1)-_bSETMASK_(lsb))
    #define _bCLRMASK_(b)                                      (~_bSETMASK_(b))
    #define _NCLRMASK_(msb,lsb)                                (~_NSETMASK_(msb,lsb))
    #define _BFGET_(r,msb,lsb)                                 (_NSETMASK_((msb)-(lsb),0)&((r)>>(lsb)))
    #define _BFSET_(r,msb,lsb,v)                               do{ (r)&=_NCLRMASK_(msb,lsb); (r)|=_NSETMASK_(msb,lsb)&((v)<<(lsb)); }while(0)

#endif



//////
/// 
/// $INTERFACE oneReg                                   (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000                      (R-)
///               %unsigned 32 0x00000000                
///                                    ###
///                                    * One 32 bit entry for the BCM queue
///                                    ###
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:       4B, bits:      32b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_oneReg
#define h_oneReg (){}

    #define     BA_oneReg_0x00000000                           0x0000
    #define     B16oneReg_0x00000000                           0x0000
    #define   LSb32oneReg_0x00000000                              0
    #define   LSb16oneReg_0x00000000                              0
    #define       boneReg_0x00000000                           32
    #define   MSK32oneReg_0x00000000                              0xFFFFFFFF
    ///////////////////////////////////////////////////////////

    typedef struct SIE_oneReg {
    ///////////////////////////////////////////////////////////
    #define   GET32oneReg_0x00000000(r32)                      _BFGET_(r32,31, 0)
    #define   SET32oneReg_0x00000000(r32,v)                    _BFSET_(r32,31, 0,v)

            UNSG32 u_0x00000000                                : 32;
    ///////////////////////////////////////////////////////////
    } SIE_oneReg;

    ///////////////////////////////////////////////////////////
     SIGN32 oneReg_drvrd(SIE_oneReg *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 oneReg_drvwr(SIE_oneReg *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void oneReg_reset(SIE_oneReg *p);
     SIGN32 oneReg_cmp  (SIE_oneReg *p, SIE_oneReg *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define oneReg_check(p,pie,pfx,hLOG) oneReg_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define oneReg_print(p,    pfx,hLOG) oneReg_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: oneReg
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE AVIO_REG                                 (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000                      (P)
///     # 0x00000 dummy                
///               $oneReg              dummy             REG      [64]
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:     256B, bits:    2048b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_AVIO_REG
#define h_AVIO_REG (){}

    #define     RA_AVIO_REG_dummy                              0x0000
    ///////////////////////////////////////////////////////////

    typedef struct SIE_AVIO_REG {
    ///////////////////////////////////////////////////////////
              SIE_oneReg                                       ie_dummy[64];
    ///////////////////////////////////////////////////////////
    } SIE_AVIO_REG;

    ///////////////////////////////////////////////////////////
     SIGN32 AVIO_REG_drvrd(SIE_AVIO_REG *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 AVIO_REG_drvwr(SIE_AVIO_REG *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void AVIO_REG_reset(SIE_AVIO_REG *p);
     SIGN32 AVIO_REG_cmp  (SIE_AVIO_REG *p, SIE_AVIO_REG *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define AVIO_REG_check(p,pie,pfx,hLOG) AVIO_REG_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define AVIO_REG_print(p,    pfx,hLOG) AVIO_REG_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: AVIO_REG
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE OCCURENCE                                (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000                      (WOC-)
///               %unsigned 8  AUTO_PUSH_CNT             0x0
///                                    ###
///                                    * One 8 bit counter value for the BCM queue
///                                    ###
///               %%        24         # Stuffing bits...
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:       4B, bits:       8b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_OCCURENCE
#define h_OCCURENCE (){}

    #define     BA_OCCURENCE_AUTO_PUSH_CNT                     0x0000
    #define     B16OCCURENCE_AUTO_PUSH_CNT                     0x0000
    #define   LSb32OCCURENCE_AUTO_PUSH_CNT                        0
    #define   LSb16OCCURENCE_AUTO_PUSH_CNT                        0
    #define       bOCCURENCE_AUTO_PUSH_CNT                     8
    #define   MSK32OCCURENCE_AUTO_PUSH_CNT                        0x000000FF
    ///////////////////////////////////////////////////////////

    typedef struct SIE_OCCURENCE {
    ///////////////////////////////////////////////////////////
    #define   GET32OCCURENCE_AUTO_PUSH_CNT(r32)                _BFGET_(r32, 7, 0)
    #define   SET32OCCURENCE_AUTO_PUSH_CNT(r32,v)              _BFSET_(r32, 7, 0,v)
    #define   GET16OCCURENCE_AUTO_PUSH_CNT(r16)                _BFGET_(r16, 7, 0)
    #define   SET16OCCURENCE_AUTO_PUSH_CNT(r16,v)              _BFSET_(r16, 7, 0,v)

            UNSG32 u_AUTO_PUSH_CNT                             :  8;
            UNSG32 RSVDx0_b8                                   : 24;
    ///////////////////////////////////////////////////////////
    } SIE_OCCURENCE;

    ///////////////////////////////////////////////////////////
     SIGN32 OCCURENCE_drvrd(SIE_OCCURENCE *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 OCCURENCE_drvwr(SIE_OCCURENCE *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void OCCURENCE_reset(SIE_OCCURENCE *p);
     SIGN32 OCCURENCE_cmp  (SIE_OCCURENCE *p, SIE_OCCURENCE *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define OCCURENCE_check(p,pie,pfx,hLOG) OCCURENCE_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define OCCURENCE_print(p,    pfx,hLOG) OCCURENCE_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: OCCURENCE
////////////////////////////////////////////////////////////

//////
/// 
/// $INTERFACE AVIO                    biu              (4,4)
///     # # ----------------------------------------------------------
///     @ 0x00000                      (R-)
///     # 0x00000 cfgReg               
///               $AVIO_REG            cfgReg            MEM          
///     @ 0x00100 BCM_Q0               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #0.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00104 BCM_Q1               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #1.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00108 BCM_Q2               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #2.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x0010C BCM_Q3               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #3.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00110 BCM_Q4               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #4.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00114 BCM_Q5               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #5.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00118 BCM_Q6               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #6.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x0011C BCM_Q7               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #7.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00120 BCM_Q8               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #8.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00124 BCM_Q9               (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #9.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00128 BCM_Q10              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #10.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x0012C BCM_Q11              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #11.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00130 BCM_Q14              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #14.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00134 BCM_Q15              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #15.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00138 BCM_Q16              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #16.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x0013C BCM_Q17              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #17.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00140 BCM_Q18              (P)
///               %unsigned 5  mux                       0x1F
///                                    ###
///                                    * This mux defines the mapping between the interrupt and the BCM queue #18.
///                                    ###
///               %%        27         # Stuffing bits...
///     @ 0x00144 BCM_FULL_STS         (R-)
///               %unsigned 1  Q0                        0x0
///               %unsigned 1  Q1                        0x0
///               %unsigned 1  Q2                        0x0
///               %unsigned 1  Q3                        0x0
///               %unsigned 1  Q4                        0x0
///               %unsigned 1  Q5                        0x0
///               %unsigned 1  Q6                        0x0
///               %unsigned 1  Q7                        0x0
///               %unsigned 1  Q8                        0x0
///               %unsigned 1  Q9                        0x0
///               %unsigned 1  Q10                       0x0
///               %unsigned 1  Q11                       0x0
///               %unsigned 1  Q12                       0x0
///               %unsigned 1  Q13                       0x0
///               %unsigned 1  Q14                       0x0
///               %unsigned 1  Q15                       0x0
///               %unsigned 1  Q16                       0x0
///               %unsigned 1  Q17                       0x0
///               %unsigned 1  Q18                       0x0
///               %unsigned 1  Q31                       0x0
///                                    ###
///                                    * This bit indicates the full status of each queue. One bit is assigned per queue. SW should poll this queue before programming the queue. If the queue is full and SW programs the queue, data will be lost.
///                                    ###
///               %%        12         # Stuffing bits...
///     @ 0x00148 BCM_EMP_STS          (R-)
///               %unsigned 1  Q0                        0x0
///               %unsigned 1  Q1                        0x0
///               %unsigned 1  Q2                        0x0
///               %unsigned 1  Q3                        0x0
///               %unsigned 1  Q4                        0x0
///               %unsigned 1  Q5                        0x0
///               %unsigned 1  Q6                        0x0
///               %unsigned 1  Q7                        0x0
///               %unsigned 1  Q8                        0x0
///               %unsigned 1  Q9                        0x0
///               %unsigned 1  Q10                       0x0
///               %unsigned 1  Q11                       0x0
///               %unsigned 1  Q12                       0x0
///               %unsigned 1  Q13                       0x0
///               %unsigned 1  Q14                       0x0
///               %unsigned 1  Q15                       0x0
///               %unsigned 1  Q16                       0x0
///               %unsigned 1  Q17                       0x0
///               %unsigned 1  Q18                       0x0
///               %unsigned 1  Q31                       0x0
///                                    ###
///                                    * This bit indicates the empty status of each queue.
///                                    ###
///               %%        12         # Stuffing bits...
///     @ 0x0014C BCM_FLUSH            (P)
///               %unsigned 1  Q0                        0x0
///               %unsigned 1  Q1                        0x0
///               %unsigned 1  Q2                        0x0
///               %unsigned 1  Q3                        0x0
///               %unsigned 1  Q4                        0x0
///               %unsigned 1  Q5                        0x0
///               %unsigned 1  Q6                        0x0
///               %unsigned 1  Q7                        0x0
///               %unsigned 1  Q8                        0x0
///               %unsigned 1  Q9                        0x0
///               %unsigned 1  Q10                       0x0
///               %unsigned 1  Q11                       0x0
///               %unsigned 1  Q12                       0x0
///               %unsigned 1  Q13                       0x0
///               %unsigned 1  Q14                       0x0
///               %unsigned 1  Q15                       0x0
///               %unsigned 1  Q16                       0x0
///               %unsigned 1  Q17                       0x0
///               %unsigned 1  Q18                       0x0
///               %unsigned 1  Q31                       0x0
///                                    ###
///                                    * This bit is used to clear each queue.
///                                    * 1: queue is cleared
///                                    * 0: queue is not cleared, normal operation.
///                                    ###
///               %%        12         # Stuffing bits...
///     @ 0x00150 BCM_AUTOPUSH_CNT     (WOC-)
///               %unsigned 32 OCCURENCE                 0x0
///     @ 0x00154                      (P)
///     # 0x00154 Q0                   
///               $OCCURENCE           Q0                REG          
///     @ 0x00158                      (P)
///     # 0x00158 Q1                   
///               $OCCURENCE           Q1                REG          
///     @ 0x0015C                      (P)
///     # 0x0015C Q2                   
///               $OCCURENCE           Q2                REG          
///     @ 0x00160                      (P)
///     # 0x00160 Q3                   
///               $OCCURENCE           Q3                REG          
///     @ 0x00164                      (P)
///     # 0x00164 Q4                   
///               $OCCURENCE           Q4                REG          
///     @ 0x00168                      (P)
///     # 0x00168 Q5                   
///               $OCCURENCE           Q5                REG          
///     @ 0x0016C                      (P)
///     # 0x0016C Q6                   
///               $OCCURENCE           Q6                REG          
///     @ 0x00170                      (P)
///     # 0x00170 Q7                   
///               $OCCURENCE           Q7                REG          
///     @ 0x00174                      (P)
///     # 0x00174 Q8                   
///               $OCCURENCE           Q8                REG          
///     @ 0x00178                      (P)
///     # 0x00178 Q9                   
///               $OCCURENCE           Q9                REG          
///     @ 0x0017C                      (P)
///     # 0x0017C Q10                  
///               $OCCURENCE           Q10               REG          
///     @ 0x00180                      (P)
///     # 0x00180 Q11                  
///               $OCCURENCE           Q11               REG          
///     @ 0x00184                      (P)
///     # 0x00184 Q14                  
///               $OCCURENCE           Q14               REG          
///     @ 0x00188                      (P)
///     # 0x00188 Q15                  
///               $OCCURENCE           Q15               REG          
///     @ 0x0018C                      (P)
///     # 0x0018C Q16                  
///               $OCCURENCE           Q16               REG          
///     @ 0x00190                      (P)
///     # 0x00190 Q17                  
///               $OCCURENCE           Q17               REG          
///     @ 0x00194                      (P)
///     # 0x00194 Q18                  
///               $OCCURENCE           Q18               REG          
///                                    ###
///                                    * This register records number of occurences of BCM AUTOPUSH event
///                                    ###
///     @ 0x00198 BCM_AUTOPUSH         (P)
///               %unsigned 1  Q0                        0x0
///               %unsigned 1  Q1                        0x0
///               %unsigned 1  Q2                        0x0
///               %unsigned 1  Q3                        0x0
///               %unsigned 1  Q4                        0x0
///               %unsigned 1  Q5                        0x0
///               %unsigned 1  Q6                        0x0
///               %unsigned 1  Q7                        0x0
///               %unsigned 1  Q8                        0x0
///               %unsigned 1  Q9                        0x0
///               %unsigned 1  Q10                       0x0
///               %unsigned 1  Q11                       0x0
///               %unsigned 1  Q12                       0x0
///               %unsigned 1  Q13                       0x0
///               %unsigned 1  Q14                       0x0
///               %unsigned 1  Q15                       0x0
///               %unsigned 1  Q16                       0x0
///               %unsigned 1  Q17                       0x0
///               %unsigned 1  Q18                       0x0
///                                    ###
///                                    * When this bit is set to 1 for a Q and corresponding Q is empty when interrupt event for the Q occurs, BCM automatically pushes last command in that particular Q
///                                    ###
///               %%        13         # Stuffing bits...
///     @ 0x0019C BCM_FULL_STS_STICKY  (WOC-)
///               %unsigned 1  Q0                        0x0
///               %unsigned 1  Q1                        0x0
///               %unsigned 1  Q2                        0x0
///               %unsigned 1  Q3                        0x0
///               %unsigned 1  Q4                        0x0
///               %unsigned 1  Q5                        0x0
///               %unsigned 1  Q6                        0x0
///               %unsigned 1  Q7                        0x0
///               %unsigned 1  Q8                        0x0
///               %unsigned 1  Q9                        0x0
///               %unsigned 1  Q10                       0x0
///               %unsigned 1  Q11                       0x0
///               %unsigned 1  Q12                       0x0
///               %unsigned 1  Q13                       0x0
///               %unsigned 1  Q14                       0x0
///               %unsigned 1  Q15                       0x0
///               %unsigned 1  Q16                       0x0
///               %unsigned 1  Q17                       0x0
///               %unsigned 1  Q18                       0x0
///                                    ###
///                                    * 1: indicates full happened since last clear
///                                    * 0: full didn't happen since last clear
///                                    * Software shall write 1 to clear a particular bit.
///                                    ###
///               %%        13         # Stuffing bits...
///     @ 0x001A0 BCM_ERROR            (WOC-)
///               %unsigned 1  err                       0x0
///                                    ###
///                                    * Indicates that BCM Engine received a {address, data} pair over data channel interface of dHub's BCM channel, where “address” points to a register that is inaccessible by BCM Engine.
///                                    * This is a sticky status, and SW need to write 0x1 to clear this bit.
///                                    ###
///               %%        31         # Stuffing bits...
///     @ 0x001A4 BCM_LOG_ADDR         (R-)
///               %unsigned 32 addr                      0x0
///                                    ###
///                                    * The value of “address” which is inaccessible by BCM engine. It logs the address value for the most recent error transaction.
///                                    ###
///     @ 0x001A8 BCM_ERROR_DATA       (R-)
///               %unsigned 32 data                      0x0
///                                    ###
///                                    * The value of “data” in {address, data} pair where address is inaccessible by BCM engine. It logs the data value for the most recent error transaction.
///                                    ###
///     @ 0x001AC                      (W-)
///     #         # Stuffing bytes...
///               %% 672
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:     512B, bits:     448b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_AVIO
#define h_AVIO (){}

    #define     RA_AVIO_cfgReg                                 0x0000
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q0                                 0x0100

    #define     BA_AVIO_BCM_Q0_mux                             0x0100
    #define     B16AVIO_BCM_Q0_mux                             0x0100
    #define   LSb32AVIO_BCM_Q0_mux                                0
    #define   LSb16AVIO_BCM_Q0_mux                                0
    #define       bAVIO_BCM_Q0_mux                             5
    #define   MSK32AVIO_BCM_Q0_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q1                                 0x0104

    #define     BA_AVIO_BCM_Q1_mux                             0x0104
    #define     B16AVIO_BCM_Q1_mux                             0x0104
    #define   LSb32AVIO_BCM_Q1_mux                                0
    #define   LSb16AVIO_BCM_Q1_mux                                0
    #define       bAVIO_BCM_Q1_mux                             5
    #define   MSK32AVIO_BCM_Q1_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q2                                 0x0108

    #define     BA_AVIO_BCM_Q2_mux                             0x0108
    #define     B16AVIO_BCM_Q2_mux                             0x0108
    #define   LSb32AVIO_BCM_Q2_mux                                0
    #define   LSb16AVIO_BCM_Q2_mux                                0
    #define       bAVIO_BCM_Q2_mux                             5
    #define   MSK32AVIO_BCM_Q2_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q3                                 0x010C

    #define     BA_AVIO_BCM_Q3_mux                             0x010C
    #define     B16AVIO_BCM_Q3_mux                             0x010C
    #define   LSb32AVIO_BCM_Q3_mux                                0
    #define   LSb16AVIO_BCM_Q3_mux                                0
    #define       bAVIO_BCM_Q3_mux                             5
    #define   MSK32AVIO_BCM_Q3_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q4                                 0x0110

    #define     BA_AVIO_BCM_Q4_mux                             0x0110
    #define     B16AVIO_BCM_Q4_mux                             0x0110
    #define   LSb32AVIO_BCM_Q4_mux                                0
    #define   LSb16AVIO_BCM_Q4_mux                                0
    #define       bAVIO_BCM_Q4_mux                             5
    #define   MSK32AVIO_BCM_Q4_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q5                                 0x0114

    #define     BA_AVIO_BCM_Q5_mux                             0x0114
    #define     B16AVIO_BCM_Q5_mux                             0x0114
    #define   LSb32AVIO_BCM_Q5_mux                                0
    #define   LSb16AVIO_BCM_Q5_mux                                0
    #define       bAVIO_BCM_Q5_mux                             5
    #define   MSK32AVIO_BCM_Q5_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q6                                 0x0118

    #define     BA_AVIO_BCM_Q6_mux                             0x0118
    #define     B16AVIO_BCM_Q6_mux                             0x0118
    #define   LSb32AVIO_BCM_Q6_mux                                0
    #define   LSb16AVIO_BCM_Q6_mux                                0
    #define       bAVIO_BCM_Q6_mux                             5
    #define   MSK32AVIO_BCM_Q6_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q7                                 0x011C

    #define     BA_AVIO_BCM_Q7_mux                             0x011C
    #define     B16AVIO_BCM_Q7_mux                             0x011C
    #define   LSb32AVIO_BCM_Q7_mux                                0
    #define   LSb16AVIO_BCM_Q7_mux                                0
    #define       bAVIO_BCM_Q7_mux                             5
    #define   MSK32AVIO_BCM_Q7_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q8                                 0x0120

    #define     BA_AVIO_BCM_Q8_mux                             0x0120
    #define     B16AVIO_BCM_Q8_mux                             0x0120
    #define   LSb32AVIO_BCM_Q8_mux                                0
    #define   LSb16AVIO_BCM_Q8_mux                                0
    #define       bAVIO_BCM_Q8_mux                             5
    #define   MSK32AVIO_BCM_Q8_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q9                                 0x0124

    #define     BA_AVIO_BCM_Q9_mux                             0x0124
    #define     B16AVIO_BCM_Q9_mux                             0x0124
    #define   LSb32AVIO_BCM_Q9_mux                                0
    #define   LSb16AVIO_BCM_Q9_mux                                0
    #define       bAVIO_BCM_Q9_mux                             5
    #define   MSK32AVIO_BCM_Q9_mux                                0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q10                                0x0128

    #define     BA_AVIO_BCM_Q10_mux                            0x0128
    #define     B16AVIO_BCM_Q10_mux                            0x0128
    #define   LSb32AVIO_BCM_Q10_mux                               0
    #define   LSb16AVIO_BCM_Q10_mux                               0
    #define       bAVIO_BCM_Q10_mux                            5
    #define   MSK32AVIO_BCM_Q10_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q11                                0x012C

    #define     BA_AVIO_BCM_Q11_mux                            0x012C
    #define     B16AVIO_BCM_Q11_mux                            0x012C
    #define   LSb32AVIO_BCM_Q11_mux                               0
    #define   LSb16AVIO_BCM_Q11_mux                               0
    #define       bAVIO_BCM_Q11_mux                            5
    #define   MSK32AVIO_BCM_Q11_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q14                                0x0130

    #define     BA_AVIO_BCM_Q14_mux                            0x0130
    #define     B16AVIO_BCM_Q14_mux                            0x0130
    #define   LSb32AVIO_BCM_Q14_mux                               0
    #define   LSb16AVIO_BCM_Q14_mux                               0
    #define       bAVIO_BCM_Q14_mux                            5
    #define   MSK32AVIO_BCM_Q14_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q15                                0x0134

    #define     BA_AVIO_BCM_Q15_mux                            0x0134
    #define     B16AVIO_BCM_Q15_mux                            0x0134
    #define   LSb32AVIO_BCM_Q15_mux                               0
    #define   LSb16AVIO_BCM_Q15_mux                               0
    #define       bAVIO_BCM_Q15_mux                            5
    #define   MSK32AVIO_BCM_Q15_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q16                                0x0138

    #define     BA_AVIO_BCM_Q16_mux                            0x0138
    #define     B16AVIO_BCM_Q16_mux                            0x0138
    #define   LSb32AVIO_BCM_Q16_mux                               0
    #define   LSb16AVIO_BCM_Q16_mux                               0
    #define       bAVIO_BCM_Q16_mux                            5
    #define   MSK32AVIO_BCM_Q16_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q17                                0x013C

    #define     BA_AVIO_BCM_Q17_mux                            0x013C
    #define     B16AVIO_BCM_Q17_mux                            0x013C
    #define   LSb32AVIO_BCM_Q17_mux                               0
    #define   LSb16AVIO_BCM_Q17_mux                               0
    #define       bAVIO_BCM_Q17_mux                            5
    #define   MSK32AVIO_BCM_Q17_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_Q18                                0x0140

    #define     BA_AVIO_BCM_Q18_mux                            0x0140
    #define     B16AVIO_BCM_Q18_mux                            0x0140
    #define   LSb32AVIO_BCM_Q18_mux                               0
    #define   LSb16AVIO_BCM_Q18_mux                               0
    #define       bAVIO_BCM_Q18_mux                            5
    #define   MSK32AVIO_BCM_Q18_mux                               0x0000001F
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_FULL_STS                           0x0144

    #define     BA_AVIO_BCM_FULL_STS_Q0                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q0                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q0                           0
    #define   LSb16AVIO_BCM_FULL_STS_Q0                           0
    #define       bAVIO_BCM_FULL_STS_Q0                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q0                           0x00000001

    #define     BA_AVIO_BCM_FULL_STS_Q1                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q1                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q1                           1
    #define   LSb16AVIO_BCM_FULL_STS_Q1                           1
    #define       bAVIO_BCM_FULL_STS_Q1                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q1                           0x00000002

    #define     BA_AVIO_BCM_FULL_STS_Q2                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q2                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q2                           2
    #define   LSb16AVIO_BCM_FULL_STS_Q2                           2
    #define       bAVIO_BCM_FULL_STS_Q2                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q2                           0x00000004

    #define     BA_AVIO_BCM_FULL_STS_Q3                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q3                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q3                           3
    #define   LSb16AVIO_BCM_FULL_STS_Q3                           3
    #define       bAVIO_BCM_FULL_STS_Q3                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q3                           0x00000008

    #define     BA_AVIO_BCM_FULL_STS_Q4                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q4                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q4                           4
    #define   LSb16AVIO_BCM_FULL_STS_Q4                           4
    #define       bAVIO_BCM_FULL_STS_Q4                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q4                           0x00000010

    #define     BA_AVIO_BCM_FULL_STS_Q5                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q5                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q5                           5
    #define   LSb16AVIO_BCM_FULL_STS_Q5                           5
    #define       bAVIO_BCM_FULL_STS_Q5                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q5                           0x00000020

    #define     BA_AVIO_BCM_FULL_STS_Q6                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q6                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q6                           6
    #define   LSb16AVIO_BCM_FULL_STS_Q6                           6
    #define       bAVIO_BCM_FULL_STS_Q6                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q6                           0x00000040

    #define     BA_AVIO_BCM_FULL_STS_Q7                        0x0144
    #define     B16AVIO_BCM_FULL_STS_Q7                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q7                           7
    #define   LSb16AVIO_BCM_FULL_STS_Q7                           7
    #define       bAVIO_BCM_FULL_STS_Q7                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q7                           0x00000080

    #define     BA_AVIO_BCM_FULL_STS_Q8                        0x0145
    #define     B16AVIO_BCM_FULL_STS_Q8                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q8                           8
    #define   LSb16AVIO_BCM_FULL_STS_Q8                           8
    #define       bAVIO_BCM_FULL_STS_Q8                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q8                           0x00000100

    #define     BA_AVIO_BCM_FULL_STS_Q9                        0x0145
    #define     B16AVIO_BCM_FULL_STS_Q9                        0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q9                           9
    #define   LSb16AVIO_BCM_FULL_STS_Q9                           9
    #define       bAVIO_BCM_FULL_STS_Q9                        1
    #define   MSK32AVIO_BCM_FULL_STS_Q9                           0x00000200

    #define     BA_AVIO_BCM_FULL_STS_Q10                       0x0145
    #define     B16AVIO_BCM_FULL_STS_Q10                       0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q10                          10
    #define   LSb16AVIO_BCM_FULL_STS_Q10                          10
    #define       bAVIO_BCM_FULL_STS_Q10                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q10                          0x00000400

    #define     BA_AVIO_BCM_FULL_STS_Q11                       0x0145
    #define     B16AVIO_BCM_FULL_STS_Q11                       0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q11                          11
    #define   LSb16AVIO_BCM_FULL_STS_Q11                          11
    #define       bAVIO_BCM_FULL_STS_Q11                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q11                          0x00000800

    #define     BA_AVIO_BCM_FULL_STS_Q12                       0x0145
    #define     B16AVIO_BCM_FULL_STS_Q12                       0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q12                          12
    #define   LSb16AVIO_BCM_FULL_STS_Q12                          12
    #define       bAVIO_BCM_FULL_STS_Q12                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q12                          0x00001000

    #define     BA_AVIO_BCM_FULL_STS_Q13                       0x0145
    #define     B16AVIO_BCM_FULL_STS_Q13                       0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q13                          13
    #define   LSb16AVIO_BCM_FULL_STS_Q13                          13
    #define       bAVIO_BCM_FULL_STS_Q13                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q13                          0x00002000

    #define     BA_AVIO_BCM_FULL_STS_Q14                       0x0145
    #define     B16AVIO_BCM_FULL_STS_Q14                       0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q14                          14
    #define   LSb16AVIO_BCM_FULL_STS_Q14                          14
    #define       bAVIO_BCM_FULL_STS_Q14                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q14                          0x00004000

    #define     BA_AVIO_BCM_FULL_STS_Q15                       0x0145
    #define     B16AVIO_BCM_FULL_STS_Q15                       0x0144
    #define   LSb32AVIO_BCM_FULL_STS_Q15                          15
    #define   LSb16AVIO_BCM_FULL_STS_Q15                          15
    #define       bAVIO_BCM_FULL_STS_Q15                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q15                          0x00008000

    #define     BA_AVIO_BCM_FULL_STS_Q16                       0x0146
    #define     B16AVIO_BCM_FULL_STS_Q16                       0x0146
    #define   LSb32AVIO_BCM_FULL_STS_Q16                          16
    #define   LSb16AVIO_BCM_FULL_STS_Q16                          0
    #define       bAVIO_BCM_FULL_STS_Q16                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q16                          0x00010000

    #define     BA_AVIO_BCM_FULL_STS_Q17                       0x0146
    #define     B16AVIO_BCM_FULL_STS_Q17                       0x0146
    #define   LSb32AVIO_BCM_FULL_STS_Q17                          17
    #define   LSb16AVIO_BCM_FULL_STS_Q17                          1
    #define       bAVIO_BCM_FULL_STS_Q17                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q17                          0x00020000

    #define     BA_AVIO_BCM_FULL_STS_Q18                       0x0146
    #define     B16AVIO_BCM_FULL_STS_Q18                       0x0146
    #define   LSb32AVIO_BCM_FULL_STS_Q18                          18
    #define   LSb16AVIO_BCM_FULL_STS_Q18                          2
    #define       bAVIO_BCM_FULL_STS_Q18                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q18                          0x00040000

    #define     BA_AVIO_BCM_FULL_STS_Q31                       0x0146
    #define     B16AVIO_BCM_FULL_STS_Q31                       0x0146
    #define   LSb32AVIO_BCM_FULL_STS_Q31                          19
    #define   LSb16AVIO_BCM_FULL_STS_Q31                          3
    #define       bAVIO_BCM_FULL_STS_Q31                       1
    #define   MSK32AVIO_BCM_FULL_STS_Q31                          0x00080000
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_EMP_STS                            0x0148

    #define     BA_AVIO_BCM_EMP_STS_Q0                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q0                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q0                            0
    #define   LSb16AVIO_BCM_EMP_STS_Q0                            0
    #define       bAVIO_BCM_EMP_STS_Q0                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q0                            0x00000001

    #define     BA_AVIO_BCM_EMP_STS_Q1                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q1                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q1                            1
    #define   LSb16AVIO_BCM_EMP_STS_Q1                            1
    #define       bAVIO_BCM_EMP_STS_Q1                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q1                            0x00000002

    #define     BA_AVIO_BCM_EMP_STS_Q2                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q2                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q2                            2
    #define   LSb16AVIO_BCM_EMP_STS_Q2                            2
    #define       bAVIO_BCM_EMP_STS_Q2                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q2                            0x00000004

    #define     BA_AVIO_BCM_EMP_STS_Q3                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q3                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q3                            3
    #define   LSb16AVIO_BCM_EMP_STS_Q3                            3
    #define       bAVIO_BCM_EMP_STS_Q3                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q3                            0x00000008

    #define     BA_AVIO_BCM_EMP_STS_Q4                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q4                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q4                            4
    #define   LSb16AVIO_BCM_EMP_STS_Q4                            4
    #define       bAVIO_BCM_EMP_STS_Q4                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q4                            0x00000010

    #define     BA_AVIO_BCM_EMP_STS_Q5                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q5                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q5                            5
    #define   LSb16AVIO_BCM_EMP_STS_Q5                            5
    #define       bAVIO_BCM_EMP_STS_Q5                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q5                            0x00000020

    #define     BA_AVIO_BCM_EMP_STS_Q6                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q6                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q6                            6
    #define   LSb16AVIO_BCM_EMP_STS_Q6                            6
    #define       bAVIO_BCM_EMP_STS_Q6                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q6                            0x00000040

    #define     BA_AVIO_BCM_EMP_STS_Q7                         0x0148
    #define     B16AVIO_BCM_EMP_STS_Q7                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q7                            7
    #define   LSb16AVIO_BCM_EMP_STS_Q7                            7
    #define       bAVIO_BCM_EMP_STS_Q7                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q7                            0x00000080

    #define     BA_AVIO_BCM_EMP_STS_Q8                         0x0149
    #define     B16AVIO_BCM_EMP_STS_Q8                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q8                            8
    #define   LSb16AVIO_BCM_EMP_STS_Q8                            8
    #define       bAVIO_BCM_EMP_STS_Q8                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q8                            0x00000100

    #define     BA_AVIO_BCM_EMP_STS_Q9                         0x0149
    #define     B16AVIO_BCM_EMP_STS_Q9                         0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q9                            9
    #define   LSb16AVIO_BCM_EMP_STS_Q9                            9
    #define       bAVIO_BCM_EMP_STS_Q9                         1
    #define   MSK32AVIO_BCM_EMP_STS_Q9                            0x00000200

    #define     BA_AVIO_BCM_EMP_STS_Q10                        0x0149
    #define     B16AVIO_BCM_EMP_STS_Q10                        0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q10                           10
    #define   LSb16AVIO_BCM_EMP_STS_Q10                           10
    #define       bAVIO_BCM_EMP_STS_Q10                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q10                           0x00000400

    #define     BA_AVIO_BCM_EMP_STS_Q11                        0x0149
    #define     B16AVIO_BCM_EMP_STS_Q11                        0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q11                           11
    #define   LSb16AVIO_BCM_EMP_STS_Q11                           11
    #define       bAVIO_BCM_EMP_STS_Q11                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q11                           0x00000800

    #define     BA_AVIO_BCM_EMP_STS_Q12                        0x0149
    #define     B16AVIO_BCM_EMP_STS_Q12                        0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q12                           12
    #define   LSb16AVIO_BCM_EMP_STS_Q12                           12
    #define       bAVIO_BCM_EMP_STS_Q12                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q12                           0x00001000

    #define     BA_AVIO_BCM_EMP_STS_Q13                        0x0149
    #define     B16AVIO_BCM_EMP_STS_Q13                        0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q13                           13
    #define   LSb16AVIO_BCM_EMP_STS_Q13                           13
    #define       bAVIO_BCM_EMP_STS_Q13                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q13                           0x00002000

    #define     BA_AVIO_BCM_EMP_STS_Q14                        0x0149
    #define     B16AVIO_BCM_EMP_STS_Q14                        0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q14                           14
    #define   LSb16AVIO_BCM_EMP_STS_Q14                           14
    #define       bAVIO_BCM_EMP_STS_Q14                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q14                           0x00004000

    #define     BA_AVIO_BCM_EMP_STS_Q15                        0x0149
    #define     B16AVIO_BCM_EMP_STS_Q15                        0x0148
    #define   LSb32AVIO_BCM_EMP_STS_Q15                           15
    #define   LSb16AVIO_BCM_EMP_STS_Q15                           15
    #define       bAVIO_BCM_EMP_STS_Q15                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q15                           0x00008000

    #define     BA_AVIO_BCM_EMP_STS_Q16                        0x014A
    #define     B16AVIO_BCM_EMP_STS_Q16                        0x014A
    #define   LSb32AVIO_BCM_EMP_STS_Q16                           16
    #define   LSb16AVIO_BCM_EMP_STS_Q16                           0
    #define       bAVIO_BCM_EMP_STS_Q16                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q16                           0x00010000

    #define     BA_AVIO_BCM_EMP_STS_Q17                        0x014A
    #define     B16AVIO_BCM_EMP_STS_Q17                        0x014A
    #define   LSb32AVIO_BCM_EMP_STS_Q17                           17
    #define   LSb16AVIO_BCM_EMP_STS_Q17                           1
    #define       bAVIO_BCM_EMP_STS_Q17                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q17                           0x00020000

    #define     BA_AVIO_BCM_EMP_STS_Q18                        0x014A
    #define     B16AVIO_BCM_EMP_STS_Q18                        0x014A
    #define   LSb32AVIO_BCM_EMP_STS_Q18                           18
    #define   LSb16AVIO_BCM_EMP_STS_Q18                           2
    #define       bAVIO_BCM_EMP_STS_Q18                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q18                           0x00040000

    #define     BA_AVIO_BCM_EMP_STS_Q31                        0x014A
    #define     B16AVIO_BCM_EMP_STS_Q31                        0x014A
    #define   LSb32AVIO_BCM_EMP_STS_Q31                           19
    #define   LSb16AVIO_BCM_EMP_STS_Q31                           3
    #define       bAVIO_BCM_EMP_STS_Q31                        1
    #define   MSK32AVIO_BCM_EMP_STS_Q31                           0x00080000
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_FLUSH                              0x014C

    #define     BA_AVIO_BCM_FLUSH_Q0                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q0                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q0                              0
    #define   LSb16AVIO_BCM_FLUSH_Q0                              0
    #define       bAVIO_BCM_FLUSH_Q0                           1
    #define   MSK32AVIO_BCM_FLUSH_Q0                              0x00000001

    #define     BA_AVIO_BCM_FLUSH_Q1                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q1                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q1                              1
    #define   LSb16AVIO_BCM_FLUSH_Q1                              1
    #define       bAVIO_BCM_FLUSH_Q1                           1
    #define   MSK32AVIO_BCM_FLUSH_Q1                              0x00000002

    #define     BA_AVIO_BCM_FLUSH_Q2                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q2                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q2                              2
    #define   LSb16AVIO_BCM_FLUSH_Q2                              2
    #define       bAVIO_BCM_FLUSH_Q2                           1
    #define   MSK32AVIO_BCM_FLUSH_Q2                              0x00000004

    #define     BA_AVIO_BCM_FLUSH_Q3                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q3                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q3                              3
    #define   LSb16AVIO_BCM_FLUSH_Q3                              3
    #define       bAVIO_BCM_FLUSH_Q3                           1
    #define   MSK32AVIO_BCM_FLUSH_Q3                              0x00000008

    #define     BA_AVIO_BCM_FLUSH_Q4                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q4                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q4                              4
    #define   LSb16AVIO_BCM_FLUSH_Q4                              4
    #define       bAVIO_BCM_FLUSH_Q4                           1
    #define   MSK32AVIO_BCM_FLUSH_Q4                              0x00000010

    #define     BA_AVIO_BCM_FLUSH_Q5                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q5                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q5                              5
    #define   LSb16AVIO_BCM_FLUSH_Q5                              5
    #define       bAVIO_BCM_FLUSH_Q5                           1
    #define   MSK32AVIO_BCM_FLUSH_Q5                              0x00000020

    #define     BA_AVIO_BCM_FLUSH_Q6                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q6                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q6                              6
    #define   LSb16AVIO_BCM_FLUSH_Q6                              6
    #define       bAVIO_BCM_FLUSH_Q6                           1
    #define   MSK32AVIO_BCM_FLUSH_Q6                              0x00000040

    #define     BA_AVIO_BCM_FLUSH_Q7                           0x014C
    #define     B16AVIO_BCM_FLUSH_Q7                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q7                              7
    #define   LSb16AVIO_BCM_FLUSH_Q7                              7
    #define       bAVIO_BCM_FLUSH_Q7                           1
    #define   MSK32AVIO_BCM_FLUSH_Q7                              0x00000080

    #define     BA_AVIO_BCM_FLUSH_Q8                           0x014D
    #define     B16AVIO_BCM_FLUSH_Q8                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q8                              8
    #define   LSb16AVIO_BCM_FLUSH_Q8                              8
    #define       bAVIO_BCM_FLUSH_Q8                           1
    #define   MSK32AVIO_BCM_FLUSH_Q8                              0x00000100

    #define     BA_AVIO_BCM_FLUSH_Q9                           0x014D
    #define     B16AVIO_BCM_FLUSH_Q9                           0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q9                              9
    #define   LSb16AVIO_BCM_FLUSH_Q9                              9
    #define       bAVIO_BCM_FLUSH_Q9                           1
    #define   MSK32AVIO_BCM_FLUSH_Q9                              0x00000200

    #define     BA_AVIO_BCM_FLUSH_Q10                          0x014D
    #define     B16AVIO_BCM_FLUSH_Q10                          0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q10                             10
    #define   LSb16AVIO_BCM_FLUSH_Q10                             10
    #define       bAVIO_BCM_FLUSH_Q10                          1
    #define   MSK32AVIO_BCM_FLUSH_Q10                             0x00000400

    #define     BA_AVIO_BCM_FLUSH_Q11                          0x014D
    #define     B16AVIO_BCM_FLUSH_Q11                          0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q11                             11
    #define   LSb16AVIO_BCM_FLUSH_Q11                             11
    #define       bAVIO_BCM_FLUSH_Q11                          1
    #define   MSK32AVIO_BCM_FLUSH_Q11                             0x00000800

    #define     BA_AVIO_BCM_FLUSH_Q12                          0x014D
    #define     B16AVIO_BCM_FLUSH_Q12                          0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q12                             12
    #define   LSb16AVIO_BCM_FLUSH_Q12                             12
    #define       bAVIO_BCM_FLUSH_Q12                          1
    #define   MSK32AVIO_BCM_FLUSH_Q12                             0x00001000

    #define     BA_AVIO_BCM_FLUSH_Q13                          0x014D
    #define     B16AVIO_BCM_FLUSH_Q13                          0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q13                             13
    #define   LSb16AVIO_BCM_FLUSH_Q13                             13
    #define       bAVIO_BCM_FLUSH_Q13                          1
    #define   MSK32AVIO_BCM_FLUSH_Q13                             0x00002000

    #define     BA_AVIO_BCM_FLUSH_Q14                          0x014D
    #define     B16AVIO_BCM_FLUSH_Q14                          0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q14                             14
    #define   LSb16AVIO_BCM_FLUSH_Q14                             14
    #define       bAVIO_BCM_FLUSH_Q14                          1
    #define   MSK32AVIO_BCM_FLUSH_Q14                             0x00004000

    #define     BA_AVIO_BCM_FLUSH_Q15                          0x014D
    #define     B16AVIO_BCM_FLUSH_Q15                          0x014C
    #define   LSb32AVIO_BCM_FLUSH_Q15                             15
    #define   LSb16AVIO_BCM_FLUSH_Q15                             15
    #define       bAVIO_BCM_FLUSH_Q15                          1
    #define   MSK32AVIO_BCM_FLUSH_Q15                             0x00008000

    #define     BA_AVIO_BCM_FLUSH_Q16                          0x014E
    #define     B16AVIO_BCM_FLUSH_Q16                          0x014E
    #define   LSb32AVIO_BCM_FLUSH_Q16                             16
    #define   LSb16AVIO_BCM_FLUSH_Q16                             0
    #define       bAVIO_BCM_FLUSH_Q16                          1
    #define   MSK32AVIO_BCM_FLUSH_Q16                             0x00010000

    #define     BA_AVIO_BCM_FLUSH_Q17                          0x014E
    #define     B16AVIO_BCM_FLUSH_Q17                          0x014E
    #define   LSb32AVIO_BCM_FLUSH_Q17                             17
    #define   LSb16AVIO_BCM_FLUSH_Q17                             1
    #define       bAVIO_BCM_FLUSH_Q17                          1
    #define   MSK32AVIO_BCM_FLUSH_Q17                             0x00020000

    #define     BA_AVIO_BCM_FLUSH_Q18                          0x014E
    #define     B16AVIO_BCM_FLUSH_Q18                          0x014E
    #define   LSb32AVIO_BCM_FLUSH_Q18                             18
    #define   LSb16AVIO_BCM_FLUSH_Q18                             2
    #define       bAVIO_BCM_FLUSH_Q18                          1
    #define   MSK32AVIO_BCM_FLUSH_Q18                             0x00040000

    #define     BA_AVIO_BCM_FLUSH_Q31                          0x014E
    #define     B16AVIO_BCM_FLUSH_Q31                          0x014E
    #define   LSb32AVIO_BCM_FLUSH_Q31                             19
    #define   LSb16AVIO_BCM_FLUSH_Q31                             3
    #define       bAVIO_BCM_FLUSH_Q31                          1
    #define   MSK32AVIO_BCM_FLUSH_Q31                             0x00080000
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_AUTOPUSH_CNT                       0x0150

    #define     BA_AVIO_BCM_AUTOPUSH_CNT_OCCURENCE             0x0150
    #define     B16AVIO_BCM_AUTOPUSH_CNT_OCCURENCE             0x0150
    #define   LSb32AVIO_BCM_AUTOPUSH_CNT_OCCURENCE                0
    #define   LSb16AVIO_BCM_AUTOPUSH_CNT_OCCURENCE                0
    #define       bAVIO_BCM_AUTOPUSH_CNT_OCCURENCE             32
    #define   MSK32AVIO_BCM_AUTOPUSH_CNT_OCCURENCE                0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q0                                     0x0154
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q1                                     0x0158
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q2                                     0x015C
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q3                                     0x0160
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q4                                     0x0164
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q5                                     0x0168
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q6                                     0x016C
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q7                                     0x0170
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q8                                     0x0174
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q9                                     0x0178
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q10                                    0x017C
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q11                                    0x0180
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q14                                    0x0184
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q15                                    0x0188
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q16                                    0x018C
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q17                                    0x0190
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_Q18                                    0x0194
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_AUTOPUSH                           0x0198

    #define     BA_AVIO_BCM_AUTOPUSH_Q0                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q0                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q0                           0
    #define   LSb16AVIO_BCM_AUTOPUSH_Q0                           0
    #define       bAVIO_BCM_AUTOPUSH_Q0                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q0                           0x00000001

    #define     BA_AVIO_BCM_AUTOPUSH_Q1                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q1                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q1                           1
    #define   LSb16AVIO_BCM_AUTOPUSH_Q1                           1
    #define       bAVIO_BCM_AUTOPUSH_Q1                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q1                           0x00000002

    #define     BA_AVIO_BCM_AUTOPUSH_Q2                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q2                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q2                           2
    #define   LSb16AVIO_BCM_AUTOPUSH_Q2                           2
    #define       bAVIO_BCM_AUTOPUSH_Q2                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q2                           0x00000004

    #define     BA_AVIO_BCM_AUTOPUSH_Q3                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q3                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q3                           3
    #define   LSb16AVIO_BCM_AUTOPUSH_Q3                           3
    #define       bAVIO_BCM_AUTOPUSH_Q3                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q3                           0x00000008

    #define     BA_AVIO_BCM_AUTOPUSH_Q4                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q4                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q4                           4
    #define   LSb16AVIO_BCM_AUTOPUSH_Q4                           4
    #define       bAVIO_BCM_AUTOPUSH_Q4                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q4                           0x00000010

    #define     BA_AVIO_BCM_AUTOPUSH_Q5                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q5                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q5                           5
    #define   LSb16AVIO_BCM_AUTOPUSH_Q5                           5
    #define       bAVIO_BCM_AUTOPUSH_Q5                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q5                           0x00000020

    #define     BA_AVIO_BCM_AUTOPUSH_Q6                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q6                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q6                           6
    #define   LSb16AVIO_BCM_AUTOPUSH_Q6                           6
    #define       bAVIO_BCM_AUTOPUSH_Q6                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q6                           0x00000040

    #define     BA_AVIO_BCM_AUTOPUSH_Q7                        0x0198
    #define     B16AVIO_BCM_AUTOPUSH_Q7                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q7                           7
    #define   LSb16AVIO_BCM_AUTOPUSH_Q7                           7
    #define       bAVIO_BCM_AUTOPUSH_Q7                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q7                           0x00000080

    #define     BA_AVIO_BCM_AUTOPUSH_Q8                        0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q8                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q8                           8
    #define   LSb16AVIO_BCM_AUTOPUSH_Q8                           8
    #define       bAVIO_BCM_AUTOPUSH_Q8                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q8                           0x00000100

    #define     BA_AVIO_BCM_AUTOPUSH_Q9                        0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q9                        0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q9                           9
    #define   LSb16AVIO_BCM_AUTOPUSH_Q9                           9
    #define       bAVIO_BCM_AUTOPUSH_Q9                        1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q9                           0x00000200

    #define     BA_AVIO_BCM_AUTOPUSH_Q10                       0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q10                       0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q10                          10
    #define   LSb16AVIO_BCM_AUTOPUSH_Q10                          10
    #define       bAVIO_BCM_AUTOPUSH_Q10                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q10                          0x00000400

    #define     BA_AVIO_BCM_AUTOPUSH_Q11                       0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q11                       0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q11                          11
    #define   LSb16AVIO_BCM_AUTOPUSH_Q11                          11
    #define       bAVIO_BCM_AUTOPUSH_Q11                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q11                          0x00000800

    #define     BA_AVIO_BCM_AUTOPUSH_Q12                       0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q12                       0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q12                          12
    #define   LSb16AVIO_BCM_AUTOPUSH_Q12                          12
    #define       bAVIO_BCM_AUTOPUSH_Q12                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q12                          0x00001000

    #define     BA_AVIO_BCM_AUTOPUSH_Q13                       0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q13                       0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q13                          13
    #define   LSb16AVIO_BCM_AUTOPUSH_Q13                          13
    #define       bAVIO_BCM_AUTOPUSH_Q13                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q13                          0x00002000

    #define     BA_AVIO_BCM_AUTOPUSH_Q14                       0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q14                       0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q14                          14
    #define   LSb16AVIO_BCM_AUTOPUSH_Q14                          14
    #define       bAVIO_BCM_AUTOPUSH_Q14                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q14                          0x00004000

    #define     BA_AVIO_BCM_AUTOPUSH_Q15                       0x0199
    #define     B16AVIO_BCM_AUTOPUSH_Q15                       0x0198
    #define   LSb32AVIO_BCM_AUTOPUSH_Q15                          15
    #define   LSb16AVIO_BCM_AUTOPUSH_Q15                          15
    #define       bAVIO_BCM_AUTOPUSH_Q15                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q15                          0x00008000

    #define     BA_AVIO_BCM_AUTOPUSH_Q16                       0x019A
    #define     B16AVIO_BCM_AUTOPUSH_Q16                       0x019A
    #define   LSb32AVIO_BCM_AUTOPUSH_Q16                          16
    #define   LSb16AVIO_BCM_AUTOPUSH_Q16                          0
    #define       bAVIO_BCM_AUTOPUSH_Q16                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q16                          0x00010000

    #define     BA_AVIO_BCM_AUTOPUSH_Q17                       0x019A
    #define     B16AVIO_BCM_AUTOPUSH_Q17                       0x019A
    #define   LSb32AVIO_BCM_AUTOPUSH_Q17                          17
    #define   LSb16AVIO_BCM_AUTOPUSH_Q17                          1
    #define       bAVIO_BCM_AUTOPUSH_Q17                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q17                          0x00020000

    #define     BA_AVIO_BCM_AUTOPUSH_Q18                       0x019A
    #define     B16AVIO_BCM_AUTOPUSH_Q18                       0x019A
    #define   LSb32AVIO_BCM_AUTOPUSH_Q18                          18
    #define   LSb16AVIO_BCM_AUTOPUSH_Q18                          2
    #define       bAVIO_BCM_AUTOPUSH_Q18                       1
    #define   MSK32AVIO_BCM_AUTOPUSH_Q18                          0x00040000
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_FULL_STS_STICKY                    0x019C

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q0                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q0                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q0                    0
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q0                    0
    #define       bAVIO_BCM_FULL_STS_STICKY_Q0                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q0                    0x00000001

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q1                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q1                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q1                    1
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q1                    1
    #define       bAVIO_BCM_FULL_STS_STICKY_Q1                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q1                    0x00000002

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q2                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q2                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q2                    2
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q2                    2
    #define       bAVIO_BCM_FULL_STS_STICKY_Q2                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q2                    0x00000004

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q3                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q3                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q3                    3
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q3                    3
    #define       bAVIO_BCM_FULL_STS_STICKY_Q3                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q3                    0x00000008

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q4                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q4                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q4                    4
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q4                    4
    #define       bAVIO_BCM_FULL_STS_STICKY_Q4                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q4                    0x00000010

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q5                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q5                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q5                    5
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q5                    5
    #define       bAVIO_BCM_FULL_STS_STICKY_Q5                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q5                    0x00000020

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q6                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q6                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q6                    6
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q6                    6
    #define       bAVIO_BCM_FULL_STS_STICKY_Q6                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q6                    0x00000040

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q7                 0x019C
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q7                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q7                    7
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q7                    7
    #define       bAVIO_BCM_FULL_STS_STICKY_Q7                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q7                    0x00000080

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q8                 0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q8                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q8                    8
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q8                    8
    #define       bAVIO_BCM_FULL_STS_STICKY_Q8                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q8                    0x00000100

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q9                 0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q9                 0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q9                    9
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q9                    9
    #define       bAVIO_BCM_FULL_STS_STICKY_Q9                 1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q9                    0x00000200

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q10                0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q10                0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q10                   10
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q10                   10
    #define       bAVIO_BCM_FULL_STS_STICKY_Q10                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q10                   0x00000400

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q11                0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q11                0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q11                   11
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q11                   11
    #define       bAVIO_BCM_FULL_STS_STICKY_Q11                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q11                   0x00000800

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q12                0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q12                0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q12                   12
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q12                   12
    #define       bAVIO_BCM_FULL_STS_STICKY_Q12                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q12                   0x00001000

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q13                0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q13                0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q13                   13
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q13                   13
    #define       bAVIO_BCM_FULL_STS_STICKY_Q13                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q13                   0x00002000

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q14                0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q14                0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q14                   14
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q14                   14
    #define       bAVIO_BCM_FULL_STS_STICKY_Q14                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q14                   0x00004000

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q15                0x019D
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q15                0x019C
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q15                   15
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q15                   15
    #define       bAVIO_BCM_FULL_STS_STICKY_Q15                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q15                   0x00008000

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q16                0x019E
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q16                0x019E
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q16                   16
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q16                   0
    #define       bAVIO_BCM_FULL_STS_STICKY_Q16                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q16                   0x00010000

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q17                0x019E
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q17                0x019E
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q17                   17
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q17                   1
    #define       bAVIO_BCM_FULL_STS_STICKY_Q17                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q17                   0x00020000

    #define     BA_AVIO_BCM_FULL_STS_STICKY_Q18                0x019E
    #define     B16AVIO_BCM_FULL_STS_STICKY_Q18                0x019E
    #define   LSb32AVIO_BCM_FULL_STS_STICKY_Q18                   18
    #define   LSb16AVIO_BCM_FULL_STS_STICKY_Q18                   2
    #define       bAVIO_BCM_FULL_STS_STICKY_Q18                1
    #define   MSK32AVIO_BCM_FULL_STS_STICKY_Q18                   0x00040000
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_ERROR                              0x01A0

    #define     BA_AVIO_BCM_ERROR_err                          0x01A0
    #define     B16AVIO_BCM_ERROR_err                          0x01A0
    #define   LSb32AVIO_BCM_ERROR_err                             0
    #define   LSb16AVIO_BCM_ERROR_err                             0
    #define       bAVIO_BCM_ERROR_err                          1
    #define   MSK32AVIO_BCM_ERROR_err                             0x00000001
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_LOG_ADDR                           0x01A4

    #define     BA_AVIO_BCM_LOG_ADDR_addr                      0x01A4
    #define     B16AVIO_BCM_LOG_ADDR_addr                      0x01A4
    #define   LSb32AVIO_BCM_LOG_ADDR_addr                         0
    #define   LSb16AVIO_BCM_LOG_ADDR_addr                         0
    #define       bAVIO_BCM_LOG_ADDR_addr                      32
    #define   MSK32AVIO_BCM_LOG_ADDR_addr                         0xFFFFFFFF
    ///////////////////////////////////////////////////////////
    #define     RA_AVIO_BCM_ERROR_DATA                         0x01A8

    #define     BA_AVIO_BCM_ERROR_DATA_data                    0x01A8
    #define     B16AVIO_BCM_ERROR_DATA_data                    0x01A8
    #define   LSb32AVIO_BCM_ERROR_DATA_data                       0
    #define   LSb16AVIO_BCM_ERROR_DATA_data                       0
    #define       bAVIO_BCM_ERROR_DATA_data                    32
    #define   MSK32AVIO_BCM_ERROR_DATA_data                       0xFFFFFFFF
    ///////////////////////////////////////////////////////////

    typedef struct SIE_AVIO {
    ///////////////////////////////////////////////////////////
              SIE_AVIO_REG                                     ie_cfgReg;
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q0_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q0_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q0_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q0_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q0                                 {\
            UNSG32 uBCM_Q0_mux                                 :  5;\
            UNSG32 RSVDx100_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q0;
            struct w32AVIO_BCM_Q0;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q1_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q1_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q1_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q1_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q1                                 {\
            UNSG32 uBCM_Q1_mux                                 :  5;\
            UNSG32 RSVDx104_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q1;
            struct w32AVIO_BCM_Q1;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q2_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q2_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q2_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q2_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q2                                 {\
            UNSG32 uBCM_Q2_mux                                 :  5;\
            UNSG32 RSVDx108_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q2;
            struct w32AVIO_BCM_Q2;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q3_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q3_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q3_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q3_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q3                                 {\
            UNSG32 uBCM_Q3_mux                                 :  5;\
            UNSG32 RSVDx10C_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q3;
            struct w32AVIO_BCM_Q3;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q4_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q4_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q4_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q4_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q4                                 {\
            UNSG32 uBCM_Q4_mux                                 :  5;\
            UNSG32 RSVDx110_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q4;
            struct w32AVIO_BCM_Q4;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q5_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q5_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q5_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q5_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q5                                 {\
            UNSG32 uBCM_Q5_mux                                 :  5;\
            UNSG32 RSVDx114_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q5;
            struct w32AVIO_BCM_Q5;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q6_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q6_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q6_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q6_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q6                                 {\
            UNSG32 uBCM_Q6_mux                                 :  5;\
            UNSG32 RSVDx118_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q6;
            struct w32AVIO_BCM_Q6;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q7_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q7_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q7_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q7_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q7                                 {\
            UNSG32 uBCM_Q7_mux                                 :  5;\
            UNSG32 RSVDx11C_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q7;
            struct w32AVIO_BCM_Q7;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q8_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q8_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q8_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q8_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q8                                 {\
            UNSG32 uBCM_Q8_mux                                 :  5;\
            UNSG32 RSVDx120_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q8;
            struct w32AVIO_BCM_Q8;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q9_mux(r32)                        _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q9_mux(r32,v)                      _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q9_mux(r16)                        _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q9_mux(r16,v)                      _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q9                                 {\
            UNSG32 uBCM_Q9_mux                                 :  5;\
            UNSG32 RSVDx124_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q9;
            struct w32AVIO_BCM_Q9;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q10_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q10_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q10_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q10_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q10                                {\
            UNSG32 uBCM_Q10_mux                                :  5;\
            UNSG32 RSVDx128_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q10;
            struct w32AVIO_BCM_Q10;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q11_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q11_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q11_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q11_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q11                                {\
            UNSG32 uBCM_Q11_mux                                :  5;\
            UNSG32 RSVDx12C_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q11;
            struct w32AVIO_BCM_Q11;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q14_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q14_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q14_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q14_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q14                                {\
            UNSG32 uBCM_Q14_mux                                :  5;\
            UNSG32 RSVDx130_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q14;
            struct w32AVIO_BCM_Q14;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q15_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q15_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q15_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q15_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q15                                {\
            UNSG32 uBCM_Q15_mux                                :  5;\
            UNSG32 RSVDx134_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q15;
            struct w32AVIO_BCM_Q15;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q16_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q16_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q16_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q16_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q16                                {\
            UNSG32 uBCM_Q16_mux                                :  5;\
            UNSG32 RSVDx138_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q16;
            struct w32AVIO_BCM_Q16;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q17_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q17_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q17_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q17_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q17                                {\
            UNSG32 uBCM_Q17_mux                                :  5;\
            UNSG32 RSVDx13C_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q17;
            struct w32AVIO_BCM_Q17;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_Q18_mux(r32)                       _BFGET_(r32, 4, 0)
    #define   SET32AVIO_BCM_Q18_mux(r32,v)                     _BFSET_(r32, 4, 0,v)
    #define   GET16AVIO_BCM_Q18_mux(r16)                       _BFGET_(r16, 4, 0)
    #define   SET16AVIO_BCM_Q18_mux(r16,v)                     _BFSET_(r16, 4, 0,v)

    #define     w32AVIO_BCM_Q18                                {\
            UNSG32 uBCM_Q18_mux                                :  5;\
            UNSG32 RSVDx140_b5                                 : 27;\
          }
    union { UNSG32 u32AVIO_BCM_Q18;
            struct w32AVIO_BCM_Q18;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_FULL_STS_Q0(r32)                   _BFGET_(r32, 0, 0)
    #define   SET32AVIO_BCM_FULL_STS_Q0(r32,v)                 _BFSET_(r32, 0, 0,v)
    #define   GET16AVIO_BCM_FULL_STS_Q0(r16)                   _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_FULL_STS_Q0(r16,v)                 _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_FULL_STS_Q1(r32)                   _BFGET_(r32, 1, 1)
    #define   SET32AVIO_BCM_FULL_STS_Q1(r32,v)                 _BFSET_(r32, 1, 1,v)
    #define   GET16AVIO_BCM_FULL_STS_Q1(r16)                   _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_FULL_STS_Q1(r16,v)                 _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_FULL_STS_Q2(r32)                   _BFGET_(r32, 2, 2)
    #define   SET32AVIO_BCM_FULL_STS_Q2(r32,v)                 _BFSET_(r32, 2, 2,v)
    #define   GET16AVIO_BCM_FULL_STS_Q2(r16)                   _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_FULL_STS_Q2(r16,v)                 _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_FULL_STS_Q3(r32)                   _BFGET_(r32, 3, 3)
    #define   SET32AVIO_BCM_FULL_STS_Q3(r32,v)                 _BFSET_(r32, 3, 3,v)
    #define   GET16AVIO_BCM_FULL_STS_Q3(r16)                   _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_FULL_STS_Q3(r16,v)                 _BFSET_(r16, 3, 3,v)

    #define   GET32AVIO_BCM_FULL_STS_Q4(r32)                   _BFGET_(r32, 4, 4)
    #define   SET32AVIO_BCM_FULL_STS_Q4(r32,v)                 _BFSET_(r32, 4, 4,v)
    #define   GET16AVIO_BCM_FULL_STS_Q4(r16)                   _BFGET_(r16, 4, 4)
    #define   SET16AVIO_BCM_FULL_STS_Q4(r16,v)                 _BFSET_(r16, 4, 4,v)

    #define   GET32AVIO_BCM_FULL_STS_Q5(r32)                   _BFGET_(r32, 5, 5)
    #define   SET32AVIO_BCM_FULL_STS_Q5(r32,v)                 _BFSET_(r32, 5, 5,v)
    #define   GET16AVIO_BCM_FULL_STS_Q5(r16)                   _BFGET_(r16, 5, 5)
    #define   SET16AVIO_BCM_FULL_STS_Q5(r16,v)                 _BFSET_(r16, 5, 5,v)

    #define   GET32AVIO_BCM_FULL_STS_Q6(r32)                   _BFGET_(r32, 6, 6)
    #define   SET32AVIO_BCM_FULL_STS_Q6(r32,v)                 _BFSET_(r32, 6, 6,v)
    #define   GET16AVIO_BCM_FULL_STS_Q6(r16)                   _BFGET_(r16, 6, 6)
    #define   SET16AVIO_BCM_FULL_STS_Q6(r16,v)                 _BFSET_(r16, 6, 6,v)

    #define   GET32AVIO_BCM_FULL_STS_Q7(r32)                   _BFGET_(r32, 7, 7)
    #define   SET32AVIO_BCM_FULL_STS_Q7(r32,v)                 _BFSET_(r32, 7, 7,v)
    #define   GET16AVIO_BCM_FULL_STS_Q7(r16)                   _BFGET_(r16, 7, 7)
    #define   SET16AVIO_BCM_FULL_STS_Q7(r16,v)                 _BFSET_(r16, 7, 7,v)

    #define   GET32AVIO_BCM_FULL_STS_Q8(r32)                   _BFGET_(r32, 8, 8)
    #define   SET32AVIO_BCM_FULL_STS_Q8(r32,v)                 _BFSET_(r32, 8, 8,v)
    #define   GET16AVIO_BCM_FULL_STS_Q8(r16)                   _BFGET_(r16, 8, 8)
    #define   SET16AVIO_BCM_FULL_STS_Q8(r16,v)                 _BFSET_(r16, 8, 8,v)

    #define   GET32AVIO_BCM_FULL_STS_Q9(r32)                   _BFGET_(r32, 9, 9)
    #define   SET32AVIO_BCM_FULL_STS_Q9(r32,v)                 _BFSET_(r32, 9, 9,v)
    #define   GET16AVIO_BCM_FULL_STS_Q9(r16)                   _BFGET_(r16, 9, 9)
    #define   SET16AVIO_BCM_FULL_STS_Q9(r16,v)                 _BFSET_(r16, 9, 9,v)

    #define   GET32AVIO_BCM_FULL_STS_Q10(r32)                  _BFGET_(r32,10,10)
    #define   SET32AVIO_BCM_FULL_STS_Q10(r32,v)                _BFSET_(r32,10,10,v)
    #define   GET16AVIO_BCM_FULL_STS_Q10(r16)                  _BFGET_(r16,10,10)
    #define   SET16AVIO_BCM_FULL_STS_Q10(r16,v)                _BFSET_(r16,10,10,v)

    #define   GET32AVIO_BCM_FULL_STS_Q11(r32)                  _BFGET_(r32,11,11)
    #define   SET32AVIO_BCM_FULL_STS_Q11(r32,v)                _BFSET_(r32,11,11,v)
    #define   GET16AVIO_BCM_FULL_STS_Q11(r16)                  _BFGET_(r16,11,11)
    #define   SET16AVIO_BCM_FULL_STS_Q11(r16,v)                _BFSET_(r16,11,11,v)

    #define   GET32AVIO_BCM_FULL_STS_Q12(r32)                  _BFGET_(r32,12,12)
    #define   SET32AVIO_BCM_FULL_STS_Q12(r32,v)                _BFSET_(r32,12,12,v)
    #define   GET16AVIO_BCM_FULL_STS_Q12(r16)                  _BFGET_(r16,12,12)
    #define   SET16AVIO_BCM_FULL_STS_Q12(r16,v)                _BFSET_(r16,12,12,v)

    #define   GET32AVIO_BCM_FULL_STS_Q13(r32)                  _BFGET_(r32,13,13)
    #define   SET32AVIO_BCM_FULL_STS_Q13(r32,v)                _BFSET_(r32,13,13,v)
    #define   GET16AVIO_BCM_FULL_STS_Q13(r16)                  _BFGET_(r16,13,13)
    #define   SET16AVIO_BCM_FULL_STS_Q13(r16,v)                _BFSET_(r16,13,13,v)

    #define   GET32AVIO_BCM_FULL_STS_Q14(r32)                  _BFGET_(r32,14,14)
    #define   SET32AVIO_BCM_FULL_STS_Q14(r32,v)                _BFSET_(r32,14,14,v)
    #define   GET16AVIO_BCM_FULL_STS_Q14(r16)                  _BFGET_(r16,14,14)
    #define   SET16AVIO_BCM_FULL_STS_Q14(r16,v)                _BFSET_(r16,14,14,v)

    #define   GET32AVIO_BCM_FULL_STS_Q15(r32)                  _BFGET_(r32,15,15)
    #define   SET32AVIO_BCM_FULL_STS_Q15(r32,v)                _BFSET_(r32,15,15,v)
    #define   GET16AVIO_BCM_FULL_STS_Q15(r16)                  _BFGET_(r16,15,15)
    #define   SET16AVIO_BCM_FULL_STS_Q15(r16,v)                _BFSET_(r16,15,15,v)

    #define   GET32AVIO_BCM_FULL_STS_Q16(r32)                  _BFGET_(r32,16,16)
    #define   SET32AVIO_BCM_FULL_STS_Q16(r32,v)                _BFSET_(r32,16,16,v)
    #define   GET16AVIO_BCM_FULL_STS_Q16(r16)                  _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_FULL_STS_Q16(r16,v)                _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_FULL_STS_Q17(r32)                  _BFGET_(r32,17,17)
    #define   SET32AVIO_BCM_FULL_STS_Q17(r32,v)                _BFSET_(r32,17,17,v)
    #define   GET16AVIO_BCM_FULL_STS_Q17(r16)                  _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_FULL_STS_Q17(r16,v)                _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_FULL_STS_Q18(r32)                  _BFGET_(r32,18,18)
    #define   SET32AVIO_BCM_FULL_STS_Q18(r32,v)                _BFSET_(r32,18,18,v)
    #define   GET16AVIO_BCM_FULL_STS_Q18(r16)                  _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_FULL_STS_Q18(r16,v)                _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_FULL_STS_Q31(r32)                  _BFGET_(r32,19,19)
    #define   SET32AVIO_BCM_FULL_STS_Q31(r32,v)                _BFSET_(r32,19,19,v)
    #define   GET16AVIO_BCM_FULL_STS_Q31(r16)                  _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_FULL_STS_Q31(r16,v)                _BFSET_(r16, 3, 3,v)

    #define     w32AVIO_BCM_FULL_STS                           {\
            UNSG32 uBCM_FULL_STS_Q0                            :  1;\
            UNSG32 uBCM_FULL_STS_Q1                            :  1;\
            UNSG32 uBCM_FULL_STS_Q2                            :  1;\
            UNSG32 uBCM_FULL_STS_Q3                            :  1;\
            UNSG32 uBCM_FULL_STS_Q4                            :  1;\
            UNSG32 uBCM_FULL_STS_Q5                            :  1;\
            UNSG32 uBCM_FULL_STS_Q6                            :  1;\
            UNSG32 uBCM_FULL_STS_Q7                            :  1;\
            UNSG32 uBCM_FULL_STS_Q8                            :  1;\
            UNSG32 uBCM_FULL_STS_Q9                            :  1;\
            UNSG32 uBCM_FULL_STS_Q10                           :  1;\
            UNSG32 uBCM_FULL_STS_Q11                           :  1;\
            UNSG32 uBCM_FULL_STS_Q12                           :  1;\
            UNSG32 uBCM_FULL_STS_Q13                           :  1;\
            UNSG32 uBCM_FULL_STS_Q14                           :  1;\
            UNSG32 uBCM_FULL_STS_Q15                           :  1;\
            UNSG32 uBCM_FULL_STS_Q16                           :  1;\
            UNSG32 uBCM_FULL_STS_Q17                           :  1;\
            UNSG32 uBCM_FULL_STS_Q18                           :  1;\
            UNSG32 uBCM_FULL_STS_Q31                           :  1;\
            UNSG32 RSVDx144_b20                                : 12;\
          }
    union { UNSG32 u32AVIO_BCM_FULL_STS;
            struct w32AVIO_BCM_FULL_STS;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_EMP_STS_Q0(r32)                    _BFGET_(r32, 0, 0)
    #define   SET32AVIO_BCM_EMP_STS_Q0(r32,v)                  _BFSET_(r32, 0, 0,v)
    #define   GET16AVIO_BCM_EMP_STS_Q0(r16)                    _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_EMP_STS_Q0(r16,v)                  _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_EMP_STS_Q1(r32)                    _BFGET_(r32, 1, 1)
    #define   SET32AVIO_BCM_EMP_STS_Q1(r32,v)                  _BFSET_(r32, 1, 1,v)
    #define   GET16AVIO_BCM_EMP_STS_Q1(r16)                    _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_EMP_STS_Q1(r16,v)                  _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_EMP_STS_Q2(r32)                    _BFGET_(r32, 2, 2)
    #define   SET32AVIO_BCM_EMP_STS_Q2(r32,v)                  _BFSET_(r32, 2, 2,v)
    #define   GET16AVIO_BCM_EMP_STS_Q2(r16)                    _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_EMP_STS_Q2(r16,v)                  _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_EMP_STS_Q3(r32)                    _BFGET_(r32, 3, 3)
    #define   SET32AVIO_BCM_EMP_STS_Q3(r32,v)                  _BFSET_(r32, 3, 3,v)
    #define   GET16AVIO_BCM_EMP_STS_Q3(r16)                    _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_EMP_STS_Q3(r16,v)                  _BFSET_(r16, 3, 3,v)

    #define   GET32AVIO_BCM_EMP_STS_Q4(r32)                    _BFGET_(r32, 4, 4)
    #define   SET32AVIO_BCM_EMP_STS_Q4(r32,v)                  _BFSET_(r32, 4, 4,v)
    #define   GET16AVIO_BCM_EMP_STS_Q4(r16)                    _BFGET_(r16, 4, 4)
    #define   SET16AVIO_BCM_EMP_STS_Q4(r16,v)                  _BFSET_(r16, 4, 4,v)

    #define   GET32AVIO_BCM_EMP_STS_Q5(r32)                    _BFGET_(r32, 5, 5)
    #define   SET32AVIO_BCM_EMP_STS_Q5(r32,v)                  _BFSET_(r32, 5, 5,v)
    #define   GET16AVIO_BCM_EMP_STS_Q5(r16)                    _BFGET_(r16, 5, 5)
    #define   SET16AVIO_BCM_EMP_STS_Q5(r16,v)                  _BFSET_(r16, 5, 5,v)

    #define   GET32AVIO_BCM_EMP_STS_Q6(r32)                    _BFGET_(r32, 6, 6)
    #define   SET32AVIO_BCM_EMP_STS_Q6(r32,v)                  _BFSET_(r32, 6, 6,v)
    #define   GET16AVIO_BCM_EMP_STS_Q6(r16)                    _BFGET_(r16, 6, 6)
    #define   SET16AVIO_BCM_EMP_STS_Q6(r16,v)                  _BFSET_(r16, 6, 6,v)

    #define   GET32AVIO_BCM_EMP_STS_Q7(r32)                    _BFGET_(r32, 7, 7)
    #define   SET32AVIO_BCM_EMP_STS_Q7(r32,v)                  _BFSET_(r32, 7, 7,v)
    #define   GET16AVIO_BCM_EMP_STS_Q7(r16)                    _BFGET_(r16, 7, 7)
    #define   SET16AVIO_BCM_EMP_STS_Q7(r16,v)                  _BFSET_(r16, 7, 7,v)

    #define   GET32AVIO_BCM_EMP_STS_Q8(r32)                    _BFGET_(r32, 8, 8)
    #define   SET32AVIO_BCM_EMP_STS_Q8(r32,v)                  _BFSET_(r32, 8, 8,v)
    #define   GET16AVIO_BCM_EMP_STS_Q8(r16)                    _BFGET_(r16, 8, 8)
    #define   SET16AVIO_BCM_EMP_STS_Q8(r16,v)                  _BFSET_(r16, 8, 8,v)

    #define   GET32AVIO_BCM_EMP_STS_Q9(r32)                    _BFGET_(r32, 9, 9)
    #define   SET32AVIO_BCM_EMP_STS_Q9(r32,v)                  _BFSET_(r32, 9, 9,v)
    #define   GET16AVIO_BCM_EMP_STS_Q9(r16)                    _BFGET_(r16, 9, 9)
    #define   SET16AVIO_BCM_EMP_STS_Q9(r16,v)                  _BFSET_(r16, 9, 9,v)

    #define   GET32AVIO_BCM_EMP_STS_Q10(r32)                   _BFGET_(r32,10,10)
    #define   SET32AVIO_BCM_EMP_STS_Q10(r32,v)                 _BFSET_(r32,10,10,v)
    #define   GET16AVIO_BCM_EMP_STS_Q10(r16)                   _BFGET_(r16,10,10)
    #define   SET16AVIO_BCM_EMP_STS_Q10(r16,v)                 _BFSET_(r16,10,10,v)

    #define   GET32AVIO_BCM_EMP_STS_Q11(r32)                   _BFGET_(r32,11,11)
    #define   SET32AVIO_BCM_EMP_STS_Q11(r32,v)                 _BFSET_(r32,11,11,v)
    #define   GET16AVIO_BCM_EMP_STS_Q11(r16)                   _BFGET_(r16,11,11)
    #define   SET16AVIO_BCM_EMP_STS_Q11(r16,v)                 _BFSET_(r16,11,11,v)

    #define   GET32AVIO_BCM_EMP_STS_Q12(r32)                   _BFGET_(r32,12,12)
    #define   SET32AVIO_BCM_EMP_STS_Q12(r32,v)                 _BFSET_(r32,12,12,v)
    #define   GET16AVIO_BCM_EMP_STS_Q12(r16)                   _BFGET_(r16,12,12)
    #define   SET16AVIO_BCM_EMP_STS_Q12(r16,v)                 _BFSET_(r16,12,12,v)

    #define   GET32AVIO_BCM_EMP_STS_Q13(r32)                   _BFGET_(r32,13,13)
    #define   SET32AVIO_BCM_EMP_STS_Q13(r32,v)                 _BFSET_(r32,13,13,v)
    #define   GET16AVIO_BCM_EMP_STS_Q13(r16)                   _BFGET_(r16,13,13)
    #define   SET16AVIO_BCM_EMP_STS_Q13(r16,v)                 _BFSET_(r16,13,13,v)

    #define   GET32AVIO_BCM_EMP_STS_Q14(r32)                   _BFGET_(r32,14,14)
    #define   SET32AVIO_BCM_EMP_STS_Q14(r32,v)                 _BFSET_(r32,14,14,v)
    #define   GET16AVIO_BCM_EMP_STS_Q14(r16)                   _BFGET_(r16,14,14)
    #define   SET16AVIO_BCM_EMP_STS_Q14(r16,v)                 _BFSET_(r16,14,14,v)

    #define   GET32AVIO_BCM_EMP_STS_Q15(r32)                   _BFGET_(r32,15,15)
    #define   SET32AVIO_BCM_EMP_STS_Q15(r32,v)                 _BFSET_(r32,15,15,v)
    #define   GET16AVIO_BCM_EMP_STS_Q15(r16)                   _BFGET_(r16,15,15)
    #define   SET16AVIO_BCM_EMP_STS_Q15(r16,v)                 _BFSET_(r16,15,15,v)

    #define   GET32AVIO_BCM_EMP_STS_Q16(r32)                   _BFGET_(r32,16,16)
    #define   SET32AVIO_BCM_EMP_STS_Q16(r32,v)                 _BFSET_(r32,16,16,v)
    #define   GET16AVIO_BCM_EMP_STS_Q16(r16)                   _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_EMP_STS_Q16(r16,v)                 _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_EMP_STS_Q17(r32)                   _BFGET_(r32,17,17)
    #define   SET32AVIO_BCM_EMP_STS_Q17(r32,v)                 _BFSET_(r32,17,17,v)
    #define   GET16AVIO_BCM_EMP_STS_Q17(r16)                   _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_EMP_STS_Q17(r16,v)                 _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_EMP_STS_Q18(r32)                   _BFGET_(r32,18,18)
    #define   SET32AVIO_BCM_EMP_STS_Q18(r32,v)                 _BFSET_(r32,18,18,v)
    #define   GET16AVIO_BCM_EMP_STS_Q18(r16)                   _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_EMP_STS_Q18(r16,v)                 _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_EMP_STS_Q31(r32)                   _BFGET_(r32,19,19)
    #define   SET32AVIO_BCM_EMP_STS_Q31(r32,v)                 _BFSET_(r32,19,19,v)
    #define   GET16AVIO_BCM_EMP_STS_Q31(r16)                   _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_EMP_STS_Q31(r16,v)                 _BFSET_(r16, 3, 3,v)

    #define     w32AVIO_BCM_EMP_STS                            {\
            UNSG32 uBCM_EMP_STS_Q0                             :  1;\
            UNSG32 uBCM_EMP_STS_Q1                             :  1;\
            UNSG32 uBCM_EMP_STS_Q2                             :  1;\
            UNSG32 uBCM_EMP_STS_Q3                             :  1;\
            UNSG32 uBCM_EMP_STS_Q4                             :  1;\
            UNSG32 uBCM_EMP_STS_Q5                             :  1;\
            UNSG32 uBCM_EMP_STS_Q6                             :  1;\
            UNSG32 uBCM_EMP_STS_Q7                             :  1;\
            UNSG32 uBCM_EMP_STS_Q8                             :  1;\
            UNSG32 uBCM_EMP_STS_Q9                             :  1;\
            UNSG32 uBCM_EMP_STS_Q10                            :  1;\
            UNSG32 uBCM_EMP_STS_Q11                            :  1;\
            UNSG32 uBCM_EMP_STS_Q12                            :  1;\
            UNSG32 uBCM_EMP_STS_Q13                            :  1;\
            UNSG32 uBCM_EMP_STS_Q14                            :  1;\
            UNSG32 uBCM_EMP_STS_Q15                            :  1;\
            UNSG32 uBCM_EMP_STS_Q16                            :  1;\
            UNSG32 uBCM_EMP_STS_Q17                            :  1;\
            UNSG32 uBCM_EMP_STS_Q18                            :  1;\
            UNSG32 uBCM_EMP_STS_Q31                            :  1;\
            UNSG32 RSVDx148_b20                                : 12;\
          }
    union { UNSG32 u32AVIO_BCM_EMP_STS;
            struct w32AVIO_BCM_EMP_STS;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_FLUSH_Q0(r32)                      _BFGET_(r32, 0, 0)
    #define   SET32AVIO_BCM_FLUSH_Q0(r32,v)                    _BFSET_(r32, 0, 0,v)
    #define   GET16AVIO_BCM_FLUSH_Q0(r16)                      _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_FLUSH_Q0(r16,v)                    _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_FLUSH_Q1(r32)                      _BFGET_(r32, 1, 1)
    #define   SET32AVIO_BCM_FLUSH_Q1(r32,v)                    _BFSET_(r32, 1, 1,v)
    #define   GET16AVIO_BCM_FLUSH_Q1(r16)                      _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_FLUSH_Q1(r16,v)                    _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_FLUSH_Q2(r32)                      _BFGET_(r32, 2, 2)
    #define   SET32AVIO_BCM_FLUSH_Q2(r32,v)                    _BFSET_(r32, 2, 2,v)
    #define   GET16AVIO_BCM_FLUSH_Q2(r16)                      _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_FLUSH_Q2(r16,v)                    _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_FLUSH_Q3(r32)                      _BFGET_(r32, 3, 3)
    #define   SET32AVIO_BCM_FLUSH_Q3(r32,v)                    _BFSET_(r32, 3, 3,v)
    #define   GET16AVIO_BCM_FLUSH_Q3(r16)                      _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_FLUSH_Q3(r16,v)                    _BFSET_(r16, 3, 3,v)

    #define   GET32AVIO_BCM_FLUSH_Q4(r32)                      _BFGET_(r32, 4, 4)
    #define   SET32AVIO_BCM_FLUSH_Q4(r32,v)                    _BFSET_(r32, 4, 4,v)
    #define   GET16AVIO_BCM_FLUSH_Q4(r16)                      _BFGET_(r16, 4, 4)
    #define   SET16AVIO_BCM_FLUSH_Q4(r16,v)                    _BFSET_(r16, 4, 4,v)

    #define   GET32AVIO_BCM_FLUSH_Q5(r32)                      _BFGET_(r32, 5, 5)
    #define   SET32AVIO_BCM_FLUSH_Q5(r32,v)                    _BFSET_(r32, 5, 5,v)
    #define   GET16AVIO_BCM_FLUSH_Q5(r16)                      _BFGET_(r16, 5, 5)
    #define   SET16AVIO_BCM_FLUSH_Q5(r16,v)                    _BFSET_(r16, 5, 5,v)

    #define   GET32AVIO_BCM_FLUSH_Q6(r32)                      _BFGET_(r32, 6, 6)
    #define   SET32AVIO_BCM_FLUSH_Q6(r32,v)                    _BFSET_(r32, 6, 6,v)
    #define   GET16AVIO_BCM_FLUSH_Q6(r16)                      _BFGET_(r16, 6, 6)
    #define   SET16AVIO_BCM_FLUSH_Q6(r16,v)                    _BFSET_(r16, 6, 6,v)

    #define   GET32AVIO_BCM_FLUSH_Q7(r32)                      _BFGET_(r32, 7, 7)
    #define   SET32AVIO_BCM_FLUSH_Q7(r32,v)                    _BFSET_(r32, 7, 7,v)
    #define   GET16AVIO_BCM_FLUSH_Q7(r16)                      _BFGET_(r16, 7, 7)
    #define   SET16AVIO_BCM_FLUSH_Q7(r16,v)                    _BFSET_(r16, 7, 7,v)

    #define   GET32AVIO_BCM_FLUSH_Q8(r32)                      _BFGET_(r32, 8, 8)
    #define   SET32AVIO_BCM_FLUSH_Q8(r32,v)                    _BFSET_(r32, 8, 8,v)
    #define   GET16AVIO_BCM_FLUSH_Q8(r16)                      _BFGET_(r16, 8, 8)
    #define   SET16AVIO_BCM_FLUSH_Q8(r16,v)                    _BFSET_(r16, 8, 8,v)

    #define   GET32AVIO_BCM_FLUSH_Q9(r32)                      _BFGET_(r32, 9, 9)
    #define   SET32AVIO_BCM_FLUSH_Q9(r32,v)                    _BFSET_(r32, 9, 9,v)
    #define   GET16AVIO_BCM_FLUSH_Q9(r16)                      _BFGET_(r16, 9, 9)
    #define   SET16AVIO_BCM_FLUSH_Q9(r16,v)                    _BFSET_(r16, 9, 9,v)

    #define   GET32AVIO_BCM_FLUSH_Q10(r32)                     _BFGET_(r32,10,10)
    #define   SET32AVIO_BCM_FLUSH_Q10(r32,v)                   _BFSET_(r32,10,10,v)
    #define   GET16AVIO_BCM_FLUSH_Q10(r16)                     _BFGET_(r16,10,10)
    #define   SET16AVIO_BCM_FLUSH_Q10(r16,v)                   _BFSET_(r16,10,10,v)

    #define   GET32AVIO_BCM_FLUSH_Q11(r32)                     _BFGET_(r32,11,11)
    #define   SET32AVIO_BCM_FLUSH_Q11(r32,v)                   _BFSET_(r32,11,11,v)
    #define   GET16AVIO_BCM_FLUSH_Q11(r16)                     _BFGET_(r16,11,11)
    #define   SET16AVIO_BCM_FLUSH_Q11(r16,v)                   _BFSET_(r16,11,11,v)

    #define   GET32AVIO_BCM_FLUSH_Q12(r32)                     _BFGET_(r32,12,12)
    #define   SET32AVIO_BCM_FLUSH_Q12(r32,v)                   _BFSET_(r32,12,12,v)
    #define   GET16AVIO_BCM_FLUSH_Q12(r16)                     _BFGET_(r16,12,12)
    #define   SET16AVIO_BCM_FLUSH_Q12(r16,v)                   _BFSET_(r16,12,12,v)

    #define   GET32AVIO_BCM_FLUSH_Q13(r32)                     _BFGET_(r32,13,13)
    #define   SET32AVIO_BCM_FLUSH_Q13(r32,v)                   _BFSET_(r32,13,13,v)
    #define   GET16AVIO_BCM_FLUSH_Q13(r16)                     _BFGET_(r16,13,13)
    #define   SET16AVIO_BCM_FLUSH_Q13(r16,v)                   _BFSET_(r16,13,13,v)

    #define   GET32AVIO_BCM_FLUSH_Q14(r32)                     _BFGET_(r32,14,14)
    #define   SET32AVIO_BCM_FLUSH_Q14(r32,v)                   _BFSET_(r32,14,14,v)
    #define   GET16AVIO_BCM_FLUSH_Q14(r16)                     _BFGET_(r16,14,14)
    #define   SET16AVIO_BCM_FLUSH_Q14(r16,v)                   _BFSET_(r16,14,14,v)

    #define   GET32AVIO_BCM_FLUSH_Q15(r32)                     _BFGET_(r32,15,15)
    #define   SET32AVIO_BCM_FLUSH_Q15(r32,v)                   _BFSET_(r32,15,15,v)
    #define   GET16AVIO_BCM_FLUSH_Q15(r16)                     _BFGET_(r16,15,15)
    #define   SET16AVIO_BCM_FLUSH_Q15(r16,v)                   _BFSET_(r16,15,15,v)

    #define   GET32AVIO_BCM_FLUSH_Q16(r32)                     _BFGET_(r32,16,16)
    #define   SET32AVIO_BCM_FLUSH_Q16(r32,v)                   _BFSET_(r32,16,16,v)
    #define   GET16AVIO_BCM_FLUSH_Q16(r16)                     _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_FLUSH_Q16(r16,v)                   _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_FLUSH_Q17(r32)                     _BFGET_(r32,17,17)
    #define   SET32AVIO_BCM_FLUSH_Q17(r32,v)                   _BFSET_(r32,17,17,v)
    #define   GET16AVIO_BCM_FLUSH_Q17(r16)                     _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_FLUSH_Q17(r16,v)                   _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_FLUSH_Q18(r32)                     _BFGET_(r32,18,18)
    #define   SET32AVIO_BCM_FLUSH_Q18(r32,v)                   _BFSET_(r32,18,18,v)
    #define   GET16AVIO_BCM_FLUSH_Q18(r16)                     _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_FLUSH_Q18(r16,v)                   _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_FLUSH_Q31(r32)                     _BFGET_(r32,19,19)
    #define   SET32AVIO_BCM_FLUSH_Q31(r32,v)                   _BFSET_(r32,19,19,v)
    #define   GET16AVIO_BCM_FLUSH_Q31(r16)                     _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_FLUSH_Q31(r16,v)                   _BFSET_(r16, 3, 3,v)

    #define     w32AVIO_BCM_FLUSH                              {\
            UNSG32 uBCM_FLUSH_Q0                               :  1;\
            UNSG32 uBCM_FLUSH_Q1                               :  1;\
            UNSG32 uBCM_FLUSH_Q2                               :  1;\
            UNSG32 uBCM_FLUSH_Q3                               :  1;\
            UNSG32 uBCM_FLUSH_Q4                               :  1;\
            UNSG32 uBCM_FLUSH_Q5                               :  1;\
            UNSG32 uBCM_FLUSH_Q6                               :  1;\
            UNSG32 uBCM_FLUSH_Q7                               :  1;\
            UNSG32 uBCM_FLUSH_Q8                               :  1;\
            UNSG32 uBCM_FLUSH_Q9                               :  1;\
            UNSG32 uBCM_FLUSH_Q10                              :  1;\
            UNSG32 uBCM_FLUSH_Q11                              :  1;\
            UNSG32 uBCM_FLUSH_Q12                              :  1;\
            UNSG32 uBCM_FLUSH_Q13                              :  1;\
            UNSG32 uBCM_FLUSH_Q14                              :  1;\
            UNSG32 uBCM_FLUSH_Q15                              :  1;\
            UNSG32 uBCM_FLUSH_Q16                              :  1;\
            UNSG32 uBCM_FLUSH_Q17                              :  1;\
            UNSG32 uBCM_FLUSH_Q18                              :  1;\
            UNSG32 uBCM_FLUSH_Q31                              :  1;\
            UNSG32 RSVDx14C_b20                                : 12;\
          }
    union { UNSG32 u32AVIO_BCM_FLUSH;
            struct w32AVIO_BCM_FLUSH;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_AUTOPUSH_CNT_OCCURENCE(r32)        _BFGET_(r32,31, 0)
    #define   SET32AVIO_BCM_AUTOPUSH_CNT_OCCURENCE(r32,v)      _BFSET_(r32,31, 0,v)

    #define     w32AVIO_BCM_AUTOPUSH_CNT                       {\
            UNSG32 uBCM_AUTOPUSH_CNT_OCCURENCE                 : 32;\
          }
    union { UNSG32 u32AVIO_BCM_AUTOPUSH_CNT;
            struct w32AVIO_BCM_AUTOPUSH_CNT;
          };
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q0;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q1;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q2;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q3;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q4;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q5;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q6;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q7;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q8;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q9;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q10;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q11;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q14;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q15;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q16;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q17;
    ///////////////////////////////////////////////////////////
              SIE_OCCURENCE                                    ie_Q18;
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_AUTOPUSH_Q0(r32)                   _BFGET_(r32, 0, 0)
    #define   SET32AVIO_BCM_AUTOPUSH_Q0(r32,v)                 _BFSET_(r32, 0, 0,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q0(r16)                   _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_AUTOPUSH_Q0(r16,v)                 _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q1(r32)                   _BFGET_(r32, 1, 1)
    #define   SET32AVIO_BCM_AUTOPUSH_Q1(r32,v)                 _BFSET_(r32, 1, 1,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q1(r16)                   _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_AUTOPUSH_Q1(r16,v)                 _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q2(r32)                   _BFGET_(r32, 2, 2)
    #define   SET32AVIO_BCM_AUTOPUSH_Q2(r32,v)                 _BFSET_(r32, 2, 2,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q2(r16)                   _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_AUTOPUSH_Q2(r16,v)                 _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q3(r32)                   _BFGET_(r32, 3, 3)
    #define   SET32AVIO_BCM_AUTOPUSH_Q3(r32,v)                 _BFSET_(r32, 3, 3,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q3(r16)                   _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_AUTOPUSH_Q3(r16,v)                 _BFSET_(r16, 3, 3,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q4(r32)                   _BFGET_(r32, 4, 4)
    #define   SET32AVIO_BCM_AUTOPUSH_Q4(r32,v)                 _BFSET_(r32, 4, 4,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q4(r16)                   _BFGET_(r16, 4, 4)
    #define   SET16AVIO_BCM_AUTOPUSH_Q4(r16,v)                 _BFSET_(r16, 4, 4,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q5(r32)                   _BFGET_(r32, 5, 5)
    #define   SET32AVIO_BCM_AUTOPUSH_Q5(r32,v)                 _BFSET_(r32, 5, 5,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q5(r16)                   _BFGET_(r16, 5, 5)
    #define   SET16AVIO_BCM_AUTOPUSH_Q5(r16,v)                 _BFSET_(r16, 5, 5,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q6(r32)                   _BFGET_(r32, 6, 6)
    #define   SET32AVIO_BCM_AUTOPUSH_Q6(r32,v)                 _BFSET_(r32, 6, 6,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q6(r16)                   _BFGET_(r16, 6, 6)
    #define   SET16AVIO_BCM_AUTOPUSH_Q6(r16,v)                 _BFSET_(r16, 6, 6,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q7(r32)                   _BFGET_(r32, 7, 7)
    #define   SET32AVIO_BCM_AUTOPUSH_Q7(r32,v)                 _BFSET_(r32, 7, 7,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q7(r16)                   _BFGET_(r16, 7, 7)
    #define   SET16AVIO_BCM_AUTOPUSH_Q7(r16,v)                 _BFSET_(r16, 7, 7,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q8(r32)                   _BFGET_(r32, 8, 8)
    #define   SET32AVIO_BCM_AUTOPUSH_Q8(r32,v)                 _BFSET_(r32, 8, 8,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q8(r16)                   _BFGET_(r16, 8, 8)
    #define   SET16AVIO_BCM_AUTOPUSH_Q8(r16,v)                 _BFSET_(r16, 8, 8,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q9(r32)                   _BFGET_(r32, 9, 9)
    #define   SET32AVIO_BCM_AUTOPUSH_Q9(r32,v)                 _BFSET_(r32, 9, 9,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q9(r16)                   _BFGET_(r16, 9, 9)
    #define   SET16AVIO_BCM_AUTOPUSH_Q9(r16,v)                 _BFSET_(r16, 9, 9,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q10(r32)                  _BFGET_(r32,10,10)
    #define   SET32AVIO_BCM_AUTOPUSH_Q10(r32,v)                _BFSET_(r32,10,10,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q10(r16)                  _BFGET_(r16,10,10)
    #define   SET16AVIO_BCM_AUTOPUSH_Q10(r16,v)                _BFSET_(r16,10,10,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q11(r32)                  _BFGET_(r32,11,11)
    #define   SET32AVIO_BCM_AUTOPUSH_Q11(r32,v)                _BFSET_(r32,11,11,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q11(r16)                  _BFGET_(r16,11,11)
    #define   SET16AVIO_BCM_AUTOPUSH_Q11(r16,v)                _BFSET_(r16,11,11,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q12(r32)                  _BFGET_(r32,12,12)
    #define   SET32AVIO_BCM_AUTOPUSH_Q12(r32,v)                _BFSET_(r32,12,12,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q12(r16)                  _BFGET_(r16,12,12)
    #define   SET16AVIO_BCM_AUTOPUSH_Q12(r16,v)                _BFSET_(r16,12,12,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q13(r32)                  _BFGET_(r32,13,13)
    #define   SET32AVIO_BCM_AUTOPUSH_Q13(r32,v)                _BFSET_(r32,13,13,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q13(r16)                  _BFGET_(r16,13,13)
    #define   SET16AVIO_BCM_AUTOPUSH_Q13(r16,v)                _BFSET_(r16,13,13,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q14(r32)                  _BFGET_(r32,14,14)
    #define   SET32AVIO_BCM_AUTOPUSH_Q14(r32,v)                _BFSET_(r32,14,14,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q14(r16)                  _BFGET_(r16,14,14)
    #define   SET16AVIO_BCM_AUTOPUSH_Q14(r16,v)                _BFSET_(r16,14,14,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q15(r32)                  _BFGET_(r32,15,15)
    #define   SET32AVIO_BCM_AUTOPUSH_Q15(r32,v)                _BFSET_(r32,15,15,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q15(r16)                  _BFGET_(r16,15,15)
    #define   SET16AVIO_BCM_AUTOPUSH_Q15(r16,v)                _BFSET_(r16,15,15,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q16(r32)                  _BFGET_(r32,16,16)
    #define   SET32AVIO_BCM_AUTOPUSH_Q16(r32,v)                _BFSET_(r32,16,16,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q16(r16)                  _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_AUTOPUSH_Q16(r16,v)                _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q17(r32)                  _BFGET_(r32,17,17)
    #define   SET32AVIO_BCM_AUTOPUSH_Q17(r32,v)                _BFSET_(r32,17,17,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q17(r16)                  _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_AUTOPUSH_Q17(r16,v)                _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_AUTOPUSH_Q18(r32)                  _BFGET_(r32,18,18)
    #define   SET32AVIO_BCM_AUTOPUSH_Q18(r32,v)                _BFSET_(r32,18,18,v)
    #define   GET16AVIO_BCM_AUTOPUSH_Q18(r16)                  _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_AUTOPUSH_Q18(r16,v)                _BFSET_(r16, 2, 2,v)

    #define     w32AVIO_BCM_AUTOPUSH                           {\
            UNSG32 uBCM_AUTOPUSH_Q0                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q1                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q2                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q3                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q4                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q5                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q6                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q7                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q8                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q9                            :  1;\
            UNSG32 uBCM_AUTOPUSH_Q10                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q11                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q12                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q13                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q14                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q15                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q16                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q17                           :  1;\
            UNSG32 uBCM_AUTOPUSH_Q18                           :  1;\
            UNSG32 RSVDx198_b19                                : 13;\
          }
    union { UNSG32 u32AVIO_BCM_AUTOPUSH;
            struct w32AVIO_BCM_AUTOPUSH;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q0(r32)            _BFGET_(r32, 0, 0)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q0(r32,v)          _BFSET_(r32, 0, 0,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q0(r16)            _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q0(r16,v)          _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q1(r32)            _BFGET_(r32, 1, 1)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q1(r32,v)          _BFSET_(r32, 1, 1,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q1(r16)            _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q1(r16,v)          _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q2(r32)            _BFGET_(r32, 2, 2)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q2(r32,v)          _BFSET_(r32, 2, 2,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q2(r16)            _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q2(r16,v)          _BFSET_(r16, 2, 2,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q3(r32)            _BFGET_(r32, 3, 3)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q3(r32,v)          _BFSET_(r32, 3, 3,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q3(r16)            _BFGET_(r16, 3, 3)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q3(r16,v)          _BFSET_(r16, 3, 3,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q4(r32)            _BFGET_(r32, 4, 4)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q4(r32,v)          _BFSET_(r32, 4, 4,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q4(r16)            _BFGET_(r16, 4, 4)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q4(r16,v)          _BFSET_(r16, 4, 4,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q5(r32)            _BFGET_(r32, 5, 5)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q5(r32,v)          _BFSET_(r32, 5, 5,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q5(r16)            _BFGET_(r16, 5, 5)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q5(r16,v)          _BFSET_(r16, 5, 5,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q6(r32)            _BFGET_(r32, 6, 6)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q6(r32,v)          _BFSET_(r32, 6, 6,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q6(r16)            _BFGET_(r16, 6, 6)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q6(r16,v)          _BFSET_(r16, 6, 6,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q7(r32)            _BFGET_(r32, 7, 7)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q7(r32,v)          _BFSET_(r32, 7, 7,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q7(r16)            _BFGET_(r16, 7, 7)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q7(r16,v)          _BFSET_(r16, 7, 7,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q8(r32)            _BFGET_(r32, 8, 8)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q8(r32,v)          _BFSET_(r32, 8, 8,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q8(r16)            _BFGET_(r16, 8, 8)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q8(r16,v)          _BFSET_(r16, 8, 8,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q9(r32)            _BFGET_(r32, 9, 9)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q9(r32,v)          _BFSET_(r32, 9, 9,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q9(r16)            _BFGET_(r16, 9, 9)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q9(r16,v)          _BFSET_(r16, 9, 9,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q10(r32)           _BFGET_(r32,10,10)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q10(r32,v)         _BFSET_(r32,10,10,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q10(r16)           _BFGET_(r16,10,10)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q10(r16,v)         _BFSET_(r16,10,10,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q11(r32)           _BFGET_(r32,11,11)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q11(r32,v)         _BFSET_(r32,11,11,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q11(r16)           _BFGET_(r16,11,11)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q11(r16,v)         _BFSET_(r16,11,11,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q12(r32)           _BFGET_(r32,12,12)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q12(r32,v)         _BFSET_(r32,12,12,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q12(r16)           _BFGET_(r16,12,12)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q12(r16,v)         _BFSET_(r16,12,12,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q13(r32)           _BFGET_(r32,13,13)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q13(r32,v)         _BFSET_(r32,13,13,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q13(r16)           _BFGET_(r16,13,13)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q13(r16,v)         _BFSET_(r16,13,13,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q14(r32)           _BFGET_(r32,14,14)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q14(r32,v)         _BFSET_(r32,14,14,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q14(r16)           _BFGET_(r16,14,14)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q14(r16,v)         _BFSET_(r16,14,14,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q15(r32)           _BFGET_(r32,15,15)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q15(r32,v)         _BFSET_(r32,15,15,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q15(r16)           _BFGET_(r16,15,15)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q15(r16,v)         _BFSET_(r16,15,15,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q16(r32)           _BFGET_(r32,16,16)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q16(r32,v)         _BFSET_(r32,16,16,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q16(r16)           _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q16(r16,v)         _BFSET_(r16, 0, 0,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q17(r32)           _BFGET_(r32,17,17)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q17(r32,v)         _BFSET_(r32,17,17,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q17(r16)           _BFGET_(r16, 1, 1)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q17(r16,v)         _BFSET_(r16, 1, 1,v)

    #define   GET32AVIO_BCM_FULL_STS_STICKY_Q18(r32)           _BFGET_(r32,18,18)
    #define   SET32AVIO_BCM_FULL_STS_STICKY_Q18(r32,v)         _BFSET_(r32,18,18,v)
    #define   GET16AVIO_BCM_FULL_STS_STICKY_Q18(r16)           _BFGET_(r16, 2, 2)
    #define   SET16AVIO_BCM_FULL_STS_STICKY_Q18(r16,v)         _BFSET_(r16, 2, 2,v)

    #define     w32AVIO_BCM_FULL_STS_STICKY                    {\
            UNSG32 uBCM_FULL_STS_STICKY_Q0                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q1                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q2                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q3                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q4                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q5                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q6                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q7                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q8                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q9                     :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q10                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q11                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q12                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q13                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q14                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q15                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q16                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q17                    :  1;\
            UNSG32 uBCM_FULL_STS_STICKY_Q18                    :  1;\
            UNSG32 RSVDx19C_b19                                : 13;\
          }
    union { UNSG32 u32AVIO_BCM_FULL_STS_STICKY;
            struct w32AVIO_BCM_FULL_STS_STICKY;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_ERROR_err(r32)                     _BFGET_(r32, 0, 0)
    #define   SET32AVIO_BCM_ERROR_err(r32,v)                   _BFSET_(r32, 0, 0,v)
    #define   GET16AVIO_BCM_ERROR_err(r16)                     _BFGET_(r16, 0, 0)
    #define   SET16AVIO_BCM_ERROR_err(r16,v)                   _BFSET_(r16, 0, 0,v)

    #define     w32AVIO_BCM_ERROR                              {\
            UNSG32 uBCM_ERROR_err                              :  1;\
            UNSG32 RSVDx1A0_b1                                 : 31;\
          }
    union { UNSG32 u32AVIO_BCM_ERROR;
            struct w32AVIO_BCM_ERROR;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_LOG_ADDR_addr(r32)                 _BFGET_(r32,31, 0)
    #define   SET32AVIO_BCM_LOG_ADDR_addr(r32,v)               _BFSET_(r32,31, 0,v)

    #define     w32AVIO_BCM_LOG_ADDR                           {\
            UNSG32 uBCM_LOG_ADDR_addr                          : 32;\
          }
    union { UNSG32 u32AVIO_BCM_LOG_ADDR;
            struct w32AVIO_BCM_LOG_ADDR;
          };
    ///////////////////////////////////////////////////////////
    #define   GET32AVIO_BCM_ERROR_DATA_data(r32)               _BFGET_(r32,31, 0)
    #define   SET32AVIO_BCM_ERROR_DATA_data(r32,v)             _BFSET_(r32,31, 0,v)

    #define     w32AVIO_BCM_ERROR_DATA                         {\
            UNSG32 uBCM_ERROR_DATA_data                        : 32;\
          }
    union { UNSG32 u32AVIO_BCM_ERROR_DATA;
            struct w32AVIO_BCM_ERROR_DATA;
          };
    ///////////////////////////////////////////////////////////
             UNSG8 RSVDx1AC                                    [84];
    ///////////////////////////////////////////////////////////
    } SIE_AVIO;

    typedef union  T32AVIO_BCM_Q0
          { UNSG32 u32;
            struct w32AVIO_BCM_Q0;
                 } T32AVIO_BCM_Q0;
    typedef union  T32AVIO_BCM_Q1
          { UNSG32 u32;
            struct w32AVIO_BCM_Q1;
                 } T32AVIO_BCM_Q1;
    typedef union  T32AVIO_BCM_Q2
          { UNSG32 u32;
            struct w32AVIO_BCM_Q2;
                 } T32AVIO_BCM_Q2;
    typedef union  T32AVIO_BCM_Q3
          { UNSG32 u32;
            struct w32AVIO_BCM_Q3;
                 } T32AVIO_BCM_Q3;
    typedef union  T32AVIO_BCM_Q4
          { UNSG32 u32;
            struct w32AVIO_BCM_Q4;
                 } T32AVIO_BCM_Q4;
    typedef union  T32AVIO_BCM_Q5
          { UNSG32 u32;
            struct w32AVIO_BCM_Q5;
                 } T32AVIO_BCM_Q5;
    typedef union  T32AVIO_BCM_Q6
          { UNSG32 u32;
            struct w32AVIO_BCM_Q6;
                 } T32AVIO_BCM_Q6;
    typedef union  T32AVIO_BCM_Q7
          { UNSG32 u32;
            struct w32AVIO_BCM_Q7;
                 } T32AVIO_BCM_Q7;
    typedef union  T32AVIO_BCM_Q8
          { UNSG32 u32;
            struct w32AVIO_BCM_Q8;
                 } T32AVIO_BCM_Q8;
    typedef union  T32AVIO_BCM_Q9
          { UNSG32 u32;
            struct w32AVIO_BCM_Q9;
                 } T32AVIO_BCM_Q9;
    typedef union  T32AVIO_BCM_Q10
          { UNSG32 u32;
            struct w32AVIO_BCM_Q10;
                 } T32AVIO_BCM_Q10;
    typedef union  T32AVIO_BCM_Q11
          { UNSG32 u32;
            struct w32AVIO_BCM_Q11;
                 } T32AVIO_BCM_Q11;
    typedef union  T32AVIO_BCM_Q14
          { UNSG32 u32;
            struct w32AVIO_BCM_Q14;
                 } T32AVIO_BCM_Q14;
    typedef union  T32AVIO_BCM_Q15
          { UNSG32 u32;
            struct w32AVIO_BCM_Q15;
                 } T32AVIO_BCM_Q15;
    typedef union  T32AVIO_BCM_Q16
          { UNSG32 u32;
            struct w32AVIO_BCM_Q16;
                 } T32AVIO_BCM_Q16;
    typedef union  T32AVIO_BCM_Q17
          { UNSG32 u32;
            struct w32AVIO_BCM_Q17;
                 } T32AVIO_BCM_Q17;
    typedef union  T32AVIO_BCM_Q18
          { UNSG32 u32;
            struct w32AVIO_BCM_Q18;
                 } T32AVIO_BCM_Q18;
    typedef union  T32AVIO_BCM_FULL_STS
          { UNSG32 u32;
            struct w32AVIO_BCM_FULL_STS;
                 } T32AVIO_BCM_FULL_STS;
    typedef union  T32AVIO_BCM_EMP_STS
          { UNSG32 u32;
            struct w32AVIO_BCM_EMP_STS;
                 } T32AVIO_BCM_EMP_STS;
    typedef union  T32AVIO_BCM_FLUSH
          { UNSG32 u32;
            struct w32AVIO_BCM_FLUSH;
                 } T32AVIO_BCM_FLUSH;
    typedef union  T32AVIO_BCM_AUTOPUSH_CNT
          { UNSG32 u32;
            struct w32AVIO_BCM_AUTOPUSH_CNT;
                 } T32AVIO_BCM_AUTOPUSH_CNT;
    typedef union  T32AVIO_BCM_AUTOPUSH
          { UNSG32 u32;
            struct w32AVIO_BCM_AUTOPUSH;
                 } T32AVIO_BCM_AUTOPUSH;
    typedef union  T32AVIO_BCM_FULL_STS_STICKY
          { UNSG32 u32;
            struct w32AVIO_BCM_FULL_STS_STICKY;
                 } T32AVIO_BCM_FULL_STS_STICKY;
    typedef union  T32AVIO_BCM_ERROR
          { UNSG32 u32;
            struct w32AVIO_BCM_ERROR;
                 } T32AVIO_BCM_ERROR;
    typedef union  T32AVIO_BCM_LOG_ADDR
          { UNSG32 u32;
            struct w32AVIO_BCM_LOG_ADDR;
                 } T32AVIO_BCM_LOG_ADDR;
    typedef union  T32AVIO_BCM_ERROR_DATA
          { UNSG32 u32;
            struct w32AVIO_BCM_ERROR_DATA;
                 } T32AVIO_BCM_ERROR_DATA;
    ///////////////////////////////////////////////////////////

    typedef union  TAVIO_BCM_Q0
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q0;
                   };
                 } TAVIO_BCM_Q0;
    typedef union  TAVIO_BCM_Q1
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q1;
                   };
                 } TAVIO_BCM_Q1;
    typedef union  TAVIO_BCM_Q2
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q2;
                   };
                 } TAVIO_BCM_Q2;
    typedef union  TAVIO_BCM_Q3
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q3;
                   };
                 } TAVIO_BCM_Q3;
    typedef union  TAVIO_BCM_Q4
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q4;
                   };
                 } TAVIO_BCM_Q4;
    typedef union  TAVIO_BCM_Q5
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q5;
                   };
                 } TAVIO_BCM_Q5;
    typedef union  TAVIO_BCM_Q6
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q6;
                   };
                 } TAVIO_BCM_Q6;
    typedef union  TAVIO_BCM_Q7
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q7;
                   };
                 } TAVIO_BCM_Q7;
    typedef union  TAVIO_BCM_Q8
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q8;
                   };
                 } TAVIO_BCM_Q8;
    typedef union  TAVIO_BCM_Q9
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q9;
                   };
                 } TAVIO_BCM_Q9;
    typedef union  TAVIO_BCM_Q10
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q10;
                   };
                 } TAVIO_BCM_Q10;
    typedef union  TAVIO_BCM_Q11
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q11;
                   };
                 } TAVIO_BCM_Q11;
    typedef union  TAVIO_BCM_Q14
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q14;
                   };
                 } TAVIO_BCM_Q14;
    typedef union  TAVIO_BCM_Q15
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q15;
                   };
                 } TAVIO_BCM_Q15;
    typedef union  TAVIO_BCM_Q16
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q16;
                   };
                 } TAVIO_BCM_Q16;
    typedef union  TAVIO_BCM_Q17
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q17;
                   };
                 } TAVIO_BCM_Q17;
    typedef union  TAVIO_BCM_Q18
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_Q18;
                   };
                 } TAVIO_BCM_Q18;
    typedef union  TAVIO_BCM_FULL_STS
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_FULL_STS;
                   };
                 } TAVIO_BCM_FULL_STS;
    typedef union  TAVIO_BCM_EMP_STS
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_EMP_STS;
                   };
                 } TAVIO_BCM_EMP_STS;
    typedef union  TAVIO_BCM_FLUSH
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_FLUSH;
                   };
                 } TAVIO_BCM_FLUSH;
    typedef union  TAVIO_BCM_AUTOPUSH_CNT
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_AUTOPUSH_CNT;
                   };
                 } TAVIO_BCM_AUTOPUSH_CNT;
    typedef union  TAVIO_BCM_AUTOPUSH
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_AUTOPUSH;
                   };
                 } TAVIO_BCM_AUTOPUSH;
    typedef union  TAVIO_BCM_FULL_STS_STICKY
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_FULL_STS_STICKY;
                   };
                 } TAVIO_BCM_FULL_STS_STICKY;
    typedef union  TAVIO_BCM_ERROR
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_ERROR;
                   };
                 } TAVIO_BCM_ERROR;
    typedef union  TAVIO_BCM_LOG_ADDR
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_LOG_ADDR;
                   };
                 } TAVIO_BCM_LOG_ADDR;
    typedef union  TAVIO_BCM_ERROR_DATA
          { UNSG32 u32[1];
            struct {
            struct w32AVIO_BCM_ERROR_DATA;
                   };
                 } TAVIO_BCM_ERROR_DATA;

    ///////////////////////////////////////////////////////////
     SIGN32 AVIO_drvrd(SIE_AVIO *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 AVIO_drvwr(SIE_AVIO *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void AVIO_reset(SIE_AVIO *p);
     SIGN32 AVIO_cmp  (SIE_AVIO *p, SIE_AVIO *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define AVIO_check(p,pie,pfx,hLOG) AVIO_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define AVIO_print(p,    pfx,hLOG) AVIO_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: AVIO
////////////////////////////////////////////////////////////



#ifdef __cplusplus
  }
#endif
#pragma  pack()

#endif
//////
/// ENDOFFILE: avio.h
////////////////////////////////////////////////////////////

