/******************************************************************************
 * Copyright (c) 2013-2014 Marvell International Ltd. and its affiliates.
 * All rights reserved.
 *
 * This software file (the "File") is owned and distributed by Marvell
 * International Ltd. and/or its affiliates ("Marvell") under the following
 * licensing terms.
 ******************************************************************************
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell and you have entered into a
 * commercial license agreement (a "Commercial License") with Marvell, the
 * File is licensed to you under the terms of the applicable Commercial
 * License.
 ******************************************************************************
 * Marvell GPL License Option
 *
 * If you received this File from Marvell, you may opt to use, redistribute
 * and/or modify this File in accordance with the terms and conditions of the
 * General Public License Version 2, June 1991 (the "GPL License"), a copy of
 * which is available along with the File in the license.txt file or by writing
 * to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 or on the worldwide web at http://www.gnu.org/licenses/gpl.txt.
 * THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE ARE
 * EXPRESSLY DISCLAIMED. The GPL License provides additional details about this
 * warranty disclaimer.
 *******************************************************************************/
//////
/// don't edit! auto-generated by docc: Galois_memmap.h
////////////////////////////////////////////////////////////
#ifndef Galois_memmap_h
#define Galois_memmap_h (){}


#include "ctypes.h"

#pragma pack(1)
#ifdef __cplusplus
  extern "C" {
#endif

#ifndef _DOCC_H_BITOPS_
#define _DOCC_H_BITOPS_ (){}

    #define _bSETMASK_(b)                                      ((b)<32 ? (1<<((b)&31)) : 0)
    #define _NSETMASK_(msb,lsb)                                (_bSETMASK_((msb)+1)-_bSETMASK_(lsb))
    #define _bCLRMASK_(b)                                      (~_bSETMASK_(b))
    #define _NCLRMASK_(msb,lsb)                                (~_NSETMASK_(msb,lsb))
    #define _BFGET_(r,msb,lsb)                                 (_NSETMASK_((msb)-(lsb),0)&((r)>>(lsb)))
    #define _BFSET_(r,msb,lsb,v)                               do{ (r)&=_NCLRMASK_(msb,lsb); (r)|=_NSETMASK_(msb,lsb)&((v)<<(lsb)); }while(0)

#endif



//////
/// 
/// $INTERFACE MEMMAP                                   (4,4)
///     # # ----------------------------------------------------------
///               : DRAM_CACHE_BASE    0x0
///                            ###
///                            * This should be big enough. Bigger dram will make not make sense for cost consideration.
///                            * 1024 MB
///                            ###
///               : DRAM_CACHE_SIZE    0x40000000
///                            ###
///                            * Size of cacheable DDR memory mapping
///                            ###
///               : DRAM_CACHE_DEC_BIT 0x1E
///                            ###
///                            * 1024 MB has a 30 bits offset
///                            ###
///               : DRAM_UNCACHE_BASE  0x40000000
///                            ###
///                            * Start address of uncacheable DDR
///                            * 1024 MB
///                            ###
///               : DRAM_UNCACHE_SIZE  0x40000000
///                            ###
///                            * Size of uncacheable DDR memory mapping
///                            ###
///               : DRAM_UNCACHE_DEC_BIT 0x1E
///                            ###
///                            * 1024 MB has a 30 bits offset
///                            ###
///               : DRAM_2GBTO3GB_BASE 0x80000000
///                            ###
///                            * Start address of 2GB to 3GB DDR
///                            * 1024 MB
///                            ###
///               : DRAM_2GBTO3GB_SIZE 0x40000000
///                            ###
///                            * Size of 2GB to 3GB memory mapping
///                            ###
///               : DRAM_2GBTO3GB_DEC_BIT 0x1E
///                            ###
///                            * 1024 MB has 30 bits offset
///                            ###
///               : DRAM_3GBTO3P5GB_BASE 0xC0000000
///                            ###
///                            * Start address of 3GB to 3.5GB DDR
///                            * 512 MB
///                            ###
///               : DRAM_3GBTO3P5GB_SIZE 0x20000000
///                            ###
///                            * Size of 3GB to 3.5GB memory mapping
///                            ###
///               : DRAM_3GBTO3P5GB_DEC_BIT 0x1D
///                            ###
///                            * 512 MB has 29 bits offset
///                            ###
///               : PCIE_UPSTREAM_BASE 0xE0000000
///                            ###
///                            * PCIe memory from endpoint's point of view
///                            * 256 MB
///                            ###
///               : PCIE_UPSTREAM_SIZE 0x10000000
///                            ###
///                            * Size of PCI-Express upstream memory mapping
///                            ###
///               : PCIE_UPSTREAM_DEC_BIT 0x1C
///                            ###
///                            * 258 MB has a 28 bits offset
///                            * Memory map for Data Cross-bar control Register base
///                            ###
///               : DXBAR_REG_BASE     0xA0000000
///                            ###
///                            * DXBAR Control Register Base Address
///                            * 64KB
///                            ###
///               : DXBAR_REG_SIZE     0x10000
///                            ###
///                            * Size of DxBar control register
///                            ###
///               : DXBAR_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has a 16 bits offset
///                            ###
///               : PXBAR_REG_BASE     0xA0010000
///                            ###
///                            * PXBAR control register base address
///                            * 64KB
///                            ###
///               : PXBAR_REG_SIZE     0x10000
///                            ###
///                            * Size of PXBAR control register
///                            ###
///               : PXBAR_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has a 16 bits offset
///                            ###
///               : CXBAR_REG_BASE     0xA0020000
///                            ###
///                            * CXBAR control register address
///                            * 64KB
///                            ###
///               : CXBAR_REG_SIZE     0x10000
///                            ###
///                            * size of CXBAR control register
///                            ###
///               : CXBAR_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has 16 bits offset
///                            ###
///               : RESERVED_BASE      0xA0030000
///                            ###
///                            * Reserved memory space
///                            * 1 GB - 48KB
///                            ###
///               : PCIE_DOWNSTREAM_BASE 0xE0000000
///                            ###
///                            * Reserved (space to map Galois DDR to PCIe host. This is from the PCIe host point of view. So this space COULD still be used by Galois CPU, but intentionally left blank to avoid causing any confusion)
///                            * 256 MB
///                            ###
///               : PCIE_DOWNSTREAM_SIZE 0x10000000
///                            ###
///                            * Size of PCI-Express Down Stream memory mapping
///                            ###
///               : PCIE_DOWNSTREAM_DEC_BIT 0x1C
///                            ###
///                            * 256 MB has a 28 bits offset
///                            ###
///               : SPI_FLASH_BASE     0xF0000000
///                            ###
///                            * The following 256 MB can be mapped to host PCI-Express for easier access /debugging
///                            * Base address for SPI flash
///                            * 64 MB (depends on the configuration)
///                            * 100M AHB
///                            ###
///               : SPI_FLASH_SIZE     0x4000000
///                            ###
///                            * Size of SPI flash
///                            * 64 MB
///                            ###
///               : SPI_FLASH_DEC_BIT  0x1A
///                            ###
///                            * 64 MB has a 26 bits offset
///                            ###
///               : SUNOL_FLASH_BASE   0xF4000000
///                            ###
///                            * Base address for Sunol flash
///                            * 32 MB
///                            * 100M AHB
///                            ###
///               : SUNOL_FLASH_SIZE   0x2000000
///                            ###
///                            * Size of Sunol flash
///                            * 32 MB
///                            ###
///               : SUNOL_FLASH_DEC_BIT 0x19
///                            ###
///                            * 32 MB has a 25 bits offset
///                            ###
///               : SLOW_REG_BASE      0xF6000000
///                            ###
///                            * 100MHz AHB
///                            * all on-chip devices not listed in “Fast Register” section, minimal 64k Byte space for each
///                            * The base address will equal with the last slow register section base
///                            * The slow register base address is descent from 0xF8000000.
///                            * 0x36 * 64 KB
///                            * Memory map for V2G
///                            ###
///               : V2G_REG_BASE       0xF7800000
///                            ###
///                            * Base address of V2G Registers
///                            * 1MB
///                            * Size of V2G registers
///                            ###
///               : V2G_REG_SIZE       0x100000
///                            ###
///                            * Size of V2G Registers
///                            * Address decoding bit
///                            ###
///               : V2G_REG_DEC_BIT    0x14
///                            ###
///                            * 1MB has 20-bit offset
///                            * Memory map for AVIF Global inside AVIF subsystem
///                            ###
///               : AVIF_GBL_REG_BASE  0xF7950000
///                            ###
///                            * Base address of AVIF_GBL Registers
///                            * 64KB
///                            * Size of AVIF_GBL registers
///                            ###
///               : AVIF_GBL_REG_SIZE  0x10000
///                            ###
///                            * Size of AVIF_GBL Registers
///                            * Address decoding bit
///                            ###
///               : AVIF_GBL_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for AHB Bus Activity Monitor inside SoC subsystem
///                            ###
///               : BUSMON_REG_BASE    0xF7960000
///                            ###
///                            * Base address of BUSMON Registers
///                            * 64KB
///                            * Size of BUSMON registers
///                            ###
///               : BUSMON_REG_SIZE    0x10000
///                            ###
///                            * Size of BUSMON Registers
///                            * Address decoding bit
///                            ###
///               : BUSMON_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for Smart Card Controller1 inside perif subsystem
///                            ###
///               : USIM1_REG_BASE     0xF7970000
///                            ###
///                            * Base address of USIM1 Registers
///                            * 64KB
///                            * Size of USIM1 registers
///                            ###
///               : USIM1_REG_SIZE     0x10000
///                            ###
///                            * Size of USIM1 Registers
///                            * Address decoding bit
///                            ###
///               : USIM1_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for AVIF subsystem
///                            ###
///               : AVIF_REG_BASE      0xF7980000
///                            ###
///                            * Base address of AVIF Registers
///                            * 512KB
///                            * Size of AVIF registers
///                            ###
///               : AVIF_REG_SIZE      0x80000
///                            ###
///                            * Size of AVIF Registers
///                            * Address decoding bit
///                            ###
///               : AVIF_REG_DEC_BIT   0x13
///                            ###
///                            * 512KB has 19-bit offset
///                            * Memory map for Smart Card Controller0 inside perif subsystem
///                            ###
///               : USIM0_REG_BASE     0xF7A00000
///                            ###
///                            * Base address of USIM0 Registers
///                            * 64KB
///                            * Size of USIM0 registers
///                            ###
///               : USIM0_REG_SIZE     0x10000
///                            ###
///                            * Size of USIM0 Registers
///                            * Address decoding bit
///                            ###
///               : USIM0_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for CI Controller inside perif subsystem
///                            ###
///               : CIC_REG_BASE       0xF7A10000
///                            ###
///                            * Base address of CIC Registers
///                            * 64KB
///                            * Size of CIC registers
///                            ###
///               : CIC_REG_SIZE       0x10000
///                            ###
///                            * Size of CIC Registers
///                            * Address decoding bit
///                            ###
///               : CIC_REG_DEC_BIT    0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for USB3 inside perif subsystem
///                            ###
///               : USB3_REG_BASE      0xF7A20000
///                            ###
///                            * Base address of USB3 Registers
///                            * 64KB
///                            * Size of USB3 registers
///                            ###
///               : USB3_REG_SIZE      0x10000
///                            ###
///                            * Size of USB3 Registers
///                            * Address decoding bit
///                            ###
///               : USB3_REG_DEC_BIT   0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for USB2 inside perif subsystem
///                            ###
///               : USB2_REG_BASE      0xF7A30000
///                            ###
///                            * Base address of USB2 Registers
///                            * 64KB
///                            * Size of USB2 registers
///                            ###
///               : USB2_REG_SIZE      0x10000
///                            ###
///                            * Size of USB2 Registers
///                            * Address decoding bit
///                            ###
///               : USB2_REG_DEC_BIT   0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for TSP inside perif subsystem
///                            ###
///               : TSP_REG_BASE       0xF7A40000
///                            ###
///                            * Base address of TSP Registers
///                            * 256KB
///                            * Size of TSP registers
///                            ###
///               : TSP_REG_SIZE       0x40000
///                            ###
///                            * Size of TSP Registers
///                            * Address decoding bit
///                            ###
///               : TSP_REG_DEC_BIT    0x12
///                            ###
///                            * 256KB has 18-bit offset
///                            * Memory map for SDIO3 inside perif subsystem
///                            ###
///               : SDIO3_REG_BASE     0xF7AB0000
///                            ###
///                            * Base address of SDIO3 Registers
///                            * 64KB
///                            * Size of SDIO3 registers
///                            ###
///               : SDIO3_REG_SIZE     0x10000
///                            ###
///                            * Size of SDIO3 Registers
///                            * Address decoding bit
///                            ###
///               : SDIO3_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for SL2C (System L2 Cache) registers inside PJ4B-MP sub-system
///                            ###
///               : CPU_SL2C_REG_BASE  0xF7AC0000
///                            ###
///                            * Base address of CPU_SL2C Registers
///                            * 64KB
///                            * Size of CPU_SL2C memory mapping
///                            ###
///               : CPU_SL2C_REG_SIZE  0x10000
///                            ###
///                            * Size of CPU_PMR Registers
///                            * Address decoding bit
///                            ###
///               : CPU_SL2C_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for PMR inside PJ4B-MP sub-system
///                            ###
///               : CPU_PMR_REG_BASE   0xF7AD0000
///                            ###
///                            * Base address of CPU_PMR Registers
///                            * 64KB
///                            * Size of CPU_PMR memory mapping
///                            ###
///               : CPU_PMR_REG_SIZE   0x10000
///                            ###
///                            * Size of CPU_PMR Registers
///                            * Address decodin bit
///                            ###
///               : CPU_PMR_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for Video Input Port Data Streaming Hub
///                            ###
///               : VIP_DHUB_REG_BASE  0xF7AE0000
///                            ###
///                            * Base address of VIP DHUB control Registers
///                            * 128KB
///                            * Size of VIP DHUB register memory mapping
///                            ###
///               : VIP_DHUB_REG_SIZE  0x20000
///                            ###
///                            * Size of VIP DHUB control Registers
///                            * Address decodin bit
///                            ###
///               : VIP_DHUB_REG_DEC_BIT 0x11
///                            ###
///                            * 128KB has 17-bit offset
///                            * Memory map for CORESIGHT registers
///                            ###
///               : CORESIGHT_REG_BASE 0xF7B00000
///                            ###
///                            * Base address of CS registers
///                            * 256KB
///                            * Size of CORESIGHT registers
///                            ###
///               : CORESIGHT_REG_SIZE 0x40000
///                            ###
///                            * Size of CS Registers
///                            * Address decodin bit
///                            ###
///               : CORESIGHT_REG_DEC_BIT 0x12
///                            ###
///                            * 256KB has 18-bit offset
///                            ###
///               : MTEST_REG_BASE     0xF7B40000
///                            ###
///                            * Base address for MTEST Registers
///                            * 64KB
///                            ###
///               : MTEST_REG_SIZE     0x10000
///                            ###
///                            * Size of MTEST Registers
///                            ###
///               : MTEST_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : AVIO_BCM_REG_BASE  0xF7B50000
///                            ###
///                            * Base address for AVIO BCM Registers
///                            * 64KB
///                            ###
///               : AVIO_BCM_REG_SIZE  0x10000
///                            ###
///                            * Size of AVIO BCM Registers
///                            ###
///               : AVIO_BCM_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for Gigabit Ethernet Controller
///                            ###
///               : GE_REG_BASE        0xF7B60000
///                            ###
///                            * Base address for Gigabit Ethernet Controller Registers
///                            * 64KB
///                            * Size of Gigabit Ethernet Controller Registers
///                            ###
///               : GE_REG_SIZE        0x10000
///                            ###
///                            * Size of Gigabit Ethernet Controller Registers
///                            * Address decoding bit
///                            ###
///               : GE_REG_DEC_BIT     0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            * Memory map for PHYPERIF
///                            ###
///               : PHYPERIF_REG_BASE  0xF7B70000
///                            ###
///                            * Base address for PHY Peripheral Registers
///                            * 64KB
///                            ###
///               : PHYPERIF_REG_SIZE  0x10000
///                            ###
///                            * Size of PHY Peripheral Registers
///                            ###
///               : PHYPERIF_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : SDIO1_REG_BASE     0xF7B80000
///                            ###
///                            * Base address for SDIO1 Registers
///                            * 64KB
///                            ###
///               : SDIO1_REG_SIZE     0x10000
///                            ###
///                            * Size of SDIO1 Registers
///                            ###
///               : SDIO1_REG_DEC_BIT  0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : ETHERNET1_REG_BASE 0xF7B90000
///                            ###
///                            * Base address for ETHERNET1 Registers
///                            * 64KB
///                            ###
///               : ETHERNET1_REG_SIZE 0x10000
///                            ###
///                            * Size of ETHERNET1 Registers
///                            ###
///               : ETHERNET1_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : PTP1_REG_BASE      0xF7BA0000
///                            ###
///                            * Base address for PTP1 Registers
///                            * 64KB
///                            ###
///               : PTP1_REG_SIZE      0x10000
///                            ###
///                            * Size of PTP1 Registers
///                            ###
///               : PTP1_REG_DEC_BIT   0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : AVIO_DH3_DHUB_REG_BASE 0xF7BB0000
///                            ###
///                            * Base address for AVIO Reserve0 Registers
///                            * 64KB
///                            ###
///               : AVIO_DH3_DHUB_REG_SIZE 0x10000
///                            ###
///                            * Size of AVIO Reserve0 Registers
///                            ###
///               : AVIO_DH3_DHUB_REG_DEC_BIT 0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : GFX3D_REG_BASE     0xF7BC0000
///                            ###
///                            * Base address for GFx3D Registers
///                            * 256KB
///                            ###
///               : GFX3D_REG_SIZE     0x40000
///                            ###
///                            * Size of GFX3D Registers
///                            ###
///               : GFX3D_REG_DEC_BIT  0x12
///                            ###
///                            * 256KB has 18-bit offset
///                            ###
///               : ZSP_REG_BASE       0xF7C00000
///                            ###
///                            * Base address for ZSP Registers
///                            * 512KB
///                            ###
///               : ZSP_REG_SIZE       0x80000
///                            ###
///                            * Size of ZSP register memory mapping
///                            ###
///               : ZSP_REG_DEC_BIT    0x13
///                            ###
///                            * 512KB has 19-bit offset
///                            ###
///               : VPP_4K_REG_BASE    0xF7C80000
///                            ###
///                            * Base address for VPP 4K Registers
///                            * 128KB
///                            ###
///               : VPP_4K_REG_SIZE    0x20000
///                            ###
///                            * Size of VPP 4K register memory mapping
///                            ###
///               : VPP_4K_REG_DEC_BIT 0x11
///                            ###
///                            * 128 KB has 17-bit offset
///                            ###
///               : SOC_REG_BASE       0xF7CA0000
///                            ###
///                            * Base address for SOC registers
///                            * 64KB
///                            ###
///               : SOC_REG_SIZE       0x10000
///                            ###
///                            * Size of SOC register memory mapping
///                            ###
///               : SOC_REG_DEC_BIT    0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : DDR_REG_BASE       0xF7CB0000
///                            ###
///                            * Base address for DDR registers
///                            * 64KB
///                            ###
///               : DDR_REG_SIZE       0x10000
///                            ###
///                            * Size of DDR registers memory mapping
///                            ###
///               : DDR_REG_DEC_BIT    0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : TSI_REG_BASE       0xF7CC0000
///                            ###
///                            * Base address of TSI register region
///                            * 256KB
///                            ###
///               : TSI_REG_SIZE       0x40000
///                            ###
///                            * Size of TSI register region
///                            ###
///               : TSI_REG_DEC_BIT    0x12
///                            ###
///                            * 256KB has 18-bit offset
///                            ###
///               : AG_DHUB_REG_BASE   0xF7D00000
///                            ###
///                            * Base address of AG DHUB control Registers
///                            * 128 KB
///                            ###
///               : AG_DHUB_REG_SIZE   0x20000
///                            ###
///                            * Size of AG DHUB Registers memory mapping
///                            ###
///               : AG_DHUB_REG_DEC_BIT 0x11
///                            ###
///                            * 128 KB has a 17 bits offset
///                            ###
///               : APP_REG_BASE       0xF7D30000
///                            ###
///                            * Base address for APP registers
///                            * 64KB
///                            ###
///               : APP_REG_SIZE       0x10000
///                            ###
///                            * size of APP register space
///                            ###
///               : APP_REG_DEC_BIT    0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : SPU_REG_BASE       0xF7D40000
///                            ###
///                            * Base address for RLE decoder hardware accelerator Registers
///                            * 64KB
///                            ###
///               : SPU_REG_SIZE       0x10000
///                            ###
///                            * Size of SPU register space
///                            ###
///               : SPU_REG_DEC_BIT    0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : SDIO_REG_BASE      0xF7D50000
///                            ###
///                            * Base address for SDIO Registers
///                            * 64KB
///                            ###
///               : SDIO_REG_SIZE      0x10000
///                            ###
///                            * Size of SDIO register space
///                            ###
///               : SDIO_REG_DEC_BIT   0x10
///                            ###
///                            * 64KB has 16-bit offset
///                            ###
///               : PTP_REG_BASE       0xF7D60000
///                            ###
///                            * Base address for PTP Registers
///                            * 64 KB
///                            ###
///               : PTP_REG_SIZE       0x10000
///                            ###
///                            * Size of PTP registers memory mapping
///                            ###
///               : PTP_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : PB_REG_BASE        0xF7D70000
///                            ###
///                            * Base address for PBridge registers
///                            * 64KB
///                            ###
///               : PB_REG_SIZE        0x10000
///                            ###
///                            * Size of PBridge Registers
///                            ###
///               : PB_REG_DEC_BIT     0x10
///                            ###
///                            * 64KB has a 16bits offset
///                            ###
///               : SX_REG_BASE        0xF7D80000
///                            ###
///                            * Base address for SxBar registers
///                            * 64KB
///                            ###
///               : SX_REG_SIZE        0x10000
///                            ###
///                            * Size of SxBar Registers
///                            ###
///               : SX_REG_DEC_BIT     0x10
///                            ###
///                            * 64KB has a 16 bits offset
///                            ###
///               : MX_REG_BASE        0xF7D90000
///                            ###
///                            * Base address for Mxbar registers
///                            * 64KB
///                            ###
///               : MX_REG_SIZE        0x10000
///                            ###
///                            * Size of MxBar Registers
///                            ###
///               : MX_REG_DEC_BIT     0x10
///                            ###
///                            * 64KB has a 16 bits offset
///                            ###
///               : NX_REG_BASE        0xF7DA0000
///                            ###
///                            * Base address for NxBar registers
///                            * 64 KB
///                            ###
///               : NX_REG_SIZE        0x10000
///                            ###
///                            * Size of NxBar Registers
///                            ###
///               : NX_REG_DEC_BIT     0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : VOP_PG_REG_BASE    0xF7DB0000
///                            ###
///                            * Base address for VOP Programmer Registers
///                            * 64 KB
///                            ###
///               : VOP_PG_REG_SIZE    0x10000
///                            ###
///                            * Size of VOP Programmer Registers memory mapping
///                            ###
///               : VOP_PG_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : CMD_PACK_REG_BASE  0xF7DC0000
///                            ###
///                            * Base address for Command Pack Registers
///                            * 64 KB
///                            ###
///               : CMD_PACK_REG_SIZE  0x10000
///                            ###
///                            * Size of Command Pack Registers memory mapping
///                            ###
///               : CMD_PACK_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : CPUSS_REG_BASE     0xF7DD0000
///                            ###
///                            * Base address for CPU_SS Registers
///                            * 64 KB
///                            ###
///               : CPUSS_REG_SIZE     0x10000
///                            ###
///                            * Size of CPU_SS Registers memory mapping
///                            ###
///               : CPUSS_REG_DEC_BIT  0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : VOP_VIDEO_REG_BASE 0xF7DE0000
///                            ###
///                            * Base address for VOP Main Video Registers
///                            * 64 KB
///                            ###
///               : VOP_VIDEO_REG_SIZE 0x10000
///                            ###
///                            * Size of VOP Main Video Registers memory mapping
///                            ###
///               : VOP_VIDEO_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : VOP_PIP_REG_BASE   0xF7DF0000
///                            ###
///                            * Base address for VOP Picture in Picture Registers
///                            * 64 KB
///                            ###
///               : VOP_PIP_REG_SIZE   0x10000
///                            ###
///                            * Size of VOP PIP Registers memory mapping
///                            ###
///               : VOP_PIP_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : VOP_OSD_REG_BASE   0xF7E00000
///                            ###
///                            * Base address for VOP On Screen Display Registers
///                            * 64 KB
///                            ###
///               : VOP_OSD_REG_SIZE   0x10000
///                            ###
///                            * Size of VOP OSD Registers memory mapping
///                            ###
///               : VOP_OSD_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : AVIO_RESR2_BASE    0xF7E10000
///                            ###
///                            * Base address for AVIO Reserve2 Registers
///                            * 64 KB
///                            ###
///               : AVIO_RESR2_SIZE    0x10000
///                            ###
///                            * Size of AVIO Reserve2 Registers
///                            ###
///               : AVIO_RESR2_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16-bit offset
///                            ###
///               : AVIO_GBL_BASE      0xF7E20000
///                            ###
///                            * Base address for AVIO Global Registers
///                            * 64 KB
///                            ###
///               : AVIO_GBL_SIZE      0x10000
///                            ###
///                            * Size of AVIO Global Registers
///                            ###
///               : AVIO_GBL_DEC_BIT   0x10
///                            ###
///                            * 64 KB has a 16-bit offset
///                            ###
///               : PCI_REG_BASE       0xF7E30000
///                            ###
///                            * Base address for PCI Registers
///                            * 64 KB
///                            ###
///               : PCI_REG_SIZE       0x10000
///                            ###
///                            * Size of PCI Registers memory mapping
///                            ###
///               : PCI_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : PCIE_REG_BASE      0xF7E40000
///                            ###
///                            * Base address for PCI-Express Registers
///                            * 64 KB
///                            ###
///               : PCIE_REG_SIZE      0x10000
///                            ###
///                            * Size of PCI-Express Registers memory mapping
///                            ###
///               : PCIE_REG_DEC_BIT   0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : ETHERNET_REG_BASE  0xF7E50000
///                            ###
///                            * Base address for Ethernet Registers
///                            * 64 KB
///                            ###
///               : ETHERNET_REG_SIZE  0x10000
///                            ###
///                            * Size of Ethernet Registers memory mapping
///                            ###
///               : ETHERNET_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : SPDIF_REG_BASE     0xF7E60000
///                            ###
///                            * Base address for SPDIF Registers
///                            * 64 KB
///                            ###
///               : SPDIF_REG_SIZE     0x10000
///                            ###
///                            * Size of SPDIF Registers memory mapping
///                            ###
///               : SPDIF_REG_DEC_BIT  0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : I2S_REG_BASE       0xF7E70000
///                            ###
///                            * Base address for I2S Registers
///                            * 64 KB
///                            ###
///               : I2S_REG_SIZE       0x10000
///                            ###
///                            * Size of I2S Registers memory mapping
///                            ###
///               : I2S_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : APBPERIF_REG_BASE  0xF7E80000
///                            ###
///                            * Base address for ApbPerif Registers
///                            * ApbPerif is designed to integrate all the low speed I/O functionalities.
///                            * It provides an AHB interface for processor to access the low speed I/O devices and memory-mapped SPI Flash device. It also have a OCP master interface for external Host to access chip internal address through I2C interface
///                            * I2C master/slave; SPI master; UART controller; GPIO; Timer; Watchdog timer; Interrupt controller
///                            * 64 KB
///                            ###
///               : APBPERIF_REG_SIZE  0x10000
///                            ###
///                            * Size of ApbPerif Registers memory mapping
///                            ###
///               : APBPERIF_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : SATA_REG_BASE      0xF7E90000
///                            ###
///                            * Base address for SATA Registers
///                            * 64 KB
///                            ###
///               : SATA_REG_SIZE      0x10000
///                            ###
///                            * Size of SATA Registers memory mapping
///                            ###
///               : SATA_REG_DEC_BIT   0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : CHIP_CTRL_REG_BASE 0xF7EA0000
///                            ###
///                            * Chip Control (Processor Reset, Bootstrap, ...)
///                            * 64 KB
///                            ###
///               : CHIP_CTRL_REG_SIZE 0x10000
///                            ###
///                            * Size of CHIP ID Registers memory mapping
///                            ###
///               : CHIP_CTRL_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : MPP_REG_BASE       0xF7EB0000
///                            ###
///                            * Base address for MPP
///                            * 64 KB
///                            ###
///               : MPP_REG_SIZE       0x10000
///                            ###
///                            * Size of MPP Registers memory mapping
///                            ###
///               : MPP_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : AVIO_SEMAPHORE_REG_BASE 0xF7EC0000
///                            ###
///                            * Base address of AVIO semaphore control Registers
///                            * 64 KB
///                            ###
///               : AVIO_SEMAPHORE_REG_SIZE 0x10000
///                            ###
///                            * Size of AVIO semaphore Registers memory mapping
///                            ###
///               : AVIO_SEMAPHORE_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : USB0_REG_BASE      0xF7ED0000
///                            ###
///                            * Base address of USB 0 control Registers
///                            * 64 KB
///                            ###
///               : USB0_REG_SIZE      0x10000
///                            ###
///                            * Size of USB 0 Registers memory mapping
///                            ###
///               : USB0_REG_DEC_BIT   0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : USB1_REG_BASE      0xF7EE0000
///                            ###
///                            * Base address of USB 1 control Registers
///                            * 64 KB
///                            ###
///               : USB1_REG_SIZE      0x10000
///                            ###
///                            * Size of USB 1 Registers memory mapping
///                            ###
///               : USB1_REG_DEC_BIT   0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : GFX2D_REG_BASE     0xF7EF0000
///                            ###
///                            * Base address of 2D Graphics control Registers
///                            * 64 KB
///                            ###
///               : GFX2D_REG_SIZE     0x10000
///                            ###
///                            * Size of GFX 2D Registers memory mapping
///                            ###
///               : GFX2D_REG_DEC_BIT  0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : NAND_FLASH_REG_BASE 0xF7F00000
///                            ###
///                            * Base address of NAND flash control Registers
///                            * 64 KB
///                            ###
///               : NAND_FLASH_REG_SIZE 0x10000
///                            ###
///                            * Size of NAND flash Registers memory mapping
///                            ###
///               : NAND_FLASH_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : LBC_REG_BASE       0xF7F10000
///                            ###
///                            * Base address of Local Bus Controller Registers
///                            * 64 KB
///                            ###
///               : LBC_REG_SIZE       0x10000
///                            ###
///                            * Size of Local Bus Controller Registers memory mapping
///                            ###
///               : LBC_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : PWM_REG_BASE       0xF7F20000
///                            ###
///                            * Base address of Pulse Width Modulator control Registers
///                            * 64 KB
///                            ###
///               : PWM_REG_SIZE       0x10000
///                            ###
///                            * Size of Pulse Width Modulator Registers memory mapping
///                            ###
///               : PWM_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : VPP_REG_BASE       0xF7F60000
///                            ###
///                            * Base address of Video Post Process control Registers
///                            * 64 KB
///                            ###
///               : VPP_REG_SIZE       0x20000
///                            ###
///                            * Size of Video Post Process Registers memory mapping
///                            ###
///               : VPP_REG_DEC_BIT    0x11
///                            ###
///                            * 128 KB has a 16 bits offset
///                            ###
///               : DMA_AVIO_REG_BASE  0xF7F40000
///                            ###
///                            * Base address of DMA AVIO control Registers (overlay with VPP DHUB)
///                            * 64 KB
///                            ###
///               : DMA_AVIO_REG_SIZE  0x10000
///                            ###
///                            * Size of DMA AVIO Registers memory mapping
///                            ###
///               : DMA_AVIO_REG_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset and overlay with VPP DHUB
///                            ###
///               : VPP_DHUB_REG_BASE  0xF7F40000
///                            ###
///                            * Base address of VPP DHUB control Registers
///                            * 64 KB
///                            ###
///               : VPP_DHUB_REG_SIZE  0x20000
///                            ###
///                            * Size of VPP DHUB Registers memory mapping
///                            ###
///               : VPP_DHUB_REG_DEC_BIT 0x11
///                            ###
///                            * 128 KB has a 16 bits offset
///                            ###
///               : SM_REG_BASE        0xF7F80000
///                            ###
///                            * Base address of SM registers
///                            * 512 K Byte
///                            ###
///               : SM_REG_SIZE        0x80000
///                            ###
///                            * Size of SM memory mapping
///                            ###
///               : SM_REG_DEC_BIT     0x13
///                            ###
///                            * 512 KB has a 19 bits offset
///                            ###
///               : FAST_REG_BASE      0xF8000000
///                            ###
///                            * Starting address for all memory mapping of fast register
///                            * 64MB ~ 512KB
///                            * 400 AHB (Local Bus)
///                            ###
///               : VPRO_REG_BASE      0xF8000000
///                            ###
///                            * Starting address for vPro sub system
///                            * 4MB
///                            * Including VSCPE, PCUBE, VPOR_MISC, VPRO_SEMAPHORE, DMA_PIX_PRO, VCACHE
///                            ###
///               : VPRO_REG_SIZE      0x400000
///                            ###
///                            * Size of vPro Registers memory mapping
///                            * 4MB
///                            ###
///               : VPRO_REG_DEC_BIT   0x16
///                            ###
///                            * 4MB has a 22 bits offset
///                            * VSCOPE_REG_BASE
///                            * 0xF8000000
///                            * Size is 1 MB, address must be alignment at 1 MB boundary
///                            * 1 MB
///                            * VSCOPE_REG_SIZE
///                            * 0x00100000
///                            * Size of VSCOPE Registers memory mapping
///                            * VSCOPE_REG_DEC_BIT
///                            * 20
///                            * 1 MB has a 20 bits offset
///                            * PCUBE_REG_BASE
///                            * 0xF8100000
///                            * Size is 1MB, address must be alignment at 1 MB boundary
///                            * 1 MB
///                            * PCUBE_REG_SIZE
///                            * 0x00100000
///                            * Size of PCUBE Registers memory mapping
///                            * PCUBE_REG_DEC_BIT
///                            * 20
///                            * 1 MB has 20 bits offset
///                            * VPRO_MISC_REG_BASE
///                            * 0xF8200000
///                            * Base address of vPro misc Registers
///                            * 256KB
///                            * VPRO_MISC_REG_SIZE
///                            * 0x00040000
///                            * Size of vPro misc Registers memory mapping
///                            * VPRO_MISC_REG_DEC_BIT
///                            * 18
///                            * 256 KB has a 18 bits offset
///                            * DMA_PIX_PRO_REG_BASE
///                            * 0xF8240000
///                            * Base address of Pixel Processing DMA Registers
///                            * 64 KB
///                            * DMA_PIX_PRO_REG_SIZE
///                            * 0x00010000
///                            * Size of Pixel Processing DMA Registers memory mapping
///                            * DMA_PIX_PRO_REG_DEC_BIT
///                            * 16
///                            * 64 KB has a 16 bits offset
///                            * VCACHE_REG_BASE
///                            * 0xF8250000
///                            * Base address for vCache Registers
///                            * 64 KB
///                            * VCACHE_REG_SIZE
///                            * 0x00010000
///                            * Size of vCache Registers memory mapping
///                            * VCACHE_REG_DEC_BIT
///                            * 16
///                            * 64 KB has a 16 bits offset
///                            * VPRO_SEMAPHORE_REG_BASE
///                            * 0xF8260000
///                            * Base address for Video Processing Semaphore Registers
///                            * 64 KB
///                            * VPRO_SEMAPHORE_REG_SIZE
///                            * 0x00010000
///                            * Size of Video Processing Semaphore Registers memory mapping
///                            * VPRO_SEMAPHORE_DEC_BIT
///                            * 16
///                            * 64 KB has a 16 bits offsetMV_PE_OUTPUT_VIDEO_PRIM
///                            ###
///               : UFAHB_REG_BASE     0xF8400000
///                            ###
///                            * Base address of ultra-fast AHB Registers
///                            * 128 KB
///                            ###
///               : UFAHB_REG_SIZE     0x20000
///                            ###
///                            * Size of ultra-fast AHB Registers memory mapping
///                            ###
///               : UFAHB_REG_DEC_BIT  0x11
///                            ###
///                            * 128 KB has a 17 bits offset
///                            ###
///               : PIC_REG_BASE       0xF8420000
///                            ###
///                            * Base address of PIC Registers
///                            * 64 KB
///                            ###
///               : PIC_REG_SIZE       0x10000
///                            ###
///                            * Size of PIC Registers memory mapping
///                            ###
///               : PIC_REG_DEC_BIT    0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : PROCESSOR_ID_REG_BASE 0xF8430000
///                            ###
///                            * CPU_ID indicates the current CPU is CPU0/1/2
///                            * REVERSION_ID indicates the version of the layout
///                            * In order to reduce the address parsing, just put it at 64 KB boundary
///                            * 32 bytes
///                            ###
///               : PROCESSOR_ID_REG_SIZE 0x20
///                            ###
///                            * Size of Processor ID Registers (8 x 4 bytes)
///                            ###
///               : PROCESSOR_ID_REG_DEC_BIT 0x5
///                            ###
///                            * 32 bytes has a 5 bits offset
///                            ###
///               : ONCHIP_LOW_ROM_BASE 0xFF800000
///                            ###
///                            * Reserved for on-chip ROM. Left blank for TC1
///                            * 512 KB - 64 KB
///                            ###
///               : ONCHIP_LOW_ROM_SIZE 0x10000
///                            ###
///                            * Size of On-chip's low address ROM
///                            * 64 KB ((8192 + 8128) * 32bits)
///                            ###
///               : ONCHIP_LOW_ROM_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : HIGH_ROM_VECTOR_BASE 0xFFFF0000
///                            ###
///                            * VECTORS = 0xFFFF-0000 ~ 0xFFFF-BFFF
///                            * HIGH ADDRESS ROM = 0xFFFF-C000 ~ 0xFFFF-FFFF
///                            ###
///               : HIGH_ROM_VECTOR_SIZE 0x10000
///                            ###
///                            * VECTOR has 48 KB; High address ROM has 16 KB
///                            * 64 KB
///                            ###
///               : HIGH_ROM_VECTOR_DEC_BIT 0x10
///                            ###
///                            * 64 KB has a 16 bits offset
///                            ###
///               : VECTOR_BASE        0xFFFF0000
///                            ###
///                            * Interrupt Vectors Register base
///                            * 32 bytes
///                            * 8 vectors, with 0xFFFF0000 pointing to
///                            * --- external flash on power up for TC1 or
///                            * --- internal ROM some where Depending on strap pin
///                            ###
///               : VECTOR_SIZE        0x20
///                            ###
///                            * Size of Interrupt Vectors Registers
///                            ###
///               : VECTOR_DEC_BIT     0x5
///                            ###
///                            * 32 bytes has a 5 bits offset
///                            ###
///               : HIGH_EXCEPT_RESET_REG 0xFFFF0000
///                            ###
///                            * The first instruction address after reseting
///                            * Readable/Writable for both software and hardware
///                            * Default value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Default value is loading the content of 0xFFFF0020 as the PC address
///                            ###
///               : HIGH_EXCEPT_UNDEF_REG 0xFFFF0004
///                            ###
///                            * The first instruction address for undefined instruction exception
///                            * Readable/Writable for both software and hardware
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Fix value is loading the content of 0xFFFF0024 as the PC address
///                            ###
///               : HIGH_EXCEPT_SOFT_REG 0xFFFF0008
///                            ###
///                            * The first instruction address for software interrupt exception
///                            * Readable/Writable for both software and hardware
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Fix value is loading the content of 0xFFFF0028 as the PC address
///                            ###
///               : HIGH_EXCEPT_PREFETCH_REG 0xFFFF000C
///                            ###
///                            * The first instruction address for instruction fetch memory abort
///                            * Readable/Writable for both software and hardware
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Fix value is loading the content of 0xFFFF002C as the PC address
///                            ###
///               : HIGH_EXCEPT_DATA_REG 0xFFFF0010
///                            ###
///                            * The first instruction address for data access memory abort
///                            * Readable/Writable for both software and hardware
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Fix value is loading the content of 0xFFFF0030 as the PC address
///                            ###
///               : HIGH_EXCEPT_UNUSED_REG 0xFFFF0014
///                            ###
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            ###
///               : HIGH_EXCEPT_IRQ_REG 0xFFFF0018
///                            ###
///                            * The address for IRQ service routine entry
///                            * Readable/Writable for both software and hardware
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Fix value is loading the content of 0xFFFF0038 as the PC address
///                            * ISR will be universal ISR for all CPUs.
///                            ###
///               : HIGH_EXCEPT_FIQ_REG 0xFFFF001C
///                            ###
///                            * The address for FIQ service routine entry
///                            * Readable/Writable for both software and hardware
///                            * Fix value is 0xe59ff018 {LDR pc, [pc + #0x20 - #8]}
///                            * Fix value is loading the content of 0xFFFF003C as the PC address
///                            * FIQ service routine will be universal entry for all CPU's FIQ
///                            ###
///               : ADDR_DATA_REG_BASE 0xFFFF0020
///                            ###
///                            * Addr_data_?_? Table base address
///                            * 128 bytes – 3 x 8 registers – 3x8x4=96
///                            ###
///               : ADDR_DATA_REG_SIZE 0x80
///                            ###
///                            * Size of Addr_data_?_? Table
///                            ###
///               : VECTOR_ADDR_0_REG  0xFFFF0020
///                            ###
///                            * Vector address register for reset
///                            * Software read ONLY/ hardware readable/writable
///                            * Default value is 0xFFFFC000 (booting from DRAM)
///                            * 0xFFFFC240 booting from ROM / 0xFFFFC200 booting from others
///                            ###
///               : VECTOR_ADDR_1_REG  0xFFFF0024
///                            ###
///                            * Vector address register for undefined instruction
///                            * Software and hardware readable and writable
///                            ###
///               : VECTOR_ADDR_2_REG  0xFFFF0028
///                            ###
///                            * Vector address register for software interrupt
///                            * Software and hardware readable and writable
///                            ###
///               : VECTOR_ADDR_3_REG  0xFFFF002C
///                            ###
///                            * Vector address register for prefetch abort
///                            * Software and hardware readable and writable
///                            ###
///               : VECTOR_ADDR_4_REG  0xFFFF0030
///                            ###
///                            * Vector address register for Data Abort
///                            * Software and hardware readable and writable
///                            ###
///               : VECTOR_ADDR_5_REG  0xFFFF0034
///                            ###
///                            * Not used
///                            ###
///               : VECTOR_ADDR_6_REG  0xFFFF0038
///                            ###
///                            * Vector address register for universal IRQ service routine entry
///                            * Software and hardware readable and writable
///                            ###
///               : VECTOR_ADDR_7_REG  0xFFFF003C
///                            ###
///                            * Vector address register for universal FIQ service routine entry
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_1_0_REG  0xFFFF0040
///                            ###
///                            * Undefined Instruction Exception Handler entry address for CPU #0
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_1_1_REG  0xFFFF0044
///                            ###
///                            * Undefined Instruction Exception Handler entry address for CPU #1
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_1_2_REG  0xFFFF0048
///                            ###
///                            * Undefined Instruction Exception Handler entry address for CPU #2
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_2_0_REG  0xFFFF004C
///                            ###
///                            * Software Interrupt Exception Handler entry address for CPU #0
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_2_1_REG  0xFFFF0050
///                            ###
///                            * Software Interrupt Exception Handler entry address for CPU #1
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_2_2_REG  0xFFFF0054
///                            ###
///                            * Software Interrupt Exception Handler entry address for CPU #2
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_3_0_REG  0xFFFF0058
///                            ###
///                            * Instruction Prefetch Abort Exception Handler entry address for CPU #0
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_3_1_REG  0xFFFF005C
///                            ###
///                            * Instruction Prefetch Abort Exception Handler entry address for CPU #1
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_3_2_REG  0xFFFF0060
///                            ###
///                            * Instruction Prefetch Abort Exception Handler entry address for CPU #2
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_4_0_REG  0xFFFF0064
///                            ###
///                            * Data Abort Exception Handler entry address for CPU #0
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_4_1_REG  0xFFFF0068
///                            ###
///                            * Data Abort Exception Handler entry address for CPU #1
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_4_2_REG  0xFFFF006C
///                            ###
///                            * Data Abort Exception Handler entry address for CPU #2
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_5_0_REG  0xFFFF0070
///                            ###
///                            * Not used
///                            ###
///               : BRCH_ADDR_5_1_REG  0xFFFF0074
///                            ###
///                            * Not used
///                            ###
///               : BRCH_ADDR_5_2_REG  0xFFFF0078
///                            ###
///                            * Not used
///                            ###
///               : BRCH_ADDR_6_0_REG  0xFFFF007C
///                            ###
///                            * IRQ service routine entry address for CPU #0
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_6_1_REG  0xFFFF0080
///                            ###
///                            * IRQ service routine entry address for CPU #1
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_6_2_REG  0xFFFF0084
///                            ###
///                            * IRQ service routine entry address for CPU #2
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_7_0_REG  0xFFFF0088
///                            ###
///                            * FIQ service routine entry address for CPU #0
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_7_1_REG  0xFFFF008C
///                            ###
///                            * FIQ service routine entry address for CPU #1
///                            * Software and hardware readable and writable
///                            ###
///               : BRCH_ADDR_7_2_REG  0xFFFF0090
///                            ###
///                            * FIQ service routine entry address for CPU #2
///                            * Software and hardware readable and writable
///                            ###
///               : SOFTWARE_RESET_ADDR_REG 0xFFFF0094
///                            ###
///                            * After software reset the special CPU or whole system,
///                            * The CPU(s) will fetch the value of this register as the address of
///                            * The first instruction.
///                            * To make it work, please change register HIGH_EXCEPT_RESET_REG
///                            * (0xFFFF-0000) with value 0xe59ff08C {LDR pc, [pc + #0x94 - #8]}
///                            ###
///               : ONCHIP_HIGH_ROM_BASE 0xFFFFC000
///                            ###
///                            * High address space ROM
///                            * 16KB
///                            ###
///               : ONCHIP_HIGH_ROM_SIZE 0x4000
///                            ###
///                            * Size of On-chip's high address ROM
///                            ###
///               : ONCHIP_HIGH_ROM_DEC_BIT 0xE
///                            ###
///                            * 16 KB has a 14 bits offset
///                            ###
///     @ 0x00000 memmap               (R-)
///               %signed   32 dummy                     0
///                                    ###
///                                    * Dummy word for automatically generates header file
///                                    ###
///     # # ----------------------------------------------------------
/// $ENDOFINTERFACE  # size:       4B, bits:      32b, padding:     0B
////////////////////////////////////////////////////////////
#ifndef h_MEMMAP
#define h_MEMMAP (){}

    #define        MEMMAP_DRAM_CACHE_BASE                      0x0
    #define        MEMMAP_DRAM_CACHE_SIZE                      0x40000000
    #define        MEMMAP_DRAM_CACHE_DEC_BIT                   0x1E
    #define        MEMMAP_DRAM_UNCACHE_BASE                    0x40000000
    #define        MEMMAP_DRAM_UNCACHE_SIZE                    0x40000000
    #define        MEMMAP_DRAM_UNCACHE_DEC_BIT                 0x1E
    #define        MEMMAP_DRAM_2GBTO3GB_BASE                   0x80000000
    #define        MEMMAP_DRAM_2GBTO3GB_SIZE                   0x40000000
    #define        MEMMAP_DRAM_2GBTO3GB_DEC_BIT                0x1E
    #define        MEMMAP_DRAM_3GBTO3P5GB_BASE                 0xC0000000
    #define        MEMMAP_DRAM_3GBTO3P5GB_SIZE                 0x20000000
    #define        MEMMAP_DRAM_3GBTO3P5GB_DEC_BIT              0x1D
    #define        MEMMAP_PCIE_UPSTREAM_BASE                   0xE0000000
    #define        MEMMAP_PCIE_UPSTREAM_SIZE                   0x10000000
    #define        MEMMAP_PCIE_UPSTREAM_DEC_BIT                0x1C
    #define        MEMMAP_DXBAR_REG_BASE                       0xA0000000
    #define        MEMMAP_DXBAR_REG_SIZE                       0x10000
    #define        MEMMAP_DXBAR_REG_DEC_BIT                    0x10
    #define        MEMMAP_PXBAR_REG_BASE                       0xA0010000
    #define        MEMMAP_PXBAR_REG_SIZE                       0x10000
    #define        MEMMAP_PXBAR_REG_DEC_BIT                    0x10
    #define        MEMMAP_CXBAR_REG_BASE                       0xA0020000
    #define        MEMMAP_CXBAR_REG_SIZE                       0x10000
    #define        MEMMAP_CXBAR_REG_DEC_BIT                    0x10
    #define        MEMMAP_RESERVED_BASE                        0xA0030000
    #define        MEMMAP_PCIE_DOWNSTREAM_BASE                 0xE0000000
    #define        MEMMAP_PCIE_DOWNSTREAM_SIZE                 0x10000000
    #define        MEMMAP_PCIE_DOWNSTREAM_DEC_BIT              0x1C
    #define        MEMMAP_SPI_FLASH_BASE                       0xF0000000
    #define        MEMMAP_SPI_FLASH_SIZE                       0x4000000
    #define        MEMMAP_SPI_FLASH_DEC_BIT                    0x1A
    #define        MEMMAP_SUNOL_FLASH_BASE                     0xF4000000
    #define        MEMMAP_SUNOL_FLASH_SIZE                     0x2000000
    #define        MEMMAP_SUNOL_FLASH_DEC_BIT                  0x19
    #define        MEMMAP_SLOW_REG_BASE                        0xF6000000
    #define        MEMMAP_V2G_REG_BASE                         0xF7800000
    #define        MEMMAP_V2G_REG_SIZE                         0x100000
    #define        MEMMAP_V2G_REG_DEC_BIT                      0x14
    #define        MEMMAP_AVIF_GBL_REG_BASE                    0xF7950000
    #define        MEMMAP_AVIF_GBL_REG_SIZE                    0x10000
    #define        MEMMAP_AVIF_GBL_REG_DEC_BIT                 0x10
    #define        MEMMAP_BUSMON_REG_BASE                      0xF7960000
    #define        MEMMAP_BUSMON_REG_SIZE                      0x10000
    #define        MEMMAP_BUSMON_REG_DEC_BIT                   0x10
    #define        MEMMAP_USIM1_REG_BASE                       0xF7970000
    #define        MEMMAP_USIM1_REG_SIZE                       0x10000
    #define        MEMMAP_USIM1_REG_DEC_BIT                    0x10
    #define        MEMMAP_AVIF_REG_BASE                        0xF7980000
    #define        MEMMAP_AVIF_REG_SIZE                        0x80000
    #define        MEMMAP_AVIF_REG_DEC_BIT                     0x13
    #define        MEMMAP_USIM0_REG_BASE                       0xF7A00000
    #define        MEMMAP_USIM0_REG_SIZE                       0x10000
    #define        MEMMAP_USIM0_REG_DEC_BIT                    0x10
    #define        MEMMAP_CIC_REG_BASE                         0xF7A10000
    #define        MEMMAP_CIC_REG_SIZE                         0x10000
    #define        MEMMAP_CIC_REG_DEC_BIT                      0x10
    #define        MEMMAP_USB3_REG_BASE                        0xF7A20000
    #define        MEMMAP_USB3_REG_SIZE                        0x10000
    #define        MEMMAP_USB3_REG_DEC_BIT                     0x10
    #define        MEMMAP_USB2_REG_BASE                        0xF7A30000
    #define        MEMMAP_USB2_REG_SIZE                        0x10000
    #define        MEMMAP_USB2_REG_DEC_BIT                     0x10
    #define        MEMMAP_TSP_REG_BASE                         0xF7A40000
    #define        MEMMAP_TSP_REG_SIZE                         0x40000
    #define        MEMMAP_TSP_REG_DEC_BIT                      0x12
    #define        MEMMAP_SDIO3_REG_BASE                       0xF7AB0000
    #define        MEMMAP_SDIO3_REG_SIZE                       0x10000
    #define        MEMMAP_SDIO3_REG_DEC_BIT                    0x10
    #define        MEMMAP_CPU_SL2C_REG_BASE                    0xF7AC0000
    #define        MEMMAP_CPU_SL2C_REG_SIZE                    0x10000
    #define        MEMMAP_CPU_SL2C_REG_DEC_BIT                 0x10
    #define        MEMMAP_CPU_PMR_REG_BASE                     0xF7AD0000
    #define        MEMMAP_CPU_PMR_REG_SIZE                     0x10000
    #define        MEMMAP_CPU_PMR_REG_DEC_BIT                  0x10
    #define        MEMMAP_VIP_DHUB_REG_BASE                    0xF7AE0000
    #define        MEMMAP_VIP_DHUB_REG_SIZE                    0x20000
    #define        MEMMAP_VIP_DHUB_REG_DEC_BIT                 0x11
    #define        MEMMAP_CORESIGHT_REG_BASE                   0xF7B00000
    #define        MEMMAP_CORESIGHT_REG_SIZE                   0x40000
    #define        MEMMAP_CORESIGHT_REG_DEC_BIT                0x12
    #define        MEMMAP_MTEST_REG_BASE                       0xF7B40000
    #define        MEMMAP_MTEST_REG_SIZE                       0x10000
    #define        MEMMAP_MTEST_REG_DEC_BIT                    0x10
    #define        MEMMAP_AVIO_BCM_REG_BASE                    0xF7B50000
    #define        MEMMAP_AVIO_BCM_REG_SIZE                    0x10000
    #define        MEMMAP_AVIO_BCM_REG_DEC_BIT                 0x10
    #define        MEMMAP_GE_REG_BASE                          0xF7B60000
    #define        MEMMAP_GE_REG_SIZE                          0x10000
    #define        MEMMAP_GE_REG_DEC_BIT                       0x10
    #define        MEMMAP_PHYPERIF_REG_BASE                    0xF7B70000
    #define        MEMMAP_PHYPERIF_REG_SIZE                    0x10000
    #define        MEMMAP_PHYPERIF_REG_DEC_BIT                 0x10
    #define        MEMMAP_SDIO1_REG_BASE                       0xF7B80000
    #define        MEMMAP_SDIO1_REG_SIZE                       0x10000
    #define        MEMMAP_SDIO1_REG_DEC_BIT                    0x10
    #define        MEMMAP_ETHERNET1_REG_BASE                   0xF7B90000
    #define        MEMMAP_ETHERNET1_REG_SIZE                   0x10000
    #define        MEMMAP_ETHERNET1_REG_DEC_BIT                0x10
    #define        MEMMAP_PTP1_REG_BASE                        0xF7BA0000
    #define        MEMMAP_PTP1_REG_SIZE                        0x10000
    #define        MEMMAP_PTP1_REG_DEC_BIT                     0x10
    #define        MEMMAP_AVIO_DH3_DHUB_REG_BASE               0xF7BB0000
    #define        MEMMAP_AVIO_DH3_DHUB_REG_SIZE               0x10000
    #define        MEMMAP_AVIO_DH3_DHUB_REG_DEC_BIT            0x10
    #define        MEMMAP_GFX3D_REG_BASE                       0xF7BC0000
    #define        MEMMAP_GFX3D_REG_SIZE                       0x40000
    #define        MEMMAP_GFX3D_REG_DEC_BIT                    0x12
    #define        MEMMAP_ZSP_REG_BASE                         0xF7C00000
    #define        MEMMAP_ZSP_REG_SIZE                         0x80000
    #define        MEMMAP_ZSP_REG_DEC_BIT                      0x13
    #define        MEMMAP_VPP_4K_REG_BASE                      0xF7C80000
    #define        MEMMAP_VPP_4K_REG_SIZE                      0x20000
    #define        MEMMAP_VPP_4K_REG_DEC_BIT                   0x11
    #define        MEMMAP_SOC_REG_BASE                         0xF7CA0000
    #define        MEMMAP_SOC_REG_SIZE                         0x10000
    #define        MEMMAP_SOC_REG_DEC_BIT                      0x10
    #define        MEMMAP_DDR_REG_BASE                         0xF7CB0000
    #define        MEMMAP_DDR_REG_SIZE                         0x10000
    #define        MEMMAP_DDR_REG_DEC_BIT                      0x10
    #define        MEMMAP_TSI_REG_BASE                         0xF7CC0000
    #define        MEMMAP_TSI_REG_SIZE                         0x40000
    #define        MEMMAP_TSI_REG_DEC_BIT                      0x12
    #define        MEMMAP_AG_DHUB_REG_BASE                     0xF7D00000
    #define        MEMMAP_AG_DHUB_REG_SIZE                     0x20000
    #define        MEMMAP_AG_DHUB_REG_DEC_BIT                  0x11
    #define        MEMMAP_APP_REG_BASE                         0xF7D30000
    #define        MEMMAP_APP_REG_SIZE                         0x10000
    #define        MEMMAP_APP_REG_DEC_BIT                      0x10
    #define        MEMMAP_SPU_REG_BASE                         0xF7D40000
    #define        MEMMAP_SPU_REG_SIZE                         0x10000
    #define        MEMMAP_SPU_REG_DEC_BIT                      0x10
    #define        MEMMAP_SDIO_REG_BASE                        0xF7D50000
    #define        MEMMAP_SDIO_REG_SIZE                        0x10000
    #define        MEMMAP_SDIO_REG_DEC_BIT                     0x10
    #define        MEMMAP_PTP_REG_BASE                         0xF7D60000
    #define        MEMMAP_PTP_REG_SIZE                         0x10000
    #define        MEMMAP_PTP_REG_DEC_BIT                      0x10
    #define        MEMMAP_PB_REG_BASE                          0xF7D70000
    #define        MEMMAP_PB_REG_SIZE                          0x10000
    #define        MEMMAP_PB_REG_DEC_BIT                       0x10
    #define        MEMMAP_SX_REG_BASE                          0xF7D80000
    #define        MEMMAP_SX_REG_SIZE                          0x10000
    #define        MEMMAP_SX_REG_DEC_BIT                       0x10
    #define        MEMMAP_MX_REG_BASE                          0xF7D90000
    #define        MEMMAP_MX_REG_SIZE                          0x10000
    #define        MEMMAP_MX_REG_DEC_BIT                       0x10
    #define        MEMMAP_NX_REG_BASE                          0xF7DA0000
    #define        MEMMAP_NX_REG_SIZE                          0x10000
    #define        MEMMAP_NX_REG_DEC_BIT                       0x10
    #define        MEMMAP_VOP_PG_REG_BASE                      0xF7DB0000
    #define        MEMMAP_VOP_PG_REG_SIZE                      0x10000
    #define        MEMMAP_VOP_PG_REG_DEC_BIT                   0x10
    #define        MEMMAP_CMD_PACK_REG_BASE                    0xF7DC0000
    #define        MEMMAP_CMD_PACK_REG_SIZE                    0x10000
    #define        MEMMAP_CMD_PACK_REG_DEC_BIT                 0x10
    #define        MEMMAP_CPUSS_REG_BASE                       0xF7DD0000
    #define        MEMMAP_CPUSS_REG_SIZE                       0x10000
    #define        MEMMAP_CPUSS_REG_DEC_BIT                    0x10
    #define        MEMMAP_VOP_VIDEO_REG_BASE                   0xF7DE0000
    #define        MEMMAP_VOP_VIDEO_REG_SIZE                   0x10000
    #define        MEMMAP_VOP_VIDEO_REG_DEC_BIT                0x10
    #define        MEMMAP_VOP_PIP_REG_BASE                     0xF7DF0000
    #define        MEMMAP_VOP_PIP_REG_SIZE                     0x10000
    #define        MEMMAP_VOP_PIP_REG_DEC_BIT                  0x10
    #define        MEMMAP_VOP_OSD_REG_BASE                     0xF7E00000
    #define        MEMMAP_VOP_OSD_REG_SIZE                     0x10000
    #define        MEMMAP_VOP_OSD_REG_DEC_BIT                  0x10
    #define        MEMMAP_AVIO_RESR2_BASE                      0xF7E10000
    #define        MEMMAP_AVIO_RESR2_SIZE                      0x10000
    #define        MEMMAP_AVIO_RESR2_DEC_BIT                   0x10
    #define        MEMMAP_AVIO_GBL_BASE                        0xF7E20000
    #define        MEMMAP_AVIO_GBL_SIZE                        0x10000
    #define        MEMMAP_AVIO_GBL_DEC_BIT                     0x10
    #define        MEMMAP_PCI_REG_BASE                         0xF7E30000
    #define        MEMMAP_PCI_REG_SIZE                         0x10000
    #define        MEMMAP_PCI_REG_DEC_BIT                      0x10
    #define        MEMMAP_PCIE_REG_BASE                        0xF7E40000
    #define        MEMMAP_PCIE_REG_SIZE                        0x10000
    #define        MEMMAP_PCIE_REG_DEC_BIT                     0x10
    #define        MEMMAP_ETHERNET_REG_BASE                    0xF7E50000
    #define        MEMMAP_ETHERNET_REG_SIZE                    0x10000
    #define        MEMMAP_ETHERNET_REG_DEC_BIT                 0x10
    #define        MEMMAP_SPDIF_REG_BASE                       0xF7E60000
    #define        MEMMAP_SPDIF_REG_SIZE                       0x10000
    #define        MEMMAP_SPDIF_REG_DEC_BIT                    0x10
    #define        MEMMAP_I2S_REG_BASE                         0xF7E70000
    #define        MEMMAP_I2S_REG_SIZE                         0x10000
    #define        MEMMAP_I2S_REG_DEC_BIT                      0x10
    #define        MEMMAP_APBPERIF_REG_BASE                    0xF7E80000
    #define        MEMMAP_APBPERIF_REG_SIZE                    0x10000
    #define        MEMMAP_APBPERIF_REG_DEC_BIT                 0x10
    #define        MEMMAP_SATA_REG_BASE                        0xF7E90000
    #define        MEMMAP_SATA_REG_SIZE                        0x10000
    #define        MEMMAP_SATA_REG_DEC_BIT                     0x10
    #define        MEMMAP_CHIP_CTRL_REG_BASE                   0xF7EA0000
    #define        MEMMAP_CHIP_CTRL_REG_SIZE                   0x10000
    #define        MEMMAP_CHIP_CTRL_REG_DEC_BIT                0x10
    #define        MEMMAP_MPP_REG_BASE                         0xF7EB0000
    #define        MEMMAP_MPP_REG_SIZE                         0x10000
    #define        MEMMAP_MPP_REG_DEC_BIT                      0x10
    #define        MEMMAP_AVIO_SEMAPHORE_REG_BASE              0xF7EC0000
    #define        MEMMAP_AVIO_SEMAPHORE_REG_SIZE              0x10000
    #define        MEMMAP_AVIO_SEMAPHORE_DEC_BIT               0x10
    #define        MEMMAP_USB0_REG_BASE                        0xF7ED0000
    #define        MEMMAP_USB0_REG_SIZE                        0x10000
    #define        MEMMAP_USB0_REG_DEC_BIT                     0x10
    #define        MEMMAP_USB1_REG_BASE                        0xF7EE0000
    #define        MEMMAP_USB1_REG_SIZE                        0x10000
    #define        MEMMAP_USB1_REG_DEC_BIT                     0x10
    #define        MEMMAP_GFX2D_REG_BASE                       0xF7EF0000
    #define        MEMMAP_GFX2D_REG_SIZE                       0x10000
    #define        MEMMAP_GFX2D_REG_DEC_BIT                    0x10
    #define        MEMMAP_NAND_FLASH_REG_BASE                  0xF7F00000
    #define        MEMMAP_NAND_FLASH_REG_SIZE                  0x10000
    #define        MEMMAP_NAND_FLASH_DEC_BIT                   0x10
    #define        MEMMAP_LBC_REG_BASE                         0xF7F10000
    #define        MEMMAP_LBC_REG_SIZE                         0x10000
    #define        MEMMAP_LBC_REG_DEC_BIT                      0x10
    #define        MEMMAP_PWM_REG_BASE                         0xF7F20000
    #define        MEMMAP_PWM_REG_SIZE                         0x10000
    #define        MEMMAP_PWM_REG_DEC_BIT                      0x10
    #define        MEMMAP_VPP_REG_BASE                         0xF7F60000
    #define        MEMMAP_VPP_REG_SIZE                         0x20000
    #define        MEMMAP_VPP_REG_DEC_BIT                      0x11
    #define        MEMMAP_DMA_AVIO_REG_BASE                    0xF7F40000
    #define        MEMMAP_DMA_AVIO_REG_SIZE                    0x10000
    #define        MEMMAP_DMA_AVIO_REG_DEC_BIT                 0x10
    #define        MEMMAP_VPP_DHUB_REG_BASE                    0xF7F40000
    #define        MEMMAP_VPP_DHUB_REG_SIZE                    0x20000
    #define        MEMMAP_VPP_DHUB_REG_DEC_BIT                 0x11
    #define        MEMMAP_SM_REG_BASE                          0xF7F80000
    #define        MEMMAP_SM_REG_SIZE                          0x80000
    #define        MEMMAP_SM_REG_DEC_BIT                       0x13
    #define        MEMMAP_FAST_REG_BASE                        0xF8000000
    #define        MEMMAP_VPRO_REG_BASE                        0xF8000000
    #define        MEMMAP_VPRO_REG_SIZE                        0x400000
    #define        MEMMAP_VPRO_REG_DEC_BIT                     0x16
    #define        MEMMAP_UFAHB_REG_BASE                       0xF8400000
    #define        MEMMAP_UFAHB_REG_SIZE                       0x20000
    #define        MEMMAP_UFAHB_REG_DEC_BIT                    0x11
    #define        MEMMAP_PIC_REG_BASE                         0xF8420000
    #define        MEMMAP_PIC_REG_SIZE                         0x10000
    #define        MEMMAP_PIC_REG_DEC_BIT                      0x10
    #define        MEMMAP_PROCESSOR_ID_REG_BASE                0xF8430000
    #define        MEMMAP_PROCESSOR_ID_REG_SIZE                0x20
    #define        MEMMAP_PROCESSOR_ID_REG_DEC_BIT             0x5
    #define        MEMMAP_ONCHIP_LOW_ROM_BASE                  0xFF800000
    #define        MEMMAP_ONCHIP_LOW_ROM_SIZE                  0x10000
    #define        MEMMAP_ONCHIP_LOW_ROM_DEC_BIT               0x10
    #define        MEMMAP_HIGH_ROM_VECTOR_BASE                 0xFFFF0000
    #define        MEMMAP_HIGH_ROM_VECTOR_SIZE                 0x10000
    #define        MEMMAP_HIGH_ROM_VECTOR_DEC_BIT              0x10
    #define        MEMMAP_VECTOR_BASE                          0xFFFF0000
    #define        MEMMAP_VECTOR_SIZE                          0x20
    #define        MEMMAP_VECTOR_DEC_BIT                       0x5
    #define        MEMMAP_HIGH_EXCEPT_RESET_REG                0xFFFF0000
    #define        MEMMAP_HIGH_EXCEPT_UNDEF_REG                0xFFFF0004
    #define        MEMMAP_HIGH_EXCEPT_SOFT_REG                 0xFFFF0008
    #define        MEMMAP_HIGH_EXCEPT_PREFETCH_REG             0xFFFF000C
    #define        MEMMAP_HIGH_EXCEPT_DATA_REG                 0xFFFF0010
    #define        MEMMAP_HIGH_EXCEPT_UNUSED_REG               0xFFFF0014
    #define        MEMMAP_HIGH_EXCEPT_IRQ_REG                  0xFFFF0018
    #define        MEMMAP_HIGH_EXCEPT_FIQ_REG                  0xFFFF001C
    #define        MEMMAP_ADDR_DATA_REG_BASE                   0xFFFF0020
    #define        MEMMAP_ADDR_DATA_REG_SIZE                   0x80
    #define        MEMMAP_VECTOR_ADDR_0_REG                    0xFFFF0020
    #define        MEMMAP_VECTOR_ADDR_1_REG                    0xFFFF0024
    #define        MEMMAP_VECTOR_ADDR_2_REG                    0xFFFF0028
    #define        MEMMAP_VECTOR_ADDR_3_REG                    0xFFFF002C
    #define        MEMMAP_VECTOR_ADDR_4_REG                    0xFFFF0030
    #define        MEMMAP_VECTOR_ADDR_5_REG                    0xFFFF0034
    #define        MEMMAP_VECTOR_ADDR_6_REG                    0xFFFF0038
    #define        MEMMAP_VECTOR_ADDR_7_REG                    0xFFFF003C
    #define        MEMMAP_BRCH_ADDR_1_0_REG                    0xFFFF0040
    #define        MEMMAP_BRCH_ADDR_1_1_REG                    0xFFFF0044
    #define        MEMMAP_BRCH_ADDR_1_2_REG                    0xFFFF0048
    #define        MEMMAP_BRCH_ADDR_2_0_REG                    0xFFFF004C
    #define        MEMMAP_BRCH_ADDR_2_1_REG                    0xFFFF0050
    #define        MEMMAP_BRCH_ADDR_2_2_REG                    0xFFFF0054
    #define        MEMMAP_BRCH_ADDR_3_0_REG                    0xFFFF0058
    #define        MEMMAP_BRCH_ADDR_3_1_REG                    0xFFFF005C
    #define        MEMMAP_BRCH_ADDR_3_2_REG                    0xFFFF0060
    #define        MEMMAP_BRCH_ADDR_4_0_REG                    0xFFFF0064
    #define        MEMMAP_BRCH_ADDR_4_1_REG                    0xFFFF0068
    #define        MEMMAP_BRCH_ADDR_4_2_REG                    0xFFFF006C
    #define        MEMMAP_BRCH_ADDR_5_0_REG                    0xFFFF0070
    #define        MEMMAP_BRCH_ADDR_5_1_REG                    0xFFFF0074
    #define        MEMMAP_BRCH_ADDR_5_2_REG                    0xFFFF0078
    #define        MEMMAP_BRCH_ADDR_6_0_REG                    0xFFFF007C
    #define        MEMMAP_BRCH_ADDR_6_1_REG                    0xFFFF0080
    #define        MEMMAP_BRCH_ADDR_6_2_REG                    0xFFFF0084
    #define        MEMMAP_BRCH_ADDR_7_0_REG                    0xFFFF0088
    #define        MEMMAP_BRCH_ADDR_7_1_REG                    0xFFFF008C
    #define        MEMMAP_BRCH_ADDR_7_2_REG                    0xFFFF0090
    #define        MEMMAP_SOFTWARE_RESET_ADDR_REG              0xFFFF0094
    #define        MEMMAP_ONCHIP_HIGH_ROM_BASE                 0xFFFFC000
    #define        MEMMAP_ONCHIP_HIGH_ROM_SIZE                 0x4000
    #define        MEMMAP_ONCHIP_HIGH_ROM_DEC_BIT              0xE
    ///////////////////////////////////////////////////////////
    #define     RA_MEMMAP_memmap                               0x0000

    #define     BA_MEMMAP_memmap_dummy                         0x0000
    #define     B16MEMMAP_memmap_dummy                         0x0000
    #define   LSb32MEMMAP_memmap_dummy                            0
    #define   LSb16MEMMAP_memmap_dummy                            0
    #define       bMEMMAP_memmap_dummy                         32
    #define   MSK32MEMMAP_memmap_dummy                            0xFFFFFFFF
    ///////////////////////////////////////////////////////////

    typedef struct SIE_MEMMAP {
    ///////////////////////////////////////////////////////////
    #define   GET32MEMMAP_memmap_dummy(r32)                    _BFGET_(r32,31, 0)
    #define   SET32MEMMAP_memmap_dummy(r32,v)                  _BFSET_(r32,31, 0,v)

    #define     w32MEMMAP_memmap                               {\
            UNSG32 smemmap_dummy                               : 32;\
          }
    union { UNSG32 u32MEMMAP_memmap;
            struct w32MEMMAP_memmap;
          };
    ///////////////////////////////////////////////////////////
    } SIE_MEMMAP;

    typedef union  T32MEMMAP_memmap
          { UNSG32 u32;
            struct w32MEMMAP_memmap;
                 } T32MEMMAP_memmap;
    ///////////////////////////////////////////////////////////

    typedef union  TMEMMAP_memmap
          { UNSG32 u32[1];
            struct {
            struct w32MEMMAP_memmap;
                   };
                 } TMEMMAP_memmap;

    ///////////////////////////////////////////////////////////
     SIGN32 MEMMAP_drvrd(SIE_MEMMAP *p, UNSG32 base, SIGN32 mem, SIGN32 tst);
     SIGN32 MEMMAP_drvwr(SIE_MEMMAP *p, UNSG32 base, SIGN32 mem, SIGN32 tst, UNSG32 *pcmd);
       void MEMMAP_reset(SIE_MEMMAP *p);
     SIGN32 MEMMAP_cmp  (SIE_MEMMAP *p, SIE_MEMMAP *pie, char *pfx, void *hLOG, SIGN32 mem, SIGN32 tst);
    #define MEMMAP_check(p,pie,pfx,hLOG) MEMMAP_cmp(p,pie,pfx,(void*)(hLOG),0,0)
    #define MEMMAP_print(p,    pfx,hLOG) MEMMAP_cmp(p,0,  pfx,(void*)(hLOG),0,0)

#endif
//////
/// ENDOFINTERFACE: MEMMAP
////////////////////////////////////////////////////////////



#ifdef __cplusplus
  }
#endif
#pragma  pack()

#endif
//////
/// ENDOFFILE: Galois_memmap.h
////////////////////////////////////////////////////////////

