﻿/* SCE CONFIDENTIAL
 * $PSLibId$
 * Copyright (C) 2011 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef _SCE_API_LIBGXM_COMMON_H
#define _SCE_API_LIBGXM_COMMON_H

#include <gxm.h>
#include <kernel.h>
#include "heap.h"

// Heap types
enum HeapType {
	HEAP_TYPE_LPDDR_R,
	HEAP_TYPE_LPDDR_RW,
	HEAP_TYPE_CDRAM_RW,
	HEAP_TYPE_VERTEX_USSE,
	HEAP_TYPE_FRAGMENT_USSE
};

// Heap sizes
#define HEAP_SIZE_LPDDR_R			(64*1024*1024)
#define HEAP_SIZE_LPDDR_RW			(32*1024*1024)
#define HEAP_SIZE_CDRAM_RW			(32*1024*1024)
#define HEAP_SIZE_VERTEX_USSE		(8*1024*1024)
#define HEAP_SIZE_FRAGMENT_USSE		(8*1024*1024)

// Display dimensions
#define DISPLAY_WIDTH				960
#define DISPLAY_HEIGHT				544
#define DISPLAY_STRIDE_IN_PIXELS	1024

#define DISPLAY_COLOR_FORMAT		SCE_GXM_COLOR_FORMAT_A8B8G8R8
#define DISPLAY_PIXEL_FORMAT		SCE_DISPLAY_PIXELFORMAT_A8B8G8R8
#define DISPLAY_DBGFONT_FORMAT		SCE_DBGFONT_PIXELFORMAT_A8B8G8R8
#define DISPLAY_BUFFER_COUNT		3
#define DISPLAY_MAX_PENDING_SWAPS	2

// Supported flip modes
enum FlipMode {
	FLIP_MODE_HSYNC,	///< Flip on next HSYNC
	FLIP_MODE_VSYNC,	///< Flip on next VSYNC
	FLIP_MODE_VSYNC_2	///< Flip on next VSYNC, display for 2 VSYNCs minimum
};

// Graphics parameters
#define MSAA_MODE					SCE_GXM_MULTISAMPLE_NONE

// Debug Font.
// You cannot use the debugger of Visual Studio when .self link the libSceDbgFont.a
//#define DISABLE_DEBUG_FONT

// Mark variable as used
#define	UNUSED(a)					(void)(a)

// Align value
#define ALIGN(x, a)					(((x) + ((a) - 1)) & ~((a) - 1))

// Get maximum value
#define MAX(a, b)					(((a) > (b)) ? (a) : (b))

// libgxm context
extern SceGxmContext				*g_context;

// libgxm shader patcher
extern SceGxmShaderPatcher			*g_shaderPatcher;

// libgxm display queue
extern void							*g_displayBufferData[DISPLAY_BUFFER_COUNT];
extern SceUID						g_displayBufferUid[DISPLAY_BUFFER_COUNT];
extern SceGxmColorSurface			g_displaySurface[DISPLAY_BUFFER_COUNT];
extern SceGxmSyncObject				*g_displayBufferSync[DISPLAY_BUFFER_COUNT];
extern uint32_t						g_displayFrontBufferIndex;
extern uint32_t						g_displayBackBufferIndex;

// Depth buffer for display surface
extern void							*g_mainDepthBufferData;
extern SceUID						g_mainDepthBufferUid;
extern SceGxmDepthStencilSurface	g_mainDepthSurface;

// libgxm main render target
extern SceGxmRenderTarget			*g_mainRenderTarget;

// Expected to be provided by sample
int renderDbgFont(void);

// Initialize libdbgfont
int initDbgFont(void);

// Terminate libdbgfont
int termDbgFont(void);

// Initialize libgxm
int initGxm(void);

// Terminate libgxm
int termGxm(void);

// Cycles display buffers in the display queue
int cycleDisplayBuffers(
	FlipMode flipMode = FLIP_MODE_VSYNC,
	uint32_t width = DISPLAY_WIDTH,
	uint32_t height = DISPLAY_HEIGHT,
	uint32_t strideInPixels = DISPLAY_STRIDE_IN_PIXELS);

// Helper function to create a render target
SceGxmRenderTarget *createRenderTarget(uint32_t width, uint32_t height, SceGxmMultisampleMode msaaMode);

// Helper function to destroy a render target
void destroyRenderTarget(SceGxmRenderTarget *renderTarget);

#endif /* _SCE_API_LIBGXM_COMMON_H */

