/*
    Copyright (C) 2011 Nokia Corporation and/or its subsidiary(-ies)
    Copyright (C) 2013 Company 100, Inc.
    Copyright (C) 2014 Sony Computer Entertainment Inc.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef CoordinatedLayerTreeHostProxyManx_h
#define CoordinatedLayerTreeHostProxyManx_h

#if USE(COORDINATED_GRAPHICS) && ENABLE(MANX_AC_PROCESS)

#include "CoordinatedGraphicsArgumentCoders.h"
#include "MessageReceiver.h"
#include "manx/CanvasBuffer.h"
#include <WebCore/CoordinatedGraphicsScene.h>
#include <WebCore/DisplayRefreshMonitor.h>
#include <WebCore/GLMemoryInfo.h>
#include <wtf/Functional.h>

namespace WebCore {
struct CoordinatedGraphicsState;
class IntSize;
}

namespace WebKit {

class CoordinatedLayerTreeHostProxyManx : public WebCore::CoordinatedGraphicsSceneClient, public CoreIPC::MessageReceiver {
    WTF_MAKE_NONCOPYABLE(CoordinatedLayerTreeHostProxyManx);
    WTF_MAKE_FAST_ALLOCATED;
    friend class LayerFlushScheduler;
public:
    explicit CoordinatedLayerTreeHostProxyManx(uint64_t pageID);
    virtual ~CoordinatedLayerTreeHostProxyManx();

    void commitCoordinatedGraphicsState(const WebCore::CoordinatedGraphicsState&);
    void setBackgroundColor(const WebCore::Color&);

    void sizeDidChange(const WebCore::IntSize&); // FIXME: This is not necessary for ideal UI side compositing.

    void setVisible(bool);
    bool isVisible() const { return m_isVisible; }

    void setActive(bool);
    bool isActive() const { return m_isActive; }

    void setVisibleContentsRect(const WebCore::FloatRect&, const WebCore::FloatPoint& trajectoryVector);
    WebCore::CoordinatedGraphicsScene* coordinatedGraphicsScene() const { return m_scene.get(); }

    virtual void updateViewport() OVERRIDE;
    virtual void renderNextFrame() OVERRIDE;
    virtual void purgeBackingStores() OVERRIDE;

    virtual void commitScrollOffset(uint32_t layerID, const WebCore::IntSize& offset);

    uint64_t pageID() const { return m_pageID; }

protected:
    void dispatchUpdate(const Function<void()>&);

    // CoreIPC::MessageReceiver
    virtual void didReceiveMessage(CoreIPC::Connection*, CoreIPC::MessageDecoder&) OVERRIDE;

    // DisplayRefreshMonitorClient
    virtual void displayRefreshFired(double timestamp);

    void ensureCanvasBuffer(const WebCore::IntSize& canvasSize);
    void scheduleLayerFlush();
    void cancelPendingLayerFlush();
    void doLayerFlush();

    void invalidateCanvas();
    void updateCanvasHandle();

    uint64_t m_pageID;
    RefPtr<WebCore::CoordinatedGraphicsScene> m_scene;
    WebCore::FloatRect m_lastSentVisibleRect;
    WebCore::FloatPoint m_lastSentTrajectoryVector;

    sce::Canvas::Id m_canvasID;
    sce::Canvas::Handle m_canvasHandle;
    CanvasBuffer* m_canvasBuffer;
    WebCore::IntSize m_viewSize;
    WebCore::Color m_backgroundColor;

    WebCore::GLMemoryInfo m_glMemoryInfo;
    bool m_isVisible;
    bool m_isActive;
};

} // namespace WebKit

#endif // USE(COORDINATED_GRAPHICS) && ENABLE(MANX_AC_PROCESS)

#endif // CoordinatedLayerTreeHostProxyManx_h
