/*
 * Copyright (C) 2014 Sony Computer Entertainment Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#include "ACProcess.h"

#if ENABLE(MANX_AC_PROCESS)

#include "ACProcessMessages.h"
#include "ACProcessProxyMessages.h"
#include "CoordinatedLayerTreeHostProxyManx.h"
#include "CoordinatedLayerTreeHostProxyMessages.h"
#include "NotImplemented.h"
#include "WKBase.h"
#include <WebCore/RunLoop.h>
#include <wtf/MainThread.h>
#include <wtf/OwnPtr.h>

using namespace WebCore;

namespace WebKit {

// WebProcess -> ACProcess
void ACProcess::initializeACProcess(const ACProcessCreationParameters& parameters)
{
    if (parameters.userID > 0) {
        char webkitUserID[16];
        snprintf(webkitUserID, sizeof(webkitUserID), "%d", parameters.userID);
        setenv("WEBKIT_USER_ID", webkitUserID, 1);
    }
}

void ACProcess::createLayerTreeHostProxy(uint64_t pageID)
{
    if (!m_layerTreeHostProxyMap.contains(pageID))
        m_layerTreeHostProxyMap.add(pageID, adoptPtr(new LayerTreeHostProxy(pageID)));
}

void ACProcess::removeLayerTreeHostProxy(uint64_t pageID)
{
    m_layerTreeHostProxyMap.remove(pageID);
}

// 
ACProcess& ACProcess::shared()
{
    static ACProcess& process = *new ACProcess;
    return process;
}

ACProcess::ACProcess()
{
    notImplemented();
}

ACProcess::~ACProcess()
{
    notImplemented();
}

// ChildProcess
void ACProcess::initializeProcess(const ChildProcessInitializationParameters&)
{
    notImplemented();
}

void ACProcess::initializeProcessName(const ChildProcessInitializationParameters&)
{
    notImplemented();
}

void ACProcess::initializeSandbox(const ChildProcessInitializationParameters&, SandboxInitializationParameters&)
{
    notImplemented();
}

void ACProcess::initializeConnection(CoreIPC::Connection* connection)
{
    ChildProcess::initializeConnection(connection);

    connection->setShouldExitOnSyncMessageSendFailure(true);
}

bool ACProcess::shouldTerminate()
{
    notImplemented();
    return false;
}

void ACProcess::terminate()
{
    notImplemented();
}

// CoreIPC::Connection::Client
void ACProcess::didReceiveMessage(CoreIPC::Connection* connection, CoreIPC::MessageDecoder& decoder)
{
    if (messageReceiverMap().dispatchMessage(connection, decoder))
        return;

    if (decoder.messageReceiverName() == Messages::ACProcess::messageReceiverName()) {
        didReceiveACProcessMessage(connection, decoder);
        return;
    }
}

void ACProcess::didReceiveSyncMessage(CoreIPC::Connection*, CoreIPC::MessageDecoder&, OwnPtr<CoreIPC::MessageEncoder>&)
{
    notImplemented();
}

void ACProcess::didClose(CoreIPC::Connection*)
{
    RunLoop::main()->stop();
}

void ACProcess::didReceiveInvalidMessage(CoreIPC::Connection*, CoreIPC::StringReference messageReceiverName, CoreIPC::StringReference messageName)
{
    notImplemented();
}

// ProcessMain
WK_EXPORT extern "C" int ACProcessMain(int argc, char* argv[])
{
    ASSERT(argc == 2);

    WTF::initializeThreading();
    WTF::initializeMainThread();

    RunLoop::initializeMainRunLoop();
    int socket = atoi(argv[1]);

    ChildProcessInitializationParameters parameters;
    parameters.connectionIdentifier = socket;

    ACProcess::shared().initialize(parameters);

    RunLoop::run();

    return 0;
}

}

#endif
